ITK 5.1.0 Release
=

We are happy to announce the [Insight Toolkit (ITK)](https://itk.org) 5.1.0 release! :tada: ITK is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration.

ITK 5.1.0 is a feature release that improves and extends the major ITK 5.0 release. ITK 5.1.0 includes a [NumPy](https://numpy.org) and [Xarray](https://xarray.pydata.org) filter interface, clang-format enforced coding style, enhanced modern C++ range support, strongly-typed enum's, and much more.

A number of issues were addressed based on feedback from Release Candidate 3. Filters avoid extra copies when operating on NumPy arrays, and `itk.Image` is now a NumPy array-like. Remote module CI testing infrastructure has been migrated to GitHub Actions for C++ tests, Python package builds, and automated Python package deployment.


Downloads
---------

**Python Packages**

Install [ITK Python packages](https://itkpythonpackage.readthedocs.io/en/latest/Quick_start_guide.html) with:

```
pip install --upgrade itk
```

or:

```
conda -c conda-forge install itk
```

**Guide and Textbook**

- [InsightSoftwareGuide-Book1-5.1.0.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.1.0/InsightSoftwareGuide-Book1-5.1.0.pdf)
- [InsightSoftwareGuide-Book2-5.1.0.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.1.0/InsightSoftwareGuide-Book2-5.1.0.pdf)

**Library Sources**

- [InsightToolkit-5.1.0.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.1.0/InsightToolkit-5.1.0.tar.gz)
- [InsightToolkit-5.1.0.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.1.0/InsightToolkit-5.1.0.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.1.0.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.1.0/InsightData-5.1.0.tar.gz)
- [InsightData-5.1.0.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.1.0/InsightData-5.1.0.zip)

**Checksums**

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.1.0/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.1.0/SHA512SUMS)



Features
--------

![ITKParabolicMorphology](https://imgur.com/MowNzqL.png)


Parabolic morphological filtering with the [ITKParabolicMorphology](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology) remote module. To install the new Python package: `pip install itk-parabolicmorphology`. Jupyter notebooks are provided as [examples](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology/tree/master/examples). For more information, see the [Insight Journal article](https://www.insight-journal.org/browse/publication/228), *Beare R. Morphology with parabolic structuring elements. The Insight Journal. January-June. 2008. https://www.insight-journal.org/browse/publication/228*.

### GitHub Actions for ITK Remote Module Testing, Packaging, PyPI Deployment

A [GitHub Action configuration](https://gist.github.com/thewtex/aab3f401b27dfd262e508cf1019853f0) is available for ITK Remote Module continuous integration (CI) testing and Python packaging on Linux, macOS, and Windows. Continuous deployment (CD) is configured to upload packages to the [Python Package Index (PyPI)](https://pypi.org) when the repository is tagged. More information can be found in the [ITK Python Package ReadTheDocs](https://itkpythonpackage.readthedocs.io/en/master/Build_ITK_Module_Python_packages.html#github-automated-ci-package-builds) documentation.

### Pass NumPy Array's or Xarray DataArray's to ITK Image Filters


The [Pythonic, functional-like interface](https://discourse.itk.org/t/itk-5-0-beta-1-pythonic-interface/1271) to all ITK image-to-image-filters now directly supports operation on [NumPy ndarray's](https://docs.scipy.org/doc/numpy/reference/generated/numpy.ndarray.html), i.e. `numpy.ndarray`. If a `ndarray` is passed as an input, a `ndarray` is returned as an output.

For example,

```
smoothed = itk.median_image_filter(array, radius=2)
```

Previously, explicit conversion to / from an `itk.Image` was required with `itk.array_from_image` and `itk.image_from_array`.

We can now also convert an `itk.Image` to a `numpy.ndarray` with the standard `np.asarray` call.

```
import numpy as np
import itk

image = itk.imread('/path/to/image.tif')
array = np.asarray(image)
```

An `itk.Image` is now more NumPy array-like: `shape`, `ndim`, and `dtype` attributes are available; these correspond to the values when converted to a NumPy `ndarray`. Basic NumPy functions can be called directly on an `itk.Image`, i.e.,

```
min = np.min(image)
max = np.max(image)
mean = np.mean(image)
```

Similar, experimental support (subject to change) is also available for [Xarray DataArray's](https://xarray.pydata.org/en/stable/generated/xarray.DataArray.html). If an `xarray.DataArray` is passed as an input, an `xarray.DataArray` is returned as an output. Moreover, the operation preserves spatial and dimensional metadata. For example,

```
import xarray as xr
import itk

image = itk.imread('/path/to/image.tif')
da = itk.xarray_from_image(image)
smoothed = itk.median_image_filter(da, radius=3)
print(smoothed)
```

results in:

```
<xarray.DataArray (y: 288, x: 894)>
array([[255.    , 255.    , 255.    , ..., 255.    , 255.    , 255.    ],
       [ 11.9995,  11.9995,  11.9995, ...,  11.9995,  11.9995,  11.9995],
       [ 11.9995,  11.9995,  11.9995, ...,  11.9995,  11.9995,  11.9995],
       ...,
       [ 11.9995,  11.9995,  11.9995, ...,  11.9995,  11.9995,  11.9995],
       [ 11.9995,  11.9995,  11.9995, ...,  11.9995,  11.9995,  11.9995],
       [ 11.9995,  11.9995,  11.9995, ...,  11.9995,  11.9995,  11.9995]],
      dtype=float32)
Coordinates:
  * x        (x) float64 0.0 1.0 2.0 3.0 4.0 ... 889.0 890.0 891.0 892.0 893.0
  * y        (y) float64 0.0 1.0 2.0 3.0 4.0 ... 283.0 284.0 285.0 286.0 287.0
Attributes:
    direction:  [[1. 0.]\n [0. 1.]]

```

A round trip is possible with `itk.image_from_xarray`.

### Python 3 Only

ITK 5.1 will be the first Python 3-only release. Consistent with most scientific Python packages and [CPython's 2020 drop in support](https://pythonclock.org), Python 2 support and binaries are no longer available.

### Python Package 64-bit Float Support

In addition to the many other pixel types supported, the `itk` binary Python packages now include support for the `double` pixel type, i.e. 64-bit IEEE floating-point pixels. This improves compatibility with [scikit-image](https://scikit-image.org/), which uses this pixel type as a default.

### clang-format Enforced C++ Coding Style

ITK has adopted a [*.clang-format*](https://github.com/InsightSoftwareConsortium/ITK/blob/master/.clang-format) coding style configuration file so a consistent coding style can automatically be applied to C++ code with the [`clang-format`](https://releases.llvm.org/download.html) binary. A consistent coding style is critical for readability and collaborative development.

`clang-format` has been applied to the entire codebase. The Whitesmiths style of brace indentation, previously part of the [ITK Coding Style Guidelines](https://itk.org/ItkSoftwareGuide.pdf), is not supported by clang-format, so it has been replaced by a brace style consistent with VTK's current style.

A Git commit hook will automatically apply `clang-format` to changed C++ code.

### Enhanced Modern C++ Range Support

In addition to the [`ImageBufferRange`](https://docs.itk.org/projects/doxygen/en/stable/classitk_1_1Experimental_1_1ImageBufferRange.html), [`ShapedImageNeighborhoodRange`](https://docs.itk.org/projects/doxygen/en/stable/classitk_1_1Experimental_1_1ShapedImageNeighborhoodRange.html), and [`IndexRange`](https://docs.itk.org/projects/doxygen/en/stable/classitk_1_1Experimental_1_1IndexRange.html) classes introduced in ITK 5.0, ITK 5.1 adds an [`ImageRegionRange`](https://docs.itk.org/projects/doxygen/en/stable/classitk_1_1Experimental_1_1ImageRegionRange.html). These range classes conform to the Standard C++ Iterator requirements so they can be used in range-based for loop's and passed to Standard C++ algorithms. Range-based for loops provide an elegant syntax for iteration. Moreover, they are often more performant than other iteration classes available.

For example, to add 42 to every pixel:

```
ImageBufferRange<ImageType> range{ *image };

for (auto&& pixel : range)
{
  pixel = pixel + 42;
}
```

In ITK 5.1, adoption of the range classes was extended across the toolkit, which demonstrates their use and improves toolkit performance.

### Point Set Registration Parallelism

ITK provides a powerful registration framework for point-set registration, offering information-theoretic similarity metrics, labeled point-set metrics, and spatial transformation models that range from affine to b-spline to dense displacement fields. ITK 5.1 features enhanced parallelism in point-set metric computation, leveraging the [native thread-pool and Threading Building Blocks (TBB)](https://discourse.itk.org/t/itk-5-0-alpha-2-performance/959) enhancements in ITK 5.

### SpatialObject's and Strongly-Typed enum's

Improvements and refinements were made to the ITK 5 `itk::SpatialObject` refactoring, and modern C++ interface. In particular, ITK 5.1 transitions enumerations to [strongly-typed enumerations](https://www.modernescpp.com/index.php/strongly-typed-enums), which is flagged by modern compilers due to improved scoping and implicit conversions to `int`. Enum names now follow a consistent `<Description>Enum` naming conversion, which results in a Python interface:

```
<Description>Enum_<EnumValue1>
<Description>Enum_<EnumValue2>
[...]
```

A guide for updating to the new enum's can be found in the [Strongly Typed Enumerations](https://github.com/InsightSoftwareConsortium/ITK/blob/master/Documentation/ITK5MigrationGuide.md#strongly-typed-enumerations) section of the ITK 5 Migration Guide.

### DICOM Support

ITK's broadly adopted medical image support is hardened thanks to 20 years of testing and support from major open source DICOM library maintainers. In this release, many members of the community collaborated to further enhance ITK's DICOM support for corner cases related to modality, pixel types, and vendor variations.

### Remote Module Updates

New remote module: [TubeTK](https://github.com/InsightSoftwareConsortium/ITKTubeTK):  An open-source toolkit, led by Kitware, Inc., for the segmentation, registration, and analysis of tubes and surfaces in images.

A new [remote module grading system](https://discourse.itk.org/t/remote-module-grading-ranking-system-needed/2750) was added to help convey the quality compliance level for the 45 remote modules.

Many remote modules were updated: *AnalyzeObjectMapIO, AnisotropicDiffusionLBR, BSplineGradient, BioCell, BoneEnhancement, BoneMorphometry, Cuberille, FixedPointInverseDisplacementField, GenericLabelInterpolator, HigherOrderAccurateGradient, IOMeshSTL, IOOpenSlide, IOScanco, IOTransformDCMTK, IsotropicWavelets, LabelErodeDilate, LesionSizingToolkit, MinimalPathExtraction, Montage, MorphologicalContourInterpolation, ParabolicMorphology, PhaseSymmetry, RLEImage, RTK, SCIFIO, SimpleITKFilters, SkullStrip, SplitComponents, Strain, SubdivisionQuadEdgeMeshFilter, TextureFeatures, Thickness3D, TotalVariation,* and *TwoProjectionRegistration*.

### Zenodo Citation

ITK has a [Zenodo Citation](https://zenodo.org/badge/latestdoi/800928):

[![DOI](https://zenodo.org/badge/800928.svg)](https://zenodo.org/badge/latestdoi/800928)

This citation can be used to cite a specific version of the software. If you have contributed 10 or more patches to ITK, please add your [ORCID iD](https://orcid.org/) to our [.zenodo.json](https://github.com/InsightSoftwareConsortium/ITK/blob/master/.zenodo.json) file for authorship association.

### NumFOCUS Copyright Transfer

ITK's copyright and the copyright of software held by the [Insight Software Consortium](https://www.insightsoftwareconsortium.org/) have been transferred to [NumFOCUS](https://numfocus.org/). [CMake](https://cmake.org)'s copyright has been transferred to [Kitware](https://kitware.com).

### And More

Many more improvements have been made. For details, see the changelogs for the release candidates and changelog below.

### Congratulations

Congratulations and **thank you** to everyone who contributed to this release.

Of *73 authors* since v5.0.0, we would like to specially recognize the new contributors:

Mathew J. Seng, Zahil Shanis, yjcchen0913, PA Rodesch, Aurélien Coussat, yinkaola, Bryce Besler, Pierre Chatelier, Rinat Mukhometzianov, Ramraj Chandradevan, Hina Shah, Gordian Kabelitz, Genevieve Buckley, Aaron Bray, nslay, Antoine Robert, James Butler, Matthew Rocklin, Gina Helfrich, and Neslisah Torosdagli, Brad T. Moore, Niklas Johansson, Flavien Bridault, Pradeep Garigipati, haaput, tabish, and Antoine Robert, Ben Wilson, Adam Rankin, PA Rodesch, Tabish Syed, vlibertiaux, Michael Jackson, Conrad Poelman, and muschellij2.


**Enjoy ITK!**

ITK Changes Since v5.1rc03
---------------------------------------------

### Bradley Lowekamp (3):

#### Bug Fixes

-  Check if calculator is proper type ([3e7307744e](https://github.com/InsightSoftwareConsortium/ITK/commit/3e7307744e))
-  Use one calculator in ItermodesThresholder ([6dc4948017](https://github.com/InsightSoftwareConsortium/ITK/commit/6dc4948017))
-  Use GDCM as private dependency in ITKIOGDCM ([ca1913cee6](https://github.com/InsightSoftwareConsortium/ITK/commit/ca1913cee6))


### Conrad Poelman (1):

#### Platform Fixes

-  Remove deprecated/removed std ([7b2dfd28d4](https://github.com/InsightSoftwareConsortium/ITK/commit/7b2dfd28d4))


### Dženan Zukić (1):

#### Enhancements

-  add the .exe executable extension to clang-format on Windows ([343cbf9236](https://github.com/InsightSoftwareConsortium/ITK/commit/343cbf9236))


### GDCM Upstream (1):

#### Miscellaneous Changes

- efdd2cab95 ([efdd2cab95](https://github.com/InsightSoftwareConsortium/ITK/commit/efdd2cab95))


### Hans J. Johnson (16):

#### Enhancements

-  Remove use of deprecated, redundant interface ([51792db03b](https://github.com/InsightSoftwareConsortium/ITK/commit/51792db03b))
-  Prefer multiplication to division ([50b91ab2cc](https://github.com/InsightSoftwareConsortium/ITK/commit/50b91ab2cc))
-  Variable names updated to better indicate their pupopse ([5012b7e41f](https://github.com/InsightSoftwareConsortium/ITK/commit/5012b7e41f))
-  Provide new baseline for ImageRegisration4Test ([623bef5c10](https://github.com/InsightSoftwareConsortium/ITK/commit/623bef5c10))

#### Performance Improvements

-  Only compute log(fixedImageMarginalPDFValue once outside loop ([e7ef06e39a](https://github.com/InsightSoftwareConsortium/ITK/commit/e7ef06e39a))
-  Avoid processing entire rows based on mathematical certainties ([82730afa5c](https://github.com/InsightSoftwareConsortium/ITK/commit/82730afa5c))

#### Documentation Updates

-  Improve diagnostic message for exception ([bebe1d6f4a](https://github.com/InsightSoftwareConsortium/ITK/commit/bebe1d6f4a))
-  Fix missing \ingroup ITKIODCMTK ([d7f8c463dc](https://github.com/InsightSoftwareConsortium/ITK/commit/d7f8c463dc))
-  Fix typo in comment User -> Uses ([d87449620f](https://github.com/InsightSoftwareConsortium/ITK/commit/d87449620f))

#### Platform Fixes

-  Suppress compiler warning about value trucation ([9e137468bc](https://github.com/InsightSoftwareConsortium/ITK/commit/9e137468bc))
-  Unused variable warning ([c40a494c79](https://github.com/InsightSoftwareConsortium/ITK/commit/c40a494c79))

#### Bug Fixes

-  TBB build requires consistent exception options ([c4caa4cdbe](https://github.com/InsightSoftwareConsortium/ITK/commit/c4caa4cdbe))
-  Pointer to temporary variable needs resetting to null. ([b29dc9182e](https://github.com/InsightSoftwareConsortium/ITK/commit/b29dc9182e))

#### Style Changes

-  Reorder commands for locallity of reference ([8626163a48](https://github.com/InsightSoftwareConsortium/ITK/commit/8626163a48))
-  Make alias variables to assist with clear documentation ([56922b8d80](https://github.com/InsightSoftwareConsortium/ITK/commit/56922b8d80))
-  totalMassOfPDF == this->m_JointPDFSum by definition ([982cfaec51](https://github.com/InsightSoftwareConsortium/ITK/commit/982cfaec51))


### Jean-Christophe Fillion-Robin (1):

#### Platform Fixes

-  Fix -Wstrict-overflow warning in itkImageRegionConstIteratorWithIndex ([93be179376](https://github.com/InsightSoftwareConsortium/ITK/commit/93be179376))

### Jon Haitz Legarreta Gorroño (5):

#### Enhancements

-  Improve Thresholding module filters' coverage. ([e4507807e5](https://github.com/InsightSoftwareConsortium/ITK/commit/e4507807e5))
-  Change ivar name in `itk ([e864411be3](https://github.com/InsightSoftwareConsortium/ITK/commit/e864411be3))
-  Avoid duplicated code in `itk ([4217cc08a3](https://github.com/InsightSoftwareConsortium/ITK/commit/4217cc08a3))
-  Make the histogram generator set up method private ([8f8b7ca7a4](https://github.com/InsightSoftwareConsortium/ITK/commit/8f8b7ca7a4))

#### Bug Fixes

-  Fix threshold variable type/value in histogram threshold calc classes ([5c114fec35](https://github.com/InsightSoftwareConsortium/ITK/commit/5c114fec35))


### Matt McCormick (25):

#### Enhancements

-  Wrap unsigned long long for image reading writing ([4febe70198](https://github.com/InsightSoftwareConsortium/ITK/commit/4febe70198))
-  Improve is_vector identification in image_from_xarray ([69b90001ed](https://github.com/InsightSoftwareConsortium/ITK/commit/69b90001ed))
-  Update CI testing virtual machine images ([8463020847](https://github.com/InsightSoftwareConsortium/ITK/commit/8463020847))
-  Set Visual Studio toolset version in Python CI builds ([8cd2bd66c7](https://github.com/InsightSoftwareConsortium/ITK/commit/8cd2bd66c7))
-  ndim, shape, and dtype attributes for itk.Image ([a1763524ff](https://github.com/InsightSoftwareConsortium/ITK/commit/a1763524ff))
-  Update testing data content links for 5.1.0 ([d3286c9cc0](https://github.com/InsightSoftwareConsortium/ITK/commit/d3286c9cc0))

#### Performance Improvements

-  PyBuffer importImageFilterWillOwnTheBuffer is constexpr ([a306f50eff](https://github.com/InsightSoftwareConsortium/ITK/commit/a306f50eff))

#### Documentation Updates

-  Update ITKBibliography.bib link ([e401d14d76](https://github.com/InsightSoftwareConsortium/ITK/commit/e401d14d76))
-  Release process updates for v5.1rc03 ([e4e08332db](https://github.com/InsightSoftwareConsortium/ITK/commit/e4e08332db))
-  Document how to handle operator<< link errors from enum libraries ([bced49ef65](https://github.com/InsightSoftwareConsortium/ITK/commit/bced49ef65))
-  Update .zenodo ([1865c357d9](https://github.com/InsightSoftwareConsortium/ITK/commit/1865c357d9))

#### Platform Fixes

-  Update CastXML binary for Visual Studio 2019 ([ce5cf91651](https://github.com/InsightSoftwareConsortium/ITK/commit/ce5cf91651))
-  Remove unused calls in itkHashTableTest ([fc88c718ed](https://github.com/InsightSoftwareConsortium/ITK/commit/fc88c718ed))
-  Silence discarding return value in GE5ImageIO ([da78c29634](https://github.com/InsightSoftwareConsortium/ITK/commit/da78c29634))
-  UnboundLocalError in _GetImageFromArray ([97f281198c](https://github.com/InsightSoftwareConsortium/ITK/commit/97f281198c))
-  Condition HDF5 HDopen on _MSC_VER definition ([47a85f15a1](https://github.com/InsightSoftwareConsortium/ITK/commit/47a85f15a1))

#### Bug Fixes

-  Correct image_view_from_array alias ([26560ebc08](https://github.com/InsightSoftwareConsortium/ITK/commit/26560ebc08))
-  Reset m_Dimension in VideoFileWriter ([136b8e462a](https://github.com/InsightSoftwareConsortium/ITK/commit/136b8e462a))
-  Return type for PyBuffer _GetImageViewFromArray with VectorImage ([cd62423ed5](https://github.com/InsightSoftwareConsortium/ITK/commit/cd62423ed5))
-  Keep a reference to the NumPy array passed to itk.image_view_from_array ([60afb52f5b](https://github.com/InsightSoftwareConsortium/ITK/commit/60afb52f5b))
-  Use linspace for coords in xarray_from_image ([67ddcde911](https://github.com/InsightSoftwareConsortium/ITK/commit/67ddcde911))
-  Provide initial input_type value in itkTemplate ([1cf6dd01b5](https://github.com/InsightSoftwareConsortium/ITK/commit/1cf6dd01b5))
-  Keep itk.Image reference in NumPy array views ([87bc23f723](https://github.com/InsightSoftwareConsortium/ITK/commit/87bc23f723))
-  Filters avoid extra copies when operating on NumPy arrays ([8a8dfe5907](https://github.com/InsightSoftwareConsortium/ITK/commit/8a8dfe5907))
-  itk.CType to numpy.dtype types for Windows ([7cd5889b1f](https://github.com/InsightSoftwareConsortium/ITK/commit/7cd5889b1f))


### Simon Rit (2):

#### Enhancements

-  update remote module RTK ([319799698c](https://github.com/InsightSoftwareConsortium/ITK/commit/319799698c))

#### Bug Fixes

-  remove warning when writing 1D, 4D, 5D and 6D images read from disk ([8932e7ccb7](https://github.com/InsightSoftwareConsortium/ITK/commit/8932e7ccb7))


### Stephen R. Aylward (2):

#### Enhancements

-  Upgrade version of TubeTK ([3de18fcf2e](https://github.com/InsightSoftwareConsortium/ITK/commit/3de18fcf2e))
-  Added jacobian computation to ComposeScaleSkewVersorTransform (#1755) ([2f38debfe3](https://github.com/InsightSoftwareConsortium/ITK/commit/2f38debfe3))


### VXL Maintainers (1):

#### Miscellaneous Changes

- 21e619bf69 ([21e619bf69](https://github.com/InsightSoftwareConsortium/ITK/commit/21e619bf69))


### muschellij2 (2):

#### Platform Fixes

-  Add CMAKE_SH definition for Eigen ExternalProject ([b21c5f6001](https://github.com/InsightSoftwareConsortium/ITK/commit/b21c5f6001))
-  Fix HDF5 HDopen definition for MinGW ([d997cb288f](https://github.com/InsightSoftwareConsortium/ITK/commit/d997cb288f))




ITK Examples Changes Since v5.1rc03
---------------------------------------------

### Dženan Zukić (1):

#### Documentation Updates

-  update usage for ResampleAnImage ([433c158a](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/433c158a))


### Mathew Seng (6):

#### Enhancements

-  Add python testing and I/O moved to Girder Python testing is now configured for this module. ([dbe29b80](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/dbe29b80))

#### Bug Fixes

-  Test expects failure, removing EXIT_FAILURE allows test to continue ([fbe2eaaf](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/fbe2eaaf))
-  Change python enums to new v5 enum structure ([de6e33be](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/de6e33be))
-  Add exception for invalid keys that cannot be processed at runtime. ([a2fc2fbe](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/a2fc2fbe))
-  Invalid vtk image being processed. Changed to use mushroom.vtk taken ITK test. ([779409a4](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/779409a4))

#### Style Changes

-  Prefer making deleted functions public Deleting a function affects fundamental aspects of the client interface of a class, and hiding them in private as if they were implementation details is unhelpful. ([881346ff](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/881346ff))


### Matt McCormick (10):

#### Enhancements

-  Bump ITK External Project version to v5.1.0 ([df2a71e2](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/df2a71e2))

#### Documentation Updates

-  Update Sphinx date, copyright assignment ([d41321f7](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/d41321f7))
-  Update links to Sphinx ([7644858a](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/7644858a))
-  Remove invalid label map article link ([fdd95a86](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/fdd95a86))

#### Platform Fixes

-  Update breathe for Sphinx compatibility ([2216fcbe](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/2216fcbe))
-  Update pyparsing for Python 3 ([8032f868](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/8032f868))
-  Update doxylink for recent Sphinx ([1426ac93](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/1426ac93))
-  Update breathelink for recent Sphinx ([f8d6c7b0](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/f8d6c7b0))

#### Bug Fixes

-  Correct ReadAndPrintDICOMTags output ([880cee9c](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/880cee9c))
-  Disable AdaptiveHistogramEqualization Python tests ([7c0f4999](https://github.com/InsightSoftwareConsortium/ITKExamples/commit/7c0f4999))




ITK Software Guide Changes Since v5.1rc03
---------------------------------------------

### Jon Haitz Legarreta Gorroño (3):

#### Enhancements

-  Add missing table borders in `How To Create A Module` chapter ([7fd0894](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/7fd0894))
-  Add section about tests for Wrapping files ([fbb8615](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/fbb8615))
-  Miscellaneous fixes in introduction and installation ([a5f9673](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/a5f9673))


### Matt McCormick (5):

#### Enhancements

-  Bump ITK ExternalProject version to v5.1.0 ([8d41ce7](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/8d41ce7))
-  Add GitHub Action to build and publish Guide PDFs ([68e2f9f](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/68e2f9f))

#### Documentation Updates

-  Remove TreeContainer.tex input ([6e78b83](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/6e78b83))
-  Add GitHub Actions Build badge ([f91ed71](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/f91ed71))

#### Bug Fixes

-  Remove CircleCI configuration ([5e18abd](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/5e18abd))




Remote Module Changes Since v5.1rc03
---------------------------------------------

## RTK:
### Antoine Robert (8):

#### Enhancements

-  wrap image file reader and writer for dimension 1 ([0832018a](https://github.com/SimonRit/RTK/commit/0832018a))
-  wrap NumpyBridge for dimension 1 ([72ed4dfb](https://github.com/SimonRit/RTK/commit/72ed4dfb))
-  Add quadratic penalization to OSEM algorithm ([b806c7e6](https://github.com/SimonRit/RTK/commit/b806c7e6))

#### Platform Fixes

-  Fix wrapping when building ITK with dimension 1 ([3a02b74f](https://github.com/SimonRit/RTK/commit/3a02b74f))

#### Bug Fixes

-  Use real image type as input of Hilbert filter ([0d135b4d](https://github.com/SimonRit/RTK/commit/0d135b4d))
-  Change member type from float to double in Zeng projectors ([adb8061f](https://github.com/SimonRit/RTK/commit/adb8061f))

#### Style Changes

-  Use override instead of ITK_OVERRIDE ([8db54152](https://github.com/SimonRit/RTK/commit/8db54152))
-  Use default member initialization ([9ec2bc5d](https://github.com/SimonRit/RTK/commit/9ec2bc5d))


### Aurélien Coussat (7):

#### Enhancements

-  ProgressReporter for FDK reconstruction ([4b2b1fd8](https://github.com/SimonRit/RTK/commit/4b2b1fd8))
-  filters check whether their geometry is set ([40c0565d](https://github.com/SimonRit/RTK/commit/40c0565d))
-  default projectors for all iterative filters ([2c8ae75f](https://github.com/SimonRit/RTK/commit/2c8ae75f))
-  set division threshold for SART ([a0e604c7](https://github.com/SimonRit/RTK/commit/a0e604c7))

#### Performance Improvements

-  reduced size of application tests ([40f49ecc](https://github.com/SimonRit/RTK/commit/40f49ecc))

#### Bug Fixes

-  solve memory leak in rtkcheckimagequality ([2a3eb595](https://github.com/SimonRit/RTK/commit/2a3eb595))

#### Style Changes

-  fixed format in rtkIterationCommands.h ([324f0609](https://github.com/SimonRit/RTK/commit/324f0609))


### Lucas Gandel (5):

#### Enhancements

-  Add rtkSimulatedGeometry python application ([1edbc560](https://github.com/SimonRit/RTK/commit/1edbc560))
-  Add ITK clang-format linter check ([1a888880](https://github.com/SimonRit/RTK/commit/1a888880))
-  Apply clang-format to PR with tag action ([974eb598](https://github.com/SimonRit/RTK/commit/974eb598))

#### Platform Fixes

-  Set latest available itk version in setup.py ([a6437840](https://github.com/SimonRit/RTK/commit/a6437840))

#### Style Changes

-  Exclude gengetopt and lpsolve folders from clang formatting ([590cf8f5](https://github.com/SimonRit/RTK/commit/590cf8f5))


### Simon Rit (14):

#### Enhancements

-  use latest ITK v5.1 version for python packages ([2683eed1](https://github.com/SimonRit/RTK/commit/2683eed1))
-  wrap RTK image IO ([9a9d2141](https://github.com/SimonRit/RTK/commit/9a9d2141))

#### Documentation Updates

-  change CMake variable name for RTK git tag ([eeac6312](https://github.com/SimonRit/RTK/commit/eeac6312))

#### Platform Fixes

-  remove MacOS and Windows self-hosted Cuda python packages ([df54c6f7](https://github.com/SimonRit/RTK/commit/df54c6f7))
-  fix wrong header guard for rtkProgressCommands.h ([e7e4c8d1](https://github.com/SimonRit/RTK/commit/e7e4c8d1))
-  fix missing ITKGDCM dependency ([957d049e](https://github.com/SimonRit/RTK/commit/957d049e))
-  remove warnings due to unhandled enum value ([69b08d8e](https://github.com/SimonRit/RTK/commit/69b08d8e))

#### Bug Fixes

-  minimize disk space in Linux Azure pipelines to avoid saturation ([fed8944a](https://github.com/SimonRit/RTK/commit/fed8944a))
-  wrong target libraries in FirstReconstruction examples ([cf776249](https://github.com/SimonRit/RTK/commit/cf776249))
-  fix wrappings for 1D and double ([b36a0442](https://github.com/SimonRit/RTK/commit/b36a0442))

#### Style Changes

-  remove unused kernel parameter in Cuda forward projection ([dcb015ee](https://github.com/SimonRit/RTK/commit/dcb015ee))
-  fix ITK clang-format to a few RTK source files ([bbcc5802](https://github.com/SimonRit/RTK/commit/bbcc5802))
-  fix ITK clang-format ([84a0611c](https://github.com/SimonRit/RTK/commit/84a0611c))

#### Miscellaneous Changes

-  remove unused examples/CMakeLists.txt ([a90d7738](https://github.com/SimonRit/RTK/commit/a90d7738))



## TubeTK:

### Stephen R. Aylward (5):

#### Enhancements

-  Remove SVM and RandomForest methods and add ObjectDocuments Tests ([4190dcba](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/4190dcba))
-
#### Bug Fixes

-  Make find_package(ITK) dependent (NOT ITK_SOURCE) (#4) ([892a43bc](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/892a43bc))
-  Make find_package(ITK) dependent (NOT ITK_SOURCE) (#5) ([30a909d2](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/30a909d2))

#### Miscellaneous Changes

- 077e4a93 ([077e4a93](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/077e4a93))
