/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.lax;

import com.zerog.awt.ZGStandardDialog;
import com.zerog.common.io.NullInputStream;
import com.zerog.common.io.NullOutputStream;
import com.zerog.common.java.util.PropertiesUtil;
import com.zerog.lax.LAXQuotedStreamTokenizer;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class LAX {
    public static final String LAX_VERSION = "9.0";
    public static final String PROPERTYPREFIX = "lax.";
    public static final String VERSION = "lax.version";
    public static final String APP_NAME = "lax.application.name";
    public static final String MAIN_CLASS = "lax.main.class";
    public static final String MAIN_METHOD = "lax.main.method";
    public static final String CMD_LINE_ARGS = "lax.command.line.args";
    public static final String USER_DIR = "lax.user.dir";
    public static final String INSTALL_DIRECTORY = "lax.root.install.dir";
    public static final String NATIVE_LAUNCHER_INSTALL_DIRECTORY = "lax.dir";
    public static final String LAX_MAIN_CLASS = "lax.nl.java.launcher.main.class";
    public static final String LAX_MAIN_METHOD = "lax.nl.java.launcher.main.method";
    public static final String CLASS_PATH = "lax.class.path";
    public static final String CURRENT_VM = "lax.nl.current.vm";
    public static final String STDIN = "lax.stdin.redirect";
    public static final String STDOUT = "lax.stdout.redirect";
    public static final String STDERR = "lax.stderr.redirect";
    public static final String ENVIRONMENT_VARIABLE_PREFIX = "lax.nl.env.";
    private String[] nativeArgs;
    private static PrintStream originalSTDOUT = System.out;
    private static PrintStream originalSTDERR = System.err;
    private static InputStream originalSTDIN = System.in;
    private static final String osName = System.getProperty("os.name").toLowerCase();
    private static final boolean isMacOSX = osName.indexOf("mac") != -1 && osName.indexOf("x") != -1;
    private static boolean appendSTDOUT = false;
    private static boolean appendSTDERR = false;
    private Throwable theException;
    private static final String generalAppErrorString = "Unable to Launch Java Application";
    private static final String generalAppFailureString = "This Application has Unexpectedly Quit";
    private static final String alertDialogTitle = "Fatal Application Error";
    private static final String[] SUPPORTED_PLATFORMS = new String[]{"unix", "irix", "netbsd", "freebsd", "bsdi", "bsd", "unixware", "aix", "dg/ux", "dgux", "osf1", "linux", "machten", "nextstep", "rhapsody", "mac os x", "hp-ux", "hpux", "sunos", "solaris", "windows"};

    public static PrintStream getOriginalStdOut() {
        return originalSTDOUT;
    }

    public static PrintStream getOriginalStdErr() {
        return originalSTDERR;
    }

    public static InputStream getOriginalStdIn() {
        return originalSTDIN;
    }

    public void addProperties(String[] stringArray) throws IOException {
        if (stringArray[0].toUpperCase().endsWith(".LAX") || stringArray[0].toUpperCase().endsWith(".PROPERTIES")) {
            File file = new File(stringArray[0]);
            if (!file.exists()) {
                file = new File(file.getName());
            }
            Properties properties = file.exists() ? PropertiesUtil.loadProperties(file) : new Properties();
            PropertiesUtil.mergeIntoProps(System.getProperties(), properties);
        }
    }

    public LAX(String[] stringArray) throws Throwable {
        Object object;
        stringArray = this.convertArguments(stringArray);
        stringArray = LAX.dequoteArguments(stringArray);
        if (stringArray != null) {
            this.nativeArgs = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.nativeArgs[i] = LAX.convertFromEscapedUnicode(stringArray[i]);
            }
        } else {
            this.nativeArgs = null;
        }
        if (this.nativeArgs != null && this.nativeArgs.length > 0) {
            File file;
            this.addProperties(this.nativeArgs);
            if (!this.verifyProperty(MAIN_CLASS, this.nativeArgs[0])) {
                return;
            }
            if (!this.verifyProperty(MAIN_METHOD, this.nativeArgs[0])) {
                return;
            }
            if (!isMacOSX && this.nativeArgs.length > 1 && !this.nativeArgs[1].equals("lax_no_temp_file") && (file = new File(this.nativeArgs[1])) != null && file.exists()) {
                object = new File(this.nativeArgs[1]);
                Properties properties = PropertiesUtil.loadProperties((File)object);
                file.delete();
                PropertiesUtil.mergeIntoProps(System.getProperties(), properties);
                ((File)object).delete();
            }
        } else if (!isMacOSX) {
            originalSTDOUT.println("Path not supplied to properties file");
        }
        this.setStdOutStdErrOnSupportedPlatforms();
        this.configureDebugging();
        if (System.getProperty("LISTPROPS") != null) {
            PropertiesUtil.listProperties(System.err, System.getProperties());
        }
        if (System.getProperty("lax.java.compiler") == "off" || System.getProperty("lax.nl.java.compiler") == "off") {
            Compiler.disable();
        }
        Properties properties = System.getProperties();
        ((Hashtable)properties).put(VERSION, LAX_VERSION);
        System.setProperties(properties);
        object = System.getProperty("lax.nl.env.LAX_DEBUG");
        if (object == null) {
            object = System.getProperty("lax.control-key");
        }
        if (object != null && !((String)object).equals("false") && !((String)object).trim().equals("")) {
            System.err.println("LAX Version = 9.0");
        }
    }

    private String[] convertArguments(String[] stringArray) {
        int n;
        String string = "\"";
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("\"") && n < stringArray.length && stringArray[n + 1].equals("\"")) {
                vector.addElement(" ");
                ++n;
                continue;
            }
            vector.addElement(stringArray[n]);
        }
        stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        vector.removeAllElements();
        for (n = 0; n < stringArray.length; ++n) {
            if (bl) {
                string2 = string2 + " " + stringArray[n];
            }
            if (stringArray[n].startsWith("\"") && !stringArray[n].endsWith("\"")) {
                string2 = stringArray[n].substring(1, stringArray[n].length());
                bl = true;
                continue;
            }
            if (bl && stringArray[n].endsWith("\"")) {
                bl = false;
                vector.addElement(string2.substring(0, string2.length() - 1));
                continue;
            }
            if (bl) continue;
            vector.addElement(stringArray[n]);
        }
        String[] stringArray2 = new String[vector.size()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (String)vector.elementAt(i);
        }
        return stringArray2;
    }

    public static String[] dequoteArguments(String[] stringArray) {
        String string = "\"";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() <= 1) continue;
            int n = string2.startsWith("\"") ? 1 : 0;
            int n2 = string2.endsWith("\"") ? string2.length() - 2 : string2.length() - 1;
            stringArray[i] = string2 = string2.substring(n, n2 + 1);
        }
        return stringArray;
    }

    private void setStdOutStdErrOnSupportedPlatforms() {
        if (isMacOSX && "console".equals(System.getProperty(STDOUT, "").trim().toLowerCase())) {
            if (System.getProperty("os.version", "").startsWith("10.3")) {
                ((Hashtable)System.getProperties()).put(STDOUT, "/Library/Logs/Console/" + System.getProperty("user.name") + "/console.log");
            } else if (!System.getProperty("os.version", "").startsWith("10.4")) {
                ((Hashtable)System.getProperties()).put(STDOUT, "/var/tmp/console.log");
            }
            appendSTDOUT = true;
        }
        if (isMacOSX && "console".equals(System.getProperty(STDERR, "").trim().toLowerCase())) {
            if (System.getProperty("os.version", "").startsWith("10.3")) {
                ((Hashtable)System.getProperties()).put(STDERR, "/Library/Logs/Console/" + System.getProperty("user.name") + "/console.log");
            } else if (!System.getProperty("os.version", "").startsWith("10.4")) {
                ((Hashtable)System.getProperties()).put(STDERR, "/var/tmp/console.log");
            }
            appendSTDERR = true;
        }
        for (int i = 0; i < SUPPORTED_PLATFORMS.length; ++i) {
            if (osName.indexOf(SUPPORTED_PLATFORMS[i]) == -1) continue;
            this.setStdOutStdErr();
            break;
        }
    }

    private void setStdOutStdErr() {
        String string;
        String string2;
        String string3 = System.getProperty(STDIN);
        if (string3 != null) {
            if (string3.length() > 0) {
                if (!string3.toLowerCase().trim().equals("console") && !string3.toLowerCase().trim().equals("")) {
                    try {
                        System.setIn(new FileInputStream(string3));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println("Error redirecting stdin from file.");
                        fileNotFoundException.printStackTrace();
                    }
                }
            } else {
                System.setIn(new NullInputStream());
            }
        } else {
            System.setIn(new NullInputStream());
        }
        if ((string2 = System.getProperty(STDOUT)) != null) {
            if (string2.length() > 0) {
                if (!string2.toLowerCase().trim().equals("console") && !string2.toLowerCase().trim().equals("")) {
                    try {
                        System.setOut(new PrintStream(new FileOutputStream(string2, appendSTDOUT)));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        try {
                            System.setOut(new PrintStream(new FileOutputStream("out.txt")));
                            System.err.println("Error redirecting stdout.  Output will be placed into 'out.txt' instead.");
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            } else {
                System.setOut(new PrintStream(new NullOutputStream()));
            }
        } else {
            System.setOut(new PrintStream(new NullOutputStream()));
        }
        if ((string = System.getProperty(STDERR)) != null) {
            if (string.length() > 0) {
                if (!string.toLowerCase().trim().equals("console") && !string.toLowerCase().trim().equals("")) {
                    if (string.equals(string2)) {
                        System.setErr(System.out);
                    } else {
                        try {
                            System.setErr(new PrintStream(new FileOutputStream(string, appendSTDERR)));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            try {
                                System.setOut(new PrintStream(new FileOutputStream("err.txt")));
                                System.err.println("Error redirecting stderr.  Output will be placed into 'err.txt' instead.");
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                System.setErr(new PrintStream(new NullOutputStream()));
            }
        } else {
            System.setErr(new PrintStream(new NullOutputStream()));
        }
    }

    public void launch() {
        Properties properties = System.getProperties();
        Class<?> clazz = null;
        String string = properties.getProperty(MAIN_CLASS);
        Method method = null;
        String string2 = properties.getProperty(MAIN_METHOD);
        String string3 = properties.getProperty(CMD_LINE_ARGS);
        String string4 = "";
        try {
            Object[] objectArray;
            try {
                clazz = Class.forName(string);
            }
            catch (Throwable throwable) {
                this.theException = throwable;
                string4 = "Unable to locate the application's 'main' class. The class '" + string + "' must be public and have a 'public static void " + string2 + "(String[])' method. (LAX)";
                originalSTDERR.println(string4);
                this.showExceptionDialog(generalAppErrorString, string4, true);
                System.exit(3001);
            }
            try {
                objectArray = new Class[]{new String[0].getClass()};
                method = clazz.getMethod(string2, (Class<?>[])objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.theException = noSuchMethodException;
                string4 = "The method to invoke is not accessible. The class '" + string + "' must be public and have a 'public static void " + string2 + "(String[])' method. (LAX)";
                originalSTDERR.println(string4);
                this.showExceptionDialog(generalAppErrorString, string4, true);
                System.exit(3002);
            }
            try {
                objectArray = new Object[]{this.parseArgs(string3)};
                method.invoke(null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.theException = illegalAccessException;
                string4 = "The method to invoke is not accessible. The class '" + string + "' must be public and have a 'public static void " + string2 + "(String[])' method. (LAX)";
                originalSTDERR.println(string4);
                this.showExceptionDialog(generalAppErrorString, string4, true);
                System.exit(3003);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.theException = illegalArgumentException;
                string4 = "The method to invoke is not accessible. The class '" + string + "' must be public and have a 'public static void " + string2 + "(String[])' method. (LAX)";
                originalSTDERR.println(string4);
                this.showExceptionDialog(generalAppErrorString, string4, true);
                System.exit(3003);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.theException = invocationTargetException.getTargetException();
                string4 = "Invocation of this Java Application has caused an InvocationTargetException. This application will now exit. (LAX)";
                if (this.theException instanceof ExceptionInInitializerError) {
                    System.err.println("theException = ExceptionInInitializerError");
                    string4 = "Invocation of this Java Application has caused an ExceptionInInitializerError. This application will now exit. (LAX)";
                    this.theException = ((ExceptionInInitializerError)this.theException).getException();
                }
                originalSTDERR.println(string4);
                originalSTDERR.println("\nStack Trace:");
                this.theException.printStackTrace(originalSTDERR);
                this.showExceptionDialog(generalAppFailureString, string4, true);
                System.exit(3004);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                this.theException = exceptionInInitializerError.getException();
                while (this.theException instanceof ExceptionInInitializerError) {
                    this.theException = exceptionInInitializerError.getException();
                }
                string4 = "Invocation of this Java Application has caused an ExceptionInInitializerError. This application will now exit. (LAX)";
                originalSTDERR.println(string4);
                originalSTDERR.println("\nStack Trace:");
                this.theException.printStackTrace(originalSTDERR);
                this.showExceptionDialog(generalAppFailureString, string4, true);
                System.exit(3004);
            }
            catch (NullPointerException nullPointerException) {
                this.theException = nullPointerException;
                string4 = "This Java Application has encountered a NullPointerException and will now exit. (LAX)";
                originalSTDERR.println(string4);
                originalSTDERR.println("\nStack Trace:");
                nullPointerException.printStackTrace(originalSTDERR);
                this.showExceptionDialog(generalAppFailureString, string4, true);
                System.exit(3004);
            }
        }
        catch (ThreadDeath threadDeath) {
            System.exit(3000);
        }
        catch (Exception exception) {
            this.theException = exception;
            string4 = "This Java Application has encountered an unexpected exception and will now exit. (LAX)";
            originalSTDERR.println(string4);
            originalSTDERR.println("\nStack Trace:");
            exception.printStackTrace(originalSTDERR);
            this.showExceptionDialog(generalAppFailureString, string4, true);
            System.exit(3000);
        }
        catch (Throwable throwable) {
            this.theException = throwable;
            string4 = "This Java Application has encountered an unexpected error and will now exit. (LAX)";
            originalSTDERR.println(string4);
            originalSTDERR.println("\nStack Trace:");
            throwable.printStackTrace(originalSTDERR);
            this.showExceptionDialog(generalAppFailureString, string4, true);
            System.exit(3000);
        }
    }

    private boolean verifyProperty(String string, String string2) {
        if (System.getProperty(string) == null) {
            String string3 = "The properties files is missing an essential property: " + string + ". Please make sure it exists in the properties file: " + string2;
            originalSTDERR.println(string3);
            this.showExceptionDialog(generalAppErrorString, string3, false);
            return false;
        }
        return true;
    }

    private String[] parseArgs(String string) {
        if (string == null || string.length() <= 0) {
            return new String[0];
        }
        LAXQuotedStreamTokenizer lAXQuotedStreamTokenizer = new LAXQuotedStreamTokenizer(new StringReader(string));
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            while ((string2 = lAXQuotedStreamTokenizer.getNextToken()) != null) {
                if (lAXQuotedStreamTokenizer.getType() == -10) {
                    vector.addElement(string2);
                    continue;
                }
                if (lAXQuotedStreamTokenizer.getType() == -11) {
                    vector.addElement(string2);
                    continue;
                }
                if (lAXQuotedStreamTokenizer.getType() != -12) continue;
                vector.addElement(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(originalSTDERR);
        }
        if (vector.size() <= 0) {
            return new String[0];
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!((String)e).equals("$CMD_LINE_ARGUMENTS$")) continue;
            for (int j = this.nativeArgs.length - 1; j > 1; --j) {
                vector.insertElementAt(this.nativeArgs[j], i);
            }
            vector.removeElement(e);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private void configureDebugging() {
        try {
            boolean bl = Boolean.getBoolean(System.getProperty("lax.debug.all", "false"));
            if (bl) {
                ZeroGb.a = Integer.parseInt(System.getProperty("lax.debug.level", "0"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            ZeroGb.a = 0;
        }
    }

    private void showExceptionDialog(String string, String string2, boolean bl) {
        try {
            Dialog dialog = osName.indexOf("mac") != -1 && osName.indexOf("x") != -1 ? new ZeroGax(alertDialogTitle, string, string2) : new ZGStandardDialog(alertDialogTitle, string, string2);
            dialog.setDetailsButtonVisible(bl);
            dialog.setCancelButtonVisible(false);
            dialog.setVisible(true);
            if (dialog.getLastButtonPressed() == 3) {
                ZeroGps zeroGps = new ZeroGps(this.theException);
                ((Component)zeroGps).setVisible(true);
            }
        }
        catch (Throwable throwable) {
            originalSTDERR.println(string + ": " + string2);
        }
    }

    public static void serviceMainHook(String[] stringArray) {
    }

    public static void main(String[] stringArray) {
        try {
            final LAX lAX = new LAX(stringArray);
            if (osName.indexOf("win") != -1 && System.getProperty("lax.nl.win32.service", "false").trim().equalsIgnoreCase("true") && System.getProperty("java.version", "").startsWith("1.3") && !System.getProperty("java.version", "").startsWith("1.3.1")) {
                Thread thread = new Thread("LaunchAnywhere Main Thread"){

                    public void run() {
                        lAX.launch();
                    }
                };
                thread.setPriority(10);
                thread.start();
            } else {
                lAX.launch();
            }
        }
        catch (Throwable throwable) {
            String string = "An internal LaunchAnywhere application error has occured and this application cannot proceed. (LAX)";
            System.err.println(string);
            System.err.println("\nStack Trace:");
            throwable.printStackTrace(System.err);
            System.exit(3000);
        }
    }

    public static String convertFromEscapedUnicode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = -1;
        int n3 = 0;
        char c = '\u0000';
        int n4 = 0;
        while (n4 < n) {
            c = string.charAt(n4);
            if (c == '\\') {
                if (++n4 >= n) continue;
                c = string.charAt(n4);
                if (c == 'u') {
                    ++n4;
                    n2 = 0;
                    for (int i = 0; i < 4 && n4 < n; ++n4, ++i) {
                        c = string.charAt(n4);
                        n3 = LAX.getOffset(c);
                        if (n3 == -1) {
                            stringBuffer.append("\\u");
                            while (i > 0) {
                                stringBuffer.append(string.charAt(n4 - i));
                                --i;
                            }
                            n2 = -1;
                            break;
                        }
                        n2 = (n2 << 4) + c - n3;
                    }
                    if (n2 == -1) continue;
                    stringBuffer.append((char)n2);
                    continue;
                }
                stringBuffer.append(c);
                ++n4;
                continue;
            }
            stringBuffer.append(c);
            ++n4;
        }
        return stringBuffer.toString();
    }

    private static int getOffset(int n) {
        if (n >= 48 && n <= 57) {
            return 48;
        }
        if (n >= 65 && n <= 70) {
            return 55;
        }
        if (n >= 97 && n <= 102) {
            return 87;
        }
        return -1;
    }
}

