/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.TitledPaneBehavior;
import com.sun.javafx.scene.control.skin.AccordionSkin;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Labeled;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.util.Duration;

public class TitledPaneSkin
extends LabeledSkinBase<TitledPane, TitledPaneBehavior> {
    public static final int MIN_HEADER_HEIGHT = 22;
    public static final Duration TRANSITION_DURATION = new Duration(350.0);
    private final TitleRegion titleRegion;
    private final ContentContainer contentContainer;
    private final Content contentRegion;
    private Timeline timeline;
    private double transitionStartValue;
    private Rectangle clipRect = new Rectangle();
    private Pos pos;
    private HPos hpos;
    private VPos vpos;
    private DoubleProperty transition;
    private double prefHeightFromAccordion = 0.0;

    public TitledPaneSkin(TitledPane titledPane) {
        super(titledPane, new TitledPaneBehavior(titledPane));
        this.setClip(this.clipRect);
        this.transitionStartValue = 0.0;
        this.titleRegion = new TitleRegion();
        this.contentRegion = new Content(((TitledPane)this.getSkinnable()).getContent());
        this.contentContainer = new ContentContainer();
        this.contentContainer.getChildren().setAll((Node[])new Node[]{this.contentRegion});
        if (titledPane.isExpanded()) {
            this.setExpanded(titledPane.isExpanded());
        } else {
            this.setTransition(0.0);
        }
        this.getChildren().setAll((Node[])new Node[]{this.contentContainer, this.titleRegion});
        this.registerChangeListener(titledPane.contentProperty(), "CONTENT");
        this.registerChangeListener(titledPane.expandedProperty(), "EXPANDED");
        this.registerChangeListener(titledPane.collapsibleProperty(), "COLLAPSIBLE");
        this.registerChangeListener(titledPane.alignmentProperty(), "ALIGNMENT");
        this.registerChangeListener(this.titleRegion.alignmentProperty(), "TITLE_REGION_ALIGNMENT");
        this.pos = titledPane.getAlignment();
        this.hpos = titledPane.getAlignment().getHpos();
        this.vpos = titledPane.getAlignment().getVpos();
    }

    public StackPane getContentRegion() {
        return this.contentRegion;
    }

    @Override
    protected void setWidth(double d) {
        super.setWidth(d);
        this.clipRect.setWidth(d);
    }

    @Override
    protected void setHeight(double d) {
        super.setHeight(d);
        this.clipRect.setHeight(d);
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "CONTENT") {
            this.contentRegion.setContent(((TitledPane)this.getSkinnable()).getContent());
        } else if (string == "EXPANDED") {
            this.setExpanded(((TitledPane)this.getSkinnable()).isExpanded());
        } else if (string == "COLLAPSIBLE") {
            this.titleRegion.update();
        } else if (string == "ALIGNMENT") {
            this.pos = ((TitledPane)this.getSkinnable()).getAlignment();
            this.hpos = this.pos.getHpos();
            this.vpos = this.pos.getVpos();
        } else if (string == "TITLE_REGION_ALIGNMENT") {
            this.pos = this.titleRegion.getAlignment();
            this.hpos = this.pos.getHpos();
            this.vpos = this.pos.getVpos();
        }
    }

    @Override
    protected void updateChildren() {
        if (this.titleRegion != null) {
            this.titleRegion.update();
        }
    }

    private void setExpanded(boolean bl) {
        if (!((TitledPane)this.getSkinnable()).isCollapsible()) {
            this.setTransition(1.0);
            return;
        }
        if (((TitledPane)this.getSkinnable()).isAnimated()) {
            this.transitionStartValue = this.getTransition();
            this.doAnimationTransition();
        } else {
            if (bl) {
                this.setTransition(1.0);
            } else {
                this.setTransition(0.0);
            }
            if (this.contentRegion.getContent() != null) {
                this.contentRegion.getContent().setVisible(bl);
            }
            this.requestLayout();
        }
    }

    private void setTransition(double d) {
        this.transitionProperty().set(d);
    }

    private double getTransition() {
        return this.transition == null ? 0.0 : this.transition.get();
    }

    private DoubleProperty transitionProperty() {
        if (this.transition == null) {
            this.transition = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    TitledPaneSkin.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return TitledPaneSkin.this;
                }

                @Override
                public String getName() {
                    return "transition";
                }
            };
        }
        return this.transition;
    }

    @Override
    protected void layoutChildren() {
        double d = this.snapSize(this.getWidth()) - (this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight()));
        double d2 = this.snapSize(this.getHeight()) - (this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom()));
        double d3 = Math.max(22.0, this.snapSize(this.titleRegion.prefHeight(-1.0)));
        this.titleRegion.resize(d, d3);
        this.positionInArea(this.titleRegion, this.snapSpace(this.getInsets().getLeft()), this.snapSpace(this.getInsets().getTop()), d, d3, 0.0, HPos.LEFT, VPos.CENTER);
        double d4 = d;
        double d5 = d2 - d3;
        if (((TitledPane)this.getSkinnable()).getParent() != null && ((TitledPane)this.getSkinnable()).getParent() instanceof AccordionSkin && this.prefHeightFromAccordion != 0.0) {
            d5 = this.prefHeightFromAccordion - d3;
        }
        double d6 = this.snapSpace(this.getInsets().getTop()) + this.snapSpace(d3) - d5 * (1.0 - this.getTransition());
        double d7 = d5 * (1.0 - this.getTransition());
        ((Rectangle)this.contentContainer.getClip()).setY(d7);
        this.contentContainer.resize(d4, d5);
        this.positionInArea(this.contentContainer, this.snapSpace(this.getInsets().getLeft()), d6, d, d5, 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    protected double computeMinWidth(double d) {
        return this.computePrefWidth(d);
    }

    @Override
    protected double computeMinHeight(double d) {
        return Math.max(22.0, this.snapSize(this.titleRegion.prefHeight(-1.0)));
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = this.snapSize(this.titleRegion.prefWidth(d));
        double d3 = this.snapSize(this.contentContainer.prefWidth(d));
        return Math.max(d2, d3) + this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight());
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = Math.max(22.0, this.snapSize(this.titleRegion.prefHeight(-1.0)));
        double d3 = 0.0;
        d3 = ((TitledPane)this.getSkinnable()).getParent() != null && ((TitledPane)this.getSkinnable()).getParent() instanceof AccordionSkin ? this.contentContainer.prefHeight(-1.0) : this.contentContainer.prefHeight(-1.0) * this.getTransition();
        return d2 + this.snapSize(d3) + this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom());
    }

    @Override
    protected double computeMaxWidth(double d) {
        return Double.MAX_VALUE;
    }

    void setMaxTitledPaneHeightForAccordion(double d) {
        this.prefHeightFromAccordion = d;
    }

    double getTitledPaneHeightForAccordion() {
        double d = Math.max(22.0, this.snapSize(this.titleRegion.prefHeight(-1.0)));
        double d2 = (this.prefHeightFromAccordion - d) * this.getTransition();
        return d + this.snapSize(d2) + this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom());
    }

    private void doAnimationTransition() {
        KeyFrame keyFrame;
        KeyFrame keyFrame2;
        Duration duration;
        if (this.contentRegion.getContent() == null) {
            return;
        }
        if (this.timeline != null && this.timeline.getStatus() != Animation.Status.STOPPED) {
            duration = this.timeline.getCurrentTime();
            this.timeline.stop();
        } else {
            duration = TRANSITION_DURATION;
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(1);
        if (((TitledPane)this.getSkinnable()).isExpanded()) {
            keyFrame2 = new KeyFrame(Duration.ZERO, new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    TitledPaneSkin.this.contentRegion.getContent().setCache(true);
                    TitledPaneSkin.this.contentRegion.getContent().setVisible(true);
                }
            }, new KeyValue(this.transitionProperty(), this.transitionStartValue));
            keyFrame = new KeyFrame(duration, new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    TitledPaneSkin.this.contentRegion.getContent().setCache(false);
                }
            }, new KeyValue(this.transitionProperty(), 1, Interpolator.EASE_OUT));
        } else {
            keyFrame2 = new KeyFrame(Duration.ZERO, new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    TitledPaneSkin.this.contentRegion.getContent().setCache(true);
                }
            }, new KeyValue(this.transitionProperty(), this.transitionStartValue));
            keyFrame = new KeyFrame(duration, new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    TitledPaneSkin.this.contentRegion.getContent().setVisible(false);
                    TitledPaneSkin.this.contentRegion.getContent().setCache(false);
                }
            }, new KeyValue(this.transitionProperty(), 0, Interpolator.EASE_IN));
        }
        this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame2, keyFrame});
        this.timeline.play();
    }

    class Content
    extends StackPane
    implements TraverseListener {
        private Node content;
        private TraversalEngine engine;
        private Direction direction;

        public Content(Node node) {
            this.setContent(node);
            this.engine = new TraversalEngine(this, false){

                @Override
                public void trav(Node node, Direction direction) {
                    Content.this.direction = direction;
                    super.trav(node, direction);
                }
            };
            this.engine.addTraverseListener(this);
            this.setImpl_traversalEngine(this.engine);
        }

        public final void setContent(Node node) {
            this.content = node;
            this.getChildren().clear();
            if (node != null) {
                this.getChildren().setAll((Node[])new Node[]{node});
            }
        }

        public final Node getContent() {
            return this.content;
        }

        @Override
        public void onTraverse(Node node, Bounds bounds) {
            int n = this.engine.registeredNodes.indexOf(node);
            if (n == -1 && this.direction.equals((Object)Direction.PREVIOUS) && ((TitledPane)TitledPaneSkin.this.getSkinnable()).getParent() != null && ((TitledPane)TitledPaneSkin.this.getSkinnable()).getParent() instanceof AccordionSkin) {
                new TraversalEngine((Parent)((Object)TitledPaneSkin.this.getSkinnable()), false).trav(((TitledPane)TitledPaneSkin.this.getSkinnable()).getParent(), Direction.PREVIOUS);
            }
            if (n == -1 && this.direction.equals((Object)Direction.NEXT) && ((TitledPane)TitledPaneSkin.this.getSkinnable()).getParent() != null && ((TitledPane)TitledPaneSkin.this.getSkinnable()).getParent() instanceof AccordionSkin) {
                new TraversalEngine((Parent)((Object)TitledPaneSkin.this.getSkinnable()), false).trav(((TitledPane)TitledPaneSkin.this.getSkinnable()).getParent(), Direction.NEXT);
            }
        }
    }

    class ContentContainer
    extends StackPane {
        private Rectangle clipRect;

        public ContentContainer() {
            this.getStyleClass().setAll((String[])new String[]{"content"});
            this.clipRect = new Rectangle();
            this.setClip(this.clipRect);
            this.setAlignment(Pos.BOTTOM_CENTER);
        }

        @Override
        protected void setWidth(double d) {
            super.setWidth(d);
            this.clipRect.setWidth(d);
        }

        @Override
        protected void setHeight(double d) {
            super.setHeight(d);
            this.clipRect.setHeight(d);
        }
    }

    class TitleRegion
    extends StackPane {
        private final StackPane arrowRegion;

        public TitleRegion() {
            this.getStyleClass().setAll((String[])new String[]{"title"});
            this.arrowRegion = new StackPane();
            this.arrowRegion.setId("arrowRegion");
            this.arrowRegion.getStyleClass().setAll((String[])new String[]{"arrow-button"});
            StackPane stackPane = new StackPane();
            stackPane.setId("arrow");
            stackPane.getStyleClass().setAll((String[])new String[]{"arrow"});
            this.arrowRegion.getChildren().setAll((Node[])new Node[]{stackPane});
            this.setAlignment(Pos.CENTER_LEFT);
            this.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (((TitledPane)TitledPaneSkin.this.getSkinnable()).isCollapsible() && ((TitledPane)TitledPaneSkin.this.getSkinnable()).isFocused()) {
                        ((TitledPaneBehavior)TitledPaneSkin.this.getBehavior()).toggle();
                    }
                }
            });
            this.update();
        }

        private void update() {
            this.getChildren().clear();
            TitledPane titledPane = (TitledPane)TitledPaneSkin.this.getSkinnable();
            if (titledPane.isCollapsible()) {
                this.getChildren().add(this.arrowRegion);
            }
            if (TitledPaneSkin.this.graphic != null) {
                TitledPaneSkin.this.graphic.layoutBoundsProperty().removeListener(TitledPaneSkin.this.graphicPropertyChangedListener);
            }
            TitledPaneSkin.this.graphic = titledPane.getGraphic();
            if (TitledPaneSkin.this.isIgnoreGraphic()) {
                if (titledPane.getContentDisplay() == ContentDisplay.GRAPHIC_ONLY) {
                    this.getChildren().clear();
                    this.getChildren().add(this.arrowRegion);
                } else {
                    this.getChildren().add(TitledPaneSkin.this.text);
                }
            } else {
                TitledPaneSkin.this.graphic.layoutBoundsProperty().addListener(TitledPaneSkin.this.graphicPropertyChangedListener);
                if (TitledPaneSkin.this.isIgnoreText()) {
                    this.getChildren().add(TitledPaneSkin.this.graphic);
                } else {
                    this.getChildren().addAll((Node[])new Node[]{TitledPaneSkin.this.graphic, TitledPaneSkin.this.text});
                }
            }
            this.setCursor(((TitledPane)TitledPaneSkin.this.getSkinnable()).isCollapsible() ? Cursor.HAND : Cursor.DEFAULT);
        }

        @Override
        protected double computePrefWidth(double d) {
            double d2 = this.snapSpace(this.getInsets().getLeft());
            double d3 = this.snapSpace(this.getInsets().getRight());
            double d4 = 0.0;
            double d5 = this.labelPrefWidth(d);
            if (this.arrowRegion != null) {
                d4 = this.snapSize(this.arrowRegion.prefWidth(d));
            }
            return d2 + d4 + d5 + d3;
        }

        @Override
        protected double computePrefHeight(double d) {
            double d2 = this.snapSpace(this.getInsets().getTop());
            double d3 = this.snapSpace(this.getInsets().getBottom());
            double d4 = 0.0;
            double d5 = this.labelPrefHeight(d);
            if (this.arrowRegion != null) {
                d4 = this.snapSize(this.arrowRegion.prefHeight(d));
            }
            return d2 + Math.max(d4, d5) + d3;
        }

        @Override
        protected void layoutChildren() {
            double d = this.snapSpace(this.getInsets().getTop());
            double d2 = this.snapSpace(this.getInsets().getBottom());
            double d3 = this.snapSpace(this.getInsets().getLeft());
            double d4 = this.snapSpace(this.getInsets().getRight());
            double d5 = this.getWidth() - (d3 + d4);
            double d6 = this.getHeight() - (d + d2);
            double d7 = this.snapSize(this.arrowRegion.prefWidth(-1.0));
            double d8 = this.snapSize(this.arrowRegion.prefHeight(-1.0));
            double d9 = this.snapSize(this.labelPrefWidth(-1.0));
            double d10 = this.snapSize(this.labelPrefHeight(-1.0));
            double d11 = d3 + d7 + Utils.computeXOffset(d5 - d7, d9, TitledPaneSkin.this.hpos);
            if (HPos.CENTER == TitledPaneSkin.this.hpos) {
                d11 = d3 + Utils.computeXOffset(d5, d9, TitledPaneSkin.this.hpos);
            }
            double d12 = d + Utils.computeYOffset(d6, Math.max(d8, d10), TitledPaneSkin.this.vpos);
            this.arrowRegion.resize(d7, d8);
            this.positionInArea(this.arrowRegion, d3, d, d7, d6, 0.0, HPos.CENTER, VPos.CENTER);
            TitledPaneSkin.this.layoutLabelInArea(d11, d12, d9, d6, TitledPaneSkin.this.pos);
        }

        private double labelPrefWidth(double d) {
            Labeled labeled = (Labeled)TitledPaneSkin.this.getSkinnable();
            Font font = TitledPaneSkin.this.text.getFont();
            String string = labeled.getText();
            boolean bl = string == null || string.isEmpty();
            Insets insets = labeled.getLabelPadding();
            double d2 = insets.getLeft() + insets.getRight();
            double d3 = bl ? 0.0 : Utils.computeTextWidth(font, string, 0.0);
            Node node = labeled.getGraphic();
            if (TitledPaneSkin.this.isIgnoreGraphic()) {
                return d3 + d2;
            }
            if (TitledPaneSkin.this.isIgnoreText()) {
                return node.prefWidth(-1.0) + d2;
            }
            if (labeled.getContentDisplay() == ContentDisplay.LEFT || labeled.getContentDisplay() == ContentDisplay.RIGHT) {
                return d3 + labeled.getGraphicTextGap() + node.prefWidth(-1.0) + d2;
            }
            return Math.max(d3, node.prefWidth(-1.0)) + d2;
        }

        private double labelPrefHeight(double d) {
            double d2;
            Labeled labeled = (Labeled)TitledPaneSkin.this.getSkinnable();
            Font font = TitledPaneSkin.this.text.getFont();
            ContentDisplay contentDisplay = labeled.getContentDisplay();
            double d3 = labeled.getGraphicTextGap();
            Insets insets = this.getInsets();
            Insets insets2 = labeled.getLabelPadding();
            double d4 = insets.getLeft() + insets.getRight() + insets2.getLeft() + insets2.getRight();
            String string = labeled.getText();
            if (string != null && string.endsWith("\n")) {
                string = string.substring(0, string.length() - 1);
            }
            if (!(TitledPaneSkin.this.isIgnoreGraphic() || contentDisplay != ContentDisplay.LEFT && contentDisplay != ContentDisplay.RIGHT)) {
                d -= TitledPaneSkin.this.graphic.prefWidth(-1.0) + d3;
            }
            double d5 = d2 = Utils.computeTextHeight(font, string, labeled.isWrapText() ? (d -= d4) : 0.0);
            if (!TitledPaneSkin.this.isIgnoreGraphic()) {
                Node node = labeled.getGraphic();
                d5 = contentDisplay == ContentDisplay.TOP || contentDisplay == ContentDisplay.BOTTOM ? node.prefHeight(-1.0) + d3 + d2 : Math.max(d2, node.prefHeight(-1.0));
            }
            return d5 + insets2.getTop() + insets2.getBottom();
        }
    }
}

