/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import java.util.Arrays;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class BorderStyle {
    public static final BorderStyle NONE = new BorderStyle();
    public static final BorderStyle SOLID = new BorderStyle(StrokeType.CENTERED, StrokeLineJoin.MITER, StrokeLineCap.BUTT, 10.0, 0.0, new double[0]);
    private final StrokeType strokeType;
    private final StrokeLineJoin strokeLineJoin;
    private final StrokeLineCap strokeLineCap;
    private final double strokeMiterLimit;
    private final double strokeDashOffset;
    private final double[] strokeDashArray;
    boolean adjusted = false;

    public StrokeType getStrokeType() {
        return this.strokeType;
    }

    public StrokeLineJoin getStrokeLineJoin() {
        return this.strokeLineJoin;
    }

    public StrokeLineCap getStrokeLineCap() {
        return this.strokeLineCap;
    }

    public double getStrokeMiterLimit() {
        return this.strokeMiterLimit;
    }

    public double getStrokeDashOffset() {
        return this.strokeDashOffset;
    }

    public double[] getStrokeDashArray() {
        return this.strokeDashArray;
    }

    public BorderStyle(StrokeType strokeType, StrokeLineJoin strokeLineJoin, StrokeLineCap strokeLineCap, Double d, Double d2, double[] dArray) {
        this.strokeType = strokeType != null ? strokeType : StrokeType.CENTERED;
        this.strokeLineJoin = strokeLineJoin != null ? strokeLineJoin : StrokeLineJoin.MITER;
        this.strokeLineCap = strokeLineCap != null ? strokeLineCap : StrokeLineCap.BUTT;
        this.strokeMiterLimit = d != null ? d : 10.0;
        this.strokeDashOffset = d2 != null ? d2 : 0.0;
        this.strokeDashArray = (double[])(dArray != null ? dArray : null);
    }

    private BorderStyle() {
        this.strokeType = StrokeType.CENTERED;
        this.strokeLineJoin = StrokeLineJoin.MITER;
        this.strokeLineCap = StrokeLineCap.BUTT;
        this.strokeMiterLimit = 10.0;
        this.strokeDashOffset = 0.0;
        this.strokeDashArray = null;
    }

    void adjustForStrokeWidth(double d) {
        if (d > 1.0 && !this.adjusted) {
            if (this.strokeDashArray != null && this.strokeDashArray.length > 0) {
                double d2 = d - 1.0;
                int n = 0;
                while (n < this.strokeDashArray.length) {
                    int n2 = n++;
                    this.strokeDashArray[n2] = this.strokeDashArray[n2] * d2;
                }
            }
            this.adjusted = true;
        }
    }

    public String toString() {
        String string = "BorderStyle.NONE";
        if (this == SOLID) {
            string = "BorderStyle.SOLID";
        } else if (this != NONE) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("BorderStyle: ");
            stringBuilder.append((Object)this.strokeType);
            stringBuilder.append(", ");
            stringBuilder.append((Object)this.strokeLineJoin);
            stringBuilder.append(", ");
            stringBuilder.append((Object)this.strokeLineCap);
            stringBuilder.append(", ");
            stringBuilder.append(this.strokeMiterLimit);
            stringBuilder.append(", ");
            stringBuilder.append(this.strokeDashOffset);
            stringBuilder.append(", [");
            if (this.strokeDashArray != null) {
                for (int i = 0; i < this.strokeDashArray.length - 1; ++i) {
                    stringBuilder.append(this.strokeDashArray[i]);
                    stringBuilder.append(", ");
                }
                if (this.strokeDashArray.length > 0) {
                    stringBuilder.append(this.strokeDashArray[this.strokeDashArray.length - 1]);
                }
            }
            stringBuilder.append("]");
            string = stringBuilder.toString();
        }
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BorderStyle) {
            BorderStyle borderStyle = (BorderStyle)object;
            if (this.strokeType == borderStyle.strokeType && this.strokeLineJoin == borderStyle.strokeLineJoin && this.strokeLineCap == borderStyle.strokeLineCap && this.strokeMiterLimit == borderStyle.strokeMiterLimit && this.strokeDashOffset == borderStyle.strokeDashOffset) {
                if (this.strokeDashArray != null && borderStyle.strokeDashArray != null && this.strokeDashArray.length == borderStyle.strokeDashArray.length) {
                    return Arrays.equals(this.strokeDashArray, borderStyle.strokeDashArray);
                }
                return this.strokeDashArray == null && borderStyle.strokeDashArray == null;
            }
        }
        return false;
    }
}

