/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.generic.BranchHandle;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class InstructionHandle
implements Serializable {
    InstructionHandle next;
    InstructionHandle prev;
    Instruction instruction;
    protected int i_position = -1;
    private HashSet targeters;
    private HashMap attributes;
    private static InstructionHandle ih_list = null;

    public final InstructionHandle getNext() {
        return this.next;
    }

    public final InstructionHandle getPrev() {
        return this.prev;
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        if (instruction == null) {
            throw new ClassGenException("Assigning null to handle");
        }
        if (this.getClass() != BranchHandle.class && instruction instanceof BranchInstruction) {
            throw new ClassGenException("Assigning branch instruction " + instruction + " to plain handle");
        }
        if (this.instruction != null) {
            this.instruction.dispose();
        }
        this.instruction = instruction;
    }

    public Instruction swapInstruction(Instruction instruction) {
        Instruction instruction2 = this.instruction;
        this.instruction = instruction;
        return instruction2;
    }

    protected InstructionHandle(Instruction instruction) {
        this.setInstruction(instruction);
    }

    static final InstructionHandle getInstructionHandle(Instruction instruction) {
        if (ih_list == null) {
            return new InstructionHandle(instruction);
        }
        InstructionHandle instructionHandle = ih_list;
        ih_list = instructionHandle.next;
        instructionHandle.setInstruction(instruction);
        return instructionHandle;
    }

    protected int updatePosition(int n, int n2) {
        this.i_position += n;
        return 0;
    }

    public int getPosition() {
        return this.i_position;
    }

    void setPosition(int n) {
        this.i_position = n;
    }

    protected void addHandle() {
        this.next = ih_list;
        ih_list = this;
    }

    void dispose() {
        this.prev = null;
        this.next = null;
        this.instruction.dispose();
        this.instruction = null;
        this.i_position = -1;
        this.attributes = null;
        this.removeAllTargeters();
        this.addHandle();
    }

    public void removeAllTargeters() {
        if (this.targeters != null) {
            this.targeters.clear();
        }
    }

    public void removeTargeter(InstructionTargeter instructionTargeter) {
        this.targeters.remove(instructionTargeter);
    }

    public void addTargeter(InstructionTargeter instructionTargeter) {
        if (this.targeters == null) {
            this.targeters = new HashSet();
        }
        this.targeters.add(instructionTargeter);
    }

    public boolean hasTargeters() {
        return this.targeters != null && this.targeters.size() > 0;
    }

    public InstructionTargeter[] getTargeters() {
        if (!this.hasTargeters()) {
            return null;
        }
        InstructionTargeter[] instructionTargeterArray = new InstructionTargeter[this.targeters.size()];
        this.targeters.toArray(instructionTargeterArray);
        return instructionTargeterArray;
    }

    public String toString(boolean bl) {
        return Utility.format(this.i_position, 4, false, ' ') + ": " + this.instruction.toString(bl);
    }

    public String toString() {
        return this.toString(true);
    }

    public void addAttribute(Object object, Object object2) {
        if (this.attributes == null) {
            this.attributes = new HashMap(3);
        }
        this.attributes.put(object, object2);
    }

    public void removeAttribute(Object object) {
        if (this.attributes != null) {
            this.attributes.remove(object);
        }
    }

    public Object getAttribute(Object object) {
        if (this.attributes != null) {
            return this.attributes.get(object);
        }
        return null;
    }

    public Collection getAttributes() {
        return this.attributes.values();
    }

    public void accept(Visitor visitor) {
        this.instruction.accept(visitor);
    }
}

