/* 
 * Copyright 1999,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.log4j.appender;

import org.apache.log4j.helpers.FileHelper;
import org.apache.log4j.spi.LoggingEvent;

/**
 * @author <a href="mailto:simon_park_mail AT yahoo DOT co DOT uk">Simon Park</a>
 * @version 1.2
 */
final class OneShotStartupRoller extends AbstractRoller implements FileRollable {

  private boolean hasRunOnce = false;

  public OneShotStartupRoller(final TimeAndSizeRollingAppender rollingAppender,
      AppenderRollingProperties appenderRollingProperties) {
    super(rollingAppender, appenderRollingProperties);
  }

  public final boolean roll(final LoggingEvent loggingEvent) {
    if (this.hasRunOnce) {
      return false;
    }
    this.hasRunOnce = true;
    if (super.getProperties().shouldRollOnStartup()) {
      if (new FileHelper().isEmpty(super.getAppender().getIoFile())) {
        return false;
      }
      // TODO Use Log4J 1.2.15 getTimeStamp() instead of direct field access
      super.roll(loggingEvent.timeStamp);
      return true;
    }
    return false;
  }

}
