/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpQManager;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;

final class SnmpSendServer
extends Thread {
    private int intervalRange = 5000;
    private Vector readyPool;
    SnmpQManager snmpq = null;
    boolean isBeingDestroyed = false;

    public SnmpSendServer(ThreadGroup threadGroup, SnmpQManager snmpQManager) {
        super(threadGroup, "SnmpSendServer");
        this.snmpq = snmpQManager;
        this.start();
    }

    public synchronized void stopSendServer() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(5);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSendServer.class.getName(), "run", "Thread Started");
        }
        while (true) {
            try {
                do {
                    this.prepareAndSendRequest();
                } while (!this.isBeingDestroyed);
            }
            catch (Exception exception) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSendServer.class.getName(), "run", "Exception in send server", exception);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSendServer.class.getName(), "run", "Exiting... Fatal error");
                }
                throw threadDeath;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSendServer.class.getName(), "run", "Out of memory");
                continue;
            }
            catch (Error error) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSendServer.class.getName(), "run", "Got unexpected error", error);
                }
                throw error;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndSendRequest() {
        if (this.readyPool == null || this.readyPool.isEmpty()) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSendServer.class.getName(), "prepareAndSendRequest", "Blocking for inform requests");
            }
            this.readyPool = this.snmpq.getAllOutstandingRequest(this.intervalRange);
            if (this.isBeingDestroyed) {
                return;
            }
        } else if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSendServer.class.getName(), "prepareAndSendRequest", "Inform requests from a previous block left unprocessed. Will try again");
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSendServer.class.getName(), "prepareAndSendRequest", "List of inform requests to send : " + this.reqListToString(this.readyPool));
        }
        SnmpSendServer snmpSendServer = this;
        synchronized (snmpSendServer) {
            if (this.readyPool.size() < 2) {
                this.fireRequestList(this.readyPool);
                return;
            }
            while (!this.readyPool.isEmpty()) {
                SnmpInformRequest snmpInformRequest = (SnmpInformRequest)this.readyPool.lastElement();
                if (snmpInformRequest != null && snmpInformRequest.inProgress()) {
                    this.fireRequest(snmpInformRequest);
                }
                this.readyPool.removeElementAt(this.readyPool.size() - 1);
            }
            this.readyPool.removeAllElements();
        }
    }

    void fireRequest(SnmpInformRequest snmpInformRequest) {
        if (snmpInformRequest != null && snmpInformRequest.inProgress()) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSendServer.class.getName(), "fireRequest", "Firing inform request directly. -> " + snmpInformRequest.getRequestId());
            }
            snmpInformRequest.action();
        }
    }

    void fireRequestList(Vector vector) {
        while (!vector.isEmpty()) {
            SnmpInformRequest snmpInformRequest = (SnmpInformRequest)vector.lastElement();
            if (snmpInformRequest != null && snmpInformRequest.inProgress()) {
                this.fireRequest(snmpInformRequest);
            }
            vector.removeElementAt(vector.size() - 1);
        }
    }

    final String reqListToString(Vector vector) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(vector.size() * 100);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (SnmpInformRequest)enumeration.nextElement();
            stringBuffer.append("InformRequestId -> ");
            stringBuffer.append(((SnmpInformRequest)object).getRequestId());
            stringBuffer.append(" / Destination -> ");
            stringBuffer.append(((SnmpInformRequest)object).getAddress());
            stringBuffer.append(". ");
        }
        object = stringBuffer.toString();
        stringBuffer = null;
        return object;
    }
}

