/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util;

import com.zerog.common.io.NullInputStream;
import com.zerog.common.io.NullOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class DebugOutputConfig {
    public static final InputStream originalSTDIN = System.in;
    public static final PrintStream originalSTDOUT = System.out;
    public static final PrintStream originalSTDERR = System.err;
    public static final String CONSOLE_REDIRECT = "console";
    private static final String VAR_DELIMITER = "$";
    private static final String JAVA_PROP_PREFIX = "prop.";
    private static final String SYS_PROP_EXACTCASE_PREFIX = "lax.nl.env.exact_case.";
    private static final String userName = System.getProperty("user.name");
    private static final String osVersion = System.getProperty("os.version", "");
    private static final String osName = System.getProperty("os.name").toLowerCase();
    private static final boolean isMacOSX;
    private static final String MAC_LOG_FILE = "/var/tmp/console.log";
    private static final String MAC_103_LOG_FILE;
    private static final String[] SUPPORTED_PLATFORMS;
    public static File errFile;
    public static File outFile;

    public static void configStdInStdOutStdErrOnSupportedPlatforms() {
        String string = System.getProperty("lax.stdin.redirect", "").trim();
        String string2 = System.getProperty("lax.stdout.redirect", "").trim();
        String string3 = System.getProperty("lax.stderr.redirect", "").trim();
        boolean bl = true;
        boolean bl2 = true;
        if (isMacOSX) {
            if (string2.equalsIgnoreCase(CONSOLE_REDIRECT)) {
                if (osVersion.startsWith("10.3")) {
                    System.setProperty("lax.stdout.redirect", MAC_103_LOG_FILE);
                } else if (!osVersion.startsWith("10.4")) {
                    System.setProperty("lax.stdout.redirect", MAC_LOG_FILE);
                }
            }
        }
        if (isMacOSX) {
            if (string3.equalsIgnoreCase(CONSOLE_REDIRECT)) {
                if (osVersion.startsWith("10.3")) {
                    System.setProperty("lax.stderr.redirect", MAC_103_LOG_FILE);
                } else if (!osVersion.startsWith("10.4")) {
                    System.setProperty("lax.stderr.redirect", MAC_LOG_FILE);
                }
            }
        }
        for (int i = 0; i < SUPPORTED_PLATFORMS.length; ++i) {
            if (osName.indexOf(SUPPORTED_PLATFORMS[i]) == -1) continue;
            DebugOutputConfig.configStdInStdOutStdErr(string, string2, bl, string3, bl2);
            break;
        }
    }

    public static File stdErrFile() {
        return errFile;
    }

    public static File stdOutFile() {
        return outFile;
    }

    /*
     * Unable to fully structure code
     */
    public static void configStdInStdOutStdErr(String var0, String var1_1, boolean var2_2, String var3_3, boolean var4_4) {
        var5_5 = System.getProperty("INCLUDE_DEBUG", "").trim().equalsIgnoreCase("true");
        if (var5_5) {
            try {
                DebugOutputConfig.errFile = File.createTempFile("lax-", "-err.tmp");
                var3_3 = DebugOutputConfig.errFile.getAbsolutePath();
            }
            catch (IOException var6_6) {
                var6_6.printStackTrace();
            }
        }
        if (var5_5) {
            try {
                DebugOutputConfig.outFile = File.createTempFile("lax-", "-out.tmp");
                var1_1 = DebugOutputConfig.outFile.getAbsolutePath();
            }
            catch (IOException var6_7) {
                var6_7.printStackTrace();
            }
        }
        if (var0 == null) ** GOTO lbl-1000
        if (!var0.equals("")) {
            if (!var0.toLowerCase().equals("console")) {
                try {
                    System.setIn(new FileInputStream(var0));
                }
                catch (FileNotFoundException var6_9) {
                    Flexeraawb.ag("Error reading stdin from file: " + var0);
                }
            }
        } else lbl-1000:
        // 2 sources

        {
            System.setIn(new NullInputStream());
        }
        if (var1_1 == null) ** GOTO lbl-1000
        if (!var1_1.equals("")) {
            if (!var1_1.toLowerCase().equals("console")) {
                var1_1 = DebugOutputConfig.substituteVariables(var1_1);
                try {
                    var6_8 = new File(var1_1).getParentFile();
                    if (var6_8 != null) {
                        var6_8.mkdirs();
                    }
                    System.setOut(DebugOutputConfig.createPrintStream(var1_1, var2_2));
                }
                catch (Exception var6_10) {
                    try {
                        var7_12 = File.createTempFile("lax-", "-out.txt").getAbsolutePath();
                        Flexeraawb.ag("Error redirecting stdout to '" + var1_1 + "'. Output will be placed in file: " + var7_12);
                        System.setOut(DebugOutputConfig.createPrintStream(var7_12, false));
                    }
                    catch (IOException var7_13) {
                        Flexeraawb.au("Unable to create stdout output file.", var7_13);
                    }
                }
            }
        } else lbl-1000:
        // 2 sources

        {
            System.setOut(new PrintStream(new NullOutputStream()));
        }
        if (var3_3 == null) ** GOTO lbl-1000
        if (!var3_3.equals("")) {
            if (!var3_3.toLowerCase().equals("console")) {
                if (var3_3.equals(var1_1)) {
                    System.setErr(System.out);
                } else {
                    var3_3 = DebugOutputConfig.substituteVariables(var3_3);
                    try {
                        var6_8 = new File(var3_3).getParentFile();
                        if (var6_8 != null) {
                            var6_8.mkdirs();
                        }
                        System.setErr(DebugOutputConfig.createPrintStream(var3_3, var4_4));
                    }
                    catch (Exception var6_11) {
                        try {
                            var7_12 = File.createTempFile("lax-", "-err.txt").getAbsolutePath();
                            Flexeraawb.ag("Error redirecting stderr to '" + var3_3 + "'. Output will be placed in file: " + var7_12);
                            System.setErr(DebugOutputConfig.createPrintStream(var7_12, false));
                        }
                        catch (IOException var7_14) {
                            Flexeraawb.au("Unable to create stderr output file.", var7_14);
                        }
                    }
                }
            }
        } else lbl-1000:
        // 2 sources

        {
            System.setErr(new PrintStream(new NullOutputStream()));
        }
    }

    private static PrintStream createPrintStream(String string, boolean bl) throws FileNotFoundException {
        return new PrintStream(new FileOutputStream(string, bl));
    }

    public static String substituteVariables(String string) {
        String string2 = "";
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(VAR_DELIMITER, n)) > -1) {
            string2 = string2 + string.substring(n, n2);
            int n3 = string.indexOf(VAR_DELIMITER, n2 + 1);
            if (n3 > -1) {
                String string3 = string.substring(n2 + 1, n3);
                if (!string3.trim().equals("")) {
                    string2 = string2 + DebugOutputConfig.getVariable(string3);
                }
                n = n3 + 1;
                continue;
            }
            string2 = string2 + VAR_DELIMITER;
            n = n2 + 1;
        }
        string2 = string2 + string.substring(n);
        return string2;
    }

    public static String getVariable(String string) {
        block6: {
            block5: {
                if (string.equals("\\")) break block5;
                if (!string.equals("/")) break block6;
            }
            return System.getProperty("file.separator", "/");
        }
        if (string.toLowerCase().startsWith(JAVA_PROP_PREFIX)) {
            return System.getProperty(string.toLowerCase().substring(JAVA_PROP_PREFIX.length()), "");
        }
        if (string.toLowerCase().startsWith(SYS_PROP_EXACTCASE_PREFIX)) {
            return System.getProperty(string, "");
        }
        return System.getProperty(string.toLowerCase(), "");
    }

    /*
     * Unable to fully structure code
     */
    static {
        if (DebugOutputConfig.osName.indexOf("mac") == -1) ** GOTO lbl-1000
        if (DebugOutputConfig.osName.indexOf("x") != -1) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        DebugOutputConfig.isMacOSX = v0;
        DebugOutputConfig.MAC_103_LOG_FILE = "/Library/Logs/Console/" + DebugOutputConfig.userName + "/console.log";
        v1 = new String[26];
        v1[0] = "unix";
        v1[1] = "irix";
        v1[2] = "netbsd";
        v1[3] = "freebsd";
        v1[4] = "bsdi";
        v1[5] = "bsd";
        v1[6] = "unixware";
        v1[7] = "aix";
        v1[8] = "dg/ux";
        v1[9] = "dgux";
        v1[10] = "osf1";
        v1[11] = "linux";
        v1[12] = "machten";
        v1[13] = "nextstep";
        v1[14] = "rhapsody";
        v1[15] = "mac os x";
        v1[16] = "hp-ux";
        v1[17] = "hpux";
        v1[18] = "sunos";
        v1[19] = "solaris";
        v1[20] = "windows";
        v1[21] = "i5/os";
        v1[22] = "os/400";
        v1[23] = "as/400";
        v1[24] = "z/os";
        v1[25] = "os400";
        DebugOutputConfig.SUPPORTED_PLATFORMS = v1;
        DebugOutputConfig.errFile = null;
        DebugOutputConfig.outFile = null;
    }
}

