/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.jvm;

import com.zerog.util.jvm.JVMInformationRetrieverServer;
import com.zerog.util.jvm.ValidatorTimeoutException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class JVMInformationRetriever {
    private static final int JVM_TIMEOUT = 15000;
    public static final int SUCCESS_EXIT_CODE = 0;
    public static final int ERROR_EXIT_CODE = -1;
    public static final int CHECK_FAIL_EXIT_CODE = 1;
    public static final String FILTER_LIST_DELIMITER = " ";
    public static final int OP_VENDOR_CHECK = 1;
    public static final int OP_FILTER_CHECK = 2;
    public static final int OP_RETRIEVE_JAVA_HOME = 3;
    private String serverClassName;

    public JVMInformationRetriever() {
        this(JVMInformationRetrieverServer.class.getName());
    }

    public JVMInformationRetriever(String string) {
        this.serverClassName = string;
    }

    public boolean checkFilter(String string, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        vector2.add(string);
        vector2.addAll(vector);
        return this.retrieveInformation(string, 2, vector2) == 0;
    }

    public boolean checkVendor(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        vector.add(string2);
        return this.retrieveInformation(string, 1, vector) == 0;
    }

    public String getJavaHome(String string) {
        try {
            File file = File.createTempFile("java_home", ".tmp");
            file.deleteOnExit();
            Vector<String> vector = new Vector<String>();
            vector.add(file.getAbsolutePath());
            if (this.retrieveInformation(string, 3, vector) != 0) {
                throw new Exception();
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            file.delete();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int retrieveInformation(String string, int n, Vector vector) {
        int n2 = -1;
        File file = new File(string);
        if (file.exists()) {
            try {
                String string2 = new File(string).getAbsolutePath();
                String string3 = System.getProperty("java.class.path");
                Vector<String> vector2 = new Vector<String>();
                vector2.add(string2);
                vector2.add("-cp");
                vector2.add(string3);
                vector2.add(this.serverClassName);
                vector2.add(Integer.toString(n));
                if (vector != null) {
                    vector2.addAll(vector);
                }
                final Process process = Runtime.getRuntime().exec(vector2.toArray(new String[0]));
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
                thread.start();
                if (thread.isAlive()) {
                    thread.join(15000L);
                    if (thread.isAlive()) {
                        thread.interrupt();
                        throw new ValidatorTimeoutException();
                    }
                }
                n2 = process.exitValue();
            }
            catch (IOException iOException) {
                n2 = -1;
            }
            catch (InterruptedException interruptedException) {
                n2 = -1;
            }
        }
        return n2;
    }
}

