Option Explicit
'********************************************************************************
'*	Author: Benjamin Henriksen - bhenriksen@kpmg.dk                             *
'*	Purpose: Software inventory                                                 *
'*                                                                              *

'Disclaimer: Administrator(s) should validate and confirm that the  	
'script will not cause production issue(s) if executed on any production 	
'server they choose. We recommend testing this scripts in a non production 
'environment first before running on any production server. KPMG and 
'Microsoft are not liable for any production issues as a result of running 
'this script.

Const Version="2.63.20" '                                                          *
Const ScriptName="kscan.2.63.20.vbs"
'********************************************************************************

'********************************************************************************
'*Change log*********************************************************************
'********************************************************************************
'ToDo
'2.63.20
'SQL stability improvements backported from kscan
'added service name as well as display name to help debug targetted scans
'2.63.19
'Hyperv collects 4 files up from 1 as well as limiting columns for those files
'2.63.18
'Hyperv gets it's own subdirectory
'2.63.17
'SQL data collection via registry port
'2.63.16
'64/32 fix for arp only
'2.63.15
'bugfix to disabled services enabled sql mode
'2.63.12.2
'offline machine bugfix
'2.63.12.2
'bugfix
'2.63.12
'integration of Seattle changes in 2.55.12 with denmark changes in 2.63
'2.63
'Changed scriptName to include version
'Added possiblity to exclude servers from the ADlist, and do just workstations
'Skip MSIevents for Windows 2000
'Performance increase to evt()
'Performance increase to listadGrops, only one user lookup pr user.
'Added TimeZone Check
'Added a field to services (Clean exe)
'2.62
'Minor fix, when hardcoding username and password, AD extract did not function as expected.
'2.61
'Minor fix to listadusers and groups
'2.6
'If computername scanned seems to be an alias, the computername is now printed in lowercase. (Check OS file, for the real name)
'RealComputerName added
'Fixed minor bug in registryfunction
'Major change to the AD extract of computers, now includes more data (WhenCreated, etc)
'Script now accepts /local, the longer /server:%computername% is still accepted as well
'Fixed bug causing script to crash after scanning ~32000 servers (cint -> clng)
'Added Last, which shows who have loggedon to a given system
'Fix to FillServerArray function
'Status file removed
'Show msinstaller log
'Added local user and group extract
'added AD extracts via /listadusersandgroups
'added AD extracts via /listadgroups
'added AD extracts via /listadusers
'
'2.55.12
'Collect OCS version edition and channel.
'Collect OCS User and Server tables.
'
'2.55.11
'Collect Lync version edition and channel.
'
'2.55.10
'Added Product ID and Identifying Number (guid) to applications entries in add remove programs table
'
'2.55.9
'Added install date to operating system entry in add remove programs table
'
'2.55.8
'Added sccm, hyperv, and rdl scanning
'Tuned wmi calls for list processes and list services to cut down on network traffic
'
'2.55.7
'Added forest scan mode boolean that allows for scanning an entire forest instead of domain in ad mode
'
'2.55.6
'Added exchange version scanning for old versions of exchange 2k & 2k3 only
'
'2.55.5
'Updated min passes to 4
'
'2.55.4
'Included arp fix but left it disabled
'Changed min file size from 10 bytes to 2 bytes
'Added new PassMax variable set to 5 which ensures that no more than 5 passes will execute
'Updated PassLimit variable to 1 so that at least one pass will execute
'Updated AD age limit to 90 days
'Added OS to Applications file to prevent empty applications file bug.
'Scanning for sql but not services still gets sql data.
'Updated threads to 20
'
'2.55.3
'Modified current user to not raise an error.
'
'2.55.2
'Turned webshpere mq off
'
'2.55.1
'Added current user, last logged on user, and user folders collection.
'
'2.55
'Added model # and manufacturer, and systemenclosure information (Hardware output file CHANGED)
'Change script help/status files to start with #
'
'2.54
'Minor bug fix
'strComputer undefined error fixed, this error only happend when 2 functions
'returned an error and was trying to add to the Error log.
'
'2.53
'Change fileoutput from ASCII to unicode to allow special chars to be passed.
'Prior to this fix lines/applications with chineese or other special chars
'were dropped
'Empty applications files are deleted.
'Combined removed
'
'2.52
'Improved Errorhandling
'Added cluster module
'Major change to the WMI authentication method
'Script can now be argument overloaded to use different credentials  
'Mq check changed on request from Morten.										*
'Addition to WMI error message regarding firewalls and ports (Thanks Omer)      *
'Fixed missing quote in mq output
'Fixed carrige returns in localmq check
'Changed sql module, to use WMI for sql 2005+
'2.41
'Minor change to combine function
'2.4
'Bug fix, which fixes issue with missing carrige return in hardware output file *
'which prevented combine from working as expected.								*
'Added MQcheck functionality
'Changed sqlcheck to include "isclustered" (SQL 2k only)
'
'2.3                                                                            *
'Bug fix, Win2K support reimplemented(Win2kMode)                                *
'Implemented Detect WSHVersion function and Win2kMode (Global Var)              *
'Removed unnesssary quotes " from headers in combined files						*
'Impletmed a detect function which detects script renameing and print warning	*
'																				*
'2.2                                                                            *
'Bug fix, blank space in directory names cause combinefiles to fail             *
' only the combine function was modified in this release                        *
'2.1                                                                            *
'Bugfix, when scanning over 1000 computers, the status message did not show _   *
' correct indicators.															*
' Old [cut] Processing [" & lpad(I+1," ",3) [cut]                               *
' New [cut] Processing [" & lpad(I+1," ",5) [cut]                               *
'																				*
'2.0                                                                            *
'Now accepts /server:<server-to-scan>                                           *
'added MAC information to ip file.                                              *
'Added motherboard information for VMWARE identification                        *
'new Ping function, resolves language issues.                                   *
'remove the code that changed "." in filenames to _                             *
'New output format                                                              *
'CPU Load check                                                                 *
'The script can now scan multiple servers at a time.                            *
'********************************************************************************


'********************************************************************************
'********************************************************************************
'*THIS SECTION IS USED TO FILTER THE ADD/REMOVE PROGRAMS (ARP) RESULTS          *
'********************************************************************************
'********************************************************************************
'*Declare the variables to be used to filter for ARP application installations  *
'********************************************************************************
Dim bFilterArpResults   'Boolean to decide whether to filter ARP results or not *
Dim bFilterFound        'Boolean to track whether an ARP keyword is found       *
Dim strArpFilterTerms   'String of the ARP filter terms seperated by commas     *
                        'without spaces ("term1,term 2,term3")                  *
Dim strArpExcludeTerms  'Exclude entries with any of these keywords             *
                        'seperated by commas w/out spaces ("term1,term 2,term3")*
Dim arrArpFilterTerms   'Array for the filtered terms for ARP entries           *
Dim arrArpExcludeTerms  'Array for the ARP entry filtered terms to be excluded  *
Dim searchTerm          'individual search term to use in array loops           *
'********************************************************************************
'*Set the included/excluded keywords for ARP results                            *
'********************************************************************************
bFilterArpResults = False    'FALSE = Include all ARP entries to output file     *
'********************************************************************************
'********************************************************************************
'Keywords should be seperated by commas without spaces... "term1,term 2,term3"  *
'Spaces within a term ARE OK (ie. term 2)                                       *
'********************************************************************************
'                                                                               *
'********************************************************************************
'**************************** Included ARP keywords *****************************
'********************************************************************************
strArpFilterTerms = "Microsoft,citrix,vmware"
'NOT case sensitive ('microsoft' and 'MICROSOFT' both are the same)             *
'Will only write/output ARP entries that have one of these keywords AND         *
'do NOT have keywords from the excluded list below                              *
'********************************************************************************
'                                                                               *
'********************************************************************************
'**************************** Excluded ARP keywords *****************************
'********************************************************************************
strArpExcludeTerms = "security,hotfix,update,service pack,add-in,proof,.net framework,MUI,media player," & _
                        "silverlight,debug,windows live"
'NOT case sensitive ('microsoft' and 'MICROSOFT' both are the same)             *
'Leave empty with double quotes ---> "" if you do NOT have keywords to exclude  *
'strArpExcludeTerms = "" ---> (no entries excluded)                             *
'strArpExc... = "adobe,hotfix" (entries w/ adobe or hotfix not written to file) *
'********************************************************************************
'********************************************************************************
'********************************************************************************
'*END OF SECTION                                                                *
'********************************************************************************
'********************************************************************************



'********************************************************************************
'*This section is used to select what type of systems you want in your audit ****
'********************************************************************************
'*The settings below are very important IF you want to audit workstations       *
'*IF bOnlyIncludeServersFromAD is false, it will generate a list of sysetms     *
'*including both workstations and servers.                                      *
'*IF bOnlyCheckServers is True it will never audit a workstation no matter what *
'*AgeLimit, sets the MAX ComputerPassword Age, IF the password age is older than*
'*agelimit, it will be skipped.                                                 *
'*A computer account password is by default changed every 30 days (Win 2000+)   *
'********************************************************************************
Const bOnlyIncludeServersFromAD =FALSE  '                                       *
Const bOnlyIncludeWorkstationsFromAD =False	'									*
Const bOnlyCheckServers 		=FALSE  '                                       *
Const AgeLimit 					= 6500   	'                                       *
Const bScanForest               =FALSE  '                                       *
'********************************************************************************


'********************************************************************************
'*This section is used to select audit duration *********************************
'********************************************************************************
Const PassLimitMinutes			= 2880	'4320 	' Minimum minutes the script should run *
Const PassLimit					= 0		' Minimum passes the script should run  *
Const PassMax					= 5		' Max passes the script should run  *
'* Debugging                                                                    *
Const bDebug					= FALSE								'           *
Const WaitingTime				= 1' Waiting time, before window close (3000)   *
Const bRunMinimized				= TRUE ' Run minimized or maximised			    * 
Const BwaitOnReturn             = FALSE ' Can be us to enforce single thread    *
'********************************************************************************

'********************************************************************************
'*This section is used to define how gentle the script should be ****************
'*                                                                              *
'*IF CPULOADCheck is TRUE then                                                  *
'*MaxCPULoad is the max cpu on the box being autied (The remote server)         *
'********************************************************************************
Const MaxCPULoad				=95	  '                                         *
Const bCPULoadCheck				=TRUE '	                                        *
Const bCheckAdmin				=TRUE 'Check for admin acces (For debugging)    *
Const bIgnoreCheckAdmin			=TRUE 'IF Admin check fails, collect data anyway*
'********************************************************************************

'********************************************************************************
'*Settings in this sectrion, controls script execution and are only valid *******
'*For the host running the script, not for the systems being audited ************
'********************************************************************************
Const MaxThreads				= 30'Maximum number for servers to scan at once *
Const MaxHostCPU				= 70'MAX load on the host executing cheksrv.vbs *
'********************************************************************************

'********************************************************************************
'*This section is used to Toggle script "modules" *******************************
'********************************************************************************
Const bCheckCPU					=TRUE'Collect CPU data                          *
Const bCheckHardware			=TRUE'Collect motherboard and bios information  *
Const bCheckShares				=FALSE'Collect Share data                       *
Const bCheckProcesses			=FALSE'Collect process data                      *
Const bCheckIP 					=FALSE'Collect IP information                    *
Const bCheckServices			=TRUE'Collect data abount installed services    *
Const bCheckLoggedonUsers		=FALSE'Collect data abount users loggedon locally*
Const bCheckMQ					=FALSE'Collect MQ information of WEBSPHERE MQ    *
Const bListLocalUsersAndGroups	=FALSE 'collect local user and group information*
Const bByPassGroupChecksOnPDC   =FALSE ' Disable all user checks on PDCs          *
Const bCheckEvtLog				=FALSE 'collect MSIinstaller info 				*
Const bIgnoreMSIFailed			=FALSE' Skip "Fail" from MSIINstaller info    *
'*The Checks below can only be enabled of IF bCheckServices is TRUE  		    *
Const bSQLCheck					=TRUE'                                          *
Const bClusterCheck				=TRUE'
Const bCheckCurrentUser  = FALSE  ' Collect current user                        *
Const bCheckUsers        = TRUE  ' Collect last user login ID                  *
Const bCheckUserFolders  = FALSE  ' Collect user info from c:\users folders     *
Const bExchangeCheck     = TRUE  ' Collect exchange version info for 2k & 2k3
Const bSCCMCheck         = FALSE  ' Collect SCCM Contents
Const bVMCheck           = TRUE  ' Collect VM data for target hyper-v host
Const bRDLCheck          = TRUE  ' Collect remote desktop and terminal services licensing data
Const bGetProductIds     = FALSE  ' Collect Product IDs for ARP entries. This is slow.
Dim bLyncRegCheck
bLyncRegCheck            = TRUE  ' Collect Lync Registry Keys which indicate edition, etc;
Dim bOCSCheck
bOCSCheck                = FALSE  ' Collect OCS User and Server tables.
'********************************************************************************

'********************************************************************************
'*Settings up WMI Connection                                                 ****
'*      																     ****
'Hardcode here if you want to run the script, against serverlist.txt            *
'With a set of credentials different from the once executing the script
Dim strUser, strPassword, strDomain,strSQLUser,strSqlPassword
strUser="notset"
strPassword="notset"
strDomain="notset"
'Only for sql 2000 and below!!
strSQLUser="notset"
strSqlPassword="notset"
'*     
'********************************************************************************


 
'********************************************************************************
'*Setings below should NOT be changed *******************************************
'********************************************************************************
Const prefix 		    		="_KPMG_" 		'File prefix
Const OutputFolder 				= "KPMG_Output"	'Name of the output folder.
Const BytesNeeded  				= 2 			'Min size to reutrn ok
Const cStatusFile 				= "#KPMG_Status.txt" 'Status file name
Const cWMIHelpFile			    = "#WMI_HelpFile.txt"'WMI Help file
Dim quote									
Quote=chr(34)

'Creating File Header
Dim sFileHeader
sFileHeader = "###----------------------------------------" & VbCrLf _
&	          "### KPMG Software Audit Script V" & Version & VbCrLf _
&             "### Date:" & Date & VbCrLf _
&             "### Time:" & Time & VbCrLf _
&             "###----------------------------------------" & VbCrLf
'********************************************************************************'

'********************************************************************************
'*Declarations Global Vars and constants                                        *
'********************************************************************************
Dim ArrServerName()' Global Array for holding the list of servers to scan       *
Dim Pass 		'Number of times the script has cycled through the serverlist   *
Dim OutPutPath 	'OutPutPath to output folder                                    *
Dim FullPath	'Path to the folder where the script is located.                *
Dim StartTime  	'Used to calculate hours since execution.                       *
Dim ScriptMode 	'Holds script run mode.                                         *
Dim Win2kMode   ' Sets 2kMode													*
'*                                                                              *
Dim  intOffline, intDone,intError, intLoad 'Vars for statistics                 *
'*                                                                              *
Const WindowMinimized	= 7 ' Setting to run windows minimized					*
Const WindowMaximized	= 3 ' Setting to run windows maximized	        		*
'*                                                                              *
Const ForReading 		= 1 			'Consts for file operations             *
Const ForWriting 		= 2 			'Consts for file operations             *
Const ForAppending 		= 8 			'Consts for file operations             *
Const OverwriteExisting = True 			'Consts for file operations             *
Const PktPrivacy        = 6				'Const for WMI connection				*			
Const wbemAuthenticationLevelPkt= 6		'Const for WMI connection				*			
Dim objSWbemLocator, objswbemService, objSWbemServiceDefault, objReg 'For WMI   *
Dim strRealComputerName					' Holds the servers "real" name
Dim dicUserList ' USER list for ad loockup
set dicUserList = CreateObject("Scripting.Dictionary")'

Dim strUserHeader
strUserHeader=quote & "UserName" & quote & ";" & quote & "Description" & quote & ";" & quote & "ObjectClass" & Quote & ";" & quote & "DisplayName" & quote & ";" & quote & "GivenName" & quote & ";" & Quote & "SirName" & Quote & ";" _
			& quote & "PwdLastSet" & quote & ";" & quote & "LastLogonTimeStamp" & Quote & ";" & Quote & "PasswordRequired" & quote & ";" & Quote & "AccountDisabled" & quote & ";" & Quote & "PasswordExpired" & Quote _
			& ";" & quote & "DistinguishedName" & quote & ";" & quote & "WhenCreated" & Quote & ";" & Quote & "WhenChanged" & Quote & ";" & Quote & "LockOut" & Quote
Dim strGroupHeader
strGroupHeader=quote & "GroupName" & quote & ";" & quote & "GroupDescription" & quote & ";" & quote & "GroupObjectClass" & quote & ";" & quote & "GroupType" & quote & ";" & quote & "GroupDN" & quote & ";" & Quote & "GroupWhenCreated" & Quote _			
			& ";" & quote & "GroupWhenChanged" & quote 
'********************************************************************************

Function Q(str)
	Q=quote & str & quote
End function

'********************************************************************************
Function ConnectWMI(strComputer)
	on Error Resume next
	Err.clear	
	Set objSWbemLocator = CreateObject("WbemScripting.SWbemLocator")
	objSWbemLocator.Security_.AuthenticationLevel = wbemAuthenticationLevelPkt
	if (strUser<>"notset") and (strpassword<>"notset") and (strDomain<>"notset") then 
		Set objSWbemService = objSWbemLocator.ConnectServer(strComputer,"root\cimv2",strUser,strPassword,"MS_409","ntlmdomain:" + strDomain)
		if Err <> 0 then
			WmiError strComputer,"Exception in ConnectWMI1:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
			wscript.echo "Exiting..."
			wscript.quit
		End if
		Set objSWbemServiceDefault = objSWbemLocator.ConnectServer(strComputer,"root\default",strUser,strPassword,"MS_409","ntlmdomain:" + strDomain)
		if Err <> 0 then
			WmiError strComputer,"Exception in ConnectWMI2:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
			wscript.echo "Exiting..."
			wscript.quit
		End if
		Set objReg= objSWbemLocator.ConnectServer(strComputer,"\root\default:StdRegProv",strUser,strPassword,"MS_409","ntlmdomain:" + strDomain)	
		if err <> 0 then
			WmiError strComputer,"Exception in ConnectWMI3, StdRegProv:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
		End if
			
	Else 
		Set objSWbemService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")	
		if Err <> 0 then
			WmiError strComputer,"Exception in ConnectWMI4:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
			wscript.echo "Exiting..."
			wscript.quit
		End if

		Set objSWbemServiceDefault = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\default")
		if Err <> 0 then
			WmiError strComputer,"Exception in ConnectWMI5:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
			wscript.echo "Exiting..."
			wscript.quit
		End if
			
		Set objReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & strComputer & "\root\default:StdRegProv")
		if err <> 0 then
			err.clear
			Set objReg=GetObject("winmgmts:{impersonationLevel=impersonate,authenticationLevel=pktPrivacy}!\\" & strComputer & "\root\default:StdRegProv")
			if err <> 0 then
					WmiError strComputer,"Exception in ConnectWMI6, StdRegProv:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
			End if
		End if
	End if
	
End Function
'********************************************************************************
Function GetForeignCM (strSID)
	on error Resume Next
	Select Case strSID
		Case "S-1-0"
			GetForeignCM = quote & "Null Authority" & quote & ";" & quote & "Description: An identifier authority." & Quote
		Case "S-1-0-0"
			GetForeignCM = quote & "Nobody" & quote & ";" & quote & "No security principal." & Quote
		Case "S-1-1"
			GetForeignCM = quote & "World Authority" & quote & ";" & quote & "An identifier authority." & Quote
		Case "S-1-1-0"
			GetForeignCM = quote & "Everyone" & quote & ";" & quote & "A group that includes all users, even anonymous users and guests. Membership is controlled by the operating system." & Quote
		Case "S-1-2"
			GetForeignCM = quote & "Local Authority" & quote & ";" & quote & "An identifier authority." & Quote	
		Case "S-1-2-0"
			GetForeignCM = quote & "Local" & quote & ";" & quote & "A group that includes all users who have logged on locally." & Quote
		Case "S-1-2-1"
			GetForeignCM = quote & "Console Logon" & quote & ";" & quote & "A group that includes users who are logged on to the physical console." & Quote
		Case "S-1-3"
			GetForeignCM = quote & "Creator Authority" & quote & ";" & quote & "An identifier authority." & Quote
		Case "S-1-3-0"
			GetForeignCM = quote & "Creator Owner" & quote & ";" & quote & "A placeholder in an inheritable access control entry (ACE). When the ACE is inherited, the system replaces this SID with the SID for the object's creator." & Quote
		Case "S-1-3-1"
			GetForeignCM = quote & "Creator Group" & quote & ";" & quote & "A placeholder in an inheritable ACE. When the ACE is inherited, the system replaces this SID with the SID for the primary group of the object's creator. The primary group is used only by the POSIX subsystem." & Quote
		Case "S-1-3-2"
			GetForeignCM = quote & "Creator Owner Server" & quote & ";" & quote & "This SID is not used in Windows 2000." & Quote
		Case "S-1-3-3"
			GetForeignCM = quote & "Creator Group Server" & quote & ";" & quote & "This SID is not used in Windows 2000." & Quote
		Case "S-1-3-4"
			GetForeignCM = quote & "Owner Rights" & quote & ";" & quote & "A group that represents the current owner of the object. When an ACE that carries this SID is applied to an object, the system ignores the implicit READ_CONTROL and WRITE_DAC permissions for the object owner." & Quote
		Case "S-1-4"
			GetForeignCM = quote & "Non-unique Authority" & quote & ";" & quote & "An identifier authority." & Quote
		Case "S-1-5"
		  GetForeignCM = quote & "NT Authority" & quote & ";" & quote & "An identifier authority." & Quote
		Case "S-1-5-1"
		  GetForeignCM = quote & "Dialup" & quote & ";" & quote & "A group that includes all users who have logged on through a dial-up connection. Membership is controlled by the operating system." & Quote
		Case "S-1-5-2"
		  GetForeignCM = quote & "Network" & quote & ";" & quote & "A group that includes all users that have logged on through a network connection. Membership is controlled by the operating system." & Quote
		Case "S-1-5-3"
		  GetForeignCM = quote & "Batch" & quote & ";" & quote & "A group that includes all users that have logged on through a batch queue facility. Membership is controlled by the operating system." & Quote
		Case "S-1-5-4"
		  GetForeignCM = quote & "Interactive" & quote & ";" & quote & "A group that includes all users that have logged on interactively. Membership is controlled by the operating system." & Quote
		Case "S-1-5-5-X-Y"
		  GetForeignCM = quote & "Logon Session" & quote & ";" & quote & "A logon session. The X and Y values for these SIDs are different for each session." & Quote
		Case "S-1-5-6"
		  GetForeignCM = quote & "Service" & quote & ";" & quote & "A group that includes all security principals that have logged on as a service. Membership is controlled by the operating system." & Quote
		Case "S-1-5-7"
		  GetForeignCM = quote & "Anonymous" & quote & ";" & quote & "A group that includes all users that have logged on anonymously. Membership is controlled by the operating system." & Quote
		Case "S-1-5-8"
		  GetForeignCM = quote & "Proxy" & quote & ";" & quote & "This SID is not used in Windows 2000." & Quote
		Case "S-1-5-9"
		GetForeignCM = quote & "Enterprise Domain Controllers" & quote & ";" & quote & "A group that includes all domain controllers in a forest that uses an Active Directory directory service. Membership is controlled by the operating system." & Quote
		Case "S-1-5-10"
		  GetForeignCM = quote & "Principal Self" & quote & ";" & quote & "A placeholder in an inheritable ACE on an account object or group object in Active Directory. When the ACE is inherited, the system replaces this SID with the SID for the security principal who holds the account." & Quote
		Case "S-1-5-11"
		  GetForeignCM = quote & "Authenticated Users" & quote & ";" & quote & "A group that includes all users whose identities were authenticated when they logged on. Membership is controlled by the operating system." & Quote
		Case "S-1-5-12"
		  GetForeignCM = quote & "Restricted Code" & quote & ";" & quote & "This SID is reserved for future use." & Quote
		Case "S-1-5-13"
		  GetForeignCM = quote & "Terminal Server Users" & quote & ";" & quote & "A group that includes all users that have logged on to a Terminal Services server. Membership is controlled by the operating system." & Quote
		Case "S-1-5-14"
		  GetForeignCM = quote & "Remote Interactive Logon" & quote & ";" & quote & "A group that includes all users who have logged on through a terminal services logon." & Quote
		Case "S-1-5-15"
		  GetForeignCM = quote & "This Organization" & quote & ";" & quote & "A group that includes all users from the same organization. Only included with AD accounts and only added by a Windows Server 2003 or later domain controller." & Quote
		Case "S-1-5-17"
		  GetForeignCM = quote & "This Organization" & quote & ";" & quote & "An account that is used by the default Internet Information Services (IIS) user." & Quote
		Case "S-1-5-18"
		  GetForeignCM = quote & "Local System" & quote & ";" & quote & "A service account that is used by the operating system." & Quote
		Case "S-1-5-19"
		  GetForeignCM = quote & "NT Authority" & quote & ";" & quote & "Local Service" & Quote
		Case "S-1-5-20"
		  GetForeignCM = quote & "NT Authority" & quote & ";" & quote & "Network Service" & Quote
		Case "S-1-5-21domain-500"
		  GetForeignCM = quote & "Administrator" & quote & ";" & quote & "A user account for the system administrator. By default, it is the only user account that is given full control over the system." & Quote
		Case "S-1-5-21domain-501"
		  GetForeignCM = quote & "Guest" & quote & ";" & quote & "A user account for people who do not have individual accounts. This user account does not require a password. By default, the Guest account is disabled." & Quote
		Case "S-1-5-21domain-502"
		  GetForeignCM = quote & "KRBTGT" & quote & ";" & quote & "A service account that is used by the Key Distribution Center (KDC) service." & Quote
		Case "S-1-5-21domain-512"
		  GetForeignCM = quote & "Domain Admins" & quote & ";" & quote & "A global group whose members are authorized to administer the domain. By default, the Domain Admins group is a member of the Administrators group on all computers that have joined a domain, including the domain controllers. Domain Admins is the default owner of any object that is created by any member of the group." & Quote
		Case "S-1-5-21domain-513"
		  GetForeignCM = quote & "Domain Users" & quote & ";" & quote & "A global group that, by default, includes all user accounts in a domain. When you create a user account in a domain, it is added to this group by default." & Quote
		Case "S-1-5-21domain-514"
		  GetForeignCM = quote & "Domain Guests" & quote & ";" & quote & "A global group that, by default, has only one member, the domain's built-in Guest account." & Quote
		Case "S-1-5-21domain-515"
		  GetForeignCM = quote & "Domain Computers" & quote & ";" & quote & "A global group that includes all clients and servers that have joined the domain." & Quote
		Case "S-1-5-21domain-516"
		  GetForeignCM = quote & "Domain Controllers" & quote & ";" & quote & "A global group that includes all domain controllers in the domain. New domain controllers are added to this group by default." & Quote
		Case "S-1-5-21domain-517"
		  GetForeignCM = quote & "Cert Publishers" & quote & ";" & quote & "A global group that includes all computers that are running an enterprise certification authority. Cert Publishers are authorized to publish certificates for User objects in Active Directory." & Quote
		Case "S-1-5-21root domain-518"
		  GetForeignCM = quote & "Schema Admins" & quote & ";" & quote & "A universal group in a native-mode domain, a global group in a mixed-mode domain. The group is authorized to make schema changes in Active Directory. By default, the only member of the group is the Administrator account for the forest root domain." & Quote
		Case "S-1-5-21root domain-519"
		  GetForeignCM = quote & "Enterprise Admins" & quote & ";" & quote & "A universal group in a native-mode domain,a global group in a mixed-mode domain. The group is authorized to make forest-wide changes in Active Directory, such as adding child domains. By default, the only member of the group is the Administrator account for the forest root domain." & Quote
		Case "S-1-5-21domain-520"
		  GetForeignCM = quote & "Group Policy Creator Owners" & quote & ";" & quote & "A global group that is authorized to create new Group Policy objects in Active Directory. By default, the only member of the group is Administrator." & Quote
		Case "S-1-5-21domain-553"
		  GetForeignCM = quote & "RAS and IAS Servers" & quote & ";" & quote & "A domain local group. By default, this group has no members. Servers in this group have Read Account Restrictions and Read Logon Information access to User objects in the Active Directory domain local group." & Quote
		Case "S-1-5-32-544"
		  GetForeignCM = quote & "Administrators" & quote & ";" & quote & "A built-in group. After the initial installation of the operating system, the only member of the group is the Administrator account. When a computer joins a domain, the Domain Admins group is added to the Administrators group. When a server becomes a domain controller, the Enterprise Admins group also is added to the Administrators group." & Quote
		Case "S-1-5-32-545"
		  GetForeignCM = quote & "Users" & quote & ";" & quote & "A built-in group. After the initial installation of the operating system, the only member is the Authenticated Users group. When a computer joins a domain, the Domain Users group is added to the Users group on the computer." & Quote
		Case "S-1-5-32-546"
		  GetForeignCM = quote & "Guests" & quote & ";" & quote & "A built-in group. By default, the only member is the Guest account. The Guests group allows occasional or one-time users to log on with limited privileges to a computer's built-in Guest account." & Quote
		Case "S-1-5-32-547"
		  GetForeignCM = quote & "Power Users" & quote & ";" & quote & "A built-in group. By default, the group has no members. Power users can create local users and groups,modify and delete accounts that they have created,and remove users from the Power Users, Users, and Guests groups. Power users also can install programs,create, manage, and delete local printers,and create and delete file shares." & Quote
		Case "S-1-5-32-548"
		  GetForeignCM = quote & "Account Operators" & quote & ";" & quote & "A built-in group that exists only on domain controllers. By default, the group has no members. By default, Account Operators have permission to create, modify, and delete accounts for users, groups, and computers in all containers and organizational units of Active Directory except the Builtin container and the Domain Controllers OU. Account Operators do not have permission to modify the Administrators and Domain Admins groups, nor do they have permission to modify the accounts for members of those groups." & Quote
		Case "S-1-5-32-549"
		  GetForeignCM = quote & "Server Operators" & quote & ";" & quote & "A built-in group that exists only on domain controllers. By default, the group has no members. Server Operators can log on to a server interactively,create and delete network shares,start and stop services,back up and restore files,format the hard disk of the computer,and shut down the computer." & Quote
		Case "S-1-5-32-550"
		  GetForeignCM = quote & "Print Operators" & quote & ";" & quote & "A built-in group that exists only on domain controllers. By default, the only member is the Domain Users group. Print Operators can manage printers and document queues." & Quote
		Case "S-1-5-32-551"
		  GetForeignCM = quote & "Backup Operators" & quote & ";" & quote & "A built-in group. By default, the group has no members. Backup Operators can back up and restore all files on a computer, regardless of the permissions that protect those files. Backup Operators also can log on to the computer and shut it down." & Quote
		Case "S-1-5-32-552"
		  GetForeignCM = quote & "Replicators" & quote & ";" & quote & "A built-in group that is used by the File Replication service on domain controllers. By default, the group has no members. Do not add users to this group." & Quote
		Case "S-1-5-64-10"
		  GetForeignCM = quote & "NTLM Authentication" & quote & ";" & quote & "A SID that is used when the NTLM authentication package authenticated the client"
		Case "S-1-5-64-14"
		  GetForeignCM = quote & "SChannel Authentication" & quote & ";" & quote & "A SID that is used when the SChannel authentication package authenticated the client." & Quote
		Case "S-1-5-64-21"
		  GetForeignCM = quote & "Digest Authentication" & quote & ";" & quote & "A SID that is used when the Digest authentication package authenticated the client." & Quote
		Case "S-1-5-80"
		  GetForeignCM = quote & "NT Service" & quote & ";" & quote & "An NT Service account prefix"
		Case "S-1-16-0"
		  GetForeignCM = quote & "Untrusted Mandatory Level" & quote & ";" & quote & "An untrusted integrity level. Note Added in Windows Vista and Windows Server 2008"
		  'Note Added in Windows Vista and Windows Server 2008
		Case "S-1-16-4096"
		  GetForeignCM = quote & "Low Mandatory Level" & quote & ";" & quote & "A low integrity level." & Quote
		  'Note Added in Windows Vista and Windows Server 2008
		Case "S-1-16-8192"
		  GetForeignCM = quote & "Medium Mandatory Level" & quote & ";" & quote & "A medium integrity level." & Quote
		  'Note Added in Windows Vista and Windows Server 2008
		Case "S-1-16-8448"
		  GetForeignCM = quote & "Medium Plus Mandatory Level" & quote & ";" & quote & "A medium plus integrity level." & Quote
		  'Note Added in Windows Vista and Windows Server 2008
		Case "S-1-16-12288"
		  GetForeignCM = quote & "High Mandatory Level" & quote & ";" & quote & "A high integrity level." & Quote
		  'Note Added in Windows Vista and Windows Server 2008
		Case "S-1-16-16384"
		  GetForeignCM = quote & "System Mandatory Level" & quote & ";" & quote & "A system integrity level." & Quote

		  'Note Added in Windows Vista and Windows Server 2008
		Case "S-1-16-20480"
		  GetForeignCM = quote & "Protected Process Mandatory Level" & quote & ";" & quote & "A protected-process integrity level." & Quote

		  'Note Added in Windows Vista and Windows Server 2008
		Case "S-1-16-28672"
		  GetForeignCM = quote & "Secure Process Mandatory Level" & quote & ";" & quote & "A secure process integrity level." & Quote

		  'Note Added in Windows Vista and Windows Server 2008
		Case "S-1-5-80-0"
		  GetForeignCM = quote & "All Services" & quote & ";" & quote & "A group that includes all service processes that are configured on the system. Membership is controlled by the operating system." & Quote
		Case "S-1-5-32-554"
		  GetForeignCM = quote & "BUILTIN\Pre-Windows 2000 Compatible Access" & quote & ";" & quote & "An alias added by Windows 2000. A backward compatibility group which allows read access on all users and groups in the domain." & Quote
		Case "S-1-5-32-555"
		  GetForeignCM = quote & "BUILTIN\Remote Desktop Users" & quote & ";" & quote & "An alias. Members in this group are granted the right to logon remotely." & Quote
		Case "S-1-5-32-556"
		  GetForeignCM = quote & "BUILTIN\Network Configuration Operators" & quote & ";" & quote & "An alias. Members in this group can have some administrative privileges to manage configuration of networking features." & Quote
		Case "S-1-5-32-557"
		  GetForeignCM = quote & "BUILTIN\Incoming Forest Trust Builders" & quote & ";" & quote & "An alias. Members of this group can create incoming, one-way trusts to this forest." & Quote
		Case "S-1-5-32-558"
		  GetForeignCM = quote & "BUILTIN\Performance Monitor Users" & quote & ";" & quote & "An alias. Members of this group have remote access to monitor this computer." & Quote
		Case "S-1-5-32-559"
		  GetForeignCM = quote & "BUILTIN\Performance Log Users" & quote & ";" & quote & "An alias. Members of this group have remote access to schedule logging of performance counters on this computer." & Quote
		Case "S-1-5-32-560"
		  GetForeignCM = quote & "BUILTIN\Windows Authorization Access Group" & quote & ";" & quote & "An alias. Members of this group have access to the computed tokenGroupsGlobalAndUniversal attribute on User objects." & Quote
		Case "S-1-5-32-5612"
		  GetForeignCM = quote & "BUILTIN\Terminal Server License Servers" & quote & ";" & quote & "An alias. A group for Terminal Server License Servers. When Windows Server 2003 Service Pack 1 is installed, a new local group is created." & Quote
		Case "S-1-5-32-562"
		  GetForeignCM = quote & "BUILTIN\Distributed COM Users" & quote & ";" & quote & "An alias. A group for COM to provide computerwide access controls that govern access to all call, activation, or launch requests on the computer." & Quote
	End select
End function
 '********************************************************************************
Function ListLocalUsers(strComputer)
'List local users uses WMI to list users
	on error Resume Next
	Dim strSystemRole
	Wscript.Echo "------- Listing Local Users From " & strComputer & " -------"
	strSystemRole=GetSystemRole(strComputer)
	IF instr(strSystemRole,"Domain") > 0 Then
		wscript.echo "Not lising local users since " & strComputer & " is a " & strSystemRole
		exit function
	End if
	
	Dim ColItems, objItem
	Dim objFSO, objFile, SOutputFile 	'Filesystem vars.
	Set colItems = objSWbemService.ExecQuery ("Select * from Win32_UserAccount Where LocalAccount = True and SidType=1")
	if err<>0 and bdebug then
		wscript.echo strComputer,"Exception in ListUsers:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf		
	Else	
		Set objFSO = CreateObject("Scripting.FileSystemObject")
		sOutPutFile = StrComputer & prefix & "LocalUsers.txt"
		DeleteFile(OutPutPath & sOutPutFile) 'Delete File to avoid create/Overwrite issues
		Set objFile = objFSO.CreateTextFile(OutPutPath & sOutPutFile, ForAppending, TRUE) 
		
		For Each objItem in colItems 
			objFile.WriteLine showLocalUser(strComputer,objItem.Name)
			WScript.StdOut.Write "."
		Next 
		'objFile.Write "Extract completed succesfully" & vbCrLf
		objFile.Close
		WScript.StdOut.WriteBlankLines(1)
	End if
End Function ' ListLocalUsers
'********************************************************************************
'********************************************************************************
Function ShowLocalUser	(strComputer,StrUser)
	on error Resume Next
	Dim objItem, objUser,tst, arrTemp,strLastLogon, colITems
	Set ColItems=objSWbemService.ExecQuery ("Select * from Win32_UserAccount Where LocalAccount = True and SidType=1 and name='" & strUser &"'")
	if err<>0 and bdebug then
				wscript.echo strComputer,"Exception in ShowLocalUser:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf		
	Else
		dim objProperty
		For Each objItem in colItems 
			Set objUser = GetObject("WinNT://" & strComputer & "/" & objItem.Name & ",user")
			strLastLogon = objUser.LastLogin
			If Err <> 0 Then
				strLastLogon = "Never"
			End If 
			IF instr(objItem.Caption,"\") > 0 Then
				arrTemp=split(objItem.Caption,"\")
				ShowLocalUser=quote & arrTemp(1) & quote &";" & quote & strComputer & quote & ";" & quote & strRealComputerName & quote & ";" & quote & objItem.AccountType & quote & ";" & Quote & objItem.Description  & Quote & ";" & Quote & objItem.Disabled & Quote &";" & Quote & objItem.Domain & quote & ";" & _
				quote & objItem.Lockout & Quote & ";" & quote & objItem.Name & Quote & ";" & quote & objItem.PasswordChangeable & Quote & ";" & Quote & objItem.PasswordExpires & Quote & ";" & _
				Quote & objItem.PasswordRequired & quote & ";" & Quote & objItem.SID & quote & ";" & Quote & SidType(objItem.SIDType) & quote & ";" & Quote &  objItem.Status & quote & ";" & Quote &  strLastLogon 	& quote & ";" & _
				Quote & DateAdd("s", objUser.PasswordAge * -1, Now) & quote & ";" & Quote & objUser.PasswordMinimumLength & Quote & ";" & Quote & objItem.LocalAccount & Quote
			Else
				ShowLocalUser= quote & objItem.Caption	 & quote &";" & quote & strComputer & quote & ";" & quote & strRealComputerName & quote &  ";" & quote & objItem.AccountType & quote & ";" & Quote & objItem.Description  & Quote & ";" & Quote & objItem.Disabled & Quote &";" & Quote & objItem.Domain & quote & ";" & _
				quote & objItem.Lockout & Quote & ";" & quote & objItem.Name & Quote & ";" & quote & objItem.PasswordChangeable & Quote & ";" & Quote & objItem.PasswordExpires & Quote & ";" & _
				Quote & objItem.PasswordRequired & quote & ";" & Quote & objItem.SID & quote & ";" & Quote & SidType(objItem.SIDType) & quote & ";" & Quote &  objItem.Status & quote & ";" & Quote &  strLastLogon  & quote & ";" & _
				Quote & DateAdd("s", objUser.PasswordAge * -1, Now) & quote & ";" & Quote & objUser.PasswordMinimumLength & Quote & ";" & Quote & objItem.LocalAccount & Quote
			end if
			set objUser = Nothing 
		Next
	End if
End Function
'********************************************************************************

'********************************************************************************
Function ListLocalGroupMembers(strComputer,strInputString)
'List the members of a group
	on error Resume Next
	Dim ColItems, objItem, objUser,ColUsers
	Dim arrTemp, I, strGroupName
	arrTemp=split(strInputString,";")
	strGroupName=arrTemp(0)
	Set ColItems = GetObject("WinNT://" & strComputer & "/" & strGroupName)
	if err<>0 and bdebug then
		wscript.echo strComputer,"Exception in ListLocalGroupMembers:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf		
	Else
		I=0
		for each objItem in ColItems.Members		
			WScript.StdOut.Write "."
			I=I+1
			ListLocalGroupMembers = ListLocalGroupMembers & strInputString & ";" & replace(objITem.adspath,"WinNT://","") & vbCrLf		
		Next
		IF I=0 then
			'Group is empty
			ListLocalGroupMembers = strInputString & ";" & quote & "Empty" & quote & vbCrLf
		End if
	End if
End Function
'********************************************************************************

'********************************************************************************
Function ListLocalGroups(strComputer)
	on error Resume Next
	Wscript.Echo "-------  Listing LocalGroups From " & strComputer & " -------"
	
	Dim ColItems, objItem, objUser
	Dim strTemp, I
	Dim objFSO, objFile, SOutputFile 	'Filesystem vars.
	Set colItems = objSWbemService.ExecQuery ("Select * from Win32_Group  Where LocalAccount = True")
	if err<>0 and bdebug then
		wscript.echo strComputer,"Exception in ListLocalGroups:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf		
	Else
		Set objFSO = CreateObject("Scripting.FileSystemObject")
		sOutPutFile = StrComputer & prefix & "LocalGroups.txt"
		DeleteFile(OutPutPath & sOutPutFile) 'Delete File to avoid create/Overwrite issues
		Set objFile = objFSO.CreateTextFile(OutPutPath & sOutPutFile, ForAppending, TRUE) 	
		
		I=0
		For Each ObjItem in ColItems
			'Loop for each group
			I=I+1
			strTemp=objItem.Name & ";" & quote & objItem.Description & quote & ";" & objitem.Domain &";" & objitem.caption & ";" & objItem.Sid & ";" & strComputer & ";" & strRealComputerName
			objFile.write(ListLocalGroupMembers(strComputer,strTemp))
		Next
		IF I=0 then
			objFile.write(quote & "No Local Groups" & Quote &";;;;;" & strComputer & ";")
		End if
		WScript.StdOut.WriteBlankLines(1)
		objfile.close
	End if
	'wscript.echo listlocalgroups
End Function 'ListLocalGroups
'*******************************************************************************

'********************************************************************************
 Function SidType(intSIDType)
	Select Case intSidType
		Case 1
			SidType="User"
		Case 2
			SidType="Group"
		Case 3
			SidType="Domain"
		Case 4
			SidType="Alias"
		Case 5
			SidType="WellKnownGroup"
		Case 6
			SidType="DeletedAccount"
		Case 7
			SidType="Invalid"
		Case 8	
			SidType="Unknown"
		Case 9
			SidType="Computer"		
		Case Else
			SidType="Unknown"
	End Select
 End function
 '********************************************************************************
 
 
 '********************************************************************************
 Function GetSystemRole(strComputer)
	on error resume next
	Dim ColItems, objItem
	Set ColItems = objSWbemService.ExecQuery ("Select DomainRole from Win32_ComputerSystem")
	if err <> 0 Then
		wscript.echo strComputer,"Exception in GetSystemRole!:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf		
	End if
	For Each objItem in ColItems
		Select Case objItem.DomainRole
			Case 0
				GetSystemRole = "Standalone Workstation"
			Case 1
				GetSystemRole = "Member Workstation"
			Case 2
				GetSystemRole = "Standalone Server"
			Case 3
				GetSystemRole = "Member Server"
			Case 4
				GetSystemRole = "Backup Domain Controller"
			Case 5
				GetSystemRole = "Primary Domain Controller"
		End Select
	Next
End Function
 '********************************************************************************

 
 '********************************************************************************
   
   
  '********************************************************************************
 Function ListADGroupMembers(strGroupADsPath, dicSeenGroupMember,strGroupInfo,objFile)
 'shows user info for everyone in a group, including nested groups.
	on error resume next
	Dim objGroup, objMember, strTemp, strForeignSid
	strGroupADsPath="LDAP://" & strGroupADsPath
	set objGroup = GetObject(strGroupADsPath)
		for each objMember In objGroup.Members			
			if lcase(objMember.ObjectCategory) = "group" then
				if not dicSeenGroupMember.Exists(objMember.ADsPath) then			
					dicSeenGroupMember.Add objMember.ADsPath, 1'avoid loop, when nested groups are "looped"
					ListADGroupMembers objMember.ADsPath, dicSeenGroupMember, strGroupInfo, objFile
				End if
			Else				
				if lcase(objMember.Class) = "user" then
					'We are dealing with a user which is a member of the group or a subgroup
					if not dicUserList.exists(objMember.DistinguishedName) Then
						dicUserList.add objMember.DistinguishedName, ListAdUserInfo(objMember.DistinguishedName)
						'objFile.WriteLine strGroupInfo & ";" & ListAdUserInfo(objMember.DistinguishedName)
						objFile.WriteLine strGroupInfo & ";" & dicUserList.item(objMember.DistinguishedName)				
					End if
					objFile.WriteLine strGroupInfo & ";" & dicUserList.item(objMember.DistinguishedName)
				ELSEif lcase(objMember.Category) = "Foreign-Security-Principal" then
					'resolve well known SIDs
					strTemp =  GetForeignCM(replace(objMember.name,"CN=",""))
					if strTemp ="" Then
						strForeignSid=""
						if instr(objMember.DistinguishedName,",") > 0 then
							strForeignSid= left(objMember.DistinguishedName,instr(objMember.DistinguishedName,",") -1)
						Else
							strForeignSid=objMember.DistinguishedName
						end if
						objFile.WriteLine strGroupInfo & ";" & quote & strForeignSid & quote & ";;" & quote & objMember.Class & quote &";;;;;;;;;" & quote & objMember.DistinguishedName & quote & ";;;;"
					else
						objFile.WriteLine strGroupInfo & ";" & strTemp & ";" & quote & objMember.Class & quote
					End if
				End if
			End if
	   next	   
	   'WScript.StdOut.WriteBlankLines(1)
 End Function 'ListADGroupMembers
 '********************************************************************************
 '********************************************************************************
 
 '********************************************************************************
Function Progress(lngTotal,lngCurrent)
	'WScript.StdOut.WriteBlankLines(1)
	
 	'wscript.echo round(lngCurrent/lngTotal *100) & "%"
	WScript.StdOut.Write round(lngCurrent/lngTotal *100) & "%" 
End Function
'********************************************************************************

'******************************************************************************** 
Function ListADGroups(strComputer)
	on error Resume Next
	Dim dicSeenGroupMember
	
	Dim adoConn, adoCmd
	Dim objRootDSE,strDNSDomain
	Dim strFilter, strQuery, adoRecordset, adoRecordsetForCounting
	Dim objFSO, objFile, SOutputFile 	'Filesystem vars.
	dim I, lngGroupCount
	
	
	IF instr(getSystemRole(strComputer),"Standalone") > 0 Then
		wscript.echo "Not lising Domain groups, since " & strComputer & " is a " & strSystemRole
		exit function
	End if
	' Use ADO to search the domain for all users.
	Set adoConn = CreateObject("ADODB.Connection")
	Set adoCmd = CreateObject("ADODB.Command")
	adoConn.Provider = "ADsDSOOBject"
	adoConn.Open "Active Directory Provider"
	Set adoCmd.ActiveConnection = adoConn
	Set objRootDSE = GetObject("LDAP://RootDSE")
	if err<>0 and bdebug then
		wscript.echo strComputer,"Exception in ListADGroups:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf		
	End if
	strDNSDomain = objRootDSE.Get("DefaultNamingContext")
	Wscript.Echo "-------  Listing AD Groups From " & strDNSDomain & " -------"
	IF trim(strDNSDomain) <> "" Then		
		'File settings
		Set objFSO = CreateObject("Scripting.FileSystemObject")
		sOutPutFile = strDNSDomain & prefix & "ADGroups.txt"
		DeleteFile(OutPutPath & sOutPutFile) 'Delete File to avoid create/Overwrite issues
		Set objFile = objFSO.CreateTextFile(OutPutPath & sOutPutFile, ForAppending, TRUE) 
		'AD
		strFilter = "(&(objectCategory=Group))"
		strQuery = "<LDAP://" & strDNSDomain & ">;" & strFilter & ";distinguishedName;subtree"
		adoCmd.CommandText = strQuery
		adoCmd.Properties("Page Size") = 1000
		adoCmd.Properties("Timeout") = 25
		adoCmd.Properties("Cache Results") = False
		'Header
		objFile.writeLine strGroupHeader & ";" & strUserHeader
		Set adoRecordset = adoCmd.Execute
		set adoRecordSetForCounting= adoCmd.Execute
		lngGroupCount = adoRecordSetForCounting.recordCount
		set adoRecordSetForCounting = Nothing
		wscript.echo lngGroupCount & " Groups found in AD"
		WScript.StdOut.Write "."
		Do Until adoRecordset.EOF
			I=I+1
			if I mod (1+(lngGroupCount/100)) = 0  Then
				WScript.StdOut.Write "."
			end if
			if (I mod (lngGroupCount/5) = 0) or (I=lngGroupCount)  Then
				progress lngGroupCount,I
			end if
			if bdebug Then
				'Wscript.echo "Working with the group: " & adoRecordset.Fields("DistinguishedName").Value
			End if
			set dicSeenGroupMember = CreateObject("Scripting.Dictionary")'
			ListADGroupMembers adoRecordset.Fields("DistinguishedName").Value, dicSeenGroupMember, ListADGroupInfo(adoRecordset.Fields("DistinguishedName").Value), objFile
			dicSeenGroupMember = ""
			adoRecordset.MoveNext
		Loop
		
		WScript.StdOut.WriteBlankLines(1)
		adoRecordset.Close
		adoConn.Close
		objFile.close
	Else
		wscript.echo "Can't finding any domain?"
	End IF	
End function
'********************************************************************************

'********************************************************************************
Function ListADUsers (strComputer)	
	on error Resume Next
	Dim adoConn, adoCmd
	Dim objRootDSE,strDNSDomain
	Dim strFilter, strQuery, adoRecordset
	Dim objFSO, objFile, SOutputFile 	'Filesystem vars.
	Dim lngUserCount, I
	Dim adoRecordSetForCounting
	IF instr(getSystemRole(strComputer),"Standalone") > 0 Then
		wscript.echo "Not lising Domain users, since " & strComputer & " is a Standalone system"
		exit function
	End if

	' Use ADO to search the domain for all users.
	Set adoConn = CreateObject("ADODB.Connection")
	Set adoCmd = CreateObject("ADODB.Command")
	adoConn.Provider = "ADsDSOOBject"
	adoConn.Open "Active Directory Provider"
	Set adoCmd.ActiveConnection = adoConn
	Set objRootDSE = GetObject("LDAP://RootDSE")
	if err<>0 and bdebug then
		wscript.echo strComputer,"Exception in ListADUsers:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf		
	End if
	strDNSDomain = objRootDSE.Get("DefaultNamingContext")
	
	IF trim(strDNSDomain) <> "" Then		
		Wscript.Echo "-------  Listing AD Users From " & strDNSDomain & " -------"
		Set objFSO = CreateObject("Scripting.FileSystemObject")
		sOutPutFile = strDNSDomain & prefix & "ADUsers.txt"
		DeleteFile(OutPutPath & sOutPutFile) 'Delete File to avoid create/Overwrite issues
		Set objFile = objFSO.CreateTextFile(OutPutPath & sOutPutFile, ForAppending, TRUE) 
		strFilter = "(&(objectCategory=person)(objectClass=user))"
		strQuery = "<LDAP://" & strDNSDomain & ">;" & strFilter & ";distinguishedName;subtree"
		adoCmd.CommandText = strQuery
		adoCmd.Properties("Page Size") = 1000
		adoCmd.Properties("Timeout") = 25
		adoCmd.Properties("Cache Results") = False
		'Header
		objFile.Write strUserHeader & vbCrLF
		Set adoRecordset = adoCmd.Execute
		if err <> 0 then
			wscript.echo strComputer,"Exception in ListADUsers:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf		
		Else
			set adoRecordSetForCounting = adoCmd.Execute ' Populating the entire recordset, just for counting. Forward only curse, so can't reuse. Will change later
			if err <> 0 then
				wscript.echo strComputer,"Exception in ListADUsers:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf		
			Else
				lngUserCount = adoRecordSetForCounting.recordCount
				wscript.echo lngUserCount & " users found in AD"
				Do Until adoRecordset.EOF
					I=I+1
					if I mod (1+(lngUserCount/50)) = 0  Then
						WScript.StdOut.Write "."
					end if				
					objFile.writeLine ListADUserInfo(adoRecordset.Fields("DistinguishedName").Value)
					if (I mod (lngUserCount/5) = 0)  or (I=lngUserCount) Then
						progress lngUserCount,I
					end if
					adoRecordset.MoveNext
				Loop
			End if
		End if
		WScript.StdOut.WriteBlankLines(1)
		adoRecordset.Close
		adoConn.Close
		objFile.close
	Else
		wscript.echo "Can't finding any domain?"
		'wscript.quit
	End IF	
End function
'********************************************************************************

'********************************************************************************
Function ListADUserInfo(strUserADsPath)
	on error resume next
	Dim objUser
	Dim strDescription, strDisplayName, strPwdLastSet, intUserAccountControl, strlastLogon, whenCreated, strgivenName, strsn, strsAMAccountName
	Dim	strPasswordExpired, bPasswordRequired,strDisabled, strDN, strWhenChanged, strLockOut, strPasswordLastSet, strClass
	Dim objTemp

	'UserFlags	
	Const ADS_UF_SCRIPT = &H0001 
	Const ADS_UF_ACCOUNTDISABLE = &H0002 
	Const ADS_UF_HOMEDIR_REQUIRED = &H0008 
	Const ADS_UF_LOCKOUT = &H0010 
	Const ADS_UF_PASSWD_NOTREQD = &H0020 
	Const ADS_UF_PASSWD_CANT_CHANGE = &H0040 
	Const ADS_UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED = &H0080 
	Const ADS_UF_DONT_EXPIRE_PASSWD = &H10000 
	Const ADS_UF_SMARTCARD_REQUIRED = &H40000 
	Const ADS_UF_PASSWORD_EXPIRED = &H800000
	Set objUser = GetObject("LDAP://" & strUserADsPath)	
	strsAMAccountName = objUser.sAMAccountName
	
	strDescription = objUser.description
	strDisplayName = objUser.Displayname
	strGivenName= objUser.GivenName
	strsn=objUser.sn 
	strClass=objUser.Class
	strPwdlastset=objUser.PasswordLastChanged
	
	if strPwdlastset = "" then
		strPwdlastset= "Never"
	END IF
	set objTemp= objUser.Get("lastLogonTimestamp")
	strLastLogon=Integer8Date(objTemp)
	bPasswordRequired = objUser.PasswordRequired
	if bPasswordRequired then
		bPasswordRequired = "Yes"
	Else
		bPasswordRequired = "No"
	End if
	whenCreated = objUser.WhenCreated
	intuserAccountControl= objUser.userAccountControl
	If intuserAccountControl AND ADS_UF_ACCOUNTDISABLE Then
		strDisabled = "AccountDisabled"
	Else
		strDisabled = "AccountNotDisabled"
	End If
	If intuserAccountControl AND ADS_UF_PASSWORD_EXPIRED Then
		strPasswordExpired =  "PasswordExpired"
	Else
		strPasswordExpired = "PasswordNotExpired"
	End If
	
	If intuserAccountControl AND ADS_UF_LOCKOUT Then
		strLockOut =  "AccountLocked"
	Else
		strLockOut =  "AccountNotLocked"
	End If
		
	strDN = objUser.distinguishedName		
	strWhenChanged = objUser.whenChanged
	ListADUserInfo=quote & strsAMAccountName & quote & ";" & quote & strDescription & quote & ";" & quote & strClass & quote & ";" & quote & strDisplayName & quote & ";" & quote & strGivenName & quote & ";" & Quote & strSN & Quote & ";" _
	& quote & strPwdLastSet & quote & ";" & quote & strLastLogon & Quote & ";" & Quote & bPasswordRequired & quote & ";" & Quote & strDisabled & quote & ";" & Quote & strPasswordExpired & Quote _
	& ";" & quote & strDN & quote & ";" & quote & whenCreated & Quote & ";" & Quote & strWhenChanged & Quote & ";" & Quote & strLockOut & Quote
End Function
'********************************************************************************
'********************************************************************************
Function ListADGroupInfo(strGroupADsPath)
	on error resume next
	Const GROUP_TYPE_BUILTIN_LOCAL_GROUP= &h00000001
	Const GROUP_TYPE_ACCOUNT_GROUP 		= &h00000002
	Const GROUP_TYPE_RESOURCE_GROUP 	= &h00000004
	Const GROUP_TYPE_UNIVERSAL_GROUP 	= &h00000008
	Const GROUP_TYPE_SECURITY_ENABLED	= &h80000000
	Dim objGroup, strDescription, intGroupType, whenCreated, strsAMAccountName, strDN, strWhenChanged, strGroupType,strClass
	Set objGroup = GetObject("LDAP://" & strGroupADsPath)
	
	strsAMAccountName 	= objGroup.sAMAccountName
	strDescription 		= objGroup.description
	whenCreated 		= objGroup.WhenCreated
	strClass			= objGroup.Class
	strDN = objGroup.distinguishedName		
	strWhenChanged = objGroup.whenChanged
	intGroupType=objGroup.GroupType
	if intGroupType AND GROUP_TYPE_BUILTIN_LOCAL_GROUP then
		strGroupType= "Builtin Local,"
	End if
	if intGroupType AND GROUP_TYPE_ACCOUNT_GROUP  then
		strGroupType=strGroupType & "GlobalGroup,"
	End if
	if intGroupType AND  GROUP_TYPE_RESOURCE_GROUP then
		strGroupType=strGroupType & "Domain Local,"
	End if
	if intGroupType AND GROUP_TYPE_UNIVERSAL_GROUP then
		strGroupType=strGroupType & "Universal,"
	End if
	if intGroupType AND GROUP_TYPE_SECURITY_ENABLED then
		strGroupType=strGroupType & "security-enabled group,"
	End if	
	'wscript.echo 
	ListADGroupInfo=quote & strsAMAccountName & quote & ";" & quote & strDescription & quote & ";" & quote & strClass & Quote & ";" & quote & strGroupType & quote & ";" & quote & strDN & quote & ";" & quote & whenCreated & Quote & ";" & Quote & strWhenChanged & Quote 
End Function


'********************************************************************************
Function ReadNTFSACL(objWMI, strPath, strName,strComputer)
'Needed by ListShars
	Dim objSecuritySettings 
	Dim objSecurityDec 
	Dim strDomain
	Dim objACE
	Set objSecuritySettings = objWMI.Get("Win32_LogicalFileSecuritySetting='" & strPath & "'")	
	objSecuritySettings.GetSecurityDescriptor objSecurityDec	
	strDomain = objSecurityDec.Owner.Domain
  	IF strDomain <> "" Then 
		strDomain = strDomain & "\"
	End IF
	
	' Display the DACL
	For Each objACE in objSecurityDec.DACL
		ReadNTFSACL=ReadNTFSACL & ShowACE(strName & quote & ";" & quote & StrPath & quote & ";" & quote & "NTFS",objACE,strComputer) & VbCrLf
	Next
End Function
'*******************************************************************************
 
'*******************************************************************************
Function ReadShareACL(objWMI, strName, strPath,StrComputer)
	'Needed by ListShars
	on Error resume next
	Dim objSecuritySettings 
	Set objSecuritySettings = objWMI.Get("Win32_LogicalShareSecuritySetting='" & strName & "'")
	Dim objSecurityDec 
	objSecuritySettings.GetSecurityDescriptor objSecurityDec
	Dim objACE
 	' Display the DACL
	Dim a 
	For Each objACE in objSecurityDec.DACL
		ReadShareACL=ReadShareACL & ShowACE(strName & quote & ";" & quote & strPath & quote & ";" & quote & "Sharesecurity",objACE,StrComputer) & VbCrLf
	Next
End Function
'*******************************************************************************
 
'*******************************************************************************
Function DisplayValues(dblValues, objSecurityEnumeration)
'Needed by ListShars
	on Error resume next
	Dim dblValue
	For Each dblValue in objSecurityEnumeration
		IF dblValues >= dblValue Then
			DisplayValues = "" & objSecurityEnumeration(dblValue) 
			dblValues = dblValues - dblValue
		End IF
	Next
End Function
'*******************************************************************************
 
'*******************************************************************************
Function ShowACE(sComment,objACE,StrComputer)
'Needed by ListShars
'Shows rights
	Dim strDomain 
	strDomain = objAce.Trustee.Domain
	Dim objAceTypes : Set objAceTypes = CreateObject("Scripting.Dictionary")
	objAceTypes.Add 0, "Allow"
	objAceTypes.Add 1, "Deny"
	Dim objAccessRights 
	Set objAccessRights = CreateObject("Scripting.Dictionary")
	objAccessRights.Add 2032127, "FullControl"
	objAccessRights.Add 1048576, "Synchronize"
	objAccessRights.Add 524288, "TakeOwnership"
	objAccessRights.Add 262144, "ChangePermissions"
	objAccessRights.Add 197055, "Modify"
	objAccessRights.Add 131241, "ReadAndExecute"
	objAccessRights.Add 131209, "Read"
	objAccessRights.Add 131072, "ReadPermissions"
	objAccessRights.Add 65536, "Delete"
	objAccessRights.Add 278, "Write"
	objAccessRights.Add 256, "WriteAttributes"
	objAccessRights.Add 128, "ReadAttributes"
	objAccessRights.Add 64, "DeleteSubdirectoriesAndFiles"
	objAccessRights.Add 32, "ExecuteFile"
	objAccessRights.Add 16, "WriteExtendedAttributes"
	objAccessRights.Add 8, "ReadExtendedAttributes"
	objAccessRights.Add 4, "AppendData"
	objAccessRights.Add 2, "CreateFiles"
	objAccessRights.Add 1, "ReadData"
	IF strDomain <> "" Then 
		strDomain = strDomain & "\"
	End IF
	ShowACE = strComputer & ";" & quote & sComment & quote & ";" & quote & (UCASE(strDomain & objAce.Trustee.Name)) & quote &  ";" & quote & DisplayValues(objACE.AccessMask,objAccessRights) & quote & ";" & quote & objAceTypes(objACE.AceType) & quote
End function
'*******************************************************************************

'*******************************************************************************
'Function to detect old WSH versions
Function DetectWSHVersion
	on error Resume Next
	If replace(UCASE(WScript.Version),".","") < 56 Then
		wscript.echo "It seems like the system your are running then script on has an old version of Windows scripting host"
		wscript.echo "WSH version:" & WScript.Version
		Wscript.echo "Running script in Win2k mode, this only works in localmode"
		Win2kMode=TRUE
		Wscript.echo " "
	Else
		Win2kMode=FALSE
	End if
End Function
'*******************************************************************************

'*******************************************************************************
'This function can show status for one system
Function CheckServerStat (strComputer)
			IF  	ifexist(OutPutPath & strComputer & prefix & "DONE") Then
					CheckServerStat = "DONE"
			ELSEIF  	ifexist(OutPutPath & StrComputer & prefix & "OFFLINE") Then
					CheckServerStat = "OFFLINE"
			ELSEIF  	ifexist(OutPutPath & strComputer & prefix & "ERROR") Then
					CheckServerStat = "ERROR"
			ELSEIF  	ifexist(OutPutPath & strComputer & prefix & "LOAD") Then
					CheckServerStat = "LOAD"
			ELSE
					CheckServerStat = "RUNNING"
			End IF
End Function
'*******************************************************************************

'*******************************************************************************
 Function Stats ()
		Dim I
        'Var Reset
        intDone		=0 
        intError	=0
		intLoad		=0
        intOffline	=0
      	For I=0 to uBound(ArrServerName)					
			IF  	ifexist(OutPutPath & ArrServerName(I) & prefix & "DONE") Then
					intDone = intDone +1 
			ELSEIF  	ifexist(OutPutPath & ArrServerName(I) & prefix & "OFFLINE") Then
					intOffline = intOffline +1
			ELSEIF  	ifexist(OutPutPath & ArrServerName(I) & prefix & "ERROR") Then
					intError = intError +1
			ELSEIF  	ifexist(OutPutPath & ArrServerName(I) & prefix & "LOAD") Then
					intLoad = intLoad +1						
			End IF
		Next
 End Function ' Stats
'*******************************************************************************

'*******************************************************************************
Function ListShares (strComputer)
	on Error resume next
	Dim TempResult
	Dim colItems 
	Dim objItem
	Set colItems = objSWbemService.ExecQuery("SELECT * FROM Win32_Share WHERE Type='0'") ' Only disk shares
	TempResult=""
	Wscript.Echo "------- Share Information from "& strComputer & " -------"
	For Each objItem in colItems
		TempResult=TempResult & ReadShareACL(objSWbemService, objItem.Name, objItem.Path, strComputer)
		TempResult=TempResult & ReadNTFSACL(objSWbemService, objItem.Path, objItem.Name,StrComputer)
	Next
	LogToFile StrComputer & prefix &"Shares.txt", TempResult
End function
'*******************************************************************************

'******************************************************************************
Function CheckCurrentDirectory()
'Ensure Path is correct!
	Dim wshshell
	Set WshShell = WScript.CreateObject("WScript.Shell") 
	if Win2kmode Then
		FullPath = replace(replace(UCASE(WScript.ScriptFullName),UCASE(ScriptName),"") & "\","\\","\")
		OutPutPath = replace(FullPath & OutputFolder & "\","\\","\")
	Else
		FullPath = replace(UCASE(WScript.ScriptFullName),UCASE(ScriptName),"") & "\"
		WshShell.CurrentDirectory = FullPath
		OutPutPath = WshShell.CurrentDirectory & "\" & OutputFolder & "\"
	End if
End Function
'*******************************************************************************

'******************************************************************************
'This function will create an output directory.
Function CreateOutputDirectory ()
'Create output dierctory, Then copy serverlist.txt and/or serverlist-full.txt to the output directory	
	Dim FileSystem, NewFolder, WshShell, SourceFile
	set FileSystem =CreateObject("Scripting.FileSystemObject") 
	
	IF Not FileSystem.FolderExists(OutputFolder) Then 
		Set NewFolder = FileSystem.CreateFolder(OutputFolder) 
	End IF 
	IF ifexist(fullpath & "serverlist.txt") Then
		FileSystem.CopyFile fullpath & "serverlist.txt" , OutPutPath & "#CopyOfServerlist.txt", OverwriteExisting
	End IF

	IF ifexist(FullPath & "Serverlist-Full.txt") Then
		FileSystem.CopyFile fullpath & "Serverlist-Full.txt" , OutPutPath & "#CopyOfServerlist-Full.txt", OverwriteExisting
	End IF
	
	LogToFile "Version.log", Version
	
	Set WshShell = WScript.CreateObject("WScript.Shell") 
	if not Win2kMode then
		WshShell.CurrentDirectory = OutputFolder
	End if
End Function
'*******************************************************************************
Function WMIError(strComputer,strError)
'This function just creates a WMI help file
	on Error RESUME NEXT
	'Touch (strComputer & prefix & "WMI.Error")
	LogToFile strComputer & prefix & "WMI.Error",  sFileHeader & strError
	Wscript.Echo strError	
	IF not IfExist (cWMIHelpFile) Then
		'Write HelpFile IF it does not exist.
		Dim strHelpFile
		strHelpFile = sFileHeader & VbCrLf & VbCrLf _
		& "* Handling WMI Errors *" & VbCrLf & VbCrLf _
		& "IF you encounter WMI errors this could be beacuse:" & VbCrLf _
		& " 1. Windows Firewall on the remote system is blocking WMI." & VbCrLf _
		& " 2. The remote system is running Vista or Windows Server 2008, with UAC enabled." & VbCrLf _
		& " 3. Getting WMI through a firewall http://blogs.msdn.com/b/john_daskalakis/archive/2009/02/05/9397926.aspx." & VbCrLf _
		& "-----------------------------" & VbCrLf _
		& "Possible solutions:" & VbCrLf _
		& " You can disable the firewall on the remote system temporarily, or allow WMI." & VbCrLf _
		& " copy "&  ScriptName &" to the remote system, and run it locally." & VbCrLf _
		& "-----------------------------" & VbCrLf _
		& "Troubleshooting ideas:" & VbCrLf _
		& " 1a. Download a WMI browser application: " & VbCrLf _
		& "     http://www.microsoft.com/downloads/details.aspx?familyid=6430F853-1120-48DB-8CC5-F2ABDC3ED314" & VbCrLf _
		& " 1b. Try to connect to the remote computer which is causing issues" & VbCrLf _
		& " 1c. Try to change firewall/UAC settings and connect again." & VbCrLf _
		& "-----------------------------" & VbCrLf _
		& "More information" & VbCrLf _
		& " 1. For details about (UAC Effect on WMI Data Returned to Scripts or Applications) see:" & VbCrLf _
		& "      http://msdn.microsoft.com/en-us/library/aa826699(VS.85).aspx" & VbCrLf _
		& " 2. For details about (Connecting Through Windows Firewall) see:" & VbCrLf _
		& "      http://msdn.microsoft.com/en-us/library/aa389286.aspx" & VbCrLf _
				& "-----------------------------" & VbCrLf _
		& "More information" & VbCrLf _
		& " 1. For details about running the script through a firewall see:" & VbCrLf _
		& "      http://blogs.msdn.com/b/john_daskalakis/archive/2009/02/05/9397926.aspx" & VbCrLf _
		& "---------------------------------------------------------------" & VbCrLf 
		LogToFile cWMIHelpFile,strHelpFile
	End IF
End Function
'*******************************************************************************
'******************************************************************************
'This function can append something to a file.
'It will not append but overwrite!
Function AppendToFile(sOutPutFile,StrResult)
	on Error goto 0
	Dim objFSO
	Dim objFile
	Set objFSO = CreateObject("Scripting.FileSystemObject")
	if ifexist(OutPutPath & sOutPutFile) then
		Set objFile = objFSO.OpenTextFile(OutPutPath & sOutPutFile, ForAppending, TRUE ) ' fixed in 2.53
	Else
		Set objFile = objFSO.CreateTextFile(OutPutPath & sOutPutFile, ForWriting, TRUE) ' fixed in 2.53
	End if
	objFile.Write StrResult
	objFile.close
End Function 'Appendtofile
'******************************************************************************
'******************************************************************************
'This function can log something to a file.
'It will not append but overwrite!
Function LogToFile(sOutPutFile,StrResult)
	Dim objFSO
	Dim objFile
	Set objFSO = CreateObject("Scripting.FileSystemObject")
	'Delete File to avoid create/Overwrite issues
	DeleteFile(OutPutPath & sOutPutFile)
	'Write new file
	Set objFile = objFSO.CreateTextFile(OutPutPath & sOutPutFile, ForWriting, TRUE) ' Fixed in 2.53
	objFile.Write StrResult
	objFile.close
End Function 'LogToFile
'******************************************************************************
'********************************************************************************
'This function collects the current user of the machine from the registry
'********************************************************************************
Function ListCurrentUser (strComputer)

    On Error Resume Next
    Const HKCU = &H80000001 'HKEY_CURRENT_USER
    Dim strEntry1,strEntry2,strEntry3,strEntry4
    Dim ObjReg, strSubKey, strSubKey2, strValue1, strValue2, strValue3, strValue4, StrKey
    Dim arrSubKeys(), arrSubKeys2()
    Dim TempResult, intRet1,intRet2,intRet3, intValue3,intValue4
    Dim objFSO, objFile, SOutputFile     'Filesystem vars.
    
    'Create OutPutFile
    'LogToFile created issues due to largeamounts of data!
    Set objFSO = CreateObject("Scripting.FileSystemObject")
    sOutPutFile = StrComputer & prefix & "CURRENT_USER.txt"
    DeleteFile(OutPutPath & sOutPutFile) 'Delete File to avoid create/Overwrite issues
    Set objFile = objFSO.CreateTextFile(OutPutPath & sOutPutFile, ForAppending)
    strKey = "Volatile Environment\" 'Find current logged in user
    strEntry1 = "USERNAME"
    strEntry2 =  "USERDNSDOMAIN"
    strEntry3 = "USERDOMAIN"
    strEntry4 =  "USERPROFILE"
    Wscript.Echo "------- Current User From " & strComputer & " -------"
    
    Set objReg = GetObject("winmgmts://" & strComputer & "/root/default:StdRegProv")
    
    IF Err = 0 Then 'Get the information for the current user of the machine
            'Pull current user information from the "Volatile Environment\" registry location (strKey above)
            objReg.GetStringValue HKCU, strKey, strEntry1, strValue1
            objReg.GetStringValue HKCU, strKey, strEntry2, strValue2
            objReg.GetStringValue HKCU, strKey, strEntry3, strValue3
            objReg.GetStringValue HKCU, strKey, strEntry4, strValue4
            'If one of the values has data, then write it to file;
            'Sometimes this data can't be pulled and strValues are all blank and therefore we wouldn't want to write to file
            IF strValue1 <> "" OR strValue2 <> "" OR strValue3 <> "" OR strValue4 <> "" Then
                TempResult=TempResult & strComputer & ";" & quote & strValue1 & quote 'USERNAME
                TempResult=TempResult & ";" & quote & strValue2 & quote 'USERDNSDOMAIN
                TempResult=TempResult & ";" & quote & strValue3 & quote 'USERDOMAIN
                TempResult=TempResult & ";" & quote & strValue4 & quote &  VbCrLf 'USERPROFILE
                'Write to the CURRENT_USER.txt file
                objFile.Write TempResult
		objFile.close
            End If
        ELSE
            ListCurrentUser = False
            WmiError strComputer,"**** Error binding WMI"
    End If
        
    If FileOk(sOutPutFile) = TRUE Then
            ListCurrentUser=True
        Else
            ListCurrentUser=False
    End If
    
End Function

'********************************************************************************
'This function collects the last user of the machine from the registry
'********************************************************************************
Function ListLastUsers (strComputer)
    on Error Resume Next
    Const HKLM = &H80000002 'HKEY_LOCAL_MACHINE
    Dim strEntry1,strEntry2,strEntry3,strEntry4
    Dim ObjReg, strSubKey, strSubKey2, strValue1, strValue2, strValue3, strValue4, StrKey
    Dim arrSubKeys(), arrSubKeys2()
    Dim TempResult, intRet1,intRet2,intRet3, intValue3,intValue4
    Dim objFSO, objFile, SOutputFile     'Filesystem vars.
    
    'Create OutPutFile
    'LogToFile created issues due to largeamounts of data!
    Set objFSO = CreateObject("Scripting.FileSystemObject")
    sOutPutFile = StrComputer & prefix & "USERS.txt"
    DeleteFile(OutPutPath & sOutPutFile) 'Delete File to avoid create/Overwrite issues
    Set objFile = objFSO.CreateTextFile(OutPutPath & sOutPutFile, ForAppending)
    strKey = "Software\Microsoft\Windows\CurrentVersion\Authentication\LogonUI\" 'Find last logged in user
    strEntry1 = "LastLoggedOnSAMUser"
    strEntry2 =  "LastLoggedOnUser"
    strEntry3 = "LoggedOnSAMUser"
    strEntry4 =  "LoggedOnUsername"
    Wscript.Echo "------- Recent User(s) From " & strComputer & " -------"
    Set objReg = GetObject("winmgmts://" & strComputer & "/root/default:StdRegProv")
    IF Err = 0 Then 'Get the information for the main/original user of the machine
        'Pull the LastLogged on user fields in the "Software\Microsoft\...\LogonUI registry location (strKey above)
        objReg.GetStringValue HKLM, strKey, strEntry1, strValue1
        objReg.GetStringValue HKLM, strKey, strEntry2, strValue2
        objReg.GetStringValue HKLM, strKey, strEntry3, strValue3
        objReg.GetStringValue HKLM, strKey, strEntry4, strValue4
        'If one of the values has data, then write it to file;
        'Sometimes this data can't be pulled and strValues are all blank and therefore we wouldn't want to write to file
        IF strValue1 <> "" OR strValue2 <> "" OR strValue3 <> "" OR strValue4 <> "" Then
            TempResult=TempResult & strComputer & ";" & quote & strValue1 & quote ' LastLoggedOnSAMUser
            TempResult=TempResult & ";" & quote & strValue2 & quote 'LastLoggedOnUser
            TempResult=TempResult & ";" & quote & strValue3 & quote 'LoggedOnSAMUser
            TempResult=TempResult & ";" & quote & strValue4 & quote &  VbCrLf 'LoggedOnUsername
            'Write to the USERS.txt file
            objFile.Write TempResult
        End If
        'Clear the tempResult variable for secondary user information
        TempResult= ""
        strValue1 = ""
        strValue2 = ""
        strValue3 = ""
        strValue4 = ""
            'Import all registry folders from the strKey location into the arrSubKeys array
            'Use this to find the secondary user information (ie. other users who have logged on recently)
            objReg.EnumKey HKLM, strKey, arrSubKeys
            For Each strSubKey In arrSubKeys
                'Import all folders within the strKey\strSubKey location (looking for "SessionData" location)
                '"Software\Microsoft\Windows\CurrentVersion\Authentication\LogonUI\" should have a "SessionData" Folder
                'Within the "SessionData" folder, there should be atleast 1 folder numbered (1,2,3 etc.)
                'Within each of those numbered folders there should be LoggedOnSAMUser and LoggedOnUsername keys
                'Each numbered folder represents a recent user log-in
                objReg.EnumKey HKLM, strKey & strSubKey, arrSubKeys2
                    'For each numbered folder (recent users) described above, look for user login information
                    For Each strSubKey2 In arrSubKeys2
                        'The IF statements here aren't really useful as the strValue's were just emptied above
                        'Leave it anyway just as a precautionary measure
                        'These statements pull the values for the LogOn User data (LoggedOnSAMUser and LoggedOnUsername)
                        IF trim(strValue1) = "" Then objReg.GetStringValue HKLM, strKey & strSubKey & "\" & strSubKey2, strEntry1, strValue1
                        IF trim(strValue2) = "" Then objReg.GetStringValue HKLM, strKey & strSubKey & "\" & strSubKey2, strEntry2, strValue2
                        IF trim(strValue3) = "" Then objReg.GetStringValue HKLM, strKey & strSubKey & "\" & strSubKey2, strEntry3, strValue3
                        IF trim(strValue4) = "" Then objReg.GetStringValue HKLM, strKey & strSubKey & "\" & strSubKey2, strEntry4, strValue4
                        IF strValue1 <> "" OR strValue2 <> "" OR strValue3 <> "" OR strValue4 <> "" Then
                            TempResult=TempResult & strComputer & ";" & quote & strValue1 & quote ' LastLoggedOnSAMUser
                            TempResult=TempResult & ";" & quote & strValue2 & quote 'LastLoggedOnUser
                            TempResult=TempResult & ";" & quote & strValue3 & quote 'LoggedOnSAMUser
                            TempResult=TempResult & ";" & quote & strValue4 & quote &  VbCrLf 'LoggedOnUsername
                            objFile.Write TempResult
                        End If
                        TempResult= ""
                        strValue1 = ""
                        strValue2 = ""
                        strValue3 = ""
                        strValue4 = ""
                    Next
            Next
        strValue1 = ""
        strValue2 = ""
        'Below handles finding the primary user for Windows XP machines and earlier
        strKey = "Software\Microsoft\Windows NT\CurrentVersion\Winlogon"
        strEntry1 = "defaultUserName"
        strEntry2 = "altDefaultUserName"
        objReg.GetStringValue HKLM, strKey, strEntry1, strValue1
        objReg.GetStringValue HKLM, strKey, strEntry2, strValue2
           
        IF strValue1 <> "" OR strValue2 <> "" Then
            TempResult=TempResult & strComputer & ";" & quote & strValue1 & quote ' LastLoggedOnSAMUser
            TempResult=TempResult & ";" & quote & strValue2 & quote &  VbCrLf
            objFile.Write TempResult
        End If
        
        'Close File
        objFile.close
    ELSE
        ListLastUsers = False
        WmiError strComputer,"**** Error binding WMI"
    End IF
    
    If FileOk(sOutPutFile) Then
            ListLastUsers=True
        Else
            ListLastUsers=False
    End If

End Function

'********************************************************************************

'********************************************************************************
'This function collects the folder names from the c:\users folder (different for XP)
Function ListUserFolders(strComputer)
    On Error Resume Next
        Dim objFSO, folder, folders, NewFile, sfolder, path, resultString, sOutPutFile, objFile, folderIdx
        'Create OutPutFile
        'LogToFile created issues due to largeamounts of data!
        Set objFSO = CreateObject("Scripting.FileSystemObject")
        sOutPutFile = StrComputer & prefix & "UserFolders.txt"
        DeleteFile(OutPutPath & sOutPutFile) 'Delete File to avoid create/Overwrite issues
        Set objFile = objFSO.CreateTextFile(OutPutPath & sOutPutFile, ForAppending)
        resultString=""
        Wscript.Echo "------- User Folder(s) From " & strComputer & " -------"
        
        If objFSO.FolderExists("C:\Users") Then 'Windows Vista or after
                sFolder = "C:\Users"
            ElseIf objFSO.FolderExists("C:\Documents and Settings") Then 'For Windows XP and earlier
                    sFolder = "C:\Documents and Settings"
                Else
                    resultString="No User Folder Found"
        End If

        Set folder = objFSO.GetFolder(sFolder)
        Set folders = folder.SubFolders

        If resultString="" Then
                For each folderIdx In folders
                    resultString=resultString & strComputer & ";" & quote & folderIdx.Name & quote & ";" & quote & folderIdx.DateCreated & quote & ";" & quote & folderIdx.DateLastAccessed & quote & ";" & quote & folderIdx.DateLastModified & quote & VbCrLf
                    If InStr(LCase(resultString),"default")=0 AND InStr(LCase(resultString),"public")=0 AND InStr(lcase(resultString),"admin")=0 AND InStr(lcase(resultString),"all user")=0 Then objFile.Write resultString
                    If resultString="" Then
                        resultString="No User Folder Found"
                        objFile.Write strComputer & ";" & quote & resultString & quote & vbCrlf
                        Exit For
                    End If
                    resultString=""
                Next
		objFile.close
            Else
                objFile.Write strComputer & ";" & quote & resultString & quote & vbCrlf
		objFile.close
        End If

    If FileOk(sOutPutFile) Then
            ListUserFolders=True
        Else
            ListUserFolders=False
    End If

    objFile.close
End Function
'********************************************************************************

'******************************************************************************
'This function is the script that collects the actual data.
Function ListInstalledSoftware (strComputer)
	on error Resume Next
	Dim bMQNotchecked
	bMQNotchecked = TRUE
	Const HKLM = &H80000002 'HKEY_LOCAL_MACHINE
	Dim strEntry1a,strEntry1b,strEntry2,strEntry3,strEntry4,strEntry5, strEntry6
	Dim strSubkey, strValue1, StrKey, IntArch, Inparams, objCtx, objLocator, objServices, objStdRegProv, Outparams 
	Dim arrSubkeys()
	Dim IntArchs (1)
	Dim TempResult, intRet1,intRet2,intRet3, strValue2, intValue3,intValue4, strValue5, strValue6
	Dim objFSO, objFile, SOutputFile 	'Filesystem vars.
	Dim ColOSes, ColOS,objOS, colItems, objItem
	if bGetProductIDs then
		Set colItems = objSWbemService.ExecQuery ("Select Name,ProductID,IdentifyingNumber from Win32_Product")
	end if
    'Fill the arrays with the terms entered above
    arrArpFilterTerms = Split(strArpFilterTerms,",")
    arrArpExcludeTerms = Split(strArpExcludeTerms,",")
	IF Err = 0 Then			
	    'Create OutPutFile
		Set objFSO = CreateObject("Scripting.FileSystemObject")
		sOutPutFile = StrComputer & prefix & "APPLICATIONS.txt"
		DeleteFile(OutPutPath & sOutPutFile) 'Delete File to avoid create/Overwrite issues
		Set objFile = objFSO.CreateTextFile(OutPutPath & sOutPutFile, ForAppending) 
		StrKey = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\"
		IntArchs(0) = 32
		IntArchs(1) = 64
		strEntry1a = "DisplayName"
		strEntry1b = "QuietDisplayName"
		strEntry2 =  "InstallDate"
		strEntry3 =  "VersionMajor"
		strEntry4 =  "VersionMinor"
		strEntry5 =  "DisplayVersion"
		strEntry6 =  "Publisher"	
		Wscript.Echo "------- Installed Application from " & strComputer & " -------"
		For each IntArch in IntArchs
		
			Set objCtx = CreateObject("WbemScripting.SWbemNamedValueSet")
			objCtx.Add "__ProviderArchitecture", IntArch
			Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
			If (strUser<>"notset") and (strpassword<>"notset") and (strDomain<>"notset") then 
				Set objServices = objLocator.ConnectServer(strComputer,"root\default",strUser,strPassword,"MS_409","ntlmdomain:" + strDomain,,objCtx)
			Else
				Set objServices = objLocator.ConnectServer(strComputer,"root\default","","",,,,objCtx)
				objServices.Security_.ImpersonationLevel = 3
			End If
			Set objStdRegProv = objServices.Get("StdRegProv") 
			
			Set Inparams = objStdRegProv.Methods_("EnumKey").Inparameters
			Inparams.Hdefkey = HKLM
			Inparams.Ssubkeyname = StrKey
			set Outparams = objStdRegProv.ExecMethod_("EnumKey", Inparams,,objCtx)
			For Each strSubkey In Outparams.sNames
				Set Inparams = objStdRegProv.Methods_("GetStringValue").Inparameters
				Inparams.Hdefkey = HKLM
				Inparams.Ssubkeyname = strKey & strSubkey
				Inparams.sValueName = strEntry1a
				set Outparams = objStdRegProv.ExecMethod_("GetStringValue", Inparams,,objCtx)
				strValue1 = Outparams.SValue
				IF intRet1 <> 0 Then
					Set Inparams = objStdRegProv.Methods_("GetStringValue").Inparameters
					Inparams.Hdefkey = HKLM
					Inparams.Ssubkeyname = strKey & strSubkey
					Inparams.sValueName = strEntry1b
					set Outparams = objStdRegProv.ExecMethod_("GetStringValue", Inparams,,objCtx)
					strValue1 = Outparams.SValue
				End IF
				IF trim(strValue1) <> "" Then
					if strRealComputerName <> strComputer Then 
						StrComputer=lcase(strComputer) ' to to lcase if an Alias is used (This is a compromise, originally the idea was to have strRealComputerName, in evey output file)
					End if
					TempResult=TempResult & strComputer & ";" & quote & strValue1 & quote ' DisplayName
					strComputer=UCASE(strComputer)
					if bcheckMQ and bMQNotChecked Then
						IF instr(UCASE(strValue1),"WEBSPHERE MQ") > 0 Then
							checkMQ(strComputer)
							bMQNOTChecked = FALSE
						End if
					End if
					
					Set Inparams = objStdRegProv.Methods_("GetStringValue").Inparameters
					Inparams.Hdefkey = HKLM
					Inparams.Ssubkeyname = strKey & strSubkey
					Inparams.sValueName = strEntry2
					set Outparams = objStdRegProv.ExecMethod_("GetStringValue", Inparams,,objCtx)
					strValue2 = Outparams.SValue
					
					TempResult=TempResult & ";" & quote & strValue2 & quote 'Install Date
					
					Set Inparams = objStdRegProv.Methods_("GetDWORDValue").Inparameters
					Inparams.Hdefkey = HKLM
					Inparams.Ssubkeyname = strKey & strSubkey
					Inparams.sValueName = strEntry3
					set Outparams = objStdRegProv.ExecMethod_("GetDWORDValue", Inparams,,objCtx)
					intValue3 = Outparams.UValue
					
					Set Inparams = objStdRegProv.Methods_("GetDWORDValue").Inparameters
					Inparams.Hdefkey = HKLM
					Inparams.Ssubkeyname = strKey & strSubkey
					Inparams.sValueName = strEntry4
					set Outparams = objStdRegProv.ExecMethod_("GetDWORDValue", Inparams,,objCtx)
					intValue4 = Outparams.UValue
					
					IF trim(intValue3 & "." & intValue4) = "." Then
						TempResult=TempResult & ";" & quote & quote 'Blank
					ELSE
						TempResult=TempResult & ";" & quote & intValue3 & "." & intValue4 & quote 'Installed version
					End IF
					
					Set Inparams = objStdRegProv.Methods_("GetStringValue").Inparameters
					Inparams.Hdefkey = HKLM
					Inparams.Ssubkeyname = strKey & strSubkey
					Inparams.sValueName = strEntry5
					set Outparams = objStdRegProv.ExecMethod_("GetStringValue", Inparams,,objCtx)
					strValue5 = Outparams.SValue
					
					TempResult=TempResult & ";" & quote & strValue5 & quote'DisplayVersion
					
					Set Inparams = objStdRegProv.Methods_("GetStringValue").Inparameters
					Inparams.Hdefkey = HKLM
					Inparams.Ssubkeyname = strKey & strSubkey
					Inparams.sValueName = strEntry6
					set Outparams = objStdRegProv.ExecMethod_("GetStringValue", Inparams,,objCtx)
					strValue6 = Outparams.SValue
					
					TempResult=TempResult & ";" & quote & strValue6 & quote' publisher
					if bGetProductIDs then
						For Each objItem in colItems
							if objItem.name = strValue1 then
								TempResult=TempResult & ";" & quote & objItem.ProductID & quote ' Product ID
								TempResult=TempResult & ";" & quote & objItem.IdentifyingNumber & quote ' IdentifyingNumber
							end if
						next
					end if
					TempResult=TempResult &  VbCrLf 'end of line
                    'TempResult is the entire string seperated with ";" to be written as a new application entry (a new line)
                    'Check to see if filtering by search terms is turned on (If FALSE, then return all application entries)
                    If bFilterArpResults = True Then 'Filter results is set to TRUE which means only in-scope ARP entries will be recorded
                            For Each searchTerm in arrArpFilterTerms 'loop through each keyword in the ArpFilterTerms array
                                If InStr(LCase(TempResult),LCase(searchTerm))>0 AND searchTerm <> "" Then 'Check if the keyword is in the ARP entry
                                    bFilterFound = True 'If keyword is found, then set the trigger to TRUE
                                End If
                            Next
                            If strArpFilterTerms = "" Then bFilterFound = True 'If Arp Filter Terms is BLANK ("") then include current ARP entry
                            'If the excluded terms variable is NOT blank, then check to see if it is present in the current ARP entry
                            If strArpExcludeTerms <> "" Then
                                For Each searchTerm in arrArpExcludeTerms 'loop through each keyword in the ArpExcludeTerms array
                                    'Check if the keyword to exclude is in the ARP entry
                                    If InStr(LCase(TempResult),LCase(searchTerm))>0 AND searchTerm <> "" Then
                                        bFilterFound = False 'If keyword is found, then set the trigger to FALSE (ie. don't output current ARP entry)
                                    End If
                                Next
                            End If
                            
                            If bFilterFound = True Then objFile.Write TempResult 'Write the ARP entry to the output file
                            bFilterFound = False 'Reset the FilterFound trigger to FALSE

                        Else 'No filtering of results; include all ARP entries
                            objFile.Write TempResult 'Write the ARP entry to the output file
                            bFilterFound = False 'Reset the FilterFound trigger to FALSE
                    End If
                    TempResult="" 'Reset the TempResult variable that is holding the current ARP entry data to BLANK to be ready for next entry
				End IF
			Next
		Next 
		TempResult=""
		Set colOSes = objSWbemService.ExecQuery("Select * from Win32_OperatingSystem")
		For Each objOS in colOSes
			TempResult = strComputer & ";" & quote & objOS.Caption & quote & ";" & quote & objOS.InstallDate & quote & ";" & quote & objOS.Version & quote & ";" & quote & objOS.Version & quote & ";" & quote & objOS.Manufacturer & quote
			if bGetProductIDs then
				TempResult = TempResult & ";" & quote & objOS.SerialNumber & quote
			end if
			objFile.Write TempResult 'Write the ARP entry to the output file
			TempResult=""
		Next
		'Close File
		objFile.close	
	End if
	
	IF fileok(strComputer & prefix &"APPLICATIONS.txt" ) Then
		ListInstalledSoftware=TRUE
	ELSE
		ListInstalledSoftware=FALSE
	End IF

End Function
'ListInstalledSoftware
'******************************************************************************

'******************************************************************************
'This function is the script that collects the actual data.
Function ListLyncReg (strComputer)
	Wscript.Echo "------- Lync Edition from " & strComputer & " -------"
	on Error Resume Next
	Const HKLM = &H80000002 'HKEY_LOCAL_MACHINE
	Dim strEntry1,strEntry2,strEntry3
	Dim objregistry, strSubkey, StrKey
	Dim arrSubkeys()
	Dim TempResult, strValue1, strValue2, strValue3
	Dim ColOSes, ColOS,objOS, colItems, objItem
	Set objregistry = objSWbemServiceDefault.Get("StdRegProv")
	IF Err = 0 Then	
		StrKey = "SOFTWARE\Microsoft\Real-Time Communications\"
		strEntry1 =  "Server"
		strEntry2 =  "Type"
		strEntry3 =  "Version"	
		objregistry.EnumKey HKLM, strKey, arrSubkeys
		For Each strSubkey In arrSubkeys
			objregistry.GetStringValue HKLM, strKey & strSubkey, _
			strEntry1, strValue1
			objregistry.GetStringValue HKLM, strKey & strSubkey, _
			strEntry2, strValue2
			objregistry.GetStringValue HKLM, strKey & strSubkey, _
			strEntry3, strValue3
			TempResult=TempResult & strComputer & ";" & quote & strValue1 & quote & ";" & quote & strValue2 & quote & ";" & quote & strValue3 & quote &  VbCrLf 'end of line

		Next
		LogToFile StrComputer & prefix &"LyncReg.txt", TempResult
	End if
    
	IF fileok(strComputer & prefix &"LyncReg.txt" ) Then
		ListInstalledSoftware=TRUE
	ELSE
		ListInstalledSoftware=FALSE
	End IF

End Function
'ListLyncReg
'******************************************************************************

'******************************************************************************
'Function List IP information
Function ListIP (strComputer)
	on Error Resume Next
	Dim TempResult, I, counter
	Dim IPConfigSet,IPCONFIG, ObjWMIService
	Wscript.Echo "------- IP address information from " & strComputer & " -------"
	Set IPConfigSet = objSWbemService.ExecQuery ("Select * from Win32_NetworkAdapterConfiguration Where IPEnabled=TRUE")
	IF Err = 0 Then	
		Counter=0
		For Each IPConfig in IPConfigSet
			IF Not IsNull(IPConfig.IPAddress) Then 
				For i=LBound(IPConfig.IPAddress) to UBound(IPConfig.IPAddress)
					if strRealComputerName <> strComputer Then 
						StrComputer=lcase(strComputer) ' to to lcase if an Alias is used (This is a compromise, originally the idea was to have strRealComputerName, in evey output file)
					End if
					TempResult=TempResult & strComputer & ";"& counter &  ";" & quote & IPConfig.IPAddress(i)  & quote & ";" & quote & IPConfig.MACAddress(i)  & quote & VbCrLf
					Counter=Counter+1
					StrComputer=UCASE(StrComputer)
				Next
			End IF
		Next
	LogToFile StrComputer & prefix &"IP.txt",TempResult
	ELSE
		WmiError strComputer,"Exception in ListIP:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	End IF
	IF FileOK (StrComputer & prefix &"IP.txt" ) Then
		ListIP=TRUE
	ELSE
		ListIP=FALSE
	End IF
End Function
'End List IP
'******************************************************************************
Function RealComputerName (strComputer)
	on error Resume Next
	Dim ColOSes, objOS
	Set colOSes = objSWbemService.ExecQuery("Select * from Win32_OperatingSystem")
	IF Err = 0 Then	
		For Each objOS in colOSes
		 strRealComputerName = UCASE(objOS.CSName)
		 RealComputerName = strRealComputerName
		Next
	ELSE
		WmiError strComputer,"Exception in RealComputerName:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	END IF
End Function
'******************************************************************************
'******************************************************************************
Function CreateADList()
'Var definition
	on Error Resume Next
	Dim strDNSDomain
	Dim objRootDSE 
	Dim ArrTemp ()
	Dim I	
	Dim adoConn, adoCmd
	Dim adoRecordset
	Dim	strName, Age, strOS, strOSVersion,strWhenModified,strWhenCreated, strDN
	Dim objDate
	Dim objFile, objFileFull, objFSO
	Dim arrDomainList, strDomainList
	Set objRootDSE = GetObject("LDAP://RootDSE")
	if err<>0 and bdebug then
				WmiError "LocalHost_CreatingADList","Exception in CreateADList:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf		
	End if
	strDNSDomain = objRootDSE.Get("DefaultNamingContext")
	'Exit IF system is a standalone system
	IF trim(strDNSDomain) = "" Then
		wscript.echo "Can't finding any domain?"
		wscript.echo "Please run the script again and select localhost"
		wscript.echo "Exiting, script Version:" & Version
		wscript.quit
	End IF
	
	'Handle Output files
	set objFSO = CreateObject("Scripting.FileSystemObject")
	DeleteFile(FullPath & "Serverlist.txt") 
	DeleteFile(FullPath & "Serverlist-Full.txt") 
	Set objFile = objFSO.CreateTextFile(fullpath & "Serverlist.txt", ForWriting) 
	Set objFileFull = objFSO.CreateTextFile(fullpath & "Serverlist-Full.txt", ForWriting)
	objFileFull.write sFileHeader
	objFileFull.writeline "### Currentdomain=" & strDNSDomain
	Set strDomainList = GetDomainList
	objFileFull.writeline "### Full domainlist=" & GetDomainList ' Write domianlist to file
	objFileFull.writeline "Name;PasswordAge;OS;OS_Version;WhenCreated;DN"
	if bScanForest then
		Set arrDomainList = strDomainList.split(";")
	else
		Set arrDomainList = strDNSDomain
	end if
'Done with outputfile handling
	
	for each strDNSDomain in arrDomainList
		'Setup AD Connection
		Set adoConn = CreateObject("ADODB.Connection")
		Set adoCmd = CreateObject("ADODB.Command")
		adoConn.Provider = "ADsDSOObject"
		adoConn.Open "Active Directory Provider"
		Set adoCmd.ActiveConnection = adoConn
		Wscript.Echo "*** Collecting list of systems from " & strDNSDomain & "."	
	' Get Data	
	adoCmd.CommandText = "<LDAP://" & strDNSDomain & ">;(objectCategory=computer);Name,operatingSystem,operatingSystemVersion,pwdLastSet,whenCreated,distinguishedName;subtree"
		adoCmd.Properties("Page Size") = 500
		adoCmd.Properties("Timeout") = 25
		adoCmd.Properties("Cache Results") = False
		Set adoRecordset = adoCmd.Execute
		Do Until adoRecordset.EOF
		'Fill vars
			strName 		= UCASE(trim(adoRecordset.Fields("Name").Value))
			strOS			= Trim(adoRecordset.Fields("operatingSystem").Value)
			StrOSVersion 	= Trim (adoRecordset.Fields("operatingSystemVersion").Value)
			Set objDate 	= adoRecordset.Fields("pwdLastSet").Value
			Age=DateDiff("d", Integer8Date(objDate), Now)
		strWhenCreated= adoRecordset.Fields("whenCreated").Value
		strDN= adoRecordset.Fields("distinguishedName").Value
		
		
		'Vars filled
		'Write to Fullfile
		objFileFull.WriteLine strName & ";" & Quote & Age & quote & ";" & Quote & strOS & quote & ";" & quote & strOSVersion & Quote & ";" & quote & strWhenCreated & Quote & ";" & quote & strDN & Quote
		'Create serverlist.txt 
		IF Age > AgeLimit Then
			 'wscript.echo "*** Old:" & strName & " Days:" & Age 
	    ELSE
			IF (instr(UCASE(strOS),"SERVER") > 0) Then 
				'IF (we are not setup to care about OS( or the OS is a server) Then print to file.
				IF not bOnlyIncludeWorkstationsFromAD Then
					objFile.WriteLine strName & ";" & Quote & Age & quote & ";" & Quote & strOS & quote & ";" & quote & strOSVersion & Quote & ";" & quote & strWhenCreated & Quote  & ";" & quote & strDN & Quote
				End if
			ELSE
					IF not bOnlyIncludeServersFromAD Then
					objFile.WriteLine strName & ";" & Quote & Age & quote & ";" & Quote & strOS & quote & ";" & quote & strOSVersion & Quote & ";" & quote & strWhenCreated & Quote  & ";" & quote & strDN & Quote
					End IF
				End IF
			End IF 
			adoRecordset.MoveNext
		Loop
		adoRecordset.Close
	Next
	Wscript.Echo "*** Serverlist.txt and Serverlist-Full.txt Created"
	Wscript.Echo "*** Done"
	objFile.Close
	objFileFull.Close
End Function
'******************************************************************************

'******************************************************************************
Function ListOS (strComputer)
	on Error Resume Next
	Dim TempResult
	Dim ColOSes, ColOS,objOS
	Wscript.Echo "------- Operating system information from " & strComputer & " -------"
	Dim TimeZoneDayLightName, StandardTimeZoneName,TimeZoneDescription
	Dim ColItems, objItem
	Set colItems = objSWbemService.ExecQuery("Select * from Win32_TimeZone")
	For Each objItem in colItems
		TimeZoneDescription= objItem.Description
		TimeZoneDayLightName=objItem.DaylightName
		StandardTimeZoneName= objItem.StandardName
	Next
	Set colOSes = objSWbemService.ExecQuery("Select * from Win32_OperatingSystem")
	IF Err = 0 Then	
	'IF WMI connected
		For Each objOS in colOSes
		  TempResult=TempResult & strComputer & ";" & quote & objOS.CSName & quote & ";" & quote & objOS.Caption & quote 
		  IF instr(UCASE(objOS.Caption),"SERVER") > 0 Then
			Wscript.Echo "------- " & strComputer & " is a server"
		  ELSE
			Wscript.Echo "------- " & strComputer & " is a workstation"
			IF bOnlyCheckServers Then
				Wscript.echo "*** SKIPPING " & strComputer & " because it is a workstation"
				LogToFile strComputer & prefix & "workstation", strComputer ' Create <servername><prefix>offline
				wscript.sleep WaitingTime
				wscript.quit 'Exit
			End IF
		  End IF
		  TempResult=TempResult & ";" & q(objOS.Version) & ";" & q(objOS.BuildNumber) & ";" & q(objOS.BuildType) & ";" & q(objOS.OSType) & ";" & q(objOS.OtherTypeDescription) & ";" & q(objOS.ServicePackMajorVersion & "." &  objOS.ServicePackMinorVersion) & ";" & q(TimeZoneDescription) & ";" & q(TimeZoneDayLightName) & ";" & q(StandardTimeZoneName) & VbCrLf
		Next
		LogToFile StrComputer & prefix &"OS.txt", TempResult
		IF FileOK (StrComputer & prefix &"OS.txt" ) Then
			ListOS=TRUE
		ELSE
			ListOS=FALSE
		End IF
	ELSE
		WmiError strComputer,"Exception in ListOS:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	End IF

End Function
'End ListOS
'******************************************************************************

'******************************************************************************
'Function used for getting hardware information
Function ListCPU (strComputer)
	ON ERROR Resume Next
	Dim TempResult
	Dim ColItems, objItem, objComp	
	Dim I
	Dim strNUMBER_OF_PROCESSORS,strPROCESSOR_ARCHITECTURE,strPROCESSOR_IDENTIFIER,strPROCESSOR_REVISION
	Dim CpuInitialString ' Used to hold env Vars
	Dim RegistryCPUName
	I=0
	Wscript.Echo "------- Processor information from " & strComputer & " -------"
	Set colItems = objSWbemService.ExecQuery("Select * from Win32_Environment where name like '%processor%'")
	IF Err = 0 Then	
		For Each objItem in colItems
			Select Case ObjItem.Name 
				Case "NUMBER_OF_PROCESSORS"
					strNUMBER_OF_PROCESSORS=quote & objitem.VariableValue & quote
				Case "PROCESSOR_ARCHITECTURE"
					strPROCESSOR_ARCHITECTURE=quote & objitem.VariableValue & quote
				Case "PROCESSOR_IDENTIFIER"
					strPROCESSOR_IDENTIFIER=quote & objitem.VariableValue & quote
				Case "PROCESSOR_REVISION"
					strPROCESSOR_REVISION=quote & objitem.VariableValue & quote
			End Select
		Next
		'CpuInitialString=TempResult 
		RegistryCPUName=quote & ReadHKLMRegistryString(strComputer,"HARDWARE\DESCRIPTION\System\CentralProcessor\0","ProcessorNameString") & quote
		if strRealComputerName <> strComputer Then 
			StrComputer=lcase(strComputer) ' to to lcase if an Alias is used (This is a compromise, originally the idea was to have strRealComputerName, in evey output file)
		End if	
		CpuInitialString=strComputer & ";" & strNUMBER_OF_PROCESSORS & ";" & strPROCESSOR_ARCHITECTURE & ";" & strPROCESSOR_IDENTIFIER & ";" & strPROCESSOR_REVISION & ";" & RegistryCPUName
		StrComputer=UCASE(StrComputer)
		Set colItems = objSWbemService.ExecQuery("Select * from Win32_Processor")
		For Each objItem in colItems
			TempResult=CpuInitialString  & ";" & I 
			Err.clear
			TempResult = tempResult & ";" & quote & objItem.NumberOfLogicalProcessors & quote 	' New Entry, only exist on newer OS'es or os with patched WMI	
			'Error handling in place, to make sure systems with older WMI implementations print all fields.
			IF Err <> 0	then
				TempResult=TempResult & ";" & quote &"Old WMI" & quote				
				ERR.CLEAR
			End IF 
			TempResult=TempResult & ";" & quote & objItem.NumberOfCores  & quote '  New Entry, only exist on newer OS'es or os with patched WMI<input type="text" >
			IF err <> 0 Then	
				TempResult=TempResult & ";" & quote & "Old WMI" & quote				
				ERR.CLEAR
			End IF
			
			TempResult=TempResult & ";" & quote & objItem.Name & quote & ";" & quote & objItem.AddressWidth & quote & ";" & quote & objItem.Architecture & quote & ";" & quote & objItem.Availability & quote
			TempResult=TempResult & ";" & quote & objItem.CpuStatus & quote & ";" & quote & objItem.CurrentClockSpeed & quote & ";" & quote & objItem.DataWidth & quote
			TempResult=TempResult & ";" & quote & objItem.Description & quote & ";" & quote & objItem.DeviceID & quote & ";" & quote & objItem.ExtClock & quote & ";"& quote & objItem.Family & quote
			TempResult=TempResult & ";" & quote & objItem.L2CacheSize & quote & ";" & quote & objItem.L2CacheSpeed & quote & ";" & quote & objItem.Level & quote & ";" & quote & objItem.LoadPercentage & quote
			TempResult=TempResult & ";" & quote & objItem.Manufacturer & quote & ";" &  quote & objItem.MaxClockSpeed & quote & ";" & quote & objItem.PNPDeviceID & quote 
			TempResult=TempResult & ";" & quote & objItem.ProcessorId & quote & ";" & quote & objItem.ProcessorType & quote & ";" & quote & objItem.Revision & quote & ";" & quote & objItem.Role & quote
			TempResult=TempResult & ";" & quote & objItem.SocketDesignation & quote & ";" & quote & objItem.StatusInfo & quote & ";" & quote & objItem.Stepping & quote & ";" & quote & objItem.UniqueId & quote
			TempResult=TempResult & ";" & quote & objItem.UpgradeMethod & quote & ";" & quote & objItem.Version & quote & ";" & quote & objItem.VoltageCaps & quote & VbCrLf
			I=I+1
		Next
		
		LogToFile StrComputer & prefix &"CPU.txt", TempResult
	ELSE
		WmiError strComputer,"Exception in ListCPU:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	End IF
	
	IF FileOK (StrComputer & prefix &"CPU.txt" ) Then
		ListCPU=TRUE
	ELSE
		ListCPU=FALSE
	End IF
End Function
'End ListCPU
'******************************************************************************

'*******************************************************************************
Function CPULoad(strComputer)
'This function will check cpuload, IF it is high it will recheck.
	on Error resume next
	Dim CPULoadLevel 
	CpuLoadLevel = CurrentCPULoad(strComputer)
	IF CPULoadLevel > MaxCPULoad Then
		Wscript.echo "*** Checking CPU load on "& strComputer & ", CPU load is [HIGH] :[" & CPULoadLevel & "/" & MaxCPULoad & "]"
		CpuLoadLevel = CurrentCPULoad(strComputer)
		IF CPULoadLevel > MaxCPULoad Then
			Wscript.echo "*** Checking CPU load on "& strComputer & ", CPU load is [HIGH] :[" & CPULoadLevel & "/" & MaxCPULoad & "]"
			CPULoad = TRUE
			LogToFile StrComputer & prefix & "LOAD", StrComputer
			wscript.quit
		ELSE
			Wscript.echo "*** Checking CPU load on "& strComputer & ", CPU load is [OK] :[" & CPULoadLevel  & "/" & MaxCPULoad & "]"
			CPULoad = FALSE
		End IF
		CPULoad = FALSE
	ELSE
		Wscript.echo "*** Checking CPU load on "& strComputer & ", CPU load is [OK] :[" & CPULoadLevel & "/" & MaxCPULoad & "]"
		CPULoad = FALSE
	End IF
End Function
'******************************************************************************

'******************************************************************************
Function CurrentCPULoad(strComputer)
'This function just returns the CPU load
	on Error Resume Next
	Dim colItems, objItem
	Set colItems = objSWbemService.ExecQuery("Select deviceid, loadpercentage from Win32_Processor where DeviceID='CPU0'")  
	IF Err = 0 Then	
		For Each objItem in colItems
			CurrentCPULoad = objItem.LoadPercentage
			IF isNull(CurrentCPULoad) then
				CurrentCPULoad = 42 ' Prevent null return from causing an error. The system will be scanned.
			End IF
		Next
	ELSE
		wscript.echo "Exception in CurrentCPULOAD:" & vbCrLf &  " Error number: " & Err.Number & vbCrLf &   " Error Source:" & Err.Source & vbCrLf & " Error description:'" & Err.Description & vbCrLf & " WSH ver:" & WScript.Version & vbCrLf
		CurrentCPULoad = 42 ' Prevent null return from causing an error. The system will be scanned.
	End IF
End Function 
'******************************************************************************

'*******************************************************************************
Function ListHardware (strComputer)
	on Error resume next
	
	Dim ColItems, objItem, objComp
	Dim TempResult
	Wscript.Echo "------- Hardware information from " & strComputer & " -------"
	Set colItems = objSWbemService.ExecQuery("Select * from Win32_ComputerSystem")
	if err <> 0 then
		WmiError strComputer,"Exception in ListHardware, win32_computerSystem:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	Else
		if strRealComputerName <> strComputer Then 
			StrComputer=lcase(strComputer) ' to to lcase if an Alias is used (This is a compromise, originally the idea was to have strRealComputerName, in evey output file)
		End if	

		For Each objComp in colItems
			TempResult=TempResult & strComputer & ";" & quote & FormatNumber (objComp.TotalPhysicalMemory /1024 /1024,0) & "MB" & quote
			TempResult=TempResult & ";" & quote & objComp.Model & quote
			TempResult=TempResult & ";" & quote & objComp.Manufacturer & quote
			'TempResult=TempResult & strComputer & ";" & quote & objComp.UserName & quote
		Next
		strComputer=UCASE(strComputer)
	End if
'	Const HardwareHeader	= "ComputerName;PhysicalMemory;ComputerSystem_Model;ComputerSystem_Maufacturer;Bios_Caption;Bios_Manufacturer;Bios_SerialNumer;Bios_Version;Motherboard_Product;MotherBoard_Manufacturer;SystemEnclosure;SystemEnclosure_SerialNumber"
	Set colItems = objSWbemService.ExecQuery("Select * from Win32_BIOS")  
	IF Err = 0 Then	
		for each objItem in colItems
			TempResult = TempResult & ";" & quote & objItem.Caption & quote & ";" & quote & objItem.Manufacturer & quote & ";" & quote & objItem.SerialNumber & quote & ";" & quote & objItem.Version & quote 
		next
	ELSE
		WmiError strComputer,"Exception in ListHardware, Win32_Bios:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	End IF
	
	Set colItems = objSWbemService.ExecQuery("Select * from Win32_BaseBoard")  
	IF Err = 0 Then	
		for each objItem in colItems
			TempResult = TempResult & ";" & quote & objItem.Product & quote & ";" & quote & objItem.Manufacturer & quote 
		next
	ELSE
		WmiError strComputer,"Exception in ListHardware, win32_baseboard:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	End IF
	
	Set colItems = objSWbemService.ExecQuery("Select * from Win32_SystemEnclosure")  
	IF Err = 0 Then	
		for each objItem in colItems
			TempResult = TempResult  & ";" & quote & objItem.SerialNumber & quote & ";" & quote & objItem.model & quote &";" & quote & objItem.name & quote &";" & quote & objItem.manufacturer & quote
		next
	ELSE
		WmiError strComputer,"Exception in ListHardware (systemenclosure):" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	End IF	
	
	LogToFile StrComputer & prefix &"HARDWARE.txt", TempResult & vbcrlf
	IF FileOK (StrComputer & prefix &"HARDWARE.txt" ) Then
		ListHardWare=TRUE
	ELSE
		ListHardWare=FALSE
	End IF

End Function
'End listHArdware
'*******************************************************************************

'******************************************************************************
'Function list running processes
Function ListProcesses (strComputer)
	on Error Resume Next
	Dim TempResult 
	Dim objProcess, colProcess 
	Wscript.Echo "------- Process Information from "& strComputer & " -------"	
	Set colProcess = objSWbemService.ExecQuery ("Select Name, ExecutablePath from Win32_Process")
	IF Err = 0 Then	
		if strRealComputerName <> strComputer Then 
			StrComputer=lcase(strComputer) ' to to lcase if an Alias is used (This is a compromise, originally the idea was to have strRealComputerName, in evey output file)
		End if
		For Each objProcess in colProcess ' IF we can get Executable path, we do that, otherwise we take the process name
			TempResult=TempResult & strComputer & ";" & quote & objProcess.Name & quote & ";" &  quote & objProcess.ExecutablePath & quote & VbCrLf
		Next
		strComputer=UCASE(strComputer)
		LogToFile StrComputer & prefix &"PROCESS.txt", TempResult
	ELSE
		WmiError strComputer,"Exception in ListProcesses:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf		
	End IF
	IF FileOK (StrComputer & prefix &"PROCESS.txt" ) Then
		ListProcesses=TRUE
	ELSE
		ListProcesses=FALSE
	End IF
End Function
'End ListProcesses
'******************************************************************************

'******************************************************************************
Function ClusterCheck(strComputer)
	ON ERROR resume next
	Dim COLITEMS, objItem
	Dim ClusterAlias
	DIM ITEM
	Dim TempResult,TempResult2
	Dim  objSWbemServiceCluster
	Dim bError
	Wscript.Echo "------- Cluster Information from "& strComputer & " -------"	
	if (strUser<>"notset") and (strpassword<>"notset") and (strDomain<>"notset") then 
		Set objSWbemServiceCluster = objSWbemLocator.ConnectServer(strComputer,"\Root\MSCluster",strUser,strPassword,"MS_409","ntlmdomain:" + strDomain)
		if Err <> 0 then
			WmiError strComputer, "Exception in Clustercheck:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
			bError = True
		End if
	else
		Set objSWbemServiceCluster= GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\" & strComputer & "\Root\MSCluster")
		if Err <> 0 then
			WmiError strComputer, "Exception in Clustercheck:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
			bError = True
		End if
	End If
	
	if not bError then	
		Set colItems = objSWbemServiceCluster.ExecQuery("select * from MSCluster_Cluster")
		if Err <> 0 then				
			'Wscript.echo "Trying to encrypt WMI connection, to avoid issues with MS Server 2008"
			err.clear
			'Set objSWbemLocator = CreateObject("WbemScripting.SWbemLocator")
			objSWbemLocator.Security_.AuthenticationLevel = wbemAuthenticationLevelPkt
			objSWbemLocator.Security_.Privileges.AddAsString "SeSecurityPrivilege"
			if (strUser<>"notset") and (strpassword<>"notset") and (strDomain<>"notset") then 
				Set objSWbemServiceCluster = objSWbemLocator.ConnectServer(strComputer,"\Root\MSCluster",strUser,strPassword,"MS_409","ntlmdomain:" + strDomain)
				if Err <> 0 then
					WmiError strComputer, "Exception in Clustercheck:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
					bError = True
				End if
			else
				Set objSWbemServiceCluster= GetObject("winmgmts:" & "{impersonationLevel=impersonate,authenticationLevel=pktPrivacy}!\\" & strComputer & "\Root\MSCluster")
				if Err <> 0 then
					WmiError strComputer, "Exception in Clustercheck:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
					bError = True
				End if
			End If
			Set colItems = objSWbemServiceCluster.ExecQuery("select * from MSCluster_Cluster")
			if Err <> 0 then	
				WmiError strComputer, "Exception in Clustercheck:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
				err.clear
				bError = true
			End if
		End if	
		if not bError then
			For Each objItem in colItems 		
				Clusteralias = objitem.name
			Next	
			Set colItems = objSWbemServiceCluster.ExecQuery("select * from MSCluster_NodeToActiveResource")
				if Err <> 0 then
				WmiError strComputer, "Exception in Clustercheck:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
				err.clear
				End if
			if strRealComputerName <> strComputer Then 
				StrComputer=lcase(strComputer) ' to to lcase if an Alias is used (This is a compromise, originally the idea was to have strRealComputerName, in evey output file)
			End if
			For Each objItem in colItems 
				TempResult = TempResult & strComputer & ";" & quote & ClusterAlias & quote & ";" & quote & "ACTIVE" & quote & ";" & quote & replace(replace(objitem.GroupComponent,"MSCluster_Node.Name=",""),"""","") & quote & ";" & quote & replace(replace(objitem.partComponent,"MSCluster_Resource.Name=",""),"""","") & quote & vbCrLf
				TempResult2 = TempResult2 & strComputer & ";" & quote & ClusterAlias & quote & ";" & quote & replace(replace(objitem.GroupComponent,"MSCluster_Node.Name=",""),"""","") & quote & ";" & quote & replace(replace(objitem.partComponent,"MSCluster_Resource.Name=",""),"""","") & quote & vbCrLf
			next
			strComputer=ucase(strComputer)
			Set colItems = objSWbemServiceCluster.ExecQuery("select * from MSCluster_ResourceToPossibleOwner")
				if Err <> 0 then
					WmiError strComputer, "Exception in Clustercheck:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
				
					err.clear
				End if
				Dim Line
			For Each objItem in colItems 
				Line  = strComputer & ";" & quote & ClusterAlias & quote & ";" & quote & replace(replace(objitem.PartComponent,"MSCluster_Node.Name=",""),"""","") & quote & ";" & quote & replace(replace(objitem.GroupComponent,"MSCluster_Resource.Name=",""),"""","") & quote & vbCrLf
				IF not instr(TempResult2,line) > 0 Then
					TempResult=TempResult & strComputer & ";" & quote & ClusterAlias & quote & ";" & quote & "PASSIVE" & quote & ";" & quote & replace(replace(objitem.PartComponent,"MSCluster_Node.Name=",""),"""","") & quote & ";" & quote & replace(replace(objitem.GroupComponent,"MSCluster_Resource.Name=",""),"""","") & quote & vbCrLf
				End if 
			Next
		End if
	End if
	ClusterCheck=TempResult
End Function

'******************************************************************************

'******************************************************************************
'List Services
Function ListServices (strComputer)
	on Error Resume Next
	Dim bSQLFound
	Dim TempResult
	Dim TempSQLResult
	Dim strServiceEXE
	bSQLFound = FALSE
	IF bCheckServices Then
	Wscript.Echo "------- Service Information from "& strComputer & " -------"
	End IF
	Dim colItems, objWMIService, objItem
	Set colItems = objSWbemService.ExecQuery("SELECT DisplayName, State, StartMode, PathName, Name FROM Win32_Service",,48) 
	IF Err = 0 Then	
	'WMI Connected
		For Each objItem in colItems 
			if strRealComputerName <> strComputer Then 
				StrComputer=lcase(strComputer) ' to to lcase if an Alias is used (This is a compromise, originally the idea was to have strRealComputerName, in evey output file)
			End if
			if instr (UCASE(objItem.PathName),"EXE") > 0 then
				strServiceEXE=Right(left(replace(objItem.PathName,quote,""),instr(UCASE(objItem.PathName),"EXE")+2),len(left(replace(objItem.PathName,quote,""),instr(UCASE(objItem.PathName),"EXE")+2)) - instrRev(replace(objItem.PathName,quote,""),"\"))
			Else 
				strServiceEXE=""
			End if
			TempResult=TempResult & strComputer & ";" & q(objItem.DisplayName) & ";" & q(objItem.State) & ";" & q(objItem.StartMode) & ";" & q(replace(objItem.PathName,quote,"")) & ";" & q(strServiceEXE) & ";" & q(ObjItem.Name) & VBNewLine 
			strComputer=UCASE(strComputer)
			IF bSQLCheck And UCASE(objItem.Name) = "MSSQL$MICROSOFT##SSEE" Then
				'Free Product
			ElseIF bSQLCheck And (instr(UCASE(objItem.Name),"MSSQL$") = 1 and objItem.Name <> "" ) Then
					bSQLFound = TRUE	
					TempSQLResult = TempSQLResult & CheckSQL(strComputer,UCASE(objItem.Name))
			ElseIF bSQLCheck And UCASE(objItem.Name) = "MSSQLSERVER" Then
					bSQLFound = TRUE	
					TempSQLResult = TempSQLResult & CheckSQL(strComputer,UCASE("MSSQL$" & objItem.Name))
			ElseIF bSQLCheck And UCASE(objItem.Name) = "MSSQLSERVEROLAPSERVICE" Then
					bSQLFound = TRUE
					TempSQLResult = TempSQLResult & CheckSQL(strComputer,UCASE("MSSQL$" & objItem.Name))
			ElseIF bSQLCheck And UCASE(objItem.Name) = "REPORTSERVER" Then
					bSQLFound = TRUE
					TempSQLResult = TempSQLResult & CheckSQL(strComputer,UCASE("MSSQL$" & objItem.Name))
			End IF
			if ( bClusterCheck and (instr(UCASE(objItem.DisplayName),"CLUSTER SERVICE") > 0) and objItem.DisplayName <> "" ) Then
					LogToFile StrComputer & prefix &"Cluster.txt", ClusterCheck(strComputer)				
			End if
			if  ( bExchangeCheck and (instr(UCASE(objItem.DisplayName),"EXCHANGE") > 0) and objItem.DisplayName <> "" ) Then
				listExchangeVersion(StrComputer)
			End IF
			if  ( bSCCMCheck and (instr(UCASE(objItem.DisplayName),"SMS_SITE_COMPONENT_MANAGER") > 0) and objItem.DisplayName <> "" ) Then
				listSCCM(StrComputer)
			End IF
			if  ( bVMCheck and (instr(UCASE(objItem.DisplayName),"HYPER-V VIRTUAL MACHINE MANAGEMENT") > 0) and objItem.DisplayName <> "" ) Then
				listVM(StrComputer)
			End IF
			if  ( bRDLCheck and (instr(UCASE(objItem.DisplayName),"REMOTE DESKTOP LICENSING") > 0) and objItem.DisplayName <> "" ) Then
				listRDL(StrComputer)
			End IF
			if  ( bLyncRegCheck and (instr(UCASE(objItem.DisplayName),"LYNC SERVER") > 0) and objItem.DisplayName <> "" ) Then
				listLyncReg(StrComputer)
				bLyncRegCheck = FALSE
			End IF
			if  ( bLyncRegCheck and (instr(UCASE(objItem.DisplayName),"OFFICE COMMUNICATIONS SERVER") > 0) and objItem.DisplayName <> "" ) Then
				listLyncReg(StrComputer)
				bLyncRegCheck = FALSE
			End If
			if  ( bOCSCheck and (instr(UCASE(objItem.DisplayName),"OFFICE COMMUNICATIONS SERVER") > 0) and objItem.DisplayName <> "" ) Then
				listOCS(StrComputer)
				bOCSCheck = FALSE
			End If
		Next
		IF bCheckServices Then
			LogToFile StrComputer & prefix &"SERVICES.txt",TempResult
		End IF
		IF bSQLFound Then	
			TempSQLResult = TempSQLResult & Extract_SQLInformation(StrComputer)
			LogToFile StrComputer & prefix & "SQL.txt", TempSQLResult
		End IF
	ELSE
		WmiError strComputer,"Exception in ListServices:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	End IF
	IF bCheckServices Then
		IF FileOK (StrComputer & prefix &"SERVICES.txt" ) Then
			ListServices=TRUE
		ELSE
			ListServices=FALSE
		End IF
	else
		ListServices=TRUE
	end if
End Function
'End List services
'******************************************************************************
Function CutDate(strDate)
	CutDate=mid(strDate,7,2) & "/" & mid(strDate,5,2) & "/" & left(strDate,4)	
End function
Function Last(strComputer)
	on error resume next
	Dim strProfilePath
	Wscript.Echo "------- User longon Information from "& strComputer & " -------"
	strProfilePAth=ReadHKLMRegistryString(strComputer,"SOFTWARE\MICROSOFT\WINDOWS NT\CURRENTVERSION\PROFILELIST","PROFILESDIRECTORY")
	Dim TempResult
	IF not (instr(strProfilePath,"\\") > 0) Then 
		Dim ColItems, objItem, strTemp
		Set colItems = objswbemService.Execquery("Select * from win32_directory where hidden=false and path='" & replace(replace(right(strProfilePath,len(strProfilePath)-2)  & "\","\","\\"),"\\\","\\") & "' and drive='" & left(strProfilePAth,2) & "'")
		if err <> 0 then
			WmiError strComputer,"Exception in Last:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
		ELSE
			for each objItem in ColItems	
				if ucase(objItem.FileName) <> "ALL USERS" then
					TempResult= TempResult & quote & StrComputer & Quote & ";" & quote & strRealComputerName & quote & ";"& quote & objItem.FileName & Quote & ";" & quote & objItem.Name & quote & ";" & Quote & cutdate(objItem.CreationDate) & quote & ";" & quote & cutdate(objItem.LastModified) & quote _
					& ";" & quote & cutdate(objItem.LastAccessed) & quote & vbCrLf
				END IF
			Next
			LogToFile StrComputer & prefix &"UserLogons.txt", TempResult
		END IF
	END IF
End Function
'******************************************************************************

'******************************************************************************
Function ReadRegistry(sHive,strComputer,sPath,sKey,sKeyType)
	ON ERROR Resume Next
	Dim arrSubKeys, subkey
	Select Case lcase(sKeyType)
		Case "string"	objReg.GetStringValue GetHive(sHive),sPath,sKey,ReadRegistry		
		Case "dword"	objReg.GetDWORDValue  GetHive(sHive),sPath,sKey,ReadRegistry		
		Case "listkeys" objReg.EnumKey GetHive(sHive),sPath,arrSubKeys
						For Each subkey In arrSubKeys
							ReadRegistry = ReadRegistry &  subkey & VbCrLf
						Next
		Case "listvalues" objReg.EnumValues GetHive(sHive),sPath,arrSubKeys
						For Each subkey In arrSubKeys
							ReadRegistry = ReadRegistry &  subkey & VbCrLf
						Next
	End Select
End Function	'ReadRegistry	
'******************************************************************************
Function CheckMQ(strComputer)
	on Error resume next
	Wscript.Echo "------- MQ SERVER IDENTIFICATION ON "& strComputer & " -------"
	Dim TempResult
	TempResult = strComputer & 				 ";" & quote & "Local Clients\Windows NT Client" & quote & ";" & quote & ReadHKLMRegistryString(strComputer,"SOFTWARE\IBM\MQSERIES\CURRENTVERSION\COMPONENTS","Local Clients\Windows NT Client")   & quote & VbCrLf
	TempResult =  Tempresult & strComputer & ";" & quote & "FTA_Clien" & quote & ";" & quote & ReadHKLMRegistryString(strComputer,"SOFTWARE\IBM\MQSERIES\CURRENTVERSION\COMPONENTS","FTA_Client") & quote & VbCrLf
	TempResult =  Tempresult & strComputer & ";" & quote & "FTA_SERVER;"& quote & ";" & quote & ReadHKLMRegistryString(strComputer,"SOFTWARE\IBM\MQSERIES\CURRENTVERSION\COMPONENTS","FTA_Server") & quote & VbCrLf
	TempResult =  Tempresult & strComputer & ";" & quote & "FTA_Client" & quote & ";" & quote & ReadHKLMRegistryString(strComputer,"SOFTWARE\IBM\MQSERIES\CURRENTVERSION\COMPONENTS","FTA_Client") & quote & VbCrLf
	TempResult =  Tempresult & strComputer & ";" & quote & "server;" & quote & ";" & quote & ReadHKLMRegistryString(strComputer,"SOFTWARE\IBM\MQSERIES\CURRENTVERSION\COMPONENTS","Server") & quote & VbCrLf
	TempResult =  Tempresult & strComputer & ";" & quote & "XA_JAVA;" & quote & ";" & quote & ReadHKLMRegistryString(strComputer,"SOFTWARE\IBM\MQSERIES\CURRENTVERSION\COMPONENTS","XA_Java") & quote & VbCrLf
	TempResult =  Tempresult & strComputer & ";" & quote & "XA_Client;" & quote & ";" & quote & ReadHKLMRegistryString(strComputer,"SOFTWARE\IBM\MQSERIES\CURRENTVERSION\COMPONENTS","XA_Client") & quote & VbCrLf
	TempResult =  Tempresult & strComputer & ";" & quote & "Explorer;" & quote & ";" & quote & ReadHKLMRegistryString(strComputer,"SOFTWARE\IBM\MQSERIES\CURRENTVERSION\COMPONENTS","Explorer") & quote & VbCrLf
	TempResult =  Tempresult & strComputer & ";" & quote & "LicenseType;" & quote & ";" & quote & ReadHKLMRegistryString(strComputer,"SOFTWARE\IBM\MQSERIES\CURRENTVERSION","LicenseType") & quote & VbCrLf
	if scriptmode = "LOCALMODE" then 
		TempResult = TempResult & LocalMQCheck(strComputer)
	end if
	LogToFile StrComputer & prefix &"MQ.txt", TempResult
End Function

Function LocalMQCheck(strComputer)
'try DSPMQ 
	Wscript.Echo "------- MQ LOCAL SERVER IDENTIFICATION ON "& strComputer & " -------"
	on Error resume next
	Dim objExecObject
	Dim TempResult
	Dim objShell
	set objShell = WScript.CreateObject("WScript.Shell")
	Set objExecObject = objShell.Exec("cmd /c dspmq")
	if err <> 0 then
				WmiError strComputer,"Exception in LocaLMQCheck:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	End if
	Do While Not objExecObject.StdOut.AtEndOfStream
		LocalMQCheck =  LocalMQCheck & strcomputer & ";" & quote & "DSPMQ" & quote & ";" & quote & replace(trim(objExecObject.StdOut.ReadLine()),VbCrLf,"") & quote &VbCrLf
	Loop
	Do While Not objExecObject.StdErr.AtEndOfStream
		LocalMQCheck =  LocalMQCheck & strcomputer & ";" & quote & "DSPMQ Error" &quote & ";" & quote & replace(trim(objExecObject.StdErr.ReadLine()),VbCrLf,"") & quote & VbCrLf
	Loop	
End Function
'******************************************************************************
'******************************************************************************
'This function collects data depending on config settings.
Function CheckSQL(strComputer,strServiceName)
	on Error resume next
	Wscript.Echo "------- SQL Edition info from instance "& strServiceName & " on " & strComputer
	Dim COLITEMS
	
	DIM ITEM
	Dim tempEdition, TempInstance,TempEditionType,tempVersion,TempCurrentVersion,Tempisclustered,TempSKU
	Dim objSWbemServiceSQL
    Dim ArrSQLWMINamespaces(2)
    Dim StrSQLWMINamespace
    Dim ArrSQLWMIQueries(1)
    Dim StrSQLWMIQuery
    ArrSQLWMIQueries(0) = "select * from SqlServiceAdvancedProperty where servicename like '" & Replace(strServiceName, "MSSQL$", "") & "'"
    ArrSQLWMIQueries(1) = "select * from SqlServiceAdvancedProperty where servicename like '%" & Replace(strServiceName, "MSSQL$", "") & "%'"
    ArrSQLWMINamespaces(0) = "\root\Microsoft\SqlServer\ComputerManagement"
    ArrSQLWMINamespaces(1) = "\root\Microsoft\SqlServer\ComputerManagement10"
    ArrSQLWMINamespaces(2) = "\root\Microsoft\SqlServer\ComputerManagement11"
	StrSQLWMINamespace=""
    For Each StrSQLWMINamespace In ArrSQLWMINamespaces
		'wscript.echo "Checking " & StrSQLWMINamespace
		Err.Clear
		If (strUser<>"notset") and (strpassword<>"notset") and (strDomain<>"notset") Then 
			Set objSWbemServiceSQL = objSWbemLocator.ConnectServer(strComputer,StrSQLWMINamespace,strUser,strPassword,"MS_409","ntlmdomain:" + strDomain)
		else
			Set objSWbemServiceSQL = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\" & strComputer & StrSQLWMINamespace)
		End If
		'wscript.echo "Version: " & StrSQLWMINamespace		
		For Each StrSQLWMIQuery In ArrSQLWMIQueries
			'wscript.echo "Checking " & StrSQLWMIQuery
			Err.clear
			Set colItems = objSWbemServiceSQL.ExecQuery(StrSQLWMIQuery) 
			'wscript.echo " Query: " & StrSQLWMIQuery
			for each item in colitems			
				if ucase(item.propertyname) = "SKUNAME" then
					TempEdition=item.PropertystrValue
				end if
				if ucase(item.propertyname) = "CLUSTERED" then
					TempisClustered=item.PropertyNumValue
				end if
				if ucase(item.propertyname) = "VERSION" then
					TempVersion=item.PropertystrValue
				end if
				if ucase(item.propertyname) = "SKU" then
					TempSKU=item.PropertyNumValue
					tempInstance=item.ServiceName					
				end if
			next
			if strRealComputerName <> strComputer Then 
				StrComputer=lcase(strComputer) ' to to lcase if an Alias is used (This is a compromise, originally the idea was to have strRealComputerName, in evey output file)
			End if
			wscript.echo "Instance: " & tempInstance
			CheckSQL=CheckSQL & strComputer & ";" & quote & tempInstance & quote & ";" & quote & tempEdition & quote & ";" & quote & quote & ";" & Quote & TempVersion & quote & ";" & quote &quote & ";" & Quote & TempisClustered & quote & ";" & Quote & tempSKU & Quote  & vbCrLf
			strComputer=UCASE(strComputer)
		Next
	Next	
		wscript.echo "Checking via direct sQL connection"
	'Assume SQL version 2k, and try alternate method.
	'This will not run IF a system has a SQL2k and a SQL2005.
		IF strInstanceName = "MSSQLSERVER" Then
			if (strSqluser="notset")and(strsqlpassword="notset") then
				if strUser="notset" then
					CheckSQL=CheckSQL+ReadSQLVersion(strComputer,"","",strServiceName)
				else
					CheckSQL=CheckSQL+ReadSQLVersion(strComputer,"sa","",strServiceName)
				End if
			else
				CheckSQL=CheckSQL+ReadSQLVersion(strComputer,strSQLuser,strSQLpassword,strServiceName)
			End if
		ELSE
			if (strSqluser="notset")and(strsqlpassword="notset") then
				if strUser="notset" Then
					CheckSQL=CheckSQL+ReadSQLVersion(strComputer & "\" & strInstanceName,"","",strServiceName)
				else
					CheckSQL=CheckSQL+ReadSQLVersion(strComputer & "\" & strInstanceName,"sa","",strServiceName)	 'Windows credentials can't be used here
				end if
			Else
				CheckSQL=CheckSQL+ReadSQLVersion(strComputer & "\" & strInstanceName,strSqluser,strSQLpassword,strServiceName)
			end if
		End IF
		CheckSQL=CheckSQL
End Function
'******************************************************************************
'Extract SQL Server edition, version, components and clustering information
'henryma@kpmg.com.au Henry Ma
'******************************************************************************
Function Extract_SQLInformation(strComputer)
    On Error Resume Next
    Dim strOutput, strEdition, strVersion, intCluster, strPath, SQLValueName, arrSQLValueNames, strSQLPath, strSQLPathName, strProductID, arrSQLValueTypes
    strOutput = ""
    'Checking for SQL Database Engine 2000
    strEdition = ""
    strVersion = ""
    intCluster = ""
    strPath = ""
    strEdition = ReadHKLMRegistryString(strComputer,"SOFTWARE\Microsoft\MSSQLServer\Setup","Edition")
    strVersion = ReadHKLMRegistryString(strComputer,"SOFTWARE\Microsoft\MSSQLServer\Setup","Patchlevel")
    intCluster = ReadHKLMRegistryString(strComputer,"SOFTWARE\Microsoft\MSSQLServer\Setup","SqlCluster")
    strProductID = ReadHKLMRegistryString(strComputer,"SOFTWARE\Microsoft\MSSQLServer\Setup","ProductID")
    strPath = ReadHKLMRegistryString(strComputer,"SOFTWARE\Microsoft\MSSQLServer\Setup","SQLPath")
    If strEdition <> "" And strVersion <> "" Then
        strOutput = strOutput & strComputer & ";" & Quote & "MSSQL$MSSQLServer" & Quote & ";" & Quote & strEdition & Quote & ";" & Quote & Quote & ";" & Quote & strVersion & Quote & ";" & Quote & Quote & ";" & Quote & intCluster & Quote & ";" & Quote & Quote & ";" & Quote & strProductID & Quote & vbCrLf
    End If

    'Checking for SQL Database Engine 2005, 2008 and 2008R2
	objReg.EnumValues GetHive("HKEY_LOCAL_MACHINE"),"Software\Microsoft\Microsoft SQL Server\Instance Names\SQL",arrSQLValueNames, arrSQLValueTypes
    If Not IsNothing(arrSQLValueNames) And Not IsDBNull(arrSQLValueNames) Then
        For Each SQLValueName In arrSQLValueNames
            'Extracting for each SQL Server instance, the registry path
            strSQLPath = ""
            strSQLPathName = ReadHKLMRegistryString(strComputer, "Software\Microsoft\Microsoft SQL Server\Instance Names\SQL", SQLValueName)
            strSQLPath = "Software\Microsoft\Microsoft SQL Server\" & strSQLPathName & "\Setup"

            'Extracting for each SQL Server instance, the setup keys and values
            strEdition = ""
            strVersion = ""
            intCluster = ""
            strPath = ""
            strEdition = ReadHKLMRegistryString(strComputer,strSQLPath,"Edition")
            strVersion = ReadHKLMRegistryString(strComputer,strSQLPath,"Version")
            intCluster = ReadHKLMRegistryString(strComputer,strSQLPath,"SqlCluster")
            strProductID = ReadHKLMRegistryString(strComputer,strSQLPath,"ProductID")
            strPath = ReadHKLMRegistryString(strComputer,strSQLPath,"SQLPath")
            If strEdition <> "" And strVersion <> "" Then
                strOutput = strOutput & strComputer & ";" & Quote & "MSSQL$" & SQLValueName & Quote & ";" & Quote & strEdition & Quote & ";" & Quote & Quote & ";" & Quote & strVersion & Quote & ";" & Quote & Quote & ";" & Quote & intCluster & Quote & ";" & Quote & Quote & ";" & Quote & strProductID & Quote & vbCrLf
            End If
        Next
        arrSQLValueNames = vbNull
    End If

    'Checking for SQL Analysis Services 2005, 2008 and 2008R2 
	objReg.EnumValues GetHive("HKEY_LOCAL_MACHINE"),"Software\Microsoft\Microsoft SQL Server\Instance Names\OLAP",arrSQLValueNames, arrSQLValueTypes
    If Not IsNothing(arrSQLValueNames) And Not IsDBNull(arrSQLValueNames) Then
        For Each SQLValueName In arrSQLValueNames
            'Extracting for each SQL Server instance, the registry path
            strSQLPath = ""
            strSQLPathName = ReadHKLMRegistryString(strComputer,"Software\Microsoft\Microsoft SQL Server\Instance Names\OLAP", SQLValueName)
            strSQLPath = "Software\Microsoft\Microsoft SQL Server\" & strSQLPathName & "\Setup"

            'Extracting for each SQL Server instance, the setup keys and values
            strEdition = ""
            strVersion = ""
            intCluster = ""
            strPath = ""
            strEdition = ReadHKLMRegistryString(strComputer,strSQLPath,"Edition")
            strVersion = ReadHKLMRegistryString(strComputer,strSQLPath,"Version")
            intCluster = ReadHKLMRegistryString(strComputer,strSQLPath,"SqlCluster")
            strProductID = ReadHKLMRegistryString(strComputer,strSQLPath,"ProductID")
            strPath = ReadHKLMRegistryString(strComputer,strSQLPath,"SQLPath")
            If strEdition <> "" And strVersion <> "" Then
                strOutput = strOutput & strComputer & ";" & Quote & "MSSSAS$" & SQLValueName & Quote & ";" & Quote & strEdition & Quote & ";" & Quote & Quote & ";" & Quote & strVersion & Quote & ";" & Quote & Quote & ";" & Quote & intCluster & Quote & ";" & Quote & Quote & ";" & Quote & strProductID & Quote & vbCrLf
            End If
        Next
        arrSQLValueNames = vbNull
    End If

    'Checking for SQL Reporting Services 2005, 2008 and 2008R2
	objReg.EnumValues GetHive("HKEY_LOCAL_MACHINE"),"Software\Microsoft\Microsoft SQL Server\Instance Names\RS",arrSQLValueNames, arrSQLValueTypes
    If Not IsNothing(arrSQLValueNames) And Not IsDBNull(arrSQLValueNames) Then
        For Each SQLValueName In arrSQLValueNames
            'Extracting for each SQL Server instance, the registry path
            strSQLPath = ""
            strSQLPathName = ReadHKLMRegistryString(strComputer,"Software\Microsoft\Microsoft SQL Server\Instance Names\RS", SQLValueName)
            strSQLPath = "Software\Microsoft\Microsoft SQL Server\" & strSQLPathName & "\Setup"

            'Extracting for each SQL Server instance, the setup keys and values
            strEdition = ""
            strVersion = ""
            intCluster = ""
            strPath = ""
            strEdition = ReadHKLMRegistryString(strComputer,strSQLPath,"Edition")
            strVersion = ReadHKLMRegistryString(strComputer,strSQLPath,"Version")
            intCluster = ReadHKLMRegistryString(strComputer,strSQLPath,"SqlCluster")
            strProductID = ReadHKLMRegistryString(strComputer,strSQLPath,"ProductID")
            strPath = ReadHKLMRegistryString(strComputer,strSQLPath,"SQLPath")
            If strEdition <> "" And strVersion <> "" Then
                strOutput = strOutput & strComputer & ";" & Quote & "MSSSRS$" & SQLValueName & Quote & ";" & Quote & strEdition & Quote & ";" & Quote & Quote & ";" & Quote & strVersion & Quote & ";" & Quote & Quote & ";" & Quote & intCluster & Quote & ";" & Quote & Quote & ";" & Quote & strProductID & Quote & vbCrLf
            End If
        Next
        arrSQLValueNames = vbNull
    End If

    'Checking for SQL Integration Services 2005
    strEdition = ""
    strVersion = ""
    intCluster = ""
    strPath = ""
    strSQLPath = "SOFTWARE\Microsoft\Microsoft SQL Server\90\DTS\Setup"
    strEdition = ReadHKLMRegistryString(strComputer,strSQLPath,"Edition")
    strVersion = ReadHKLMRegistryString(strComputer,strSQLPath,"Version")
    intCluster = ReadHKLMRegistryString(strComputer,strSQLPath,"SqlCluster")
    strProductID = ReadHKLMRegistryString(strComputer,strSQLPath,"ProductID")
    strPath = ReadHKLMRegistryString(strComputer,strSQLPath,"SQLPath")
    If strEdition <> "" And strVersion <> "" Then
        strOutput = strOutput & strComputer & ";" & Quote & "Integration Services 2005" & Quote & ";" & Quote & strEdition & Quote & ";" & Quote & Quote & ";" & Quote & strVersion & Quote & ";" & Quote & Quote & ";" & Quote & intCluster & Quote & ";" & Quote & Quote & ";" & Quote & strProductID & Quote & vbCrLf
    End If

    'Checking for SQL Integration Services 2008 and 2008R2
    strEdition = ""
    strVersion = ""
    intCluster = ""
    strPath = ""
    strSQLPath = "SOFTWARE\Microsoft\Microsoft SQL Server\100\DTS\Setup"
    strEdition = ReadHKLMRegistryString(strComputer,strSQLPath,"Edition")
    strVersion = ReadHKLMRegistryString(strComputer,strSQLPath,"Version")
    intCluster = ReadHKLMRegistryString(strComputer,strSQLPath,"SqlCluster")
    strProductID = ReadHKLMRegistryString(strComputer,strSQLPath,"ProductID")
    strPath = ReadHKLMRegistryString(strComputer,strSQLPath,"SQLPath")
    If strEdition <> "" And strVersion <> "" Then
        strOutput = strOutput & strComputer & ";" & Quote & "Integration Services 2008 & 2008 R2" & Quote & ";" & Quote & strEdition & Quote & ";" & Quote & Quote & ";" & Quote & strVersion & Quote & ";" & Quote & Quote & ";" & Quote & intCluster & Quote & ";" & Quote & Quote & ";" & Quote & strProductID & Quote & vbCrLf
    End If
	if(" " & strOutput = " ")then
		wscript.echo "registry collection of SQL install information failed"
	else
		wscript.echo "registry collection of SQL install information succeeded"
	end if
    Extract_SQLInformation = strOutput

End Function

'******************************************************************************
Function InstanceID (strComputer,strInstanceName)
	'This function can convert an instance name to an instance ID, needed for SQL 2008
	InstanceID=ReadHKLMRegistryString(strComputer,"SOFTWARE\MICROSOFT\MICROSOFT SQL SERVER\INSTANCE NAMES\SQL",strInstanceName)
End Function
'******************************************************************************


'******************************************************************************
Function ReadHKLMRegistryString(strComputer,sPath,sKey)
	ReadHKLMRegistryString	= ReadRegistry("HKEY_LOCAL_MACHINE",strComputer,sPath,sKey,"string")
End Function
'*******************************************************************************

'*******************************************************************************
Function ReadHKLMRegistrydword(strComputer,sPath,sKey)
	ReadHKLMRegistrydword	= ReadRegistry("HKEY_LOCAL_MACHINE",strComputer,sPath,sKey,"dword")
End Function
'*******************************************************************************

'*******************************************************************************
Function ReadHKLMListKeys(strComputer,sPath)
	ReadHKLMListKeys		= ReadRegistry("HKEY_LOCAL_MACHINE",strComputer,sPath,"","listkeys")
End Function
'********************************************************************************
'*******************************************************************************
Function ReadHKLMListValues(strComputer,sPath)
	ReadHKLMListValues		= ReadRegistry("HKEY_LOCAL_MACHINE",strComputer,sPath,"","listvalues")
End Function
'********************************************************************************

'*******************************************************************************
Function GetHive(sHive)
	Select Case UCASE(sHive)
		Case "HKEY_CLASSES_ROOT"	GetHive	= &H80000000 
		Case "HKEY_CURRENT_USER"	GetHive	= &H80000001 
		Case "HKEY_LOCAL_MACHINE"	GetHive	= &H80000002
		Case "HKEY_USERS"			GetHive	= &H80000003 
		Case "HKEY_CURRENT_CONFIG"	GetHive	= &H80000005 
		Case "HKEY_DYN_DATA"		GetHive	= &H80000006
		Case ELSE wscript.echo "Unknown HiveType in GetHive"
				  wscript.quit
	End select
End Function 'GetHive
'******************************************************************************

'******************************************************************************
'*This function collects data depending on config settings                    *
'*ListOS is NOT optional                                                      *
'*ListInstalledSoftware is NOT optional                                       *
'******************************************************************************
Function CollectData (strComputer)
	on Error Resume Next
	strRealcomputername = ""
	RealComputerName(strComputer) ' Fill globalvar
	
	if strComputer <> strRealComputerName then
		wscript.echo "*** Info: ComputerName:" & strcomputer & " seems to be an alias, the realname is:" & strRealComputerName
	End if
	
	Dim bDone ' Is all ok 
	bDone=TRUE
	'Check OS	(Will exit IF OS=Workstation and bonlycheckservers is true)
	IF Not ListOS (strComputer) Then
		bDone=FALSE
	End IF

	'List installed software.
	IF not ListInstalledSoftware(strComputer) Then
		bDone=FALSE
	End IF	
	
	IF bCheckCPU Then
		IF not ListCPU(strComputer) Then
			bDone=FALSE
		End IF
	End IF
	
	IF bCheckHardware Then
		IF not ListHardware(strComputer) Then
			bDone=FALSE
		End IF
	End IF
	
	IF bCheckIP Then
		IF not ListIP (strComputer) Then
			bDone=FALSE
		End IF
	End IF		

	IF bCheckProcesses Then
		IF not ListProcesses(strComputer) Then
			bDone=FALSE
		End IF
	End IF


	IF not ListServices(strComputer) Then
		bDone=FALSE
	End IF

	IF bCheckShares Then
		'No error checking, systems can have no shares.
		ListShares(strComputer) 
	END IF
	
	if bCheckEvtLog and not Win2kMode then
		evt(strComputer)
	END IF

	'List current user
	If bCheckCurrentUser = TRUE Then
		IF not ListCurrentUser(strComputer) = TRUE Then
			'bDone=FALSE
		End IF
	End If
    
	
	'List recent user(s).
	If bCheckUsers = TRUE Then
		IF not ListLastUsers(strComputer) = TRUE Then
			bDone=FALSE
		End IF
    	End If
    
	'List user folders
	If bCheckUserFolders = TRUE Then
		IF not ListUserFolders(strComputer) = TRUE Then
			bDone=FALSE
		End IF
	End If
	
	if bCheckLoggedonUsers then
		last(strComputer)
	END IF
	if bListLocalUsersAndGroups then
		ListLocalUsers(strComputer)
		if bByPassGroupChecksOnPDC Then
			Dim strSystemRole
			strSystemRole=GetSystemRole(strComputer)
			IF not instr(strSystemRole,"Domain") > 0 Then
				ListLocalGroups(strComputer)
			End if
		Else 
			ListLocalGroups(strComputer)	
		End if
	end if
	
	
	Wscript.echo "*** Done getting data from " & strComputer
	'CheckOutPut
	IF bDone Then
		wscript.echo "*** Complete, output seems correct"
		LogToFile StrComputer & prefix & "Done", StrComputer
		DeleteFile(OutPutPath & StrComputer & prefix & "WMI.Error") 	'Clean up
	ELSE
		wscript.echo "*** Error, output seems incorrect"
		LogToFile StrComputer & prefix & "Error", StrComputer
	End IF
	wscript.sleep WaitingTime
End Function
'End CollectData
'******************************************************************************

'******************************************************************************
'This function will load all systems in .\serverlist.txt into the array ArrServerName
Function FillServerArray
	Dim I
	Dim objFSO, ObjTextFile
	Dim TempTxt, arrTemp
	'FillArray from file
	Set objFSO = CreateObject("Scripting.FileSystemObject")	
	Set objTextFile = objFSO.OpenTextFile (OutPutPath & "..\Serverlist.txt", ForReading)
	Do Until objTextFile.AtEndOfStream
		TempTxt = UCASE(Trim(objTextFile.Readline)) 
		IF instr(TempTxt,";") > 0 Then  ' Check if serverlist contains ";", indicating that it has been created by createADLIST, isolate the servername.
			arrTemp=split(TempTxt,";")
			IF arrTemp(0) <> "" then
				TempTxt=arrTemp(0)
			ELSE
				TempTxt="" ' Skip likes with Empty servername. (Lines, containing a leading ;)
			END IF
		END IF
		IF TempTxt <> "" Then
			redim preserve ArrServerName(I)
			ArrServerName(I) = TempTxt
			I=I+1
		End IF
	Loop
	if isempty (ArrServerName) then
	
	wscript.echo "EMPTY"
	END IF
	
	on error Resume Next
	I=ubound(ArrServerName)
	if err=0 then
		wscript.echo "Read " & ubound(ArrServerName) + 1  & " Systems into memory"
	Else
		wscript.echo "Nothing to scan!"
		wscript.echo "Serverlist.txt seems empty"	
		wscript.quit
	End if
	
End Function
'******************************************************************************

'******************************************************************************
Function DeleteFile (sFileName)
	Dim objFSO
	Set objFSO = CreateObject("Scripting.FileSystemObject")	
	IF objFSO.FileExists(sFileName) Then
		objFSO.DeleteFile (sFileName)
	End IF
End Function  ' Delete file
'******************************************************************************


'******************************************************************************
'This function will create a file (like unix touch command)
Function Touch (strName)
'Like the unix command Touch, this function just creates a file
	Dim objFSO, ObjFile
	Set objFSO = CreateObject("Scripting.FileSystemObject")
	Set objFile = objFSO.CreateTextFile(OutPutPath & strName)
	objFile.Close
End Function
'******************************************************************************

'******************************************************************************
Function ArgumentError
	wscript.echo "IF used with arguments, only one argument is allowed:"
	wscript.echo ScriptName & " /server:server1 (to scan server1)"
	wscript.echo ScriptName & " /Local (to scan localhost)"
	wscript.echo ScriptName & " /ListAdUsersAndGroups (to make AD USER and GROUP extract)"
	wscript.echo ScriptName & " /ListAdGroups (to make AD GROUP extract)"
	wscript.echo ScriptName & " /ListAdUsers(to make AD USER extract)"
	wscript.echo ScriptName & " /ListActiveComputers (to make AD computer extract)"
	wscript.echo "** Scanning servers with alternative credentials:"
	wscript.echo ScriptName & " /server:server1 /USER:administrator /password:secret /domain:mydomain"
	wscript.echo "please note that domain can be left blank, due to WMI limitations password can't be blank"
	wscript.quit	
End function
'******************************************************************************

'*******************************************************************************
'This function will check IF serverlist.txt exist.
Function StartUp
	Dim choice
	Dim wshshell
	Set WshShell = WScript.CreateObject("WScript.Shell") 	
	if err <> 0  then
				WmiError "Host Scanning","Exception in Startup:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	End if
	Dim ArgumentCount, sArgument
	
	ArgumentCount = WScript.Arguments.Count
	Select Case ArgumentCount
	Case "0"
		'No Arguments, search for serverlist.txt or prompt for input.
		IF IfExist( FullPath & "\serverlist.txt") and ArgumentCount=0 and not win2kmode Then
			ScriptMode="SERVERLIST"
		ELSE
			if Win2kMode then
				Do
					Wscript.echo "Press <L> IF you just want to run the script on this system"
					Wscript.echo "Press (L) and Then press the <Enter> key."
					choice = lcase(Wscript.StdIn.ReadLine)
				} Loop While choice <> "l"
			else
				Do
					Wscript.echo "Press <A> IF you just want to run the script against systems in Active Directory."
					Wscript.echo "Press <L> IF you just want to run the script on this system"
					Wscript.echo "Press (A\L) and Then press the <Enter> key."
					choice = lcase(Wscript.StdIn.ReadLine)
				} Loop While choice <> "l" and choice <> "a"
			End if
			IF choice = "a" Then
				ScriptMode="AD"
			End IF
			
			IF choice = "l" Then
				ScriptMode="LOCALMODE"
				redim preserve ArrServerName(0)	
				ArrServerName(0) = LocalComputerName
			End IF
						
		End IF
	Case "1"
		Dim strTmpComputerName
		strTmpComputerName=LocalComputerName()
		sArgument=UCASE(WScript.Arguments.Item(0))
		IF Win2kMode Then 
			if (instr(sArgument,"/LOCAL") > 0) then
				wscript.echo "*** Running in localmode"
			Else
				Wscript.echo "Older WSH version detected, only localmode allowed, exiting..."
				wscript.echo sArgument
				wscript.quit
			End if
		END If
		IF (instr(sArgument,"/SERVER:") > 0) and sArgument<>"/SERVER:" Then 
			sArgument=replace(sArgument,"/SERVER:","")
			redim preserve ArrServerName(0)	
			ArrServerName(0) = sArgument
			ScriptMode="ARGUMENT"
		ELSEIF (instr(sArgument,"/LOCAL") > 0) Then 
			ScriptMode="LOCALMODE"
			redim preserve ArrServerName(0)	
			ArrServerName(0) = strTmpComputerName
		ELSEIF (instr(sArgument,"/LISTACTIVECOMPUTERS") > 0) Then 
			CreateADList()
			wscript.quit
		ELSEIF (instr(sArgument,"/LISTADUSERSANDGROUPS") > 0) Then 
			DetectWSHVersion		'Check WSH version
			CheckCurrentDirectory 	' See IF script is executed from current directory
			CreateOutputDirectory 	'Create output folder.
			connectWMI(strTmpComputerName)	
			ListAdUsers(strTmpComputerName)
		    ListADGroups(strTmpComputerName)
			wscript.quit
		ELSEIF (instr(sArgument,"/LISTADGROUPS") > 0) Then
			DetectWSHVersion		'Check WSH version
			CheckCurrentDirectory 	' See IF script is executed from current directory
			CreateOutputDirectory 	'Create output folder.
			connectWMI(strTmpComputerName)	
		    ListADGroups(strTmpComputerName)
			wscript.quit
		ELSEIF (instr(sArgument,"/LISTADUSERS") > 0) Then
			DetectWSHVersion		'Check WSH version
			CheckCurrentDirectory 	' See IF script is executed from current directory
			CreateOutputDirectory 	'Create output folder.
			connectWMI(strTmpComputerName)	
			ListAdUsers(strTmpComputerName)
			wscript.quit
		ELSE
			ArgumentError
		End IF
	Case "4"		
		IF Win2kMode then
			Wscript.echo "Older WSH version detected, only localmode allowed, exiting..."
			wscript.quit
		End if
		
		Dim objArgs, strarg
		Dim TempServer
		tempServer="notset"
		Set objArgs = Wscript.Arguments
		for each strArg in objArgs
			IF (instr(ucase(strArg),"/SERVER:") > 0) and UCASE(strArg)<>"/SERVER:" Then 
				redim preserve ArrServerName(0)	
				ArrServerName(0) = replace(UCASE(strArg),"/SERVER:","")
				tempServer=replace(UCASE(strArg),"/SERVER:","")
				ScriptMode="ARGUMENT"
			End if 
			IF (instr(UCASE(strArg),"/USER:") > 0)  Then 
				strUser=replace(UCASE(strArg),"/USER:","")
			End if 
			IF (instr(UCASE(strArg), "/PASSWORD:") > 0) Then 
				strPassword=replace(strArg,"/PASSWORD:","",1,1,1)
			End if
			IF (instr(UCASE(strArg),"/DOMAIN:") > 0)  Then 
				strDomain=replace(UCASE(strArg),"/DOMAIN:","")
			End if
		next
		if (strDomain ="notset") OR (strUser = "notset") or (strPassword  = "notset") or (tempServer = "notset") then
			ArgumentError
		End if
	Case ELSE
		ArgumentError
	End Select
		'Wscript.echo "Running script against " & ArrServerName(0)	
End Function
'******************************************************************************

'*******************************************************************************
Function LocalComputerName
'Returns the LocalComputerName
	Dim objNetwork
	Set objNetwork = WScript.CreateObject("WScript.Network")
	if err<>0 then
				WmiError "Scanning host","Exception in LocalComputerName:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	End if
	LocalComputerName = UCASE(trim(objNetwork.ComputerName))
End Function
'******************************************************************************

'*******************************************************************************
'This function is TRUE IF the file exists
Function IfExist (sFileName)
	Dim objFSO
	Set objFSO = CreateObject("Scripting.FileSystemObject")
	IF objFSO.FileExists( quote & sFileName & quote ) Then
		IfExist = TRUE
	ELSE
		IF objFSO.FileExists(sFileName) Then
			IfExist = TRUE
		End IF
	End IF
End Function 
'******************************************************************************

'********************************************************************************
Function CheckAdminAccess(strComputer)
'Will return TRUE IF user has admin access to box!
'it will check by trying to locate explorer.exe
	on Error Resume Next
	Dim objFSO
	Set objFSO = CreateObject("Scripting.FileSystemObject")
	CheckAdminAccess = objFSO.FileExists("\\" & strComputer & "\admin$\explorer.exe")
End Function ' CheckAdminAccess
'********************************************************************************

'******************************************************************************
'This function will return TRUE IF the hostname/ip responds
Function Ping(strComputer)
	on Error resume next
	IF UCASE(scriptmode) = "LOCALMODE" Then
		'Skipping in LOCALMODE, to avoid issues with older windows versions which does not support the Win32_PingStatus (Windows 2000 and below)
		Ping = True
	ELSE
		Dim objPing, oRetStatus
		Set objPing = GetObject("winmgmts:{impersonationLevel=impersonate}").ExecQuery("select * from Win32_PingStatus where address='" & strComputer & "'")
		if err<>0 then
					WmiError strComputer,"Exception in Ping:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
		end if
		For Each oRetStatus In objPing
			IF  oRetStatus.StatusCode = 0 Then
				Ping = True
			ELSE
				Ping = False
			End IF
			Set oRetStatus = Nothing
			set objping = Nothing
		Next
	End IF
 End Function ' Ping
'******************************************************************************

'******************************************************************************
'This Function Check IF all is ok, and then calls collectdata IF all is [OK]
Function CheckServer(strComputer)
	on error Resume Next
				
	if scriptmode <> "LOCALMODE" then
		IF ScriptThreads(strComputer) > 1 Then
			wscript.echo "**** Skipping " & StrComputer &", a query is already running aginst this system" 
			wscript.sleep WaitingTime
			wscript.quit
		End IF		
		CleanUp(strComputer)
	End if
	
	IF IfExist (OutPutPath & StrComputer & prefix & "done") Then
		wscript.echo "**** Skipping " & StrComputer &", it has already been completed"
		wscript.sleep WaitingTime
		if not bDebug Then
			wscript.quit
		End if
	End IF
	
	
	IF ping(StrComputer) Then
		wscript.echo "*** " & StrComputer & " is online"
	ELSE
		wscript.echo "*** " & StrComputer & " is offline"
		LogToFile StrComputer & prefix & "offline", StrComputer ' Create <servername><prefix>offline
		wscript.sleep WaitingTime
		'wscript.quit 'Exit
	End IF
	
	IF bCheckAdmin Then
		IF CheckAdminAccess(StrComputer) Then
			wscript.echo "*** You have Admin access on " & StrComputer
		ELSE
			wscript.echo "*** You do NOT have Admin access on " & StrComputer
			LogToFile StrComputer & prefix & "noadmin", StrComputer
			IF bIgnoreCheckAdmin Then
				Wscript.echo "*** Trying to collect data from " & StrComputer & " anyway"
			ELSE
				wscript.sleep WaitingTime
				wscript.quit ' Exit
			END IF
		END IF	
	END IF
	
	connectwmi(strComputer)		
	IF bCPULoadCheck Then
		IF CPULoad(StrComputer) Then
			wscript.sleep WaitingTime
			wscript.quit ' Exit Load on system X.
		End IF
	End IF
'IF we arrive here without exiting, all is ok. CollectData!
	CollectData (StrComputer)
End Function ' checkserver
'******************************************************************************

'******************************************************************************
'*This function deletes error files before checking a system*******************
'******************************************************************************
Function CleanUp (strComputer)
	'DeleteFile(OutPutPath & StrComputer & prefix & "WMI.Error") 	'Clean up
	DeleteFile(OutPutPath & StrComputer & prefix & "offline") 		'Clean up
	DeleteFile(OutPutPath & StrComputer & prefix & "Error") 		'Clean up
	DeleteFile(OutPutPath & StrComputer & prefix & "Noadmin") 		'Clean up
	DeleteFile(OutPutPath & StrComputer & prefix & "Workstation")	'Clean up
	DeleteFile(OutPutPath & StrComputer & prefix & "LOAD") 			'Clean up
End Function
'******************************************************************************

'******************************************************************************
Function ShowStatus()
	on Error Resume Next
	'This function will report incorrect numbers if many threads are active.
	'This is why the pause function is inserted here.
	
	IF ScriptThreads("%") > 1 Then
		wscript.sleep 6000
	End IF
	IF ScriptThreads("%") < 1 Then
		stats ()
		Dim TempResult
		TempResult=TempResult & "Number of systems                                    :" & ubound(ArrServerName) + 1 & VBNewLine 
		TempResult=TempResult & "Number of systems skipped due to high CPU LOAD       :" & intLoad & VBNewLine 
		TempResult=TempResult & "Number of systems offline                            :" & intOffline & VBNewLine 	
		TempResult=TempResult & "Number of systems completed with no errors           :" & intDone & VBNewLine 
		TempResult=TempResult & "Number of systems completed, with incomplete output  :" & intError & VBNewLine 
		wscript.echo TempResult	
		AppendToFile cStatusFile, sFileHeader & TempResult
		ShowStatus=TRUE
		'Check IF all systems has been marked as done, IF yes, then exit
		IF intDone = ubound(ArrServerName) + 1 Then
			wscript.echo "Audit complete, exiting"
			wscript.quit
		End IF
	ELSE
		ShowStatus=FALSE
	End IF
End Function ' ShowStatus
'******************************************************************************

'*******************************************************************************
'Date conversion
Function Integer8Date(objDate)
    Dim lngAdjust, lngDate, lngHigh, lngLow
    lngHigh = objDate.HighPart
    lngLow = objDate.LowPart
    IF (lngHigh = 0) And (lngLow = 0) Then
        lngAdjust = 0
    End IF
    lngDate = #1/1/1601# + (((lngHigh * (2 ^ 32)) + lngLow) / 600000000 ) / 1440
    Integer8Date = CDate(lngDate)
End Function
'******************************************************************************
'******************************************************************************
Function Evt(strComputer)
	on error Resume Next
	Wscript.Echo "------- Msinstaller information from "& strComputer & " -------"
	Dim objEvents,objEvent
	Dim I
	Dim lngEventCount
	
	Dim objFSO, objFile, SOutputFile 	'Filesystem vars.
	Set objFSO = CreateObject("Scripting.FileSystemObject")
	sOutPutFile = StrComputer & prefix & "MsiInstaller.txt"
	DeleteFile(OutPutPath & sOutPutFile) 'Delete File to avoid create/Overwrite issues
	Set objFile = objFSO.CreateTextFile(OutPutPath & sOutPutFile, ForAppending, TRUE) 
	Set objEvents = objSWbemService.ExecQuery ("Select * from Win32_NTLogEvent where LogFile = 'Application' and sourcename='MSIinstaller'")
	if err <> 0 then	
		WmiError strComputer,"Exception in Evt3:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
	Else
		lngEventcount=objEvents.Count
		if objEvents.Count=0 then
			'No events
				objFile.WriteLine strComputer & ";" & q(strComputer) & ";EMPTY;EMPTY;EMPTY;;;EMPTY;EMPTY;EMPTY" 
				wScript.StdOut.Write "."	
		else
			For Each objEvent in objEvents
				I=I+1
				If I = 1 Then ' Show first Event
					objFile.WriteLine strComputer & ";" & q(objEvent.ComputerName) & ";START;START;START;" & q(objEvent.TimeWritten) & ";START;START;START;" & q(objEvent.LogFile)					
				End if			
				
				if bIgnoreMSIFailed and instr(UCASE(objEvent.Message),"FAIL") > 0 then
					'wscript.echo objevent.message
				Else
					objFile.WriteLine strComputer & ";" & ShowEvent(objEvent)
				End if
				wScript.StdOut.Write "."			
				
				if I = lngEventcount Then ' Show Last Event
					objFile.WriteLine strComputer & ";" & quote & objEvent.ComputerName  & Quote & ";END;END;END;" & Quote  & objEvent.TimeWritten  & Quote & ";END;END;END;" & Quote & objEvent.LogFile & Quote
				End if
			Next
		End if
	End if
	set objEvents= nothing
	objFile.Close
	WScript.StdOut.WriteBlankLines(1)
End function
'******************************************************************************

'******************************************************************************
Function ShowEvent(objEvent)	
	on error resume next
	Dim strMessage, strType
	strType=""
	strMessage=replace ("" & objEvent.Message,";",",") 'Avoid null replacement and ; -> ,

	'Some OS'es seem to return a String
	if VarType(objEvent.Type) = 8 Then
		StrType=objEvent.Type ' Contains a String
	Else
		Select Case(objEvent.Type)
			case 1 strType="Error"
			Case 2 strType="Warning"
			case 3 strType="Information" 
			case 4 strType="Security Audit Success"
			case 5 strType="Security Audit Failure"		
		End select
	End IF
	showevent=""
	ShowEvent= quote & objEvent.ComputerName  & Quote & ";" & Quote & objEvent.Category & Quote & ";" & Quote & objEvent.EventCode & Quote & ";" & Quote & replace(replace(strMessage,chr(10),""),chr(13),"") & Quote & ";" & Quote  & objEvent.TimeWritten  & Quote & ";" & quote & objEvent.SourceName & Quote & ";" & Quote & strType  & Quote & ";" & Quote & objEvent.User & Quote & ";" & Quote & objEvent.LogFile & Quote
End function
'******************************************************************************'******************************************************************************

'******************************************************************************
'This functions generates a list of domains in the forest.
Function GetDomainList
	on Error resume next
	Dim objConn, objRootDSE, objRS
	Dim strDomainlist
	set objRootDSE = GetObject("LDAP://RootDSE")
	set objConn = CreateObject("ADODB.Connection")
	objConn.Provider = "ADsDSOObject"
	objConn.Open "Active Directory Provider"
	set objRS = objConn.Execute("<GC://" & objRootDSE.Get("rootDomainNamingContext") & ">;(objectcategory=domainDNS);name;SubTree")
	objRS.MoveFirst
	while Not objRS.EOF
		IF strDomainList <> "" Then 
			strDomainList = strDomainList & ";"
		End IF	
		strDomainList=strDomainList & objRS.Fields(0).Value
		objRS.MoveNext
	wend
	GetDomainList=strDomainList
End Function 'GetDomainList
'******************************************************************************

'******************************************************************************
'This function returns TRUE IF the file exist and is more than BytesNeeded in size
Function FileOk(sFileName)
	Dim objFSO
	Dim objFile
	Set objFSO = CreateObject("Scripting.FileSystemObject")
	IF objFSO.FileExists(OutPutPath & sFileName) Then
	  set objFile = objFSO.GetFile(OutPutPath & sFileName)	
		IF objFile.size > BytesNeeded Then 
			FileOk = TRUE
		ELSE
			FileOk = FALSE
			wscript.echo "*** Error," & OutPutPath & sFileName & " is not as big as expected"
		End IF
	ELSE
		FileOk = FALSE
		wscript.echo "*** Error," & OutPutPath & sFileName & " does not exist"
	End IF
End Function  ' FileSize
'******************************************************************************

'******************************************************************************
Function ScriptThreads (strComputer)
'Return the number of active threads
	Dim procItems, procItem
	Set procItems = GetObject("winmgmts:{impersonationLevel=impersonate}").ExecQuery("Select * from Win32_Process WHERE Name='cscript.exe' AND CommandLine LIKE '%/SERVER:" & strComputer &"'")
	if Err <> 0 then
				WmiError strComputer,"Exception in ScriptThreads:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
		ScriptThreads = 0
		
	Else
		if bDebug Then
			For Each procItem in procItems
					wscript.echo "Running process:" & procItem.CommandLine
			Next
		End if
		ScriptThreads = procItems.Count 
	End if
End Function
'******************************************************************************


'******************************************************************************
'Force a cscript 
Function Force_Cscript
    IF right(lCase(wscript.fullname),11)= "wscript.exe" Then
        wscript.echo "Please start the script from a DOS prompt, using cscript " & ScriptName
        wscript.echo "Please refer to the manual for instructions."
        wscript.echo "Exiting, script Version:" & Version
        wscript.quit
		'Could start cscript instead, but this will cause the window to close as soon as 
		'The script has completed, making output unreadable from the screen.
    End IF
	'The script uses the name to locate running processes etc., so renaming it will cause that to fail.
	IF NOT instr(UCASE(WScript.ScriptFullName),UCASE(ScriptName)) > 0 Then  
		wscript.echo "Please rename the script to "& ScriptName &" and try again."
        wscript.echo "Exiting, script Version:" & Version
        wscript.quit
	End If
End Function
'******************************************************************************
 
'******************************************************************************
  Function Rpad (MyValue, MyPadChar, MyPaddedLength)
  on Error Resume next
    Rpad = MyValue & string(MyPaddedLength - Len(MyValue), MyPadChar)
  End Function
'******************************************************************************

'******************************************************************************
  Function Lpad (MyValue, MyPadChar, MyPaddedLength)
  on Error Resume next
	Lpad = string(MyPaddedLength - Len(MyValue),MyPadChar) & MyValue
  End Function
'******************************************************************************

'******************************************************************************
Function SpawnThreads
	Dim I
	Dim wshshell
	Dim ScriptHost ' Host where the script runs from:
	ScriptHost=LocalComputerName
	Set WshShell = WScript.CreateObject("WScript.Shell") 
	Pass=1
	Set objSWbemService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\.\root\cimv2")
	if err <> 0 then
		Wscript.echo "Error in spawnThreads"
		wscript.echo "This script can only run in localmode on Windows 2000 or older"
		Wscript.echo "If scanning remote computers, please use a newer OS."
	End if
	'In AD or in serverlist mode:
	Do Until (pass > passmax) or ((pass > passlimit) and (DateDiff("n", StartTime, Now) > PassLimitMinutes))
		Wscript.echo "****************************************************"
		Wscript.echo "****************************************************"
		Wscript.echo "* The script has been running for " & DateDiff("n", StartTime, Now) & " minutes"
		Wscript.echo "* The script has completed " & Pass & " passes"
		Wscript.echo "* The script used is Version:" & Version
		Wscript.echo "****************************************************"
		Wscript.echo "****************************************************"
		IF (pass > passlimit) then
			wscript.echo "*** The script will exit after " &  PassLimitMinutes  - DateDiff("n", StartTime, Now) & " minutes or " & PassMax &" passes."	
		ELSE
			IF (DateDiff("n", StartTime, Now) > PassLimitMinutes) then
				wscript.echo "*** The script will exit after " & Passlimit &" passes has been completed"
			ELSE
				wscript.echo "*** Pass ["& pass & "\" & PassLimit &"] the script will exit after " &  PassLimitMinutes  - DateDiff("n", StartTime, Now) & " min, IF " & Passlimit &" to " & PassMax &" passes has been completed"
			End IF
		End IF
		'CheckServers    	' Query servers for information.
		'Loop through the array:
		For I=0 to uBound(ArrServerName)
			wscript.echo "*** Processing [" & lpad(I+1," ",5) & "/" & ubound(ArrServerName)+1 & "] " & Rpad(ArrServerName(I)," ",50)
			IF bRunMinimized Then
				WshShell.Run "CScript.exe //NOLOGO " &  quote & WScript.ScriptFullName & quote & " /SERVER:" & ArrServerName(I), WindowMinimized, bWaitOnReturn
			ELSE
				WshShell.Run "CScript.exe //NOLOGO " &  quote & WScript.ScriptFullName & quote & " /SERVER:" & ArrServerName(I), WindowMaximized, bWaitOnReturn
			End IF
			wscript.echo "*** Status for " & rpad(arrServername(I),".",20) & "." & lpad(CheckServerStat(ArrServername(I)),".",40)
			IF ((clng(i) mod 4)=2) then
				'Only check CPU load on the system the running the script every 4th time. (The check takes a long time to complete)
				While (clng(ScriptThreads("%")) >= clng(MaxThreads)) Or (clng(CurrentCPULoad(ScriptHost)) > clng(MaxHostCPU))
					wscript.sleep 3000
				Wend
				ELSE
					While (clng(ScriptThreads("%")) >= clng(MaxThreads)) 
					wscript.sleep 1000
				Wend
			End IF			
		next
		'Check IF all servers has been completed without errors, IF yes... quit.
				
		Pass = Pass + 1 'Increment pass
		IF not ((pass > passmax) or ((pass > passlimit) and (DateDiff("n", StartTime, Now) > PassLimitMinutes))) then
			Wscript.echo "Script will test offline systems again in a few minutes, or exit IF done."
			wscript.sleep 20000
			ShowStatus
			wscript.sleep 60000
		ELSE
			ShowStatus
		End IF
	Loop
End Function
'******************************************************************************

'******************************************************************************
Function ReadSQLVersion(strComputer,SQLUser,SqlPassword, instance)
	'This is for only intended for SQL2k and sql version 7.
	on Error resume next
	Dim adoconn, rs, adocommand, SQLCMD, Field
	Dim bTrusted
	
	set adoconn = createObject("ADODB.CONNECTION")
	Set rs = CreateObject("ADODB.Recordset")
	set adocommand = CreateObject("ADODB.Command")
	
	IF SQLUser = "" Then 
		bTrusted=True
	End IF
	
	IF bTrusted Then
		adoconn.ConnectionString = "Provider=SQLOLEDB;Data Source=" & strComputer &";Integrated Security=SSPI;Connect Timeout = 30 " 
	ELSE
		IF SQLPassword = "" Then
			adoconn.ConnectionString = "Provider=SQLOLEDB.1;Persist Security Info=False;User ID=" & SQLUser &";Data Source=" & strcomputer
		ELSE
			adoconn.ConnectionString = "Provider=SQLOLEDB.1;Password="& SQLPasswod &";Persist Security Info=False;User ID=" & SQLUser & ";Data Source=" & strcomputer
		End IF
	End IF
	
	adoconn.Open 'Open Connection
	IF Err = 0 Then	
		'wscript.echo "DB Connection made"
		SQLCMD = "Select SERVERPROPERTY('Edition') AS [Edition],SERVERPROPERTY('InstanceName') AS [InstanceName],@@VERSION AS [Server Information],SERVERPROPERTY('productversion') AS [ProductVersion],SERVERPROPERTY('ProductLevel') AS [ProductLevel], SERVERPROPERTY('ISCLUSTERED') AS ISCLUSTERED"
		rs.Open sqlCMD, adoconn
		IF Err = 0 Then	
			ReadSQLVersion=strComputer  & strRealComputerName 	
			ReadSQLVersion=ReadSQLVersion & ";" & quote & instance & quote
			ReadSQLVersion=ReadSQLVersion & ";" & quote & rs.Fields.Item("Edition") 		& quote
			ReadSQLVersion=ReadSQLVersion & ";" & quote & replace(replace(Replace(trim(rs.Fields.Item("Server Information")),VbCrLf,""),VbTAB,""),vblf,",") & quote			
			ReadSQLVersion=ReadSQLVersion & ";" & quote & rs.Fields.Item("ProductVersion") 	& quote
			ReadSQLVersion=ReadSQLVersion & ";" & quote & rs.Fields.Item("ProductLevel") 	& quote  
			ReadSQLVersion=ReadSQLVersion & ";" & quote & rs.Fields.Item("isclustered") 	& quote & ";" & quote & quote & VbCrLf 
			rs.Close
		End IF
		adoconn.Close
		set adoconn = nothing
	else
					WmiError strComputer,"Exception in ReadSQLVersion:" & "," &  " Error number: " & Err.Number & "," &   " Error Source:" & Err.Source & "," & " Error description:'" & Err.Description & ","  & " WSH ver:" & WScript.Version & vbCrLf
			Err.clear
	End IF
End Function ' ReadSQLVersion
'******************************************************************************

'this function scans exchange
'******************************************************************************
function listExchangeVersion(strComputer)
dim sPath, arrSubKeys, subkey, ExVersion, TempResult
sPath = "Software\Microsoft\Windows\CurrentVersion\Uninstall\"
objReg.EnumKey GetHive("HKEY_LOCAL_MACHINE"),sPath,arrSubKeys
For Each subkey In arrSubKeys
	select case ucase(subkey)
		case ucase("DB20F7FD-67BC-4813-8808-78F63E89EB56") ExVersion = "Exchange 2000 Standard"
		case ucase("775CF3DA-C007-4709-B4CC-CE2239BE2E03") Exversion = "Exchange 2000 Standard"
		case ucase("FC6FA539-452D-4a9b-8065-C1FA74B86F83") ExVersion = "Exchange 2000 Standard Evaluation"
		case ucase("D3574E0C-360A-44d5-858C-33323C2D79F2") ExVersion = "Exchange 2000 Enterprise" 
		case ucase("F8567801-906B-439b-8D6A-87BDFEC9BA52") ExVersion = "Exchange 2000 Enterprise" 
		case ucase("65D9643D-06E8-47d6-865E-80F4CC9BB879") ExVersion = "Exchange 2000 Enterprise" 
		case ucase("8B102332-6052-4af3-ADFA-35A3DED0506A") ExVersion = "Exchange 2000 Enterprise Evaluation" 
		case ucase("ee2d3727-33c0-11d2-ab50-00c04fb1799f") ExVersion = "Exchange 2000 Standard SBS" 
		case ucase("EAE76D62-2691-4883-8BBB-1F2EE6D370D5") ExVersion = "Exchange 2003 Standard" 
		case ucase("9682A75B-EBD1-4c7d-88F9-13BE236F706C") ExVersion = "Exchange 2003 Standard" 
		case ucase("9161A261-6ABE-4668-BBFA-AD06B3F642CF") ExVersion = "Exchange 2003 Standard" 
		case ucase("D8862944-4F8A-429d-9A4F-6F201428FB0C") ExVersion = "Exchange 2003 Standard Evaluation" 
		case ucase("C160866F-DE53-434f-ADF1-CC42ABBF8778") ExVersion = "Exchange 2003 Standard Evaluation"
		case ucase("74F3BB3C-A434-48fa-AAC1-3FC37CD2B0DB") ExVersion = "Exchange 2003 Enterprise"
		case ucase("7F4210A8-D3B4-480a-835E-D5DAA0D0B157") ExVersion = "Exchange 2003 Enterprise" 
		case ucase("4050D45F-9598-44bc-8C07-4C1BBE22EFBB") ExVersion = "Exchange 2003 Enterprise"
		case ucase("F95DE19F-CF69-4b03-81B6-9EC050D20D3B") ExVersion = "Exchange 2003 Enterprise" 
		case ucase("3D5A0E1C-B6DA-42a7-A871-03CD2E30FEA3") ExVersion = "Exchange 2003 Enterprise Evaluation"
		case ucase("2B8EC4BD-5638-47e2-8817-1A50B38A828D") ExVersion = "Exchange 2003 Enterprise Evaluation" 
		case ucase("5717D53E-DD6D-4d1e-8A1F-C7BE620F65AA") ExVersion = "Exchange 2003 Standard SBS" 
	end select
Next

TempResult = StrComputer & ";" & ExVersion
LogToFile StrComputer & prefix &"Exchange.txt",TempResult
IF FileOK (StrComputer & prefix &"Exchange.txt" ) Then
	listExchangeVersion=TRUE
ELSE
	listExchangeVersion=FALSE
End IF
end function 'listExchangeVersion
'******************************************************************************

'this function converts a wmi object to a csv formatted string
'******************************************************************************
Function WMI2CSV(strComputer, objList)
	On Error Resume Next
    Wscript.Echo "[" & strComputer & "] returned [" & objList.count & "] items."
	Dim strLine, objLine, objProperty
    for each objLine in objList
        strLine = "ComputerName"
        for each objProperty in objLine.Properties_
            strLine = strLine & "," & Quote & objProperty.name & Quote
        next
    next
    strLine = strLine & VBNewLine
    For Each objLine in objList
        strLine = strLine & strComputer
        for each objProperty in objLine.Properties_
            if VarType(objProperty) = 1 or VarType(objProperty) = 3 or VarType(objProperty) = 8 then
                strLine = strLine & "," & Quote & objProperty & Quote
            else
                strLine = strLine & ","
            end if
        next
        strLine = strLine & VBNewLine
    next
    WMI2CSV = strLine
End Function 'WMI2CSV
'******************************************************************************

'this function Lists data related to RDL
'******************************************************************************
Function ListRDL(strComputer)
	On Error Resume Next
	Wscript.echo "------- Remote Desktop Licensing Information from " & strComputer & " -------"
	Dim intReturn, List, strWMIClass, csvText, strFile
	Dim arrWMIClasses(7)
	arrWMIClasses(0) = "TSLicenseReport"
	arrWMIClasses(1) = "TSLicenseKeyPack"
	arrWMIClasses(2) = "TSIssuedLicense"
	arrWMIClasses(3) = "TSLicenseReportEntry"
	arrWMIClasses(4) = "TSLicenseReportFailedPerUserEntry"
	arrWMIClasses(5) = "TSLicenseReportFailedPerUserSummaryEntry"
	arrWMIClasses(6) = "TSLicenseReportPerDeviceEntry"
	arrWMIClasses(7) = "TSLicenseReportSummaryEntry"
	for each strWMIClass in arrWMIClasses
		strFile = StrComputer & prefix & strWMIClass & ".csv"
		If strWMIClass = "TSLicenseReport" then
			Set objReport = objSWbemService.Get("Win32_TSLicenseReport")
			intReturn = objReport.GenerateReportEx (OutPutPath & strFile)
			intReturn = objReport.GenerateReport (3,"",OutPutPath & strFile)
		else
			Set List = objSWbemService.ExecQuery("SELECT * FROM win32_" & strWMIClass)
			if ((List.count) AND (List.count <> 0)) then
				csvText = WMI2CSV(strComputer,List)
				LogToFile strFile,csvText
			end if
		end if
	next
end function 'ListRDL
'******************************************************************************
'
'this function Lists data related to OCS
'******************************************************************************
Function ListOCS(strComputer)
	On Error Resume Next
	Wscript.echo "------- Office Communications Server Information from " & strComputer & " -------"
	Dim intReturn, List, strWMIClass, csvText, strFile
	Dim arrWMIClasses(1)
	arrWMIClasses(0) = "MSFT_SIPTrustedServiceSetting"
	arrWMIClasses(1) = "MSFT_SIPESUserSetting"
	for each strWMIClass in arrWMIClasses
		strFile = StrComputer & prefix & strWMIClass & ".csv"
		Set List = objSWbemService.ExecQuery("SELECT * FROM " & strWMIClass)
		if ((List.count) AND (List.count <> 0)) then
			csvText = WMI2CSV(strComputer,List)
			LogToFile strFile,csvText
		end if
	next
end function 'ListRDL
'******************************************************************************
'
'this function Lists data related to Hyper-v
'******************************************************************************
Function ListVM(strComputer)
	On Error Resume Next
	Wscript.echo "------- Hyper-v Information from " & strComputer & " -------"
	Dim intReturn, List, strWMIClass, csvText, strFile, objVMWMIService, NewFolder, FileSystem
	Err.Clear
	Set objVMWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}\\" & strComputer & "\root\virtualization")
	If Err.Number Then
        Wscript.Echo "Can't access hyper-v status via wmi for server [" & strComputer & "]"
        Err.Clear
    End If
	strFile = "Hyperv\" & StrComputer & prefix & "Msvm_ComputerSystem" & ".csv"
	Set List = objVMWMIService.ExecQuery("SELECT Caption, Description, ElementName, EnabledState, HealthState, InstallDate, Name, OnTimeInMilliseconds, RequestedState, ResetCapability, Status, TimeOfLastConfigurationChange, TimeOfLastStateChange FROM Msvm_ComputerSystem")
	if ((List.count) AND (List.count <> 0)) then
		set FileSystem = CreateObject("Scripting.FileSystemObject") 
		IF Not FileSystem.FolderExists(OutPutPath & "\Hyperv") Then 
			Set NewFolder = FileSystem.CreateFolder(OutPutPath & "\Hyperv") 
		End IF 
		csvText = WMI2CSV(strComputer,List)
		LogToFile strFile,csvText
	end if
	strFile = "Hyperv\" & StrComputer & prefix & "Msvm_PlannedComputerSystem" & ".csv"
	Set List = objVMWMIService.ExecQuery("SELECT Caption, Description, ElementName, EnabledState, HealthState, InstallDate, Name, OnTimeInMilliseconds, Status, TimeOfLastConfigurationChange,  TimeOfLastStateChange FROM Msvm_PlannedComputerSystem")
	if ((List.count) AND (List.count <> 0)) then
		set FileSystem = CreateObject("Scripting.FileSystemObject") 
		IF Not FileSystem.FolderExists(OutPutPath & "\Hyperv") Then 
			Set NewFolder = FileSystem.CreateFolder(OutPutPath & "\Hyperv") 
		End IF 
		csvText = WMI2CSV(strComputer,List)
		LogToFile strFile,csvText
	end if
	strFile = "Hyperv\" & StrComputer & prefix & "Msvm_SummaryInformation" & ".csv"
	Set List = objVMWMIService.ExecQuery("SELECT AllocatedGPU, ApplicationHealth, AvailableMemoryBuffer, CreationTime, ElementName, EnabledState, EnhancedSessionModeState, GuestOperatingSystem, HealthState, Heartbeat, IntegrationServicesVersionState, MemoryAvailable, MemoryUsage, Name, Notes, NumberOfProcessors, OtherEnabledState, ProcessorLoad, UpTime, VirtualSystemSubType FROM Msvm_SummaryInformation")
	if ((List.count) AND (List.count <> 0)) then
		set FileSystem = CreateObject("Scripting.FileSystemObject") 
		IF Not FileSystem.FolderExists(OutPutPath & "\Hyperv") Then 
			Set NewFolder = FileSystem.CreateFolder(OutPutPath & "\Hyperv") 
		End IF 
		csvText = WMI2CSV(strComputer,List)
		LogToFile strFile,csvText
	end if
	strFile = "Hyperv\" & StrComputer & prefix & "Msvm_VirtualSystemSettingData" & ".csv"
	Set List = objVMWMIService.ExecQuery("SELECT AdditionalRecoveryInformation, BaseBoardSerialNumber, BIOSGUID, BIOSSerialNumber, Caption, ChassisAssetTag, ChassisSerialNumber, ConfigurationID, CreationTime, Description, ElementName, NetworkBootPreferredProtocol, Parent, Version, VirtualSystemIdentifier, VirtualSystemSubType, VirtualSystemType FROM Msvm_VirtualSystemSettingData")
	if ((List.count) AND (List.count <> 0)) then
		set FileSystem = CreateObject("Scripting.FileSystemObject") 
		IF Not FileSystem.FolderExists(OutPutPath & "\Hyperv") Then 
			Set NewFolder = FileSystem.CreateFolder(OutPutPath & "\Hyperv") 
		End IF 
		csvText = WMI2CSV(strComputer,List)
		LogToFile strFile,csvText
	end if
end function 'ListVM
'******************************************************************************
'this function Lists data related to sccm
'******************************************************************************
Function ListSCCM(strComputer)
	On Error Resume Next
	Wscript.echo "------- System Center Configuration Manager Information from " & strComputer & " -------"
	Dim List, strWMIClass, csvText, strFile, objSMSWMIService, objSMSWMIServiceNS, strWMIClassSuffix, strWMIClassPrefix, strNameSpace, objNameSpace
	Dim arrWMIClasses(29)
	arrWMIClasses(0) = "System_ACTIVESYNC_CONNECTED_DEVICE"
	arrWMIClasses(1) = "System_ACTIVESYNC_SERVICE"
	arrWMIClasses(2) = "System_ADD_REMOVE_PROGRAMS"
	arrWMIClasses(3) = "System_ADD_REMOVE_PROGRAMS_64"
	arrWMIClasses(4) = "System_AUTOSTART_SOFTWARE"
	arrWMIClasses(5) = "System_BROWSER_HELPER_OBJECT"
	arrWMIClasses(6) = "System_CCM_RECENTLY_USED_APPS"
	arrWMIClasses(7) = "System_COMPUTER_SYSTEM"
	arrWMIClasses(8) = "System_DEVICE_COMPUTER_SYSTEM"
	arrWMIClasses(9) = "System_DEVICE_OS_INFORMATION"
	arrWMIClasses(10) = "System_INSTALLED_EXECUTABLE"
	arrWMIClasses(11) = "System_INSTALLED_SOFTWARE"
	arrWMIClasses(12) = "System_INSTALLED_SOFTWARE_MS"
	arrWMIClasses(13) = "System_LastSoftwareScan"
	arrWMIClasses(14) = "System_LOGICAL_DISK"
	arrWMIClasses(15) = "System_PC_BIOS"
	arrWMIClasses(16) = "System_PROCESSOR"
	arrWMIClasses(17) = "System_SOFTWARE_LICENSING_PRODUCT"
	arrWMIClasses(18) = "System_SOFTWARE_LICENSING_SERVICE"
	arrWMIClasses(19) = "System_SOFTWARE_SHORTCUT"
	arrWMIClasses(20) = "System_SoftwareFile"
	arrWMIClasses(21) = "System_SoftwareProduct"
	arrWMIClasses(22) = "System_SoftwareUsageData"
	arrWMIClasses(23) = "System_SYSTEM_CONSOLE_USAGE"
	arrWMIClasses(24) = "System_SYSTEM_CONSOLE_USER"
	arrWMIClasses(25) = "System_SYSTEM_ENCLOSURE"
	arrWMIClasses(26) = "System_VIRTUAL_APPLICATION_PACKAGES"
	arrWMIClasses(27) = "System_VIRTUAL_APPLICATIONS"
	arrWMIClasses(28) = "System_SERVICE"
	arrWMIClasses(29) = "System_OPERATING_SYSTEM"
	Dim arrWMIPrefixes(2)
	arrWMIPrefixes(0) = "SMS_G_"
	arrWMIPrefixes(1) = "SMS_GEH_"
	arrWMIPrefixes(2) = "SMS_GH_"
	Set objSMSWMIServiceNS = GetObject ("winmgmts:{impersonationLevel=impersonate}\\" & strComputer & "\root\sms")
	For Each objNameSpace In objSMSWMIServiceNS.InstancesOf("__NAMESPACE")
		strNameSpace = objNameSpace.name
		if strNameSpace = "inv_schema" then
		else
			Err.Clear
			Set objSMSWMIService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\sms\" & strNameSpace)
			If Err.Number Then
				Wscript.Echo "Can't access sccm status for server [" & strComputer & "] namespace [" & strNameSpace & "]"
				Err.Clear
			End If
			for each strWMIClassSuffix in arrWMIClasses
				for each strWMIClassPrefix in arrWMIPrefixes
					strWMIClass = strWMIClassPrefix & strWMIClassSuffix
					strFile = StrComputer & prefix & strNameSpace & "_" & strWMIClass & ".csv"
					Set List = objSMSWMIService.ExecQuery("SELECT * FROM " & strWMIClass)
					if ((List.count) AND (List.count <> 0)) then
						csvText = WMI2CSV(strComputer,List)
						LogToFile strFile,csvText  'should do per line logging due to high item count
					end if
				next
			next
		end if
	next
end function 'ListSCCM
'******************************************************************************
'*Program starts here'*********************************************************
'******************************************************************************
'Record the start time of the script.
StartTime = now 
'Function calls
Force_Cscript			'check startup mode, exit IF wscript is used.
DetectWSHVersion		'Check WSH version
CheckCurrentDirectory 	' See IF script is executed from current directory
StartUp	  		  		' Check IF serverlist.txt exists or IF arguments is passed
CreateOutputDirectory 	'Create output folder.

'Run script according to ScriptMode
Select Case UCASE(ScriptMode)
	Case "AD"							' Used when user press <A> for AD mode.
		CreateADList					'Create serverlist.txt from information extracted from Active Directory
		FillServerArray 	   			' Fill the Array arrServerName with systems from serverlist.txt
		SpawnThreads			
	Case "SERVERLIST"					' Used when serverlist.txt exists
		FillServerArray			 	   	' Fill the Array arrServerName with systems from serverlist.txt
		SpawnThreads
	Case "ARGUMENT"						' Used when script is run with /SERVER:<SERVERNAME>
		CheckServer arrServerName(0)   	' Query servers for information.
	CASE "LOCALMODE"					' Used when user press <L> for localmode
		CheckServer arrServerName(0)   	' Query servers for information.
End Select 
'******************************************************************************
'*Program ends here'***********************************************************
'******************************************************************************