﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// Source files represent a source generated JsonSerializerContext as produced by the .NET 8 SDK.
// Used to validate correctness of contexts generated by previous SDKs against the current System.Text.Json runtime components.
// Unless absolutely necessary DO NOT MODIFY any of these files -- it would invalidate the purpose of the regression tests.

// <auto-generated/>

#nullable enable annotations
#nullable disable warnings

// Suppress warnings about [Obsolete] member usage in generated code.
#pragma warning disable CS0612, CS0618

namespace System.Text.Json.Tests.SourceGenRegressionTests.Net80
{
    public partial class Net80GeneratedContext : global::System.Text.Json.Serialization.Metadata.IJsonTypeInfoResolver
    {
        /// <inheritdoc/>
        public override global::System.Text.Json.Serialization.Metadata.JsonTypeInfo? GetTypeInfo(global::System.Type type)
        {
            Options.TryGetTypeInfo(type, out global::System.Text.Json.Serialization.Metadata.JsonTypeInfo? typeInfo);
            return typeInfo;
        }

        global::System.Text.Json.Serialization.Metadata.JsonTypeInfo? global::System.Text.Json.Serialization.Metadata.IJsonTypeInfoResolver.GetTypeInfo(global::System.Type type, global::System.Text.Json.JsonSerializerOptions options)
        {
            if (type == typeof(global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>))
            {
                return Create_DictionaryStringHighLowTemps(options);
            }
            if (type == typeof(global::System.Collections.Generic.List<global::System.DateTimeOffset>))
            {
                return Create_ListDateTimeOffset(options);
            }
            if (type == typeof(global::System.DateTimeOffset))
            {
                return Create_DateTimeOffset(options);
            }
            if (type == typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.ClassWithCustomConverter))
            {
                return Create_ClassWithCustomConverter(options);
            }
            if (type == typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps))
            {
                return Create_HighLowTemps(options);
            }
            if (type == typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.MyLinkedList))
            {
                return Create_MyLinkedList(options);
            }
            if (type == typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs))
            {
                return Create_WeatherForecastWithPOCOs(options);
            }
            if (type == typeof(int))
            {
                return Create_Int32(options);
            }
            if (type == typeof(string))
            {
                return Create_String(options);
            }
            if (type == typeof(string[]))
            {
                return Create_StringArray(options);
            }
            return null;
        }
    }
}
