/*
 * GTK ASTerisk MANager
 * Copyright (C) 2002, Digium
 *
 * Written by Mark Spencer <markster@digium.com>
 *
 * All Rights Reserved
 */

#ifndef _GASTMAN_H
#define _GASTMAN_H

#define COLOR_GRAY		0	/* Color only */
#define TYPE_TRASH		1
#define TYPE_EXTEN		2
#define TYPE_CALL		3
#define TYPE_QUEUE		4
#define TYPE_QUEUENAME	5

struct gui_object;
struct gui_queue;

int gui_init(int *argc, char **argv[]);

int gui_show_doing(char *title, char *tmp);

char* gui_get_home_dir(void);

int gui_ask_maybe(char *title, char *text, char *entity, int choices, int def, char *ctext[]);
int gui_ask(char *title, char *text, int choices, int def, char *ctext[]);
int gui_yesno(char *title, char *text, int defaultyes);
int gui_confirm(char *title, char *text, int defaultyes, char *entity);
int gui_hide_doing(void);
int gui_show_message(char *title, char *text);
int gui_login(char **user, char **pass, char *hostname);
int gui_exten(char **extens, char **chans, char **icon, char **label, char *title);
int gui_show_box(char *host);
int gui_run(void);
int gui_watch_fd(int fd);
int gui_exit(void);
struct gui_object *gui_add_object(char *name, char *text, char *icon, char *ident, void *pvt, int size, int withled, int type);
void gui_del_object(struct gui_object *obj);
struct gui_queue *gui_add_queue(char *channel, char *queue, char *icon, void *pvt, int type);
void gui_del_queue(struct gui_queue *obj);
void gui_object_set_text(struct gui_object *obj, char *text);
void gui_object_set_tooltip(struct gui_object *obj, char *tip);
void gui_object_set_callinfo(struct gui_object *obj, char *callerid, char *link, char *location, struct gui_object *cobj, struct gui_object *eobj);
void gui_queue_set_callinfo(struct gui_queue *obj, char *callerid, int position, int wait);
void gui_queue_set_queueinfo(struct gui_queue *obj, int num, int max);
void gui_object_set_led(struct gui_object *obj, int on);
int gui_run_a_little(int *timeout);
int gui_set_icon(int nformat);
int gui_status(char *str);
int gui_get_user_input(char *title, char *msg, char *buf, int buflen);
int gui_get_hostname(char *buf, int buflen);
int gui_link(struct gui_object *obj1, struct gui_object *obj2);
int gui_unlink(struct gui_object *obj1, struct gui_object *obj2);
int gui_show_chan_menu(void);
int gui_show_exten_menu(void);
void gui_move_near(struct gui_object *dst, struct gui_object *src);
void gui_cli_result(char *s);
int gui_object_location(struct gui_object *obj, int *x, int *y);
int gui_object_move(struct gui_object *obj, int newx, int newy);

void gastman_run_command(const char *cmd);
int gastman_input_ready(void);
void gastman_object_select(void *pvt);
void gastman_redirect(void *pvt);
void gastman_hangup(void *pvt);
void gastman_queue_select(void *pvt);
void gastman_quit(void);
void gastman_add_exten(void);
void gastman_drag_drop(void *src, void *target);
int gastman_pre_drag_drop(void *src, void *target);
void gastman_right_click(void *obj);
void gastman_double_click(void *obj);
void gastman_del_exten(void *data);
void gastman_originate_exten(void *data);
void gastman_invite_exten(void *data);
char *gastman_curhost(void);
char *gastman_complete(const char *orig, int *pos);
char *gastman_prevhist(void);
char *gastman_nexthist(void);
char *get_old_ident(void *pvt, char *buffer, int buffersize);

#endif
