/*
 * Copyright (C) 2015-2016 Open Source Robotics Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

#ifndef _GAZEBO_LASERVIEW_TEST_HH_
#define _GAZEBO_LASERVIEW_TEST_HH_

#include "gazebo/gui/QTestFixture.hh"
#include "gazebo/gui/viewers/LaserView.hh"

/// \brief A test class for the LaserView widget.
class LaserView_TEST : public QTestFixture
{
  Q_OBJECT

  /// \brief Test construction and usage in a world with a laser.
  private slots: void Construction();

  /// \brief Test invoking buttons in the laser view widget.
  private slots: void Buttons();
};
#endif
