/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/*
 * PolicyParser.java
 *
 * Created on May 27, 2004, 7:36 AM
 */

package com.sun.enterprise.tools.upgrade.miscconfig;

import java.io.*;
import java.util.Enumeration;

/**
 *
 * @author  Hans Hrasna
 */

public class PolicyParser extends sun.security.provider.PolicyParser {
    
    /** Creates a new instance of PolicyParser */
    public PolicyParser() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
    }
    
    public void write(java.io.Writer policy) {
        PrintWriter out = new PrintWriter(new BufferedWriter(policy));
        
        Enumeration ee = grantElements();
        
        out.println("/* Generated by asupgrade on "+
        (new java.util.Date()) + "         */");
        out.println("/* Copyright 2004 Sun Microsystems, Inc. All rights reserved.     */");
        out.println("/* SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. */");
        out.println();
        
        // write the (unexpanded) keystore entry as the first entry of the
        // policy file
        if (getKeyStoreUrl() != null) {
            writeKeyStoreEntry(out);
        }
        
        // write "grant" entries
        while (ee.hasMoreElements()) {
            GrantEntry ge = (GrantEntry) ee.nextElement();
            ge.write(out);
            out.println();
        }
        out.flush();
        out.close();
    }
    
    /**
     * writes the (unexpanded) keystore entry
     */
    private void writeKeyStoreEntry(PrintWriter out) {
        out.print("keystore \"");
        out.print(getKeyStoreUrl());
        out.print('"');
        String keyStoreType = getKeyStoreType();
        if (keyStoreType != null && keyStoreType.length() > 0)
            out.print(", \"" + keyStoreType + "\"");
        out.println(";");
        out.println();
    }
}
