#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
# generated by wxGlade 0.6.8
#

import wx

# begin wxGlade: dependencies
import gettext
# end wxGlade

# begin wxGlade: extracode
from Gnumed.wxpython.gmTextCtrl import cTextCtrl
# end wxGlade


class wxgDynamicHintDlg(wx.Dialog):
	def __init__(self, *args, **kwds):
		# begin wxGlade: wxgDynamicHintDlg.__init__
		kwds["style"] = wx.DEFAULT_DIALOG_STYLE | wx.RESIZE_BORDER | wx.MAXIMIZE_BOX | wx.MINIMIZE_BOX | wx.THICK_FRAME
		wx.Dialog.__init__(self, *args, **kwds)
		self._TCTRL_title = wx.TextCtrl(self, wx.ID_ANY, _("<hint title>"), style=wx.TE_READONLY | wx.TE_CENTRE | wx.NO_BORDER)
		self._TCTRL_hint = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_MULTILINE | wx.TE_READONLY | wx.TE_WORDWRAP)
		self._TCTRL_source = wx.TextCtrl(self, wx.ID_ANY, _("<hint source>"), style=wx.TE_READONLY | wx.TE_CENTRE | wx.NO_BORDER)
		self._URL_info = wx.HyperlinkCtrl(self, wx.ID_ANY, _("Further information"), _("http://www.duckduckgo.com"), style=wx.HL_ALIGN_CENTRE | wx.HL_CONTEXTMENU | wx.HL_DEFAULT_STYLE)
		self._TCTRL_rationale = cTextCtrl(self, wx.ID_ANY, "", style=wx.TE_MULTILINE | wx.TE_WORDWRAP | wx.NO_BORDER)
		self._LBL_previous_rationale = wx.StaticText(self, wx.ID_ANY, _("Previous\nrationale"))
		self._TCTRL_previous_rationale = cTextCtrl(self, wx.ID_ANY, "", style=wx.TE_MULTILINE | wx.TE_READONLY | wx.TE_WORDWRAP | wx.NO_BORDER)
		self._BTN_OK = wx.Button(self, wx.ID_OK, "")
		self._BTN_suppress = wx.Button(self, wx.ID_ANY, _("&Suppress"))
		self._BTN_manage_hints = wx.Button(self, wx.ID_ANY, _("&Manage"), style=wx.BU_EXACTFIT)

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_BUTTON, self._on_suppress_button_pressed, self._BTN_suppress)
		self.Bind(wx.EVT_BUTTON, self._on_manage_hints_button_pressed, self._BTN_manage_hints)
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: wxgDynamicHintDlg.__set_properties
		self.SetTitle(_("Dynamic hint"))
		self.SetSize((400, 400))
		self._TCTRL_title.SetBackgroundColour(wx.Colour(255, 0, 0))
		self._TCTRL_title.SetForegroundColour(wx.Colour(255, 255, 0))
		self._TCTRL_title.SetFont(wx.Font(10, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
		self._TCTRL_hint.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_BACKGROUND))
		self._TCTRL_source.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_BACKGROUND))
		self._URL_info.Enable(False)
		self._TCTRL_rationale.SetToolTipString(_("Enter a rationale for suppressing this hint."))
		self._TCTRL_previous_rationale.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_BACKGROUND))
		self._BTN_OK.SetToolTipString(_("Dismiss this hint for now."))
		self._BTN_OK.SetFocus()
		self._BTN_suppress.SetToolTipString(_("Suppress this hint in this patient (needs a rationale)."))
		self._BTN_suppress.Enable(False)
		self._BTN_manage_hints.SetToolTipString(_("Manage dynamic hints."))
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: wxgDynamicHintDlg.__do_layout
		__szr_main = wx.BoxSizer(wx.VERTICAL)
		__szr_buttons = wx.BoxSizer(wx.HORIZONTAL)
		__gszr_rationale = wx.FlexGridSizer(2, 2, 3, 5)
		__szr_main.Add(self._TCTRL_title, 0, wx.LEFT | wx.RIGHT | wx.BOTTOM | wx.EXPAND, 3)
		__szr_main.Add(self._TCTRL_hint, 1, wx.LEFT | wx.RIGHT | wx.BOTTOM | wx.EXPAND | wx.ALIGN_CENTER_VERTICAL, 3)
		__szr_main.Add(self._TCTRL_source, 0, wx.LEFT | wx.RIGHT | wx.BOTTOM | wx.EXPAND, 3)
		__szr_main.Add(self._URL_info, 0, wx.BOTTOM | wx.ALIGN_CENTER_HORIZONTAL | wx.ALIGN_CENTER_VERTICAL, 5)
		__lbl_rationale = wx.StaticText(self, wx.ID_ANY, _("Rationale for\nsuppression"))
		__gszr_rationale.Add(__lbl_rationale, 0, wx.ALIGN_CENTER_VERTICAL, 3)
		__gszr_rationale.Add(self._TCTRL_rationale, 1, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL, 0)
		__gszr_rationale.Add(self._LBL_previous_rationale, 0, wx.ALIGN_CENTER_VERTICAL, 3)
		__gszr_rationale.Add(self._TCTRL_previous_rationale, 1, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL, 0)
		__gszr_rationale.AddGrowableRow(0)
		__gszr_rationale.AddGrowableCol(1)
		__szr_main.Add(__gszr_rationale, 0, wx.LEFT | wx.RIGHT | wx.EXPAND | wx.ALIGN_CENTER_VERTICAL, 3)
		__szr_buttons.Add((20, 20), 2, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL, 0)
		__szr_buttons.Add(self._BTN_OK, 0, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL, 10)
		__szr_buttons.Add((20, 20), 1, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL, 0)
		__szr_buttons.Add(self._BTN_suppress, 0, wx.ALIGN_CENTER_VERTICAL, 5)
		__szr_buttons.Add((20, 20), 2, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL, 0)
		__szr_buttons.Add(self._BTN_manage_hints, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		__szr_buttons.Add((20, 20), 1, wx.EXPAND | wx.ALIGN_CENTER_VERTICAL, 0)
		__szr_main.Add(__szr_buttons, 0, wx.LEFT | wx.RIGHT | wx.TOP | wx.EXPAND, 3)
		self.SetSizer(__szr_main)
		self.Layout()
		# end wxGlade

	def _on_suppress_button_pressed(self, event):  # wxGlade: wxgDynamicHintDlg.<event_handler>
		print "Event handler '_on_suppress_button_pressed' not implemented!"
		event.Skip()

	def _on_manage_hints_button_pressed(self, event):  # wxGlade: wxgDynamicHintDlg.<event_handler>
		print "Event handler '_on_manage_hints_button_pressed' not implemented!"
		event.Skip()

# end of class wxgDynamicHintDlg
if __name__ == "__main__":
	gettext.install("app") # replace with the appropriate catalog name

	app = wx.PySimpleApp(0)
	wx.InitAllImageHandlers()
	dialog_1 = wxgDynamicHintDlg(None, wx.ID_ANY, "")
	app.SetTopWindow(dialog_1)
	dialog_1.Show()
	app.MainLoop()