// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about an inference component.
func (c *Client) DescribeInferenceComponent(ctx context.Context, params *DescribeInferenceComponentInput, optFns ...func(*Options)) (*DescribeInferenceComponentOutput, error) {
	if params == nil {
		params = &DescribeInferenceComponentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeInferenceComponent", params, optFns, c.addOperationDescribeInferenceComponentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeInferenceComponentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeInferenceComponentInput struct {

	// The name of the inference component.
	//
	// This member is required.
	InferenceComponentName *string

	noSmithyDocumentSerde
}

type DescribeInferenceComponentOutput struct {

	// The time when the inference component was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the endpoint that hosts the inference
	// component.
	//
	// This member is required.
	EndpointArn *string

	// The name of the endpoint that hosts the inference component.
	//
	// This member is required.
	EndpointName *string

	// The Amazon Resource Name (ARN) of the inference component.
	//
	// This member is required.
	InferenceComponentArn *string

	// The name of the inference component.
	//
	// This member is required.
	InferenceComponentName *string

	// The time when the inference component was last updated.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// If the inference component status is Failed , the reason for the failure.
	FailureReason *string

	// The status of the inference component.
	InferenceComponentStatus types.InferenceComponentStatus

	// Details about the runtime settings for the model that is deployed with the
	// inference component.
	RuntimeConfig *types.InferenceComponentRuntimeConfigSummary

	// Details about the resources that are deployed with this inference component.
	Specification *types.InferenceComponentSpecificationSummary

	// The name of the production variant that hosts the inference component.
	VariantName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeInferenceComponentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeInferenceComponent{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeInferenceComponent{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeInferenceComponent"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeInferenceComponentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeInferenceComponent(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeInferenceComponent(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeInferenceComponent",
	}
}
