// Deprecated: Please note, this package has been deprecated. A replacement package is available [github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/powerbiembedded/armpowerbiembedded](https://pkg.go.dev/github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/powerbiembedded/armpowerbiembedded). We strongly encourage you to upgrade to continue receiving updates. See [Migration Guide](https://aka.ms/azsdk/golang/t2/migration) for guidance on upgrading. Refer to our [deprecation policy](https://azure.github.io/azure-sdk/policies_support.html) for more details.
//
// Package powerbiembedded implements the Azure ARM Powerbiembedded service API version 2016-01-29.
//
// Client to manage your Power BI Embedded workspace collections and retrieve workspaces.
package powerbiembedded

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

const (
	// DefaultBaseURI is the default URI used for the service Powerbiembedded
	DefaultBaseURI = "https://management.azure.com"
)

// BaseClient is the base client for Powerbiembedded.
type BaseClient struct {
	autorest.Client
	BaseURI        string
	SubscriptionID string
}

// New creates an instance of the BaseClient client.
func New(subscriptionID string) BaseClient {
	return NewWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewWithBaseURI creates an instance of the BaseClient client using a custom endpoint.  Use this when interacting with
// an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return BaseClient{
		Client:         autorest.NewClientWithUserAgent(UserAgent()),
		BaseURI:        baseURI,
		SubscriptionID: subscriptionID,
	}
}

// GetAvailableOperations indicates which operations can be performed by the Power BI Resource Provider.
func (client BaseClient) GetAvailableOperations(ctx context.Context) (result OperationList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetAvailableOperations")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAvailableOperationsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbiembedded.BaseClient", "GetAvailableOperations", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAvailableOperationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "powerbiembedded.BaseClient", "GetAvailableOperations", resp, "Failure sending request")
		return
	}

	result, err = client.GetAvailableOperationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "powerbiembedded.BaseClient", "GetAvailableOperations", resp, "Failure responding to request")
		return
	}

	return
}

// GetAvailableOperationsPreparer prepares the GetAvailableOperations request.
func (client BaseClient) GetAvailableOperationsPreparer(ctx context.Context) (*http.Request, error) {
	const APIVersion = "2016-01-29"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.PowerBI/operations"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAvailableOperationsSender sends the GetAvailableOperations request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetAvailableOperationsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAvailableOperationsResponder handles the response to the GetAvailableOperations request. The method always
// closes the http.Response Body.
func (client BaseClient) GetAvailableOperationsResponder(resp *http.Response) (result OperationList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
