package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// DatabaseSQLVulnerabilityAssessmentScanResultClient is the the Azure SQL Database management API provides a RESTful
// set of web services that interact with Azure SQL Database services to manage your databases. The API enables you to
// create, retrieve, update, and delete databases.
type DatabaseSQLVulnerabilityAssessmentScanResultClient struct {
	BaseClient
}

// NewDatabaseSQLVulnerabilityAssessmentScanResultClient creates an instance of the
// DatabaseSQLVulnerabilityAssessmentScanResultClient client.
func NewDatabaseSQLVulnerabilityAssessmentScanResultClient(subscriptionID string) DatabaseSQLVulnerabilityAssessmentScanResultClient {
	return NewDatabaseSQLVulnerabilityAssessmentScanResultClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDatabaseSQLVulnerabilityAssessmentScanResultClientWithBaseURI creates an instance of the
// DatabaseSQLVulnerabilityAssessmentScanResultClient client using a custom endpoint.  Use this when interacting with
// an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewDatabaseSQLVulnerabilityAssessmentScanResultClientWithBaseURI(baseURI string, subscriptionID string) DatabaseSQLVulnerabilityAssessmentScanResultClient {
	return DatabaseSQLVulnerabilityAssessmentScanResultClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get gets a vulnerability assessment scan record of a database.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
// scanID - the scan id of the SQL Vulnerability Assessment scan to retrieve result from.
// scanResultID - the scan result id of the specific result to retrieve.
func (client DatabaseSQLVulnerabilityAssessmentScanResultClient) Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string, scanResultID string) (result VulnerabilityAssessmentScanResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentScanResultClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, serverName, databaseName, scanID, scanResultID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScanResultClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScanResultClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScanResultClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client DatabaseSQLVulnerabilityAssessmentScanResultClient) GetPreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string, scanResultID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":                autorest.Encode("path", databaseName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"scanId":                      autorest.Encode("path", scanID),
		"scanResultId":                autorest.Encode("path", scanResultID),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseSQLVulnerabilityAssessmentScanResultClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client DatabaseSQLVulnerabilityAssessmentScanResultClient) GetResponder(resp *http.Response) (result VulnerabilityAssessmentScanResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByScan gets a vulnerability assessment scan record of a database.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
// scanID - the scan id of the SQL Vulnerability Assessment scan to retrieve result from.
func (client DatabaseSQLVulnerabilityAssessmentScanResultClient) ListByScan(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (result VulnerabilityAssessmentScanListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentScanResultClient.ListByScan")
		defer func() {
			sc := -1
			if result.vaslr.Response.Response != nil {
				sc = result.vaslr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByScanNextResults
	req, err := client.ListByScanPreparer(ctx, resourceGroupName, serverName, databaseName, scanID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScanResultClient", "ListByScan", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByScanSender(req)
	if err != nil {
		result.vaslr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScanResultClient", "ListByScan", resp, "Failure sending request")
		return
	}

	result.vaslr, err = client.ListByScanResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScanResultClient", "ListByScan", resp, "Failure responding to request")
		return
	}
	if result.vaslr.hasNextLink() && result.vaslr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByScanPreparer prepares the ListByScan request.
func (client DatabaseSQLVulnerabilityAssessmentScanResultClient) ListByScanPreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":                autorest.Encode("path", databaseName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"scanId":                      autorest.Encode("path", scanID),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByScanSender sends the ListByScan request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseSQLVulnerabilityAssessmentScanResultClient) ListByScanSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByScanResponder handles the response to the ListByScan request. The method always
// closes the http.Response Body.
func (client DatabaseSQLVulnerabilityAssessmentScanResultClient) ListByScanResponder(resp *http.Response) (result VulnerabilityAssessmentScanListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByScanNextResults retrieves the next set of results, if any.
func (client DatabaseSQLVulnerabilityAssessmentScanResultClient) listByScanNextResults(ctx context.Context, lastResults VulnerabilityAssessmentScanListResult) (result VulnerabilityAssessmentScanListResult, err error) {
	req, err := lastResults.vulnerabilityAssessmentScanListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScanResultClient", "listByScanNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByScanSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScanResultClient", "listByScanNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByScanResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScanResultClient", "listByScanNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByScanComplete enumerates all values, automatically crossing page boundaries as required.
func (client DatabaseSQLVulnerabilityAssessmentScanResultClient) ListByScanComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (result VulnerabilityAssessmentScanListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentScanResultClient.ListByScan")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByScan(ctx, resourceGroupName, serverName, databaseName, scanID)
	return
}
