//**************************************************************************************************
//                                        PrcSimEngBase.hpp                                        *
//                                       -------------------                                       *
// Description : This is the base class for classes which provide the interface to the SPICE       *
//               circuit simulator.                                                                *
// Started     : 2004-04-25                                                                        *
// Last Update : 2015-01-05                                                                        *
// Copyright   : (C) 2004 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef PRCSIMENGBASE_HPP
#define PRCSIMENGBASE_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "base/PrcBase.hpp"
#include "base/SimnBase.hpp"
#include "netlist/NetList.hpp"

//**************************************************************************************************

class PrcSimEngBase : public PrcBase
{
  protected :

    eTypeSimEng  m_eSimEng;       // Simulation engine specifier

    wxFileName   m_ofnResults;    // The file name of the process output
    wxTextFile   m_oFileResults;  // A text file object for the above

    // Save the console output to file
             bool  bSaveOutput( const wxString & rosFName );
             bool  bErrorCheck( const wxString & rosFName );

  public :

                   PrcSimEngBase( void );
                  ~PrcSimEngBase( );

             bool  bSetResultsFile( const wxString & rosFName );

          eTypeSimEng   eGetSimEng     ( void ) { return( m_eSimEng    ); }
    const wxFileName & roGetResultsFile( void ) { return( m_ofnResults ); }

    // Create the process argument list
    virtual  bool  bMakeArgLst( SimnBase & roSimn );

    // Execute the simulation
    virtual  bool  bExec( void );

    // Format the results file
    virtual  bool  bFmtResults( void ) = 0;
};

//**************************************************************************************************

#endif // PRCSIMENGBASE_HPP
