#ifndef _NAP_LIBRARY_H
#define _NAP_LIBRARY_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include "mp3s.h"

/* structure to hold a pair of a device and an inode. This information
   suffices to uniquely identify a file or directory on a machine,
   even across different file systems */

struct dev_inode_s {
  dev_t dev;
  ino_t ino;
  struct dev_inode_s *next;
};
typedef struct dev_inode_s dev_inode_t;

/* the library structure holds an entry in our private library of
   shared files. This information is kept in the file ~/.nap/shared */
struct library_s {
  char *lfn;            /* full local path name of this file */
  char *hash;           /* md5 checksum in standard nap format checksum-size */
  size_t sz;             /* file size */
  unsigned int bitrate;  /* bitrate */
  unsigned int freq;     /* frequency */
  unsigned int len;      /* length in seconds */
  struct library_s *next;
};
typedef struct library_s library_t;

/* the masquerade structure holds a list of pathname/replacement
   pairs.  It is globally persistent, i.e., it grows and never shrinks
   during a particular session of the client. This ensures that
   virtual filenames do not become inconsistent if we change our
   upload path. */
struct masquerade_s {
  char *path;    /* absolute local path */
  int n;         /* replace this path by /n */
  struct masquerade_s *next;
};
typedef struct masquerade_s masquerade_t;

library_t *read_library_file(char *sd);
int rebuild(int, char *, char *);
int isshared(char *fn, char *sd);
int buildflist(char *, char *);
void addfile(char *fn, FILE *f, dev_inode_t **di_list_p, library_t *l, time_t reftime);
mhdr_t *filestats(char *fn);
int lfiles(int, char *);
int up_to_date(char *sd, char *path);
int modified_after(time_t mtime, char *fn, dev_inode_t **di_list_p);
char *masquerade(char *path);
char *unmasquerade(char *path);
 
#endif /* not _NAP_LIBRARY_H */
