/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQMetaData;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQStaticContext;
import net.sf.saxon.Configuration;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQDataSource;
import net.sf.saxon.xqj.SaxonXQExpression;
import net.sf.saxon.xqj.SaxonXQMetaData;
import net.sf.saxon.xqj.SaxonXQPreparedExpression;
import net.sf.saxon.xqj.SaxonXQStaticContext;

public class SaxonXQConnection
extends SaxonXQDataFactory
implements XQConnection {
    private Configuration config;
    private SaxonXQStaticContext staticContext;

    SaxonXQConnection(SaxonXQDataSource dataSource) {
        this.config = dataSource.getConfiguration();
        this.staticContext = new SaxonXQStaticContext(this.config);
        this.init();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void commit() throws XQException {
        this.checkNotClosed();
    }

    public XQExpression createExpression() throws XQException {
        this.checkNotClosed();
        return new SaxonXQExpression(this);
    }

    public XQExpression createExpression(XQStaticContext properties) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(properties, "properties");
        return new SaxonXQExpression(this, (SaxonXQStaticContext)properties);
    }

    public boolean getAutoCommit() throws XQException {
        return false;
    }

    public XQMetaData getMetaData() throws XQException {
        this.checkNotClosed();
        return new SaxonXQMetaData(this);
    }

    public XQStaticContext getStaticContext() throws XQException {
        this.checkNotClosed();
        return this.staticContext;
    }

    public XQPreparedExpression prepareExpression(InputStream xquery) throws XQException {
        return this.prepareExpression(xquery, (XQStaticContext)this.staticContext);
    }

    public XQPreparedExpression prepareExpression(InputStream xquery, XQStaticContext properties) throws XQException {
        this.checkNotClosed();
        try {
            SaxonXQStaticContext xqStaticContext = (SaxonXQStaticContext)properties;
            StaticQueryContext sqc = xqStaticContext.getSaxonStaticQueryContext();
            XQueryExpression exp = sqc.compileQuery(xquery, null);
            DynamicQueryContext dqc = new DynamicQueryContext(this.config);
            return new SaxonXQPreparedExpression(this, exp, xqStaticContext, dqc);
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
        catch (IOException e) {
            throw this.newXQException(e);
        }
        catch (NullPointerException e) {
            throw this.newXQException(e);
        }
    }

    public XQPreparedExpression prepareExpression(Reader xquery) throws XQException {
        return this.prepareExpression(xquery, (XQStaticContext)this.staticContext);
    }

    public XQPreparedExpression prepareExpression(Reader xquery, XQStaticContext properties) throws XQException {
        this.checkNotClosed();
        try {
            SaxonXQStaticContext xqStaticContext = (SaxonXQStaticContext)properties;
            StaticQueryContext sqc = xqStaticContext.getSaxonStaticQueryContext();
            XQueryExpression exp = sqc.compileQuery(xquery);
            DynamicQueryContext dqc = new DynamicQueryContext(this.config);
            return new SaxonXQPreparedExpression(this, exp, xqStaticContext, dqc);
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
        catch (IOException e) {
            throw this.newXQException(e);
        }
        catch (NullPointerException e) {
            throw this.newXQException(e);
        }
    }

    public XQPreparedExpression prepareExpression(String xquery) throws XQException {
        return this.prepareExpression(xquery, (XQStaticContext)this.staticContext);
    }

    public XQPreparedExpression prepareExpression(String xquery, XQStaticContext properties) throws XQException {
        this.checkNotClosed();
        try {
            SaxonXQStaticContext xqStaticContext = (SaxonXQStaticContext)properties;
            StaticQueryContext sqc = xqStaticContext.getSaxonStaticQueryContext();
            XQueryExpression exp = sqc.compileQuery(xquery);
            DynamicQueryContext dqc = new DynamicQueryContext(this.config);
            return new SaxonXQPreparedExpression(this, exp, xqStaticContext, dqc);
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
        catch (NullPointerException e) {
            throw this.newXQException(e);
        }
    }

    public XQPreparedExpression copyPreparedExpression(XQPreparedExpression expression) throws XQException {
        this.checkNotClosed();
        if (!(expression instanceof SaxonXQPreparedExpression)) {
            throw new IllegalArgumentException("Supplied expression must be compiled using Saxon");
        }
        XQueryExpression xqe = ((SaxonXQPreparedExpression)expression).getXQueryExpression();
        if (xqe.getExecutable().getConfiguration() != this.config) {
            throw new IllegalArgumentException("Supplied expression must derive from the same XQDataSource");
        }
        SaxonXQStaticContext sqc = ((SaxonXQPreparedExpression)expression).getSaxonXQStaticContext();
        DynamicQueryContext dqc = new DynamicQueryContext(this.config);
        return new SaxonXQPreparedExpression(this, xqe, sqc, dqc);
    }

    public void rollback() throws XQException {
        this.checkNotClosed();
    }

    public void setAutoCommit(boolean autoCommit) throws XQException {
        this.checkNotClosed();
    }

    public void setStaticContext(XQStaticContext properties) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(properties, "properties");
        this.staticContext = (SaxonXQStaticContext)properties;
    }

    private XQException newXQException(Exception err) {
        XQException xqe = new XQException(err.getMessage());
        xqe.initCause(err);
        return xqe;
    }
}

