.TH AP %manext8% "December 4, 2013" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
ap \- parse addresses RFC 822-style
.SH SYNOPSIS
.HP 5
.na
.B %libdir%/ap
.RB [ \-form
.IR formatfile ]
.RB [ \-format
.IR string ]
.RB [ \-width
.IR columns ]
.RB [ \-version ]
.RB [ \-help ] 
.I addrs
\&...
.ad
.SH DESCRIPTION
.B Ap
is a program that parses addresses according to the ARPA
Internet standard.  It also understands many non\-standard formats.
It is useful for seeing how
.B nmh
will interpret an address.
.PP
The
.B ap
program treats each argument as one or more addresses, and
prints those addresses out in the official RFC 822 format.  Hence, it is
usually best to enclose each argument in quotes for the shell.
.PP
To override the output format used by
.BR ap ,
the
.B \-format
.I string
or
.B \-format
.I file
switches are used.  This permits individual fields of
the address to be extracted with ease.  The string is simply a format
string, and the file is simply a format file.  See
.IR mh\-format (5)
for the details.
.PP
In addition to the standard escapes,
.B ap
also recognizes the following additional escape:
.PP
.RS 5
.nf
.ta \w'Escape  'u +\w'Returns  'u
.I "Escape	Returns	Description"
error	string	A diagnostic if the parse failed
.RE
.fi
.PP
Here is the default format string used by
.BR ap :
.PP
.RS 5
%<{error}%{error}: %{text}%|%(putstr(proper{text}))%>
.RE
.PP
which says that if an error was detected, print the error, a `:', and
the address in error.  Otherwise, output the RFC 822\-proper format of
the address.
.SH FILES
.PD 0
.TP 20
$HOME/\&.mh\(ruprofile
The user's profile.
.TP
%etcdir%/mts.conf
The mts configuration file.
.PD
.SH "PROFILE COMPONENTS"
None
.SH "SEE ALSO"
.IR dp (8)
.PP
.I
Standard for the Format of ARPA Internet Text Messages
(RFC 822)
.SH DEFAULTS
.PD 0
.TP 20
-format
As described above.
.TP
\-width
The width of the terminal.
.PD
.SH CONTEXT
None
