module Distribution.Types.ComponentInclude
  ( ComponentInclude (..)
  , ci_id
  , ci_pkgid
  , ci_cname
  ) where

import Distribution.Types.AnnotatedId
import Distribution.Types.ComponentName
import Distribution.Types.PackageId

-- Once ci_id is refined to an 'OpenUnitId' or 'DefUnitId',
-- the 'includeRequiresRn' is not so useful (because it
-- includes the requirements renaming that is no longer
-- needed); use 'ci_prov_renaming' instead.
data ComponentInclude id rn = ComponentInclude
  { ci_ann_id :: AnnotatedId id
  , ci_renaming :: rn
  , ci_implicit :: Bool
  -- ^ Did this come from an entry in @mixins@, or
  -- was implicitly generated by @build-depends@?
  }

ci_id :: ComponentInclude id rn -> id
ci_id = ann_id . ci_ann_id

ci_pkgid :: ComponentInclude id rn -> PackageId
ci_pkgid = ann_pid . ci_ann_id

-- | This should always return 'CLibName' or 'CSubLibName'
ci_cname :: ComponentInclude id rn -> ComponentName
ci_cname = ann_cname . ci_ann_id
