//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapimanagement

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APICollection.
func (a APICollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APICollection.
func (a *APICollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIContactInformation.
func (a APIContactInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "email", a.Email)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "url", a.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIContactInformation.
func (a *APIContactInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "email":
			err = unpopulate(val, "Email", &a.Email)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &a.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIContract.
func (a APIContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIContract.
func (a *APIContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIContractProperties.
func (a APIContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiRevision", a.APIRevision)
	populate(objectMap, "apiRevisionDescription", a.APIRevisionDescription)
	populate(objectMap, "type", a.APIType)
	populate(objectMap, "apiVersion", a.APIVersion)
	populate(objectMap, "apiVersionDescription", a.APIVersionDescription)
	populate(objectMap, "apiVersionSet", a.APIVersionSet)
	populate(objectMap, "apiVersionSetId", a.APIVersionSetID)
	populate(objectMap, "authenticationSettings", a.AuthenticationSettings)
	populate(objectMap, "contact", a.Contact)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "isCurrent", a.IsCurrent)
	populate(objectMap, "isOnline", a.IsOnline)
	populate(objectMap, "license", a.License)
	populate(objectMap, "path", a.Path)
	populate(objectMap, "protocols", a.Protocols)
	populate(objectMap, "serviceUrl", a.ServiceURL)
	populate(objectMap, "sourceApiId", a.SourceAPIID)
	populate(objectMap, "subscriptionKeyParameterNames", a.SubscriptionKeyParameterNames)
	populate(objectMap, "subscriptionRequired", a.SubscriptionRequired)
	populate(objectMap, "termsOfServiceUrl", a.TermsOfServiceURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIContractProperties.
func (a *APIContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiRevision":
			err = unpopulate(val, "APIRevision", &a.APIRevision)
			delete(rawMsg, key)
		case "apiRevisionDescription":
			err = unpopulate(val, "APIRevisionDescription", &a.APIRevisionDescription)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "APIType", &a.APIType)
			delete(rawMsg, key)
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &a.APIVersion)
			delete(rawMsg, key)
		case "apiVersionDescription":
			err = unpopulate(val, "APIVersionDescription", &a.APIVersionDescription)
			delete(rawMsg, key)
		case "apiVersionSet":
			err = unpopulate(val, "APIVersionSet", &a.APIVersionSet)
			delete(rawMsg, key)
		case "apiVersionSetId":
			err = unpopulate(val, "APIVersionSetID", &a.APIVersionSetID)
			delete(rawMsg, key)
		case "authenticationSettings":
			err = unpopulate(val, "AuthenticationSettings", &a.AuthenticationSettings)
			delete(rawMsg, key)
		case "contact":
			err = unpopulate(val, "Contact", &a.Contact)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "isCurrent":
			err = unpopulate(val, "IsCurrent", &a.IsCurrent)
			delete(rawMsg, key)
		case "isOnline":
			err = unpopulate(val, "IsOnline", &a.IsOnline)
			delete(rawMsg, key)
		case "license":
			err = unpopulate(val, "License", &a.License)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &a.Path)
			delete(rawMsg, key)
		case "protocols":
			err = unpopulate(val, "Protocols", &a.Protocols)
			delete(rawMsg, key)
		case "serviceUrl":
			err = unpopulate(val, "ServiceURL", &a.ServiceURL)
			delete(rawMsg, key)
		case "sourceApiId":
			err = unpopulate(val, "SourceAPIID", &a.SourceAPIID)
			delete(rawMsg, key)
		case "subscriptionKeyParameterNames":
			err = unpopulate(val, "SubscriptionKeyParameterNames", &a.SubscriptionKeyParameterNames)
			delete(rawMsg, key)
		case "subscriptionRequired":
			err = unpopulate(val, "SubscriptionRequired", &a.SubscriptionRequired)
			delete(rawMsg, key)
		case "termsOfServiceUrl":
			err = unpopulate(val, "TermsOfServiceURL", &a.TermsOfServiceURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIContractUpdateProperties.
func (a APIContractUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiRevision", a.APIRevision)
	populate(objectMap, "apiRevisionDescription", a.APIRevisionDescription)
	populate(objectMap, "type", a.APIType)
	populate(objectMap, "apiVersion", a.APIVersion)
	populate(objectMap, "apiVersionDescription", a.APIVersionDescription)
	populate(objectMap, "apiVersionSetId", a.APIVersionSetID)
	populate(objectMap, "authenticationSettings", a.AuthenticationSettings)
	populate(objectMap, "contact", a.Contact)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "isCurrent", a.IsCurrent)
	populate(objectMap, "isOnline", a.IsOnline)
	populate(objectMap, "license", a.License)
	populate(objectMap, "path", a.Path)
	populate(objectMap, "protocols", a.Protocols)
	populate(objectMap, "serviceUrl", a.ServiceURL)
	populate(objectMap, "subscriptionKeyParameterNames", a.SubscriptionKeyParameterNames)
	populate(objectMap, "subscriptionRequired", a.SubscriptionRequired)
	populate(objectMap, "termsOfServiceUrl", a.TermsOfServiceURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIContractUpdateProperties.
func (a *APIContractUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiRevision":
			err = unpopulate(val, "APIRevision", &a.APIRevision)
			delete(rawMsg, key)
		case "apiRevisionDescription":
			err = unpopulate(val, "APIRevisionDescription", &a.APIRevisionDescription)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "APIType", &a.APIType)
			delete(rawMsg, key)
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &a.APIVersion)
			delete(rawMsg, key)
		case "apiVersionDescription":
			err = unpopulate(val, "APIVersionDescription", &a.APIVersionDescription)
			delete(rawMsg, key)
		case "apiVersionSetId":
			err = unpopulate(val, "APIVersionSetID", &a.APIVersionSetID)
			delete(rawMsg, key)
		case "authenticationSettings":
			err = unpopulate(val, "AuthenticationSettings", &a.AuthenticationSettings)
			delete(rawMsg, key)
		case "contact":
			err = unpopulate(val, "Contact", &a.Contact)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "isCurrent":
			err = unpopulate(val, "IsCurrent", &a.IsCurrent)
			delete(rawMsg, key)
		case "isOnline":
			err = unpopulate(val, "IsOnline", &a.IsOnline)
			delete(rawMsg, key)
		case "license":
			err = unpopulate(val, "License", &a.License)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &a.Path)
			delete(rawMsg, key)
		case "protocols":
			err = unpopulate(val, "Protocols", &a.Protocols)
			delete(rawMsg, key)
		case "serviceUrl":
			err = unpopulate(val, "ServiceURL", &a.ServiceURL)
			delete(rawMsg, key)
		case "subscriptionKeyParameterNames":
			err = unpopulate(val, "SubscriptionKeyParameterNames", &a.SubscriptionKeyParameterNames)
			delete(rawMsg, key)
		case "subscriptionRequired":
			err = unpopulate(val, "SubscriptionRequired", &a.SubscriptionRequired)
			delete(rawMsg, key)
		case "termsOfServiceUrl":
			err = unpopulate(val, "TermsOfServiceURL", &a.TermsOfServiceURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APICreateOrUpdateParameter.
func (a APICreateOrUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APICreateOrUpdateParameter.
func (a *APICreateOrUpdateParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APICreateOrUpdateProperties.
func (a APICreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiRevision", a.APIRevision)
	populate(objectMap, "apiRevisionDescription", a.APIRevisionDescription)
	populate(objectMap, "type", a.APIType)
	populate(objectMap, "apiVersion", a.APIVersion)
	populate(objectMap, "apiVersionDescription", a.APIVersionDescription)
	populate(objectMap, "apiVersionSet", a.APIVersionSet)
	populate(objectMap, "apiVersionSetId", a.APIVersionSetID)
	populate(objectMap, "authenticationSettings", a.AuthenticationSettings)
	populate(objectMap, "contact", a.Contact)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "format", a.Format)
	populate(objectMap, "isCurrent", a.IsCurrent)
	populate(objectMap, "isOnline", a.IsOnline)
	populate(objectMap, "license", a.License)
	populate(objectMap, "path", a.Path)
	populate(objectMap, "protocols", a.Protocols)
	populate(objectMap, "serviceUrl", a.ServiceURL)
	populate(objectMap, "apiType", a.SoapAPIType)
	populate(objectMap, "sourceApiId", a.SourceAPIID)
	populate(objectMap, "subscriptionKeyParameterNames", a.SubscriptionKeyParameterNames)
	populate(objectMap, "subscriptionRequired", a.SubscriptionRequired)
	populate(objectMap, "termsOfServiceUrl", a.TermsOfServiceURL)
	populate(objectMap, "translateRequiredQueryParameters", a.TranslateRequiredQueryParametersConduct)
	populate(objectMap, "value", a.Value)
	populate(objectMap, "wsdlSelector", a.WsdlSelector)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APICreateOrUpdateProperties.
func (a *APICreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiRevision":
			err = unpopulate(val, "APIRevision", &a.APIRevision)
			delete(rawMsg, key)
		case "apiRevisionDescription":
			err = unpopulate(val, "APIRevisionDescription", &a.APIRevisionDescription)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "APIType", &a.APIType)
			delete(rawMsg, key)
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &a.APIVersion)
			delete(rawMsg, key)
		case "apiVersionDescription":
			err = unpopulate(val, "APIVersionDescription", &a.APIVersionDescription)
			delete(rawMsg, key)
		case "apiVersionSet":
			err = unpopulate(val, "APIVersionSet", &a.APIVersionSet)
			delete(rawMsg, key)
		case "apiVersionSetId":
			err = unpopulate(val, "APIVersionSetID", &a.APIVersionSetID)
			delete(rawMsg, key)
		case "authenticationSettings":
			err = unpopulate(val, "AuthenticationSettings", &a.AuthenticationSettings)
			delete(rawMsg, key)
		case "contact":
			err = unpopulate(val, "Contact", &a.Contact)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "format":
			err = unpopulate(val, "Format", &a.Format)
			delete(rawMsg, key)
		case "isCurrent":
			err = unpopulate(val, "IsCurrent", &a.IsCurrent)
			delete(rawMsg, key)
		case "isOnline":
			err = unpopulate(val, "IsOnline", &a.IsOnline)
			delete(rawMsg, key)
		case "license":
			err = unpopulate(val, "License", &a.License)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &a.Path)
			delete(rawMsg, key)
		case "protocols":
			err = unpopulate(val, "Protocols", &a.Protocols)
			delete(rawMsg, key)
		case "serviceUrl":
			err = unpopulate(val, "ServiceURL", &a.ServiceURL)
			delete(rawMsg, key)
		case "apiType":
			err = unpopulate(val, "SoapAPIType", &a.SoapAPIType)
			delete(rawMsg, key)
		case "sourceApiId":
			err = unpopulate(val, "SourceAPIID", &a.SourceAPIID)
			delete(rawMsg, key)
		case "subscriptionKeyParameterNames":
			err = unpopulate(val, "SubscriptionKeyParameterNames", &a.SubscriptionKeyParameterNames)
			delete(rawMsg, key)
		case "subscriptionRequired":
			err = unpopulate(val, "SubscriptionRequired", &a.SubscriptionRequired)
			delete(rawMsg, key)
		case "termsOfServiceUrl":
			err = unpopulate(val, "TermsOfServiceURL", &a.TermsOfServiceURL)
			delete(rawMsg, key)
		case "translateRequiredQueryParameters":
			err = unpopulate(val, "TranslateRequiredQueryParametersConduct", &a.TranslateRequiredQueryParametersConduct)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		case "wsdlSelector":
			err = unpopulate(val, "WsdlSelector", &a.WsdlSelector)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APICreateOrUpdatePropertiesWsdlSelector.
func (a APICreateOrUpdatePropertiesWsdlSelector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "wsdlEndpointName", a.WsdlEndpointName)
	populate(objectMap, "wsdlServiceName", a.WsdlServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APICreateOrUpdatePropertiesWsdlSelector.
func (a *APICreateOrUpdatePropertiesWsdlSelector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "wsdlEndpointName":
			err = unpopulate(val, "WsdlEndpointName", &a.WsdlEndpointName)
			delete(rawMsg, key)
		case "wsdlServiceName":
			err = unpopulate(val, "WsdlServiceName", &a.WsdlServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIEntityBaseContract.
func (a APIEntityBaseContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiRevision", a.APIRevision)
	populate(objectMap, "apiRevisionDescription", a.APIRevisionDescription)
	populate(objectMap, "type", a.APIType)
	populate(objectMap, "apiVersion", a.APIVersion)
	populate(objectMap, "apiVersionDescription", a.APIVersionDescription)
	populate(objectMap, "apiVersionSetId", a.APIVersionSetID)
	populate(objectMap, "authenticationSettings", a.AuthenticationSettings)
	populate(objectMap, "contact", a.Contact)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "isCurrent", a.IsCurrent)
	populate(objectMap, "isOnline", a.IsOnline)
	populate(objectMap, "license", a.License)
	populate(objectMap, "subscriptionKeyParameterNames", a.SubscriptionKeyParameterNames)
	populate(objectMap, "subscriptionRequired", a.SubscriptionRequired)
	populate(objectMap, "termsOfServiceUrl", a.TermsOfServiceURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIEntityBaseContract.
func (a *APIEntityBaseContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiRevision":
			err = unpopulate(val, "APIRevision", &a.APIRevision)
			delete(rawMsg, key)
		case "apiRevisionDescription":
			err = unpopulate(val, "APIRevisionDescription", &a.APIRevisionDescription)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "APIType", &a.APIType)
			delete(rawMsg, key)
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &a.APIVersion)
			delete(rawMsg, key)
		case "apiVersionDescription":
			err = unpopulate(val, "APIVersionDescription", &a.APIVersionDescription)
			delete(rawMsg, key)
		case "apiVersionSetId":
			err = unpopulate(val, "APIVersionSetID", &a.APIVersionSetID)
			delete(rawMsg, key)
		case "authenticationSettings":
			err = unpopulate(val, "AuthenticationSettings", &a.AuthenticationSettings)
			delete(rawMsg, key)
		case "contact":
			err = unpopulate(val, "Contact", &a.Contact)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "isCurrent":
			err = unpopulate(val, "IsCurrent", &a.IsCurrent)
			delete(rawMsg, key)
		case "isOnline":
			err = unpopulate(val, "IsOnline", &a.IsOnline)
			delete(rawMsg, key)
		case "license":
			err = unpopulate(val, "License", &a.License)
			delete(rawMsg, key)
		case "subscriptionKeyParameterNames":
			err = unpopulate(val, "SubscriptionKeyParameterNames", &a.SubscriptionKeyParameterNames)
			delete(rawMsg, key)
		case "subscriptionRequired":
			err = unpopulate(val, "SubscriptionRequired", &a.SubscriptionRequired)
			delete(rawMsg, key)
		case "termsOfServiceUrl":
			err = unpopulate(val, "TermsOfServiceURL", &a.TermsOfServiceURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIExportResult.
func (a APIExportResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "format", a.ExportResultFormat)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIExportResult.
func (a *APIExportResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "format":
			err = unpopulate(val, "ExportResultFormat", &a.ExportResultFormat)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIExportResultValue.
func (a APIExportResultValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "link", a.Link)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIExportResultValue.
func (a *APIExportResultValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "link":
			err = unpopulate(val, "Link", &a.Link)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APILicenseInformation.
func (a APILicenseInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "url", a.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APILicenseInformation.
func (a *APILicenseInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &a.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIReleaseCollection.
func (a APIReleaseCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIReleaseCollection.
func (a *APIReleaseCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIReleaseContract.
func (a APIReleaseContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIReleaseContract.
func (a *APIReleaseContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIReleaseContractProperties.
func (a APIReleaseContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiId", a.APIID)
	populateDateTimeRFC3339(objectMap, "createdDateTime", a.CreatedDateTime)
	populate(objectMap, "notes", a.Notes)
	populateDateTimeRFC3339(objectMap, "updatedDateTime", a.UpdatedDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIReleaseContractProperties.
func (a *APIReleaseContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &a.APIID)
			delete(rawMsg, key)
		case "createdDateTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedDateTime", &a.CreatedDateTime)
			delete(rawMsg, key)
		case "notes":
			err = unpopulate(val, "Notes", &a.Notes)
			delete(rawMsg, key)
		case "updatedDateTime":
			err = unpopulateDateTimeRFC3339(val, "UpdatedDateTime", &a.UpdatedDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIRevisionCollection.
func (a APIRevisionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIRevisionCollection.
func (a *APIRevisionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIRevisionContract.
func (a APIRevisionContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiId", a.APIID)
	populate(objectMap, "apiRevision", a.APIRevision)
	populateDateTimeRFC3339(objectMap, "createdDateTime", a.CreatedDateTime)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "isCurrent", a.IsCurrent)
	populate(objectMap, "isOnline", a.IsOnline)
	populate(objectMap, "privateUrl", a.PrivateURL)
	populateDateTimeRFC3339(objectMap, "updatedDateTime", a.UpdatedDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIRevisionContract.
func (a *APIRevisionContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &a.APIID)
			delete(rawMsg, key)
		case "apiRevision":
			err = unpopulate(val, "APIRevision", &a.APIRevision)
			delete(rawMsg, key)
		case "createdDateTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedDateTime", &a.CreatedDateTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "isCurrent":
			err = unpopulate(val, "IsCurrent", &a.IsCurrent)
			delete(rawMsg, key)
		case "isOnline":
			err = unpopulate(val, "IsOnline", &a.IsOnline)
			delete(rawMsg, key)
		case "privateUrl":
			err = unpopulate(val, "PrivateURL", &a.PrivateURL)
			delete(rawMsg, key)
		case "updatedDateTime":
			err = unpopulateDateTimeRFC3339(val, "UpdatedDateTime", &a.UpdatedDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIRevisionInfoContract.
func (a APIRevisionInfoContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiRevisionDescription", a.APIRevisionDescription)
	populate(objectMap, "apiVersionName", a.APIVersionName)
	populate(objectMap, "apiVersionSet", a.APIVersionSet)
	populate(objectMap, "sourceApiId", a.SourceAPIID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIRevisionInfoContract.
func (a *APIRevisionInfoContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiRevisionDescription":
			err = unpopulate(val, "APIRevisionDescription", &a.APIRevisionDescription)
			delete(rawMsg, key)
		case "apiVersionName":
			err = unpopulate(val, "APIVersionName", &a.APIVersionName)
			delete(rawMsg, key)
		case "apiVersionSet":
			err = unpopulate(val, "APIVersionSet", &a.APIVersionSet)
			delete(rawMsg, key)
		case "sourceApiId":
			err = unpopulate(val, "SourceAPIID", &a.SourceAPIID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APITagResourceContractProperties.
func (a APITagResourceContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiRevision", a.APIRevision)
	populate(objectMap, "apiRevisionDescription", a.APIRevisionDescription)
	populate(objectMap, "type", a.APIType)
	populate(objectMap, "apiVersion", a.APIVersion)
	populate(objectMap, "apiVersionDescription", a.APIVersionDescription)
	populate(objectMap, "apiVersionSetId", a.APIVersionSetID)
	populate(objectMap, "authenticationSettings", a.AuthenticationSettings)
	populate(objectMap, "contact", a.Contact)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "isCurrent", a.IsCurrent)
	populate(objectMap, "isOnline", a.IsOnline)
	populate(objectMap, "license", a.License)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "path", a.Path)
	populate(objectMap, "protocols", a.Protocols)
	populate(objectMap, "serviceUrl", a.ServiceURL)
	populate(objectMap, "subscriptionKeyParameterNames", a.SubscriptionKeyParameterNames)
	populate(objectMap, "subscriptionRequired", a.SubscriptionRequired)
	populate(objectMap, "termsOfServiceUrl", a.TermsOfServiceURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APITagResourceContractProperties.
func (a *APITagResourceContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiRevision":
			err = unpopulate(val, "APIRevision", &a.APIRevision)
			delete(rawMsg, key)
		case "apiRevisionDescription":
			err = unpopulate(val, "APIRevisionDescription", &a.APIRevisionDescription)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "APIType", &a.APIType)
			delete(rawMsg, key)
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &a.APIVersion)
			delete(rawMsg, key)
		case "apiVersionDescription":
			err = unpopulate(val, "APIVersionDescription", &a.APIVersionDescription)
			delete(rawMsg, key)
		case "apiVersionSetId":
			err = unpopulate(val, "APIVersionSetID", &a.APIVersionSetID)
			delete(rawMsg, key)
		case "authenticationSettings":
			err = unpopulate(val, "AuthenticationSettings", &a.AuthenticationSettings)
			delete(rawMsg, key)
		case "contact":
			err = unpopulate(val, "Contact", &a.Contact)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "isCurrent":
			err = unpopulate(val, "IsCurrent", &a.IsCurrent)
			delete(rawMsg, key)
		case "isOnline":
			err = unpopulate(val, "IsOnline", &a.IsOnline)
			delete(rawMsg, key)
		case "license":
			err = unpopulate(val, "License", &a.License)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &a.Path)
			delete(rawMsg, key)
		case "protocols":
			err = unpopulate(val, "Protocols", &a.Protocols)
			delete(rawMsg, key)
		case "serviceUrl":
			err = unpopulate(val, "ServiceURL", &a.ServiceURL)
			delete(rawMsg, key)
		case "subscriptionKeyParameterNames":
			err = unpopulate(val, "SubscriptionKeyParameterNames", &a.SubscriptionKeyParameterNames)
			delete(rawMsg, key)
		case "subscriptionRequired":
			err = unpopulate(val, "SubscriptionRequired", &a.SubscriptionRequired)
			delete(rawMsg, key)
		case "termsOfServiceUrl":
			err = unpopulate(val, "TermsOfServiceURL", &a.TermsOfServiceURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIUpdateContract.
func (a APIUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIUpdateContract.
func (a *APIUpdateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIVersionConstraint.
func (a APIVersionConstraint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "minApiVersion", a.MinAPIVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIVersionConstraint.
func (a *APIVersionConstraint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "minApiVersion":
			err = unpopulate(val, "MinAPIVersion", &a.MinAPIVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIVersionSetCollection.
func (a APIVersionSetCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIVersionSetCollection.
func (a *APIVersionSetCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIVersionSetContract.
func (a APIVersionSetContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIVersionSetContract.
func (a *APIVersionSetContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIVersionSetContractDetails.
func (a APIVersionSetContractDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "versionHeaderName", a.VersionHeaderName)
	populate(objectMap, "versionQueryName", a.VersionQueryName)
	populate(objectMap, "versioningScheme", a.VersioningScheme)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIVersionSetContractDetails.
func (a *APIVersionSetContractDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "versionHeaderName":
			err = unpopulate(val, "VersionHeaderName", &a.VersionHeaderName)
			delete(rawMsg, key)
		case "versionQueryName":
			err = unpopulate(val, "VersionQueryName", &a.VersionQueryName)
			delete(rawMsg, key)
		case "versioningScheme":
			err = unpopulate(val, "VersioningScheme", &a.VersioningScheme)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIVersionSetContractProperties.
func (a APIVersionSetContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "versionHeaderName", a.VersionHeaderName)
	populate(objectMap, "versionQueryName", a.VersionQueryName)
	populate(objectMap, "versioningScheme", a.VersioningScheme)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIVersionSetContractProperties.
func (a *APIVersionSetContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "versionHeaderName":
			err = unpopulate(val, "VersionHeaderName", &a.VersionHeaderName)
			delete(rawMsg, key)
		case "versionQueryName":
			err = unpopulate(val, "VersionQueryName", &a.VersionQueryName)
			delete(rawMsg, key)
		case "versioningScheme":
			err = unpopulate(val, "VersioningScheme", &a.VersioningScheme)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIVersionSetEntityBase.
func (a APIVersionSetEntityBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "versionHeaderName", a.VersionHeaderName)
	populate(objectMap, "versionQueryName", a.VersionQueryName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIVersionSetEntityBase.
func (a *APIVersionSetEntityBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "versionHeaderName":
			err = unpopulate(val, "VersionHeaderName", &a.VersionHeaderName)
			delete(rawMsg, key)
		case "versionQueryName":
			err = unpopulate(val, "VersionQueryName", &a.VersionQueryName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIVersionSetUpdateParameters.
func (a APIVersionSetUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIVersionSetUpdateParameters.
func (a *APIVersionSetUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIVersionSetUpdateParametersProperties.
func (a APIVersionSetUpdateParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "versionHeaderName", a.VersionHeaderName)
	populate(objectMap, "versionQueryName", a.VersionQueryName)
	populate(objectMap, "versioningScheme", a.VersioningScheme)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIVersionSetUpdateParametersProperties.
func (a *APIVersionSetUpdateParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "versionHeaderName":
			err = unpopulate(val, "VersionHeaderName", &a.VersionHeaderName)
			delete(rawMsg, key)
		case "versionQueryName":
			err = unpopulate(val, "VersionQueryName", &a.VersionQueryName)
			delete(rawMsg, key)
		case "versioningScheme":
			err = unpopulate(val, "VersioningScheme", &a.VersioningScheme)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessInformationCollection.
func (a AccessInformationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessInformationCollection.
func (a *AccessInformationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessInformationContract.
func (a AccessInformationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessInformationContract.
func (a *AccessInformationContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessInformationContractProperties.
func (a AccessInformationContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "principalId", a.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessInformationContractProperties.
func (a *AccessInformationContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &a.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessInformationCreateParameterProperties.
func (a AccessInformationCreateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "primaryKey", a.PrimaryKey)
	populate(objectMap, "principalId", a.PrincipalID)
	populate(objectMap, "secondaryKey", a.SecondaryKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessInformationCreateParameterProperties.
func (a *AccessInformationCreateParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &a.PrimaryKey)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &a.PrincipalID)
			delete(rawMsg, key)
		case "secondaryKey":
			err = unpopulate(val, "SecondaryKey", &a.SecondaryKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessInformationCreateParameters.
func (a AccessInformationCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessInformationCreateParameters.
func (a *AccessInformationCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessInformationSecretsContract.
func (a AccessInformationSecretsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "primaryKey", a.PrimaryKey)
	populate(objectMap, "principalId", a.PrincipalID)
	populate(objectMap, "secondaryKey", a.SecondaryKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessInformationSecretsContract.
func (a *AccessInformationSecretsContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &a.PrimaryKey)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &a.PrincipalID)
			delete(rawMsg, key)
		case "secondaryKey":
			err = unpopulate(val, "SecondaryKey", &a.SecondaryKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessInformationUpdateParameterProperties.
func (a AccessInformationUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessInformationUpdateParameterProperties.
func (a *AccessInformationUpdateParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessInformationUpdateParameters.
func (a AccessInformationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessInformationUpdateParameters.
func (a *AccessInformationUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdditionalLocation.
func (a AdditionalLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disableGateway", a.DisableGateway)
	populate(objectMap, "gatewayRegionalUrl", a.GatewayRegionalURL)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "natGatewayState", a.NatGatewayState)
	populate(objectMap, "outboundPublicIPAddresses", a.OutboundPublicIPAddresses)
	populate(objectMap, "platformVersion", a.PlatformVersion)
	populate(objectMap, "privateIPAddresses", a.PrivateIPAddresses)
	populate(objectMap, "publicIpAddressId", a.PublicIPAddressID)
	populate(objectMap, "publicIPAddresses", a.PublicIPAddresses)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "virtualNetworkConfiguration", a.VirtualNetworkConfiguration)
	populate(objectMap, "zones", a.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdditionalLocation.
func (a *AdditionalLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableGateway":
			err = unpopulate(val, "DisableGateway", &a.DisableGateway)
			delete(rawMsg, key)
		case "gatewayRegionalUrl":
			err = unpopulate(val, "GatewayRegionalURL", &a.GatewayRegionalURL)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "natGatewayState":
			err = unpopulate(val, "NatGatewayState", &a.NatGatewayState)
			delete(rawMsg, key)
		case "outboundPublicIPAddresses":
			err = unpopulate(val, "OutboundPublicIPAddresses", &a.OutboundPublicIPAddresses)
			delete(rawMsg, key)
		case "platformVersion":
			err = unpopulate(val, "PlatformVersion", &a.PlatformVersion)
			delete(rawMsg, key)
		case "privateIPAddresses":
			err = unpopulate(val, "PrivateIPAddresses", &a.PrivateIPAddresses)
			delete(rawMsg, key)
		case "publicIpAddressId":
			err = unpopulate(val, "PublicIPAddressID", &a.PublicIPAddressID)
			delete(rawMsg, key)
		case "publicIPAddresses":
			err = unpopulate(val, "PublicIPAddresses", &a.PublicIPAddresses)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "virtualNetworkConfiguration":
			err = unpopulate(val, "VirtualNetworkConfiguration", &a.VirtualNetworkConfiguration)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &a.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApimResource.
func (a ApimResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApimResource.
func (a *ApimResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmIDWrapper.
func (a ArmIDWrapper) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmIDWrapper.
func (a *ArmIDWrapper) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssociationContract.
func (a AssociationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssociationContract.
func (a *AssociationContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssociationContractProperties.
func (a AssociationContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["provisioningState"] = "created"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssociationContractProperties.
func (a *AssociationContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthenticationSettingsContract.
func (a AuthenticationSettingsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "oAuth2", a.OAuth2)
	populate(objectMap, "oAuth2AuthenticationSettings", a.OAuth2AuthenticationSettings)
	populate(objectMap, "openid", a.Openid)
	populate(objectMap, "openidAuthenticationSettings", a.OpenidAuthenticationSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthenticationSettingsContract.
func (a *AuthenticationSettingsContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "oAuth2":
			err = unpopulate(val, "OAuth2", &a.OAuth2)
			delete(rawMsg, key)
		case "oAuth2AuthenticationSettings":
			err = unpopulate(val, "OAuth2AuthenticationSettings", &a.OAuth2AuthenticationSettings)
			delete(rawMsg, key)
		case "openid":
			err = unpopulate(val, "Openid", &a.Openid)
			delete(rawMsg, key)
		case "openidAuthenticationSettings":
			err = unpopulate(val, "OpenidAuthenticationSettings", &a.OpenidAuthenticationSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationAccessPolicyCollection.
func (a AuthorizationAccessPolicyCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationAccessPolicyCollection.
func (a *AuthorizationAccessPolicyCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationAccessPolicyContract.
func (a AuthorizationAccessPolicyContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationAccessPolicyContract.
func (a *AuthorizationAccessPolicyContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationAccessPolicyContractProperties.
func (a AuthorizationAccessPolicyContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "objectId", a.ObjectID)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationAccessPolicyContractProperties.
func (a *AuthorizationAccessPolicyContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectId":
			err = unpopulate(val, "ObjectID", &a.ObjectID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationCollection.
func (a AuthorizationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationCollection.
func (a *AuthorizationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationConfirmConsentCodeRequestContract.
func (a AuthorizationConfirmConsentCodeRequestContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consentCode", a.ConsentCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationConfirmConsentCodeRequestContract.
func (a *AuthorizationConfirmConsentCodeRequestContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consentCode":
			err = unpopulate(val, "ConsentCode", &a.ConsentCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationContract.
func (a AuthorizationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationContract.
func (a *AuthorizationContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationContractProperties.
func (a AuthorizationContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationType", a.AuthorizationType)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "oauth2grantType", a.OAuth2GrantType)
	populate(objectMap, "parameters", a.Parameters)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationContractProperties.
func (a *AuthorizationContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationType":
			err = unpopulate(val, "AuthorizationType", &a.AuthorizationType)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "oauth2grantType":
			err = unpopulate(val, "OAuth2GrantType", &a.OAuth2GrantType)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationError.
func (a AuthorizationError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "message", a.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationError.
func (a *AuthorizationError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationLoginRequestContract.
func (a AuthorizationLoginRequestContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "postLoginRedirectUrl", a.PostLoginRedirectURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationLoginRequestContract.
func (a *AuthorizationLoginRequestContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "postLoginRedirectUrl":
			err = unpopulate(val, "PostLoginRedirectURL", &a.PostLoginRedirectURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationLoginResponseContract.
func (a AuthorizationLoginResponseContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "loginLink", a.LoginLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationLoginResponseContract.
func (a *AuthorizationLoginResponseContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "loginLink":
			err = unpopulate(val, "LoginLink", &a.LoginLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationProviderCollection.
func (a AuthorizationProviderCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationProviderCollection.
func (a *AuthorizationProviderCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationProviderContract.
func (a AuthorizationProviderContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationProviderContract.
func (a *AuthorizationProviderContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationProviderContractProperties.
func (a AuthorizationProviderContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "identityProvider", a.IdentityProvider)
	populate(objectMap, "oauth2", a.Oauth2)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationProviderContractProperties.
func (a *AuthorizationProviderContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "identityProvider":
			err = unpopulate(val, "IdentityProvider", &a.IdentityProvider)
			delete(rawMsg, key)
		case "oauth2":
			err = unpopulate(val, "Oauth2", &a.Oauth2)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationProviderOAuth2GrantTypes.
func (a AuthorizationProviderOAuth2GrantTypes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationCode", a.AuthorizationCode)
	populate(objectMap, "clientCredentials", a.ClientCredentials)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationProviderOAuth2GrantTypes.
func (a *AuthorizationProviderOAuth2GrantTypes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationCode":
			err = unpopulate(val, "AuthorizationCode", &a.AuthorizationCode)
			delete(rawMsg, key)
		case "clientCredentials":
			err = unpopulate(val, "ClientCredentials", &a.ClientCredentials)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationProviderOAuth2Settings.
func (a AuthorizationProviderOAuth2Settings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "grantTypes", a.GrantTypes)
	populate(objectMap, "redirectUrl", a.RedirectURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationProviderOAuth2Settings.
func (a *AuthorizationProviderOAuth2Settings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "grantTypes":
			err = unpopulate(val, "GrantTypes", &a.GrantTypes)
			delete(rawMsg, key)
		case "redirectUrl":
			err = unpopulate(val, "RedirectURL", &a.RedirectURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationServerCollection.
func (a AuthorizationServerCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationServerCollection.
func (a *AuthorizationServerCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationServerContract.
func (a AuthorizationServerContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationServerContract.
func (a *AuthorizationServerContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationServerContractBaseProperties.
func (a AuthorizationServerContractBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationMethods", a.AuthorizationMethods)
	populate(objectMap, "bearerTokenSendingMethods", a.BearerTokenSendingMethods)
	populate(objectMap, "clientAuthenticationMethod", a.ClientAuthenticationMethod)
	populate(objectMap, "defaultScope", a.DefaultScope)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "resourceOwnerPassword", a.ResourceOwnerPassword)
	populate(objectMap, "resourceOwnerUsername", a.ResourceOwnerUsername)
	populate(objectMap, "supportState", a.SupportState)
	populate(objectMap, "tokenBodyParameters", a.TokenBodyParameters)
	populate(objectMap, "tokenEndpoint", a.TokenEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationServerContractBaseProperties.
func (a *AuthorizationServerContractBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationMethods":
			err = unpopulate(val, "AuthorizationMethods", &a.AuthorizationMethods)
			delete(rawMsg, key)
		case "bearerTokenSendingMethods":
			err = unpopulate(val, "BearerTokenSendingMethods", &a.BearerTokenSendingMethods)
			delete(rawMsg, key)
		case "clientAuthenticationMethod":
			err = unpopulate(val, "ClientAuthenticationMethod", &a.ClientAuthenticationMethod)
			delete(rawMsg, key)
		case "defaultScope":
			err = unpopulate(val, "DefaultScope", &a.DefaultScope)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "resourceOwnerPassword":
			err = unpopulate(val, "ResourceOwnerPassword", &a.ResourceOwnerPassword)
			delete(rawMsg, key)
		case "resourceOwnerUsername":
			err = unpopulate(val, "ResourceOwnerUsername", &a.ResourceOwnerUsername)
			delete(rawMsg, key)
		case "supportState":
			err = unpopulate(val, "SupportState", &a.SupportState)
			delete(rawMsg, key)
		case "tokenBodyParameters":
			err = unpopulate(val, "TokenBodyParameters", &a.TokenBodyParameters)
			delete(rawMsg, key)
		case "tokenEndpoint":
			err = unpopulate(val, "TokenEndpoint", &a.TokenEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationServerContractProperties.
func (a AuthorizationServerContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationEndpoint", a.AuthorizationEndpoint)
	populate(objectMap, "authorizationMethods", a.AuthorizationMethods)
	populate(objectMap, "bearerTokenSendingMethods", a.BearerTokenSendingMethods)
	populate(objectMap, "clientAuthenticationMethod", a.ClientAuthenticationMethod)
	populate(objectMap, "clientId", a.ClientID)
	populate(objectMap, "clientRegistrationEndpoint", a.ClientRegistrationEndpoint)
	populate(objectMap, "clientSecret", a.ClientSecret)
	populate(objectMap, "defaultScope", a.DefaultScope)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "grantTypes", a.GrantTypes)
	populate(objectMap, "resourceOwnerPassword", a.ResourceOwnerPassword)
	populate(objectMap, "resourceOwnerUsername", a.ResourceOwnerUsername)
	populate(objectMap, "supportState", a.SupportState)
	populate(objectMap, "tokenBodyParameters", a.TokenBodyParameters)
	populate(objectMap, "tokenEndpoint", a.TokenEndpoint)
	populate(objectMap, "useInApiDocumentation", a.UseInAPIDocumentation)
	populate(objectMap, "useInTestConsole", a.UseInTestConsole)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationServerContractProperties.
func (a *AuthorizationServerContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationEndpoint":
			err = unpopulate(val, "AuthorizationEndpoint", &a.AuthorizationEndpoint)
			delete(rawMsg, key)
		case "authorizationMethods":
			err = unpopulate(val, "AuthorizationMethods", &a.AuthorizationMethods)
			delete(rawMsg, key)
		case "bearerTokenSendingMethods":
			err = unpopulate(val, "BearerTokenSendingMethods", &a.BearerTokenSendingMethods)
			delete(rawMsg, key)
		case "clientAuthenticationMethod":
			err = unpopulate(val, "ClientAuthenticationMethod", &a.ClientAuthenticationMethod)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &a.ClientID)
			delete(rawMsg, key)
		case "clientRegistrationEndpoint":
			err = unpopulate(val, "ClientRegistrationEndpoint", &a.ClientRegistrationEndpoint)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &a.ClientSecret)
			delete(rawMsg, key)
		case "defaultScope":
			err = unpopulate(val, "DefaultScope", &a.DefaultScope)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "grantTypes":
			err = unpopulate(val, "GrantTypes", &a.GrantTypes)
			delete(rawMsg, key)
		case "resourceOwnerPassword":
			err = unpopulate(val, "ResourceOwnerPassword", &a.ResourceOwnerPassword)
			delete(rawMsg, key)
		case "resourceOwnerUsername":
			err = unpopulate(val, "ResourceOwnerUsername", &a.ResourceOwnerUsername)
			delete(rawMsg, key)
		case "supportState":
			err = unpopulate(val, "SupportState", &a.SupportState)
			delete(rawMsg, key)
		case "tokenBodyParameters":
			err = unpopulate(val, "TokenBodyParameters", &a.TokenBodyParameters)
			delete(rawMsg, key)
		case "tokenEndpoint":
			err = unpopulate(val, "TokenEndpoint", &a.TokenEndpoint)
			delete(rawMsg, key)
		case "useInApiDocumentation":
			err = unpopulate(val, "UseInAPIDocumentation", &a.UseInAPIDocumentation)
			delete(rawMsg, key)
		case "useInTestConsole":
			err = unpopulate(val, "UseInTestConsole", &a.UseInTestConsole)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationServerSecretsContract.
func (a AuthorizationServerSecretsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientSecret", a.ClientSecret)
	populate(objectMap, "resourceOwnerPassword", a.ResourceOwnerPassword)
	populate(objectMap, "resourceOwnerUsername", a.ResourceOwnerUsername)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationServerSecretsContract.
func (a *AuthorizationServerSecretsContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &a.ClientSecret)
			delete(rawMsg, key)
		case "resourceOwnerPassword":
			err = unpopulate(val, "ResourceOwnerPassword", &a.ResourceOwnerPassword)
			delete(rawMsg, key)
		case "resourceOwnerUsername":
			err = unpopulate(val, "ResourceOwnerUsername", &a.ResourceOwnerUsername)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationServerUpdateContract.
func (a AuthorizationServerUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationServerUpdateContract.
func (a *AuthorizationServerUpdateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationServerUpdateContractProperties.
func (a AuthorizationServerUpdateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationEndpoint", a.AuthorizationEndpoint)
	populate(objectMap, "authorizationMethods", a.AuthorizationMethods)
	populate(objectMap, "bearerTokenSendingMethods", a.BearerTokenSendingMethods)
	populate(objectMap, "clientAuthenticationMethod", a.ClientAuthenticationMethod)
	populate(objectMap, "clientId", a.ClientID)
	populate(objectMap, "clientRegistrationEndpoint", a.ClientRegistrationEndpoint)
	populate(objectMap, "clientSecret", a.ClientSecret)
	populate(objectMap, "defaultScope", a.DefaultScope)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "grantTypes", a.GrantTypes)
	populate(objectMap, "resourceOwnerPassword", a.ResourceOwnerPassword)
	populate(objectMap, "resourceOwnerUsername", a.ResourceOwnerUsername)
	populate(objectMap, "supportState", a.SupportState)
	populate(objectMap, "tokenBodyParameters", a.TokenBodyParameters)
	populate(objectMap, "tokenEndpoint", a.TokenEndpoint)
	populate(objectMap, "useInApiDocumentation", a.UseInAPIDocumentation)
	populate(objectMap, "useInTestConsole", a.UseInTestConsole)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationServerUpdateContractProperties.
func (a *AuthorizationServerUpdateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationEndpoint":
			err = unpopulate(val, "AuthorizationEndpoint", &a.AuthorizationEndpoint)
			delete(rawMsg, key)
		case "authorizationMethods":
			err = unpopulate(val, "AuthorizationMethods", &a.AuthorizationMethods)
			delete(rawMsg, key)
		case "bearerTokenSendingMethods":
			err = unpopulate(val, "BearerTokenSendingMethods", &a.BearerTokenSendingMethods)
			delete(rawMsg, key)
		case "clientAuthenticationMethod":
			err = unpopulate(val, "ClientAuthenticationMethod", &a.ClientAuthenticationMethod)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &a.ClientID)
			delete(rawMsg, key)
		case "clientRegistrationEndpoint":
			err = unpopulate(val, "ClientRegistrationEndpoint", &a.ClientRegistrationEndpoint)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &a.ClientSecret)
			delete(rawMsg, key)
		case "defaultScope":
			err = unpopulate(val, "DefaultScope", &a.DefaultScope)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "grantTypes":
			err = unpopulate(val, "GrantTypes", &a.GrantTypes)
			delete(rawMsg, key)
		case "resourceOwnerPassword":
			err = unpopulate(val, "ResourceOwnerPassword", &a.ResourceOwnerPassword)
			delete(rawMsg, key)
		case "resourceOwnerUsername":
			err = unpopulate(val, "ResourceOwnerUsername", &a.ResourceOwnerUsername)
			delete(rawMsg, key)
		case "supportState":
			err = unpopulate(val, "SupportState", &a.SupportState)
			delete(rawMsg, key)
		case "tokenBodyParameters":
			err = unpopulate(val, "TokenBodyParameters", &a.TokenBodyParameters)
			delete(rawMsg, key)
		case "tokenEndpoint":
			err = unpopulate(val, "TokenEndpoint", &a.TokenEndpoint)
			delete(rawMsg, key)
		case "useInApiDocumentation":
			err = unpopulate(val, "UseInAPIDocumentation", &a.UseInAPIDocumentation)
			delete(rawMsg, key)
		case "useInTestConsole":
			err = unpopulate(val, "UseInTestConsole", &a.UseInTestConsole)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendAuthorizationHeaderCredentials.
func (b BackendAuthorizationHeaderCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parameter", b.Parameter)
	populate(objectMap, "scheme", b.Scheme)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendAuthorizationHeaderCredentials.
func (b *BackendAuthorizationHeaderCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameter":
			err = unpopulate(val, "Parameter", &b.Parameter)
			delete(rawMsg, key)
		case "scheme":
			err = unpopulate(val, "Scheme", &b.Scheme)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendBaseParameters.
func (b BackendBaseParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "credentials", b.Credentials)
	populate(objectMap, "description", b.Description)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "proxy", b.Proxy)
	populate(objectMap, "resourceId", b.ResourceID)
	populate(objectMap, "tls", b.TLS)
	populate(objectMap, "title", b.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendBaseParameters.
func (b *BackendBaseParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentials":
			err = unpopulate(val, "Credentials", &b.Credentials)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &b.Description)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "proxy":
			err = unpopulate(val, "Proxy", &b.Proxy)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &b.ResourceID)
			delete(rawMsg, key)
		case "tls":
			err = unpopulate(val, "TLS", &b.TLS)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &b.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendCollection.
func (b BackendCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", b.Count)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendCollection.
func (b *BackendCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &b.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendContract.
func (b BackendContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendContract.
func (b *BackendContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendContractProperties.
func (b BackendContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "credentials", b.Credentials)
	populate(objectMap, "description", b.Description)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "protocol", b.Protocol)
	populate(objectMap, "proxy", b.Proxy)
	populate(objectMap, "resourceId", b.ResourceID)
	populate(objectMap, "tls", b.TLS)
	populate(objectMap, "title", b.Title)
	populate(objectMap, "url", b.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendContractProperties.
func (b *BackendContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentials":
			err = unpopulate(val, "Credentials", &b.Credentials)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &b.Description)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &b.Protocol)
			delete(rawMsg, key)
		case "proxy":
			err = unpopulate(val, "Proxy", &b.Proxy)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &b.ResourceID)
			delete(rawMsg, key)
		case "tls":
			err = unpopulate(val, "TLS", &b.TLS)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &b.Title)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &b.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendCredentialsContract.
func (b BackendCredentialsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorization", b.Authorization)
	populate(objectMap, "certificate", b.Certificate)
	populate(objectMap, "certificateIds", b.CertificateIDs)
	populate(objectMap, "header", b.Header)
	populate(objectMap, "query", b.Query)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendCredentialsContract.
func (b *BackendCredentialsContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorization":
			err = unpopulate(val, "Authorization", &b.Authorization)
			delete(rawMsg, key)
		case "certificate":
			err = unpopulate(val, "Certificate", &b.Certificate)
			delete(rawMsg, key)
		case "certificateIds":
			err = unpopulate(val, "CertificateIDs", &b.CertificateIDs)
			delete(rawMsg, key)
		case "header":
			err = unpopulate(val, "Header", &b.Header)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &b.Query)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendProperties.
func (b BackendProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceFabricCluster", b.ServiceFabricCluster)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendProperties.
func (b *BackendProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceFabricCluster":
			err = unpopulate(val, "ServiceFabricCluster", &b.ServiceFabricCluster)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendProxyContract.
func (b BackendProxyContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", b.Password)
	populate(objectMap, "url", b.URL)
	populate(objectMap, "username", b.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendProxyContract.
func (b *BackendProxyContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &b.Password)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &b.URL)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &b.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendReconnectContract.
func (b BackendReconnectContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendReconnectContract.
func (b *BackendReconnectContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendReconnectProperties.
func (b BackendReconnectProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "after", b.After)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendReconnectProperties.
func (b *BackendReconnectProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "after":
			err = unpopulate(val, "After", &b.After)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendServiceFabricClusterProperties.
func (b BackendServiceFabricClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientCertificateId", b.ClientCertificateID)
	populate(objectMap, "clientCertificatethumbprint", b.ClientCertificatethumbprint)
	populate(objectMap, "managementEndpoints", b.ManagementEndpoints)
	populate(objectMap, "maxPartitionResolutionRetries", b.MaxPartitionResolutionRetries)
	populate(objectMap, "serverCertificateThumbprints", b.ServerCertificateThumbprints)
	populate(objectMap, "serverX509Names", b.ServerX509Names)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendServiceFabricClusterProperties.
func (b *BackendServiceFabricClusterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientCertificateId":
			err = unpopulate(val, "ClientCertificateID", &b.ClientCertificateID)
			delete(rawMsg, key)
		case "clientCertificatethumbprint":
			err = unpopulate(val, "ClientCertificatethumbprint", &b.ClientCertificatethumbprint)
			delete(rawMsg, key)
		case "managementEndpoints":
			err = unpopulate(val, "ManagementEndpoints", &b.ManagementEndpoints)
			delete(rawMsg, key)
		case "maxPartitionResolutionRetries":
			err = unpopulate(val, "MaxPartitionResolutionRetries", &b.MaxPartitionResolutionRetries)
			delete(rawMsg, key)
		case "serverCertificateThumbprints":
			err = unpopulate(val, "ServerCertificateThumbprints", &b.ServerCertificateThumbprints)
			delete(rawMsg, key)
		case "serverX509Names":
			err = unpopulate(val, "ServerX509Names", &b.ServerX509Names)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendTLSProperties.
func (b BackendTLSProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "validateCertificateChain", b.ValidateCertificateChain)
	populate(objectMap, "validateCertificateName", b.ValidateCertificateName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendTLSProperties.
func (b *BackendTLSProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "validateCertificateChain":
			err = unpopulate(val, "ValidateCertificateChain", &b.ValidateCertificateChain)
			delete(rawMsg, key)
		case "validateCertificateName":
			err = unpopulate(val, "ValidateCertificateName", &b.ValidateCertificateName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendUpdateParameterProperties.
func (b BackendUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "credentials", b.Credentials)
	populate(objectMap, "description", b.Description)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "protocol", b.Protocol)
	populate(objectMap, "proxy", b.Proxy)
	populate(objectMap, "resourceId", b.ResourceID)
	populate(objectMap, "tls", b.TLS)
	populate(objectMap, "title", b.Title)
	populate(objectMap, "url", b.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendUpdateParameterProperties.
func (b *BackendUpdateParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentials":
			err = unpopulate(val, "Credentials", &b.Credentials)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &b.Description)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &b.Protocol)
			delete(rawMsg, key)
		case "proxy":
			err = unpopulate(val, "Proxy", &b.Proxy)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &b.ResourceID)
			delete(rawMsg, key)
		case "tls":
			err = unpopulate(val, "TLS", &b.TLS)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &b.Title)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &b.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendUpdateParameters.
func (b BackendUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", b.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendUpdateParameters.
func (b *BackendUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BodyDiagnosticSettings.
func (b BodyDiagnosticSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bytes", b.Bytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BodyDiagnosticSettings.
func (b *BodyDiagnosticSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bytes":
			err = unpopulate(val, "Bytes", &b.Bytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheCollection.
func (c CacheCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", c.Count)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheCollection.
func (c *CacheCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &c.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheContract.
func (c CacheContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheContract.
func (c *CacheContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheContractProperties.
func (c CacheContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", c.ConnectionString)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "resourceId", c.ResourceID)
	populate(objectMap, "useFromLocation", c.UseFromLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheContractProperties.
func (c *CacheContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &c.ConnectionString)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		case "useFromLocation":
			err = unpopulate(val, "UseFromLocation", &c.UseFromLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheUpdateParameters.
func (c CacheUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheUpdateParameters.
func (c *CacheUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheUpdateProperties.
func (c CacheUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", c.ConnectionString)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "resourceId", c.ResourceID)
	populate(objectMap, "useFromLocation", c.UseFromLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheUpdateProperties.
func (c *CacheUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &c.ConnectionString)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		case "useFromLocation":
			err = unpopulate(val, "UseFromLocation", &c.UseFromLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateCollection.
func (c CertificateCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", c.Count)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateCollection.
func (c *CertificateCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &c.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateConfiguration.
func (c CertificateConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificate", c.Certificate)
	populate(objectMap, "certificatePassword", c.CertificatePassword)
	populate(objectMap, "encodedCertificate", c.EncodedCertificate)
	populate(objectMap, "storeName", c.StoreName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateConfiguration.
func (c *CertificateConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificate":
			err = unpopulate(val, "Certificate", &c.Certificate)
			delete(rawMsg, key)
		case "certificatePassword":
			err = unpopulate(val, "CertificatePassword", &c.CertificatePassword)
			delete(rawMsg, key)
		case "encodedCertificate":
			err = unpopulate(val, "EncodedCertificate", &c.EncodedCertificate)
			delete(rawMsg, key)
		case "storeName":
			err = unpopulate(val, "StoreName", &c.StoreName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateContract.
func (c CertificateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateContract.
func (c *CertificateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateContractProperties.
func (c CertificateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expirationDate", c.ExpirationDate)
	populate(objectMap, "keyVault", c.KeyVault)
	populate(objectMap, "subject", c.Subject)
	populate(objectMap, "thumbprint", c.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateContractProperties.
func (c *CertificateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &c.ExpirationDate)
			delete(rawMsg, key)
		case "keyVault":
			err = unpopulate(val, "KeyVault", &c.KeyVault)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &c.Subject)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateCreateOrUpdateParameters.
func (c CertificateCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateCreateOrUpdateParameters.
func (c *CertificateCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateCreateOrUpdateProperties.
func (c CertificateCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", c.Data)
	populate(objectMap, "keyVault", c.KeyVault)
	populate(objectMap, "password", c.Password)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateCreateOrUpdateProperties.
func (c *CertificateCreateOrUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &c.Data)
			delete(rawMsg, key)
		case "keyVault":
			err = unpopulate(val, "KeyVault", &c.KeyVault)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &c.Password)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateInformation.
func (c CertificateInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expiry", c.Expiry)
	populate(objectMap, "subject", c.Subject)
	populate(objectMap, "thumbprint", c.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateInformation.
func (c *CertificateInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiry":
			err = unpopulateDateTimeRFC3339(val, "Expiry", &c.Expiry)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &c.Subject)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientSecretContract.
func (c ClientSecretContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientSecret", c.ClientSecret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientSecretContract.
func (c *ClientSecretContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &c.ClientSecret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityCheckRequest.
func (c ConnectivityCheckRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destination", c.Destination)
	populate(objectMap, "preferredIPVersion", c.PreferredIPVersion)
	populate(objectMap, "protocol", c.Protocol)
	populate(objectMap, "protocolConfiguration", c.ProtocolConfiguration)
	populate(objectMap, "source", c.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityCheckRequest.
func (c *ConnectivityCheckRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destination":
			err = unpopulate(val, "Destination", &c.Destination)
			delete(rawMsg, key)
		case "preferredIPVersion":
			err = unpopulate(val, "PreferredIPVersion", &c.PreferredIPVersion)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &c.Protocol)
			delete(rawMsg, key)
		case "protocolConfiguration":
			err = unpopulate(val, "ProtocolConfiguration", &c.ProtocolConfiguration)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &c.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityCheckRequestDestination.
func (c ConnectivityCheckRequestDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", c.Address)
	populate(objectMap, "port", c.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityCheckRequestDestination.
func (c *ConnectivityCheckRequestDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &c.Address)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityCheckRequestProtocolConfiguration.
func (c ConnectivityCheckRequestProtocolConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "HTTPConfiguration", c.HTTPConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityCheckRequestProtocolConfiguration.
func (c *ConnectivityCheckRequestProtocolConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "HTTPConfiguration":
			err = unpopulate(val, "HTTPConfiguration", &c.HTTPConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration.
func (c ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "headers", c.Headers)
	populate(objectMap, "method", c.Method)
	populate(objectMap, "validStatusCodes", c.ValidStatusCodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration.
func (c *ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "headers":
			err = unpopulate(val, "Headers", &c.Headers)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &c.Method)
			delete(rawMsg, key)
		case "validStatusCodes":
			err = unpopulate(val, "ValidStatusCodes", &c.ValidStatusCodes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityCheckRequestSource.
func (c ConnectivityCheckRequestSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instance", c.Instance)
	populate(objectMap, "region", c.Region)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityCheckRequestSource.
func (c *ConnectivityCheckRequestSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instance":
			err = unpopulate(val, "Instance", &c.Instance)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &c.Region)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityCheckResponse.
func (c ConnectivityCheckResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "avgLatencyInMs", c.AvgLatencyInMs)
	populate(objectMap, "connectionStatus", c.ConnectionStatus)
	populate(objectMap, "hops", c.Hops)
	populate(objectMap, "maxLatencyInMs", c.MaxLatencyInMs)
	populate(objectMap, "minLatencyInMs", c.MinLatencyInMs)
	populate(objectMap, "probesFailed", c.ProbesFailed)
	populate(objectMap, "probesSent", c.ProbesSent)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityCheckResponse.
func (c *ConnectivityCheckResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "avgLatencyInMs":
			err = unpopulate(val, "AvgLatencyInMs", &c.AvgLatencyInMs)
			delete(rawMsg, key)
		case "connectionStatus":
			err = unpopulate(val, "ConnectionStatus", &c.ConnectionStatus)
			delete(rawMsg, key)
		case "hops":
			err = unpopulate(val, "Hops", &c.Hops)
			delete(rawMsg, key)
		case "maxLatencyInMs":
			err = unpopulate(val, "MaxLatencyInMs", &c.MaxLatencyInMs)
			delete(rawMsg, key)
		case "minLatencyInMs":
			err = unpopulate(val, "MinLatencyInMs", &c.MinLatencyInMs)
			delete(rawMsg, key)
		case "probesFailed":
			err = unpopulate(val, "ProbesFailed", &c.ProbesFailed)
			delete(rawMsg, key)
		case "probesSent":
			err = unpopulate(val, "ProbesSent", &c.ProbesSent)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityHop.
func (c ConnectivityHop) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", c.Address)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "issues", c.Issues)
	populate(objectMap, "nextHopIds", c.NextHopIDs)
	populate(objectMap, "resourceId", c.ResourceID)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityHop.
func (c *ConnectivityHop) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &c.Address)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "issues":
			err = unpopulate(val, "Issues", &c.Issues)
			delete(rawMsg, key)
		case "nextHopIds":
			err = unpopulate(val, "NextHopIDs", &c.NextHopIDs)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityIssue.
func (c ConnectivityIssue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "context", c.Context)
	populate(objectMap, "origin", c.Origin)
	populate(objectMap, "severity", c.Severity)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityIssue.
func (c *ConnectivityIssue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "context":
			err = unpopulate(val, "Context", &c.Context)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &c.Origin)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &c.Severity)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityStatusContract.
func (c ConnectivityStatusContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "isOptional", c.IsOptional)
	populateDateTimeRFC3339(objectMap, "lastStatusChange", c.LastStatusChange)
	populateDateTimeRFC3339(objectMap, "lastUpdated", c.LastUpdated)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "resourceType", c.ResourceType)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityStatusContract.
func (c *ConnectivityStatusContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "isOptional":
			err = unpopulate(val, "IsOptional", &c.IsOptional)
			delete(rawMsg, key)
		case "lastStatusChange":
			err = unpopulateDateTimeRFC3339(val, "LastStatusChange", &c.LastStatusChange)
			delete(rawMsg, key)
		case "lastUpdated":
			err = unpopulateDateTimeRFC3339(val, "LastUpdated", &c.LastUpdated)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &c.ResourceType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentItemCollection.
func (c ContentItemCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentItemCollection.
func (c *ContentItemCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentItemContract.
func (c ContentItemContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentItemContract.
func (c *ContentItemContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentTypeCollection.
func (c ContentTypeCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentTypeCollection.
func (c *ContentTypeCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentTypeContract.
func (c ContentTypeContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentTypeContract.
func (c *ContentTypeContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentTypeContractProperties.
func (c ContentTypeContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populateAny(objectMap, "schema", c.Schema)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentTypeContractProperties.
func (c *ContentTypeContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &c.Schema)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataMasking.
func (d DataMasking) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "headers", d.Headers)
	populate(objectMap, "queryParams", d.QueryParams)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataMasking.
func (d *DataMasking) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "headers":
			err = unpopulate(val, "Headers", &d.Headers)
			delete(rawMsg, key)
		case "queryParams":
			err = unpopulate(val, "QueryParams", &d.QueryParams)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataMaskingEntity.
func (d DataMaskingEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mode", d.Mode)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataMaskingEntity.
func (d *DataMaskingEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &d.Mode)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedServiceContract.
func (d DeletedServiceContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedServiceContract.
func (d *DeletedServiceContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedServiceContractProperties.
func (d DeletedServiceContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "deletionDate", d.DeletionDate)
	populateDateTimeRFC3339(objectMap, "scheduledPurgeDate", d.ScheduledPurgeDate)
	populate(objectMap, "serviceId", d.ServiceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedServiceContractProperties.
func (d *DeletedServiceContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deletionDate":
			err = unpopulateDateTimeRFC3339(val, "DeletionDate", &d.DeletionDate)
			delete(rawMsg, key)
		case "scheduledPurgeDate":
			err = unpopulateDateTimeRFC3339(val, "ScheduledPurgeDate", &d.ScheduledPurgeDate)
			delete(rawMsg, key)
		case "serviceId":
			err = unpopulate(val, "ServiceID", &d.ServiceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedServicesCollection.
func (d DeletedServicesCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedServicesCollection.
func (d *DeletedServicesCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeployConfigurationParameterProperties.
func (d DeployConfigurationParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "branch", d.Branch)
	populate(objectMap, "force", d.Force)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeployConfigurationParameterProperties.
func (d *DeployConfigurationParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "branch":
			err = unpopulate(val, "Branch", &d.Branch)
			delete(rawMsg, key)
		case "force":
			err = unpopulate(val, "Force", &d.Force)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeployConfigurationParameters.
func (d DeployConfigurationParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeployConfigurationParameters.
func (d *DeployConfigurationParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticCollection.
func (d DiagnosticCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", d.Count)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticCollection.
func (d *DiagnosticCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &d.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticContract.
func (d DiagnosticContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticContract.
func (d *DiagnosticContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticContractProperties.
func (d DiagnosticContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alwaysLog", d.AlwaysLog)
	populate(objectMap, "backend", d.Backend)
	populate(objectMap, "frontend", d.Frontend)
	populate(objectMap, "httpCorrelationProtocol", d.HTTPCorrelationProtocol)
	populate(objectMap, "logClientIp", d.LogClientIP)
	populate(objectMap, "loggerId", d.LoggerID)
	populate(objectMap, "metrics", d.Metrics)
	populate(objectMap, "operationNameFormat", d.OperationNameFormat)
	populate(objectMap, "sampling", d.Sampling)
	populate(objectMap, "verbosity", d.Verbosity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticContractProperties.
func (d *DiagnosticContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alwaysLog":
			err = unpopulate(val, "AlwaysLog", &d.AlwaysLog)
			delete(rawMsg, key)
		case "backend":
			err = unpopulate(val, "Backend", &d.Backend)
			delete(rawMsg, key)
		case "frontend":
			err = unpopulate(val, "Frontend", &d.Frontend)
			delete(rawMsg, key)
		case "httpCorrelationProtocol":
			err = unpopulate(val, "HTTPCorrelationProtocol", &d.HTTPCorrelationProtocol)
			delete(rawMsg, key)
		case "logClientIp":
			err = unpopulate(val, "LogClientIP", &d.LogClientIP)
			delete(rawMsg, key)
		case "loggerId":
			err = unpopulate(val, "LoggerID", &d.LoggerID)
			delete(rawMsg, key)
		case "metrics":
			err = unpopulate(val, "Metrics", &d.Metrics)
			delete(rawMsg, key)
		case "operationNameFormat":
			err = unpopulate(val, "OperationNameFormat", &d.OperationNameFormat)
			delete(rawMsg, key)
		case "sampling":
			err = unpopulate(val, "Sampling", &d.Sampling)
			delete(rawMsg, key)
		case "verbosity":
			err = unpopulate(val, "Verbosity", &d.Verbosity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DocumentationCollection.
func (d DocumentationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DocumentationCollection.
func (d *DocumentationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DocumentationContract.
func (d DocumentationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DocumentationContract.
func (d *DocumentationContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DocumentationContractProperties.
func (d DocumentationContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", d.Content)
	populate(objectMap, "title", d.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DocumentationContractProperties.
func (d *DocumentationContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &d.Content)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &d.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DocumentationUpdateContract.
func (d DocumentationUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DocumentationUpdateContract.
func (d *DocumentationUpdateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailTemplateCollection.
func (e EmailTemplateCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", e.Count)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailTemplateCollection.
func (e *EmailTemplateCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &e.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailTemplateContract.
func (e EmailTemplateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailTemplateContract.
func (e *EmailTemplateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailTemplateContractProperties.
func (e EmailTemplateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "body", e.Body)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "isDefault", e.IsDefault)
	populate(objectMap, "parameters", e.Parameters)
	populate(objectMap, "subject", e.Subject)
	populate(objectMap, "title", e.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailTemplateContractProperties.
func (e *EmailTemplateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "body":
			err = unpopulate(val, "Body", &e.Body)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &e.IsDefault)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &e.Parameters)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &e.Subject)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &e.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailTemplateParametersContractProperties.
func (e EmailTemplateParametersContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "title", e.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailTemplateParametersContractProperties.
func (e *EmailTemplateParametersContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &e.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailTemplateUpdateParameterProperties.
func (e EmailTemplateUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "body", e.Body)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "parameters", e.Parameters)
	populate(objectMap, "subject", e.Subject)
	populate(objectMap, "title", e.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailTemplateUpdateParameterProperties.
func (e *EmailTemplateUpdateParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "body":
			err = unpopulate(val, "Body", &e.Body)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &e.Parameters)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &e.Subject)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &e.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailTemplateUpdateParameters.
func (e EmailTemplateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailTemplateUpdateParameters.
func (e *EmailTemplateUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointDependency.
func (e EndpointDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainName", e.DomainName)
	populate(objectMap, "endpointDetails", e.EndpointDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointDependency.
func (e *EndpointDependency) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainName":
			err = unpopulate(val, "DomainName", &e.DomainName)
			delete(rawMsg, key)
		case "endpointDetails":
			err = unpopulate(val, "EndpointDetails", &e.EndpointDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointDetail.
func (e EndpointDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "port", e.Port)
	populate(objectMap, "region", e.Region)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointDetail.
func (e *EndpointDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "port":
			err = unpopulate(val, "Port", &e.Port)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &e.Region)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorFieldContract.
func (e ErrorFieldContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorFieldContract.
func (e *ErrorFieldContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponseBody.
func (e ErrorResponseBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponseBody.
func (e *ErrorResponseBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayCertificateAuthorityCollection.
func (g GatewayCertificateAuthorityCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayCertificateAuthorityCollection.
func (g *GatewayCertificateAuthorityCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayCertificateAuthorityContract.
func (g GatewayCertificateAuthorityContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayCertificateAuthorityContract.
func (g *GatewayCertificateAuthorityContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayCertificateAuthorityContractProperties.
func (g GatewayCertificateAuthorityContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isTrusted", g.IsTrusted)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayCertificateAuthorityContractProperties.
func (g *GatewayCertificateAuthorityContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isTrusted":
			err = unpopulate(val, "IsTrusted", &g.IsTrusted)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayCollection.
func (g GatewayCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", g.Count)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayCollection.
func (g *GatewayCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &g.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayContract.
func (g GatewayContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayContract.
func (g *GatewayContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayContractProperties.
func (g GatewayContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "locationData", g.LocationData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayContractProperties.
func (g *GatewayContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "locationData":
			err = unpopulate(val, "LocationData", &g.LocationData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayHostnameConfigurationCollection.
func (g GatewayHostnameConfigurationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayHostnameConfigurationCollection.
func (g *GatewayHostnameConfigurationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayHostnameConfigurationContract.
func (g GatewayHostnameConfigurationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayHostnameConfigurationContract.
func (g *GatewayHostnameConfigurationContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayHostnameConfigurationContractProperties.
func (g GatewayHostnameConfigurationContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateId", g.CertificateID)
	populate(objectMap, "http2Enabled", g.HTTP2Enabled)
	populate(objectMap, "hostname", g.Hostname)
	populate(objectMap, "negotiateClientCertificate", g.NegotiateClientCertificate)
	populate(objectMap, "tls10Enabled", g.Tls10Enabled)
	populate(objectMap, "tls11Enabled", g.Tls11Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayHostnameConfigurationContractProperties.
func (g *GatewayHostnameConfigurationContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateId":
			err = unpopulate(val, "CertificateID", &g.CertificateID)
			delete(rawMsg, key)
		case "http2Enabled":
			err = unpopulate(val, "HTTP2Enabled", &g.HTTP2Enabled)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &g.Hostname)
			delete(rawMsg, key)
		case "negotiateClientCertificate":
			err = unpopulate(val, "NegotiateClientCertificate", &g.NegotiateClientCertificate)
			delete(rawMsg, key)
		case "tls10Enabled":
			err = unpopulate(val, "Tls10Enabled", &g.Tls10Enabled)
			delete(rawMsg, key)
		case "tls11Enabled":
			err = unpopulate(val, "Tls11Enabled", &g.Tls11Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayKeyRegenerationRequestContract.
func (g GatewayKeyRegenerationRequestContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyType", g.KeyType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayKeyRegenerationRequestContract.
func (g *GatewayKeyRegenerationRequestContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyType":
			err = unpopulate(val, "KeyType", &g.KeyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayKeysContract.
func (g GatewayKeysContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primary", g.Primary)
	populate(objectMap, "secondary", g.Secondary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayKeysContract.
func (g *GatewayKeysContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primary":
			err = unpopulate(val, "Primary", &g.Primary)
			delete(rawMsg, key)
		case "secondary":
			err = unpopulate(val, "Secondary", &g.Secondary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayTokenContract.
func (g GatewayTokenContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayTokenContract.
func (g *GatewayTokenContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayTokenRequestContract.
func (g GatewayTokenRequestContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expiry", g.Expiry)
	populate(objectMap, "keyType", g.KeyType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayTokenRequestContract.
func (g *GatewayTokenRequestContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiry":
			err = unpopulateDateTimeRFC3339(val, "Expiry", &g.Expiry)
			delete(rawMsg, key)
		case "keyType":
			err = unpopulate(val, "KeyType", &g.KeyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateSsoURLResult.
func (g GenerateSsoURLResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateSsoURLResult.
func (g *GenerateSsoURLResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalSchemaCollection.
func (g GlobalSchemaCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", g.Count)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalSchemaCollection.
func (g *GlobalSchemaCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &g.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalSchemaContract.
func (g GlobalSchemaContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalSchemaContract.
func (g *GlobalSchemaContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalSchemaContractProperties.
func (g GlobalSchemaContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", g.Description)
	populateAny(objectMap, "document", g.Document)
	populate(objectMap, "schemaType", g.SchemaType)
	populateAny(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalSchemaContractProperties.
func (g *GlobalSchemaContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "document":
			err = unpopulate(val, "Document", &g.Document)
			delete(rawMsg, key)
		case "schemaType":
			err = unpopulate(val, "SchemaType", &g.SchemaType)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupCollection.
func (g GroupCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", g.Count)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupCollection.
func (g *GroupCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &g.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupContract.
func (g GroupContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupContract.
func (g *GroupContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupContractProperties.
func (g GroupContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "builtIn", g.BuiltIn)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "displayName", g.DisplayName)
	populate(objectMap, "externalId", g.ExternalID)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupContractProperties.
func (g *GroupContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "builtIn":
			err = unpopulate(val, "BuiltIn", &g.BuiltIn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &g.DisplayName)
			delete(rawMsg, key)
		case "externalId":
			err = unpopulate(val, "ExternalID", &g.ExternalID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupCreateParameters.
func (g GroupCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", g.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupCreateParameters.
func (g *GroupCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupCreateParametersProperties.
func (g GroupCreateParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "displayName", g.DisplayName)
	populate(objectMap, "externalId", g.ExternalID)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupCreateParametersProperties.
func (g *GroupCreateParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &g.DisplayName)
			delete(rawMsg, key)
		case "externalId":
			err = unpopulate(val, "ExternalID", &g.ExternalID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupUpdateParameters.
func (g GroupUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", g.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupUpdateParameters.
func (g *GroupUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupUpdateParametersProperties.
func (g GroupUpdateParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "displayName", g.DisplayName)
	populate(objectMap, "externalId", g.ExternalID)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupUpdateParametersProperties.
func (g *GroupUpdateParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &g.DisplayName)
			delete(rawMsg, key)
		case "externalId":
			err = unpopulate(val, "ExternalID", &g.ExternalID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPHeader.
func (h HTTPHeader) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPHeader.
func (h *HTTPHeader) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPMessageDiagnostic.
func (h HTTPMessageDiagnostic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "body", h.Body)
	populate(objectMap, "dataMasking", h.DataMasking)
	populate(objectMap, "headers", h.Headers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPMessageDiagnostic.
func (h *HTTPMessageDiagnostic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "body":
			err = unpopulate(val, "Body", &h.Body)
			delete(rawMsg, key)
		case "dataMasking":
			err = unpopulate(val, "DataMasking", &h.DataMasking)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &h.Headers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostnameConfiguration.
func (h HostnameConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificate", h.Certificate)
	populate(objectMap, "certificatePassword", h.CertificatePassword)
	populate(objectMap, "certificateSource", h.CertificateSource)
	populate(objectMap, "certificateStatus", h.CertificateStatus)
	populate(objectMap, "defaultSslBinding", h.DefaultSSLBinding)
	populate(objectMap, "encodedCertificate", h.EncodedCertificate)
	populate(objectMap, "hostName", h.HostName)
	populate(objectMap, "identityClientId", h.IdentityClientID)
	populate(objectMap, "keyVaultId", h.KeyVaultID)
	populate(objectMap, "negotiateClientCertificate", h.NegotiateClientCertificate)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostnameConfiguration.
func (h *HostnameConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificate":
			err = unpopulate(val, "Certificate", &h.Certificate)
			delete(rawMsg, key)
		case "certificatePassword":
			err = unpopulate(val, "CertificatePassword", &h.CertificatePassword)
			delete(rawMsg, key)
		case "certificateSource":
			err = unpopulate(val, "CertificateSource", &h.CertificateSource)
			delete(rawMsg, key)
		case "certificateStatus":
			err = unpopulate(val, "CertificateStatus", &h.CertificateStatus)
			delete(rawMsg, key)
		case "defaultSslBinding":
			err = unpopulate(val, "DefaultSSLBinding", &h.DefaultSSLBinding)
			delete(rawMsg, key)
		case "encodedCertificate":
			err = unpopulate(val, "EncodedCertificate", &h.EncodedCertificate)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &h.HostName)
			delete(rawMsg, key)
		case "identityClientId":
			err = unpopulate(val, "IdentityClientID", &h.IdentityClientID)
			delete(rawMsg, key)
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &h.KeyVaultID)
			delete(rawMsg, key)
		case "negotiateClientCertificate":
			err = unpopulate(val, "NegotiateClientCertificate", &h.NegotiateClientCertificate)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderBaseParameters.
func (i IdentityProviderBaseParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedTenants", i.AllowedTenants)
	populate(objectMap, "authority", i.Authority)
	populate(objectMap, "clientLibrary", i.ClientLibrary)
	populate(objectMap, "passwordResetPolicyName", i.PasswordResetPolicyName)
	populate(objectMap, "profileEditingPolicyName", i.ProfileEditingPolicyName)
	populate(objectMap, "signinPolicyName", i.SigninPolicyName)
	populate(objectMap, "signinTenant", i.SigninTenant)
	populate(objectMap, "signupPolicyName", i.SignupPolicyName)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProviderBaseParameters.
func (i *IdentityProviderBaseParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedTenants":
			err = unpopulate(val, "AllowedTenants", &i.AllowedTenants)
			delete(rawMsg, key)
		case "authority":
			err = unpopulate(val, "Authority", &i.Authority)
			delete(rawMsg, key)
		case "clientLibrary":
			err = unpopulate(val, "ClientLibrary", &i.ClientLibrary)
			delete(rawMsg, key)
		case "passwordResetPolicyName":
			err = unpopulate(val, "PasswordResetPolicyName", &i.PasswordResetPolicyName)
			delete(rawMsg, key)
		case "profileEditingPolicyName":
			err = unpopulate(val, "ProfileEditingPolicyName", &i.ProfileEditingPolicyName)
			delete(rawMsg, key)
		case "signinPolicyName":
			err = unpopulate(val, "SigninPolicyName", &i.SigninPolicyName)
			delete(rawMsg, key)
		case "signinTenant":
			err = unpopulate(val, "SigninTenant", &i.SigninTenant)
			delete(rawMsg, key)
		case "signupPolicyName":
			err = unpopulate(val, "SignupPolicyName", &i.SignupPolicyName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderContract.
func (i IdentityProviderContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProviderContract.
func (i *IdentityProviderContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderContractProperties.
func (i IdentityProviderContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedTenants", i.AllowedTenants)
	populate(objectMap, "authority", i.Authority)
	populate(objectMap, "clientId", i.ClientID)
	populate(objectMap, "clientLibrary", i.ClientLibrary)
	populate(objectMap, "clientSecret", i.ClientSecret)
	populate(objectMap, "passwordResetPolicyName", i.PasswordResetPolicyName)
	populate(objectMap, "profileEditingPolicyName", i.ProfileEditingPolicyName)
	populate(objectMap, "signinPolicyName", i.SigninPolicyName)
	populate(objectMap, "signinTenant", i.SigninTenant)
	populate(objectMap, "signupPolicyName", i.SignupPolicyName)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProviderContractProperties.
func (i *IdentityProviderContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedTenants":
			err = unpopulate(val, "AllowedTenants", &i.AllowedTenants)
			delete(rawMsg, key)
		case "authority":
			err = unpopulate(val, "Authority", &i.Authority)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &i.ClientID)
			delete(rawMsg, key)
		case "clientLibrary":
			err = unpopulate(val, "ClientLibrary", &i.ClientLibrary)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &i.ClientSecret)
			delete(rawMsg, key)
		case "passwordResetPolicyName":
			err = unpopulate(val, "PasswordResetPolicyName", &i.PasswordResetPolicyName)
			delete(rawMsg, key)
		case "profileEditingPolicyName":
			err = unpopulate(val, "ProfileEditingPolicyName", &i.ProfileEditingPolicyName)
			delete(rawMsg, key)
		case "signinPolicyName":
			err = unpopulate(val, "SigninPolicyName", &i.SigninPolicyName)
			delete(rawMsg, key)
		case "signinTenant":
			err = unpopulate(val, "SigninTenant", &i.SigninTenant)
			delete(rawMsg, key)
		case "signupPolicyName":
			err = unpopulate(val, "SignupPolicyName", &i.SignupPolicyName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderCreateContract.
func (i IdentityProviderCreateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProviderCreateContract.
func (i *IdentityProviderCreateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderCreateContractProperties.
func (i IdentityProviderCreateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedTenants", i.AllowedTenants)
	populate(objectMap, "authority", i.Authority)
	populate(objectMap, "clientId", i.ClientID)
	populate(objectMap, "clientLibrary", i.ClientLibrary)
	populate(objectMap, "clientSecret", i.ClientSecret)
	populate(objectMap, "passwordResetPolicyName", i.PasswordResetPolicyName)
	populate(objectMap, "profileEditingPolicyName", i.ProfileEditingPolicyName)
	populate(objectMap, "signinPolicyName", i.SigninPolicyName)
	populate(objectMap, "signinTenant", i.SigninTenant)
	populate(objectMap, "signupPolicyName", i.SignupPolicyName)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProviderCreateContractProperties.
func (i *IdentityProviderCreateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedTenants":
			err = unpopulate(val, "AllowedTenants", &i.AllowedTenants)
			delete(rawMsg, key)
		case "authority":
			err = unpopulate(val, "Authority", &i.Authority)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &i.ClientID)
			delete(rawMsg, key)
		case "clientLibrary":
			err = unpopulate(val, "ClientLibrary", &i.ClientLibrary)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &i.ClientSecret)
			delete(rawMsg, key)
		case "passwordResetPolicyName":
			err = unpopulate(val, "PasswordResetPolicyName", &i.PasswordResetPolicyName)
			delete(rawMsg, key)
		case "profileEditingPolicyName":
			err = unpopulate(val, "ProfileEditingPolicyName", &i.ProfileEditingPolicyName)
			delete(rawMsg, key)
		case "signinPolicyName":
			err = unpopulate(val, "SigninPolicyName", &i.SigninPolicyName)
			delete(rawMsg, key)
		case "signinTenant":
			err = unpopulate(val, "SigninTenant", &i.SigninTenant)
			delete(rawMsg, key)
		case "signupPolicyName":
			err = unpopulate(val, "SignupPolicyName", &i.SignupPolicyName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderList.
func (i IdentityProviderList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", i.Count)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProviderList.
func (i *IdentityProviderList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &i.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderUpdateParameters.
func (i IdentityProviderUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProviderUpdateParameters.
func (i *IdentityProviderUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderUpdateProperties.
func (i IdentityProviderUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedTenants", i.AllowedTenants)
	populate(objectMap, "authority", i.Authority)
	populate(objectMap, "clientId", i.ClientID)
	populate(objectMap, "clientLibrary", i.ClientLibrary)
	populate(objectMap, "clientSecret", i.ClientSecret)
	populate(objectMap, "passwordResetPolicyName", i.PasswordResetPolicyName)
	populate(objectMap, "profileEditingPolicyName", i.ProfileEditingPolicyName)
	populate(objectMap, "signinPolicyName", i.SigninPolicyName)
	populate(objectMap, "signinTenant", i.SigninTenant)
	populate(objectMap, "signupPolicyName", i.SignupPolicyName)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProviderUpdateProperties.
func (i *IdentityProviderUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedTenants":
			err = unpopulate(val, "AllowedTenants", &i.AllowedTenants)
			delete(rawMsg, key)
		case "authority":
			err = unpopulate(val, "Authority", &i.Authority)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &i.ClientID)
			delete(rawMsg, key)
		case "clientLibrary":
			err = unpopulate(val, "ClientLibrary", &i.ClientLibrary)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &i.ClientSecret)
			delete(rawMsg, key)
		case "passwordResetPolicyName":
			err = unpopulate(val, "PasswordResetPolicyName", &i.PasswordResetPolicyName)
			delete(rawMsg, key)
		case "profileEditingPolicyName":
			err = unpopulate(val, "ProfileEditingPolicyName", &i.ProfileEditingPolicyName)
			delete(rawMsg, key)
		case "signinPolicyName":
			err = unpopulate(val, "SigninPolicyName", &i.SigninPolicyName)
			delete(rawMsg, key)
		case "signinTenant":
			err = unpopulate(val, "SigninTenant", &i.SigninTenant)
			delete(rawMsg, key)
		case "signupPolicyName":
			err = unpopulate(val, "SignupPolicyName", &i.SignupPolicyName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueAttachmentCollection.
func (i IssueAttachmentCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", i.Count)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueAttachmentCollection.
func (i *IssueAttachmentCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &i.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueAttachmentContract.
func (i IssueAttachmentContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueAttachmentContract.
func (i *IssueAttachmentContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueAttachmentContractProperties.
func (i IssueAttachmentContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", i.Content)
	populate(objectMap, "contentFormat", i.ContentFormat)
	populate(objectMap, "title", i.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueAttachmentContractProperties.
func (i *IssueAttachmentContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &i.Content)
			delete(rawMsg, key)
		case "contentFormat":
			err = unpopulate(val, "ContentFormat", &i.ContentFormat)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &i.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueCollection.
func (i IssueCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", i.Count)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueCollection.
func (i *IssueCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &i.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueCommentCollection.
func (i IssueCommentCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", i.Count)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueCommentCollection.
func (i *IssueCommentCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &i.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueCommentContract.
func (i IssueCommentContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueCommentContract.
func (i *IssueCommentContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueCommentContractProperties.
func (i IssueCommentContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdDate", i.CreatedDate)
	populate(objectMap, "text", i.Text)
	populate(objectMap, "userId", i.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueCommentContractProperties.
func (i *IssueCommentContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &i.CreatedDate)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &i.Text)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &i.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueContract.
func (i IssueContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueContract.
func (i *IssueContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueContractBaseProperties.
func (i IssueContractBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiId", i.APIID)
	populateDateTimeRFC3339(objectMap, "createdDate", i.CreatedDate)
	populate(objectMap, "state", i.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueContractBaseProperties.
func (i *IssueContractBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &i.APIID)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &i.CreatedDate)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueContractProperties.
func (i IssueContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiId", i.APIID)
	populateDateTimeRFC3339(objectMap, "createdDate", i.CreatedDate)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "state", i.State)
	populate(objectMap, "title", i.Title)
	populate(objectMap, "userId", i.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueContractProperties.
func (i *IssueContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &i.APIID)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &i.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &i.Title)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &i.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueUpdateContract.
func (i IssueUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueUpdateContract.
func (i *IssueUpdateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IssueUpdateContractProperties.
func (i IssueUpdateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiId", i.APIID)
	populateDateTimeRFC3339(objectMap, "createdDate", i.CreatedDate)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "state", i.State)
	populate(objectMap, "title", i.Title)
	populate(objectMap, "userId", i.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IssueUpdateContractProperties.
func (i *IssueUpdateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &i.APIID)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &i.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &i.Title)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &i.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultContractCreateProperties.
func (k KeyVaultContractCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identityClientId", k.IdentityClientID)
	populate(objectMap, "secretIdentifier", k.SecretIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultContractCreateProperties.
func (k *KeyVaultContractCreateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identityClientId":
			err = unpopulate(val, "IdentityClientID", &k.IdentityClientID)
			delete(rawMsg, key)
		case "secretIdentifier":
			err = unpopulate(val, "SecretIdentifier", &k.SecretIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultContractProperties.
func (k KeyVaultContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identityClientId", k.IdentityClientID)
	populate(objectMap, "lastStatus", k.LastStatus)
	populate(objectMap, "secretIdentifier", k.SecretIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultContractProperties.
func (k *KeyVaultContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identityClientId":
			err = unpopulate(val, "IdentityClientID", &k.IdentityClientID)
			delete(rawMsg, key)
		case "lastStatus":
			err = unpopulate(val, "LastStatus", &k.LastStatus)
			delete(rawMsg, key)
		case "secretIdentifier":
			err = unpopulate(val, "SecretIdentifier", &k.SecretIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultLastAccessStatusContractProperties.
func (k KeyVaultLastAccessStatusContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", k.Code)
	populate(objectMap, "message", k.Message)
	populateDateTimeRFC3339(objectMap, "timeStampUtc", k.TimeStampUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultLastAccessStatusContractProperties.
func (k *KeyVaultLastAccessStatusContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &k.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &k.Message)
			delete(rawMsg, key)
		case "timeStampUtc":
			err = unpopulateDateTimeRFC3339(val, "TimeStampUTC", &k.TimeStampUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoggerCollection.
func (l LoggerCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", l.Count)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoggerCollection.
func (l *LoggerCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &l.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoggerContract.
func (l LoggerContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoggerContract.
func (l *LoggerContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoggerContractProperties.
func (l LoggerContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "credentials", l.Credentials)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "isBuffered", l.IsBuffered)
	populate(objectMap, "loggerType", l.LoggerType)
	populate(objectMap, "resourceId", l.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoggerContractProperties.
func (l *LoggerContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentials":
			err = unpopulate(val, "Credentials", &l.Credentials)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "isBuffered":
			err = unpopulate(val, "IsBuffered", &l.IsBuffered)
			delete(rawMsg, key)
		case "loggerType":
			err = unpopulate(val, "LoggerType", &l.LoggerType)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &l.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoggerUpdateContract.
func (l LoggerUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoggerUpdateContract.
func (l *LoggerUpdateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoggerUpdateParameters.
func (l LoggerUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "credentials", l.Credentials)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "isBuffered", l.IsBuffered)
	populate(objectMap, "loggerType", l.LoggerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoggerUpdateParameters.
func (l *LoggerUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentials":
			err = unpopulate(val, "Credentials", &l.Credentials)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "isBuffered":
			err = unpopulate(val, "IsBuffered", &l.IsBuffered)
			delete(rawMsg, key)
		case "loggerType":
			err = unpopulate(val, "LoggerType", &l.LoggerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueCollection.
func (n NamedValueCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", n.Count)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedValueCollection.
func (n *NamedValueCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &n.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueContract.
func (n NamedValueContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedValueContract.
func (n *NamedValueContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueContractProperties.
func (n NamedValueContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", n.DisplayName)
	populate(objectMap, "keyVault", n.KeyVault)
	populate(objectMap, "secret", n.Secret)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedValueContractProperties.
func (n *NamedValueContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &n.DisplayName)
			delete(rawMsg, key)
		case "keyVault":
			err = unpopulate(val, "KeyVault", &n.KeyVault)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &n.Secret)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueCreateContract.
func (n NamedValueCreateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedValueCreateContract.
func (n *NamedValueCreateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueCreateContractProperties.
func (n NamedValueCreateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", n.DisplayName)
	populate(objectMap, "keyVault", n.KeyVault)
	populate(objectMap, "secret", n.Secret)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedValueCreateContractProperties.
func (n *NamedValueCreateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &n.DisplayName)
			delete(rawMsg, key)
		case "keyVault":
			err = unpopulate(val, "KeyVault", &n.KeyVault)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &n.Secret)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueEntityBaseParameters.
func (n NamedValueEntityBaseParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secret", n.Secret)
	populate(objectMap, "tags", n.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedValueEntityBaseParameters.
func (n *NamedValueEntityBaseParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secret":
			err = unpopulate(val, "Secret", &n.Secret)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueSecretContract.
func (n NamedValueSecretContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedValueSecretContract.
func (n *NamedValueSecretContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueUpdateParameterProperties.
func (n NamedValueUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", n.DisplayName)
	populate(objectMap, "keyVault", n.KeyVault)
	populate(objectMap, "secret", n.Secret)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedValueUpdateParameterProperties.
func (n *NamedValueUpdateParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &n.DisplayName)
			delete(rawMsg, key)
		case "keyVault":
			err = unpopulate(val, "KeyVault", &n.KeyVault)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &n.Secret)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamedValueUpdateParameters.
func (n NamedValueUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", n.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedValueUpdateParameters.
func (n *NamedValueUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkStatusContract.
func (n NetworkStatusContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectivityStatus", n.ConnectivityStatus)
	populate(objectMap, "dnsServers", n.DNSServers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkStatusContract.
func (n *NetworkStatusContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectivityStatus":
			err = unpopulate(val, "ConnectivityStatus", &n.ConnectivityStatus)
			delete(rawMsg, key)
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &n.DNSServers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkStatusContractByLocation.
func (n NetworkStatusContractByLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "networkStatus", n.NetworkStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkStatusContractByLocation.
func (n *NetworkStatusContractByLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "networkStatus":
			err = unpopulate(val, "NetworkStatus", &n.NetworkStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationCollection.
func (n NotificationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", n.Count)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationCollection.
func (n *NotificationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &n.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationContract.
func (n NotificationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationContract.
func (n *NotificationContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationContractProperties.
func (n NotificationContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", n.Description)
	populate(objectMap, "recipients", n.Recipients)
	populate(objectMap, "title", n.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationContractProperties.
func (n *NotificationContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &n.Description)
			delete(rawMsg, key)
		case "recipients":
			err = unpopulate(val, "Recipients", &n.Recipients)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &n.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OAuth2AuthenticationSettingsContract.
func (o OAuth2AuthenticationSettingsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationServerId", o.AuthorizationServerID)
	populate(objectMap, "scope", o.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OAuth2AuthenticationSettingsContract.
func (o *OAuth2AuthenticationSettingsContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationServerId":
			err = unpopulate(val, "AuthorizationServerID", &o.AuthorizationServerID)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &o.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenIDAuthenticationSettingsContract.
func (o OpenIDAuthenticationSettingsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bearerTokenSendingMethods", o.BearerTokenSendingMethods)
	populate(objectMap, "openidProviderId", o.OpenidProviderID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenIDAuthenticationSettingsContract.
func (o *OpenIDAuthenticationSettingsContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bearerTokenSendingMethods":
			err = unpopulate(val, "BearerTokenSendingMethods", &o.BearerTokenSendingMethods)
			delete(rawMsg, key)
		case "openidProviderId":
			err = unpopulate(val, "OpenidProviderID", &o.OpenidProviderID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenIDConnectProviderCollection.
func (o OpenIDConnectProviderCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", o.Count)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenIDConnectProviderCollection.
func (o *OpenIDConnectProviderCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &o.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenidConnectProviderContract.
func (o OpenidConnectProviderContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenidConnectProviderContract.
func (o *OpenidConnectProviderContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenidConnectProviderContractProperties.
func (o OpenidConnectProviderContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", o.ClientID)
	populate(objectMap, "clientSecret", o.ClientSecret)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "displayName", o.DisplayName)
	populate(objectMap, "metadataEndpoint", o.MetadataEndpoint)
	populate(objectMap, "useInApiDocumentation", o.UseInAPIDocumentation)
	populate(objectMap, "useInTestConsole", o.UseInTestConsole)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenidConnectProviderContractProperties.
func (o *OpenidConnectProviderContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &o.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &o.ClientSecret)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &o.DisplayName)
			delete(rawMsg, key)
		case "metadataEndpoint":
			err = unpopulate(val, "MetadataEndpoint", &o.MetadataEndpoint)
			delete(rawMsg, key)
		case "useInApiDocumentation":
			err = unpopulate(val, "UseInAPIDocumentation", &o.UseInAPIDocumentation)
			delete(rawMsg, key)
		case "useInTestConsole":
			err = unpopulate(val, "UseInTestConsole", &o.UseInTestConsole)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenidConnectProviderUpdateContract.
func (o OpenidConnectProviderUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenidConnectProviderUpdateContract.
func (o *OpenidConnectProviderUpdateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenidConnectProviderUpdateContractProperties.
func (o OpenidConnectProviderUpdateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", o.ClientID)
	populate(objectMap, "clientSecret", o.ClientSecret)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "displayName", o.DisplayName)
	populate(objectMap, "metadataEndpoint", o.MetadataEndpoint)
	populate(objectMap, "useInApiDocumentation", o.UseInAPIDocumentation)
	populate(objectMap, "useInTestConsole", o.UseInTestConsole)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenidConnectProviderUpdateContractProperties.
func (o *OpenidConnectProviderUpdateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &o.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &o.ClientSecret)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &o.DisplayName)
			delete(rawMsg, key)
		case "metadataEndpoint":
			err = unpopulate(val, "MetadataEndpoint", &o.MetadataEndpoint)
			delete(rawMsg, key)
		case "useInApiDocumentation":
			err = unpopulate(val, "UseInAPIDocumentation", &o.UseInAPIDocumentation)
			delete(rawMsg, key)
		case "useInTestConsole":
			err = unpopulate(val, "UseInTestConsole", &o.UseInTestConsole)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populateAny(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationCollection.
func (o OperationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", o.Count)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationCollection.
func (o *OperationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &o.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationContract.
func (o OperationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationContract.
func (o *OperationContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationContractProperties.
func (o OperationContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "displayName", o.DisplayName)
	populate(objectMap, "method", o.Method)
	populate(objectMap, "policies", o.Policies)
	populate(objectMap, "request", o.Request)
	populate(objectMap, "responses", o.Responses)
	populate(objectMap, "templateParameters", o.TemplateParameters)
	populate(objectMap, "urlTemplate", o.URLTemplate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationContractProperties.
func (o *OperationContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &o.DisplayName)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &o.Method)
			delete(rawMsg, key)
		case "policies":
			err = unpopulate(val, "Policies", &o.Policies)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &o.Request)
			delete(rawMsg, key)
		case "responses":
			err = unpopulate(val, "Responses", &o.Responses)
			delete(rawMsg, key)
		case "templateParameters":
			err = unpopulate(val, "TemplateParameters", &o.TemplateParameters)
			delete(rawMsg, key)
		case "urlTemplate":
			err = unpopulate(val, "URLTemplate", &o.URLTemplate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationEntityBaseContract.
func (o OperationEntityBaseContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "policies", o.Policies)
	populate(objectMap, "request", o.Request)
	populate(objectMap, "responses", o.Responses)
	populate(objectMap, "templateParameters", o.TemplateParameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationEntityBaseContract.
func (o *OperationEntityBaseContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "policies":
			err = unpopulate(val, "Policies", &o.Policies)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &o.Request)
			delete(rawMsg, key)
		case "responses":
			err = unpopulate(val, "Responses", &o.Responses)
			delete(rawMsg, key)
		case "templateParameters":
			err = unpopulate(val, "TemplateParameters", &o.TemplateParameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResultContract.
func (o OperationResultContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultContract.
func (o *OperationResultContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResultContractProperties.
func (o OperationResultContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionLog", o.ActionLog)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "resultInfo", o.ResultInfo)
	populateDateTimeRFC3339(objectMap, "started", o.Started)
	populate(objectMap, "status", o.Status)
	populateDateTimeRFC3339(objectMap, "updated", o.Updated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultContractProperties.
func (o *OperationResultContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionLog":
			err = unpopulate(val, "ActionLog", &o.ActionLog)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "resultInfo":
			err = unpopulate(val, "ResultInfo", &o.ResultInfo)
			delete(rawMsg, key)
		case "started":
			err = unpopulateDateTimeRFC3339(val, "Started", &o.Started)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateDateTimeRFC3339(val, "Updated", &o.Updated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResultLogItemContract.
func (o OperationResultLogItemContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", o.Action)
	populate(objectMap, "objectKey", o.ObjectKey)
	populate(objectMap, "objectType", o.ObjectType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultLogItemContract.
func (o *OperationResultLogItemContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &o.Action)
			delete(rawMsg, key)
		case "objectKey":
			err = unpopulate(val, "ObjectKey", &o.ObjectKey)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &o.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationTagResourceContractProperties.
func (o OperationTagResourceContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiName", o.APIName)
	populate(objectMap, "apiRevision", o.APIRevision)
	populate(objectMap, "apiVersion", o.APIVersion)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "method", o.Method)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "urlTemplate", o.URLTemplate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationTagResourceContractProperties.
func (o *OperationTagResourceContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiName":
			err = unpopulate(val, "APIName", &o.APIName)
			delete(rawMsg, key)
		case "apiRevision":
			err = unpopulate(val, "APIRevision", &o.APIRevision)
			delete(rawMsg, key)
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &o.APIVersion)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &o.Method)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "urlTemplate":
			err = unpopulate(val, "URLTemplate", &o.URLTemplate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationUpdateContract.
func (o OperationUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationUpdateContract.
func (o *OperationUpdateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationUpdateContractProperties.
func (o OperationUpdateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "displayName", o.DisplayName)
	populate(objectMap, "method", o.Method)
	populate(objectMap, "policies", o.Policies)
	populate(objectMap, "request", o.Request)
	populate(objectMap, "responses", o.Responses)
	populate(objectMap, "templateParameters", o.TemplateParameters)
	populate(objectMap, "urlTemplate", o.URLTemplate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationUpdateContractProperties.
func (o *OperationUpdateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &o.DisplayName)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &o.Method)
			delete(rawMsg, key)
		case "policies":
			err = unpopulate(val, "Policies", &o.Policies)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &o.Request)
			delete(rawMsg, key)
		case "responses":
			err = unpopulate(val, "Responses", &o.Responses)
			delete(rawMsg, key)
		case "templateParameters":
			err = unpopulate(val, "TemplateParameters", &o.TemplateParameters)
			delete(rawMsg, key)
		case "urlTemplate":
			err = unpopulate(val, "URLTemplate", &o.URLTemplate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutboundEnvironmentEndpoint.
func (o OutboundEnvironmentEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", o.Category)
	populate(objectMap, "endpoints", o.Endpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutboundEnvironmentEndpoint.
func (o *OutboundEnvironmentEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &o.Category)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &o.Endpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutboundEnvironmentEndpointList.
func (o OutboundEnvironmentEndpointList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutboundEnvironmentEndpointList.
func (o *OutboundEnvironmentEndpointList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ParameterContract.
func (p ParameterContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultValue", p.DefaultValue)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "examples", p.Examples)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "required", p.Required)
	populate(objectMap, "schemaId", p.SchemaID)
	populate(objectMap, "type", p.Type)
	populate(objectMap, "typeName", p.TypeName)
	populate(objectMap, "values", p.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ParameterContract.
func (p *ParameterContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultValue":
			err = unpopulate(val, "DefaultValue", &p.DefaultValue)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "examples":
			err = unpopulate(val, "Examples", &p.Examples)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "required":
			err = unpopulate(val, "Required", &p.Required)
			delete(rawMsg, key)
		case "schemaId":
			err = unpopulate(val, "SchemaID", &p.SchemaID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &p.TypeName)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &p.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ParameterExampleContract.
func (p ParameterExampleContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "externalValue", p.ExternalValue)
	populate(objectMap, "summary", p.Summary)
	populateAny(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ParameterExampleContract.
func (p *ParameterExampleContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "externalValue":
			err = unpopulate(val, "ExternalValue", &p.ExternalValue)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &p.Summary)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PipelineDiagnosticSettings.
func (p PipelineDiagnosticSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "request", p.Request)
	populate(objectMap, "response", p.Response)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PipelineDiagnosticSettings.
func (p *PipelineDiagnosticSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "request":
			err = unpopulate(val, "Request", &p.Request)
			delete(rawMsg, key)
		case "response":
			err = unpopulate(val, "Response", &p.Response)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyCollection.
func (p PolicyCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", p.Count)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyCollection.
func (p *PolicyCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &p.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyContract.
func (p PolicyContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyContract.
func (p *PolicyContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyContractProperties.
func (p PolicyContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "format", p.Format)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyContractProperties.
func (p *PolicyContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "format":
			err = unpopulate(val, "Format", &p.Format)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyDescriptionCollection.
func (p PolicyDescriptionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", p.Count)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyDescriptionCollection.
func (p *PolicyDescriptionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &p.Count)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyDescriptionContract.
func (p PolicyDescriptionContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyDescriptionContract.
func (p *PolicyDescriptionContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyDescriptionContractProperties.
func (p PolicyDescriptionContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "scope", p.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyDescriptionContractProperties.
func (p *PolicyDescriptionContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &p.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyFragmentCollection.
func (p PolicyFragmentCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", p.Count)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyFragmentCollection.
func (p *PolicyFragmentCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &p.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyFragmentContract.
func (p PolicyFragmentContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyFragmentContract.
func (p *PolicyFragmentContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyFragmentContractProperties.
func (p PolicyFragmentContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "format", p.Format)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyFragmentContractProperties.
func (p *PolicyFragmentContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "format":
			err = unpopulate(val, "Format", &p.Format)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalConfigCollection.
func (p PortalConfigCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalConfigCollection.
func (p *PortalConfigCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalConfigContract.
func (p PortalConfigContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalConfigContract.
func (p *PortalConfigContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalConfigCorsProperties.
func (p PortalConfigCorsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedOrigins", p.AllowedOrigins)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalConfigCorsProperties.
func (p *PortalConfigCorsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedOrigins":
			err = unpopulate(val, "AllowedOrigins", &p.AllowedOrigins)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalConfigCspProperties.
func (p PortalConfigCspProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedSources", p.AllowedSources)
	populate(objectMap, "mode", p.Mode)
	populate(objectMap, "reportUri", p.ReportURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalConfigCspProperties.
func (p *PortalConfigCspProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedSources":
			err = unpopulate(val, "AllowedSources", &p.AllowedSources)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &p.Mode)
			delete(rawMsg, key)
		case "reportUri":
			err = unpopulate(val, "ReportURI", &p.ReportURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalConfigDelegationProperties.
func (p PortalConfigDelegationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "delegateRegistration", p.DelegateRegistration)
	populate(objectMap, "delegateSubscription", p.DelegateSubscription)
	populate(objectMap, "delegationUrl", p.DelegationURL)
	populate(objectMap, "validationKey", p.ValidationKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalConfigDelegationProperties.
func (p *PortalConfigDelegationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delegateRegistration":
			err = unpopulate(val, "DelegateRegistration", &p.DelegateRegistration)
			delete(rawMsg, key)
		case "delegateSubscription":
			err = unpopulate(val, "DelegateSubscription", &p.DelegateSubscription)
			delete(rawMsg, key)
		case "delegationUrl":
			err = unpopulate(val, "DelegationURL", &p.DelegationURL)
			delete(rawMsg, key)
		case "validationKey":
			err = unpopulate(val, "ValidationKey", &p.ValidationKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalConfigProperties.
func (p PortalConfigProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cors", p.Cors)
	populate(objectMap, "csp", p.Csp)
	populate(objectMap, "delegation", p.Delegation)
	populate(objectMap, "enableBasicAuth", p.EnableBasicAuth)
	populate(objectMap, "signin", p.Signin)
	populate(objectMap, "signup", p.Signup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalConfigProperties.
func (p *PortalConfigProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cors":
			err = unpopulate(val, "Cors", &p.Cors)
			delete(rawMsg, key)
		case "csp":
			err = unpopulate(val, "Csp", &p.Csp)
			delete(rawMsg, key)
		case "delegation":
			err = unpopulate(val, "Delegation", &p.Delegation)
			delete(rawMsg, key)
		case "enableBasicAuth":
			err = unpopulate(val, "EnableBasicAuth", &p.EnableBasicAuth)
			delete(rawMsg, key)
		case "signin":
			err = unpopulate(val, "Signin", &p.Signin)
			delete(rawMsg, key)
		case "signup":
			err = unpopulate(val, "Signup", &p.Signup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalConfigPropertiesSignin.
func (p PortalConfigPropertiesSignin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "require", p.Require)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalConfigPropertiesSignin.
func (p *PortalConfigPropertiesSignin) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "require":
			err = unpopulate(val, "Require", &p.Require)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalConfigPropertiesSignup.
func (p PortalConfigPropertiesSignup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "termsOfService", p.TermsOfService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalConfigPropertiesSignup.
func (p *PortalConfigPropertiesSignup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "termsOfService":
			err = unpopulate(val, "TermsOfService", &p.TermsOfService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalConfigTermsOfServiceProperties.
func (p PortalConfigTermsOfServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requireConsent", p.RequireConsent)
	populate(objectMap, "text", p.Text)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalConfigTermsOfServiceProperties.
func (p *PortalConfigTermsOfServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requireConsent":
			err = unpopulate(val, "RequireConsent", &p.RequireConsent)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &p.Text)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalDelegationSettings.
func (p PortalDelegationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalDelegationSettings.
func (p *PortalDelegationSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalDelegationSettingsProperties.
func (p PortalDelegationSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subscriptions", p.Subscriptions)
	populate(objectMap, "url", p.URL)
	populate(objectMap, "userRegistration", p.UserRegistration)
	populate(objectMap, "validationKey", p.ValidationKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalDelegationSettingsProperties.
func (p *PortalDelegationSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subscriptions":
			err = unpopulate(val, "Subscriptions", &p.Subscriptions)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &p.URL)
			delete(rawMsg, key)
		case "userRegistration":
			err = unpopulate(val, "UserRegistration", &p.UserRegistration)
			delete(rawMsg, key)
		case "validationKey":
			err = unpopulate(val, "ValidationKey", &p.ValidationKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalRevisionCollection.
func (p PortalRevisionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalRevisionCollection.
func (p *PortalRevisionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalRevisionContract.
func (p PortalRevisionContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalRevisionContract.
func (p *PortalRevisionContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalRevisionContractProperties.
func (p PortalRevisionContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdDateTime", p.CreatedDateTime)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "isCurrent", p.IsCurrent)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "statusDetails", p.StatusDetails)
	populateDateTimeRFC3339(objectMap, "updatedDateTime", p.UpdatedDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalRevisionContractProperties.
func (p *PortalRevisionContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDateTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedDateTime", &p.CreatedDateTime)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "isCurrent":
			err = unpopulate(val, "IsCurrent", &p.IsCurrent)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &p.StatusDetails)
			delete(rawMsg, key)
		case "updatedDateTime":
			err = unpopulateDateTimeRFC3339(val, "UpdatedDateTime", &p.UpdatedDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalSettingValidationKeyContract.
func (p PortalSettingValidationKeyContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "validationKey", p.ValidationKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalSettingValidationKeyContract.
func (p *PortalSettingValidationKeyContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "validationKey":
			err = unpopulate(val, "ValidationKey", &p.ValidationKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalSettingsCollection.
func (p PortalSettingsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", p.Count)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalSettingsCollection.
func (p *PortalSettingsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &p.Count)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalSettingsContract.
func (p PortalSettingsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalSettingsContract.
func (p *PortalSettingsContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalSettingsContractProperties.
func (p PortalSettingsContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", p.Enabled)
	populate(objectMap, "subscriptions", p.Subscriptions)
	populate(objectMap, "termsOfService", p.TermsOfService)
	populate(objectMap, "url", p.URL)
	populate(objectMap, "userRegistration", p.UserRegistration)
	populate(objectMap, "validationKey", p.ValidationKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalSettingsContractProperties.
func (p *PortalSettingsContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &p.Enabled)
			delete(rawMsg, key)
		case "subscriptions":
			err = unpopulate(val, "Subscriptions", &p.Subscriptions)
			delete(rawMsg, key)
		case "termsOfService":
			err = unpopulate(val, "TermsOfService", &p.TermsOfService)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &p.URL)
			delete(rawMsg, key)
		case "userRegistration":
			err = unpopulate(val, "UserRegistration", &p.UserRegistration)
			delete(rawMsg, key)
		case "validationKey":
			err = unpopulate(val, "ValidationKey", &p.ValidationKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalSigninSettingProperties.
func (p PortalSigninSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", p.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalSigninSettingProperties.
func (p *PortalSigninSettingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &p.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalSigninSettings.
func (p PortalSigninSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalSigninSettings.
func (p *PortalSigninSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalSignupSettings.
func (p PortalSignupSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalSignupSettings.
func (p *PortalSignupSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortalSignupSettingsProperties.
func (p PortalSignupSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", p.Enabled)
	populate(objectMap, "termsOfService", p.TermsOfService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortalSignupSettingsProperties.
func (p *PortalSignupSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &p.Enabled)
			delete(rawMsg, key)
		case "termsOfService":
			err = unpopulate(val, "TermsOfService", &p.TermsOfService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionRequest.
func (p PrivateEndpointConnectionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionRequest.
func (p *PrivateEndpointConnectionRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionRequestProperties.
func (p PrivateEndpointConnectionRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionRequestProperties.
func (p *PrivateEndpointConnectionRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionWrapperProperties.
func (p PrivateEndpointConnectionWrapperProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupIds", p.GroupIDs)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionWrapperProperties.
func (p *PrivateEndpointConnectionWrapperProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupIds":
			err = unpopulate(val, "GroupIDs", &p.GroupIDs)
			delete(rawMsg, key)
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceListResult.
func (p *PrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductCollection.
func (p ProductCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", p.Count)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductCollection.
func (p *ProductCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &p.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductContract.
func (p ProductContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductContract.
func (p *ProductContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductContractProperties.
func (p ProductContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "approvalRequired", p.ApprovalRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "state", p.State)
	populate(objectMap, "subscriptionRequired", p.SubscriptionRequired)
	populate(objectMap, "subscriptionsLimit", p.SubscriptionsLimit)
	populate(objectMap, "terms", p.Terms)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductContractProperties.
func (p *ProductContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "approvalRequired":
			err = unpopulate(val, "ApprovalRequired", &p.ApprovalRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		case "subscriptionRequired":
			err = unpopulate(val, "SubscriptionRequired", &p.SubscriptionRequired)
			delete(rawMsg, key)
		case "subscriptionsLimit":
			err = unpopulate(val, "SubscriptionsLimit", &p.SubscriptionsLimit)
			delete(rawMsg, key)
		case "terms":
			err = unpopulate(val, "Terms", &p.Terms)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductEntityBaseParameters.
func (p ProductEntityBaseParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "approvalRequired", p.ApprovalRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "state", p.State)
	populate(objectMap, "subscriptionRequired", p.SubscriptionRequired)
	populate(objectMap, "subscriptionsLimit", p.SubscriptionsLimit)
	populate(objectMap, "terms", p.Terms)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductEntityBaseParameters.
func (p *ProductEntityBaseParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "approvalRequired":
			err = unpopulate(val, "ApprovalRequired", &p.ApprovalRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		case "subscriptionRequired":
			err = unpopulate(val, "SubscriptionRequired", &p.SubscriptionRequired)
			delete(rawMsg, key)
		case "subscriptionsLimit":
			err = unpopulate(val, "SubscriptionsLimit", &p.SubscriptionsLimit)
			delete(rawMsg, key)
		case "terms":
			err = unpopulate(val, "Terms", &p.Terms)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductTagResourceContractProperties.
func (p ProductTagResourceContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "approvalRequired", p.ApprovalRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "state", p.State)
	populate(objectMap, "subscriptionRequired", p.SubscriptionRequired)
	populate(objectMap, "subscriptionsLimit", p.SubscriptionsLimit)
	populate(objectMap, "terms", p.Terms)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductTagResourceContractProperties.
func (p *ProductTagResourceContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "approvalRequired":
			err = unpopulate(val, "ApprovalRequired", &p.ApprovalRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		case "subscriptionRequired":
			err = unpopulate(val, "SubscriptionRequired", &p.SubscriptionRequired)
			delete(rawMsg, key)
		case "subscriptionsLimit":
			err = unpopulate(val, "SubscriptionsLimit", &p.SubscriptionsLimit)
			delete(rawMsg, key)
		case "terms":
			err = unpopulate(val, "Terms", &p.Terms)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductUpdateParameters.
func (p ProductUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductUpdateParameters.
func (p *ProductUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductUpdateProperties.
func (p ProductUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "approvalRequired", p.ApprovalRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "state", p.State)
	populate(objectMap, "subscriptionRequired", p.SubscriptionRequired)
	populate(objectMap, "subscriptionsLimit", p.SubscriptionsLimit)
	populate(objectMap, "terms", p.Terms)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductUpdateProperties.
func (p *ProductUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "approvalRequired":
			err = unpopulate(val, "ApprovalRequired", &p.ApprovalRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		case "subscriptionRequired":
			err = unpopulate(val, "SubscriptionRequired", &p.SubscriptionRequired)
			delete(rawMsg, key)
		case "subscriptionsLimit":
			err = unpopulate(val, "SubscriptionsLimit", &p.SubscriptionsLimit)
			delete(rawMsg, key)
		case "terms":
			err = unpopulate(val, "Terms", &p.Terms)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaCounterCollection.
func (q QuotaCounterCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", q.Count)
	populate(objectMap, "nextLink", q.NextLink)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaCounterCollection.
func (q *QuotaCounterCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &q.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &q.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaCounterContract.
func (q QuotaCounterContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "counterKey", q.CounterKey)
	populateDateTimeRFC3339(objectMap, "periodEndTime", q.PeriodEndTime)
	populate(objectMap, "periodKey", q.PeriodKey)
	populateDateTimeRFC3339(objectMap, "periodStartTime", q.PeriodStartTime)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaCounterContract.
func (q *QuotaCounterContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "counterKey":
			err = unpopulate(val, "CounterKey", &q.CounterKey)
			delete(rawMsg, key)
		case "periodEndTime":
			err = unpopulateDateTimeRFC3339(val, "PeriodEndTime", &q.PeriodEndTime)
			delete(rawMsg, key)
		case "periodKey":
			err = unpopulate(val, "PeriodKey", &q.PeriodKey)
			delete(rawMsg, key)
		case "periodStartTime":
			err = unpopulateDateTimeRFC3339(val, "PeriodStartTime", &q.PeriodStartTime)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaCounterValueContract.
func (q QuotaCounterValueContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaCounterValueContract.
func (q *QuotaCounterValueContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaCounterValueContractProperties.
func (q QuotaCounterValueContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "callsCount", q.CallsCount)
	populate(objectMap, "kbTransferred", q.KbTransferred)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaCounterValueContractProperties.
func (q *QuotaCounterValueContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "callsCount":
			err = unpopulate(val, "CallsCount", &q.CallsCount)
			delete(rawMsg, key)
		case "kbTransferred":
			err = unpopulate(val, "KbTransferred", &q.KbTransferred)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaCounterValueUpdateContract.
func (q QuotaCounterValueUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", q.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaCounterValueUpdateContract.
func (q *QuotaCounterValueUpdateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &q.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecipientEmailCollection.
func (r RecipientEmailCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", r.Count)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecipientEmailCollection.
func (r *RecipientEmailCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &r.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecipientEmailContract.
func (r RecipientEmailContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecipientEmailContract.
func (r *RecipientEmailContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecipientEmailContractProperties.
func (r RecipientEmailContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "email", r.Email)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecipientEmailContractProperties.
func (r *RecipientEmailContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "email":
			err = unpopulate(val, "Email", &r.Email)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecipientUserCollection.
func (r RecipientUserCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", r.Count)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecipientUserCollection.
func (r *RecipientUserCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &r.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecipientUserContract.
func (r RecipientUserContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecipientUserContract.
func (r *RecipientUserContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecipientUsersContractProperties.
func (r RecipientUsersContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "userId", r.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecipientUsersContractProperties.
func (r *RecipientUsersContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "userId":
			err = unpopulate(val, "UserID", &r.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecipientsContractProperties.
func (r RecipientsContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "emails", r.Emails)
	populate(objectMap, "users", r.Users)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecipientsContractProperties.
func (r *RecipientsContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "emails":
			err = unpopulate(val, "Emails", &r.Emails)
			delete(rawMsg, key)
		case "users":
			err = unpopulate(val, "Users", &r.Users)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegionContract.
func (r RegionContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isDeleted", r.IsDeleted)
	populate(objectMap, "isMasterRegion", r.IsMasterRegion)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegionContract.
func (r *RegionContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isDeleted":
			err = unpopulate(val, "IsDeleted", &r.IsDeleted)
			delete(rawMsg, key)
		case "isMasterRegion":
			err = unpopulate(val, "IsMasterRegion", &r.IsMasterRegion)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegionListResult.
func (r RegionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", r.Count)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegionListResult.
func (r *RegionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &r.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistrationDelegationSettingsProperties.
func (r RegistrationDelegationSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", r.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistrationDelegationSettingsProperties.
func (r *RegistrationDelegationSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &r.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemotePrivateEndpointConnectionWrapper.
func (r RemotePrivateEndpointConnectionWrapper) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemotePrivateEndpointConnectionWrapper.
func (r *RemotePrivateEndpointConnectionWrapper) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportCollection.
func (r ReportCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", r.Count)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportCollection.
func (r *ReportCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &r.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportRecordContract.
func (r ReportRecordContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiId", r.APIID)
	populate(objectMap, "apiRegion", r.APIRegion)
	populate(objectMap, "apiTimeAvg", r.APITimeAvg)
	populate(objectMap, "apiTimeMax", r.APITimeMax)
	populate(objectMap, "apiTimeMin", r.APITimeMin)
	populate(objectMap, "bandwidth", r.Bandwidth)
	populate(objectMap, "cacheHitCount", r.CacheHitCount)
	populate(objectMap, "cacheMissCount", r.CacheMissCount)
	populate(objectMap, "callCountBlocked", r.CallCountBlocked)
	populate(objectMap, "callCountFailed", r.CallCountFailed)
	populate(objectMap, "callCountOther", r.CallCountOther)
	populate(objectMap, "callCountSuccess", r.CallCountSuccess)
	populate(objectMap, "callCountTotal", r.CallCountTotal)
	populate(objectMap, "country", r.Country)
	populate(objectMap, "interval", r.Interval)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "operationId", r.OperationID)
	populate(objectMap, "productId", r.ProductID)
	populate(objectMap, "region", r.Region)
	populate(objectMap, "serviceTimeAvg", r.ServiceTimeAvg)
	populate(objectMap, "serviceTimeMax", r.ServiceTimeMax)
	populate(objectMap, "serviceTimeMin", r.ServiceTimeMin)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	populateDateTimeRFC3339(objectMap, "timestamp", r.Timestamp)
	populate(objectMap, "userId", r.UserID)
	populate(objectMap, "zip", r.Zip)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportRecordContract.
func (r *ReportRecordContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &r.APIID)
			delete(rawMsg, key)
		case "apiRegion":
			err = unpopulate(val, "APIRegion", &r.APIRegion)
			delete(rawMsg, key)
		case "apiTimeAvg":
			err = unpopulate(val, "APITimeAvg", &r.APITimeAvg)
			delete(rawMsg, key)
		case "apiTimeMax":
			err = unpopulate(val, "APITimeMax", &r.APITimeMax)
			delete(rawMsg, key)
		case "apiTimeMin":
			err = unpopulate(val, "APITimeMin", &r.APITimeMin)
			delete(rawMsg, key)
		case "bandwidth":
			err = unpopulate(val, "Bandwidth", &r.Bandwidth)
			delete(rawMsg, key)
		case "cacheHitCount":
			err = unpopulate(val, "CacheHitCount", &r.CacheHitCount)
			delete(rawMsg, key)
		case "cacheMissCount":
			err = unpopulate(val, "CacheMissCount", &r.CacheMissCount)
			delete(rawMsg, key)
		case "callCountBlocked":
			err = unpopulate(val, "CallCountBlocked", &r.CallCountBlocked)
			delete(rawMsg, key)
		case "callCountFailed":
			err = unpopulate(val, "CallCountFailed", &r.CallCountFailed)
			delete(rawMsg, key)
		case "callCountOther":
			err = unpopulate(val, "CallCountOther", &r.CallCountOther)
			delete(rawMsg, key)
		case "callCountSuccess":
			err = unpopulate(val, "CallCountSuccess", &r.CallCountSuccess)
			delete(rawMsg, key)
		case "callCountTotal":
			err = unpopulate(val, "CallCountTotal", &r.CallCountTotal)
			delete(rawMsg, key)
		case "country":
			err = unpopulate(val, "Country", &r.Country)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &r.Interval)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &r.OperationID)
			delete(rawMsg, key)
		case "productId":
			err = unpopulate(val, "ProductID", &r.ProductID)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &r.Region)
			delete(rawMsg, key)
		case "serviceTimeAvg":
			err = unpopulate(val, "ServiceTimeAvg", &r.ServiceTimeAvg)
			delete(rawMsg, key)
		case "serviceTimeMax":
			err = unpopulate(val, "ServiceTimeMax", &r.ServiceTimeMax)
			delete(rawMsg, key)
		case "serviceTimeMin":
			err = unpopulate(val, "ServiceTimeMin", &r.ServiceTimeMin)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &r.Timestamp)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &r.UserID)
			delete(rawMsg, key)
		case "zip":
			err = unpopulate(val, "Zip", &r.Zip)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RepresentationContract.
func (r RepresentationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentType", r.ContentType)
	populate(objectMap, "examples", r.Examples)
	populate(objectMap, "formParameters", r.FormParameters)
	populate(objectMap, "schemaId", r.SchemaID)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RepresentationContract.
func (r *RepresentationContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentType":
			err = unpopulate(val, "ContentType", &r.ContentType)
			delete(rawMsg, key)
		case "examples":
			err = unpopulate(val, "Examples", &r.Examples)
			delete(rawMsg, key)
		case "formParameters":
			err = unpopulate(val, "FormParameters", &r.FormParameters)
			delete(rawMsg, key)
		case "schemaId":
			err = unpopulate(val, "SchemaID", &r.SchemaID)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &r.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestContract.
func (r RequestContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "headers", r.Headers)
	populate(objectMap, "queryParameters", r.QueryParameters)
	populate(objectMap, "representations", r.Representations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestContract.
func (r *RequestContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &r.Headers)
			delete(rawMsg, key)
		case "queryParameters":
			err = unpopulate(val, "QueryParameters", &r.QueryParameters)
			delete(rawMsg, key)
		case "representations":
			err = unpopulate(val, "Representations", &r.Representations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestReportCollection.
func (r RequestReportCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", r.Count)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestReportCollection.
func (r *RequestReportCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &r.Count)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestReportRecordContract.
func (r RequestReportRecordContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiId", r.APIID)
	populate(objectMap, "apiRegion", r.APIRegion)
	populate(objectMap, "apiTime", r.APITime)
	populate(objectMap, "backendResponseCode", r.BackendResponseCode)
	populate(objectMap, "cache", r.Cache)
	populate(objectMap, "ipAddress", r.IPAddress)
	populate(objectMap, "method", r.Method)
	populate(objectMap, "operationId", r.OperationID)
	populate(objectMap, "productId", r.ProductID)
	populate(objectMap, "requestId", r.RequestID)
	populate(objectMap, "requestSize", r.RequestSize)
	populate(objectMap, "responseCode", r.ResponseCode)
	populate(objectMap, "responseSize", r.ResponseSize)
	populate(objectMap, "serviceTime", r.ServiceTime)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	populateDateTimeRFC3339(objectMap, "timestamp", r.Timestamp)
	populate(objectMap, "url", r.URL)
	populate(objectMap, "userId", r.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestReportRecordContract.
func (r *RequestReportRecordContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiId":
			err = unpopulate(val, "APIID", &r.APIID)
			delete(rawMsg, key)
		case "apiRegion":
			err = unpopulate(val, "APIRegion", &r.APIRegion)
			delete(rawMsg, key)
		case "apiTime":
			err = unpopulate(val, "APITime", &r.APITime)
			delete(rawMsg, key)
		case "backendResponseCode":
			err = unpopulate(val, "BackendResponseCode", &r.BackendResponseCode)
			delete(rawMsg, key)
		case "cache":
			err = unpopulate(val, "Cache", &r.Cache)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &r.IPAddress)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &r.Method)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &r.OperationID)
			delete(rawMsg, key)
		case "productId":
			err = unpopulate(val, "ProductID", &r.ProductID)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &r.RequestID)
			delete(rawMsg, key)
		case "requestSize":
			err = unpopulate(val, "RequestSize", &r.RequestSize)
			delete(rawMsg, key)
		case "responseCode":
			err = unpopulate(val, "ResponseCode", &r.ResponseCode)
			delete(rawMsg, key)
		case "responseSize":
			err = unpopulate(val, "ResponseSize", &r.ResponseSize)
			delete(rawMsg, key)
		case "serviceTime":
			err = unpopulate(val, "ServiceTime", &r.ServiceTime)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &r.Timestamp)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &r.URL)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &r.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResolverCollection.
func (r ResolverCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", r.Count)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResolverCollection.
func (r *ResolverCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &r.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResolverContract.
func (r ResolverContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResolverContract.
func (r *ResolverContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResolverEntityBaseContract.
func (r ResolverEntityBaseContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "path", r.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResolverEntityBaseContract.
func (r *ResolverEntityBaseContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &r.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResolverResultContract.
func (r ResolverResultContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResolverResultContract.
func (r *ResolverResultContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResolverResultContractProperties.
func (r ResolverResultContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionLog", r.ActionLog)
	populate(objectMap, "error", r.Error)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "resultInfo", r.ResultInfo)
	populateDateTimeRFC3339(objectMap, "started", r.Started)
	populate(objectMap, "status", r.Status)
	populateDateTimeRFC3339(objectMap, "updated", r.Updated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResolverResultContractProperties.
func (r *ResolverResultContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionLog":
			err = unpopulate(val, "ActionLog", &r.ActionLog)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &r.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "resultInfo":
			err = unpopulate(val, "ResultInfo", &r.ResultInfo)
			delete(rawMsg, key)
		case "started":
			err = unpopulateDateTimeRFC3339(val, "Started", &r.Started)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateDateTimeRFC3339(val, "Updated", &r.Updated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResolverResultLogItemContract.
func (r ResolverResultLogItemContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", r.Action)
	populate(objectMap, "objectKey", r.ObjectKey)
	populate(objectMap, "objectType", r.ObjectType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResolverResultLogItemContract.
func (r *ResolverResultLogItemContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &r.Action)
			delete(rawMsg, key)
		case "objectKey":
			err = unpopulate(val, "ObjectKey", &r.ObjectKey)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &r.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResolverUpdateContract.
func (r ResolverUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResolverUpdateContract.
func (r *ResolverUpdateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResolverUpdateContractProperties.
func (r ResolverUpdateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "path", r.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResolverUpdateContractProperties.
func (r *ResolverUpdateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &r.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceCollection.
func (r ResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", r.Count)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceCollection.
func (r *ResourceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &r.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceCollectionValueItem.
func (r ResourceCollectionValueItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceCollectionValueItem.
func (r *ResourceCollectionValueItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceLocationDataContract.
func (r ResourceLocationDataContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "city", r.City)
	populate(objectMap, "countryOrRegion", r.CountryOrRegion)
	populate(objectMap, "district", r.District)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceLocationDataContract.
func (r *ResourceLocationDataContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "city":
			err = unpopulate(val, "City", &r.City)
			delete(rawMsg, key)
		case "countryOrRegion":
			err = unpopulate(val, "CountryOrRegion", &r.CountryOrRegion)
			delete(rawMsg, key)
		case "district":
			err = unpopulate(val, "District", &r.District)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKU.
func (r ResourceSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKU.
func (r *ResourceSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKUCapacity.
func (r ResourceSKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", r.Default)
	populate(objectMap, "maximum", r.Maximum)
	populate(objectMap, "minimum", r.Minimum)
	populate(objectMap, "scaleType", r.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKUCapacity.
func (r *ResourceSKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &r.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &r.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &r.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &r.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKUResult.
func (r ResourceSKUResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", r.Capacity)
	populate(objectMap, "resourceType", r.ResourceType)
	populate(objectMap, "sku", r.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKUResult.
func (r *ResourceSKUResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &r.Capacity)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKUResults.
func (r ResourceSKUResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKUResults.
func (r *ResourceSKUResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResponseContract.
func (r ResponseContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "headers", r.Headers)
	populate(objectMap, "representations", r.Representations)
	populate(objectMap, "statusCode", r.StatusCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResponseContract.
func (r *ResponseContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &r.Headers)
			delete(rawMsg, key)
		case "representations":
			err = unpopulate(val, "Representations", &r.Representations)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &r.StatusCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersions", s.APIVersions)
	populate(objectMap, "capabilities", s.Capabilities)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "costs", s.Costs)
	populate(objectMap, "family", s.Family)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "locationInfo", s.LocationInfo)
	populate(objectMap, "locations", s.Locations)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "resourceType", s.ResourceType)
	populate(objectMap, "restrictions", s.Restrictions)
	populate(objectMap, "size", s.Size)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersions":
			err = unpopulate(val, "APIVersions", &s.APIVersions)
			delete(rawMsg, key)
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "costs":
			err = unpopulate(val, "Costs", &s.Costs)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &s.Family)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "locationInfo":
			err = unpopulate(val, "LocationInfo", &s.LocationInfo)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &s.Locations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "restrictions":
			err = unpopulate(val, "Restrictions", &s.Restrictions)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &s.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapabilities.
func (s SKUCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapabilities.
func (s *SKUCapabilities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapacity.
func (s SKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", s.Default)
	populate(objectMap, "maximum", s.Maximum)
	populate(objectMap, "minimum", s.Minimum)
	populate(objectMap, "scaleType", s.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapacity.
func (s *SKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &s.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &s.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &s.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &s.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCosts.
func (s SKUCosts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedUnit", s.ExtendedUnit)
	populate(objectMap, "meterID", s.MeterID)
	populate(objectMap, "quantity", s.Quantity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCosts.
func (s *SKUCosts) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedUnit":
			err = unpopulate(val, "ExtendedUnit", &s.ExtendedUnit)
			delete(rawMsg, key)
		case "meterID":
			err = unpopulate(val, "MeterID", &s.MeterID)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &s.Quantity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKULocationInfo.
func (s SKULocationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "zoneDetails", s.ZoneDetails)
	populate(objectMap, "zones", s.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKULocationInfo.
func (s *SKULocationInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "zoneDetails":
			err = unpopulate(val, "ZoneDetails", &s.ZoneDetails)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &s.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKURestrictionInfo.
func (s SKURestrictionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "locations", s.Locations)
	populate(objectMap, "zones", s.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKURestrictionInfo.
func (s *SKURestrictionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "locations":
			err = unpopulate(val, "Locations", &s.Locations)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &s.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKURestrictions.
func (s SKURestrictions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reasonCode", s.ReasonCode)
	populate(objectMap, "restrictionInfo", s.RestrictionInfo)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "values", s.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKURestrictions.
func (s *SKURestrictions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reasonCode":
			err = unpopulate(val, "ReasonCode", &s.ReasonCode)
			delete(rawMsg, key)
		case "restrictionInfo":
			err = unpopulate(val, "RestrictionInfo", &s.RestrictionInfo)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &s.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUZoneDetails.
func (s SKUZoneDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", s.Capabilities)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUZoneDetails.
func (s *SKUZoneDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUsResult.
func (s SKUsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUsResult.
func (s *SKUsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SamplingSettings.
func (s SamplingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "percentage", s.Percentage)
	populate(objectMap, "samplingType", s.SamplingType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SamplingSettings.
func (s *SamplingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "percentage":
			err = unpopulate(val, "Percentage", &s.Percentage)
			delete(rawMsg, key)
		case "samplingType":
			err = unpopulate(val, "SamplingType", &s.SamplingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SaveConfigurationParameter.
func (s SaveConfigurationParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SaveConfigurationParameter.
func (s *SaveConfigurationParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SaveConfigurationParameterProperties.
func (s SaveConfigurationParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "branch", s.Branch)
	populate(objectMap, "force", s.Force)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SaveConfigurationParameterProperties.
func (s *SaveConfigurationParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "branch":
			err = unpopulate(val, "Branch", &s.Branch)
			delete(rawMsg, key)
		case "force":
			err = unpopulate(val, "Force", &s.Force)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SchemaCollection.
func (s SchemaCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", s.Count)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SchemaCollection.
func (s *SchemaCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SchemaContract.
func (s SchemaContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SchemaContract.
func (s *SchemaContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SchemaContractProperties.
func (s SchemaContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentType", s.ContentType)
	populate(objectMap, "document", s.Document)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SchemaContractProperties.
func (s *SchemaContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentType":
			err = unpopulate(val, "ContentType", &s.ContentType)
			delete(rawMsg, key)
		case "document":
			err = unpopulate(val, "Document", &s.Document)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SchemaDocumentProperties.
func (s SchemaDocumentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "components", s.Components)
	populateAny(objectMap, "definitions", s.Definitions)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SchemaDocumentProperties.
func (s *SchemaDocumentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "components":
			err = unpopulate(val, "Components", &s.Components)
			delete(rawMsg, key)
		case "definitions":
			err = unpopulate(val, "Definitions", &s.Definitions)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceApplyNetworkConfigurationParameters.
func (s ServiceApplyNetworkConfigurationParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", s.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceApplyNetworkConfigurationParameters.
func (s *ServiceApplyNetworkConfigurationParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBackupRestoreParameters.
func (s ServiceBackupRestoreParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessKey", s.AccessKey)
	populate(objectMap, "accessType", s.AccessType)
	populate(objectMap, "backupName", s.BackupName)
	populate(objectMap, "clientId", s.ClientID)
	populate(objectMap, "containerName", s.ContainerName)
	populate(objectMap, "storageAccount", s.StorageAccount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBackupRestoreParameters.
func (s *ServiceBackupRestoreParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessKey":
			err = unpopulate(val, "AccessKey", &s.AccessKey)
			delete(rawMsg, key)
		case "accessType":
			err = unpopulate(val, "AccessType", &s.AccessType)
			delete(rawMsg, key)
		case "backupName":
			err = unpopulate(val, "BackupName", &s.BackupName)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &s.ClientID)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &s.ContainerName)
			delete(rawMsg, key)
		case "storageAccount":
			err = unpopulate(val, "StorageAccount", &s.StorageAccount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBaseProperties.
func (s ServiceBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersionConstraint", s.APIVersionConstraint)
	populate(objectMap, "additionalLocations", s.AdditionalLocations)
	populate(objectMap, "certificates", s.Certificates)
	populateDateTimeRFC3339(objectMap, "createdAtUtc", s.CreatedAtUTC)
	populate(objectMap, "customProperties", s.CustomProperties)
	populate(objectMap, "developerPortalUrl", s.DeveloperPortalURL)
	populate(objectMap, "disableGateway", s.DisableGateway)
	populate(objectMap, "enableClientCertificate", s.EnableClientCertificate)
	populate(objectMap, "gatewayRegionalUrl", s.GatewayRegionalURL)
	populate(objectMap, "gatewayUrl", s.GatewayURL)
	populate(objectMap, "hostnameConfigurations", s.HostnameConfigurations)
	populate(objectMap, "managementApiUrl", s.ManagementAPIURL)
	populate(objectMap, "natGatewayState", s.NatGatewayState)
	populate(objectMap, "notificationSenderEmail", s.NotificationSenderEmail)
	populate(objectMap, "outboundPublicIPAddresses", s.OutboundPublicIPAddresses)
	populate(objectMap, "platformVersion", s.PlatformVersion)
	populate(objectMap, "portalUrl", s.PortalURL)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "privateIPAddresses", s.PrivateIPAddresses)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "publicIpAddressId", s.PublicIPAddressID)
	populate(objectMap, "publicIPAddresses", s.PublicIPAddresses)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "restore", s.Restore)
	populate(objectMap, "scmUrl", s.ScmURL)
	populate(objectMap, "targetProvisioningState", s.TargetProvisioningState)
	populate(objectMap, "virtualNetworkConfiguration", s.VirtualNetworkConfiguration)
	populate(objectMap, "virtualNetworkType", s.VirtualNetworkType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBaseProperties.
func (s *ServiceBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersionConstraint":
			err = unpopulate(val, "APIVersionConstraint", &s.APIVersionConstraint)
			delete(rawMsg, key)
		case "additionalLocations":
			err = unpopulate(val, "AdditionalLocations", &s.AdditionalLocations)
			delete(rawMsg, key)
		case "certificates":
			err = unpopulate(val, "Certificates", &s.Certificates)
			delete(rawMsg, key)
		case "createdAtUtc":
			err = unpopulateDateTimeRFC3339(val, "CreatedAtUTC", &s.CreatedAtUTC)
			delete(rawMsg, key)
		case "customProperties":
			err = unpopulate(val, "CustomProperties", &s.CustomProperties)
			delete(rawMsg, key)
		case "developerPortalUrl":
			err = unpopulate(val, "DeveloperPortalURL", &s.DeveloperPortalURL)
			delete(rawMsg, key)
		case "disableGateway":
			err = unpopulate(val, "DisableGateway", &s.DisableGateway)
			delete(rawMsg, key)
		case "enableClientCertificate":
			err = unpopulate(val, "EnableClientCertificate", &s.EnableClientCertificate)
			delete(rawMsg, key)
		case "gatewayRegionalUrl":
			err = unpopulate(val, "GatewayRegionalURL", &s.GatewayRegionalURL)
			delete(rawMsg, key)
		case "gatewayUrl":
			err = unpopulate(val, "GatewayURL", &s.GatewayURL)
			delete(rawMsg, key)
		case "hostnameConfigurations":
			err = unpopulate(val, "HostnameConfigurations", &s.HostnameConfigurations)
			delete(rawMsg, key)
		case "managementApiUrl":
			err = unpopulate(val, "ManagementAPIURL", &s.ManagementAPIURL)
			delete(rawMsg, key)
		case "natGatewayState":
			err = unpopulate(val, "NatGatewayState", &s.NatGatewayState)
			delete(rawMsg, key)
		case "notificationSenderEmail":
			err = unpopulate(val, "NotificationSenderEmail", &s.NotificationSenderEmail)
			delete(rawMsg, key)
		case "outboundPublicIPAddresses":
			err = unpopulate(val, "OutboundPublicIPAddresses", &s.OutboundPublicIPAddresses)
			delete(rawMsg, key)
		case "platformVersion":
			err = unpopulate(val, "PlatformVersion", &s.PlatformVersion)
			delete(rawMsg, key)
		case "portalUrl":
			err = unpopulate(val, "PortalURL", &s.PortalURL)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &s.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "privateIPAddresses":
			err = unpopulate(val, "PrivateIPAddresses", &s.PrivateIPAddresses)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "publicIpAddressId":
			err = unpopulate(val, "PublicIPAddressID", &s.PublicIPAddressID)
			delete(rawMsg, key)
		case "publicIPAddresses":
			err = unpopulate(val, "PublicIPAddresses", &s.PublicIPAddresses)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "restore":
			err = unpopulate(val, "Restore", &s.Restore)
			delete(rawMsg, key)
		case "scmUrl":
			err = unpopulate(val, "ScmURL", &s.ScmURL)
			delete(rawMsg, key)
		case "targetProvisioningState":
			err = unpopulate(val, "TargetProvisioningState", &s.TargetProvisioningState)
			delete(rawMsg, key)
		case "virtualNetworkConfiguration":
			err = unpopulate(val, "VirtualNetworkConfiguration", &s.VirtualNetworkConfiguration)
			delete(rawMsg, key)
		case "virtualNetworkType":
			err = unpopulate(val, "VirtualNetworkType", &s.VirtualNetworkType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceCheckNameAvailabilityParameters.
func (s ServiceCheckNameAvailabilityParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceCheckNameAvailabilityParameters.
func (s *ServiceCheckNameAvailabilityParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceGetDomainOwnershipIdentifierResult.
func (s ServiceGetDomainOwnershipIdentifierResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainOwnershipIdentifier", s.DomainOwnershipIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceGetDomainOwnershipIdentifierResult.
func (s *ServiceGetDomainOwnershipIdentifierResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainOwnershipIdentifier":
			err = unpopulate(val, "DomainOwnershipIdentifier", &s.DomainOwnershipIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceGetSsoTokenResult.
func (s ServiceGetSsoTokenResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "redirectUri", s.RedirectURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceGetSsoTokenResult.
func (s *ServiceGetSsoTokenResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "redirectUri":
			err = unpopulate(val, "RedirectURI", &s.RedirectURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceIdentity.
func (s ServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", s.PrincipalID)
	populate(objectMap, "tenantId", s.TenantID)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "userAssignedIdentities", s.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceIdentity.
func (s *ServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &s.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &s.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &s.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceListResult.
func (s ServiceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceListResult.
func (s *ServiceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceNameAvailabilityResult.
func (s ServiceNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "nameAvailable", s.NameAvailable)
	populate(objectMap, "reason", s.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceNameAvailabilityResult.
func (s *ServiceNameAvailabilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &s.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &s.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceProperties.
func (s ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersionConstraint", s.APIVersionConstraint)
	populate(objectMap, "additionalLocations", s.AdditionalLocations)
	populate(objectMap, "certificates", s.Certificates)
	populateDateTimeRFC3339(objectMap, "createdAtUtc", s.CreatedAtUTC)
	populate(objectMap, "customProperties", s.CustomProperties)
	populate(objectMap, "developerPortalUrl", s.DeveloperPortalURL)
	populate(objectMap, "disableGateway", s.DisableGateway)
	populate(objectMap, "enableClientCertificate", s.EnableClientCertificate)
	populate(objectMap, "gatewayRegionalUrl", s.GatewayRegionalURL)
	populate(objectMap, "gatewayUrl", s.GatewayURL)
	populate(objectMap, "hostnameConfigurations", s.HostnameConfigurations)
	populate(objectMap, "managementApiUrl", s.ManagementAPIURL)
	populate(objectMap, "natGatewayState", s.NatGatewayState)
	populate(objectMap, "notificationSenderEmail", s.NotificationSenderEmail)
	populate(objectMap, "outboundPublicIPAddresses", s.OutboundPublicIPAddresses)
	populate(objectMap, "platformVersion", s.PlatformVersion)
	populate(objectMap, "portalUrl", s.PortalURL)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "privateIPAddresses", s.PrivateIPAddresses)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "publicIpAddressId", s.PublicIPAddressID)
	populate(objectMap, "publicIPAddresses", s.PublicIPAddresses)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "publisherEmail", s.PublisherEmail)
	populate(objectMap, "publisherName", s.PublisherName)
	populate(objectMap, "restore", s.Restore)
	populate(objectMap, "scmUrl", s.ScmURL)
	populate(objectMap, "targetProvisioningState", s.TargetProvisioningState)
	populate(objectMap, "virtualNetworkConfiguration", s.VirtualNetworkConfiguration)
	populate(objectMap, "virtualNetworkType", s.VirtualNetworkType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceProperties.
func (s *ServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersionConstraint":
			err = unpopulate(val, "APIVersionConstraint", &s.APIVersionConstraint)
			delete(rawMsg, key)
		case "additionalLocations":
			err = unpopulate(val, "AdditionalLocations", &s.AdditionalLocations)
			delete(rawMsg, key)
		case "certificates":
			err = unpopulate(val, "Certificates", &s.Certificates)
			delete(rawMsg, key)
		case "createdAtUtc":
			err = unpopulateDateTimeRFC3339(val, "CreatedAtUTC", &s.CreatedAtUTC)
			delete(rawMsg, key)
		case "customProperties":
			err = unpopulate(val, "CustomProperties", &s.CustomProperties)
			delete(rawMsg, key)
		case "developerPortalUrl":
			err = unpopulate(val, "DeveloperPortalURL", &s.DeveloperPortalURL)
			delete(rawMsg, key)
		case "disableGateway":
			err = unpopulate(val, "DisableGateway", &s.DisableGateway)
			delete(rawMsg, key)
		case "enableClientCertificate":
			err = unpopulate(val, "EnableClientCertificate", &s.EnableClientCertificate)
			delete(rawMsg, key)
		case "gatewayRegionalUrl":
			err = unpopulate(val, "GatewayRegionalURL", &s.GatewayRegionalURL)
			delete(rawMsg, key)
		case "gatewayUrl":
			err = unpopulate(val, "GatewayURL", &s.GatewayURL)
			delete(rawMsg, key)
		case "hostnameConfigurations":
			err = unpopulate(val, "HostnameConfigurations", &s.HostnameConfigurations)
			delete(rawMsg, key)
		case "managementApiUrl":
			err = unpopulate(val, "ManagementAPIURL", &s.ManagementAPIURL)
			delete(rawMsg, key)
		case "natGatewayState":
			err = unpopulate(val, "NatGatewayState", &s.NatGatewayState)
			delete(rawMsg, key)
		case "notificationSenderEmail":
			err = unpopulate(val, "NotificationSenderEmail", &s.NotificationSenderEmail)
			delete(rawMsg, key)
		case "outboundPublicIPAddresses":
			err = unpopulate(val, "OutboundPublicIPAddresses", &s.OutboundPublicIPAddresses)
			delete(rawMsg, key)
		case "platformVersion":
			err = unpopulate(val, "PlatformVersion", &s.PlatformVersion)
			delete(rawMsg, key)
		case "portalUrl":
			err = unpopulate(val, "PortalURL", &s.PortalURL)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &s.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "privateIPAddresses":
			err = unpopulate(val, "PrivateIPAddresses", &s.PrivateIPAddresses)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "publicIpAddressId":
			err = unpopulate(val, "PublicIPAddressID", &s.PublicIPAddressID)
			delete(rawMsg, key)
		case "publicIPAddresses":
			err = unpopulate(val, "PublicIPAddresses", &s.PublicIPAddresses)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "publisherEmail":
			err = unpopulate(val, "PublisherEmail", &s.PublisherEmail)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &s.PublisherName)
			delete(rawMsg, key)
		case "restore":
			err = unpopulate(val, "Restore", &s.Restore)
			delete(rawMsg, key)
		case "scmUrl":
			err = unpopulate(val, "ScmURL", &s.ScmURL)
			delete(rawMsg, key)
		case "targetProvisioningState":
			err = unpopulate(val, "TargetProvisioningState", &s.TargetProvisioningState)
			delete(rawMsg, key)
		case "virtualNetworkConfiguration":
			err = unpopulate(val, "VirtualNetworkConfiguration", &s.VirtualNetworkConfiguration)
			delete(rawMsg, key)
		case "virtualNetworkType":
			err = unpopulate(val, "VirtualNetworkType", &s.VirtualNetworkType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResource.
func (s ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "zones", s.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResource.
func (s *ServiceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &s.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceSKUProperties.
func (s ServiceSKUProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceSKUProperties.
func (s *ServiceSKUProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUpdateParameters.
func (s ServiceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "zones", s.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceUpdateParameters.
func (s *ServiceUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &s.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUpdateProperties.
func (s ServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersionConstraint", s.APIVersionConstraint)
	populate(objectMap, "additionalLocations", s.AdditionalLocations)
	populate(objectMap, "certificates", s.Certificates)
	populateDateTimeRFC3339(objectMap, "createdAtUtc", s.CreatedAtUTC)
	populate(objectMap, "customProperties", s.CustomProperties)
	populate(objectMap, "developerPortalUrl", s.DeveloperPortalURL)
	populate(objectMap, "disableGateway", s.DisableGateway)
	populate(objectMap, "enableClientCertificate", s.EnableClientCertificate)
	populate(objectMap, "gatewayRegionalUrl", s.GatewayRegionalURL)
	populate(objectMap, "gatewayUrl", s.GatewayURL)
	populate(objectMap, "hostnameConfigurations", s.HostnameConfigurations)
	populate(objectMap, "managementApiUrl", s.ManagementAPIURL)
	populate(objectMap, "natGatewayState", s.NatGatewayState)
	populate(objectMap, "notificationSenderEmail", s.NotificationSenderEmail)
	populate(objectMap, "outboundPublicIPAddresses", s.OutboundPublicIPAddresses)
	populate(objectMap, "platformVersion", s.PlatformVersion)
	populate(objectMap, "portalUrl", s.PortalURL)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "privateIPAddresses", s.PrivateIPAddresses)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "publicIpAddressId", s.PublicIPAddressID)
	populate(objectMap, "publicIPAddresses", s.PublicIPAddresses)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "publisherEmail", s.PublisherEmail)
	populate(objectMap, "publisherName", s.PublisherName)
	populate(objectMap, "restore", s.Restore)
	populate(objectMap, "scmUrl", s.ScmURL)
	populate(objectMap, "targetProvisioningState", s.TargetProvisioningState)
	populate(objectMap, "virtualNetworkConfiguration", s.VirtualNetworkConfiguration)
	populate(objectMap, "virtualNetworkType", s.VirtualNetworkType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceUpdateProperties.
func (s *ServiceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersionConstraint":
			err = unpopulate(val, "APIVersionConstraint", &s.APIVersionConstraint)
			delete(rawMsg, key)
		case "additionalLocations":
			err = unpopulate(val, "AdditionalLocations", &s.AdditionalLocations)
			delete(rawMsg, key)
		case "certificates":
			err = unpopulate(val, "Certificates", &s.Certificates)
			delete(rawMsg, key)
		case "createdAtUtc":
			err = unpopulateDateTimeRFC3339(val, "CreatedAtUTC", &s.CreatedAtUTC)
			delete(rawMsg, key)
		case "customProperties":
			err = unpopulate(val, "CustomProperties", &s.CustomProperties)
			delete(rawMsg, key)
		case "developerPortalUrl":
			err = unpopulate(val, "DeveloperPortalURL", &s.DeveloperPortalURL)
			delete(rawMsg, key)
		case "disableGateway":
			err = unpopulate(val, "DisableGateway", &s.DisableGateway)
			delete(rawMsg, key)
		case "enableClientCertificate":
			err = unpopulate(val, "EnableClientCertificate", &s.EnableClientCertificate)
			delete(rawMsg, key)
		case "gatewayRegionalUrl":
			err = unpopulate(val, "GatewayRegionalURL", &s.GatewayRegionalURL)
			delete(rawMsg, key)
		case "gatewayUrl":
			err = unpopulate(val, "GatewayURL", &s.GatewayURL)
			delete(rawMsg, key)
		case "hostnameConfigurations":
			err = unpopulate(val, "HostnameConfigurations", &s.HostnameConfigurations)
			delete(rawMsg, key)
		case "managementApiUrl":
			err = unpopulate(val, "ManagementAPIURL", &s.ManagementAPIURL)
			delete(rawMsg, key)
		case "natGatewayState":
			err = unpopulate(val, "NatGatewayState", &s.NatGatewayState)
			delete(rawMsg, key)
		case "notificationSenderEmail":
			err = unpopulate(val, "NotificationSenderEmail", &s.NotificationSenderEmail)
			delete(rawMsg, key)
		case "outboundPublicIPAddresses":
			err = unpopulate(val, "OutboundPublicIPAddresses", &s.OutboundPublicIPAddresses)
			delete(rawMsg, key)
		case "platformVersion":
			err = unpopulate(val, "PlatformVersion", &s.PlatformVersion)
			delete(rawMsg, key)
		case "portalUrl":
			err = unpopulate(val, "PortalURL", &s.PortalURL)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &s.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "privateIPAddresses":
			err = unpopulate(val, "PrivateIPAddresses", &s.PrivateIPAddresses)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "publicIpAddressId":
			err = unpopulate(val, "PublicIPAddressID", &s.PublicIPAddressID)
			delete(rawMsg, key)
		case "publicIPAddresses":
			err = unpopulate(val, "PublicIPAddresses", &s.PublicIPAddresses)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "publisherEmail":
			err = unpopulate(val, "PublisherEmail", &s.PublisherEmail)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &s.PublisherName)
			delete(rawMsg, key)
		case "restore":
			err = unpopulate(val, "Restore", &s.Restore)
			delete(rawMsg, key)
		case "scmUrl":
			err = unpopulate(val, "ScmURL", &s.ScmURL)
			delete(rawMsg, key)
		case "targetProvisioningState":
			err = unpopulate(val, "TargetProvisioningState", &s.TargetProvisioningState)
			delete(rawMsg, key)
		case "virtualNetworkConfiguration":
			err = unpopulate(val, "VirtualNetworkConfiguration", &s.VirtualNetworkConfiguration)
			delete(rawMsg, key)
		case "virtualNetworkType":
			err = unpopulate(val, "VirtualNetworkType", &s.VirtualNetworkType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionCollection.
func (s SubscriptionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", s.Count)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionCollection.
func (s *SubscriptionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionContract.
func (s SubscriptionContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionContract.
func (s *SubscriptionContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionContractProperties.
func (s SubscriptionContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowTracing", s.AllowTracing)
	populateDateTimeRFC3339(objectMap, "createdDate", s.CreatedDate)
	populate(objectMap, "displayName", s.DisplayName)
	populateDateTimeRFC3339(objectMap, "endDate", s.EndDate)
	populateDateTimeRFC3339(objectMap, "expirationDate", s.ExpirationDate)
	populateDateTimeRFC3339(objectMap, "notificationDate", s.NotificationDate)
	populate(objectMap, "ownerId", s.OwnerID)
	populate(objectMap, "primaryKey", s.PrimaryKey)
	populate(objectMap, "scope", s.Scope)
	populate(objectMap, "secondaryKey", s.SecondaryKey)
	populateDateTimeRFC3339(objectMap, "startDate", s.StartDate)
	populate(objectMap, "state", s.State)
	populate(objectMap, "stateComment", s.StateComment)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionContractProperties.
func (s *SubscriptionContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowTracing":
			err = unpopulate(val, "AllowTracing", &s.AllowTracing)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &s.CreatedDate)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "endDate":
			err = unpopulateDateTimeRFC3339(val, "EndDate", &s.EndDate)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &s.ExpirationDate)
			delete(rawMsg, key)
		case "notificationDate":
			err = unpopulateDateTimeRFC3339(val, "NotificationDate", &s.NotificationDate)
			delete(rawMsg, key)
		case "ownerId":
			err = unpopulate(val, "OwnerID", &s.OwnerID)
			delete(rawMsg, key)
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &s.PrimaryKey)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &s.Scope)
			delete(rawMsg, key)
		case "secondaryKey":
			err = unpopulate(val, "SecondaryKey", &s.SecondaryKey)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateDateTimeRFC3339(val, "StartDate", &s.StartDate)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "stateComment":
			err = unpopulate(val, "StateComment", &s.StateComment)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionCreateParameterProperties.
func (s SubscriptionCreateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowTracing", s.AllowTracing)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "ownerId", s.OwnerID)
	populate(objectMap, "primaryKey", s.PrimaryKey)
	populate(objectMap, "scope", s.Scope)
	populate(objectMap, "secondaryKey", s.SecondaryKey)
	populate(objectMap, "state", s.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionCreateParameterProperties.
func (s *SubscriptionCreateParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowTracing":
			err = unpopulate(val, "AllowTracing", &s.AllowTracing)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "ownerId":
			err = unpopulate(val, "OwnerID", &s.OwnerID)
			delete(rawMsg, key)
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &s.PrimaryKey)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &s.Scope)
			delete(rawMsg, key)
		case "secondaryKey":
			err = unpopulate(val, "SecondaryKey", &s.SecondaryKey)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionCreateParameters.
func (s SubscriptionCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionCreateParameters.
func (s *SubscriptionCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionKeyParameterNamesContract.
func (s SubscriptionKeyParameterNamesContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "header", s.Header)
	populate(objectMap, "query", s.Query)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionKeyParameterNamesContract.
func (s *SubscriptionKeyParameterNamesContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "header":
			err = unpopulate(val, "Header", &s.Header)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &s.Query)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionKeysContract.
func (s SubscriptionKeysContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primaryKey", s.PrimaryKey)
	populate(objectMap, "secondaryKey", s.SecondaryKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionKeysContract.
func (s *SubscriptionKeysContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &s.PrimaryKey)
			delete(rawMsg, key)
		case "secondaryKey":
			err = unpopulate(val, "SecondaryKey", &s.SecondaryKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionUpdateParameterProperties.
func (s SubscriptionUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowTracing", s.AllowTracing)
	populate(objectMap, "displayName", s.DisplayName)
	populateDateTimeRFC3339(objectMap, "expirationDate", s.ExpirationDate)
	populate(objectMap, "ownerId", s.OwnerID)
	populate(objectMap, "primaryKey", s.PrimaryKey)
	populate(objectMap, "scope", s.Scope)
	populate(objectMap, "secondaryKey", s.SecondaryKey)
	populate(objectMap, "state", s.State)
	populate(objectMap, "stateComment", s.StateComment)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionUpdateParameterProperties.
func (s *SubscriptionUpdateParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowTracing":
			err = unpopulate(val, "AllowTracing", &s.AllowTracing)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &s.ExpirationDate)
			delete(rawMsg, key)
		case "ownerId":
			err = unpopulate(val, "OwnerID", &s.OwnerID)
			delete(rawMsg, key)
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &s.PrimaryKey)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &s.Scope)
			delete(rawMsg, key)
		case "secondaryKey":
			err = unpopulate(val, "SecondaryKey", &s.SecondaryKey)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "stateComment":
			err = unpopulate(val, "StateComment", &s.StateComment)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionUpdateParameters.
func (s SubscriptionUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionUpdateParameters.
func (s *SubscriptionUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionsDelegationSettingsProperties.
func (s SubscriptionsDelegationSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", s.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionsDelegationSettingsProperties.
func (s *SubscriptionsDelegationSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &s.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagCollection.
func (t TagCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", t.Count)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagCollection.
func (t *TagCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &t.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagContract.
func (t TagContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagContract.
func (t *TagContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagContractProperties.
func (t TagContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", t.DisplayName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagContractProperties.
func (t *TagContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &t.DisplayName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagCreateUpdateParameters.
func (t TagCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", t.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagCreateUpdateParameters.
func (t *TagCreateUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagDescriptionBaseProperties.
func (t TagDescriptionBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", t.Description)
	populate(objectMap, "externalDocsDescription", t.ExternalDocsDescription)
	populate(objectMap, "externalDocsUrl", t.ExternalDocsURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagDescriptionBaseProperties.
func (t *TagDescriptionBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &t.Description)
			delete(rawMsg, key)
		case "externalDocsDescription":
			err = unpopulate(val, "ExternalDocsDescription", &t.ExternalDocsDescription)
			delete(rawMsg, key)
		case "externalDocsUrl":
			err = unpopulate(val, "ExternalDocsURL", &t.ExternalDocsURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagDescriptionCollection.
func (t TagDescriptionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", t.Count)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagDescriptionCollection.
func (t *TagDescriptionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &t.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagDescriptionContract.
func (t TagDescriptionContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagDescriptionContract.
func (t *TagDescriptionContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagDescriptionContractProperties.
func (t TagDescriptionContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", t.Description)
	populate(objectMap, "displayName", t.DisplayName)
	populate(objectMap, "externalDocsDescription", t.ExternalDocsDescription)
	populate(objectMap, "externalDocsUrl", t.ExternalDocsURL)
	populate(objectMap, "tagId", t.TagID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagDescriptionContractProperties.
func (t *TagDescriptionContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &t.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &t.DisplayName)
			delete(rawMsg, key)
		case "externalDocsDescription":
			err = unpopulate(val, "ExternalDocsDescription", &t.ExternalDocsDescription)
			delete(rawMsg, key)
		case "externalDocsUrl":
			err = unpopulate(val, "ExternalDocsURL", &t.ExternalDocsURL)
			delete(rawMsg, key)
		case "tagId":
			err = unpopulate(val, "TagID", &t.TagID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagDescriptionCreateParameters.
func (t TagDescriptionCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", t.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagDescriptionCreateParameters.
func (t *TagDescriptionCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagResourceCollection.
func (t TagResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", t.Count)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagResourceCollection.
func (t *TagResourceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &t.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagResourceContract.
func (t TagResourceContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "api", t.API)
	populate(objectMap, "operation", t.Operation)
	populate(objectMap, "product", t.Product)
	populate(objectMap, "tag", t.Tag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagResourceContract.
func (t *TagResourceContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "api":
			err = unpopulate(val, "API", &t.API)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &t.Operation)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &t.Product)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &t.Tag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagResourceContractProperties.
func (t TagResourceContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagResourceContractProperties.
func (t *TagResourceContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TenantConfigurationSyncStateContract.
func (t TenantConfigurationSyncStateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TenantConfigurationSyncStateContract.
func (t *TenantConfigurationSyncStateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TenantConfigurationSyncStateContractProperties.
func (t TenantConfigurationSyncStateContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "branch", t.Branch)
	populate(objectMap, "commitId", t.CommitID)
	populateDateTimeRFC3339(objectMap, "configurationChangeDate", t.ConfigurationChangeDate)
	populate(objectMap, "isExport", t.IsExport)
	populate(objectMap, "isGitEnabled", t.IsGitEnabled)
	populate(objectMap, "isSynced", t.IsSynced)
	populate(objectMap, "lastOperationId", t.LastOperationID)
	populateDateTimeRFC3339(objectMap, "syncDate", t.SyncDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TenantConfigurationSyncStateContractProperties.
func (t *TenantConfigurationSyncStateContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "branch":
			err = unpopulate(val, "Branch", &t.Branch)
			delete(rawMsg, key)
		case "commitId":
			err = unpopulate(val, "CommitID", &t.CommitID)
			delete(rawMsg, key)
		case "configurationChangeDate":
			err = unpopulateDateTimeRFC3339(val, "ConfigurationChangeDate", &t.ConfigurationChangeDate)
			delete(rawMsg, key)
		case "isExport":
			err = unpopulate(val, "IsExport", &t.IsExport)
			delete(rawMsg, key)
		case "isGitEnabled":
			err = unpopulate(val, "IsGitEnabled", &t.IsGitEnabled)
			delete(rawMsg, key)
		case "isSynced":
			err = unpopulate(val, "IsSynced", &t.IsSynced)
			delete(rawMsg, key)
		case "lastOperationId":
			err = unpopulate(val, "LastOperationID", &t.LastOperationID)
			delete(rawMsg, key)
		case "syncDate":
			err = unpopulateDateTimeRFC3339(val, "SyncDate", &t.SyncDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TenantSettingsCollection.
func (t TenantSettingsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TenantSettingsCollection.
func (t *TenantSettingsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TenantSettingsContract.
func (t TenantSettingsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TenantSettingsContract.
func (t *TenantSettingsContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TenantSettingsContractProperties.
func (t TenantSettingsContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "settings", t.Settings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TenantSettingsContractProperties.
func (t *TenantSettingsContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "settings":
			err = unpopulate(val, "Settings", &t.Settings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TermsOfServiceProperties.
func (t TermsOfServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consentRequired", t.ConsentRequired)
	populate(objectMap, "enabled", t.Enabled)
	populate(objectMap, "text", t.Text)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TermsOfServiceProperties.
func (t *TermsOfServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consentRequired":
			err = unpopulate(val, "ConsentRequired", &t.ConsentRequired)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &t.Enabled)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &t.Text)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TokenBodyParameterContract.
func (t TokenBodyParameterContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TokenBodyParameterContract.
func (t *TokenBodyParameterContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserCollection.
func (u UserCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", u.Count)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserCollection.
func (u *UserCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &u.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserContract.
func (u UserContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserContract.
func (u *UserContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserContractProperties.
func (u UserContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "email", u.Email)
	populate(objectMap, "firstName", u.FirstName)
	populate(objectMap, "groups", u.Groups)
	populate(objectMap, "identities", u.Identities)
	populate(objectMap, "lastName", u.LastName)
	populate(objectMap, "note", u.Note)
	populateDateTimeRFC3339(objectMap, "registrationDate", u.RegistrationDate)
	populate(objectMap, "state", u.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserContractProperties.
func (u *UserContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "email":
			err = unpopulate(val, "Email", &u.Email)
			delete(rawMsg, key)
		case "firstName":
			err = unpopulate(val, "FirstName", &u.FirstName)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &u.Groups)
			delete(rawMsg, key)
		case "identities":
			err = unpopulate(val, "Identities", &u.Identities)
			delete(rawMsg, key)
		case "lastName":
			err = unpopulate(val, "LastName", &u.LastName)
			delete(rawMsg, key)
		case "note":
			err = unpopulate(val, "Note", &u.Note)
			delete(rawMsg, key)
		case "registrationDate":
			err = unpopulateDateTimeRFC3339(val, "RegistrationDate", &u.RegistrationDate)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &u.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserCreateParameterProperties.
func (u UserCreateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appType", u.AppType)
	populate(objectMap, "confirmation", u.Confirmation)
	populate(objectMap, "email", u.Email)
	populate(objectMap, "firstName", u.FirstName)
	populate(objectMap, "identities", u.Identities)
	populate(objectMap, "lastName", u.LastName)
	populate(objectMap, "note", u.Note)
	populate(objectMap, "password", u.Password)
	populate(objectMap, "state", u.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserCreateParameterProperties.
func (u *UserCreateParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appType":
			err = unpopulate(val, "AppType", &u.AppType)
			delete(rawMsg, key)
		case "confirmation":
			err = unpopulate(val, "Confirmation", &u.Confirmation)
			delete(rawMsg, key)
		case "email":
			err = unpopulate(val, "Email", &u.Email)
			delete(rawMsg, key)
		case "firstName":
			err = unpopulate(val, "FirstName", &u.FirstName)
			delete(rawMsg, key)
		case "identities":
			err = unpopulate(val, "Identities", &u.Identities)
			delete(rawMsg, key)
		case "lastName":
			err = unpopulate(val, "LastName", &u.LastName)
			delete(rawMsg, key)
		case "note":
			err = unpopulate(val, "Note", &u.Note)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &u.Password)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &u.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserCreateParameters.
func (u UserCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserCreateParameters.
func (u *UserCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserEntityBaseParameters.
func (u UserEntityBaseParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identities", u.Identities)
	populate(objectMap, "note", u.Note)
	populate(objectMap, "state", u.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserEntityBaseParameters.
func (u *UserEntityBaseParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identities":
			err = unpopulate(val, "Identities", &u.Identities)
			delete(rawMsg, key)
		case "note":
			err = unpopulate(val, "Note", &u.Note)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &u.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserIdentityCollection.
func (u UserIdentityCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", u.Count)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserIdentityCollection.
func (u *UserIdentityCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &u.Count)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserIdentityContract.
func (u UserIdentityContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "provider", u.Provider)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserIdentityContract.
func (u *UserIdentityContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &u.Provider)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserIdentityProperties.
func (u UserIdentityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserIdentityProperties.
func (u *UserIdentityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserTokenParameterProperties.
func (u UserTokenParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expiry", u.Expiry)
	populate(objectMap, "keyType", u.KeyType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserTokenParameterProperties.
func (u *UserTokenParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiry":
			err = unpopulateDateTimeRFC3339(val, "Expiry", &u.Expiry)
			delete(rawMsg, key)
		case "keyType":
			err = unpopulate(val, "KeyType", &u.KeyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserTokenParameters.
func (u UserTokenParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserTokenParameters.
func (u *UserTokenParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserTokenResult.
func (u UserTokenResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserTokenResult.
func (u *UserTokenResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserUpdateParameters.
func (u UserUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserUpdateParameters.
func (u *UserUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserUpdateParametersProperties.
func (u UserUpdateParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "email", u.Email)
	populate(objectMap, "firstName", u.FirstName)
	populate(objectMap, "identities", u.Identities)
	populate(objectMap, "lastName", u.LastName)
	populate(objectMap, "note", u.Note)
	populate(objectMap, "password", u.Password)
	populate(objectMap, "state", u.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserUpdateParametersProperties.
func (u *UserUpdateParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "email":
			err = unpopulate(val, "Email", &u.Email)
			delete(rawMsg, key)
		case "firstName":
			err = unpopulate(val, "FirstName", &u.FirstName)
			delete(rawMsg, key)
		case "identities":
			err = unpopulate(val, "Identities", &u.Identities)
			delete(rawMsg, key)
		case "lastName":
			err = unpopulate(val, "LastName", &u.LastName)
			delete(rawMsg, key)
		case "note":
			err = unpopulate(val, "Note", &u.Note)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &u.Password)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &u.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkConfiguration.
func (v VirtualNetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subnetResourceId", v.SubnetResourceID)
	populate(objectMap, "subnetname", v.Subnetname)
	populate(objectMap, "vnetid", v.Vnetid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkConfiguration.
func (v *VirtualNetworkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subnetResourceId":
			err = unpopulate(val, "SubnetResourceID", &v.SubnetResourceID)
			delete(rawMsg, key)
		case "subnetname":
			err = unpopulate(val, "Subnetname", &v.Subnetname)
			delete(rawMsg, key)
		case "vnetid":
			err = unpopulate(val, "Vnetid", &v.Vnetid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WikiCollection.
func (w WikiCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WikiCollection.
func (w *WikiCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WikiContract.
func (w WikiContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WikiContract.
func (w *WikiContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WikiContractProperties.
func (w WikiContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "documents", w.Documents)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WikiContractProperties.
func (w *WikiContractProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "documents":
			err = unpopulate(val, "Documents", &w.Documents)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WikiDocumentationContract.
func (w WikiDocumentationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "documentationId", w.DocumentationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WikiDocumentationContract.
func (w *WikiDocumentationContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "documentationId":
			err = unpopulate(val, "DocumentationID", &w.DocumentationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WikiUpdateContract.
func (w WikiUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", w.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WikiUpdateContract.
func (w *WikiUpdateContract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X509CertificateName.
func (x X509CertificateName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "issuerCertificateThumbprint", x.IssuerCertificateThumbprint)
	populate(objectMap, "name", x.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X509CertificateName.
func (x *X509CertificateName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "issuerCertificateThumbprint":
			err = unpopulate(val, "IssuerCertificateThumbprint", &x.IssuerCertificateThumbprint)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &x.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
