//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managednetworkfabric/armmanagednetworkfabric"
	"net/http"
	"net/url"
	"regexp"
)

// NetworkDeviceSKUsServer is a fake server for instances of the armmanagednetworkfabric.NetworkDeviceSKUsClient type.
type NetworkDeviceSKUsServer struct {
	// Get is the fake for method NetworkDeviceSKUsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, networkDeviceSKUName string, options *armmanagednetworkfabric.NetworkDeviceSKUsClientGetOptions) (resp azfake.Responder[armmanagednetworkfabric.NetworkDeviceSKUsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySubscriptionPager is the fake for method NetworkDeviceSKUsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armmanagednetworkfabric.NetworkDeviceSKUsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armmanagednetworkfabric.NetworkDeviceSKUsClientListBySubscriptionResponse])
}

// NewNetworkDeviceSKUsServerTransport creates a new instance of NetworkDeviceSKUsServerTransport with the provided implementation.
// The returned NetworkDeviceSKUsServerTransport instance is connected to an instance of armmanagednetworkfabric.NetworkDeviceSKUsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewNetworkDeviceSKUsServerTransport(srv *NetworkDeviceSKUsServer) *NetworkDeviceSKUsServerTransport {
	return &NetworkDeviceSKUsServerTransport{
		srv:                        srv,
		newListBySubscriptionPager: newTracker[azfake.PagerResponder[armmanagednetworkfabric.NetworkDeviceSKUsClientListBySubscriptionResponse]](),
	}
}

// NetworkDeviceSKUsServerTransport connects instances of armmanagednetworkfabric.NetworkDeviceSKUsClient to instances of NetworkDeviceSKUsServer.
// Don't use this type directly, use NewNetworkDeviceSKUsServerTransport instead.
type NetworkDeviceSKUsServerTransport struct {
	srv                        *NetworkDeviceSKUsServer
	newListBySubscriptionPager *tracker[azfake.PagerResponder[armmanagednetworkfabric.NetworkDeviceSKUsClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for NetworkDeviceSKUsServerTransport.
func (n *NetworkDeviceSKUsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "NetworkDeviceSKUsClient.Get":
		resp, err = n.dispatchGet(req)
	case "NetworkDeviceSKUsClient.NewListBySubscriptionPager":
		resp, err = n.dispatchNewListBySubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (n *NetworkDeviceSKUsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if n.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkDeviceSkus/(?P<networkDeviceSkuName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	networkDeviceSKUNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkDeviceSkuName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.Get(req.Context(), networkDeviceSKUNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkDeviceSKU, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (n *NetworkDeviceSKUsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if n.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := n.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkDeviceSkus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := n.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		n.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armmanagednetworkfabric.NetworkDeviceSKUsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		n.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		n.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}
