//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ApplicationWhitelistings/GetAdaptiveApplicationControlsSubscription_example.json
func ExampleAdaptiveApplicationControlsClient_List() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAdaptiveApplicationControlsClient().List(ctx, &armsecurity.AdaptiveApplicationControlsClientListOptions{IncludePathRecommendations: to.Ptr(true),
		Summary: to.Ptr(false),
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AdaptiveApplicationControlGroups = armsecurity.AdaptiveApplicationControlGroups{
	// 	Value: []*armsecurity.AdaptiveApplicationControlGroup{
	// 		{
	// 			Location: to.Ptr("centralus"),
	// 			Name: to.Ptr("AMIT-VA"),
	// 			Type: to.Ptr("Microsoft.Security/applicationWhitelistings"),
	// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/locations/centralus/applicationWhitelistings/AMIT-VA"),
	// 			Properties: &armsecurity.AdaptiveApplicationControlGroupData{
	// 				ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 				EnforcementMode: to.Ptr(armsecurity.EnforcementModeAudit),
	// 				Issues: []*armsecurity.AdaptiveApplicationControlIssueSummary{
	// 				},
	// 				PathRecommendations: []*armsecurity.PathRecommendation{
	// 					{
	// 						Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 						Path: to.Ptr("C:\\Windows\\SoftwareDistribution\\Download\\Install\\Windows-KB890830-x64-V5.53-delta.exe"),
	// 						Action: to.Ptr(armsecurity.RecommendationActionRemove),
	// 						Common: to.Ptr(true),
	// 						ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusNoStatus),
	// 						FileType: to.Ptr(armsecurity.FileTypeExe),
	// 						UserSids: []*string{
	// 							to.Ptr("S-1-5-18")},
	// 							Usernames: []*armsecurity.UserRecommendation{
	// 								{
	// 									RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 									Username: to.Ptr("LOCAL SYSTEM"),
	// 							}},
	// 						},
	// 						{
	// 							Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 							Path: to.Ptr("C:\\WindowsAzure\\GuestAgent_2.7.1198.822\\CollectGuestLogs.exe"),
	// 							Action: to.Ptr(armsecurity.RecommendationActionRemove),
	// 							Common: to.Ptr(true),
	// 							ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusNoStatus),
	// 							FileType: to.Ptr(armsecurity.FileTypeExe),
	// 							UserSids: []*string{
	// 								to.Ptr("S-1-5-18")},
	// 								Usernames: []*armsecurity.UserRecommendation{
	// 									{
	// 										RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 										Username: to.Ptr("LOCAL SYSTEM"),
	// 								}},
	// 							},
	// 							{
	// 								Type: to.Ptr(armsecurity.RecommendationType("PublisherSignature")),
	// 								Path: to.Ptr("C:\\Windows\\System32\\wbem\\WmiPrvSE.exe"),
	// 								Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 								Common: to.Ptr(true),
	// 								ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 								FileType: to.Ptr(armsecurity.FileTypeExe),
	// 								PublisherInfo: &armsecurity.PublisherInfo{
	// 									BinaryName: to.Ptr("*"),
	// 									ProductName: to.Ptr("*"),
	// 									PublisherName: to.Ptr("O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US"),
	// 									Version: to.Ptr("0.0.0.0"),
	// 								},
	// 								UserSids: []*string{
	// 									to.Ptr("S-1-5-18"),
	// 									to.Ptr("S-1-1-0")},
	// 									Usernames: []*armsecurity.UserRecommendation{
	// 										{
	// 											RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 											Username: to.Ptr("Everyone"),
	// 									}},
	// 								},
	// 								{
	// 									Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 									Path: to.Ptr("%OSDRIVE%\\WINDOWSAZURE\\SECAGENT\\WASECAGENTPROV.EXE"),
	// 									Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 									Common: to.Ptr(true),
	// 									ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 									FileType: to.Ptr(armsecurity.FileTypeExe),
	// 									UserSids: []*string{
	// 										to.Ptr("S-1-1-0")},
	// 										Usernames: []*armsecurity.UserRecommendation{
	// 											{
	// 												RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 												Username: to.Ptr("Everyone"),
	// 										}},
	// 								}},
	// 								ProtectionMode: &armsecurity.ProtectionMode{
	// 									Exe: to.Ptr(armsecurity.EnforcementModeAudit),
	// 									Msi: to.Ptr(armsecurity.EnforcementModeAudit),
	// 									Script: to.Ptr(armsecurity.EnforcementModeNone),
	// 								},
	// 								RecommendationStatus: to.Ptr(armsecurity.RecommendationStatusRecommended),
	// 								SourceSystem: to.Ptr(armsecurity.SourceSystemAzureAppLocker),
	// 								VMRecommendations: []*armsecurity.VMRecommendation{
	// 									{
	// 										ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 										EnforcementSupport: to.Ptr(armsecurity.EnforcementSupportSupported),
	// 										RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 										ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/erelh-dsc/providers/microsoft.compute/virtualmachines/erelh-14011"),
	// 									},
	// 									{
	// 										ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 										EnforcementSupport: to.Ptr(armsecurity.EnforcementSupportSupported),
	// 										RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 										ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/amit-va/providers/microsoft.compute/virtualmachines/ream-test"),
	// 									},
	// 									{
	// 										ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 										EnforcementSupport: to.Ptr(armsecurity.EnforcementSupportSupported),
	// 										RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 										ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/v-arrikl-scheduledapps/providers/microsoft.compute/virtualmachines/v-arrikl-14060"),
	// 								}},
	// 							},
	// 						},
	// 						{
	// 							Location: to.Ptr("centralus"),
	// 							Name: to.Ptr("ERELGROUP1"),
	// 							Type: to.Ptr("Microsoft.Security/applicationWhitelistings"),
	// 							ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/locations/centralus/applicationWhitelistings/ERELGROUP1"),
	// 							Properties: &armsecurity.AdaptiveApplicationControlGroupData{
	// 								ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 								EnforcementMode: to.Ptr(armsecurity.EnforcementModeAudit),
	// 								Issues: []*armsecurity.AdaptiveApplicationControlIssueSummary{
	// 								},
	// 								PathRecommendations: []*armsecurity.PathRecommendation{
	// 									{
	// 										Type: to.Ptr(armsecurity.RecommendationType("PublisherSignature")),
	// 										Path: to.Ptr("[Exe] O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US\\*\\*\\0.0.0.0"),
	// 										Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 										Common: to.Ptr(true),
	// 										ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 										FileType: to.Ptr(armsecurity.FileTypeExe),
	// 										PublisherInfo: &armsecurity.PublisherInfo{
	// 											BinaryName: to.Ptr("*"),
	// 											ProductName: to.Ptr("*"),
	// 											PublisherName: to.Ptr("O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US"),
	// 											Version: to.Ptr("0.0.0.0"),
	// 										},
	// 										UserSids: []*string{
	// 											to.Ptr("S-1-1-0")},
	// 											Usernames: []*armsecurity.UserRecommendation{
	// 												{
	// 													RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 													Username: to.Ptr("Everyone"),
	// 											}},
	// 									}},
	// 									ProtectionMode: &armsecurity.ProtectionMode{
	// 										Exe: to.Ptr(armsecurity.EnforcementModeAudit),
	// 										Msi: to.Ptr(armsecurity.EnforcementModeNone),
	// 										Script: to.Ptr(armsecurity.EnforcementModeNone),
	// 									},
	// 									RecommendationStatus: to.Ptr(armsecurity.RecommendationStatusRecommended),
	// 									SourceSystem: to.Ptr(armsecurity.SourceSystemAzureAppLocker),
	// 									VMRecommendations: []*armsecurity.VMRecommendation{
	// 										{
	// 											ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 											EnforcementSupport: to.Ptr(armsecurity.EnforcementSupportNotSupported),
	// 											RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 											ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/erelh-stable/providers/microsoft.compute/virtualmachines/erelh-16090"),
	// 									}},
	// 								},
	// 							},
	// 							{
	// 								Location: to.Ptr("centralus"),
	// 								Name: to.Ptr("GROUP1"),
	// 								Type: to.Ptr("Microsoft.Security/applicationWhitelistings"),
	// 								ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/locations/centralus/applicationWhitelistings/GROUP1"),
	// 								Properties: &armsecurity.AdaptiveApplicationControlGroupData{
	// 									ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 									EnforcementMode: to.Ptr(armsecurity.EnforcementModeAudit),
	// 									Issues: []*armsecurity.AdaptiveApplicationControlIssueSummary{
	// 									},
	// 									PathRecommendations: []*armsecurity.PathRecommendation{
	// 										{
	// 											Type: to.Ptr(armsecurity.RecommendationType("PublisherSignature")),
	// 											Path: to.Ptr("[Exe] O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US\\*\\*\\0.0.0.0"),
	// 											Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 											Common: to.Ptr(true),
	// 											ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 											FileType: to.Ptr(armsecurity.FileTypeExe),
	// 											PublisherInfo: &armsecurity.PublisherInfo{
	// 												BinaryName: to.Ptr("*"),
	// 												ProductName: to.Ptr("*"),
	// 												PublisherName: to.Ptr("O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US"),
	// 												Version: to.Ptr("0.0.0.0"),
	// 											},
	// 											UserSids: []*string{
	// 												to.Ptr("S-1-1-0")},
	// 												Usernames: []*armsecurity.UserRecommendation{
	// 													{
	// 														RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 														Username: to.Ptr("Everyone"),
	// 												}},
	// 											},
	// 											{
	// 												Type: to.Ptr(armsecurity.RecommendationType("ProductSignature")),
	// 												Path: to.Ptr("%OSDRIVE%\\WINDOWSAZURE\\SECAGENT\\WASECAGENTPROV.EXE"),
	// 												Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 												Common: to.Ptr(true),
	// 												ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 												FileType: to.Ptr(armsecurity.FileTypeExe),
	// 												PublisherInfo: &armsecurity.PublisherInfo{
	// 													BinaryName: to.Ptr("*"),
	// 													ProductName: to.Ptr("MICROSOFT® COREXT"),
	// 													PublisherName: to.Ptr("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN"),
	// 													Version: to.Ptr("0.0.0.0"),
	// 												},
	// 												UserSids: []*string{
	// 													to.Ptr("S-1-1-0")},
	// 													Usernames: []*armsecurity.UserRecommendation{
	// 														{
	// 															RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 															Username: to.Ptr("NT AUTHORITY\\SYSTEM"),
	// 													}},
	// 												},
	// 												{
	// 													Type: to.Ptr(armsecurity.RecommendationType("PublisherSignature")),
	// 													Path: to.Ptr("%PROGRAMFILES%\\RAPID7\\INSIGHT AGENT\\COMPONENTS\\INSIGHT_AGENT\\2.6.7.9\\GET_PROXY.EXE"),
	// 													Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 													Common: to.Ptr(true),
	// 													ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 													FileType: to.Ptr(armsecurity.FileTypeExe),
	// 													PublisherInfo: &armsecurity.PublisherInfo{
	// 														BinaryName: to.Ptr("*"),
	// 														ProductName: to.Ptr("*"),
	// 														PublisherName: to.Ptr("O=RAPID7 LLC, L=BOSTON, S=MASSACHUSETTS, C=US"),
	// 														Version: to.Ptr("0.0.0.0"),
	// 													},
	// 													UserSids: []*string{
	// 														to.Ptr("S-1-1-0")},
	// 														Usernames: []*armsecurity.UserRecommendation{
	// 															{
	// 																RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																Username: to.Ptr("NT AUTHORITY\\SYSTEM"),
	// 														}},
	// 													},
	// 													{
	// 														Type: to.Ptr(armsecurity.RecommendationType("ProductSignature")),
	// 														Path: to.Ptr("%PROGRAMFILES%\\GOOGLE\\CHROME\\APPLICATION\\CHROME.EXE"),
	// 														Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 														Common: to.Ptr(true),
	// 														ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 														FileType: to.Ptr(armsecurity.FileTypeExe),
	// 														PublisherInfo: &armsecurity.PublisherInfo{
	// 															BinaryName: to.Ptr("*"),
	// 															ProductName: to.Ptr("GOOGLE CHROME"),
	// 															PublisherName: to.Ptr("O=GOOGLE LLC, L=MOUNTAIN VIEW, S=CA, C=US"),
	// 															Version: to.Ptr("0.0.0.0"),
	// 														},
	// 														UserSids: []*string{
	// 															to.Ptr("S-1-1-0")},
	// 															Usernames: []*armsecurity.UserRecommendation{
	// 																{
	// 																	RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																	Username: to.Ptr("NT AUTHORITY\\SYSTEM"),
	// 															}},
	// 														},
	// 														{
	// 															Type: to.Ptr(armsecurity.RecommendationType("ProductSignature")),
	// 															Path: to.Ptr("O=GOOGLE INC, L=MOUNTAIN VIEW, S=CALIFORNIA, C=US\\GOOGLE UPDATE\\*\\0.0.0.0"),
	// 															Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 															Common: to.Ptr(true),
	// 															ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 															FileType: to.Ptr(armsecurity.FileTypeExe),
	// 															PublisherInfo: &armsecurity.PublisherInfo{
	// 																BinaryName: to.Ptr("*"),
	// 																ProductName: to.Ptr("GOOGLE UPDATE"),
	// 																PublisherName: to.Ptr("O=GOOGLE INC, L=MOUNTAIN VIEW, S=CALIFORNIA, C=US"),
	// 																Version: to.Ptr("0.0.0.0"),
	// 															},
	// 															UserSids: []*string{
	// 																to.Ptr("S-1-1-0")},
	// 																Usernames: []*armsecurity.UserRecommendation{
	// 																	{
	// 																		RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																		Username: to.Ptr("NT AUTHORITY\\SYSTEM"),
	// 																}},
	// 														}},
	// 														ProtectionMode: &armsecurity.ProtectionMode{
	// 															Exe: to.Ptr(armsecurity.EnforcementModeAudit),
	// 															Msi: to.Ptr(armsecurity.EnforcementModeNone),
	// 															Script: to.Ptr(armsecurity.EnforcementModeNone),
	// 														},
	// 														RecommendationStatus: to.Ptr(armsecurity.RecommendationStatusRecommended),
	// 														SourceSystem: to.Ptr(armsecurity.SourceSystemAzureAppLocker),
	// 														VMRecommendations: []*armsecurity.VMRecommendation{
	// 															{
	// 																ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																EnforcementSupport: to.Ptr(armsecurity.EnforcementSupportSupported),
	// 																RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/talk-va/providers/microsoft.compute/virtualmachines/tal-win-vm"),
	// 															},
	// 															{
	// 																ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																EnforcementSupport: to.Ptr(armsecurity.EnforcementSupportSupported),
	// 																RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/talk-va/providers/microsoft.compute/virtualmachines/tal-win-vm-jit"),
	// 															},
	// 															{
	// 																ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																EnforcementSupport: to.Ptr(armsecurity.EnforcementSupportSupported),
	// 																RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/myresourcegroup/providers/microsoft.compute/virtualmachines/myvmweb"),
	// 															},
	// 															{
	// 																ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																EnforcementSupport: to.Ptr(armsecurity.EnforcementSupportSupported),
	// 																RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/v-arrikl-scheduledapps/providers/microsoft.compute/virtualmachines/v-arrikl-14061"),
	// 														}},
	// 													},
	// 												},
	// 												{
	// 													Location: to.Ptr("westeurope"),
	// 													Name: to.Ptr("GROUP1"),
	// 													Type: to.Ptr("Microsoft.Security/applicationWhitelistings"),
	// 													ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/locations/westeurope/applicationWhitelistings/GROUP1"),
	// 													Properties: &armsecurity.AdaptiveApplicationControlGroupData{
	// 														ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 														EnforcementMode: to.Ptr(armsecurity.EnforcementModeAudit),
	// 														Issues: []*armsecurity.AdaptiveApplicationControlIssueSummary{
	// 															{
	// 																Issue: to.Ptr(armsecurity.AdaptiveApplicationControlIssueExecutableViolationsAudited),
	// 																NumberOfVMs: to.Ptr[float32](1),
	// 														}},
	// 														PathRecommendations: []*armsecurity.PathRecommendation{
	// 															{
	// 																Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																Path: to.Ptr("/sbin/init"),
	// 																Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																Common: to.Ptr(true),
	// 																ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																UserSids: []*string{
	// 																	to.Ptr("S-1-1-0")},
	// 																	Usernames: []*armsecurity.UserRecommendation{
	// 																		{
	// 																			RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																			Username: to.Ptr("root"),
	// 																	}},
	// 																},
	// 																{
	// 																	Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																	Path: to.Ptr("/sbin/upstart-udev-bridge"),
	// 																	Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																	Common: to.Ptr(true),
	// 																	ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																	FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																	UserSids: []*string{
	// 																		to.Ptr("S-1-1-0")},
	// 																		Usernames: []*armsecurity.UserRecommendation{
	// 																			{
	// 																				RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																				Username: to.Ptr("root"),
	// 																		}},
	// 																	},
	// 																	{
	// 																		Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																		Path: to.Ptr("/lib/systemd/systemd-udevd"),
	// 																		Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																		Common: to.Ptr(true),
	// 																		ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																		FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																		UserSids: []*string{
	// 																			to.Ptr("S-1-1-0")},
	// 																			Usernames: []*armsecurity.UserRecommendation{
	// 																				{
	// 																					RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																					Username: to.Ptr("root"),
	// 																			}},
	// 																		},
	// 																		{
	// 																			Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																			Path: to.Ptr("/sbin/upstart-socket-bridge"),
	// 																			Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																			Common: to.Ptr(true),
	// 																			ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																			FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																			UserSids: []*string{
	// 																				to.Ptr("S-1-1-0")},
	// 																				Usernames: []*armsecurity.UserRecommendation{
	// 																					{
	// 																						RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																						Username: to.Ptr("root"),
	// 																				}},
	// 																			},
	// 																			{
	// 																				Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																				Path: to.Ptr("/sbin/dhclient"),
	// 																				Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																				Common: to.Ptr(true),
	// 																				ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																				FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																				UserSids: []*string{
	// 																					to.Ptr("S-1-1-0")},
	// 																					Usernames: []*armsecurity.UserRecommendation{
	// 																						{
	// 																							RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																							Username: to.Ptr("root"),
	// 																					}},
	// 																				},
	// 																				{
	// 																					Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																					Path: to.Ptr("/usr/bin/python3.4"),
	// 																					Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																					Common: to.Ptr(true),
	// 																					ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																					FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																					UserSids: []*string{
	// 																						to.Ptr("S-1-1-0")},
	// 																						Usernames: []*armsecurity.UserRecommendation{
	// 																							{
	// 																								RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																								Username: to.Ptr("root"),
	// 																						}},
	// 																					},
	// 																					{
	// 																						Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																						Path: to.Ptr("/sbin/upstart-file-bridge"),
	// 																						Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																						Common: to.Ptr(true),
	// 																						ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																						FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																						UserSids: []*string{
	// 																							to.Ptr("S-1-1-0")},
	// 																							Usernames: []*armsecurity.UserRecommendation{
	// 																								{
	// 																									RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																									Username: to.Ptr("root"),
	// 																							}},
	// 																						},
	// 																						{
	// 																							Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																							Path: to.Ptr("/bin/dbus-daemon"),
	// 																							Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																							Common: to.Ptr(true),
	// 																							ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																							FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																							UserSids: []*string{
	// 																								to.Ptr("S-1-1-0")},
	// 																								Usernames: []*armsecurity.UserRecommendation{
	// 																									{
	// 																										RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																										Username: to.Ptr("messagebus"),
	// 																								}},
	// 																							},
	// 																							{
	// 																								Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																								Path: to.Ptr("/lib/systemd/systemd-logind"),
	// 																								Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																								Common: to.Ptr(true),
	// 																								ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																								FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																								UserSids: []*string{
	// 																									to.Ptr("S-1-1-0")},
	// 																									Usernames: []*armsecurity.UserRecommendation{
	// 																										{
	// 																											RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																											Username: to.Ptr("root"),
	// 																									}},
	// 																								},
	// 																								{
	// 																									Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																									Path: to.Ptr("/sbin/getty"),
	// 																									Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																									Common: to.Ptr(true),
	// 																									ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																									FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																									UserSids: []*string{
	// 																										to.Ptr("S-1-1-0")},
	// 																										Usernames: []*armsecurity.UserRecommendation{
	// 																											{
	// 																												RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																												Username: to.Ptr("root"),
	// 																										}},
	// 																									},
	// 																									{
	// 																										Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																										Path: to.Ptr("/usr/sbin/atd"),
	// 																										Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																										Common: to.Ptr(true),
	// 																										ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																										FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																										UserSids: []*string{
	// 																											to.Ptr("S-1-1-0")},
	// 																											Usernames: []*armsecurity.UserRecommendation{
	// 																												{
	// 																													RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																													Username: to.Ptr("root"),
	// 																											}},
	// 																										},
	// 																										{
	// 																											Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																											Path: to.Ptr("/usr/sbin/cron"),
	// 																											Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																											Common: to.Ptr(true),
	// 																											ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																											FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																											UserSids: []*string{
	// 																												to.Ptr("S-1-1-0")},
	// 																												Usernames: []*armsecurity.UserRecommendation{
	// 																													{
	// 																														RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																														Username: to.Ptr("root"),
	// 																												}},
	// 																											},
	// 																											{
	// 																												Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																												Path: to.Ptr("/usr/sbin/acpid"),
	// 																												Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																												Common: to.Ptr(true),
	// 																												ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																												FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																												UserSids: []*string{
	// 																													to.Ptr("S-1-1-0")},
	// 																													Usernames: []*armsecurity.UserRecommendation{
	// 																														{
	// 																															RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																															Username: to.Ptr("root"),
	// 																													}},
	// 																												},
	// 																												{
	// 																													Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																													Path: to.Ptr("/usr/sbin/sshd"),
	// 																													Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																													Common: to.Ptr(true),
	// 																													ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																													FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																													UserSids: []*string{
	// 																														to.Ptr("S-1-1-0")},
	// 																														Usernames: []*armsecurity.UserRecommendation{
	// 																															{
	// 																																RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																Username: to.Ptr("root"),
	// 																														}},
	// 																													},
	// 																													{
	// 																														Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																														Path: to.Ptr("/usr/lib/linux-lts-xenial-tools-4.4.0-103/hv_vss_daemon"),
	// 																														Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																														Common: to.Ptr(true),
	// 																														ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																														FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																														UserSids: []*string{
	// 																															to.Ptr("S-1-1-0")},
	// 																															Usernames: []*armsecurity.UserRecommendation{
	// 																																{
	// 																																	RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																	Username: to.Ptr("root"),
	// 																															}},
	// 																														},
	// 																														{
	// 																															Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																															Path: to.Ptr("/usr/lib/linux-lts-xenial-tools-4.4.0-103/hv_kvp_daemon"),
	// 																															Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																															Common: to.Ptr(true),
	// 																															ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																															FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																															UserSids: []*string{
	// 																																to.Ptr("S-1-1-0")},
	// 																																Usernames: []*armsecurity.UserRecommendation{
	// 																																	{
	// 																																		RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																		Username: to.Ptr("root"),
	// 																																}},
	// 																															},
	// 																															{
	// 																																Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																Path: to.Ptr("/usr/sbin/nscd"),
	// 																																Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																Common: to.Ptr(true),
	// 																																ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																UserSids: []*string{
	// 																																	to.Ptr("S-1-1-0")},
	// 																																	Usernames: []*armsecurity.UserRecommendation{
	// 																																		{
	// 																																			RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																			Username: to.Ptr("unscd"),
	// 																																	}},
	// 																																},
	// 																																{
	// 																																	Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																	Path: to.Ptr("/usr/sbin/ntpd"),
	// 																																	Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																	Common: to.Ptr(true),
	// 																																	ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																	FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																	UserSids: []*string{
	// 																																		to.Ptr("S-1-1-0")},
	// 																																		Usernames: []*armsecurity.UserRecommendation{
	// 																																			{
	// 																																				RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																				Username: to.Ptr("ntp"),
	// 																																		}},
	// 																																	},
	// 																																	{
	// 																																		Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																		Path: to.Ptr("/opt/microsoft/auoms/bin/auomscollect"),
	// 																																		Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																		Common: to.Ptr(true),
	// 																																		ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																		FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																		UserSids: []*string{
	// 																																			to.Ptr("S-1-1-0")},
	// 																																			Usernames: []*armsecurity.UserRecommendation{
	// 																																				{
	// 																																					RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																					Username: to.Ptr("root"),
	// 																																			}},
	// 																																		},
	// 																																		{
	// 																																			Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																			Path: to.Ptr("/opt/omi/bin/omiserver"),
	// 																																			Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																			Common: to.Ptr(true),
	// 																																			ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																			FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																			UserSids: []*string{
	// 																																				to.Ptr("S-1-1-0")},
	// 																																				Usernames: []*armsecurity.UserRecommendation{
	// 																																					{
	// 																																						RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																						Username: to.Ptr("root"),
	// 																																				}},
	// 																																			},
	// 																																			{
	// 																																				Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																				Path: to.Ptr("/opt/omi/bin/omiengine"),
	// 																																				Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																				Common: to.Ptr(true),
	// 																																				ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																				FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																				UserSids: []*string{
	// 																																					to.Ptr("S-1-1-0")},
	// 																																					Usernames: []*armsecurity.UserRecommendation{
	// 																																						{
	// 																																							RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																							Username: to.Ptr("omi"),
	// 																																					}},
	// 																																				},
	// 																																				{
	// 																																					Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																					Path: to.Ptr("/opt/omi/bin/omiagent"),
	// 																																					Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																					Common: to.Ptr(true),
	// 																																					ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																					FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																					UserSids: []*string{
	// 																																						to.Ptr("S-1-1-0")},
	// 																																						Usernames: []*armsecurity.UserRecommendation{
	// 																																							{
	// 																																								RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																								Username: to.Ptr("root"),
	// 																																						}},
	// 																																					},
	// 																																					{
	// 																																						Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																						Path: to.Ptr("/usr/sbin/rsyslogd"),
	// 																																						Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																						Common: to.Ptr(true),
	// 																																						ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																						FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																						UserSids: []*string{
	// 																																							to.Ptr("S-1-1-0")},
	// 																																							Usernames: []*armsecurity.UserRecommendation{
	// 																																								{
	// 																																									RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																									Username: to.Ptr("syslog"),
	// 																																							}},
	// 																																						},
	// 																																						{
	// 																																							Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																							Path: to.Ptr("/usr/bin/python2.7"),
	// 																																							Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																							Common: to.Ptr(true),
	// 																																							ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																							FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																							UserSids: []*string{
	// 																																								to.Ptr("S-1-1-0")},
	// 																																								Usernames: []*armsecurity.UserRecommendation{
	// 																																									{
	// 																																										RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																										Username: to.Ptr("root"),
	// 																																									},
	// 																																									{
	// 																																										RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																										Username: to.Ptr("omsagent"),
	// 																																								}},
	// 																																							},
	// 																																							{
	// 																																								Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																								Path: to.Ptr("/opt/microsoft/omsagent/ruby/bin/ruby"),
	// 																																								Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																								Common: to.Ptr(true),
	// 																																								ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																								FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																								UserSids: []*string{
	// 																																									to.Ptr("S-1-1-0")},
	// 																																									Usernames: []*armsecurity.UserRecommendation{
	// 																																										{
	// 																																											RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																											Username: to.Ptr("omsagent"),
	// 																																									}},
	// 																																								},
	// 																																								{
	// 																																									Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																									Path: to.Ptr("/opt/microsoft/auoms/bin/auoms"),
	// 																																									Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																									Common: to.Ptr(true),
	// 																																									ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																									FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																									UserSids: []*string{
	// 																																										to.Ptr("S-1-1-0")},
	// 																																										Usernames: []*armsecurity.UserRecommendation{
	// 																																											{
	// 																																												RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																												Username: to.Ptr("root"),
	// 																																										}},
	// 																																									},
	// 																																									{
	// 																																										Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																										Path: to.Ptr("/usr/local/qualys/cloud-agent/bin/qualys-cloud-agent"),
	// 																																										Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																										Common: to.Ptr(true),
	// 																																										ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																										FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																										UserSids: []*string{
	// 																																											to.Ptr("S-1-1-0")},
	// 																																											Usernames: []*armsecurity.UserRecommendation{
	// 																																												{
	// 																																													RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																													Username: to.Ptr("root"),
	// 																																											}},
	// 																																										},
	// 																																										{
	// 																																											Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																											Path: to.Ptr("/bin/dash"),
	// 																																											Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																											Common: to.Ptr(true),
	// 																																											ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																											FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																											UserSids: []*string{
	// 																																												to.Ptr("S-1-1-0")},
	// 																																												Usernames: []*armsecurity.UserRecommendation{
	// 																																													{
	// 																																														RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																														Username: to.Ptr("omsagent"),
	// 																																													},
	// 																																													{
	// 																																														RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																														Username: to.Ptr("root"),
	// 																																												}},
	// 																																											},
	// 																																											{
	// 																																												Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																												Path: to.Ptr("/bin/sleep"),
	// 																																												Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																												Common: to.Ptr(true),
	// 																																												ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																												FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																												UserSids: []*string{
	// 																																													to.Ptr("S-1-1-0")},
	// 																																													Usernames: []*armsecurity.UserRecommendation{
	// 																																														{
	// 																																															RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																															Username: to.Ptr("omsagent"),
	// 																																													}},
	// 																																												},
	// 																																												{
	// 																																													Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																													Path: to.Ptr("/opt/dsc/bin/dsc_host"),
	// 																																													Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																													Common: to.Ptr(false),
	// 																																													ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																													FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																													UserSids: []*string{
	// 																																														to.Ptr("S-1-1-0")},
	// 																																														Usernames: []*armsecurity.UserRecommendation{
	// 																																															{
	// 																																																RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																Username: to.Ptr("omsagent"),
	// 																																														}},
	// 																																													},
	// 																																													{
	// 																																														Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																														Path: to.Ptr("/usr/bin/sudo"),
	// 																																														Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																														Common: to.Ptr(false),
	// 																																														ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																														FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																														UserSids: []*string{
	// 																																															to.Ptr("S-1-1-0")},
	// 																																															Usernames: []*armsecurity.UserRecommendation{
	// 																																																{
	// 																																																	RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																	Username: to.Ptr("root"),
	// 																																															}},
	// 																																														},
	// 																																														{
	// 																																															Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																															Path: to.Ptr("/bin/bash"),
	// 																																															Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																															Common: to.Ptr(false),
	// 																																															ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																															FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																															UserSids: []*string{
	// 																																																to.Ptr("S-1-1-0")},
	// 																																																Usernames: []*armsecurity.UserRecommendation{
	// 																																																	{
	// 																																																		RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																		Username: to.Ptr("root"),
	// 																																																}},
	// 																																															},
	// 																																															{
	// 																																																Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																																Path: to.Ptr("/usr/bin/apt-get"),
	// 																																																Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																Common: to.Ptr(false),
	// 																																																ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																																FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																																UserSids: []*string{
	// 																																																	to.Ptr("S-1-1-0")},
	// 																																																	Usernames: []*armsecurity.UserRecommendation{
	// 																																																		{
	// 																																																			RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																			Username: to.Ptr("root"),
	// 																																																	}},
	// 																																																},
	// 																																																{
	// 																																																	Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																																	Path: to.Ptr("/usr/lib/apt/methods/http"),
	// 																																																	Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																	Common: to.Ptr(false),
	// 																																																	ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																																	FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																																	UserSids: []*string{
	// 																																																		to.Ptr("S-1-1-0")},
	// 																																																		Usernames: []*armsecurity.UserRecommendation{
	// 																																																			{
	// 																																																				RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																				Username: to.Ptr("root"),
	// 																																																		}},
	// 																																																	},
	// 																																																	{
	// 																																																		Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																																		Path: to.Ptr("/usr/lib/apt/methods/gpgv"),
	// 																																																		Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																		Common: to.Ptr(false),
	// 																																																		ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																																		FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																																		UserSids: []*string{
	// 																																																			to.Ptr("S-1-1-0")},
	// 																																																			Usernames: []*armsecurity.UserRecommendation{
	// 																																																				{
	// 																																																					RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																					Username: to.Ptr("root"),
	// 																																																			}},
	// 																																																		},
	// 																																																		{
	// 																																																			Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																																			Path: to.Ptr("/usr/lib/apt/methods/copy"),
	// 																																																			Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																			Common: to.Ptr(false),
	// 																																																			ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																																			FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																																			UserSids: []*string{
	// 																																																				to.Ptr("S-1-1-0")},
	// 																																																				Usernames: []*armsecurity.UserRecommendation{
	// 																																																					{
	// 																																																						RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																						Username: to.Ptr("root"),
	// 																																																				}},
	// 																																																			},
	// 																																																			{
	// 																																																				Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																																				Path: to.Ptr("/usr/bin/pgrep"),
	// 																																																				Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																				Common: to.Ptr(true),
	// 																																																				ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																																				FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																																				UserSids: []*string{
	// 																																																					to.Ptr("S-1-1-0")},
	// 																																																					Usernames: []*armsecurity.UserRecommendation{
	// 																																																						{
	// 																																																							RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																							Username: to.Ptr("omsagent"),
	// 																																																					}},
	// 																																																				},
	// 																																																				{
	// 																																																					Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 																																																					Path: to.Ptr("/opt/microsoft/omsconfig/bin/omsconsistencyinvoker"),
	// 																																																					Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																					Common: to.Ptr(false),
	// 																																																					ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																																					FileType: to.Ptr(armsecurity.FileTypeExecutable),
	// 																																																					UserSids: []*string{
	// 																																																						to.Ptr("S-1-1-0")},
	// 																																																						Usernames: []*armsecurity.UserRecommendation{
	// 																																																							{
	// 																																																								RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																								Username: to.Ptr("omsagent"),
	// 																																																						}},
	// 																																																				}},
	// 																																																				ProtectionMode: &armsecurity.ProtectionMode{
	// 																																																					Executable: to.Ptr(armsecurity.EnforcementModeAudit),
	// 																																																				},
	// 																																																				RecommendationStatus: to.Ptr(armsecurity.RecommendationStatusRecommended),
	// 																																																				SourceSystem: to.Ptr(armsecurity.SourceSystemAzureAuditD),
	// 																																																				VMRecommendations: []*armsecurity.VMRecommendation{
	// 																																																					{
	// 																																																						ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 																																																						EnforcementSupport: to.Ptr(armsecurity.EnforcementSupportUnknown),
	// 																																																						RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 																																																						ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/nic-no-pip/providers/microsoft.compute/virtualmachines/nic-no-pip-vm"),
	// 																																																				}},
	// 																																																			},
	// 																																																	}},
	// 																																																}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ApplicationWhitelistings/GetAdaptiveApplicationControlsGroup_example.json
func ExampleAdaptiveApplicationControlsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAdaptiveApplicationControlsClient().Get(ctx, "centralus", "ERELGROUP1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AdaptiveApplicationControlGroup = armsecurity.AdaptiveApplicationControlGroup{
	// 	Location: to.Ptr("centralus"),
	// 	Name: to.Ptr("ERELGROUP1"),
	// 	Type: to.Ptr("Microsoft.Security/applicationWhitelistings"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/locations/centralus/applicationWhitelistings/ERELGROUP1"),
	// 	Properties: &armsecurity.AdaptiveApplicationControlGroupData{
	// 		ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 		EnforcementMode: to.Ptr(armsecurity.EnforcementModeAudit),
	// 		Issues: []*armsecurity.AdaptiveApplicationControlIssueSummary{
	// 		},
	// 		PathRecommendations: []*armsecurity.PathRecommendation{
	// 			{
	// 				Type: to.Ptr(armsecurity.RecommendationType("PublisherSignature")),
	// 				Path: to.Ptr("[Exe] O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US\\*\\*\\0.0.0.0"),
	// 				Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 				Common: to.Ptr(true),
	// 				ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 				FileType: to.Ptr(armsecurity.FileTypeExe),
	// 				PublisherInfo: &armsecurity.PublisherInfo{
	// 					BinaryName: to.Ptr("*"),
	// 					ProductName: to.Ptr("*"),
	// 					PublisherName: to.Ptr("O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US"),
	// 					Version: to.Ptr("0.0.0.0"),
	// 				},
	// 				UserSids: []*string{
	// 					to.Ptr("S-1-1-0")},
	// 					Usernames: []*armsecurity.UserRecommendation{
	// 						{
	// 							RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 							Username: to.Ptr("Everyone"),
	// 					}},
	// 				},
	// 				{
	// 					Type: to.Ptr(armsecurity.RecommendationType("ProductSignature")),
	// 					Path: to.Ptr("%OSDRIVE%\\WINDOWSAZURE\\SECAGENT\\WASECAGENTPROV.EXE"),
	// 					Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 					Common: to.Ptr(true),
	// 					ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 					FileType: to.Ptr(armsecurity.FileTypeExe),
	// 					PublisherInfo: &armsecurity.PublisherInfo{
	// 						BinaryName: to.Ptr("*"),
	// 						ProductName: to.Ptr("MICROSOFT® COREXT"),
	// 						PublisherName: to.Ptr("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN"),
	// 						Version: to.Ptr("0.0.0.0"),
	// 					},
	// 					UserSids: []*string{
	// 						to.Ptr("S-1-1-0")},
	// 						Usernames: []*armsecurity.UserRecommendation{
	// 							{
	// 								RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 								Username: to.Ptr("NT AUTHORITY\\SYSTEM"),
	// 						}},
	// 					},
	// 					{
	// 						Type: to.Ptr(armsecurity.RecommendationType("PublisherSignature")),
	// 						Path: to.Ptr("%OSDRIVE%\\WINDOWSAZURE\\PACKAGES_201973_7415\\COLLECTGUESTLOGS.EXE"),
	// 						Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 						Common: to.Ptr(true),
	// 						ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 						FileType: to.Ptr(armsecurity.FileTypeExe),
	// 						PublisherInfo: &armsecurity.PublisherInfo{
	// 							BinaryName: to.Ptr("*"),
	// 							ProductName: to.Ptr("*"),
	// 							PublisherName: to.Ptr("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN"),
	// 							Version: to.Ptr("0.0.0.0"),
	// 						},
	// 						UserSids: []*string{
	// 							to.Ptr("S-1-1-0")},
	// 							Usernames: []*armsecurity.UserRecommendation{
	// 								{
	// 									RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 									Username: to.Ptr("NT AUTHORITY\\SYSTEM"),
	// 							}},
	// 						},
	// 						{
	// 							Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 							Path: to.Ptr("C:\\directory\\file.exe"),
	// 							Action: to.Ptr(armsecurity.RecommendationActionAdd),
	// 							Common: to.Ptr(true),
	// 							ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 							FileType: to.Ptr(armsecurity.FileTypeExe),
	// 							UserSids: []*string{
	// 								to.Ptr("S-1-1-0")},
	// 								Usernames: []*armsecurity.UserRecommendation{
	// 									{
	// 										RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 										Username: to.Ptr("Everyone"),
	// 								}},
	// 						}},
	// 						ProtectionMode: &armsecurity.ProtectionMode{
	// 							Exe: to.Ptr(armsecurity.EnforcementModeAudit),
	// 							Msi: to.Ptr(armsecurity.EnforcementModeAudit),
	// 							Script: to.Ptr(armsecurity.EnforcementModeNone),
	// 						},
	// 						RecommendationStatus: to.Ptr(armsecurity.RecommendationStatusRecommended),
	// 						SourceSystem: to.Ptr(armsecurity.SourceSystemAzureAppLocker),
	// 						VMRecommendations: []*armsecurity.VMRecommendation{
	// 							{
	// 								ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 								EnforcementSupport: to.Ptr(armsecurity.EnforcementSupportSupported),
	// 								RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 								ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/erelh-stable/providers/microsoft.compute/virtualmachines/erelh-16090"),
	// 							},
	// 							{
	// 								ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 								EnforcementSupport: to.Ptr(armsecurity.EnforcementSupportSupported),
	// 								RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 								ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/matanvs/providers/microsoft.compute/virtualmachines/matanvs19"),
	// 						}},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ApplicationWhitelistings/PutAdaptiveApplicationControls_example.json
func ExampleAdaptiveApplicationControlsClient_Put() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAdaptiveApplicationControlsClient().Put(ctx, "centralus", "ERELGROUP1", armsecurity.AdaptiveApplicationControlGroup{
		Properties: &armsecurity.AdaptiveApplicationControlGroupData{
			EnforcementMode: to.Ptr(armsecurity.EnforcementModeAudit),
			PathRecommendations: []*armsecurity.PathRecommendation{
				{
					Type:                to.Ptr(armsecurity.RecommendationType("PublisherSignature")),
					Path:                to.Ptr("[Exe] O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US\\*\\*\\0.0.0.0"),
					Action:              to.Ptr(armsecurity.RecommendationActionRecommended),
					Common:              to.Ptr(true),
					ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
					FileType:            to.Ptr(armsecurity.FileTypeExe),
					PublisherInfo: &armsecurity.PublisherInfo{
						BinaryName:    to.Ptr("*"),
						ProductName:   to.Ptr("*"),
						PublisherName: to.Ptr("O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US"),
						Version:       to.Ptr("0.0.0.0"),
					},
					UserSids: []*string{
						to.Ptr("S-1-1-0")},
					Usernames: []*armsecurity.UserRecommendation{
						{
							RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
							Username:             to.Ptr("Everyone"),
						}},
				},
				{
					Type:                to.Ptr(armsecurity.RecommendationType("ProductSignature")),
					Path:                to.Ptr("%OSDRIVE%\\WINDOWSAZURE\\SECAGENT\\WASECAGENTPROV.EXE"),
					Action:              to.Ptr(armsecurity.RecommendationActionRecommended),
					Common:              to.Ptr(true),
					ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
					FileType:            to.Ptr(armsecurity.FileTypeExe),
					PublisherInfo: &armsecurity.PublisherInfo{
						BinaryName:    to.Ptr("*"),
						ProductName:   to.Ptr("MICROSOFT® COREXT"),
						PublisherName: to.Ptr("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN"),
						Version:       to.Ptr("0.0.0.0"),
					},
					UserSids: []*string{
						to.Ptr("S-1-1-0")},
					Usernames: []*armsecurity.UserRecommendation{
						{
							RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
							Username:             to.Ptr("NT AUTHORITY\\SYSTEM"),
						}},
				},
				{
					Type:                to.Ptr(armsecurity.RecommendationType("PublisherSignature")),
					Path:                to.Ptr("%OSDRIVE%\\WINDOWSAZURE\\PACKAGES_201973_7415\\COLLECTGUESTLOGS.EXE"),
					Action:              to.Ptr(armsecurity.RecommendationActionRecommended),
					Common:              to.Ptr(true),
					ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
					FileType:            to.Ptr(armsecurity.FileTypeExe),
					PublisherInfo: &armsecurity.PublisherInfo{
						BinaryName:    to.Ptr("*"),
						ProductName:   to.Ptr("*"),
						PublisherName: to.Ptr("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN"),
						Version:       to.Ptr("0.0.0.0"),
					},
					UserSids: []*string{
						to.Ptr("S-1-1-0")},
					Usernames: []*armsecurity.UserRecommendation{
						{
							RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
							Username:             to.Ptr("NT AUTHORITY\\SYSTEM"),
						}},
				},
				{
					Type:   to.Ptr(armsecurity.RecommendationType("File")),
					Path:   to.Ptr("C:\\directory\\file.exe"),
					Action: to.Ptr(armsecurity.RecommendationActionAdd),
					Common: to.Ptr(true),
				}},
			ProtectionMode: &armsecurity.ProtectionMode{
				Exe:    to.Ptr(armsecurity.EnforcementModeAudit),
				Msi:    to.Ptr(armsecurity.EnforcementModeNone),
				Script: to.Ptr(armsecurity.EnforcementModeNone),
			},
			VMRecommendations: []*armsecurity.VMRecommendation{
				{
					ConfigurationStatus:  to.Ptr(armsecurity.ConfigurationStatusConfigured),
					EnforcementSupport:   to.Ptr(armsecurity.EnforcementSupportSupported),
					RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
					ResourceID:           to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/erelh-stable/providers/microsoft.compute/virtualmachines/erelh-16090"),
				},
				{
					ConfigurationStatus:  to.Ptr(armsecurity.ConfigurationStatusConfigured),
					EnforcementSupport:   to.Ptr(armsecurity.EnforcementSupportSupported),
					RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
					ResourceID:           to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/matanvs/providers/microsoft.compute/virtualmachines/matanvs19"),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AdaptiveApplicationControlGroup = armsecurity.AdaptiveApplicationControlGroup{
	// 	Location: to.Ptr("centralus"),
	// 	Name: to.Ptr("ERELGROUP1"),
	// 	Type: to.Ptr("Microsoft.Security/applicationWhitelistings"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/locations/centralus/applicationWhitelistings/ERELGROUP1"),
	// 	Properties: &armsecurity.AdaptiveApplicationControlGroupData{
	// 		ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusInProgress),
	// 		EnforcementMode: to.Ptr(armsecurity.EnforcementModeAudit),
	// 		Issues: []*armsecurity.AdaptiveApplicationControlIssueSummary{
	// 		},
	// 		PathRecommendations: []*armsecurity.PathRecommendation{
	// 			{
	// 				Type: to.Ptr(armsecurity.RecommendationType("PublisherSignature")),
	// 				Path: to.Ptr("[Exe] O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US\\*\\*\\0.0.0.0"),
	// 				Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 				Common: to.Ptr(true),
	// 				ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 				FileType: to.Ptr(armsecurity.FileTypeExe),
	// 				PublisherInfo: &armsecurity.PublisherInfo{
	// 					BinaryName: to.Ptr("*"),
	// 					ProductName: to.Ptr("*"),
	// 					PublisherName: to.Ptr("O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US"),
	// 					Version: to.Ptr("0.0.0.0"),
	// 				},
	// 				UserSids: []*string{
	// 					to.Ptr("S-1-1-0")},
	// 					Usernames: []*armsecurity.UserRecommendation{
	// 						{
	// 							RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 							Username: to.Ptr("Everyone"),
	// 					}},
	// 				},
	// 				{
	// 					Type: to.Ptr(armsecurity.RecommendationType("ProductSignature")),
	// 					Path: to.Ptr("%OSDRIVE%\\WINDOWSAZURE\\SECAGENT\\WASECAGENTPROV.EXE"),
	// 					Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 					Common: to.Ptr(true),
	// 					ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 					FileType: to.Ptr(armsecurity.FileTypeExe),
	// 					PublisherInfo: &armsecurity.PublisherInfo{
	// 						BinaryName: to.Ptr("*"),
	// 						ProductName: to.Ptr("MICROSOFT® COREXT"),
	// 						PublisherName: to.Ptr("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN"),
	// 						Version: to.Ptr("0.0.0.0"),
	// 					},
	// 					UserSids: []*string{
	// 						to.Ptr("S-1-1-0")},
	// 						Usernames: []*armsecurity.UserRecommendation{
	// 							{
	// 								RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 								Username: to.Ptr("NT AUTHORITY\\SYSTEM"),
	// 						}},
	// 					},
	// 					{
	// 						Type: to.Ptr(armsecurity.RecommendationType("PublisherSignature")),
	// 						Path: to.Ptr("%OSDRIVE%\\WINDOWSAZURE\\PACKAGES_201973_7415\\COLLECTGUESTLOGS.EXE"),
	// 						Action: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 						Common: to.Ptr(true),
	// 						ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusConfigured),
	// 						FileType: to.Ptr(armsecurity.FileTypeExe),
	// 						PublisherInfo: &armsecurity.PublisherInfo{
	// 							BinaryName: to.Ptr("*"),
	// 							ProductName: to.Ptr("*"),
	// 							PublisherName: to.Ptr("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN"),
	// 							Version: to.Ptr("0.0.0.0"),
	// 						},
	// 						UserSids: []*string{
	// 							to.Ptr("S-1-1-0")},
	// 							Usernames: []*armsecurity.UserRecommendation{
	// 								{
	// 									RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 									Username: to.Ptr("NT AUTHORITY\\SYSTEM"),
	// 							}},
	// 						},
	// 						{
	// 							Type: to.Ptr(armsecurity.RecommendationType("File")),
	// 							Path: to.Ptr("C:\\directory\\file.exe"),
	// 							Action: to.Ptr(armsecurity.RecommendationActionAdd),
	// 							Common: to.Ptr(true),
	// 							ConfigurationStatus: to.Ptr(armsecurity.ConfigurationStatusNotConfigured),
	// 							FileType: to.Ptr(armsecurity.FileTypeExe),
	// 							UserSids: []*string{
	// 								to.Ptr("S-1-1-0")},
	// 								Usernames: []*armsecurity.UserRecommendation{
	// 									{
	// 										RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 										Username: to.Ptr("Everyone"),
	// 								}},
	// 						}},
	// 						ProtectionMode: &armsecurity.ProtectionMode{
	// 							Exe: to.Ptr(armsecurity.EnforcementModeAudit),
	// 							Msi: to.Ptr(armsecurity.EnforcementModeNone),
	// 							Script: to.Ptr(armsecurity.EnforcementModeNone),
	// 						},
	// 						RecommendationStatus: to.Ptr(armsecurity.RecommendationStatusRecommended),
	// 						SourceSystem: to.Ptr(armsecurity.SourceSystemAzureAppLocker),
	// 						VMRecommendations: []*armsecurity.VMRecommendation{
	// 							{
	// 								RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 								ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/erelh-stable/providers/microsoft.compute/virtualmachines/erelh-16090"),
	// 							},
	// 							{
	// 								RecommendationAction: to.Ptr(armsecurity.RecommendationActionRecommended),
	// 								ResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/matanvs/providers/microsoft.compute/virtualmachines/matanvs19"),
	// 						}},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ApplicationWhitelistings/DeleteAdaptiveApplicationControls_example.json
func ExampleAdaptiveApplicationControlsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAdaptiveApplicationControlsClient().Delete(ctx, "centralus", "GROUP1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
