// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/apps/events/subscriptions/v1/subscription_resource.proto

package subscriptionspb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible states for the subscription.
type Subscription_State int32

const (
	// Default value. This value is unused.
	Subscription_STATE_UNSPECIFIED Subscription_State = 0
	// The subscription is active and can receive and deliver events to its
	// notification endpoint.
	Subscription_ACTIVE Subscription_State = 1
	// The subscription is unable to receive events due to an error.
	// To identify the error, see the
	// [`suspension_reason`][google.apps.events.subscriptions.v1.Subscription.suspension_reason]
	// field.
	Subscription_SUSPENDED Subscription_State = 2
	// The subscription is deleted.
	Subscription_DELETED Subscription_State = 3
)

// Enum value maps for Subscription_State.
var (
	Subscription_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "SUSPENDED",
		3: "DELETED",
	}
	Subscription_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"SUSPENDED":         2,
		"DELETED":           3,
	}
)

func (x Subscription_State) Enum() *Subscription_State {
	p := new(Subscription_State)
	*p = x
	return p
}

func (x Subscription_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subscription_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_events_subscriptions_v1_subscription_resource_proto_enumTypes[0].Descriptor()
}

func (Subscription_State) Type() protoreflect.EnumType {
	return &file_google_apps_events_subscriptions_v1_subscription_resource_proto_enumTypes[0]
}

func (x Subscription_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subscription_State.Descriptor instead.
func (Subscription_State) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDescGZIP(), []int{0, 0}
}

// Possible errors for a subscription.
type Subscription_ErrorType int32

const (
	// Default value. This value is unused.
	Subscription_ERROR_TYPE_UNSPECIFIED Subscription_ErrorType = 0
	// The authorizing user has revoked the grant of one or more OAuth scopes.
	// To learn more about authorization for Google Workspace, see [Configure
	// the OAuth consent
	// screen](https://developers.google.com/workspace/guides/configure-oauth-consent#choose-scopes).
	Subscription_USER_SCOPE_REVOKED Subscription_ErrorType = 1
	// The target resource for the subscription no longer exists.
	Subscription_RESOURCE_DELETED Subscription_ErrorType = 2
	// The user that authorized the creation of the subscription no longer has
	// access to the subscription's target resource.
	Subscription_USER_AUTHORIZATION_FAILURE Subscription_ErrorType = 3
	// The Google Workspace application doesn't have access to deliver
	// events to your subscription's notification endpoint.
	Subscription_ENDPOINT_PERMISSION_DENIED Subscription_ErrorType = 4
	// The subscription's notification endpoint doesn't exist, or the endpoint
	// can't be found in the Google Cloud project where you created the
	// subscription.
	Subscription_ENDPOINT_NOT_FOUND Subscription_ErrorType = 6
	// The subscription's notification endpoint failed to receive events due to
	// insufficient quota or reaching rate limiting.
	Subscription_ENDPOINT_RESOURCE_EXHAUSTED Subscription_ErrorType = 7
	// An unidentified error has occurred.
	Subscription_OTHER Subscription_ErrorType = 5
)

// Enum value maps for Subscription_ErrorType.
var (
	Subscription_ErrorType_name = map[int32]string{
		0: "ERROR_TYPE_UNSPECIFIED",
		1: "USER_SCOPE_REVOKED",
		2: "RESOURCE_DELETED",
		3: "USER_AUTHORIZATION_FAILURE",
		4: "ENDPOINT_PERMISSION_DENIED",
		6: "ENDPOINT_NOT_FOUND",
		7: "ENDPOINT_RESOURCE_EXHAUSTED",
		5: "OTHER",
	}
	Subscription_ErrorType_value = map[string]int32{
		"ERROR_TYPE_UNSPECIFIED":      0,
		"USER_SCOPE_REVOKED":          1,
		"RESOURCE_DELETED":            2,
		"USER_AUTHORIZATION_FAILURE":  3,
		"ENDPOINT_PERMISSION_DENIED":  4,
		"ENDPOINT_NOT_FOUND":          6,
		"ENDPOINT_RESOURCE_EXHAUSTED": 7,
		"OTHER":                       5,
	}
)

func (x Subscription_ErrorType) Enum() *Subscription_ErrorType {
	p := new(Subscription_ErrorType)
	*p = x
	return p
}

func (x Subscription_ErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subscription_ErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_events_subscriptions_v1_subscription_resource_proto_enumTypes[1].Descriptor()
}

func (Subscription_ErrorType) Type() protoreflect.EnumType {
	return &file_google_apps_events_subscriptions_v1_subscription_resource_proto_enumTypes[1]
}

func (x Subscription_ErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subscription_ErrorType.Descriptor instead.
func (Subscription_ErrorType) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDescGZIP(), []int{0, 1}
}

// A subscription to receive events about a Google Workspace resource. To learn
// more about subscriptions, see the [Google Workspace Events API
// overview](https://developers.google.com/workspace/events).
type Subscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time when the subscription expires.
	//
	// The maximum expiration time depends on whether your subscription includes
	// resource data in event payloads (specified in the
	// [PayloadOptions][google.apps.events.subscriptions.v1.PayloadOptions]
	// field):
	//
	// * If payloads omit resource data, up to 7 days.
	// * If payloads include resource data, up to 4 hours. If your Google
	// Workspace organization grants access to the resource through [domain-wide
	// delegation](https://support.google.com/a/answer/162106), you can extend the
	// subscription's expiration time to up to 24 hours.
	//
	// After a subscription expires, it's deleted automatically. You receive
	// lifecycle events to the
	// [notification_endpoint][google.apps.events.subscriptions.v1.Subscription.notification_endpoint]
	// 12 hours and one hour before the subscription expires. For details, see
	// [Receive and respond to lifecycle
	// events](https://developers.google.com/workspace/events/guides/events-lifecycle).
	//
	// To prevent a subscription from expiring, you can use the
	// [`UpdateSubscription`][google.apps.events.subscriptions.v1.SubscriptionsService.UpdateSubscription]
	// method to extend its expiration date. For details, see [Update or renew a
	// subscription](https://developers.google.com/workspace/events/guides/update-subscription).
	//
	// Types that are assignable to Expiration:
	//
	//	*Subscription_ExpireTime
	//	*Subscription_Ttl
	Expiration isSubscription_Expiration `protobuf_oneof:"expiration"`
	// Optional. Immutable. Identifier. Resource name of the subscription.
	//
	// Format: `subscriptions/{subscription}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System-assigned unique identifier for the subscription.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Required. Immutable. The Google Workspace resource that's monitored for
	// events, formatted as the [full resource
	// name](https://google.aip.dev/122#full-resource-names). To learn about
	// target resources and the events that they support, see [Supported Google
	// Workspace
	// events](https://developers.google.com/workspace/events#supported-events).
	//
	// A user can only authorize your app to create one subscription for a given
	// target resource. If your app tries to create another subscription with the
	// same user credentials, the request returns an `ALREADY_EXISTS` error.
	TargetResource string `protobuf:"bytes,4,opt,name=target_resource,json=targetResource,proto3" json:"target_resource,omitempty"`
	// Required. Immutable. Unordered list. Input for creating a subscription.
	// Otherwise, output only. One or more types of events to receive about the
	// target resource. Formatted according to the CloudEvents specification.
	//
	// The supported event types depend on the target resource of your
	// subscription. For details, see [Supported Google Workspace
	// events](https://developers.google.com/workspace/events/guides#supported-events).
	//
	// By default, you also receive events about the [lifecycle of your
	// subscription](https://developers.google.com/workspace/events/guides/events-lifecycle).
	// You don't need to specify lifecycle events for this field.
	//
	// If you specify an event type that doesn't exist for the target resource,
	// the request returns an HTTP `400 Bad Request` status code.
	EventTypes []string `protobuf:"bytes,5,rep,name=event_types,json=eventTypes,proto3" json:"event_types,omitempty"`
	// Optional. Options about what data to include in the event payload. Only
	// supported for Google Chat events.
	PayloadOptions *PayloadOptions `protobuf:"bytes,6,opt,name=payload_options,json=payloadOptions,proto3" json:"payload_options,omitempty"`
	// Required. Immutable. The endpoint where the subscription delivers events,
	// such as a Pub/Sub topic.
	NotificationEndpoint *NotificationEndpoint `protobuf:"bytes,7,opt,name=notification_endpoint,json=notificationEndpoint,proto3" json:"notification_endpoint,omitempty"`
	// Output only. The state of the subscription. Determines whether the
	// subscription can receive events and deliver them to the notification
	// endpoint.
	State Subscription_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.apps.events.subscriptions.v1.Subscription_State" json:"state,omitempty"`
	// Output only. The error that suspended the subscription.
	//
	// To reactivate the subscription, resolve the error and call the
	// [`ReactivateSubscription`][google.apps.events.subscriptions.v1.SubscriptionsService.ReactivateSubscription]
	// method.
	SuspensionReason Subscription_ErrorType `protobuf:"varint,18,opt,name=suspension_reason,json=suspensionReason,proto3,enum=google.apps.events.subscriptions.v1.Subscription_ErrorType" json:"suspension_reason,omitempty"`
	// Output only. The user who authorized the creation of the
	// subscription.
	//
	// Format: `users/{user}`
	//
	// For Google Workspace users, the `{user}` value is the
	// [`user.id`](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users#User.FIELDS.ids)
	// field from the Directory API.
	Authority string `protobuf:"bytes,10,opt,name=authority,proto3" json:"authority,omitempty"`
	// Output only. The time when the subscription is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last time that the subscription is updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. If `true`, the subscription is in the process of being
	// updated.
	Reconciling bool `protobuf:"varint,15,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Optional. This checksum is computed by the server based on the value of
	// other fields, and might be sent on update requests to ensure the client has
	// an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,17,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *Subscription) Reset() {
	*x = Subscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription) ProtoMessage() {}

func (x *Subscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription.ProtoReflect.Descriptor instead.
func (*Subscription) Descriptor() ([]byte, []int) {
	return file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDescGZIP(), []int{0}
}

func (m *Subscription) GetExpiration() isSubscription_Expiration {
	if m != nil {
		return m.Expiration
	}
	return nil
}

func (x *Subscription) GetExpireTime() *timestamppb.Timestamp {
	if x, ok := x.GetExpiration().(*Subscription_ExpireTime); ok {
		return x.ExpireTime
	}
	return nil
}

func (x *Subscription) GetTtl() *durationpb.Duration {
	if x, ok := x.GetExpiration().(*Subscription_Ttl); ok {
		return x.Ttl
	}
	return nil
}

func (x *Subscription) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subscription) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Subscription) GetTargetResource() string {
	if x != nil {
		return x.TargetResource
	}
	return ""
}

func (x *Subscription) GetEventTypes() []string {
	if x != nil {
		return x.EventTypes
	}
	return nil
}

func (x *Subscription) GetPayloadOptions() *PayloadOptions {
	if x != nil {
		return x.PayloadOptions
	}
	return nil
}

func (x *Subscription) GetNotificationEndpoint() *NotificationEndpoint {
	if x != nil {
		return x.NotificationEndpoint
	}
	return nil
}

func (x *Subscription) GetState() Subscription_State {
	if x != nil {
		return x.State
	}
	return Subscription_STATE_UNSPECIFIED
}

func (x *Subscription) GetSuspensionReason() Subscription_ErrorType {
	if x != nil {
		return x.SuspensionReason
	}
	return Subscription_ERROR_TYPE_UNSPECIFIED
}

func (x *Subscription) GetAuthority() string {
	if x != nil {
		return x.Authority
	}
	return ""
}

func (x *Subscription) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Subscription) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Subscription) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *Subscription) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

type isSubscription_Expiration interface {
	isSubscription_Expiration()
}

type Subscription_ExpireTime struct {
	// Non-empty default. The timestamp in UTC when the subscription expires.
	// Always displayed on output, regardless of what was used on input.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=expire_time,json=expireTime,proto3,oneof"`
}

type Subscription_Ttl struct {
	// Input only. The time-to-live (TTL) or duration for the subscription. If
	// unspecified or set to `0`, uses the maximum possible duration.
	Ttl *durationpb.Duration `protobuf:"bytes,14,opt,name=ttl,proto3,oneof"`
}

func (*Subscription_ExpireTime) isSubscription_Expiration() {}

func (*Subscription_Ttl) isSubscription_Expiration() {}

// Options about what data to include in the event payload. Only supported for
// Google Chat events.
type PayloadOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether the event payload includes data about the resource that
	// changed. For example, for an event where a Google Chat message was created,
	// whether the payload contains data about the
	// [`Message`](https://developers.google.com/chat/api/reference/rest/v1/spaces.messages)
	// resource. If false, the event payload only includes the name of the changed
	// resource.
	IncludeResource bool `protobuf:"varint,1,opt,name=include_resource,json=includeResource,proto3" json:"include_resource,omitempty"`
	// Optional. If `include_resource` is set to `true`, the list of fields to
	// include in the event payload. Separate fields with a comma. For example, to
	// include a Google Chat message's sender and create time, enter
	// `message.sender,message.createTime`. If omitted, the payload includes all
	// fields for the resource.
	//
	// If you specify a field that doesn't exist for the resource, the system
	// ignores the field.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *PayloadOptions) Reset() {
	*x = PayloadOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PayloadOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOptions) ProtoMessage() {}

func (x *PayloadOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadOptions.ProtoReflect.Descriptor instead.
func (*PayloadOptions) Descriptor() ([]byte, []int) {
	return file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDescGZIP(), []int{1}
}

func (x *PayloadOptions) GetIncludeResource() bool {
	if x != nil {
		return x.IncludeResource
	}
	return false
}

func (x *PayloadOptions) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

// The endpoint where the subscription delivers events.
type NotificationEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Endpoint:
	//
	//	*NotificationEndpoint_PubsubTopic
	Endpoint isNotificationEndpoint_Endpoint `protobuf_oneof:"endpoint"`
}

func (x *NotificationEndpoint) Reset() {
	*x = NotificationEndpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotificationEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationEndpoint) ProtoMessage() {}

func (x *NotificationEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationEndpoint.ProtoReflect.Descriptor instead.
func (*NotificationEndpoint) Descriptor() ([]byte, []int) {
	return file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDescGZIP(), []int{2}
}

func (m *NotificationEndpoint) GetEndpoint() isNotificationEndpoint_Endpoint {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

func (x *NotificationEndpoint) GetPubsubTopic() string {
	if x, ok := x.GetEndpoint().(*NotificationEndpoint_PubsubTopic); ok {
		return x.PubsubTopic
	}
	return ""
}

type isNotificationEndpoint_Endpoint interface {
	isNotificationEndpoint_Endpoint()
}

type NotificationEndpoint_PubsubTopic struct {
	// Immutable. The Cloud Pub/Sub topic that receives events for the
	// subscription.
	//
	// Format: `projects/{project}/topics/{topic}`
	//
	// You must create the topic in the same Google Cloud project where
	// you create this subscription.
	//
	// When the topic receives events, the events are encoded as Cloud Pub/Sub
	// messages. For details, see the [Google Cloud Pub/Sub Protocol Binding for
	// CloudEvents](https://github.com/googleapis/google-cloudevents/blob/main/docs/spec/pubsub.md).
	PubsubTopic string `protobuf:"bytes,1,opt,name=pubsub_topic,json=pubsubTopic,proto3,oneof"`
}

func (*NotificationEndpoint_PubsubTopic) isNotificationEndpoint_Endpoint() {}

var File_google_apps_events_subscriptions_v1_subscription_resource_proto protoreflect.FileDescriptor

var file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xec, 0x0a, 0x0a, 0x0c, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x07, 0x48, 0x00, 0x52, 0x0a,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x03, 0x74, 0x74,
	0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x48, 0x00, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x12, 0x1d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41,
	0x08, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a,
	0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x03, 0x75, 0x69, 0x64, 0x12, 0x35, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0c, 0xe0,
	0x41, 0x05, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03, 0x0a, 0x01, 0x2a, 0x52, 0x0e, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2a, 0x0a, 0x0b, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x09, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x06, 0xe0, 0x41, 0x05, 0x52, 0x0a, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x61, 0x0a, 0x0f, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x76, 0x0a, 0x15, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x14, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x12, 0x52, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x6d, 0x0a, 0x11, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x10, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55,
	0x73, 0x65, 0x72, 0x52, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e,
	0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65,
	0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x22, 0x46, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a,
	0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x22, 0xd9, 0x01, 0x0a, 0x09, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x53, 0x43, 0x4f,
	0x50, 0x45, 0x5f, 0x52, 0x45, 0x56, 0x4f, 0x4b, 0x45, 0x44, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10,
	0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x4f,
	0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45,
	0x10, 0x03, 0x12, 0x1e, 0x0a, 0x1a, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x50,
	0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44,
	0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x4e,
	0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x06, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x4e,
	0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x45, 0x58, 0x48, 0x41, 0x55, 0x53, 0x54, 0x45, 0x44, 0x10, 0x07, 0x12, 0x09, 0x0a, 0x05, 0x4f,
	0x54, 0x48, 0x45, 0x52, 0x10, 0x05, 0x3a, 0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x2b, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x01, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0x0a, 0x0e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6c, 0x0a, 0x14, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12,
	0x48, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x42, 0x0a, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x88, 0x03, 0xea, 0x41, 0x31, 0x0a, 0x21, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x12, 0x0c,
	0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x75, 0x73, 0x65, 0x72, 0x7d, 0xea, 0x41, 0x40, 0x0a,
	0x1b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x21, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x7b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x7d, 0x0a,
	0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x19, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x62, 0x3b, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2e,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70, 0x73, 0x5c, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x5c, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x41, 0x70, 0x70, 0x73, 0x3a, 0x3a, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x3a, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDescOnce sync.Once
	file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDescData = file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDesc
)

func file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDescGZIP() []byte {
	file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDescOnce.Do(func() {
		file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDescData)
	})
	return file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDescData
}

var file_google_apps_events_subscriptions_v1_subscription_resource_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_apps_events_subscriptions_v1_subscription_resource_proto_goTypes = []interface{}{
	(Subscription_State)(0),       // 0: google.apps.events.subscriptions.v1.Subscription.State
	(Subscription_ErrorType)(0),   // 1: google.apps.events.subscriptions.v1.Subscription.ErrorType
	(*Subscription)(nil),          // 2: google.apps.events.subscriptions.v1.Subscription
	(*PayloadOptions)(nil),        // 3: google.apps.events.subscriptions.v1.PayloadOptions
	(*NotificationEndpoint)(nil),  // 4: google.apps.events.subscriptions.v1.NotificationEndpoint
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),   // 6: google.protobuf.Duration
	(*fieldmaskpb.FieldMask)(nil), // 7: google.protobuf.FieldMask
}
var file_google_apps_events_subscriptions_v1_subscription_resource_proto_depIdxs = []int32{
	5, // 0: google.apps.events.subscriptions.v1.Subscription.expire_time:type_name -> google.protobuf.Timestamp
	6, // 1: google.apps.events.subscriptions.v1.Subscription.ttl:type_name -> google.protobuf.Duration
	3, // 2: google.apps.events.subscriptions.v1.Subscription.payload_options:type_name -> google.apps.events.subscriptions.v1.PayloadOptions
	4, // 3: google.apps.events.subscriptions.v1.Subscription.notification_endpoint:type_name -> google.apps.events.subscriptions.v1.NotificationEndpoint
	0, // 4: google.apps.events.subscriptions.v1.Subscription.state:type_name -> google.apps.events.subscriptions.v1.Subscription.State
	1, // 5: google.apps.events.subscriptions.v1.Subscription.suspension_reason:type_name -> google.apps.events.subscriptions.v1.Subscription.ErrorType
	5, // 6: google.apps.events.subscriptions.v1.Subscription.create_time:type_name -> google.protobuf.Timestamp
	5, // 7: google.apps.events.subscriptions.v1.Subscription.update_time:type_name -> google.protobuf.Timestamp
	7, // 8: google.apps.events.subscriptions.v1.PayloadOptions.field_mask:type_name -> google.protobuf.FieldMask
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_google_apps_events_subscriptions_v1_subscription_resource_proto_init() }
func file_google_apps_events_subscriptions_v1_subscription_resource_proto_init() {
	if File_google_apps_events_subscriptions_v1_subscription_resource_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PayloadOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotificationEndpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Subscription_ExpireTime)(nil),
		(*Subscription_Ttl)(nil),
	}
	file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*NotificationEndpoint_PubsubTopic)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_apps_events_subscriptions_v1_subscription_resource_proto_goTypes,
		DependencyIndexes: file_google_apps_events_subscriptions_v1_subscription_resource_proto_depIdxs,
		EnumInfos:         file_google_apps_events_subscriptions_v1_subscription_resource_proto_enumTypes,
		MessageInfos:      file_google_apps_events_subscriptions_v1_subscription_resource_proto_msgTypes,
	}.Build()
	File_google_apps_events_subscriptions_v1_subscription_resource_proto = out.File
	file_google_apps_events_subscriptions_v1_subscription_resource_proto_rawDesc = nil
	file_google_apps_events_subscriptions_v1_subscription_resource_proto_goTypes = nil
	file_google_apps_events_subscriptions_v1_subscription_resource_proto_depIdxs = nil
}
