// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/backupdr/v1/backupdr.proto

package backupdrpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// VPC peering modes supported by Cloud BackupDR.
type NetworkConfig_PeeringMode int32

const (
	// Peering mode not set.
	NetworkConfig_PEERING_MODE_UNSPECIFIED NetworkConfig_PeeringMode = 0
	// Connect using Private Service Access to the Management Server. Private
	// services access provides an IP address range for multiple Google Cloud
	// services, including Cloud BackupDR.
	NetworkConfig_PRIVATE_SERVICE_ACCESS NetworkConfig_PeeringMode = 1
)

// Enum value maps for NetworkConfig_PeeringMode.
var (
	NetworkConfig_PeeringMode_name = map[int32]string{
		0: "PEERING_MODE_UNSPECIFIED",
		1: "PRIVATE_SERVICE_ACCESS",
	}
	NetworkConfig_PeeringMode_value = map[string]int32{
		"PEERING_MODE_UNSPECIFIED": 0,
		"PRIVATE_SERVICE_ACCESS":   1,
	}
)

func (x NetworkConfig_PeeringMode) Enum() *NetworkConfig_PeeringMode {
	p := new(NetworkConfig_PeeringMode)
	*p = x
	return p
}

func (x NetworkConfig_PeeringMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkConfig_PeeringMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupdr_proto_enumTypes[0].Descriptor()
}

func (NetworkConfig_PeeringMode) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupdr_proto_enumTypes[0]
}

func (x NetworkConfig_PeeringMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkConfig_PeeringMode.Descriptor instead.
func (NetworkConfig_PeeringMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{0, 0}
}

// Type of backup service resource.
type ManagementServer_InstanceType int32

const (
	// Instance type is not mentioned.
	ManagementServer_INSTANCE_TYPE_UNSPECIFIED ManagementServer_InstanceType = 0
	// Instance for backup and restore management (i.e., AGM).
	ManagementServer_BACKUP_RESTORE ManagementServer_InstanceType = 1
)

// Enum value maps for ManagementServer_InstanceType.
var (
	ManagementServer_InstanceType_name = map[int32]string{
		0: "INSTANCE_TYPE_UNSPECIFIED",
		1: "BACKUP_RESTORE",
	}
	ManagementServer_InstanceType_value = map[string]int32{
		"INSTANCE_TYPE_UNSPECIFIED": 0,
		"BACKUP_RESTORE":            1,
	}
)

func (x ManagementServer_InstanceType) Enum() *ManagementServer_InstanceType {
	p := new(ManagementServer_InstanceType)
	*p = x
	return p
}

func (x ManagementServer_InstanceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagementServer_InstanceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupdr_proto_enumTypes[1].Descriptor()
}

func (ManagementServer_InstanceType) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupdr_proto_enumTypes[1]
}

func (x ManagementServer_InstanceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagementServer_InstanceType.Descriptor instead.
func (ManagementServer_InstanceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{4, 0}
}

// State of Management server instance.
type ManagementServer_InstanceState int32

const (
	// State not set.
	ManagementServer_INSTANCE_STATE_UNSPECIFIED ManagementServer_InstanceState = 0
	// The instance is being created.
	ManagementServer_CREATING ManagementServer_InstanceState = 1
	// The instance has been created and is fully usable.
	ManagementServer_READY ManagementServer_InstanceState = 2
	// The instance configuration is being updated. Certain kinds of updates
	// may cause the instance to become unusable while the update is in
	// progress.
	ManagementServer_UPDATING ManagementServer_InstanceState = 3
	// The instance is being deleted.
	ManagementServer_DELETING ManagementServer_InstanceState = 4
	// The instance is being repaired and may be unstable.
	ManagementServer_REPAIRING ManagementServer_InstanceState = 5
	// Maintenance is being performed on this instance.
	ManagementServer_MAINTENANCE ManagementServer_InstanceState = 6
	// The instance is experiencing an issue and might be unusable. You can get
	// further details from the statusMessage field of Instance resource.
	ManagementServer_ERROR ManagementServer_InstanceState = 7
)

// Enum value maps for ManagementServer_InstanceState.
var (
	ManagementServer_InstanceState_name = map[int32]string{
		0: "INSTANCE_STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
		3: "UPDATING",
		4: "DELETING",
		5: "REPAIRING",
		6: "MAINTENANCE",
		7: "ERROR",
	}
	ManagementServer_InstanceState_value = map[string]int32{
		"INSTANCE_STATE_UNSPECIFIED": 0,
		"CREATING":                   1,
		"READY":                      2,
		"UPDATING":                   3,
		"DELETING":                   4,
		"REPAIRING":                  5,
		"MAINTENANCE":                6,
		"ERROR":                      7,
	}
)

func (x ManagementServer_InstanceState) Enum() *ManagementServer_InstanceState {
	p := new(ManagementServer_InstanceState)
	*p = x
	return p
}

func (x ManagementServer_InstanceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagementServer_InstanceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupdr_proto_enumTypes[2].Descriptor()
}

func (ManagementServer_InstanceState) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupdr_proto_enumTypes[2]
}

func (x ManagementServer_InstanceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagementServer_InstanceState.Descriptor instead.
func (ManagementServer_InstanceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{4, 1}
}

// Network configuration for ManagementServer instance.
type NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The resource name of the Google Compute Engine VPC network to
	// which the ManagementServer instance is connected.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. The network connect mode of the ManagementServer instance. For
	// this version, only PRIVATE_SERVICE_ACCESS is supported.
	PeeringMode NetworkConfig_PeeringMode `protobuf:"varint,2,opt,name=peering_mode,json=peeringMode,proto3,enum=google.cloud.backupdr.v1.NetworkConfig_PeeringMode" json:"peering_mode,omitempty"`
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{0}
}

func (x *NetworkConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *NetworkConfig) GetPeeringMode() NetworkConfig_PeeringMode {
	if x != nil {
		return x.PeeringMode
	}
	return NetworkConfig_PEERING_MODE_UNSPECIFIED
}

// ManagementURI for the Management Server resource.
type ManagementURI struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ManagementServer AGM/RD WebUI URL.
	WebUi string `protobuf:"bytes,1,opt,name=web_ui,json=webUi,proto3" json:"web_ui,omitempty"`
	// Output only. The ManagementServer AGM/RD API URL.
	Api string `protobuf:"bytes,2,opt,name=api,proto3" json:"api,omitempty"`
}

func (x *ManagementURI) Reset() {
	*x = ManagementURI{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagementURI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagementURI) ProtoMessage() {}

func (x *ManagementURI) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagementURI.ProtoReflect.Descriptor instead.
func (*ManagementURI) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{1}
}

func (x *ManagementURI) GetWebUi() string {
	if x != nil {
		return x.WebUi
	}
	return ""
}

func (x *ManagementURI) GetApi() string {
	if x != nil {
		return x.Api
	}
	return ""
}

// ManagementURI depending on the Workforce Identity i.e. either 1p or 3p.
type WorkforceIdentityBasedManagementURI struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. First party Management URI for Google Identities.
	FirstPartyManagementUri string `protobuf:"bytes,1,opt,name=first_party_management_uri,json=firstPartyManagementUri,proto3" json:"first_party_management_uri,omitempty"`
	// Output only. Third party Management URI for External Identity Providers.
	ThirdPartyManagementUri string `protobuf:"bytes,2,opt,name=third_party_management_uri,json=thirdPartyManagementUri,proto3" json:"third_party_management_uri,omitempty"`
}

func (x *WorkforceIdentityBasedManagementURI) Reset() {
	*x = WorkforceIdentityBasedManagementURI{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkforceIdentityBasedManagementURI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkforceIdentityBasedManagementURI) ProtoMessage() {}

func (x *WorkforceIdentityBasedManagementURI) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkforceIdentityBasedManagementURI.ProtoReflect.Descriptor instead.
func (*WorkforceIdentityBasedManagementURI) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{2}
}

func (x *WorkforceIdentityBasedManagementURI) GetFirstPartyManagementUri() string {
	if x != nil {
		return x.FirstPartyManagementUri
	}
	return ""
}

func (x *WorkforceIdentityBasedManagementURI) GetThirdPartyManagementUri() string {
	if x != nil {
		return x.ThirdPartyManagementUri
	}
	return ""
}

// OAuth Client ID depending on the Workforce Identity i.e. either 1p or 3p,
type WorkforceIdentityBasedOAuth2ClientID struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. First party OAuth Client ID for Google Identities.
	FirstPartyOauth2ClientId string `protobuf:"bytes,1,opt,name=first_party_oauth2_client_id,json=firstPartyOauth2ClientId,proto3" json:"first_party_oauth2_client_id,omitempty"`
	// Output only. Third party OAuth Client ID for External Identity Providers.
	ThirdPartyOauth2ClientId string `protobuf:"bytes,2,opt,name=third_party_oauth2_client_id,json=thirdPartyOauth2ClientId,proto3" json:"third_party_oauth2_client_id,omitempty"`
}

func (x *WorkforceIdentityBasedOAuth2ClientID) Reset() {
	*x = WorkforceIdentityBasedOAuth2ClientID{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkforceIdentityBasedOAuth2ClientID) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkforceIdentityBasedOAuth2ClientID) ProtoMessage() {}

func (x *WorkforceIdentityBasedOAuth2ClientID) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkforceIdentityBasedOAuth2ClientID.ProtoReflect.Descriptor instead.
func (*WorkforceIdentityBasedOAuth2ClientID) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{3}
}

func (x *WorkforceIdentityBasedOAuth2ClientID) GetFirstPartyOauth2ClientId() string {
	if x != nil {
		return x.FirstPartyOauth2ClientId
	}
	return ""
}

func (x *WorkforceIdentityBasedOAuth2ClientID) GetThirdPartyOauth2ClientId() string {
	if x != nil {
		return x.ThirdPartyOauth2ClientId
	}
	return ""
}

// ManagementServer describes a single BackupDR ManagementServer instance.
type ManagementServer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The description of the ManagementServer instance (2048 characters
	// or less).
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Resource labels to represent user provided metadata.
	// Labels currently defined:
	//  1. migrate_from_go=<false|true>
	//     If set to true, the MS is created in migration ready mode.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The time when the instance was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the instance was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The type of the ManagementServer resource.
	Type ManagementServer_InstanceType `protobuf:"varint,14,opt,name=type,proto3,enum=google.cloud.backupdr.v1.ManagementServer_InstanceType" json:"type,omitempty"`
	// Output only. The hostname or ip address of the exposed AGM endpoints, used
	// by clients to connect to AGM/RD graphical user interface and APIs.
	ManagementUri *ManagementURI `protobuf:"bytes,11,opt,name=management_uri,json=managementUri,proto3" json:"management_uri,omitempty"`
	// Output only. The hostnames of the exposed AGM endpoints for both types of
	// user i.e. 1p and 3p, used to connect AGM/RM UI.
	WorkforceIdentityBasedManagementUri *WorkforceIdentityBasedManagementURI `protobuf:"bytes,16,opt,name=workforce_identity_based_management_uri,json=workforceIdentityBasedManagementUri,proto3" json:"workforce_identity_based_management_uri,omitempty"`
	// Output only. The ManagementServer state.
	State ManagementServer_InstanceState `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.backupdr.v1.ManagementServer_InstanceState" json:"state,omitempty"`
	// Required. VPC networks to which the ManagementServer instance is connected.
	// For this version, only a single network is supported.
	Networks []*NetworkConfig `protobuf:"bytes,8,rep,name=networks,proto3" json:"networks,omitempty"`
	// Optional. Server specified ETag for the ManagementServer resource to
	// prevent simultaneous updates from overwiting each other.
	Etag string `protobuf:"bytes,13,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. The OAuth 2.0 client id is required to make API calls to the
	// BackupDR instance API of this ManagementServer. This is the value that
	// should be provided in the ‘aud’ field of the OIDC ID Token (see openid
	// specification
	// https://openid.net/specs/openid-connect-core-1_0.html#IDToken).
	Oauth2ClientId string `protobuf:"bytes,15,opt,name=oauth2_client_id,json=oauth2ClientId,proto3" json:"oauth2_client_id,omitempty"`
	// Output only. The OAuth client IDs for both types of user i.e. 1p and 3p.
	WorkforceIdentityBasedOauth2ClientId *WorkforceIdentityBasedOAuth2ClientID `protobuf:"bytes,17,opt,name=workforce_identity_based_oauth2_client_id,json=workforceIdentityBasedOauth2ClientId,proto3" json:"workforce_identity_based_oauth2_client_id,omitempty"`
	// Output only. The hostname or ip address of the exposed AGM endpoints, used
	// by BAs to connect to BA proxy.
	BaProxyUri []string `protobuf:"bytes,18,rep,name=ba_proxy_uri,json=baProxyUri,proto3" json:"ba_proxy_uri,omitempty"`
}

func (x *ManagementServer) Reset() {
	*x = ManagementServer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagementServer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagementServer) ProtoMessage() {}

func (x *ManagementServer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagementServer.ProtoReflect.Descriptor instead.
func (*ManagementServer) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{4}
}

func (x *ManagementServer) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ManagementServer) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ManagementServer) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ManagementServer) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ManagementServer) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ManagementServer) GetType() ManagementServer_InstanceType {
	if x != nil {
		return x.Type
	}
	return ManagementServer_INSTANCE_TYPE_UNSPECIFIED
}

func (x *ManagementServer) GetManagementUri() *ManagementURI {
	if x != nil {
		return x.ManagementUri
	}
	return nil
}

func (x *ManagementServer) GetWorkforceIdentityBasedManagementUri() *WorkforceIdentityBasedManagementURI {
	if x != nil {
		return x.WorkforceIdentityBasedManagementUri
	}
	return nil
}

func (x *ManagementServer) GetState() ManagementServer_InstanceState {
	if x != nil {
		return x.State
	}
	return ManagementServer_INSTANCE_STATE_UNSPECIFIED
}

func (x *ManagementServer) GetNetworks() []*NetworkConfig {
	if x != nil {
		return x.Networks
	}
	return nil
}

func (x *ManagementServer) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *ManagementServer) GetOauth2ClientId() string {
	if x != nil {
		return x.Oauth2ClientId
	}
	return ""
}

func (x *ManagementServer) GetWorkforceIdentityBasedOauth2ClientId() *WorkforceIdentityBasedOAuth2ClientID {
	if x != nil {
		return x.WorkforceIdentityBasedOauth2ClientId
	}
	return nil
}

func (x *ManagementServer) GetBaProxyUri() []string {
	if x != nil {
		return x.BaProxyUri
	}
	return nil
}

// Request message for listing management servers.
type ListManagementServersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location for which to retrieve management servers
	// information, in the format `projects/{project_id}/locations/{location}`. In
	// Cloud BackupDR, locations map to GCP regions, for example **us-central1**.
	// To retrieve management servers for all locations, use "-" for the
	// `{location}` value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results.
	Filter *string `protobuf:"bytes,4,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Optional. Hint for how to order the results.
	OrderBy *string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
}

func (x *ListManagementServersRequest) Reset() {
	*x = ListManagementServersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListManagementServersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListManagementServersRequest) ProtoMessage() {}

func (x *ListManagementServersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListManagementServersRequest.ProtoReflect.Descriptor instead.
func (*ListManagementServersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{5}
}

func (x *ListManagementServersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListManagementServersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListManagementServersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListManagementServersRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *ListManagementServersRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

// Response message for listing management servers.
type ListManagementServersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of ManagementServer instances in the project for the specified
	// location.
	//
	// If the `{location}` value in the request is "-", the response contains a
	// list of instances from all locations. In case any location is unreachable,
	// the response will only return management servers in reachable locations and
	// the 'unreachable' field will be populated with a list of unreachable
	// locations.
	ManagementServers []*ManagementServer `protobuf:"bytes,1,rep,name=management_servers,json=managementServers,proto3" json:"management_servers,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListManagementServersResponse) Reset() {
	*x = ListManagementServersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListManagementServersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListManagementServersResponse) ProtoMessage() {}

func (x *ListManagementServersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListManagementServersResponse.ProtoReflect.Descriptor instead.
func (*ListManagementServersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{6}
}

func (x *ListManagementServersResponse) GetManagementServers() []*ManagementServer {
	if x != nil {
		return x.ManagementServers
	}
	return nil
}

func (x *ListManagementServersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListManagementServersResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for getting a management server instance.
type GetManagementServerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the management server resource name, in the format
	// `projects/{project_id}/locations/{location}/managementServers/{resource_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetManagementServerRequest) Reset() {
	*x = GetManagementServerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetManagementServerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetManagementServerRequest) ProtoMessage() {}

func (x *GetManagementServerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetManagementServerRequest.ProtoReflect.Descriptor instead.
func (*GetManagementServerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{7}
}

func (x *GetManagementServerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for creating a management server instance.
type CreateManagementServerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The management server project and location in the format
	// `projects/{project_id}/locations/{location}`. In Cloud Backup and DR
	// locations map to GCP regions, for example **us-central1**.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name of the management server to create. The name must be
	// unique for the specified project and location.
	ManagementServerId string `protobuf:"bytes,2,opt,name=management_server_id,json=managementServerId,proto3" json:"management_server_id,omitempty"`
	// Required. A [management server
	// resource][google.cloud.backupdr.v1.ManagementServer]
	ManagementServer *ManagementServer `protobuf:"bytes,3,opt,name=management_server,json=managementServer,proto3" json:"management_server,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateManagementServerRequest) Reset() {
	*x = CreateManagementServerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateManagementServerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateManagementServerRequest) ProtoMessage() {}

func (x *CreateManagementServerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateManagementServerRequest.ProtoReflect.Descriptor instead.
func (*CreateManagementServerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{8}
}

func (x *CreateManagementServerRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateManagementServerRequest) GetManagementServerId() string {
	if x != nil {
		return x.ManagementServerId
	}
	return ""
}

func (x *CreateManagementServerRequest) GetManagementServer() *ManagementServer {
	if x != nil {
		return x.ManagementServer
	}
	return nil
}

func (x *CreateManagementServerRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for deleting a management server instance.
type DeleteManagementServerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteManagementServerRequest) Reset() {
	*x = DeleteManagementServerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteManagementServerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteManagementServerRequest) ProtoMessage() {}

func (x *DeleteManagementServerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteManagementServerRequest.ProtoReflect.Descriptor instead.
func (*DeleteManagementServerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteManagementServerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteManagementServerRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	// Output only. AdditionalInfo contains additional Info related to backup plan
	// association resource.
	AdditionalInfo map[string]string `protobuf:"bytes,8,rep,name=additional_info,json=additionalInfo,proto3" json:"additional_info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP(), []int{10}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

func (x *OperationMetadata) GetAdditionalInfo() map[string]string {
	if x != nil {
		return x.AdditionalInfo
	}
	return nil
}

var File_google_cloud_backupdr_v1_backupdr_proto protoreflect.FileDescriptor

var file_google_cloud_backupdr_v1_backupdr_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x64, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd4, 0x01, 0x0a, 0x0d, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5b, 0x0a, 0x0c, 0x70, 0x65,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x47, 0x0a, 0x0b, 0x50, 0x65, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e,
	0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01,
	0x22, 0x42, 0x0a, 0x0d, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x52,
	0x49, 0x12, 0x1a, 0x0a, 0x06, 0x77, 0x65, 0x62, 0x5f, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x77, 0x65, 0x62, 0x55, 0x69, 0x12, 0x15, 0x0a,
	0x03, 0x61, 0x70, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x03, 0x61, 0x70, 0x69, 0x22, 0xa9, 0x01, 0x0a, 0x23, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x52, 0x49, 0x12, 0x40, 0x0a, 0x1a,
	0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x66, 0x69, 0x72, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74,
	0x79, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x40,
	0x0a, 0x1a, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x74, 0x68, 0x69, 0x72, 0x64, 0x50, 0x61,
	0x72, 0x74, 0x79, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69,
	0x22, 0xb0, 0x01, 0x0a, 0x24, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x4f, 0x41, 0x75, 0x74, 0x68,
	0x32, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x44, 0x12, 0x43, 0x0a, 0x1c, 0x66, 0x69, 0x72,
	0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x5f, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x5f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x66, 0x69, 0x72, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x79,
	0x4f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x43,
	0x0a, 0x1c, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x5f, 0x6f, 0x61,
	0x75, 0x74, 0x68, 0x32, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x74, 0x68, 0x69, 0x72, 0x64,
	0x50, 0x61, 0x72, 0x74, 0x79, 0x4f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x22, 0xd1, 0x0b, 0x0a, 0x10, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x50, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x53, 0x0a, 0x0e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x55, 0x52, 0x49, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x98, 0x01, 0x0a, 0x27,
	0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x52, 0x49, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x23, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x53, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x2d,
	0x0a, 0x10, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6f,
	0x61, 0x75, 0x74, 0x68, 0x32, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x9c, 0x01,
	0x0a, 0x29, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x6f, 0x61, 0x75, 0x74, 0x68,
	0x32, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x61,
	0x73, 0x65, 0x64, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x32, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49,
	0x44, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x24, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x4f, 0x61,
	0x75, 0x74, 0x68, 0x32, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0c,
	0x62, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x12, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x62, 0x61, 0x50, 0x72, 0x6f, 0x78, 0x79,
	0x55, 0x72, 0x69, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x41,
	0x0a, 0x0c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d,
	0x0a, 0x19, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a,
	0x0e, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x10,
	0x01, 0x22, 0x8f, 0x01, 0x0a, 0x0d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x50, 0x41,
	0x49, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x41, 0x49, 0x4e, 0x54,
	0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x10, 0x07, 0x3a, 0xa1, 0x01, 0xea, 0x41, 0x9d, 0x01, 0x0a, 0x28, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x12, 0x4c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x7d, 0x2a, 0x11, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x73, 0x32, 0x10, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x22, 0x8d, 0x02, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x12, 0x28, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x23, 0x0a, 0x08, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x88, 0x01, 0x01, 0x42,
	0x09, 0x0a, 0x07, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x22, 0xc4, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x12, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x52, 0x11, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x62,
	0x0a, 0x1a, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xa2, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x35,
	0x0a, 0x14, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x12, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x49, 0x64, 0x12, 0x5c, 0x0a, 0x11, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x10, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x89, 0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0x87, 0x04, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a,
	0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x6d, 0x0a, 0x0f, 0x61,
	0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x66, 0x6f,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x61, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0x41, 0x0a, 0x13, 0x41, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x32, 0xee, 0x07,
	0x0a, 0x08, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x12, 0xd0, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x12, 0xbd, 0x01,
	0x0a, 0x13, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9b, 0x02,
	0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xa8, 0x01, 0xca, 0x41, 0x25, 0x0a, 0x10, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x2d, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2c, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4a, 0x3a, 0x11, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x12, 0xe3, 0x01, 0x0a, 0x16,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x71,
	0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x1a, 0x4b, 0xca, 0x41, 0x17, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xbd,
	0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x42,
	0x0d, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x70, 0x62, 0x3b,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x44, 0x52, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_backupdr_v1_backupdr_proto_rawDescOnce sync.Once
	file_google_cloud_backupdr_v1_backupdr_proto_rawDescData = file_google_cloud_backupdr_v1_backupdr_proto_rawDesc
)

func file_google_cloud_backupdr_v1_backupdr_proto_rawDescGZIP() []byte {
	file_google_cloud_backupdr_v1_backupdr_proto_rawDescOnce.Do(func() {
		file_google_cloud_backupdr_v1_backupdr_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_backupdr_v1_backupdr_proto_rawDescData)
	})
	return file_google_cloud_backupdr_v1_backupdr_proto_rawDescData
}

var file_google_cloud_backupdr_v1_backupdr_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_backupdr_v1_backupdr_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_backupdr_v1_backupdr_proto_goTypes = []interface{}{
	(NetworkConfig_PeeringMode)(0),               // 0: google.cloud.backupdr.v1.NetworkConfig.PeeringMode
	(ManagementServer_InstanceType)(0),           // 1: google.cloud.backupdr.v1.ManagementServer.InstanceType
	(ManagementServer_InstanceState)(0),          // 2: google.cloud.backupdr.v1.ManagementServer.InstanceState
	(*NetworkConfig)(nil),                        // 3: google.cloud.backupdr.v1.NetworkConfig
	(*ManagementURI)(nil),                        // 4: google.cloud.backupdr.v1.ManagementURI
	(*WorkforceIdentityBasedManagementURI)(nil),  // 5: google.cloud.backupdr.v1.WorkforceIdentityBasedManagementURI
	(*WorkforceIdentityBasedOAuth2ClientID)(nil), // 6: google.cloud.backupdr.v1.WorkforceIdentityBasedOAuth2ClientID
	(*ManagementServer)(nil),                     // 7: google.cloud.backupdr.v1.ManagementServer
	(*ListManagementServersRequest)(nil),         // 8: google.cloud.backupdr.v1.ListManagementServersRequest
	(*ListManagementServersResponse)(nil),        // 9: google.cloud.backupdr.v1.ListManagementServersResponse
	(*GetManagementServerRequest)(nil),           // 10: google.cloud.backupdr.v1.GetManagementServerRequest
	(*CreateManagementServerRequest)(nil),        // 11: google.cloud.backupdr.v1.CreateManagementServerRequest
	(*DeleteManagementServerRequest)(nil),        // 12: google.cloud.backupdr.v1.DeleteManagementServerRequest
	(*OperationMetadata)(nil),                    // 13: google.cloud.backupdr.v1.OperationMetadata
	nil,                                          // 14: google.cloud.backupdr.v1.ManagementServer.LabelsEntry
	nil,                                          // 15: google.cloud.backupdr.v1.OperationMetadata.AdditionalInfoEntry
	(*timestamppb.Timestamp)(nil),                // 16: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),              // 17: google.longrunning.Operation
}
var file_google_cloud_backupdr_v1_backupdr_proto_depIdxs = []int32{
	0,  // 0: google.cloud.backupdr.v1.NetworkConfig.peering_mode:type_name -> google.cloud.backupdr.v1.NetworkConfig.PeeringMode
	14, // 1: google.cloud.backupdr.v1.ManagementServer.labels:type_name -> google.cloud.backupdr.v1.ManagementServer.LabelsEntry
	16, // 2: google.cloud.backupdr.v1.ManagementServer.create_time:type_name -> google.protobuf.Timestamp
	16, // 3: google.cloud.backupdr.v1.ManagementServer.update_time:type_name -> google.protobuf.Timestamp
	1,  // 4: google.cloud.backupdr.v1.ManagementServer.type:type_name -> google.cloud.backupdr.v1.ManagementServer.InstanceType
	4,  // 5: google.cloud.backupdr.v1.ManagementServer.management_uri:type_name -> google.cloud.backupdr.v1.ManagementURI
	5,  // 6: google.cloud.backupdr.v1.ManagementServer.workforce_identity_based_management_uri:type_name -> google.cloud.backupdr.v1.WorkforceIdentityBasedManagementURI
	2,  // 7: google.cloud.backupdr.v1.ManagementServer.state:type_name -> google.cloud.backupdr.v1.ManagementServer.InstanceState
	3,  // 8: google.cloud.backupdr.v1.ManagementServer.networks:type_name -> google.cloud.backupdr.v1.NetworkConfig
	6,  // 9: google.cloud.backupdr.v1.ManagementServer.workforce_identity_based_oauth2_client_id:type_name -> google.cloud.backupdr.v1.WorkforceIdentityBasedOAuth2ClientID
	7,  // 10: google.cloud.backupdr.v1.ListManagementServersResponse.management_servers:type_name -> google.cloud.backupdr.v1.ManagementServer
	7,  // 11: google.cloud.backupdr.v1.CreateManagementServerRequest.management_server:type_name -> google.cloud.backupdr.v1.ManagementServer
	16, // 12: google.cloud.backupdr.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	16, // 13: google.cloud.backupdr.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	15, // 14: google.cloud.backupdr.v1.OperationMetadata.additional_info:type_name -> google.cloud.backupdr.v1.OperationMetadata.AdditionalInfoEntry
	8,  // 15: google.cloud.backupdr.v1.BackupDR.ListManagementServers:input_type -> google.cloud.backupdr.v1.ListManagementServersRequest
	10, // 16: google.cloud.backupdr.v1.BackupDR.GetManagementServer:input_type -> google.cloud.backupdr.v1.GetManagementServerRequest
	11, // 17: google.cloud.backupdr.v1.BackupDR.CreateManagementServer:input_type -> google.cloud.backupdr.v1.CreateManagementServerRequest
	12, // 18: google.cloud.backupdr.v1.BackupDR.DeleteManagementServer:input_type -> google.cloud.backupdr.v1.DeleteManagementServerRequest
	9,  // 19: google.cloud.backupdr.v1.BackupDR.ListManagementServers:output_type -> google.cloud.backupdr.v1.ListManagementServersResponse
	7,  // 20: google.cloud.backupdr.v1.BackupDR.GetManagementServer:output_type -> google.cloud.backupdr.v1.ManagementServer
	17, // 21: google.cloud.backupdr.v1.BackupDR.CreateManagementServer:output_type -> google.longrunning.Operation
	17, // 22: google.cloud.backupdr.v1.BackupDR.DeleteManagementServer:output_type -> google.longrunning.Operation
	19, // [19:23] is the sub-list for method output_type
	15, // [15:19] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_backupdr_v1_backupdr_proto_init() }
func file_google_cloud_backupdr_v1_backupdr_proto_init() {
	if File_google_cloud_backupdr_v1_backupdr_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagementURI); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkforceIdentityBasedManagementURI); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkforceIdentityBasedOAuth2ClientID); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagementServer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListManagementServersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListManagementServersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetManagementServerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateManagementServerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteManagementServerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_backupdr_v1_backupdr_proto_msgTypes[5].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_backupdr_v1_backupdr_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_backupdr_v1_backupdr_proto_goTypes,
		DependencyIndexes: file_google_cloud_backupdr_v1_backupdr_proto_depIdxs,
		EnumInfos:         file_google_cloud_backupdr_v1_backupdr_proto_enumTypes,
		MessageInfos:      file_google_cloud_backupdr_v1_backupdr_proto_msgTypes,
	}.Build()
	File_google_cloud_backupdr_v1_backupdr_proto = out.File
	file_google_cloud_backupdr_v1_backupdr_proto_rawDesc = nil
	file_google_cloud_backupdr_v1_backupdr_proto_goTypes = nil
	file_google_cloud_backupdr_v1_backupdr_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BackupDRClient is the client API for BackupDR service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BackupDRClient interface {
	// Lists ManagementServers in a given project and location.
	ListManagementServers(ctx context.Context, in *ListManagementServersRequest, opts ...grpc.CallOption) (*ListManagementServersResponse, error)
	// Gets details of a single ManagementServer.
	GetManagementServer(ctx context.Context, in *GetManagementServerRequest, opts ...grpc.CallOption) (*ManagementServer, error)
	// Creates a new ManagementServer in a given project and location.
	CreateManagementServer(ctx context.Context, in *CreateManagementServerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ManagementServer.
	DeleteManagementServer(ctx context.Context, in *DeleteManagementServerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type backupDRClient struct {
	cc grpc.ClientConnInterface
}

func NewBackupDRClient(cc grpc.ClientConnInterface) BackupDRClient {
	return &backupDRClient{cc}
}

func (c *backupDRClient) ListManagementServers(ctx context.Context, in *ListManagementServersRequest, opts ...grpc.CallOption) (*ListManagementServersResponse, error) {
	out := new(ListManagementServersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.backupdr.v1.BackupDR/ListManagementServers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupDRClient) GetManagementServer(ctx context.Context, in *GetManagementServerRequest, opts ...grpc.CallOption) (*ManagementServer, error) {
	out := new(ManagementServer)
	err := c.cc.Invoke(ctx, "/google.cloud.backupdr.v1.BackupDR/GetManagementServer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupDRClient) CreateManagementServer(ctx context.Context, in *CreateManagementServerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.backupdr.v1.BackupDR/CreateManagementServer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupDRClient) DeleteManagementServer(ctx context.Context, in *DeleteManagementServerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.backupdr.v1.BackupDR/DeleteManagementServer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BackupDRServer is the server API for BackupDR service.
type BackupDRServer interface {
	// Lists ManagementServers in a given project and location.
	ListManagementServers(context.Context, *ListManagementServersRequest) (*ListManagementServersResponse, error)
	// Gets details of a single ManagementServer.
	GetManagementServer(context.Context, *GetManagementServerRequest) (*ManagementServer, error)
	// Creates a new ManagementServer in a given project and location.
	CreateManagementServer(context.Context, *CreateManagementServerRequest) (*longrunningpb.Operation, error)
	// Deletes a single ManagementServer.
	DeleteManagementServer(context.Context, *DeleteManagementServerRequest) (*longrunningpb.Operation, error)
}

// UnimplementedBackupDRServer can be embedded to have forward compatible implementations.
type UnimplementedBackupDRServer struct {
}

func (*UnimplementedBackupDRServer) ListManagementServers(context.Context, *ListManagementServersRequest) (*ListManagementServersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListManagementServers not implemented")
}
func (*UnimplementedBackupDRServer) GetManagementServer(context.Context, *GetManagementServerRequest) (*ManagementServer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetManagementServer not implemented")
}
func (*UnimplementedBackupDRServer) CreateManagementServer(context.Context, *CreateManagementServerRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateManagementServer not implemented")
}
func (*UnimplementedBackupDRServer) DeleteManagementServer(context.Context, *DeleteManagementServerRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteManagementServer not implemented")
}

func RegisterBackupDRServer(s *grpc.Server, srv BackupDRServer) {
	s.RegisterService(&_BackupDR_serviceDesc, srv)
}

func _BackupDR_ListManagementServers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListManagementServersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupDRServer).ListManagementServers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.backupdr.v1.BackupDR/ListManagementServers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupDRServer).ListManagementServers(ctx, req.(*ListManagementServersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupDR_GetManagementServer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetManagementServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupDRServer).GetManagementServer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.backupdr.v1.BackupDR/GetManagementServer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupDRServer).GetManagementServer(ctx, req.(*GetManagementServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupDR_CreateManagementServer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateManagementServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupDRServer).CreateManagementServer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.backupdr.v1.BackupDR/CreateManagementServer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupDRServer).CreateManagementServer(ctx, req.(*CreateManagementServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupDR_DeleteManagementServer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteManagementServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupDRServer).DeleteManagementServer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.backupdr.v1.BackupDR/DeleteManagementServer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupDRServer).DeleteManagementServer(ctx, req.(*DeleteManagementServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BackupDR_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.backupdr.v1.BackupDR",
	HandlerType: (*BackupDRServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListManagementServers",
			Handler:    _BackupDR_ListManagementServers_Handler,
		},
		{
			MethodName: "GetManagementServer",
			Handler:    _BackupDR_GetManagementServer_Handler,
		},
		{
			MethodName: "CreateManagementServer",
			Handler:    _BackupDR_CreateManagementServer_Handler,
		},
		{
			MethodName: "DeleteManagementServer",
			Handler:    _BackupDR_DeleteManagementServer_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/backupdr/v1/backupdr.proto",
}
