// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/channel/v1/service.proto

package channelpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Change Type enum.
type ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType int32

const (
	// Not used.
	ListPurchasableSkusRequest_ChangeOfferPurchase_CHANGE_TYPE_UNSPECIFIED ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType = 0
	// SKU is an upgrade on the current entitlement.
	ListPurchasableSkusRequest_ChangeOfferPurchase_UPGRADE ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType = 1
	// SKU is a downgrade on the current entitlement.
	ListPurchasableSkusRequest_ChangeOfferPurchase_DOWNGRADE ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType = 2
)

// Enum value maps for ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType.
var (
	ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType_name = map[int32]string{
		0: "CHANGE_TYPE_UNSPECIFIED",
		1: "UPGRADE",
		2: "DOWNGRADE",
	}
	ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType_value = map[string]int32{
		"CHANGE_TYPE_UNSPECIFIED": 0,
		"UPGRADE":                 1,
		"DOWNGRADE":               2,
	}
)

func (x ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType) Enum() *ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType {
	p := new(ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType)
	*p = x
	return p
}

func (x ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_service_proto_enumTypes[0].Descriptor()
}

func (ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_service_proto_enumTypes[0]
}

func (x ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType.Descriptor instead.
func (ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{60, 1, 0}
}

// Request message for
// [CloudChannelService.CheckCloudIdentityAccountsExist][google.cloud.channel.v1.CloudChannelService.CheckCloudIdentityAccountsExist].
type CheckCloudIdentityAccountsExistRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The reseller account's resource name.
	// Parent uses the format: accounts/{account_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Domain to fetch for Cloud Identity account customer.
	Domain string `protobuf:"bytes,2,opt,name=domain,proto3" json:"domain,omitempty"`
}

func (x *CheckCloudIdentityAccountsExistRequest) Reset() {
	*x = CheckCloudIdentityAccountsExistRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckCloudIdentityAccountsExistRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckCloudIdentityAccountsExistRequest) ProtoMessage() {}

func (x *CheckCloudIdentityAccountsExistRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckCloudIdentityAccountsExistRequest.ProtoReflect.Descriptor instead.
func (*CheckCloudIdentityAccountsExistRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{0}
}

func (x *CheckCloudIdentityAccountsExistRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CheckCloudIdentityAccountsExistRequest) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

// Entity representing a Cloud Identity account that may be
// associated with a Channel Services API partner.
type CloudIdentityCustomerAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Returns true if a Cloud Identity account exists for a specific domain.
	Existing bool `protobuf:"varint,1,opt,name=existing,proto3" json:"existing,omitempty"`
	// Returns true if the Cloud Identity account is associated with a customer
	// of the Channel Services partner.
	Owned bool `protobuf:"varint,2,opt,name=owned,proto3" json:"owned,omitempty"`
	// If owned = true, the name of the customer that owns the Cloud Identity
	// account.
	// Customer_name uses the format:
	// accounts/{account_id}/customers/{customer_id}
	CustomerName string `protobuf:"bytes,3,opt,name=customer_name,json=customerName,proto3" json:"customer_name,omitempty"`
	// If existing = true, the Cloud Identity ID of the customer.
	CustomerCloudIdentityId string `protobuf:"bytes,4,opt,name=customer_cloud_identity_id,json=customerCloudIdentityId,proto3" json:"customer_cloud_identity_id,omitempty"`
}

func (x *CloudIdentityCustomerAccount) Reset() {
	*x = CloudIdentityCustomerAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudIdentityCustomerAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudIdentityCustomerAccount) ProtoMessage() {}

func (x *CloudIdentityCustomerAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudIdentityCustomerAccount.ProtoReflect.Descriptor instead.
func (*CloudIdentityCustomerAccount) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{1}
}

func (x *CloudIdentityCustomerAccount) GetExisting() bool {
	if x != nil {
		return x.Existing
	}
	return false
}

func (x *CloudIdentityCustomerAccount) GetOwned() bool {
	if x != nil {
		return x.Owned
	}
	return false
}

func (x *CloudIdentityCustomerAccount) GetCustomerName() string {
	if x != nil {
		return x.CustomerName
	}
	return ""
}

func (x *CloudIdentityCustomerAccount) GetCustomerCloudIdentityId() string {
	if x != nil {
		return x.CustomerCloudIdentityId
	}
	return ""
}

// Response message for
// [CloudChannelService.CheckCloudIdentityAccountsExist][google.cloud.channel.v1.CloudChannelService.CheckCloudIdentityAccountsExist].
type CheckCloudIdentityAccountsExistResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Identity accounts associated with the domain.
	CloudIdentityAccounts []*CloudIdentityCustomerAccount `protobuf:"bytes,1,rep,name=cloud_identity_accounts,json=cloudIdentityAccounts,proto3" json:"cloud_identity_accounts,omitempty"`
}

func (x *CheckCloudIdentityAccountsExistResponse) Reset() {
	*x = CheckCloudIdentityAccountsExistResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckCloudIdentityAccountsExistResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckCloudIdentityAccountsExistResponse) ProtoMessage() {}

func (x *CheckCloudIdentityAccountsExistResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckCloudIdentityAccountsExistResponse.ProtoReflect.Descriptor instead.
func (*CheckCloudIdentityAccountsExistResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{2}
}

func (x *CheckCloudIdentityAccountsExistResponse) GetCloudIdentityAccounts() []*CloudIdentityCustomerAccount {
	if x != nil {
		return x.CloudIdentityAccounts
	}
	return nil
}

// Request message for
// [CloudChannelService.ListCustomers][google.cloud.channel.v1.CloudChannelService.ListCustomers]
type ListCustomersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller account to list customers from.
	// Parent uses the format: accounts/{account_id}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of customers to return. The service may return
	// fewer than this value. If unspecified, returns at most 10 customers. The
	// maximum value is 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results other than the first page.
	// Obtained through
	// [ListCustomersResponse.next_page_token][google.cloud.channel.v1.ListCustomersResponse.next_page_token]
	// of the previous
	// [CloudChannelService.ListCustomers][google.cloud.channel.v1.CloudChannelService.ListCustomers]
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filters applied to the [CloudChannelService.ListCustomers]
	// results. See
	// https://cloud.google.com/channel/docs/concepts/google-cloud/filter-customers
	// for more information.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListCustomersRequest) Reset() {
	*x = ListCustomersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomersRequest) ProtoMessage() {}

func (x *ListCustomersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomersRequest.ProtoReflect.Descriptor instead.
func (*ListCustomersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListCustomersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCustomersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for
// [CloudChannelService.ListCustomers][google.cloud.channel.v1.CloudChannelService.ListCustomers].
type ListCustomersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The customers belonging to a reseller or distributor.
	Customers []*Customer `protobuf:"bytes,1,rep,name=customers,proto3" json:"customers,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListCustomersRequest.page_token][google.cloud.channel.v1.ListCustomersRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomersResponse) Reset() {
	*x = ListCustomersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomersResponse) ProtoMessage() {}

func (x *ListCustomersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomersResponse.ProtoReflect.Descriptor instead.
func (*ListCustomersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListCustomersResponse) GetCustomers() []*Customer {
	if x != nil {
		return x.Customers
	}
	return nil
}

func (x *ListCustomersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [CloudChannelService.GetCustomer][google.cloud.channel.v1.CloudChannelService.GetCustomer].
type GetCustomerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the customer to retrieve.
	// Name uses the format: accounts/{account_id}/customers/{customer_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomerRequest) Reset() {
	*x = GetCustomerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomerRequest) ProtoMessage() {}

func (x *GetCustomerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomerRequest.ProtoReflect.Descriptor instead.
func (*GetCustomerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{5}
}

func (x *GetCustomerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [CloudChannelService.CreateCustomer][google.cloud.channel.v1.CloudChannelService.CreateCustomer]
type CreateCustomerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of reseller account in which to create the
	// customer. Parent uses the format: accounts/{account_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The customer to create.
	Customer *Customer `protobuf:"bytes,2,opt,name=customer,proto3" json:"customer,omitempty"`
}

func (x *CreateCustomerRequest) Reset() {
	*x = CreateCustomerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomerRequest) ProtoMessage() {}

func (x *CreateCustomerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomerRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateCustomerRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomerRequest) GetCustomer() *Customer {
	if x != nil {
		return x.Customer
	}
	return nil
}

// Request message for
// [CloudChannelService.UpdateCustomer][google.cloud.channel.v1.CloudChannelService.UpdateCustomer].
type UpdateCustomerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. New contents of the customer.
	Customer *Customer `protobuf:"bytes,2,opt,name=customer,proto3" json:"customer,omitempty"`
	// The update mask that applies to the resource.
	// Optional.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCustomerRequest) Reset() {
	*x = UpdateCustomerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomerRequest) ProtoMessage() {}

func (x *UpdateCustomerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomerRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateCustomerRequest) GetCustomer() *Customer {
	if x != nil {
		return x.Customer
	}
	return nil
}

func (x *UpdateCustomerRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [CloudChannelService.DeleteCustomer][google.cloud.channel.v1.CloudChannelService.DeleteCustomer].
type DeleteCustomerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the customer to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCustomerRequest) Reset() {
	*x = DeleteCustomerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCustomerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCustomerRequest) ProtoMessage() {}

func (x *DeleteCustomerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCustomerRequest.ProtoReflect.Descriptor instead.
func (*DeleteCustomerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteCustomerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [CloudChannelService.ImportCustomer][google.cloud.channel.v1.CloudChannelService.ImportCustomer]
type ImportCustomerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the identity of the transfer customer.
	// A customer's cloud_identity_id or domain is required to look up the
	// customer's Cloud Identity. For Team customers, only the cloud_identity_id
	// option is valid.
	//
	// Types that are assignable to CustomerIdentity:
	//
	//	*ImportCustomerRequest_Domain
	//	*ImportCustomerRequest_CloudIdentityId
	CustomerIdentity isImportCustomerRequest_CustomerIdentity `protobuf_oneof:"customer_identity"`
	// Required. The resource name of the reseller's account.
	// Parent takes the format: accounts/{account_id} or
	// accounts/{account_id}/channelPartnerLinks/{channel_partner_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The super admin of the resold customer generates this token to
	// authorize a reseller to access their Cloud Identity and purchase
	// entitlements on their behalf. You can omit this token after authorization.
	// See https://support.google.com/a/answer/7643790 for more details.
	AuthToken string `protobuf:"bytes,4,opt,name=auth_token,json=authToken,proto3" json:"auth_token,omitempty"`
	// Required. Choose to overwrite an existing customer if found.
	// This must be set to true if there is an existing customer with a
	// conflicting region code or domain.
	OverwriteIfExists bool `protobuf:"varint,5,opt,name=overwrite_if_exists,json=overwriteIfExists,proto3" json:"overwrite_if_exists,omitempty"`
	// Optional. Cloud Identity ID of a channel partner who will be the direct
	// reseller for the customer's order. This field is required for 2-tier
	// transfer scenarios and can be provided via the request Parent binding as
	// well.
	ChannelPartnerId string `protobuf:"bytes,6,opt,name=channel_partner_id,json=channelPartnerId,proto3" json:"channel_partner_id,omitempty"`
	// Optional. Specifies the customer that will receive imported Cloud Identity
	// information.
	// Format: accounts/{account_id}/customers/{customer_id}
	Customer string `protobuf:"bytes,7,opt,name=customer,proto3" json:"customer,omitempty"`
}

func (x *ImportCustomerRequest) Reset() {
	*x = ImportCustomerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportCustomerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportCustomerRequest) ProtoMessage() {}

func (x *ImportCustomerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportCustomerRequest.ProtoReflect.Descriptor instead.
func (*ImportCustomerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{9}
}

func (m *ImportCustomerRequest) GetCustomerIdentity() isImportCustomerRequest_CustomerIdentity {
	if m != nil {
		return m.CustomerIdentity
	}
	return nil
}

func (x *ImportCustomerRequest) GetDomain() string {
	if x, ok := x.GetCustomerIdentity().(*ImportCustomerRequest_Domain); ok {
		return x.Domain
	}
	return ""
}

func (x *ImportCustomerRequest) GetCloudIdentityId() string {
	if x, ok := x.GetCustomerIdentity().(*ImportCustomerRequest_CloudIdentityId); ok {
		return x.CloudIdentityId
	}
	return ""
}

func (x *ImportCustomerRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportCustomerRequest) GetAuthToken() string {
	if x != nil {
		return x.AuthToken
	}
	return ""
}

func (x *ImportCustomerRequest) GetOverwriteIfExists() bool {
	if x != nil {
		return x.OverwriteIfExists
	}
	return false
}

func (x *ImportCustomerRequest) GetChannelPartnerId() string {
	if x != nil {
		return x.ChannelPartnerId
	}
	return ""
}

func (x *ImportCustomerRequest) GetCustomer() string {
	if x != nil {
		return x.Customer
	}
	return ""
}

type isImportCustomerRequest_CustomerIdentity interface {
	isImportCustomerRequest_CustomerIdentity()
}

type ImportCustomerRequest_Domain struct {
	// Required. Customer domain.
	Domain string `protobuf:"bytes,2,opt,name=domain,proto3,oneof"`
}

type ImportCustomerRequest_CloudIdentityId struct {
	// Required. Customer's Cloud Identity ID
	CloudIdentityId string `protobuf:"bytes,3,opt,name=cloud_identity_id,json=cloudIdentityId,proto3,oneof"`
}

func (*ImportCustomerRequest_Domain) isImportCustomerRequest_CustomerIdentity() {}

func (*ImportCustomerRequest_CloudIdentityId) isImportCustomerRequest_CustomerIdentity() {}

// Request message for
// [CloudChannelService.ProvisionCloudIdentity][google.cloud.channel.v1.CloudChannelService.ProvisionCloudIdentity]
type ProvisionCloudIdentityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the customer.
	// Format: accounts/{account_id}/customers/{customer_id}
	Customer string `protobuf:"bytes,1,opt,name=customer,proto3" json:"customer,omitempty"`
	// CloudIdentity-specific customer information.
	CloudIdentityInfo *CloudIdentityInfo `protobuf:"bytes,2,opt,name=cloud_identity_info,json=cloudIdentityInfo,proto3" json:"cloud_identity_info,omitempty"`
	// Admin user information.
	User *AdminUser `protobuf:"bytes,3,opt,name=user,proto3" json:"user,omitempty"`
	// Validate the request and preview the review, but do not post it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *ProvisionCloudIdentityRequest) Reset() {
	*x = ProvisionCloudIdentityRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionCloudIdentityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionCloudIdentityRequest) ProtoMessage() {}

func (x *ProvisionCloudIdentityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionCloudIdentityRequest.ProtoReflect.Descriptor instead.
func (*ProvisionCloudIdentityRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{10}
}

func (x *ProvisionCloudIdentityRequest) GetCustomer() string {
	if x != nil {
		return x.Customer
	}
	return ""
}

func (x *ProvisionCloudIdentityRequest) GetCloudIdentityInfo() *CloudIdentityInfo {
	if x != nil {
		return x.CloudIdentityInfo
	}
	return nil
}

func (x *ProvisionCloudIdentityRequest) GetUser() *AdminUser {
	if x != nil {
		return x.User
	}
	return nil
}

func (x *ProvisionCloudIdentityRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for
// [CloudChannelService.ListEntitlements][google.cloud.channel.v1.CloudChannelService.ListEntitlements]
type ListEntitlementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller's customer account to list
	// entitlements for.
	// Parent uses the format: accounts/{account_id}/customers/{customer_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server might return fewer results than
	// requested. If unspecified, return at most 50 entitlements. The maximum
	// value is 100; the server will coerce values above 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token for a page of results other than the first page.
	// Obtained using
	// [ListEntitlementsResponse.next_page_token][google.cloud.channel.v1.ListEntitlementsResponse.next_page_token]
	// of the previous
	// [CloudChannelService.ListEntitlements][google.cloud.channel.v1.CloudChannelService.ListEntitlements]
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEntitlementsRequest) Reset() {
	*x = ListEntitlementsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntitlementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntitlementsRequest) ProtoMessage() {}

func (x *ListEntitlementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntitlementsRequest.ProtoReflect.Descriptor instead.
func (*ListEntitlementsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListEntitlementsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntitlementsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntitlementsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [CloudChannelService.ListEntitlements][google.cloud.channel.v1.CloudChannelService.ListEntitlements].
type ListEntitlementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The reseller customer's entitlements.
	Entitlements []*Entitlement `protobuf:"bytes,1,rep,name=entitlements,proto3" json:"entitlements,omitempty"`
	// A token to list the next page of results.
	// Pass to
	// [ListEntitlementsRequest.page_token][google.cloud.channel.v1.ListEntitlementsRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntitlementsResponse) Reset() {
	*x = ListEntitlementsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntitlementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntitlementsResponse) ProtoMessage() {}

func (x *ListEntitlementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntitlementsResponse.ProtoReflect.Descriptor instead.
func (*ListEntitlementsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{12}
}

func (x *ListEntitlementsResponse) GetEntitlements() []*Entitlement {
	if x != nil {
		return x.Entitlements
	}
	return nil
}

func (x *ListEntitlementsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [CloudChannelService.ListTransferableSkus][google.cloud.channel.v1.CloudChannelService.ListTransferableSkus]
type ListTransferableSkusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the identity of transferred customer.
	// Either a cloud_identity_id of the customer or the customer name is
	// required to look up transferable SKUs.
	//
	// Types that are assignable to TransferredCustomerIdentity:
	//
	//	*ListTransferableSkusRequest_CloudIdentityId
	//	*ListTransferableSkusRequest_CustomerName
	TransferredCustomerIdentity isListTransferableSkusRequest_TransferredCustomerIdentity `protobuf_oneof:"transferred_customer_identity"`
	// Required. The reseller account's resource name.
	// Parent uses the format: accounts/{account_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The requested page size. Server might return fewer results than requested.
	// If unspecified, returns at most 100 SKUs.
	// The maximum value is 1000; the server will coerce values above 1000.
	// Optional.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token for a page of results other than the first page.
	// Obtained using
	// [ListTransferableSkusResponse.next_page_token][google.cloud.channel.v1.ListTransferableSkusResponse.next_page_token]
	// of the previous
	// [CloudChannelService.ListTransferableSkus][google.cloud.channel.v1.CloudChannelService.ListTransferableSkus]
	// call. Optional.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The super admin of the resold customer generates this token to
	// authorize a reseller to access their Cloud Identity and purchase
	// entitlements on their behalf. You can omit this token after authorization.
	// See https://support.google.com/a/answer/7643790 for more details.
	AuthToken string `protobuf:"bytes,5,opt,name=auth_token,json=authToken,proto3" json:"auth_token,omitempty"`
	// The BCP-47 language code. For example, "en-US". The
	// response will localize in the corresponding language code, if specified.
	// The default value is "en-US".
	// Optional.
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListTransferableSkusRequest) Reset() {
	*x = ListTransferableSkusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTransferableSkusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferableSkusRequest) ProtoMessage() {}

func (x *ListTransferableSkusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferableSkusRequest.ProtoReflect.Descriptor instead.
func (*ListTransferableSkusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{13}
}

func (m *ListTransferableSkusRequest) GetTransferredCustomerIdentity() isListTransferableSkusRequest_TransferredCustomerIdentity {
	if m != nil {
		return m.TransferredCustomerIdentity
	}
	return nil
}

func (x *ListTransferableSkusRequest) GetCloudIdentityId() string {
	if x, ok := x.GetTransferredCustomerIdentity().(*ListTransferableSkusRequest_CloudIdentityId); ok {
		return x.CloudIdentityId
	}
	return ""
}

func (x *ListTransferableSkusRequest) GetCustomerName() string {
	if x, ok := x.GetTransferredCustomerIdentity().(*ListTransferableSkusRequest_CustomerName); ok {
		return x.CustomerName
	}
	return ""
}

func (x *ListTransferableSkusRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTransferableSkusRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTransferableSkusRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTransferableSkusRequest) GetAuthToken() string {
	if x != nil {
		return x.AuthToken
	}
	return ""
}

func (x *ListTransferableSkusRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

type isListTransferableSkusRequest_TransferredCustomerIdentity interface {
	isListTransferableSkusRequest_TransferredCustomerIdentity()
}

type ListTransferableSkusRequest_CloudIdentityId struct {
	// Customer's Cloud Identity ID
	CloudIdentityId string `protobuf:"bytes,4,opt,name=cloud_identity_id,json=cloudIdentityId,proto3,oneof"`
}

type ListTransferableSkusRequest_CustomerName struct {
	// A reseller is required to create a customer and use the resource name of
	// the created customer here.
	// Customer_name uses the format:
	// accounts/{account_id}/customers/{customer_id}
	CustomerName string `protobuf:"bytes,7,opt,name=customer_name,json=customerName,proto3,oneof"`
}

func (*ListTransferableSkusRequest_CloudIdentityId) isListTransferableSkusRequest_TransferredCustomerIdentity() {
}

func (*ListTransferableSkusRequest_CustomerName) isListTransferableSkusRequest_TransferredCustomerIdentity() {
}

// Response message for
// [CloudChannelService.ListTransferableSkus][google.cloud.channel.v1.CloudChannelService.ListTransferableSkus].
type ListTransferableSkusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about existing SKUs for a customer that needs a transfer.
	TransferableSkus []*TransferableSku `protobuf:"bytes,1,rep,name=transferable_skus,json=transferableSkus,proto3" json:"transferable_skus,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListTransferableSkusRequest.page_token][google.cloud.channel.v1.ListTransferableSkusRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTransferableSkusResponse) Reset() {
	*x = ListTransferableSkusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTransferableSkusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferableSkusResponse) ProtoMessage() {}

func (x *ListTransferableSkusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferableSkusResponse.ProtoReflect.Descriptor instead.
func (*ListTransferableSkusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{14}
}

func (x *ListTransferableSkusResponse) GetTransferableSkus() []*TransferableSku {
	if x != nil {
		return x.TransferableSkus
	}
	return nil
}

func (x *ListTransferableSkusResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers]
type ListTransferableOffersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the identity of transferred customer.
	// Either a cloud_identity_id of the customer or the customer name is
	// required to look up transferrable Offers.
	//
	// Types that are assignable to TransferredCustomerIdentity:
	//
	//	*ListTransferableOffersRequest_CloudIdentityId
	//	*ListTransferableOffersRequest_CustomerName
	TransferredCustomerIdentity isListTransferableOffersRequest_TransferredCustomerIdentity `protobuf_oneof:"transferred_customer_identity"`
	// Required. The resource name of the reseller's account.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server might return fewer results than requested.
	// If unspecified, returns at most 100 offers.
	// The maximum value is 1000; the server will coerce values above 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token for a page of results other than the first page.
	// Obtained using
	// [ListTransferableOffersResponse.next_page_token][google.cloud.channel.v1.ListTransferableOffersResponse.next_page_token]
	// of the previous
	// [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers]
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Required. The SKU to look up Offers for.
	Sku string `protobuf:"bytes,6,opt,name=sku,proto3" json:"sku,omitempty"`
	// Optional. The BCP-47 language code. For example, "en-US". The
	// response will localize in the corresponding language code, if specified.
	// The default value is "en-US".
	LanguageCode string `protobuf:"bytes,7,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The Billing Account to look up Offers for. Format:
	// accounts/{account_id}/billingAccounts/{billing_account_id}.
	//
	// This field is only relevant for multi-currency accounts. It should be left
	// empty for single currency accounts.
	BillingAccount string `protobuf:"bytes,8,opt,name=billing_account,json=billingAccount,proto3" json:"billing_account,omitempty"`
}

func (x *ListTransferableOffersRequest) Reset() {
	*x = ListTransferableOffersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTransferableOffersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferableOffersRequest) ProtoMessage() {}

func (x *ListTransferableOffersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferableOffersRequest.ProtoReflect.Descriptor instead.
func (*ListTransferableOffersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{15}
}

func (m *ListTransferableOffersRequest) GetTransferredCustomerIdentity() isListTransferableOffersRequest_TransferredCustomerIdentity {
	if m != nil {
		return m.TransferredCustomerIdentity
	}
	return nil
}

func (x *ListTransferableOffersRequest) GetCloudIdentityId() string {
	if x, ok := x.GetTransferredCustomerIdentity().(*ListTransferableOffersRequest_CloudIdentityId); ok {
		return x.CloudIdentityId
	}
	return ""
}

func (x *ListTransferableOffersRequest) GetCustomerName() string {
	if x, ok := x.GetTransferredCustomerIdentity().(*ListTransferableOffersRequest_CustomerName); ok {
		return x.CustomerName
	}
	return ""
}

func (x *ListTransferableOffersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTransferableOffersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTransferableOffersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTransferableOffersRequest) GetSku() string {
	if x != nil {
		return x.Sku
	}
	return ""
}

func (x *ListTransferableOffersRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ListTransferableOffersRequest) GetBillingAccount() string {
	if x != nil {
		return x.BillingAccount
	}
	return ""
}

type isListTransferableOffersRequest_TransferredCustomerIdentity interface {
	isListTransferableOffersRequest_TransferredCustomerIdentity()
}

type ListTransferableOffersRequest_CloudIdentityId struct {
	// Customer's Cloud Identity ID
	CloudIdentityId string `protobuf:"bytes,4,opt,name=cloud_identity_id,json=cloudIdentityId,proto3,oneof"`
}

type ListTransferableOffersRequest_CustomerName struct {
	// A reseller should create a customer and use the resource name of
	// that customer here.
	CustomerName string `protobuf:"bytes,5,opt,name=customer_name,json=customerName,proto3,oneof"`
}

func (*ListTransferableOffersRequest_CloudIdentityId) isListTransferableOffersRequest_TransferredCustomerIdentity() {
}

func (*ListTransferableOffersRequest_CustomerName) isListTransferableOffersRequest_TransferredCustomerIdentity() {
}

// Response message for
// [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers].
type ListTransferableOffersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about Offers for a customer that can be used for
	// transfer.
	TransferableOffers []*TransferableOffer `protobuf:"bytes,1,rep,name=transferable_offers,json=transferableOffers,proto3" json:"transferable_offers,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListTransferableOffersRequest.page_token][google.cloud.channel.v1.ListTransferableOffersRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTransferableOffersResponse) Reset() {
	*x = ListTransferableOffersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTransferableOffersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferableOffersResponse) ProtoMessage() {}

func (x *ListTransferableOffersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferableOffersResponse.ProtoReflect.Descriptor instead.
func (*ListTransferableOffersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{16}
}

func (x *ListTransferableOffersResponse) GetTransferableOffers() []*TransferableOffer {
	if x != nil {
		return x.TransferableOffers
	}
	return nil
}

func (x *ListTransferableOffersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// TransferableOffer represents an Offer that can be used in Transfer.
// Read-only.
type TransferableOffer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Offer with parameter constraints updated to allow the Transfer.
	Offer *Offer `protobuf:"bytes,1,opt,name=offer,proto3" json:"offer,omitempty"`
}

func (x *TransferableOffer) Reset() {
	*x = TransferableOffer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferableOffer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferableOffer) ProtoMessage() {}

func (x *TransferableOffer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferableOffer.ProtoReflect.Descriptor instead.
func (*TransferableOffer) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{17}
}

func (x *TransferableOffer) GetOffer() *Offer {
	if x != nil {
		return x.Offer
	}
	return nil
}

// Request message for
// [CloudChannelService.GetEntitlement][google.cloud.channel.v1.CloudChannelService.GetEntitlement].
type GetEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entitlement to retrieve.
	// Name uses the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEntitlementRequest) Reset() {
	*x = GetEntitlementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntitlementRequest) ProtoMessage() {}

func (x *GetEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntitlementRequest.ProtoReflect.Descriptor instead.
func (*GetEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{18}
}

func (x *GetEntitlementRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [CloudChannelService.ListChannelPartnerLinks][google.cloud.channel.v1.CloudChannelService.ListChannelPartnerLinks]
type ListChannelPartnerLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller account for listing channel
	// partner links. Parent uses the format: accounts/{account_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server might return fewer results than
	// requested. If unspecified, server will pick a default size (25). The
	// maximum value is 200; the server will coerce values above 200.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token for a page of results other than the first page.
	// Obtained using
	// [ListChannelPartnerLinksResponse.next_page_token][google.cloud.channel.v1.ListChannelPartnerLinksResponse.next_page_token]
	// of the previous
	// [CloudChannelService.ListChannelPartnerLinks][google.cloud.channel.v1.CloudChannelService.ListChannelPartnerLinks]
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The level of granularity the ChannelPartnerLink will display.
	View ChannelPartnerLinkView `protobuf:"varint,4,opt,name=view,proto3,enum=google.cloud.channel.v1.ChannelPartnerLinkView" json:"view,omitempty"`
}

func (x *ListChannelPartnerLinksRequest) Reset() {
	*x = ListChannelPartnerLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListChannelPartnerLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChannelPartnerLinksRequest) ProtoMessage() {}

func (x *ListChannelPartnerLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChannelPartnerLinksRequest.ProtoReflect.Descriptor instead.
func (*ListChannelPartnerLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{19}
}

func (x *ListChannelPartnerLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListChannelPartnerLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListChannelPartnerLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListChannelPartnerLinksRequest) GetView() ChannelPartnerLinkView {
	if x != nil {
		return x.View
	}
	return ChannelPartnerLinkView_UNSPECIFIED
}

// Response message for
// [CloudChannelService.ListChannelPartnerLinks][google.cloud.channel.v1.CloudChannelService.ListChannelPartnerLinks].
type ListChannelPartnerLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Channel partner links for a reseller.
	ChannelPartnerLinks []*ChannelPartnerLink `protobuf:"bytes,1,rep,name=channel_partner_links,json=channelPartnerLinks,proto3" json:"channel_partner_links,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListChannelPartnerLinksRequest.page_token][google.cloud.channel.v1.ListChannelPartnerLinksRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListChannelPartnerLinksResponse) Reset() {
	*x = ListChannelPartnerLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListChannelPartnerLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChannelPartnerLinksResponse) ProtoMessage() {}

func (x *ListChannelPartnerLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChannelPartnerLinksResponse.ProtoReflect.Descriptor instead.
func (*ListChannelPartnerLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{20}
}

func (x *ListChannelPartnerLinksResponse) GetChannelPartnerLinks() []*ChannelPartnerLink {
	if x != nil {
		return x.ChannelPartnerLinks
	}
	return nil
}

func (x *ListChannelPartnerLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [CloudChannelService.GetChannelPartnerLink][google.cloud.channel.v1.CloudChannelService.GetChannelPartnerLink].
type GetChannelPartnerLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the channel partner link to retrieve.
	// Name uses the format: accounts/{account_id}/channelPartnerLinks/{id}
	// where {id} is the Cloud Identity ID of the partner.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The level of granularity the ChannelPartnerLink will display.
	View ChannelPartnerLinkView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.channel.v1.ChannelPartnerLinkView" json:"view,omitempty"`
}

func (x *GetChannelPartnerLinkRequest) Reset() {
	*x = GetChannelPartnerLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetChannelPartnerLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetChannelPartnerLinkRequest) ProtoMessage() {}

func (x *GetChannelPartnerLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetChannelPartnerLinkRequest.ProtoReflect.Descriptor instead.
func (*GetChannelPartnerLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{21}
}

func (x *GetChannelPartnerLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetChannelPartnerLinkRequest) GetView() ChannelPartnerLinkView {
	if x != nil {
		return x.View
	}
	return ChannelPartnerLinkView_UNSPECIFIED
}

// Request message for
// [CloudChannelService.CreateChannelPartnerLink][google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerLink]
type CreateChannelPartnerLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Create a channel partner link for the provided reseller account's
	// resource name.
	// Parent uses the format: accounts/{account_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The channel partner link to create.
	// Either channel_partner_link.reseller_cloud_identity_id or domain can be
	// used to create a link.
	ChannelPartnerLink *ChannelPartnerLink `protobuf:"bytes,2,opt,name=channel_partner_link,json=channelPartnerLink,proto3" json:"channel_partner_link,omitempty"`
}

func (x *CreateChannelPartnerLinkRequest) Reset() {
	*x = CreateChannelPartnerLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateChannelPartnerLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateChannelPartnerLinkRequest) ProtoMessage() {}

func (x *CreateChannelPartnerLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateChannelPartnerLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateChannelPartnerLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{22}
}

func (x *CreateChannelPartnerLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateChannelPartnerLinkRequest) GetChannelPartnerLink() *ChannelPartnerLink {
	if x != nil {
		return x.ChannelPartnerLink
	}
	return nil
}

// Request message for
// [CloudChannelService.UpdateChannelPartnerLink][google.cloud.channel.v1.CloudChannelService.UpdateChannelPartnerLink]
type UpdateChannelPartnerLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the channel partner link to cancel.
	// Name uses the format: accounts/{account_id}/channelPartnerLinks/{id}
	// where {id} is the Cloud Identity ID of the partner.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The channel partner link to update. Only
	// channel_partner_link.link_state is allowed for updates.
	ChannelPartnerLink *ChannelPartnerLink `protobuf:"bytes,2,opt,name=channel_partner_link,json=channelPartnerLink,proto3" json:"channel_partner_link,omitempty"`
	// Required. The update mask that applies to the resource.
	// The only allowable value for an update mask is
	// channel_partner_link.link_state.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateChannelPartnerLinkRequest) Reset() {
	*x = UpdateChannelPartnerLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateChannelPartnerLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateChannelPartnerLinkRequest) ProtoMessage() {}

func (x *UpdateChannelPartnerLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateChannelPartnerLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateChannelPartnerLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{23}
}

func (x *UpdateChannelPartnerLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateChannelPartnerLinkRequest) GetChannelPartnerLink() *ChannelPartnerLink {
	if x != nil {
		return x.ChannelPartnerLink
	}
	return nil
}

func (x *UpdateChannelPartnerLinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [CloudChannelService.GetCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.GetCustomerRepricingConfig].
type GetCustomerRepricingConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the CustomerRepricingConfig.
	// Format:
	// accounts/{account_id}/customers/{customer_id}/customerRepricingConfigs/{id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomerRepricingConfigRequest) Reset() {
	*x = GetCustomerRepricingConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomerRepricingConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomerRepricingConfigRequest) ProtoMessage() {}

func (x *GetCustomerRepricingConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomerRepricingConfigRequest.ProtoReflect.Descriptor instead.
func (*GetCustomerRepricingConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{24}
}

func (x *GetCustomerRepricingConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [CloudChannelService.ListCustomerRepricingConfigs][google.cloud.channel.v1.CloudChannelService.ListCustomerRepricingConfigs].
type ListCustomerRepricingConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the customer.
	// Parent uses the format: accounts/{account_id}/customers/{customer_id}.
	// Supports accounts/{account_id}/customers/- to retrieve configs for all
	// customers.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of repricing configs to return. The service
	// may return fewer than this value. If unspecified, returns a maximum of 50
	// rules. The maximum value is 100; values above 100 will be coerced to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results beyond the first page.
	// Obtained through
	// [ListCustomerRepricingConfigsResponse.next_page_token][google.cloud.channel.v1.ListCustomerRepricingConfigsResponse.next_page_token]
	// of the previous
	// [CloudChannelService.ListCustomerRepricingConfigs][google.cloud.channel.v1.CloudChannelService.ListCustomerRepricingConfigs]
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter for [CloudChannelService.ListCustomerRepricingConfigs]
	// results (customer only). You can use this filter when you support
	// a BatchGet-like query.
	// To use the filter, you must set `parent=accounts/{account_id}/customers/-`.
	//
	// Example: customer = accounts/account_id/customers/c1 OR
	// customer = accounts/account_id/customers/c2.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListCustomerRepricingConfigsRequest) Reset() {
	*x = ListCustomerRepricingConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomerRepricingConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomerRepricingConfigsRequest) ProtoMessage() {}

func (x *ListCustomerRepricingConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomerRepricingConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListCustomerRepricingConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{25}
}

func (x *ListCustomerRepricingConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomerRepricingConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomerRepricingConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCustomerRepricingConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for
// [CloudChannelService.ListCustomerRepricingConfigs][google.cloud.channel.v1.CloudChannelService.ListCustomerRepricingConfigs].
type ListCustomerRepricingConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The repricing configs for this channel partner.
	CustomerRepricingConfigs []*CustomerRepricingConfig `protobuf:"bytes,1,rep,name=customer_repricing_configs,json=customerRepricingConfigs,proto3" json:"customer_repricing_configs,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListCustomerRepricingConfigsRequest.page_token][google.cloud.channel.v1.ListCustomerRepricingConfigsRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomerRepricingConfigsResponse) Reset() {
	*x = ListCustomerRepricingConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomerRepricingConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomerRepricingConfigsResponse) ProtoMessage() {}

func (x *ListCustomerRepricingConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomerRepricingConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListCustomerRepricingConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{26}
}

func (x *ListCustomerRepricingConfigsResponse) GetCustomerRepricingConfigs() []*CustomerRepricingConfig {
	if x != nil {
		return x.CustomerRepricingConfigs
	}
	return nil
}

func (x *ListCustomerRepricingConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [CloudChannelService.CreateCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig].
type CreateCustomerRepricingConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the customer that will receive this
	// repricing config. Parent uses the format:
	// accounts/{account_id}/customers/{customer_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The CustomerRepricingConfig object to update.
	CustomerRepricingConfig *CustomerRepricingConfig `protobuf:"bytes,2,opt,name=customer_repricing_config,json=customerRepricingConfig,proto3" json:"customer_repricing_config,omitempty"`
}

func (x *CreateCustomerRepricingConfigRequest) Reset() {
	*x = CreateCustomerRepricingConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomerRepricingConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomerRepricingConfigRequest) ProtoMessage() {}

func (x *CreateCustomerRepricingConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomerRepricingConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomerRepricingConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{27}
}

func (x *CreateCustomerRepricingConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomerRepricingConfigRequest) GetCustomerRepricingConfig() *CustomerRepricingConfig {
	if x != nil {
		return x.CustomerRepricingConfig
	}
	return nil
}

// Request message for
// [CloudChannelService.UpdateCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.UpdateCustomerRepricingConfig].
type UpdateCustomerRepricingConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The CustomerRepricingConfig object to update.
	CustomerRepricingConfig *CustomerRepricingConfig `protobuf:"bytes,1,opt,name=customer_repricing_config,json=customerRepricingConfig,proto3" json:"customer_repricing_config,omitempty"`
}

func (x *UpdateCustomerRepricingConfigRequest) Reset() {
	*x = UpdateCustomerRepricingConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomerRepricingConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomerRepricingConfigRequest) ProtoMessage() {}

func (x *UpdateCustomerRepricingConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomerRepricingConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomerRepricingConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{28}
}

func (x *UpdateCustomerRepricingConfigRequest) GetCustomerRepricingConfig() *CustomerRepricingConfig {
	if x != nil {
		return x.CustomerRepricingConfig
	}
	return nil
}

// Request message for
// [CloudChannelService.DeleteCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.DeleteCustomerRepricingConfig].
type DeleteCustomerRepricingConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the customer repricing config rule to
	// delete. Format:
	// accounts/{account_id}/customers/{customer_id}/customerRepricingConfigs/{id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCustomerRepricingConfigRequest) Reset() {
	*x = DeleteCustomerRepricingConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCustomerRepricingConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCustomerRepricingConfigRequest) ProtoMessage() {}

func (x *DeleteCustomerRepricingConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCustomerRepricingConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteCustomerRepricingConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{29}
}

func (x *DeleteCustomerRepricingConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [CloudChannelService.GetChannelPartnerRepricingConfig][google.cloud.channel.v1.CloudChannelService.GetChannelPartnerRepricingConfig]
type GetChannelPartnerRepricingConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the ChannelPartnerRepricingConfig
	// Format:
	// accounts/{account_id}/channelPartnerLinks/{channel_partner_id}/channelPartnerRepricingConfigs/{id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetChannelPartnerRepricingConfigRequest) Reset() {
	*x = GetChannelPartnerRepricingConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetChannelPartnerRepricingConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetChannelPartnerRepricingConfigRequest) ProtoMessage() {}

func (x *GetChannelPartnerRepricingConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetChannelPartnerRepricingConfigRequest.ProtoReflect.Descriptor instead.
func (*GetChannelPartnerRepricingConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{30}
}

func (x *GetChannelPartnerRepricingConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [CloudChannelService.ListChannelPartnerRepricingConfigs][google.cloud.channel.v1.CloudChannelService.ListChannelPartnerRepricingConfigs].
type ListChannelPartnerRepricingConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the account's
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]. Parent
	// uses the format:
	// accounts/{account_id}/channelPartnerLinks/{channel_partner_id}.
	// Supports accounts/{account_id}/channelPartnerLinks/- to retrieve configs
	// for all channel partners.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of repricing configs to return. The service
	// may return fewer than this value. If unspecified, returns a maximum of 50
	// rules. The maximum value is 100; values above 100 will be coerced to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results beyond the first page.
	// Obtained through
	// [ListChannelPartnerRepricingConfigsResponse.next_page_token][google.cloud.channel.v1.ListChannelPartnerRepricingConfigsResponse.next_page_token]
	// of the previous
	// [CloudChannelService.ListChannelPartnerRepricingConfigs][google.cloud.channel.v1.CloudChannelService.ListChannelPartnerRepricingConfigs]
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter for
	// [CloudChannelService.ListChannelPartnerRepricingConfigs] results
	// (channel_partner_link only). You can use this filter when you support a
	// BatchGet-like query. To use the filter, you must set
	// `parent=accounts/{account_id}/channelPartnerLinks/-`.
	//
	// Example: `channel_partner_link =
	// accounts/account_id/channelPartnerLinks/c1` OR `channel_partner_link =
	// accounts/account_id/channelPartnerLinks/c2`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListChannelPartnerRepricingConfigsRequest) Reset() {
	*x = ListChannelPartnerRepricingConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListChannelPartnerRepricingConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChannelPartnerRepricingConfigsRequest) ProtoMessage() {}

func (x *ListChannelPartnerRepricingConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChannelPartnerRepricingConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListChannelPartnerRepricingConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{31}
}

func (x *ListChannelPartnerRepricingConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListChannelPartnerRepricingConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListChannelPartnerRepricingConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListChannelPartnerRepricingConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for
// [CloudChannelService.ListChannelPartnerRepricingConfigs][google.cloud.channel.v1.CloudChannelService.ListChannelPartnerRepricingConfigs].
type ListChannelPartnerRepricingConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The repricing configs for this channel partner.
	ChannelPartnerRepricingConfigs []*ChannelPartnerRepricingConfig `protobuf:"bytes,1,rep,name=channel_partner_repricing_configs,json=channelPartnerRepricingConfigs,proto3" json:"channel_partner_repricing_configs,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListChannelPartnerRepricingConfigsRequest.page_token][google.cloud.channel.v1.ListChannelPartnerRepricingConfigsRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListChannelPartnerRepricingConfigsResponse) Reset() {
	*x = ListChannelPartnerRepricingConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListChannelPartnerRepricingConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChannelPartnerRepricingConfigsResponse) ProtoMessage() {}

func (x *ListChannelPartnerRepricingConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChannelPartnerRepricingConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListChannelPartnerRepricingConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{32}
}

func (x *ListChannelPartnerRepricingConfigsResponse) GetChannelPartnerRepricingConfigs() []*ChannelPartnerRepricingConfig {
	if x != nil {
		return x.ChannelPartnerRepricingConfigs
	}
	return nil
}

func (x *ListChannelPartnerRepricingConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [CloudChannelService.CreateChannelPartnerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig].
type CreateChannelPartnerRepricingConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the ChannelPartner that will receive the
	// repricing config. Parent uses the format:
	// accounts/{account_id}/channelPartnerLinks/{channel_partner_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ChannelPartnerRepricingConfig object to update.
	ChannelPartnerRepricingConfig *ChannelPartnerRepricingConfig `protobuf:"bytes,2,opt,name=channel_partner_repricing_config,json=channelPartnerRepricingConfig,proto3" json:"channel_partner_repricing_config,omitempty"`
}

func (x *CreateChannelPartnerRepricingConfigRequest) Reset() {
	*x = CreateChannelPartnerRepricingConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateChannelPartnerRepricingConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateChannelPartnerRepricingConfigRequest) ProtoMessage() {}

func (x *CreateChannelPartnerRepricingConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateChannelPartnerRepricingConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateChannelPartnerRepricingConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{33}
}

func (x *CreateChannelPartnerRepricingConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateChannelPartnerRepricingConfigRequest) GetChannelPartnerRepricingConfig() *ChannelPartnerRepricingConfig {
	if x != nil {
		return x.ChannelPartnerRepricingConfig
	}
	return nil
}

// Request message for
// [CloudChannelService.UpdateChannelPartnerRepricingConfig][google.cloud.channel.v1.CloudChannelService.UpdateChannelPartnerRepricingConfig].
type UpdateChannelPartnerRepricingConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ChannelPartnerRepricingConfig object to update.
	ChannelPartnerRepricingConfig *ChannelPartnerRepricingConfig `protobuf:"bytes,1,opt,name=channel_partner_repricing_config,json=channelPartnerRepricingConfig,proto3" json:"channel_partner_repricing_config,omitempty"`
}

func (x *UpdateChannelPartnerRepricingConfigRequest) Reset() {
	*x = UpdateChannelPartnerRepricingConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateChannelPartnerRepricingConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateChannelPartnerRepricingConfigRequest) ProtoMessage() {}

func (x *UpdateChannelPartnerRepricingConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateChannelPartnerRepricingConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateChannelPartnerRepricingConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{34}
}

func (x *UpdateChannelPartnerRepricingConfigRequest) GetChannelPartnerRepricingConfig() *ChannelPartnerRepricingConfig {
	if x != nil {
		return x.ChannelPartnerRepricingConfig
	}
	return nil
}

// Request message for DeleteChannelPartnerRepricingConfig.
type DeleteChannelPartnerRepricingConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the channel partner repricing config rule to
	// delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteChannelPartnerRepricingConfigRequest) Reset() {
	*x = DeleteChannelPartnerRepricingConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteChannelPartnerRepricingConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteChannelPartnerRepricingConfigRequest) ProtoMessage() {}

func (x *DeleteChannelPartnerRepricingConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteChannelPartnerRepricingConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteChannelPartnerRepricingConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{35}
}

func (x *DeleteChannelPartnerRepricingConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListSkuGroups.
type ListSkuGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the account from which to list SKU groups.
	// Parent uses the format: accounts/{account}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of SKU groups to return. The service may
	// return fewer than this value. If unspecified, returns a maximum of 1000 SKU
	// groups. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results beyond the first page.
	// Obtained through
	// [ListSkuGroups.next_page_token][] of the previous
	// [CloudChannelService.ListSkuGroups][google.cloud.channel.v1.CloudChannelService.ListSkuGroups]
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSkuGroupsRequest) Reset() {
	*x = ListSkuGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSkuGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSkuGroupsRequest) ProtoMessage() {}

func (x *ListSkuGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSkuGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListSkuGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{36}
}

func (x *ListSkuGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSkuGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSkuGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Request message for ListSkuGroupBillableSkus.
type ListSkuGroupBillableSkusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the SKU group.
	// Format: accounts/{account}/skuGroups/{sku_group}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of SKUs to return. The service may return
	// fewer than this value. If unspecified, returns a maximum of 100000 SKUs.
	// The maximum value is 100000; values above 100000 will be coerced to 100000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results beyond the first page.
	// Obtained through
	// [ListSkuGroupBillableSkus.next_page_token][] of the previous
	// [CloudChannelService.ListSkuGroupBillableSkus][google.cloud.channel.v1.CloudChannelService.ListSkuGroupBillableSkus]
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSkuGroupBillableSkusRequest) Reset() {
	*x = ListSkuGroupBillableSkusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSkuGroupBillableSkusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSkuGroupBillableSkusRequest) ProtoMessage() {}

func (x *ListSkuGroupBillableSkusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSkuGroupBillableSkusRequest.ProtoReflect.Descriptor instead.
func (*ListSkuGroupBillableSkusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{37}
}

func (x *ListSkuGroupBillableSkusRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSkuGroupBillableSkusRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSkuGroupBillableSkusRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListSkuGroups.
type ListSkuGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of SKU groups requested.
	SkuGroups []*SkuGroup `protobuf:"bytes,1,rep,name=sku_groups,json=skuGroups,proto3" json:"sku_groups,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to [ListSkuGroups.page_token][] to obtain that
	// page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSkuGroupsResponse) Reset() {
	*x = ListSkuGroupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSkuGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSkuGroupsResponse) ProtoMessage() {}

func (x *ListSkuGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSkuGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListSkuGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{38}
}

func (x *ListSkuGroupsResponse) GetSkuGroups() []*SkuGroup {
	if x != nil {
		return x.SkuGroups
	}
	return nil
}

func (x *ListSkuGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Response message for ListSkuGroupBillableSkus.
type ListSkuGroupBillableSkusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of billable SKUs in the requested SKU group.
	BillableSkus []*BillableSku `protobuf:"bytes,1,rep,name=billable_skus,json=billableSkus,proto3" json:"billable_skus,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to [ListSkuGroupBillableSkus.page_token][] to obtain that
	// page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSkuGroupBillableSkusResponse) Reset() {
	*x = ListSkuGroupBillableSkusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSkuGroupBillableSkusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSkuGroupBillableSkusResponse) ProtoMessage() {}

func (x *ListSkuGroupBillableSkusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSkuGroupBillableSkusResponse.ProtoReflect.Descriptor instead.
func (*ListSkuGroupBillableSkusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{39}
}

func (x *ListSkuGroupBillableSkusResponse) GetBillableSkus() []*BillableSku {
	if x != nil {
		return x.BillableSkus
	}
	return nil
}

func (x *ListSkuGroupBillableSkusResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents the SKU group information.
type SkuGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of SKU group. Format:
	// accounts/{account}/skuGroups/{sku_group}.
	// Example:
	// "accounts/C01234/skuGroups/3d50fd57-3157-4577-a5a9-a219b8490041".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Unique human readable identifier for the SKU group.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *SkuGroup) Reset() {
	*x = SkuGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SkuGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SkuGroup) ProtoMessage() {}

func (x *SkuGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SkuGroup.ProtoReflect.Descriptor instead.
func (*SkuGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{40}
}

func (x *SkuGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SkuGroup) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Represents the Billable SKU information.
type BillableSku struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of Billable SKU. Format:
	// billableSkus/{sku}.
	// Example:
	// billableSkus/6E1B-6634-470F".
	Sku string `protobuf:"bytes,1,opt,name=sku,proto3" json:"sku,omitempty"`
	// Unique human readable name for the SKU.
	SkuDisplayName string `protobuf:"bytes,2,opt,name=sku_display_name,json=skuDisplayName,proto3" json:"sku_display_name,omitempty"`
	// Resource name of Service which contains Repricing SKU. Format:
	// services/{service}.
	// Example:
	// "services/B7D9-FDCB-15D8".
	Service string `protobuf:"bytes,3,opt,name=service,proto3" json:"service,omitempty"`
	// Unique human readable name for the Service.
	ServiceDisplayName string `protobuf:"bytes,4,opt,name=service_display_name,json=serviceDisplayName,proto3" json:"service_display_name,omitempty"`
}

func (x *BillableSku) Reset() {
	*x = BillableSku{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BillableSku) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BillableSku) ProtoMessage() {}

func (x *BillableSku) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BillableSku.ProtoReflect.Descriptor instead.
func (*BillableSku) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{41}
}

func (x *BillableSku) GetSku() string {
	if x != nil {
		return x.Sku
	}
	return ""
}

func (x *BillableSku) GetSkuDisplayName() string {
	if x != nil {
		return x.SkuDisplayName
	}
	return ""
}

func (x *BillableSku) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *BillableSku) GetServiceDisplayName() string {
	if x != nil {
		return x.ServiceDisplayName
	}
	return ""
}

// Request message for
// [CloudChannelService.CreateEntitlement][google.cloud.channel.v1.CloudChannelService.CreateEntitlement]
type CreateEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller's customer account in which to
	// create the entitlement. Parent uses the format:
	// accounts/{account_id}/customers/{customer_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entitlement to create.
	Entitlement *Entitlement `protobuf:"bytes,2,opt,name=entitlement,proto3" json:"entitlement,omitempty"`
	// Optional. You can specify an optional unique request ID, and if you need to
	// retry your request, the server will know to ignore the request if it's
	// complete.
	//
	// For example, you make an initial request and the request times out. If you
	// make the request again with the same request ID, the server can check if
	// it received the original operation with the same request ID. If it did, it
	// will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateEntitlementRequest) Reset() {
	*x = CreateEntitlementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntitlementRequest) ProtoMessage() {}

func (x *CreateEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntitlementRequest.ProtoReflect.Descriptor instead.
func (*CreateEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{42}
}

func (x *CreateEntitlementRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntitlementRequest) GetEntitlement() *Entitlement {
	if x != nil {
		return x.Entitlement
	}
	return nil
}

func (x *CreateEntitlementRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [CloudChannelService.TransferEntitlements][google.cloud.channel.v1.CloudChannelService.TransferEntitlements].
type TransferEntitlementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller's customer account that will
	// receive transferred entitlements. Parent uses the format:
	// accounts/{account_id}/customers/{customer_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The new entitlements to create or transfer.
	Entitlements []*Entitlement `protobuf:"bytes,2,rep,name=entitlements,proto3" json:"entitlements,omitempty"`
	// The super admin of the resold customer generates this token to
	// authorize a reseller to access their Cloud Identity and purchase
	// entitlements on their behalf. You can omit this token after authorization.
	// See https://support.google.com/a/answer/7643790 for more details.
	AuthToken string `protobuf:"bytes,4,opt,name=auth_token,json=authToken,proto3" json:"auth_token,omitempty"`
	// Optional. You can specify an optional unique request ID, and if you need to
	// retry your request, the server will know to ignore the request if it's
	// complete.
	//
	// For example, you make an initial request and the request times out. If you
	// make the request again with the same request ID, the server can check if
	// it received the original operation with the same request ID. If it did, it
	// will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,6,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *TransferEntitlementsRequest) Reset() {
	*x = TransferEntitlementsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferEntitlementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferEntitlementsRequest) ProtoMessage() {}

func (x *TransferEntitlementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferEntitlementsRequest.ProtoReflect.Descriptor instead.
func (*TransferEntitlementsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{43}
}

func (x *TransferEntitlementsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *TransferEntitlementsRequest) GetEntitlements() []*Entitlement {
	if x != nil {
		return x.Entitlements
	}
	return nil
}

func (x *TransferEntitlementsRequest) GetAuthToken() string {
	if x != nil {
		return x.AuthToken
	}
	return ""
}

func (x *TransferEntitlementsRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Response message for
// [CloudChannelService.TransferEntitlements][google.cloud.channel.v1.CloudChannelService.TransferEntitlements].
// This is put in the response field of google.longrunning.Operation.
type TransferEntitlementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The transferred entitlements.
	Entitlements []*Entitlement `protobuf:"bytes,1,rep,name=entitlements,proto3" json:"entitlements,omitempty"`
}

func (x *TransferEntitlementsResponse) Reset() {
	*x = TransferEntitlementsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferEntitlementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferEntitlementsResponse) ProtoMessage() {}

func (x *TransferEntitlementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferEntitlementsResponse.ProtoReflect.Descriptor instead.
func (*TransferEntitlementsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{44}
}

func (x *TransferEntitlementsResponse) GetEntitlements() []*Entitlement {
	if x != nil {
		return x.Entitlements
	}
	return nil
}

// Request message for
// [CloudChannelService.TransferEntitlementsToGoogle][google.cloud.channel.v1.CloudChannelService.TransferEntitlementsToGoogle].
type TransferEntitlementsToGoogleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller's customer account where the
	// entitlements transfer from. Parent uses the format:
	// accounts/{account_id}/customers/{customer_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entitlements to transfer to Google.
	Entitlements []*Entitlement `protobuf:"bytes,2,rep,name=entitlements,proto3" json:"entitlements,omitempty"`
	// Optional. You can specify an optional unique request ID, and if you need to
	// retry your request, the server will know to ignore the request if it's
	// complete.
	//
	// For example, you make an initial request and the request times out. If you
	// make the request again with the same request ID, the server can check if
	// it received the original operation with the same request ID. If it did, it
	// will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *TransferEntitlementsToGoogleRequest) Reset() {
	*x = TransferEntitlementsToGoogleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferEntitlementsToGoogleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferEntitlementsToGoogleRequest) ProtoMessage() {}

func (x *TransferEntitlementsToGoogleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferEntitlementsToGoogleRequest.ProtoReflect.Descriptor instead.
func (*TransferEntitlementsToGoogleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{45}
}

func (x *TransferEntitlementsToGoogleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *TransferEntitlementsToGoogleRequest) GetEntitlements() []*Entitlement {
	if x != nil {
		return x.Entitlements
	}
	return nil
}

func (x *TransferEntitlementsToGoogleRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [CloudChannelService.ChangeParametersRequest][].
type ChangeParametersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entitlement to update.
	// Name uses the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Entitlement parameters to update. You can only change editable
	// parameters.
	//
	// To view the available Parameters for a request, refer to the
	// [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions]
	// from the desired offer.
	Parameters []*Parameter `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Optional. You can specify an optional unique request ID, and if you need to
	// retry your request, the server will know to ignore the request if it's
	// complete.
	//
	// For example, you make an initial request and the request times out. If you
	// make the request again with the same request ID, the server can check if
	// it received the original operation with the same request ID. If it did, it
	// will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Purchase order ID provided by the reseller.
	PurchaseOrderId string `protobuf:"bytes,5,opt,name=purchase_order_id,json=purchaseOrderId,proto3" json:"purchase_order_id,omitempty"`
}

func (x *ChangeParametersRequest) Reset() {
	*x = ChangeParametersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeParametersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeParametersRequest) ProtoMessage() {}

func (x *ChangeParametersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeParametersRequest.ProtoReflect.Descriptor instead.
func (*ChangeParametersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{46}
}

func (x *ChangeParametersRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ChangeParametersRequest) GetParameters() []*Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *ChangeParametersRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *ChangeParametersRequest) GetPurchaseOrderId() string {
	if x != nil {
		return x.PurchaseOrderId
	}
	return ""
}

// Request message for
// [CloudChannelService.ChangeRenewalSettings][google.cloud.channel.v1.CloudChannelService.ChangeRenewalSettings].
type ChangeRenewalSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entitlement to update.
	// Name uses the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. New renewal settings.
	RenewalSettings *RenewalSettings `protobuf:"bytes,4,opt,name=renewal_settings,json=renewalSettings,proto3" json:"renewal_settings,omitempty"`
	// Optional. You can specify an optional unique request ID, and if you need to
	// retry your request, the server will know to ignore the request if it's
	// complete.
	//
	// For example, you make an initial request and the request times out. If you
	// make the request again with the same request ID, the server can check if
	// it received the original operation with the same request ID. If it did, it
	// will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ChangeRenewalSettingsRequest) Reset() {
	*x = ChangeRenewalSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeRenewalSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeRenewalSettingsRequest) ProtoMessage() {}

func (x *ChangeRenewalSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeRenewalSettingsRequest.ProtoReflect.Descriptor instead.
func (*ChangeRenewalSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{47}
}

func (x *ChangeRenewalSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ChangeRenewalSettingsRequest) GetRenewalSettings() *RenewalSettings {
	if x != nil {
		return x.RenewalSettings
	}
	return nil
}

func (x *ChangeRenewalSettingsRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [CloudChannelService.ChangeOffer][google.cloud.channel.v1.CloudChannelService.ChangeOffer].
type ChangeOfferRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entitlement to update.
	// Name uses the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. New Offer.
	// Format: accounts/{account_id}/offers/{offer_id}.
	Offer string `protobuf:"bytes,2,opt,name=offer,proto3" json:"offer,omitempty"`
	// Optional. Parameters needed to purchase the Offer. To view the available
	// Parameters refer to the
	// [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions]
	// from the desired offer.
	Parameters []*Parameter `protobuf:"bytes,3,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Optional. Purchase order id provided by the reseller.
	PurchaseOrderId string `protobuf:"bytes,5,opt,name=purchase_order_id,json=purchaseOrderId,proto3" json:"purchase_order_id,omitempty"`
	// Optional. You can specify an optional unique request ID, and if you need to
	// retry your request, the server will know to ignore the request if it's
	// complete.
	//
	// For example, you make an initial request and the request times out. If you
	// make the request again with the same request ID, the server can check if
	// it received the original operation with the same request ID. If it did, it
	// will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,6,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. The billing account resource name that is used to pay for this
	// entitlement when setting up billing on a trial subscription.
	//
	// This field is only relevant for multi-currency accounts. It should be
	// left empty for single currency accounts.
	BillingAccount string `protobuf:"bytes,7,opt,name=billing_account,json=billingAccount,proto3" json:"billing_account,omitempty"`
}

func (x *ChangeOfferRequest) Reset() {
	*x = ChangeOfferRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeOfferRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeOfferRequest) ProtoMessage() {}

func (x *ChangeOfferRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeOfferRequest.ProtoReflect.Descriptor instead.
func (*ChangeOfferRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{48}
}

func (x *ChangeOfferRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ChangeOfferRequest) GetOffer() string {
	if x != nil {
		return x.Offer
	}
	return ""
}

func (x *ChangeOfferRequest) GetParameters() []*Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *ChangeOfferRequest) GetPurchaseOrderId() string {
	if x != nil {
		return x.PurchaseOrderId
	}
	return ""
}

func (x *ChangeOfferRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *ChangeOfferRequest) GetBillingAccount() string {
	if x != nil {
		return x.BillingAccount
	}
	return ""
}

// Request message for
// [CloudChannelService.StartPaidService][google.cloud.channel.v1.CloudChannelService.StartPaidService].
type StartPaidServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entitlement to start a paid service for.
	// Name uses the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. You can specify an optional unique request ID, and if you need to
	// retry your request, the server will know to ignore the request if it's
	// complete.
	//
	// For example, you make an initial request and the request times out. If you
	// make the request again with the same request ID, the server can check if
	// it received the original operation with the same request ID. If it did, it
	// will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *StartPaidServiceRequest) Reset() {
	*x = StartPaidServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartPaidServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartPaidServiceRequest) ProtoMessage() {}

func (x *StartPaidServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartPaidServiceRequest.ProtoReflect.Descriptor instead.
func (*StartPaidServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{49}
}

func (x *StartPaidServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StartPaidServiceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [CloudChannelService.CancelEntitlement][google.cloud.channel.v1.CloudChannelService.CancelEntitlement].
type CancelEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entitlement to cancel.
	// Name uses the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. You can specify an optional unique request ID, and if you need to
	// retry your request, the server will know to ignore the request if it's
	// complete.
	//
	// For example, you make an initial request and the request times out. If you
	// make the request again with the same request ID, the server can check if
	// it received the original operation with the same request ID. If it did, it
	// will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CancelEntitlementRequest) Reset() {
	*x = CancelEntitlementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelEntitlementRequest) ProtoMessage() {}

func (x *CancelEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelEntitlementRequest.ProtoReflect.Descriptor instead.
func (*CancelEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{50}
}

func (x *CancelEntitlementRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CancelEntitlementRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [CloudChannelService.SuspendEntitlement][google.cloud.channel.v1.CloudChannelService.SuspendEntitlement].
type SuspendEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entitlement to suspend.
	// Name uses the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. You can specify an optional unique request ID, and if you need to
	// retry your request, the server will know to ignore the request if it's
	// complete.
	//
	// For example, you make an initial request and the request times out. If you
	// make the request again with the same request ID, the server can check if
	// it received the original operation with the same request ID. If it did, it
	// will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *SuspendEntitlementRequest) Reset() {
	*x = SuspendEntitlementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuspendEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuspendEntitlementRequest) ProtoMessage() {}

func (x *SuspendEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuspendEntitlementRequest.ProtoReflect.Descriptor instead.
func (*SuspendEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{51}
}

func (x *SuspendEntitlementRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SuspendEntitlementRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [CloudChannelService.ActivateEntitlement][google.cloud.channel.v1.CloudChannelService.ActivateEntitlement].
type ActivateEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entitlement to activate.
	// Name uses the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. You can specify an optional unique request ID, and if you need to
	// retry your request, the server will know to ignore the request if it's
	// complete.
	//
	// For example, you make an initial request and the request times out. If you
	// make the request again with the same request ID, the server can check if
	// it received the original operation with the same request ID. If it did, it
	// will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ActivateEntitlementRequest) Reset() {
	*x = ActivateEntitlementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActivateEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateEntitlementRequest) ProtoMessage() {}

func (x *ActivateEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateEntitlementRequest.ProtoReflect.Descriptor instead.
func (*ActivateEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{52}
}

func (x *ActivateEntitlementRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ActivateEntitlementRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for LookupOffer.
type LookupOfferRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entitlement to retrieve the Offer.
	// Entitlement uses the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Entitlement string `protobuf:"bytes,1,opt,name=entitlement,proto3" json:"entitlement,omitempty"`
}

func (x *LookupOfferRequest) Reset() {
	*x = LookupOfferRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LookupOfferRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupOfferRequest) ProtoMessage() {}

func (x *LookupOfferRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupOfferRequest.ProtoReflect.Descriptor instead.
func (*LookupOfferRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{53}
}

func (x *LookupOfferRequest) GetEntitlement() string {
	if x != nil {
		return x.Entitlement
	}
	return ""
}

// Request message for ListProducts.
type ListProductsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller account.
	// Format: accounts/{account_id}.
	Account string `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Optional. Requested page size. Server might return fewer results than
	// requested. If unspecified, returns at most 100 Products. The maximum value
	// is 1000; the server will coerce values above 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token for a page of results other than the first page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The BCP-47 language code. For example, "en-US". The
	// response will localize in the corresponding language code, if specified.
	// The default value is "en-US".
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListProductsRequest) Reset() {
	*x = ListProductsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProductsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductsRequest) ProtoMessage() {}

func (x *ListProductsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductsRequest.ProtoReflect.Descriptor instead.
func (*ListProductsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{54}
}

func (x *ListProductsRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *ListProductsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProductsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListProductsRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Response message for ListProducts.
type ListProductsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of Products requested.
	Products []*Product `protobuf:"bytes,1,rep,name=products,proto3" json:"products,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProductsResponse) Reset() {
	*x = ListProductsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProductsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductsResponse) ProtoMessage() {}

func (x *ListProductsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductsResponse.ProtoReflect.Descriptor instead.
func (*ListProductsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{55}
}

func (x *ListProductsResponse) GetProducts() []*Product {
	if x != nil {
		return x.Products
	}
	return nil
}

func (x *ListProductsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ListSkus.
type ListSkusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Product to list SKUs for.
	// Parent uses the format: products/{product_id}.
	// Supports products/- to retrieve SKUs for all products.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Resource name of the reseller.
	// Format: accounts/{account_id}.
	Account string `protobuf:"bytes,2,opt,name=account,proto3" json:"account,omitempty"`
	// Optional. Requested page size. Server might return fewer results than
	// requested. If unspecified, returns at most 100 SKUs. The maximum value is
	// 1000; the server will coerce values above 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token for a page of results other than the first page.
	// Optional.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The BCP-47 language code. For example, "en-US". The
	// response will localize in the corresponding language code, if specified.
	// The default value is "en-US".
	LanguageCode string `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListSkusRequest) Reset() {
	*x = ListSkusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSkusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSkusRequest) ProtoMessage() {}

func (x *ListSkusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSkusRequest.ProtoReflect.Descriptor instead.
func (*ListSkusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{56}
}

func (x *ListSkusRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSkusRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *ListSkusRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSkusRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSkusRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Response message for ListSkus.
type ListSkusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of SKUs requested.
	Skus []*Sku `protobuf:"bytes,1,rep,name=skus,proto3" json:"skus,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSkusResponse) Reset() {
	*x = ListSkusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSkusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSkusResponse) ProtoMessage() {}

func (x *ListSkusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSkusResponse.ProtoReflect.Descriptor instead.
func (*ListSkusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{57}
}

func (x *ListSkusResponse) GetSkus() []*Sku {
	if x != nil {
		return x.Skus
	}
	return nil
}

func (x *ListSkusResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ListOffers.
type ListOffersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller account from which to list
	// Offers. Parent uses the format: accounts/{account_id}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server might return fewer results than
	// requested. If unspecified, returns at most 500 Offers. The maximum value is
	// 1000; the server will coerce values above 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token for a page of results other than the first page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The expression to filter results by name (name of
	// the Offer), sku.name (name of the SKU), or sku.product.name (name of the
	// Product).
	// Example 1: sku.product.name=products/p1 AND sku.name!=products/p1/skus/s1
	// Example 2: name=accounts/a1/offers/o1
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The BCP-47 language code. For example, "en-US". The
	// response will localize in the corresponding language code, if specified.
	// The default value is "en-US".
	LanguageCode string `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. A boolean flag that determines if a response returns future
	// offers 30 days from now. If the show_future_offers is true, the response
	// will only contain offers that are scheduled to be available 30 days from
	// now.
	ShowFutureOffers bool `protobuf:"varint,7,opt,name=show_future_offers,json=showFutureOffers,proto3" json:"show_future_offers,omitempty"`
}

func (x *ListOffersRequest) Reset() {
	*x = ListOffersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOffersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOffersRequest) ProtoMessage() {}

func (x *ListOffersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOffersRequest.ProtoReflect.Descriptor instead.
func (*ListOffersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{58}
}

func (x *ListOffersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListOffersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOffersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListOffersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListOffersRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ListOffersRequest) GetShowFutureOffers() bool {
	if x != nil {
		return x.ShowFutureOffers
	}
	return false
}

// Response message for ListOffers.
type ListOffersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Offers requested.
	Offers []*Offer `protobuf:"bytes,1,rep,name=offers,proto3" json:"offers,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListOffersResponse) Reset() {
	*x = ListOffersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOffersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOffersResponse) ProtoMessage() {}

func (x *ListOffersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOffersResponse.ProtoReflect.Descriptor instead.
func (*ListOffersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{59}
}

func (x *ListOffersResponse) GetOffers() []*Offer {
	if x != nil {
		return x.Offers
	}
	return nil
}

func (x *ListOffersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ListPurchasableSkus.
type ListPurchasableSkusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines the intended purchase.
	//
	// Types that are assignable to PurchaseOption:
	//
	//	*ListPurchasableSkusRequest_CreateEntitlementPurchase_
	//	*ListPurchasableSkusRequest_ChangeOfferPurchase_
	PurchaseOption isListPurchasableSkusRequest_PurchaseOption `protobuf_oneof:"purchase_option"`
	// Required. The resource name of the customer to list SKUs for.
	// Format: accounts/{account_id}/customers/{customer_id}.
	Customer string `protobuf:"bytes,1,opt,name=customer,proto3" json:"customer,omitempty"`
	// Optional. Requested page size. Server might return fewer results than
	// requested. If unspecified, returns at most 100 SKUs. The maximum value is
	// 1000; the server will coerce values above 1000.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token for a page of results other than the first page.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The BCP-47 language code. For example, "en-US". The
	// response will localize in the corresponding language code, if specified.
	// The default value is "en-US".
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListPurchasableSkusRequest) Reset() {
	*x = ListPurchasableSkusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableSkusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableSkusRequest) ProtoMessage() {}

func (x *ListPurchasableSkusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableSkusRequest.ProtoReflect.Descriptor instead.
func (*ListPurchasableSkusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{60}
}

func (m *ListPurchasableSkusRequest) GetPurchaseOption() isListPurchasableSkusRequest_PurchaseOption {
	if m != nil {
		return m.PurchaseOption
	}
	return nil
}

func (x *ListPurchasableSkusRequest) GetCreateEntitlementPurchase() *ListPurchasableSkusRequest_CreateEntitlementPurchase {
	if x, ok := x.GetPurchaseOption().(*ListPurchasableSkusRequest_CreateEntitlementPurchase_); ok {
		return x.CreateEntitlementPurchase
	}
	return nil
}

func (x *ListPurchasableSkusRequest) GetChangeOfferPurchase() *ListPurchasableSkusRequest_ChangeOfferPurchase {
	if x, ok := x.GetPurchaseOption().(*ListPurchasableSkusRequest_ChangeOfferPurchase_); ok {
		return x.ChangeOfferPurchase
	}
	return nil
}

func (x *ListPurchasableSkusRequest) GetCustomer() string {
	if x != nil {
		return x.Customer
	}
	return ""
}

func (x *ListPurchasableSkusRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPurchasableSkusRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPurchasableSkusRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

type isListPurchasableSkusRequest_PurchaseOption interface {
	isListPurchasableSkusRequest_PurchaseOption()
}

type ListPurchasableSkusRequest_CreateEntitlementPurchase_ struct {
	// List SKUs for CreateEntitlement purchase.
	CreateEntitlementPurchase *ListPurchasableSkusRequest_CreateEntitlementPurchase `protobuf:"bytes,2,opt,name=create_entitlement_purchase,json=createEntitlementPurchase,proto3,oneof"`
}

type ListPurchasableSkusRequest_ChangeOfferPurchase_ struct {
	// List SKUs for ChangeOffer purchase with a new SKU.
	ChangeOfferPurchase *ListPurchasableSkusRequest_ChangeOfferPurchase `protobuf:"bytes,3,opt,name=change_offer_purchase,json=changeOfferPurchase,proto3,oneof"`
}

func (*ListPurchasableSkusRequest_CreateEntitlementPurchase_) isListPurchasableSkusRequest_PurchaseOption() {
}

func (*ListPurchasableSkusRequest_ChangeOfferPurchase_) isListPurchasableSkusRequest_PurchaseOption() {
}

// Response message for ListPurchasableSkus.
type ListPurchasableSkusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of SKUs requested.
	PurchasableSkus []*PurchasableSku `protobuf:"bytes,1,rep,name=purchasable_skus,json=purchasableSkus,proto3" json:"purchasable_skus,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPurchasableSkusResponse) Reset() {
	*x = ListPurchasableSkusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableSkusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableSkusResponse) ProtoMessage() {}

func (x *ListPurchasableSkusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableSkusResponse.ProtoReflect.Descriptor instead.
func (*ListPurchasableSkusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{61}
}

func (x *ListPurchasableSkusResponse) GetPurchasableSkus() []*PurchasableSku {
	if x != nil {
		return x.PurchasableSkus
	}
	return nil
}

func (x *ListPurchasableSkusResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// SKU that you can purchase. This is used in ListPurchasableSku API
// response.
type PurchasableSku struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// SKU
	Sku *Sku `protobuf:"bytes,1,opt,name=sku,proto3" json:"sku,omitempty"`
}

func (x *PurchasableSku) Reset() {
	*x = PurchasableSku{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PurchasableSku) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurchasableSku) ProtoMessage() {}

func (x *PurchasableSku) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurchasableSku.ProtoReflect.Descriptor instead.
func (*PurchasableSku) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{62}
}

func (x *PurchasableSku) GetSku() *Sku {
	if x != nil {
		return x.Sku
	}
	return nil
}

// Request message for ListPurchasableOffers.
type ListPurchasableOffersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines the intended purchase.
	//
	// Types that are assignable to PurchaseOption:
	//
	//	*ListPurchasableOffersRequest_CreateEntitlementPurchase_
	//	*ListPurchasableOffersRequest_ChangeOfferPurchase_
	PurchaseOption isListPurchasableOffersRequest_PurchaseOption `protobuf_oneof:"purchase_option"`
	// Required. The resource name of the customer to list Offers for.
	// Format: accounts/{account_id}/customers/{customer_id}.
	Customer string `protobuf:"bytes,1,opt,name=customer,proto3" json:"customer,omitempty"`
	// Optional. Requested page size. Server might return fewer results than
	// requested. If unspecified, returns at most 100 Offers. The maximum value is
	// 1000; the server will coerce values above 1000.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token for a page of results other than the first page.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The BCP-47 language code. For example, "en-US". The
	// response will localize in the corresponding language code, if specified.
	// The default value is "en-US".
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListPurchasableOffersRequest) Reset() {
	*x = ListPurchasableOffersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableOffersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableOffersRequest) ProtoMessage() {}

func (x *ListPurchasableOffersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableOffersRequest.ProtoReflect.Descriptor instead.
func (*ListPurchasableOffersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{63}
}

func (m *ListPurchasableOffersRequest) GetPurchaseOption() isListPurchasableOffersRequest_PurchaseOption {
	if m != nil {
		return m.PurchaseOption
	}
	return nil
}

func (x *ListPurchasableOffersRequest) GetCreateEntitlementPurchase() *ListPurchasableOffersRequest_CreateEntitlementPurchase {
	if x, ok := x.GetPurchaseOption().(*ListPurchasableOffersRequest_CreateEntitlementPurchase_); ok {
		return x.CreateEntitlementPurchase
	}
	return nil
}

func (x *ListPurchasableOffersRequest) GetChangeOfferPurchase() *ListPurchasableOffersRequest_ChangeOfferPurchase {
	if x, ok := x.GetPurchaseOption().(*ListPurchasableOffersRequest_ChangeOfferPurchase_); ok {
		return x.ChangeOfferPurchase
	}
	return nil
}

func (x *ListPurchasableOffersRequest) GetCustomer() string {
	if x != nil {
		return x.Customer
	}
	return ""
}

func (x *ListPurchasableOffersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPurchasableOffersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPurchasableOffersRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

type isListPurchasableOffersRequest_PurchaseOption interface {
	isListPurchasableOffersRequest_PurchaseOption()
}

type ListPurchasableOffersRequest_CreateEntitlementPurchase_ struct {
	// List Offers for CreateEntitlement purchase.
	CreateEntitlementPurchase *ListPurchasableOffersRequest_CreateEntitlementPurchase `protobuf:"bytes,2,opt,name=create_entitlement_purchase,json=createEntitlementPurchase,proto3,oneof"`
}

type ListPurchasableOffersRequest_ChangeOfferPurchase_ struct {
	// List Offers for ChangeOffer purchase.
	ChangeOfferPurchase *ListPurchasableOffersRequest_ChangeOfferPurchase `protobuf:"bytes,3,opt,name=change_offer_purchase,json=changeOfferPurchase,proto3,oneof"`
}

func (*ListPurchasableOffersRequest_CreateEntitlementPurchase_) isListPurchasableOffersRequest_PurchaseOption() {
}

func (*ListPurchasableOffersRequest_ChangeOfferPurchase_) isListPurchasableOffersRequest_PurchaseOption() {
}

// Response message for ListPurchasableOffers.
type ListPurchasableOffersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Offers requested.
	PurchasableOffers []*PurchasableOffer `protobuf:"bytes,1,rep,name=purchasable_offers,json=purchasableOffers,proto3" json:"purchasable_offers,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPurchasableOffersResponse) Reset() {
	*x = ListPurchasableOffersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableOffersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableOffersResponse) ProtoMessage() {}

func (x *ListPurchasableOffersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableOffersResponse.ProtoReflect.Descriptor instead.
func (*ListPurchasableOffersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{64}
}

func (x *ListPurchasableOffersResponse) GetPurchasableOffers() []*PurchasableOffer {
	if x != nil {
		return x.PurchasableOffers
	}
	return nil
}

func (x *ListPurchasableOffersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Offer that you can purchase for a customer. This is used in the
// ListPurchasableOffer API response.
type PurchasableOffer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Offer.
	Offer *Offer `protobuf:"bytes,1,opt,name=offer,proto3" json:"offer,omitempty"`
}

func (x *PurchasableOffer) Reset() {
	*x = PurchasableOffer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PurchasableOffer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurchasableOffer) ProtoMessage() {}

func (x *PurchasableOffer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurchasableOffer.ProtoReflect.Descriptor instead.
func (*PurchasableOffer) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{65}
}

func (x *PurchasableOffer) GetOffer() *Offer {
	if x != nil {
		return x.Offer
	}
	return nil
}

// Request message for QueryEligibleBillingAccounts.
type QueryEligibleBillingAccountsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the customer to list eligible billing
	// accounts for. Format: accounts/{account_id}/customers/{customer_id}.
	Customer string `protobuf:"bytes,1,opt,name=customer,proto3" json:"customer,omitempty"`
	// Required. List of SKUs to list eligible billing accounts for. At least one
	// SKU is required. Format: products/{product_id}/skus/{sku_id}.
	Skus []string `protobuf:"bytes,2,rep,name=skus,proto3" json:"skus,omitempty"`
}

func (x *QueryEligibleBillingAccountsRequest) Reset() {
	*x = QueryEligibleBillingAccountsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryEligibleBillingAccountsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryEligibleBillingAccountsRequest) ProtoMessage() {}

func (x *QueryEligibleBillingAccountsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryEligibleBillingAccountsRequest.ProtoReflect.Descriptor instead.
func (*QueryEligibleBillingAccountsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{66}
}

func (x *QueryEligibleBillingAccountsRequest) GetCustomer() string {
	if x != nil {
		return x.Customer
	}
	return ""
}

func (x *QueryEligibleBillingAccountsRequest) GetSkus() []string {
	if x != nil {
		return x.Skus
	}
	return nil
}

// Response message for QueryEligibleBillingAccounts.
type QueryEligibleBillingAccountsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of SKU purchase groups where each group represents a set of SKUs that
	// must be purchased using the same billing account. Each SKU from
	// [QueryEligibleBillingAccountsRequest.skus] will appear in exactly one SKU
	// group.
	SkuPurchaseGroups []*SkuPurchaseGroup `protobuf:"bytes,1,rep,name=sku_purchase_groups,json=skuPurchaseGroups,proto3" json:"sku_purchase_groups,omitempty"`
}

func (x *QueryEligibleBillingAccountsResponse) Reset() {
	*x = QueryEligibleBillingAccountsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryEligibleBillingAccountsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryEligibleBillingAccountsResponse) ProtoMessage() {}

func (x *QueryEligibleBillingAccountsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryEligibleBillingAccountsResponse.ProtoReflect.Descriptor instead.
func (*QueryEligibleBillingAccountsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{67}
}

func (x *QueryEligibleBillingAccountsResponse) GetSkuPurchaseGroups() []*SkuPurchaseGroup {
	if x != nil {
		return x.SkuPurchaseGroups
	}
	return nil
}

// Represents a set of SKUs that must be purchased using the same billing
// account.
type SkuPurchaseGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource names of the SKUs included in this group.
	// Format: products/{product_id}/skus/{sku_id}.
	Skus []string `protobuf:"bytes,1,rep,name=skus,proto3" json:"skus,omitempty"`
	// List of billing accounts that are eligible to purhcase these SKUs.
	BillingAccountPurchaseInfos []*BillingAccountPurchaseInfo `protobuf:"bytes,2,rep,name=billing_account_purchase_infos,json=billingAccountPurchaseInfos,proto3" json:"billing_account_purchase_infos,omitempty"`
}

func (x *SkuPurchaseGroup) Reset() {
	*x = SkuPurchaseGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SkuPurchaseGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SkuPurchaseGroup) ProtoMessage() {}

func (x *SkuPurchaseGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SkuPurchaseGroup.ProtoReflect.Descriptor instead.
func (*SkuPurchaseGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{68}
}

func (x *SkuPurchaseGroup) GetSkus() []string {
	if x != nil {
		return x.Skus
	}
	return nil
}

func (x *SkuPurchaseGroup) GetBillingAccountPurchaseInfos() []*BillingAccountPurchaseInfo {
	if x != nil {
		return x.BillingAccountPurchaseInfos
	}
	return nil
}

// Represents a billing account that can be used to make a purchase.
type BillingAccountPurchaseInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The billing account resource.
	BillingAccount *BillingAccount `protobuf:"bytes,1,opt,name=billing_account,json=billingAccount,proto3" json:"billing_account,omitempty"`
}

func (x *BillingAccountPurchaseInfo) Reset() {
	*x = BillingAccountPurchaseInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BillingAccountPurchaseInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BillingAccountPurchaseInfo) ProtoMessage() {}

func (x *BillingAccountPurchaseInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BillingAccountPurchaseInfo.ProtoReflect.Descriptor instead.
func (*BillingAccountPurchaseInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{69}
}

func (x *BillingAccountPurchaseInfo) GetBillingAccount() *BillingAccount {
	if x != nil {
		return x.BillingAccount
	}
	return nil
}

// Request Message for RegisterSubscriber.
type RegisterSubscriberRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the account.
	Account string `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Required. Service account that provides subscriber access to the registered
	// topic.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
}

func (x *RegisterSubscriberRequest) Reset() {
	*x = RegisterSubscriberRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterSubscriberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterSubscriberRequest) ProtoMessage() {}

func (x *RegisterSubscriberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterSubscriberRequest.ProtoReflect.Descriptor instead.
func (*RegisterSubscriberRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{70}
}

func (x *RegisterSubscriberRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *RegisterSubscriberRequest) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

// Response Message for RegisterSubscriber.
type RegisterSubscriberResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the topic the subscriber will listen to.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *RegisterSubscriberResponse) Reset() {
	*x = RegisterSubscriberResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterSubscriberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterSubscriberResponse) ProtoMessage() {}

func (x *RegisterSubscriberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterSubscriberResponse.ProtoReflect.Descriptor instead.
func (*RegisterSubscriberResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{71}
}

func (x *RegisterSubscriberResponse) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

// Request Message for UnregisterSubscriber.
type UnregisterSubscriberRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the account.
	Account string `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Required. Service account to unregister from subscriber access to the
	// topic.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
}

func (x *UnregisterSubscriberRequest) Reset() {
	*x = UnregisterSubscriberRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnregisterSubscriberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnregisterSubscriberRequest) ProtoMessage() {}

func (x *UnregisterSubscriberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnregisterSubscriberRequest.ProtoReflect.Descriptor instead.
func (*UnregisterSubscriberRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{72}
}

func (x *UnregisterSubscriberRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *UnregisterSubscriberRequest) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

// Response Message for UnregisterSubscriber.
type UnregisterSubscriberResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the topic the service account subscriber access was removed from.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *UnregisterSubscriberResponse) Reset() {
	*x = UnregisterSubscriberResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnregisterSubscriberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnregisterSubscriberResponse) ProtoMessage() {}

func (x *UnregisterSubscriberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnregisterSubscriberResponse.ProtoReflect.Descriptor instead.
func (*UnregisterSubscriberResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{73}
}

func (x *UnregisterSubscriberResponse) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

// Request Message for ListSubscribers.
type ListSubscribersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the account.
	Account string `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Optional. The maximum number of service accounts to return. The service may
	// return fewer than this value. If unspecified, returns at most 100 service
	// accounts. The maximum value is 1000; the server will coerce values above
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListSubscribers` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListSubscribers` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSubscribersRequest) Reset() {
	*x = ListSubscribersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubscribersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubscribersRequest) ProtoMessage() {}

func (x *ListSubscribersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubscribersRequest.ProtoReflect.Descriptor instead.
func (*ListSubscribersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{74}
}

func (x *ListSubscribersRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *ListSubscribersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSubscribersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response Message for ListSubscribers.
type ListSubscribersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the topic registered with the reseller.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// List of service accounts which have subscriber access to the topic.
	ServiceAccounts []string `protobuf:"bytes,2,rep,name=service_accounts,json=serviceAccounts,proto3" json:"service_accounts,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSubscribersResponse) Reset() {
	*x = ListSubscribersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubscribersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubscribersResponse) ProtoMessage() {}

func (x *ListSubscribersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubscribersResponse.ProtoReflect.Descriptor instead.
func (*ListSubscribersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{75}
}

func (x *ListSubscribersResponse) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *ListSubscribersResponse) GetServiceAccounts() []string {
	if x != nil {
		return x.ServiceAccounts
	}
	return nil
}

func (x *ListSubscribersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [CloudChannelService.ListEntitlementChanges][google.cloud.channel.v1.CloudChannelService.ListEntitlementChanges]
type ListEntitlementChangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entitlement for which to list
	// entitlement changes. The `-` wildcard may be used to match entitlements
	// across a customer. Formats:
	//
	//   - accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	//   - accounts/{account_id}/customers/{customer_id}/entitlements/-
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of entitlement changes to return. The service
	// may return fewer than this value. If unspecified, returns at most 10
	// entitlement changes. The maximum value is 50; the server will coerce values
	// above 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous
	// [CloudChannelService.ListEntitlementChanges][google.cloud.channel.v1.CloudChannelService.ListEntitlementChanges]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [CloudChannelService.ListEntitlementChanges][google.cloud.channel.v1.CloudChannelService.ListEntitlementChanges]
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filters applied to the list results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListEntitlementChangesRequest) Reset() {
	*x = ListEntitlementChangesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntitlementChangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntitlementChangesRequest) ProtoMessage() {}

func (x *ListEntitlementChangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntitlementChangesRequest.ProtoReflect.Descriptor instead.
func (*ListEntitlementChangesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{76}
}

func (x *ListEntitlementChangesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntitlementChangesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntitlementChangesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEntitlementChangesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for
// [CloudChannelService.ListEntitlementChanges][google.cloud.channel.v1.CloudChannelService.ListEntitlementChanges]
type ListEntitlementChangesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of entitlement changes.
	EntitlementChanges []*EntitlementChange `protobuf:"bytes,1,rep,name=entitlement_changes,json=entitlementChanges,proto3" json:"entitlement_changes,omitempty"`
	// A token to list the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntitlementChangesResponse) Reset() {
	*x = ListEntitlementChangesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntitlementChangesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntitlementChangesResponse) ProtoMessage() {}

func (x *ListEntitlementChangesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntitlementChangesResponse.ProtoReflect.Descriptor instead.
func (*ListEntitlementChangesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{77}
}

func (x *ListEntitlementChangesResponse) GetEntitlementChanges() []*EntitlementChange {
	if x != nil {
		return x.EntitlementChanges
	}
	return nil
}

func (x *ListEntitlementChangesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// List SKUs for a new entitlement. Make the purchase using
// [CloudChannelService.CreateEntitlement][google.cloud.channel.v1.CloudChannelService.CreateEntitlement].
type ListPurchasableSkusRequest_CreateEntitlementPurchase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List SKUs belonging to this Product.
	// Format: products/{product_id}.
	// Supports products/- to retrieve SKUs for all products.
	Product string `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
}

func (x *ListPurchasableSkusRequest_CreateEntitlementPurchase) Reset() {
	*x = ListPurchasableSkusRequest_CreateEntitlementPurchase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableSkusRequest_CreateEntitlementPurchase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableSkusRequest_CreateEntitlementPurchase) ProtoMessage() {}

func (x *ListPurchasableSkusRequest_CreateEntitlementPurchase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableSkusRequest_CreateEntitlementPurchase.ProtoReflect.Descriptor instead.
func (*ListPurchasableSkusRequest_CreateEntitlementPurchase) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{60, 0}
}

func (x *ListPurchasableSkusRequest_CreateEntitlementPurchase) GetProduct() string {
	if x != nil {
		return x.Product
	}
	return ""
}

// List SKUs for upgrading or downgrading an entitlement. Make the purchase
// using
// [CloudChannelService.ChangeOffer][google.cloud.channel.v1.CloudChannelService.ChangeOffer].
type ListPurchasableSkusRequest_ChangeOfferPurchase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the entitlement.
	// Format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Entitlement string `protobuf:"bytes,1,opt,name=entitlement,proto3" json:"entitlement,omitempty"`
	// Required. Change Type for the entitlement.
	ChangeType ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType `protobuf:"varint,2,opt,name=change_type,json=changeType,proto3,enum=google.cloud.channel.v1.ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType" json:"change_type,omitempty"`
}

func (x *ListPurchasableSkusRequest_ChangeOfferPurchase) Reset() {
	*x = ListPurchasableSkusRequest_ChangeOfferPurchase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableSkusRequest_ChangeOfferPurchase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableSkusRequest_ChangeOfferPurchase) ProtoMessage() {}

func (x *ListPurchasableSkusRequest_ChangeOfferPurchase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableSkusRequest_ChangeOfferPurchase.ProtoReflect.Descriptor instead.
func (*ListPurchasableSkusRequest_ChangeOfferPurchase) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{60, 1}
}

func (x *ListPurchasableSkusRequest_ChangeOfferPurchase) GetEntitlement() string {
	if x != nil {
		return x.Entitlement
	}
	return ""
}

func (x *ListPurchasableSkusRequest_ChangeOfferPurchase) GetChangeType() ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType {
	if x != nil {
		return x.ChangeType
	}
	return ListPurchasableSkusRequest_ChangeOfferPurchase_CHANGE_TYPE_UNSPECIFIED
}

// List Offers for CreateEntitlement purchase.
type ListPurchasableOffersRequest_CreateEntitlementPurchase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. SKU that the result should be restricted to.
	// Format: products/{product_id}/skus/{sku_id}.
	Sku string `protobuf:"bytes,1,opt,name=sku,proto3" json:"sku,omitempty"`
	// Optional. Billing account that the result should be restricted to.
	// Format: accounts/{account_id}/billingAccounts/{billing_account_id}.
	BillingAccount string `protobuf:"bytes,2,opt,name=billing_account,json=billingAccount,proto3" json:"billing_account,omitempty"`
}

func (x *ListPurchasableOffersRequest_CreateEntitlementPurchase) Reset() {
	*x = ListPurchasableOffersRequest_CreateEntitlementPurchase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableOffersRequest_CreateEntitlementPurchase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableOffersRequest_CreateEntitlementPurchase) ProtoMessage() {}

func (x *ListPurchasableOffersRequest_CreateEntitlementPurchase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableOffersRequest_CreateEntitlementPurchase.ProtoReflect.Descriptor instead.
func (*ListPurchasableOffersRequest_CreateEntitlementPurchase) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{63, 0}
}

func (x *ListPurchasableOffersRequest_CreateEntitlementPurchase) GetSku() string {
	if x != nil {
		return x.Sku
	}
	return ""
}

func (x *ListPurchasableOffersRequest_CreateEntitlementPurchase) GetBillingAccount() string {
	if x != nil {
		return x.BillingAccount
	}
	return ""
}

// List Offers for ChangeOffer purchase.
type ListPurchasableOffersRequest_ChangeOfferPurchase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the entitlement.
	// Format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Entitlement string `protobuf:"bytes,1,opt,name=entitlement,proto3" json:"entitlement,omitempty"`
	// Optional. Resource name of the new target SKU. Provide this SKU when
	// upgrading or downgrading an entitlement. Format:
	// products/{product_id}/skus/{sku_id}
	NewSku string `protobuf:"bytes,2,opt,name=new_sku,json=newSku,proto3" json:"new_sku,omitempty"`
	// Optional. Resource name of the new target Billing Account. Provide this
	// Billing Account when setting up billing for a trial subscription. Format:
	// accounts/{account_id}/billingAccounts/{billing_account_id}.
	//
	// This field is only relevant for multi-currency accounts. It should be
	// left empty for single currency accounts.
	BillingAccount string `protobuf:"bytes,3,opt,name=billing_account,json=billingAccount,proto3" json:"billing_account,omitempty"`
}

func (x *ListPurchasableOffersRequest_ChangeOfferPurchase) Reset() {
	*x = ListPurchasableOffersRequest_ChangeOfferPurchase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableOffersRequest_ChangeOfferPurchase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableOffersRequest_ChangeOfferPurchase) ProtoMessage() {}

func (x *ListPurchasableOffersRequest_ChangeOfferPurchase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableOffersRequest_ChangeOfferPurchase.ProtoReflect.Descriptor instead.
func (*ListPurchasableOffersRequest_ChangeOfferPurchase) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{63, 1}
}

func (x *ListPurchasableOffersRequest_ChangeOfferPurchase) GetEntitlement() string {
	if x != nil {
		return x.Entitlement
	}
	return ""
}

func (x *ListPurchasableOffersRequest_ChangeOfferPurchase) GetNewSku() string {
	if x != nil {
		return x.NewSku
	}
	return ""
}

func (x *ListPurchasableOffersRequest_ChangeOfferPurchase) GetBillingAccount() string {
	if x != nil {
		return x.BillingAccount
	}
	return ""
}

var File_google_cloud_channel_v1_service_proto protoreflect.FileDescriptor

var file_google_cloud_channel_v1_service_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31,
	0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f,
	0x6f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e,
	0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x62, 0x0a, 0x26, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x22,
	0xb2, 0x01, 0x0a, 0x1c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x08, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x14, 0x0a, 0x05,
	0x6f, 0x77, 0x6e, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x6f, 0x77, 0x6e,
	0x65, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x1a, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x49, 0x64, 0x22, 0x98, 0x01, 0x0a, 0x27, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x45, 0x78, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x6d, 0x0a, 0x17, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x15, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x22,
	0x96, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x80, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x3f, 0x0a, 0x09, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x09, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x56, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x78, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x0a, 0x08, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x22, 0x98, 0x01,
	0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x59, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xf1, 0x02, 0x0a, 0x15, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a,
	0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x48, 0x00, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x31, 0x0a, 0x11,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12,
	0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a,
	0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x61, 0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x33, 0x0a, 0x13, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x69, 0x66,
	0x5f, 0x65, 0x78, 0x69, 0x73, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x49, 0x66, 0x45,
	0x78, 0x69, 0x73, 0x74, 0x73, 0x12, 0x31, 0x0a, 0x12, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x48, 0x0a, 0x08, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x01, 0xfa,
	0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x42, 0x13, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0xa2, 0x02, 0x0a, 0x1d, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x13, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x11, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x36, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x55, 0x73, 0x65,
	0x72, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xa5, 0x01, 0x0a,
	0x17, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26,
	0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8c, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x48, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xb5, 0x02, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x2c, 0x0a, 0x11, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49,
	0x64, 0x12, 0x25, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x61, 0x75, 0x74, 0x68,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x1f, 0x0a, 0x1d, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x9d, 0x01, 0x0a, 0x1c,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x11,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x6b, 0x75,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b,
	0x75, 0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x6b, 0x75, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xdd, 0x02, 0x0a, 0x1d,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2c, 0x0a,
	0x11, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0d, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x73,
	0x6b, 0x75, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x73,
	0x6b, 0x75, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2c, 0x0a, 0x0f,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x1f, 0x0a, 0x1d, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0xa5, 0x01, 0x0a, 0x1e,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b,
	0x0a, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x12, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x49, 0x0a, 0x11, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61,
	0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x05, 0x6f, 0x66, 0x66, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x22, 0x5c,
	0x0a, 0x15, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcd, 0x01, 0x0a,
	0x1e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x48, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x56, 0x69, 0x65,
	0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xaa, 0x01, 0x0a,
	0x1f, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x5f, 0x0a, 0x15, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x13, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x81, 0x01, 0x0a, 0x1c, 0x47, 0x65,
	0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x56, 0x69,
	0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xa2, 0x01,
	0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x62,
	0x0a, 0x14, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65,
	0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61,
	0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x22, 0xe0, 0x01, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x62, 0x0a, 0x14, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e,
	0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x12, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x74, 0x0a, 0x21, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35,
	0x0a, 0x33, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xce, 0x01, 0x0a, 0x23,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xbe, 0x01, 0x0a,
	0x24, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70,
	0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6e, 0x0a, 0x1a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x5f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x18, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xdf, 0x01,
	0x0a, 0x24, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x71, 0x0a, 0x19,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x99, 0x01, 0x0a, 0x24, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x71, 0x0a, 0x19, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65,
	0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x77, 0x0a, 0x24, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70,
	0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52,
	0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x27, 0x47, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x55, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x41,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3b, 0x0a, 0x39, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e,
	0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xde, 0x01, 0x0a, 0x29, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65,
	0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xd8, 0x01, 0x0a, 0x2a, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52,
	0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x81, 0x01, 0x0a, 0x21, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69,
	0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x83, 0x02, 0x0a, 0x2a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x84, 0x01, 0x0a, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1d, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xb3, 0x01, 0x0a, 0x2a, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e,
	0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x84, 0x01, 0x0a, 0x20, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70,
	0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x1d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x83, 0x01, 0x0a, 0x2a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x41, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x3b, 0x0a, 0x39, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x79, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xad, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x42, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6b, 0x75, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x81, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x0a, 0x73, 0x6b,
	0x75, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x09, 0x73, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x95, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x0d, 0x62, 0x69, 0x6c,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x6b, 0x75, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x52, 0x0c, 0x62, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x6b, 0x75, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x96, 0x01, 0x0a,
	0x08, 0x53, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x3a, 0x53, 0xea, 0x41, 0x50, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x28, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f,
	0x73, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x73, 0x6b, 0x75, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x7d, 0x22, 0x95, 0x01, 0x0a, 0x0b, 0x42, 0x69, 0x6c, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x53, 0x6b, 0x75, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x6b, 0x75, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x73, 0x6b, 0x75, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x6b, 0x75, 0x5f, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x73, 0x6b, 0x75, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xd1, 0x01,
	0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x4b, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x22, 0xcc, 0x01, 0x0a, 0x1b, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4d,
	0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1d, 0x0a,
	0x0a, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x61, 0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0x68, 0x0a, 0x1c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x48, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xb5, 0x01, 0x0a, 0x23, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x54, 0x6f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x4d, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0xd0, 0x01, 0x0a, 0x17, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x11, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65,
	0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x49, 0x64, 0x22, 0xb5, 0x01, 0x0a, 0x1c, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x58, 0x0a, 0x10, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x61,
	0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xba, 0x02,
	0x0a, 0x12, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a,
	0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x47,
	0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x70, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73,
	0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x0f,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x56, 0x0a, 0x17, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x50, 0x61, 0x69, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x57, 0x0a, 0x18, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x58, 0x0a, 0x19, 0x53,
	0x75, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x59, 0x0a, 0x1a, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0x67, 0x0a, 0x12, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xa4, 0x01, 0x0a, 0x13, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65,
	0x22, 0x7c, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x08, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe5,
	0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x28, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x6c, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b,
	0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x04, 0x73, 0x6b,
	0x75, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x6b, 0x75, 0x52, 0x04, 0x73, 0x6b, 0x75, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf0, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x66, 0x66,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x31, 0x0a, 0x12, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x66, 0x75, 0x74,
	0x75, 0x72, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x68, 0x6f, 0x77, 0x46, 0x75, 0x74, 0x75, 0x72,
	0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x22, 0x74, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x4f,
	0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36, 0x0a,
	0x06, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x06, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb6, 0x06,
	0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x8f, 0x01, 0x0a,
	0x1b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73,
	0x65, 0x48, 0x00, 0x52, 0x19, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x12, 0x7d,
	0x0a, 0x15, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x70,
	0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63,
	0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x50, 0x75,
	0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x48, 0x00, 0x52, 0x13, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x12, 0x48, 0x0a,
	0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x08, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x28, 0x0a,
	0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0x3a, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x72, 0x63,
	0x68, 0x61, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x1a, 0xfd, 0x01, 0x0a, 0x13, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66,
	0x66, 0x65, 0x72, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x78, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x45, 0x0a, 0x0a,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x48,
	0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x50, 0x47, 0x52, 0x41,
	0x44, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x4f, 0x57, 0x4e, 0x47, 0x52, 0x41, 0x44,
	0x45, 0x10, 0x02, 0x42, 0x11, 0x0a, 0x0f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x10, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x6b, 0x75, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x52, 0x0f, 0x70, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x40, 0x0a, 0x0e, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x6b, 0x75, 0x12, 0x2e, 0x0a, 0x03, 0x73, 0x6b, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x75, 0x52,
	0x03, 0x73, 0x6b, 0x75, 0x22, 0xed, 0x05, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72,
	0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x91, 0x01, 0x0a, 0x1b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x75, 0x72,
	0x63, 0x68, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x48, 0x00, 0x52, 0x19,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x12, 0x7f, 0x0a, 0x15, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61,
	0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x50, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x65, 0x48, 0x00, 0x52, 0x13, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66,
	0x65, 0x72, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x1a, 0x60, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73,
	0x65, 0x12, 0x15, 0x0a, 0x03, 0x73, 0x6b, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x03, 0x73, 0x6b, 0x75, 0x12, 0x2c, 0x0a, 0x0f, 0x62, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x88, 0x01, 0x0a, 0x13, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x12, 0x25,
	0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x07, 0x6e, 0x65, 0x77, 0x5f, 0x73, 0x6b, 0x75,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6e, 0x65, 0x77,
	0x53, 0x6b, 0x75, 0x12, 0x2c, 0x0a, 0x0f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x42, 0x11, 0x0a, 0x0f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa1, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72,
	0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x12, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x72,
	0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x11, 0x70,
	0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x48, 0x0a, 0x10, 0x50, 0x75, 0x72, 0x63,
	0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x05,
	0x6f, 0x66, 0x66, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x05, 0x6f, 0x66, 0x66,
	0x65, 0x72, 0x22, 0x88, 0x01, 0x0a, 0x23, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x6c, 0x69, 0x67,
	0x69, 0x62, 0x6c, 0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x73, 0x6b, 0x75, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x73, 0x6b, 0x75, 0x73, 0x22, 0x81, 0x01,
	0x0a, 0x24, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x42,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x13, 0x73, 0x6b, 0x75, 0x5f, 0x70, 0x75,
	0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b,
	0x75, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x11,
	0x73, 0x6b, 0x75, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x22, 0xa0, 0x01, 0x0a, 0x10, 0x53, 0x6b, 0x75, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x6b, 0x75, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x73, 0x6b, 0x75, 0x73, 0x12, 0x78, 0x0a, 0x1e, 0x62, 0x69,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70, 0x75,
	0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x1b, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x73, 0x22, 0x6e, 0x0a, 0x1a, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x50, 0x0a, 0x0f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x22, 0x68, 0x0a, 0x19, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x32,
	0x0a, 0x1a, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x22, 0x6a, 0x0a, 0x1b, 0x55, 0x6e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x34,
	0x0a, 0x1c, 0x55, 0x6e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x22, 0x7d, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d,
	0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x82, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcb, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x29, 0x0a, 0x27, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa5, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x13, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x12, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xc5,
	0x52, 0x0a, 0x13, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xd4, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5e, 0x5a,
	0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x12, 0xca, 0x01,
	0x0a, 0x0b, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x22, 0x6b, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5e, 0x5a, 0x39, 0x12, 0x37,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe8, 0x01, 0x0a, 0x1f, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x69, 0x73, 0x74, 0x12, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x45, 0x78, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x45, 0x78, 0x69, 0x73, 0x74, 0x12, 0xdd, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x22, 0x78, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x72, 0x3a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5a, 0x43, 0x3a,
	0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x73, 0x22, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x73, 0x12, 0xf1, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x22, 0x8b, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x84, 0x01, 0x3a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5a,
	0x4c, 0x3a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x32, 0x40, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x2a, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc5, 0x01, 0x0a, 0x0e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x6b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x5e, 0x5a, 0x39, 0x2a, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x21,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xdd, 0x01, 0x0a, 0x0e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x22, 0x78, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x72, 0x3a,
	0x01, 0x2a, 0x5a, 0x43, 0x3a, 0x01, 0x2a, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73,
	0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x12, 0xd8, 0x01, 0x0a, 0x16, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x67, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x01, 0x2a, 0x22, 0x3c,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0xb1, 0x01, 0x0a,
	0x10, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x38, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0xbc, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x3a, 0x01,
	0x2a, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x12,
	0xc4, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x39, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x33, 0x3a, 0x01, 0x2a, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x6c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0xa0, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0x38, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc5, 0x01, 0x0a, 0x11, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x5e, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x3a, 0x01, 0x2a, 0x22,
	0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0xd4, 0x01, 0x0a, 0x10, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0xe3, 0x01, 0x0a, 0x15, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x74, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4b, 0x3a, 0x01, 0x2a, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xc5,
	0x01, 0x0a, 0x0b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f,
	0x66, 0x66, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6a, 0xca, 0x41, 0x20, 0x0a,
	0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x01, 0x2a, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x12, 0xd4, 0x01, 0x0a, 0x10, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x50, 0x61, 0x69, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x50, 0x61, 0x69, 0x64, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0xca, 0x41,
	0x20, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x50, 0x61, 0x69, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xcf, 0x01,
	0x0a, 0x12, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x75, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x66, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x12,
	0xd6, 0x01, 0x0a, 0x11, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x22,
	0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x12, 0xd2, 0x01, 0x0a, 0x13, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x67, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a,
	0x01, 0x2a, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x12, 0xe4, 0x01,
	0x0a, 0x14, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x77, 0xca, 0x41, 0x31,
	0x0a, 0x1c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0xf5, 0x01, 0x0a, 0x1c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x54, 0x6f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x54, 0x6f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x78, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x01, 0x2a, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x54, 0x6f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x12, 0xc1, 0x01, 0x0a,
	0x17, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61,
	0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x33, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x12, 0xb0, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x33,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a,
	0x14, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x12, 0xb9, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x36, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x3a, 0x01,
	0x2a, 0x32, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd7,
	0x01, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65,
	0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x4b, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xea, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65,
	0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x95, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x82, 0x01, 0xda, 0x41, 0x20, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x72, 0x65,
	0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x59, 0x3a, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x72,
	0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70,
	0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xa8, 0x02,
	0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x95, 0x01, 0xda, 0x41, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x72,
	0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x73, 0x3a, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f,
	0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x32, 0x56, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f,
	0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc3, 0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69,
	0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x4b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e,
	0x2a, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69,
	0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf9,
	0x01, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72,
	0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52,
	0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65,
	0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5b, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x12, 0x4c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8c, 0x02, 0x0a, 0x22, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65,
	0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65,
	0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e,
	0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5d, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x12, 0x4c, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xc5, 0x02, 0x0a, 0x23, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e,
	0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52,
	0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa0,
	0x01, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x72, 0x69,
	0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x70, 0x3a, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e,
	0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65,
	0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x12, 0xe0, 0x02, 0x0a, 0x23, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xbb, 0x01, 0xda, 0x41, 0x20, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x91, 0x01, 0x3a, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72,
	0x74, 0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65,
	0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdf, 0x01, 0x0a, 0x23, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70,
	0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69,
	0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x5b, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x2a, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa2, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x32, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x73, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0xd2, 0x01, 0x0a, 0x18,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x69, 0x6c, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42,
	0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73,
	0x12, 0xa7, 0x01, 0x0a, 0x0b, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x4f, 0x66, 0x66, 0x65, 0x72,
	0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x6f, 0x6b, 0x75,
	0x70, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x22, 0x4b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c,
	0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x81, 0x01, 0x0a, 0x0c, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x14, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x0e,
	0x12, 0x0c, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x85,
	0x01, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x24, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x12, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x73, 0x6b, 0x75, 0x73, 0x12, 0x8d, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x4f,
	0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0xc3, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72,
	0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72,
	0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x12, 0xcb, 0x01, 0x0a,
	0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63,
	0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0xe7, 0x01, 0x0a, 0x1c, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x42, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x6c, 0x69, 0x67, 0x69,
	0x62, 0x6c, 0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c,
	0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44,
	0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x3d,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x45, 0x6c, 0x69,
	0x67, 0x69, 0x62, 0x6c, 0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x12, 0xab, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x12, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x3a, 0x01, 0x2a, 0x22,
	0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x12, 0xb3, 0x01, 0x0a, 0x14, 0x55, 0x6e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x12, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28,
	0x3a, 0x01, 0x2a, 0x22, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x12, 0xa6, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x73, 0x12, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72,
	0x73, 0x12, 0xe5, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5a, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x12, 0x49,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x1a, 0x4b, 0xca, 0x41, 0x1b, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2a, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x64, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x35, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x70, 0x62, 0x3b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_channel_v1_service_proto_rawDescOnce sync.Once
	file_google_cloud_channel_v1_service_proto_rawDescData = file_google_cloud_channel_v1_service_proto_rawDesc
)

func file_google_cloud_channel_v1_service_proto_rawDescGZIP() []byte {
	file_google_cloud_channel_v1_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_channel_v1_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_channel_v1_service_proto_rawDescData)
	})
	return file_google_cloud_channel_v1_service_proto_rawDescData
}

var file_google_cloud_channel_v1_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_channel_v1_service_proto_msgTypes = make([]protoimpl.MessageInfo, 82)
var file_google_cloud_channel_v1_service_proto_goTypes = []interface{}{
	(ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType)(0), // 0: google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
	(*CheckCloudIdentityAccountsExistRequest)(nil),                 // 1: google.cloud.channel.v1.CheckCloudIdentityAccountsExistRequest
	(*CloudIdentityCustomerAccount)(nil),                           // 2: google.cloud.channel.v1.CloudIdentityCustomerAccount
	(*CheckCloudIdentityAccountsExistResponse)(nil),                // 3: google.cloud.channel.v1.CheckCloudIdentityAccountsExistResponse
	(*ListCustomersRequest)(nil),                                   // 4: google.cloud.channel.v1.ListCustomersRequest
	(*ListCustomersResponse)(nil),                                  // 5: google.cloud.channel.v1.ListCustomersResponse
	(*GetCustomerRequest)(nil),                                     // 6: google.cloud.channel.v1.GetCustomerRequest
	(*CreateCustomerRequest)(nil),                                  // 7: google.cloud.channel.v1.CreateCustomerRequest
	(*UpdateCustomerRequest)(nil),                                  // 8: google.cloud.channel.v1.UpdateCustomerRequest
	(*DeleteCustomerRequest)(nil),                                  // 9: google.cloud.channel.v1.DeleteCustomerRequest
	(*ImportCustomerRequest)(nil),                                  // 10: google.cloud.channel.v1.ImportCustomerRequest
	(*ProvisionCloudIdentityRequest)(nil),                          // 11: google.cloud.channel.v1.ProvisionCloudIdentityRequest
	(*ListEntitlementsRequest)(nil),                                // 12: google.cloud.channel.v1.ListEntitlementsRequest
	(*ListEntitlementsResponse)(nil),                               // 13: google.cloud.channel.v1.ListEntitlementsResponse
	(*ListTransferableSkusRequest)(nil),                            // 14: google.cloud.channel.v1.ListTransferableSkusRequest
	(*ListTransferableSkusResponse)(nil),                           // 15: google.cloud.channel.v1.ListTransferableSkusResponse
	(*ListTransferableOffersRequest)(nil),                          // 16: google.cloud.channel.v1.ListTransferableOffersRequest
	(*ListTransferableOffersResponse)(nil),                         // 17: google.cloud.channel.v1.ListTransferableOffersResponse
	(*TransferableOffer)(nil),                                      // 18: google.cloud.channel.v1.TransferableOffer
	(*GetEntitlementRequest)(nil),                                  // 19: google.cloud.channel.v1.GetEntitlementRequest
	(*ListChannelPartnerLinksRequest)(nil),                         // 20: google.cloud.channel.v1.ListChannelPartnerLinksRequest
	(*ListChannelPartnerLinksResponse)(nil),                        // 21: google.cloud.channel.v1.ListChannelPartnerLinksResponse
	(*GetChannelPartnerLinkRequest)(nil),                           // 22: google.cloud.channel.v1.GetChannelPartnerLinkRequest
	(*CreateChannelPartnerLinkRequest)(nil),                        // 23: google.cloud.channel.v1.CreateChannelPartnerLinkRequest
	(*UpdateChannelPartnerLinkRequest)(nil),                        // 24: google.cloud.channel.v1.UpdateChannelPartnerLinkRequest
	(*GetCustomerRepricingConfigRequest)(nil),                      // 25: google.cloud.channel.v1.GetCustomerRepricingConfigRequest
	(*ListCustomerRepricingConfigsRequest)(nil),                    // 26: google.cloud.channel.v1.ListCustomerRepricingConfigsRequest
	(*ListCustomerRepricingConfigsResponse)(nil),                   // 27: google.cloud.channel.v1.ListCustomerRepricingConfigsResponse
	(*CreateCustomerRepricingConfigRequest)(nil),                   // 28: google.cloud.channel.v1.CreateCustomerRepricingConfigRequest
	(*UpdateCustomerRepricingConfigRequest)(nil),                   // 29: google.cloud.channel.v1.UpdateCustomerRepricingConfigRequest
	(*DeleteCustomerRepricingConfigRequest)(nil),                   // 30: google.cloud.channel.v1.DeleteCustomerRepricingConfigRequest
	(*GetChannelPartnerRepricingConfigRequest)(nil),                // 31: google.cloud.channel.v1.GetChannelPartnerRepricingConfigRequest
	(*ListChannelPartnerRepricingConfigsRequest)(nil),              // 32: google.cloud.channel.v1.ListChannelPartnerRepricingConfigsRequest
	(*ListChannelPartnerRepricingConfigsResponse)(nil),             // 33: google.cloud.channel.v1.ListChannelPartnerRepricingConfigsResponse
	(*CreateChannelPartnerRepricingConfigRequest)(nil),             // 34: google.cloud.channel.v1.CreateChannelPartnerRepricingConfigRequest
	(*UpdateChannelPartnerRepricingConfigRequest)(nil),             // 35: google.cloud.channel.v1.UpdateChannelPartnerRepricingConfigRequest
	(*DeleteChannelPartnerRepricingConfigRequest)(nil),             // 36: google.cloud.channel.v1.DeleteChannelPartnerRepricingConfigRequest
	(*ListSkuGroupsRequest)(nil),                                   // 37: google.cloud.channel.v1.ListSkuGroupsRequest
	(*ListSkuGroupBillableSkusRequest)(nil),                        // 38: google.cloud.channel.v1.ListSkuGroupBillableSkusRequest
	(*ListSkuGroupsResponse)(nil),                                  // 39: google.cloud.channel.v1.ListSkuGroupsResponse
	(*ListSkuGroupBillableSkusResponse)(nil),                       // 40: google.cloud.channel.v1.ListSkuGroupBillableSkusResponse
	(*SkuGroup)(nil),                                               // 41: google.cloud.channel.v1.SkuGroup
	(*BillableSku)(nil),                                            // 42: google.cloud.channel.v1.BillableSku
	(*CreateEntitlementRequest)(nil),                               // 43: google.cloud.channel.v1.CreateEntitlementRequest
	(*TransferEntitlementsRequest)(nil),                            // 44: google.cloud.channel.v1.TransferEntitlementsRequest
	(*TransferEntitlementsResponse)(nil),                           // 45: google.cloud.channel.v1.TransferEntitlementsResponse
	(*TransferEntitlementsToGoogleRequest)(nil),                    // 46: google.cloud.channel.v1.TransferEntitlementsToGoogleRequest
	(*ChangeParametersRequest)(nil),                                // 47: google.cloud.channel.v1.ChangeParametersRequest
	(*ChangeRenewalSettingsRequest)(nil),                           // 48: google.cloud.channel.v1.ChangeRenewalSettingsRequest
	(*ChangeOfferRequest)(nil),                                     // 49: google.cloud.channel.v1.ChangeOfferRequest
	(*StartPaidServiceRequest)(nil),                                // 50: google.cloud.channel.v1.StartPaidServiceRequest
	(*CancelEntitlementRequest)(nil),                               // 51: google.cloud.channel.v1.CancelEntitlementRequest
	(*SuspendEntitlementRequest)(nil),                              // 52: google.cloud.channel.v1.SuspendEntitlementRequest
	(*ActivateEntitlementRequest)(nil),                             // 53: google.cloud.channel.v1.ActivateEntitlementRequest
	(*LookupOfferRequest)(nil),                                     // 54: google.cloud.channel.v1.LookupOfferRequest
	(*ListProductsRequest)(nil),                                    // 55: google.cloud.channel.v1.ListProductsRequest
	(*ListProductsResponse)(nil),                                   // 56: google.cloud.channel.v1.ListProductsResponse
	(*ListSkusRequest)(nil),                                        // 57: google.cloud.channel.v1.ListSkusRequest
	(*ListSkusResponse)(nil),                                       // 58: google.cloud.channel.v1.ListSkusResponse
	(*ListOffersRequest)(nil),                                      // 59: google.cloud.channel.v1.ListOffersRequest
	(*ListOffersResponse)(nil),                                     // 60: google.cloud.channel.v1.ListOffersResponse
	(*ListPurchasableSkusRequest)(nil),                             // 61: google.cloud.channel.v1.ListPurchasableSkusRequest
	(*ListPurchasableSkusResponse)(nil),                            // 62: google.cloud.channel.v1.ListPurchasableSkusResponse
	(*PurchasableSku)(nil),                                         // 63: google.cloud.channel.v1.PurchasableSku
	(*ListPurchasableOffersRequest)(nil),                           // 64: google.cloud.channel.v1.ListPurchasableOffersRequest
	(*ListPurchasableOffersResponse)(nil),                          // 65: google.cloud.channel.v1.ListPurchasableOffersResponse
	(*PurchasableOffer)(nil),                                       // 66: google.cloud.channel.v1.PurchasableOffer
	(*QueryEligibleBillingAccountsRequest)(nil),                    // 67: google.cloud.channel.v1.QueryEligibleBillingAccountsRequest
	(*QueryEligibleBillingAccountsResponse)(nil),                   // 68: google.cloud.channel.v1.QueryEligibleBillingAccountsResponse
	(*SkuPurchaseGroup)(nil),                                       // 69: google.cloud.channel.v1.SkuPurchaseGroup
	(*BillingAccountPurchaseInfo)(nil),                             // 70: google.cloud.channel.v1.BillingAccountPurchaseInfo
	(*RegisterSubscriberRequest)(nil),                              // 71: google.cloud.channel.v1.RegisterSubscriberRequest
	(*RegisterSubscriberResponse)(nil),                             // 72: google.cloud.channel.v1.RegisterSubscriberResponse
	(*UnregisterSubscriberRequest)(nil),                            // 73: google.cloud.channel.v1.UnregisterSubscriberRequest
	(*UnregisterSubscriberResponse)(nil),                           // 74: google.cloud.channel.v1.UnregisterSubscriberResponse
	(*ListSubscribersRequest)(nil),                                 // 75: google.cloud.channel.v1.ListSubscribersRequest
	(*ListSubscribersResponse)(nil),                                // 76: google.cloud.channel.v1.ListSubscribersResponse
	(*ListEntitlementChangesRequest)(nil),                          // 77: google.cloud.channel.v1.ListEntitlementChangesRequest
	(*ListEntitlementChangesResponse)(nil),                         // 78: google.cloud.channel.v1.ListEntitlementChangesResponse
	(*ListPurchasableSkusRequest_CreateEntitlementPurchase)(nil),   // 79: google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
	(*ListPurchasableSkusRequest_ChangeOfferPurchase)(nil),         // 80: google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
	(*ListPurchasableOffersRequest_CreateEntitlementPurchase)(nil), // 81: google.cloud.channel.v1.ListPurchasableOffersRequest.CreateEntitlementPurchase
	(*ListPurchasableOffersRequest_ChangeOfferPurchase)(nil),       // 82: google.cloud.channel.v1.ListPurchasableOffersRequest.ChangeOfferPurchase
	(*Customer)(nil),                                               // 83: google.cloud.channel.v1.Customer
	(*fieldmaskpb.FieldMask)(nil),                                  // 84: google.protobuf.FieldMask
	(*CloudIdentityInfo)(nil),                                      // 85: google.cloud.channel.v1.CloudIdentityInfo
	(*AdminUser)(nil),                                              // 86: google.cloud.channel.v1.AdminUser
	(*Entitlement)(nil),                                            // 87: google.cloud.channel.v1.Entitlement
	(*TransferableSku)(nil),                                        // 88: google.cloud.channel.v1.TransferableSku
	(*Offer)(nil),                                                  // 89: google.cloud.channel.v1.Offer
	(ChannelPartnerLinkView)(0),                                    // 90: google.cloud.channel.v1.ChannelPartnerLinkView
	(*ChannelPartnerLink)(nil),                                     // 91: google.cloud.channel.v1.ChannelPartnerLink
	(*CustomerRepricingConfig)(nil),                                // 92: google.cloud.channel.v1.CustomerRepricingConfig
	(*ChannelPartnerRepricingConfig)(nil),                          // 93: google.cloud.channel.v1.ChannelPartnerRepricingConfig
	(*Parameter)(nil),                                              // 94: google.cloud.channel.v1.Parameter
	(*RenewalSettings)(nil),                                        // 95: google.cloud.channel.v1.RenewalSettings
	(*Product)(nil),                                                // 96: google.cloud.channel.v1.Product
	(*Sku)(nil),                                                    // 97: google.cloud.channel.v1.Sku
	(*BillingAccount)(nil),                                         // 98: google.cloud.channel.v1.BillingAccount
	(*EntitlementChange)(nil),                                      // 99: google.cloud.channel.v1.EntitlementChange
	(*emptypb.Empty)(nil),                                          // 100: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),                                // 101: google.longrunning.Operation
}
var file_google_cloud_channel_v1_service_proto_depIdxs = []int32{
	2,   // 0: google.cloud.channel.v1.CheckCloudIdentityAccountsExistResponse.cloud_identity_accounts:type_name -> google.cloud.channel.v1.CloudIdentityCustomerAccount
	83,  // 1: google.cloud.channel.v1.ListCustomersResponse.customers:type_name -> google.cloud.channel.v1.Customer
	83,  // 2: google.cloud.channel.v1.CreateCustomerRequest.customer:type_name -> google.cloud.channel.v1.Customer
	83,  // 3: google.cloud.channel.v1.UpdateCustomerRequest.customer:type_name -> google.cloud.channel.v1.Customer
	84,  // 4: google.cloud.channel.v1.UpdateCustomerRequest.update_mask:type_name -> google.protobuf.FieldMask
	85,  // 5: google.cloud.channel.v1.ProvisionCloudIdentityRequest.cloud_identity_info:type_name -> google.cloud.channel.v1.CloudIdentityInfo
	86,  // 6: google.cloud.channel.v1.ProvisionCloudIdentityRequest.user:type_name -> google.cloud.channel.v1.AdminUser
	87,  // 7: google.cloud.channel.v1.ListEntitlementsResponse.entitlements:type_name -> google.cloud.channel.v1.Entitlement
	88,  // 8: google.cloud.channel.v1.ListTransferableSkusResponse.transferable_skus:type_name -> google.cloud.channel.v1.TransferableSku
	18,  // 9: google.cloud.channel.v1.ListTransferableOffersResponse.transferable_offers:type_name -> google.cloud.channel.v1.TransferableOffer
	89,  // 10: google.cloud.channel.v1.TransferableOffer.offer:type_name -> google.cloud.channel.v1.Offer
	90,  // 11: google.cloud.channel.v1.ListChannelPartnerLinksRequest.view:type_name -> google.cloud.channel.v1.ChannelPartnerLinkView
	91,  // 12: google.cloud.channel.v1.ListChannelPartnerLinksResponse.channel_partner_links:type_name -> google.cloud.channel.v1.ChannelPartnerLink
	90,  // 13: google.cloud.channel.v1.GetChannelPartnerLinkRequest.view:type_name -> google.cloud.channel.v1.ChannelPartnerLinkView
	91,  // 14: google.cloud.channel.v1.CreateChannelPartnerLinkRequest.channel_partner_link:type_name -> google.cloud.channel.v1.ChannelPartnerLink
	91,  // 15: google.cloud.channel.v1.UpdateChannelPartnerLinkRequest.channel_partner_link:type_name -> google.cloud.channel.v1.ChannelPartnerLink
	84,  // 16: google.cloud.channel.v1.UpdateChannelPartnerLinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	92,  // 17: google.cloud.channel.v1.ListCustomerRepricingConfigsResponse.customer_repricing_configs:type_name -> google.cloud.channel.v1.CustomerRepricingConfig
	92,  // 18: google.cloud.channel.v1.CreateCustomerRepricingConfigRequest.customer_repricing_config:type_name -> google.cloud.channel.v1.CustomerRepricingConfig
	92,  // 19: google.cloud.channel.v1.UpdateCustomerRepricingConfigRequest.customer_repricing_config:type_name -> google.cloud.channel.v1.CustomerRepricingConfig
	93,  // 20: google.cloud.channel.v1.ListChannelPartnerRepricingConfigsResponse.channel_partner_repricing_configs:type_name -> google.cloud.channel.v1.ChannelPartnerRepricingConfig
	93,  // 21: google.cloud.channel.v1.CreateChannelPartnerRepricingConfigRequest.channel_partner_repricing_config:type_name -> google.cloud.channel.v1.ChannelPartnerRepricingConfig
	93,  // 22: google.cloud.channel.v1.UpdateChannelPartnerRepricingConfigRequest.channel_partner_repricing_config:type_name -> google.cloud.channel.v1.ChannelPartnerRepricingConfig
	41,  // 23: google.cloud.channel.v1.ListSkuGroupsResponse.sku_groups:type_name -> google.cloud.channel.v1.SkuGroup
	42,  // 24: google.cloud.channel.v1.ListSkuGroupBillableSkusResponse.billable_skus:type_name -> google.cloud.channel.v1.BillableSku
	87,  // 25: google.cloud.channel.v1.CreateEntitlementRequest.entitlement:type_name -> google.cloud.channel.v1.Entitlement
	87,  // 26: google.cloud.channel.v1.TransferEntitlementsRequest.entitlements:type_name -> google.cloud.channel.v1.Entitlement
	87,  // 27: google.cloud.channel.v1.TransferEntitlementsResponse.entitlements:type_name -> google.cloud.channel.v1.Entitlement
	87,  // 28: google.cloud.channel.v1.TransferEntitlementsToGoogleRequest.entitlements:type_name -> google.cloud.channel.v1.Entitlement
	94,  // 29: google.cloud.channel.v1.ChangeParametersRequest.parameters:type_name -> google.cloud.channel.v1.Parameter
	95,  // 30: google.cloud.channel.v1.ChangeRenewalSettingsRequest.renewal_settings:type_name -> google.cloud.channel.v1.RenewalSettings
	94,  // 31: google.cloud.channel.v1.ChangeOfferRequest.parameters:type_name -> google.cloud.channel.v1.Parameter
	96,  // 32: google.cloud.channel.v1.ListProductsResponse.products:type_name -> google.cloud.channel.v1.Product
	97,  // 33: google.cloud.channel.v1.ListSkusResponse.skus:type_name -> google.cloud.channel.v1.Sku
	89,  // 34: google.cloud.channel.v1.ListOffersResponse.offers:type_name -> google.cloud.channel.v1.Offer
	79,  // 35: google.cloud.channel.v1.ListPurchasableSkusRequest.create_entitlement_purchase:type_name -> google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
	80,  // 36: google.cloud.channel.v1.ListPurchasableSkusRequest.change_offer_purchase:type_name -> google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
	63,  // 37: google.cloud.channel.v1.ListPurchasableSkusResponse.purchasable_skus:type_name -> google.cloud.channel.v1.PurchasableSku
	97,  // 38: google.cloud.channel.v1.PurchasableSku.sku:type_name -> google.cloud.channel.v1.Sku
	81,  // 39: google.cloud.channel.v1.ListPurchasableOffersRequest.create_entitlement_purchase:type_name -> google.cloud.channel.v1.ListPurchasableOffersRequest.CreateEntitlementPurchase
	82,  // 40: google.cloud.channel.v1.ListPurchasableOffersRequest.change_offer_purchase:type_name -> google.cloud.channel.v1.ListPurchasableOffersRequest.ChangeOfferPurchase
	66,  // 41: google.cloud.channel.v1.ListPurchasableOffersResponse.purchasable_offers:type_name -> google.cloud.channel.v1.PurchasableOffer
	89,  // 42: google.cloud.channel.v1.PurchasableOffer.offer:type_name -> google.cloud.channel.v1.Offer
	69,  // 43: google.cloud.channel.v1.QueryEligibleBillingAccountsResponse.sku_purchase_groups:type_name -> google.cloud.channel.v1.SkuPurchaseGroup
	70,  // 44: google.cloud.channel.v1.SkuPurchaseGroup.billing_account_purchase_infos:type_name -> google.cloud.channel.v1.BillingAccountPurchaseInfo
	98,  // 45: google.cloud.channel.v1.BillingAccountPurchaseInfo.billing_account:type_name -> google.cloud.channel.v1.BillingAccount
	99,  // 46: google.cloud.channel.v1.ListEntitlementChangesResponse.entitlement_changes:type_name -> google.cloud.channel.v1.EntitlementChange
	0,   // 47: google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.change_type:type_name -> google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
	4,   // 48: google.cloud.channel.v1.CloudChannelService.ListCustomers:input_type -> google.cloud.channel.v1.ListCustomersRequest
	6,   // 49: google.cloud.channel.v1.CloudChannelService.GetCustomer:input_type -> google.cloud.channel.v1.GetCustomerRequest
	1,   // 50: google.cloud.channel.v1.CloudChannelService.CheckCloudIdentityAccountsExist:input_type -> google.cloud.channel.v1.CheckCloudIdentityAccountsExistRequest
	7,   // 51: google.cloud.channel.v1.CloudChannelService.CreateCustomer:input_type -> google.cloud.channel.v1.CreateCustomerRequest
	8,   // 52: google.cloud.channel.v1.CloudChannelService.UpdateCustomer:input_type -> google.cloud.channel.v1.UpdateCustomerRequest
	9,   // 53: google.cloud.channel.v1.CloudChannelService.DeleteCustomer:input_type -> google.cloud.channel.v1.DeleteCustomerRequest
	10,  // 54: google.cloud.channel.v1.CloudChannelService.ImportCustomer:input_type -> google.cloud.channel.v1.ImportCustomerRequest
	11,  // 55: google.cloud.channel.v1.CloudChannelService.ProvisionCloudIdentity:input_type -> google.cloud.channel.v1.ProvisionCloudIdentityRequest
	12,  // 56: google.cloud.channel.v1.CloudChannelService.ListEntitlements:input_type -> google.cloud.channel.v1.ListEntitlementsRequest
	14,  // 57: google.cloud.channel.v1.CloudChannelService.ListTransferableSkus:input_type -> google.cloud.channel.v1.ListTransferableSkusRequest
	16,  // 58: google.cloud.channel.v1.CloudChannelService.ListTransferableOffers:input_type -> google.cloud.channel.v1.ListTransferableOffersRequest
	19,  // 59: google.cloud.channel.v1.CloudChannelService.GetEntitlement:input_type -> google.cloud.channel.v1.GetEntitlementRequest
	43,  // 60: google.cloud.channel.v1.CloudChannelService.CreateEntitlement:input_type -> google.cloud.channel.v1.CreateEntitlementRequest
	47,  // 61: google.cloud.channel.v1.CloudChannelService.ChangeParameters:input_type -> google.cloud.channel.v1.ChangeParametersRequest
	48,  // 62: google.cloud.channel.v1.CloudChannelService.ChangeRenewalSettings:input_type -> google.cloud.channel.v1.ChangeRenewalSettingsRequest
	49,  // 63: google.cloud.channel.v1.CloudChannelService.ChangeOffer:input_type -> google.cloud.channel.v1.ChangeOfferRequest
	50,  // 64: google.cloud.channel.v1.CloudChannelService.StartPaidService:input_type -> google.cloud.channel.v1.StartPaidServiceRequest
	52,  // 65: google.cloud.channel.v1.CloudChannelService.SuspendEntitlement:input_type -> google.cloud.channel.v1.SuspendEntitlementRequest
	51,  // 66: google.cloud.channel.v1.CloudChannelService.CancelEntitlement:input_type -> google.cloud.channel.v1.CancelEntitlementRequest
	53,  // 67: google.cloud.channel.v1.CloudChannelService.ActivateEntitlement:input_type -> google.cloud.channel.v1.ActivateEntitlementRequest
	44,  // 68: google.cloud.channel.v1.CloudChannelService.TransferEntitlements:input_type -> google.cloud.channel.v1.TransferEntitlementsRequest
	46,  // 69: google.cloud.channel.v1.CloudChannelService.TransferEntitlementsToGoogle:input_type -> google.cloud.channel.v1.TransferEntitlementsToGoogleRequest
	20,  // 70: google.cloud.channel.v1.CloudChannelService.ListChannelPartnerLinks:input_type -> google.cloud.channel.v1.ListChannelPartnerLinksRequest
	22,  // 71: google.cloud.channel.v1.CloudChannelService.GetChannelPartnerLink:input_type -> google.cloud.channel.v1.GetChannelPartnerLinkRequest
	23,  // 72: google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerLink:input_type -> google.cloud.channel.v1.CreateChannelPartnerLinkRequest
	24,  // 73: google.cloud.channel.v1.CloudChannelService.UpdateChannelPartnerLink:input_type -> google.cloud.channel.v1.UpdateChannelPartnerLinkRequest
	25,  // 74: google.cloud.channel.v1.CloudChannelService.GetCustomerRepricingConfig:input_type -> google.cloud.channel.v1.GetCustomerRepricingConfigRequest
	26,  // 75: google.cloud.channel.v1.CloudChannelService.ListCustomerRepricingConfigs:input_type -> google.cloud.channel.v1.ListCustomerRepricingConfigsRequest
	28,  // 76: google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig:input_type -> google.cloud.channel.v1.CreateCustomerRepricingConfigRequest
	29,  // 77: google.cloud.channel.v1.CloudChannelService.UpdateCustomerRepricingConfig:input_type -> google.cloud.channel.v1.UpdateCustomerRepricingConfigRequest
	30,  // 78: google.cloud.channel.v1.CloudChannelService.DeleteCustomerRepricingConfig:input_type -> google.cloud.channel.v1.DeleteCustomerRepricingConfigRequest
	31,  // 79: google.cloud.channel.v1.CloudChannelService.GetChannelPartnerRepricingConfig:input_type -> google.cloud.channel.v1.GetChannelPartnerRepricingConfigRequest
	32,  // 80: google.cloud.channel.v1.CloudChannelService.ListChannelPartnerRepricingConfigs:input_type -> google.cloud.channel.v1.ListChannelPartnerRepricingConfigsRequest
	34,  // 81: google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig:input_type -> google.cloud.channel.v1.CreateChannelPartnerRepricingConfigRequest
	35,  // 82: google.cloud.channel.v1.CloudChannelService.UpdateChannelPartnerRepricingConfig:input_type -> google.cloud.channel.v1.UpdateChannelPartnerRepricingConfigRequest
	36,  // 83: google.cloud.channel.v1.CloudChannelService.DeleteChannelPartnerRepricingConfig:input_type -> google.cloud.channel.v1.DeleteChannelPartnerRepricingConfigRequest
	37,  // 84: google.cloud.channel.v1.CloudChannelService.ListSkuGroups:input_type -> google.cloud.channel.v1.ListSkuGroupsRequest
	38,  // 85: google.cloud.channel.v1.CloudChannelService.ListSkuGroupBillableSkus:input_type -> google.cloud.channel.v1.ListSkuGroupBillableSkusRequest
	54,  // 86: google.cloud.channel.v1.CloudChannelService.LookupOffer:input_type -> google.cloud.channel.v1.LookupOfferRequest
	55,  // 87: google.cloud.channel.v1.CloudChannelService.ListProducts:input_type -> google.cloud.channel.v1.ListProductsRequest
	57,  // 88: google.cloud.channel.v1.CloudChannelService.ListSkus:input_type -> google.cloud.channel.v1.ListSkusRequest
	59,  // 89: google.cloud.channel.v1.CloudChannelService.ListOffers:input_type -> google.cloud.channel.v1.ListOffersRequest
	61,  // 90: google.cloud.channel.v1.CloudChannelService.ListPurchasableSkus:input_type -> google.cloud.channel.v1.ListPurchasableSkusRequest
	64,  // 91: google.cloud.channel.v1.CloudChannelService.ListPurchasableOffers:input_type -> google.cloud.channel.v1.ListPurchasableOffersRequest
	67,  // 92: google.cloud.channel.v1.CloudChannelService.QueryEligibleBillingAccounts:input_type -> google.cloud.channel.v1.QueryEligibleBillingAccountsRequest
	71,  // 93: google.cloud.channel.v1.CloudChannelService.RegisterSubscriber:input_type -> google.cloud.channel.v1.RegisterSubscriberRequest
	73,  // 94: google.cloud.channel.v1.CloudChannelService.UnregisterSubscriber:input_type -> google.cloud.channel.v1.UnregisterSubscriberRequest
	75,  // 95: google.cloud.channel.v1.CloudChannelService.ListSubscribers:input_type -> google.cloud.channel.v1.ListSubscribersRequest
	77,  // 96: google.cloud.channel.v1.CloudChannelService.ListEntitlementChanges:input_type -> google.cloud.channel.v1.ListEntitlementChangesRequest
	5,   // 97: google.cloud.channel.v1.CloudChannelService.ListCustomers:output_type -> google.cloud.channel.v1.ListCustomersResponse
	83,  // 98: google.cloud.channel.v1.CloudChannelService.GetCustomer:output_type -> google.cloud.channel.v1.Customer
	3,   // 99: google.cloud.channel.v1.CloudChannelService.CheckCloudIdentityAccountsExist:output_type -> google.cloud.channel.v1.CheckCloudIdentityAccountsExistResponse
	83,  // 100: google.cloud.channel.v1.CloudChannelService.CreateCustomer:output_type -> google.cloud.channel.v1.Customer
	83,  // 101: google.cloud.channel.v1.CloudChannelService.UpdateCustomer:output_type -> google.cloud.channel.v1.Customer
	100, // 102: google.cloud.channel.v1.CloudChannelService.DeleteCustomer:output_type -> google.protobuf.Empty
	83,  // 103: google.cloud.channel.v1.CloudChannelService.ImportCustomer:output_type -> google.cloud.channel.v1.Customer
	101, // 104: google.cloud.channel.v1.CloudChannelService.ProvisionCloudIdentity:output_type -> google.longrunning.Operation
	13,  // 105: google.cloud.channel.v1.CloudChannelService.ListEntitlements:output_type -> google.cloud.channel.v1.ListEntitlementsResponse
	15,  // 106: google.cloud.channel.v1.CloudChannelService.ListTransferableSkus:output_type -> google.cloud.channel.v1.ListTransferableSkusResponse
	17,  // 107: google.cloud.channel.v1.CloudChannelService.ListTransferableOffers:output_type -> google.cloud.channel.v1.ListTransferableOffersResponse
	87,  // 108: google.cloud.channel.v1.CloudChannelService.GetEntitlement:output_type -> google.cloud.channel.v1.Entitlement
	101, // 109: google.cloud.channel.v1.CloudChannelService.CreateEntitlement:output_type -> google.longrunning.Operation
	101, // 110: google.cloud.channel.v1.CloudChannelService.ChangeParameters:output_type -> google.longrunning.Operation
	101, // 111: google.cloud.channel.v1.CloudChannelService.ChangeRenewalSettings:output_type -> google.longrunning.Operation
	101, // 112: google.cloud.channel.v1.CloudChannelService.ChangeOffer:output_type -> google.longrunning.Operation
	101, // 113: google.cloud.channel.v1.CloudChannelService.StartPaidService:output_type -> google.longrunning.Operation
	101, // 114: google.cloud.channel.v1.CloudChannelService.SuspendEntitlement:output_type -> google.longrunning.Operation
	101, // 115: google.cloud.channel.v1.CloudChannelService.CancelEntitlement:output_type -> google.longrunning.Operation
	101, // 116: google.cloud.channel.v1.CloudChannelService.ActivateEntitlement:output_type -> google.longrunning.Operation
	101, // 117: google.cloud.channel.v1.CloudChannelService.TransferEntitlements:output_type -> google.longrunning.Operation
	101, // 118: google.cloud.channel.v1.CloudChannelService.TransferEntitlementsToGoogle:output_type -> google.longrunning.Operation
	21,  // 119: google.cloud.channel.v1.CloudChannelService.ListChannelPartnerLinks:output_type -> google.cloud.channel.v1.ListChannelPartnerLinksResponse
	91,  // 120: google.cloud.channel.v1.CloudChannelService.GetChannelPartnerLink:output_type -> google.cloud.channel.v1.ChannelPartnerLink
	91,  // 121: google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerLink:output_type -> google.cloud.channel.v1.ChannelPartnerLink
	91,  // 122: google.cloud.channel.v1.CloudChannelService.UpdateChannelPartnerLink:output_type -> google.cloud.channel.v1.ChannelPartnerLink
	92,  // 123: google.cloud.channel.v1.CloudChannelService.GetCustomerRepricingConfig:output_type -> google.cloud.channel.v1.CustomerRepricingConfig
	27,  // 124: google.cloud.channel.v1.CloudChannelService.ListCustomerRepricingConfigs:output_type -> google.cloud.channel.v1.ListCustomerRepricingConfigsResponse
	92,  // 125: google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig:output_type -> google.cloud.channel.v1.CustomerRepricingConfig
	92,  // 126: google.cloud.channel.v1.CloudChannelService.UpdateCustomerRepricingConfig:output_type -> google.cloud.channel.v1.CustomerRepricingConfig
	100, // 127: google.cloud.channel.v1.CloudChannelService.DeleteCustomerRepricingConfig:output_type -> google.protobuf.Empty
	93,  // 128: google.cloud.channel.v1.CloudChannelService.GetChannelPartnerRepricingConfig:output_type -> google.cloud.channel.v1.ChannelPartnerRepricingConfig
	33,  // 129: google.cloud.channel.v1.CloudChannelService.ListChannelPartnerRepricingConfigs:output_type -> google.cloud.channel.v1.ListChannelPartnerRepricingConfigsResponse
	93,  // 130: google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig:output_type -> google.cloud.channel.v1.ChannelPartnerRepricingConfig
	93,  // 131: google.cloud.channel.v1.CloudChannelService.UpdateChannelPartnerRepricingConfig:output_type -> google.cloud.channel.v1.ChannelPartnerRepricingConfig
	100, // 132: google.cloud.channel.v1.CloudChannelService.DeleteChannelPartnerRepricingConfig:output_type -> google.protobuf.Empty
	39,  // 133: google.cloud.channel.v1.CloudChannelService.ListSkuGroups:output_type -> google.cloud.channel.v1.ListSkuGroupsResponse
	40,  // 134: google.cloud.channel.v1.CloudChannelService.ListSkuGroupBillableSkus:output_type -> google.cloud.channel.v1.ListSkuGroupBillableSkusResponse
	89,  // 135: google.cloud.channel.v1.CloudChannelService.LookupOffer:output_type -> google.cloud.channel.v1.Offer
	56,  // 136: google.cloud.channel.v1.CloudChannelService.ListProducts:output_type -> google.cloud.channel.v1.ListProductsResponse
	58,  // 137: google.cloud.channel.v1.CloudChannelService.ListSkus:output_type -> google.cloud.channel.v1.ListSkusResponse
	60,  // 138: google.cloud.channel.v1.CloudChannelService.ListOffers:output_type -> google.cloud.channel.v1.ListOffersResponse
	62,  // 139: google.cloud.channel.v1.CloudChannelService.ListPurchasableSkus:output_type -> google.cloud.channel.v1.ListPurchasableSkusResponse
	65,  // 140: google.cloud.channel.v1.CloudChannelService.ListPurchasableOffers:output_type -> google.cloud.channel.v1.ListPurchasableOffersResponse
	68,  // 141: google.cloud.channel.v1.CloudChannelService.QueryEligibleBillingAccounts:output_type -> google.cloud.channel.v1.QueryEligibleBillingAccountsResponse
	72,  // 142: google.cloud.channel.v1.CloudChannelService.RegisterSubscriber:output_type -> google.cloud.channel.v1.RegisterSubscriberResponse
	74,  // 143: google.cloud.channel.v1.CloudChannelService.UnregisterSubscriber:output_type -> google.cloud.channel.v1.UnregisterSubscriberResponse
	76,  // 144: google.cloud.channel.v1.CloudChannelService.ListSubscribers:output_type -> google.cloud.channel.v1.ListSubscribersResponse
	78,  // 145: google.cloud.channel.v1.CloudChannelService.ListEntitlementChanges:output_type -> google.cloud.channel.v1.ListEntitlementChangesResponse
	97,  // [97:146] is the sub-list for method output_type
	48,  // [48:97] is the sub-list for method input_type
	48,  // [48:48] is the sub-list for extension type_name
	48,  // [48:48] is the sub-list for extension extendee
	0,   // [0:48] is the sub-list for field type_name
}

func init() { file_google_cloud_channel_v1_service_proto_init() }
func file_google_cloud_channel_v1_service_proto_init() {
	if File_google_cloud_channel_v1_service_proto != nil {
		return
	}
	file_google_cloud_channel_v1_billing_accounts_proto_init()
	file_google_cloud_channel_v1_channel_partner_links_proto_init()
	file_google_cloud_channel_v1_common_proto_init()
	file_google_cloud_channel_v1_customers_proto_init()
	file_google_cloud_channel_v1_entitlement_changes_proto_init()
	file_google_cloud_channel_v1_entitlements_proto_init()
	file_google_cloud_channel_v1_offers_proto_init()
	file_google_cloud_channel_v1_operations_proto_init()
	file_google_cloud_channel_v1_products_proto_init()
	file_google_cloud_channel_v1_repricing_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_channel_v1_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckCloudIdentityAccountsExistRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudIdentityCustomerAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckCloudIdentityAccountsExistResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCustomerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportCustomerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionCloudIdentityRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntitlementsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntitlementsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTransferableSkusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTransferableSkusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTransferableOffersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTransferableOffersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferableOffer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntitlementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListChannelPartnerLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListChannelPartnerLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetChannelPartnerLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateChannelPartnerLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateChannelPartnerLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomerRepricingConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomerRepricingConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomerRepricingConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomerRepricingConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomerRepricingConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCustomerRepricingConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetChannelPartnerRepricingConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListChannelPartnerRepricingConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListChannelPartnerRepricingConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateChannelPartnerRepricingConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateChannelPartnerRepricingConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteChannelPartnerRepricingConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSkuGroupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSkuGroupBillableSkusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSkuGroupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSkuGroupBillableSkusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SkuGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BillableSku); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEntitlementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferEntitlementsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferEntitlementsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferEntitlementsToGoogleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeParametersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeRenewalSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeOfferRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartPaidServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelEntitlementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuspendEntitlementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActivateEntitlementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LookupOfferRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProductsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProductsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSkusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSkusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOffersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOffersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableSkusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableSkusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PurchasableSku); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableOffersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableOffersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PurchasableOffer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryEligibleBillingAccountsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryEligibleBillingAccountsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SkuPurchaseGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BillingAccountPurchaseInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterSubscriberRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterSubscriberResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnregisterSubscriberRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnregisterSubscriberResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubscribersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubscribersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntitlementChangesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntitlementChangesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableSkusRequest_CreateEntitlementPurchase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableSkusRequest_ChangeOfferPurchase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableOffersRequest_CreateEntitlementPurchase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableOffersRequest_ChangeOfferPurchase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_channel_v1_service_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*ImportCustomerRequest_Domain)(nil),
		(*ImportCustomerRequest_CloudIdentityId)(nil),
	}
	file_google_cloud_channel_v1_service_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*ListTransferableSkusRequest_CloudIdentityId)(nil),
		(*ListTransferableSkusRequest_CustomerName)(nil),
	}
	file_google_cloud_channel_v1_service_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*ListTransferableOffersRequest_CloudIdentityId)(nil),
		(*ListTransferableOffersRequest_CustomerName)(nil),
	}
	file_google_cloud_channel_v1_service_proto_msgTypes[60].OneofWrappers = []interface{}{
		(*ListPurchasableSkusRequest_CreateEntitlementPurchase_)(nil),
		(*ListPurchasableSkusRequest_ChangeOfferPurchase_)(nil),
	}
	file_google_cloud_channel_v1_service_proto_msgTypes[63].OneofWrappers = []interface{}{
		(*ListPurchasableOffersRequest_CreateEntitlementPurchase_)(nil),
		(*ListPurchasableOffersRequest_ChangeOfferPurchase_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_channel_v1_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   82,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_channel_v1_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_channel_v1_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_channel_v1_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_channel_v1_service_proto_msgTypes,
	}.Build()
	File_google_cloud_channel_v1_service_proto = out.File
	file_google_cloud_channel_v1_service_proto_rawDesc = nil
	file_google_cloud_channel_v1_service_proto_goTypes = nil
	file_google_cloud_channel_v1_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudChannelServiceClient is the client API for CloudChannelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudChannelServiceClient interface {
	// List [Customer][google.cloud.channel.v1.Customer]s.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// List of [Customer][google.cloud.channel.v1.Customer]s, or an empty list if
	// there are no customers.
	ListCustomers(ctx context.Context, in *ListCustomersRequest, opts ...grpc.CallOption) (*ListCustomersResponse, error)
	// Returns the requested [Customer][google.cloud.channel.v1.Customer]
	// resource.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer resource doesn't exist. Usually the result of an
	// invalid name parameter.
	//
	// Return value:
	// The [Customer][google.cloud.channel.v1.Customer] resource.
	GetCustomer(ctx context.Context, in *GetCustomerRequest, opts ...grpc.CallOption) (*Customer, error)
	// Confirms the existence of Cloud Identity accounts based on the domain and
	// if the Cloud Identity accounts are owned by the reseller.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * INVALID_VALUE: Invalid domain value in the request.
	//
	// Return value:
	// A list of
	// [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
	// resources for the domain (may be empty)
	//
	// Note: in the v1alpha1 version of the API, a NOT_FOUND error returns if
	// no
	// [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
	// resources match the domain.
	CheckCloudIdentityAccountsExist(ctx context.Context, in *CheckCloudIdentityAccountsExistRequest, opts ...grpc.CallOption) (*CheckCloudIdentityAccountsExistResponse, error)
	// Creates a new [Customer][google.cloud.channel.v1.Customer] resource under
	// the reseller or distributor account.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The reseller account making the request is different from the
	//     reseller account in the API request.
	//   - You are not authorized to create a customer. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT:
	//   - Required request parameters are missing or invalid.
	//   - Domain field value doesn't match the primary email domain.
	//
	// Return value:
	// The newly created [Customer][google.cloud.channel.v1.Customer] resource.
	CreateCustomer(ctx context.Context, in *CreateCustomerRequest, opts ...grpc.CallOption) (*Customer, error)
	// Updates an existing [Customer][google.cloud.channel.v1.Customer] resource
	// for the reseller or distributor.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
	// for the name in the request.
	//
	// Return value:
	// The updated [Customer][google.cloud.channel.v1.Customer] resource.
	UpdateCustomer(ctx context.Context, in *UpdateCustomerRequest, opts ...grpc.CallOption) (*Customer, error)
	// Deletes the given [Customer][google.cloud.channel.v1.Customer] permanently.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * FAILED_PRECONDITION: The customer has existing entitlements.
	// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
	// for the name in the request.
	DeleteCustomer(ctx context.Context, in *DeleteCustomerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Imports a [Customer][google.cloud.channel.v1.Customer] from the Cloud
	// Identity associated with the provided Cloud Identity ID or domain before a
	// TransferEntitlements call. If a linked Customer already exists and
	// overwrite_if_exists is true, it will update that Customer's data.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The reseller account making the request is different from the
	//     reseller account in the API request.
	//   - You are not authorized to import the customer. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * NOT_FOUND: Cloud Identity doesn't exist or was deleted.
	// * INVALID_ARGUMENT: Required parameters are missing, or the auth_token is
	// expired or invalid.
	// * ALREADY_EXISTS: A customer already exists and has conflicting critical
	// fields. Requires an overwrite.
	//
	// Return value:
	// The [Customer][google.cloud.channel.v1.Customer].
	ImportCustomer(ctx context.Context, in *ImportCustomerRequest, opts ...grpc.CallOption) (*Customer, error)
	// Creates a Cloud Identity for the given customer using the customer's
	// information, or the information provided here.
	//
	// Possible error codes:
	//
	// *  PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller.
	//   - You are not authorized to provision cloud identity id. See
	//     https://support.google.com/channelservices/answer/9759265
	//   - INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//   - NOT_FOUND: The customer was not found.
	//   - ALREADY_EXISTS: The customer's primary email already exists. Retry
	//     after changing the customer's primary contact email.
	//   - INTERNAL: Any non-user error related to a technical issue in the
	//
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata contains an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ProvisionCloudIdentity(ctx context.Context, in *ProvisionCloudIdentityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to a
	// customer.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// A list of the customer's
	// [Entitlement][google.cloud.channel.v1.Entitlement]s.
	ListEntitlements(ctx context.Context, in *ListEntitlementsRequest, opts ...grpc.CallOption) (*ListEntitlementsResponse, error)
	// List [TransferableSku][google.cloud.channel.v1.TransferableSku]s of a
	// customer based on the Cloud Identity ID or Customer Name in the request.
	//
	// Use this method to list the entitlements information of an
	// unowned customer. You should provide the customer's
	// Cloud Identity ID or Customer Name.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller and has no auth token.
	//   - The supplied auth token is invalid.
	//   - The reseller account making the request is different
	//     from the reseller account in the query.
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// A list of the customer's
	// [TransferableSku][google.cloud.channel.v1.TransferableSku].
	ListTransferableSkus(ctx context.Context, in *ListTransferableSkusRequest, opts ...grpc.CallOption) (*ListTransferableSkusResponse, error)
	// List [TransferableOffer][google.cloud.channel.v1.TransferableOffer]s of a
	// customer based on Cloud Identity ID or Customer Name in the request.
	//
	// Use this method when a reseller gets the entitlement information of an
	// unowned customer. The reseller should provide the customer's
	// Cloud Identity ID or Customer Name.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller and has no auth token.
	//   - The customer provided incorrect reseller information when generating
	//     auth token.
	//   - The reseller account making the request is different
	//     from the reseller account in the query.
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// List of [TransferableOffer][google.cloud.channel.v1.TransferableOffer] for
	// the given customer and SKU.
	ListTransferableOffers(ctx context.Context, in *ListTransferableOffersRequest, opts ...grpc.CallOption) (*ListTransferableOffersResponse, error)
	// Returns the requested [Entitlement][google.cloud.channel.v1.Entitlement]
	// resource.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer entitlement was not found.
	//
	// Return value:
	// The requested [Entitlement][google.cloud.channel.v1.Entitlement] resource.
	GetEntitlement(ctx context.Context, in *GetEntitlementRequest, opts ...grpc.CallOption) (*Entitlement, error)
	// Creates an entitlement for a customer.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller.
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT:
	//   - Required request parameters are missing or invalid.
	//   - There is already a customer entitlement for a SKU from the same
	//     product family.
	//
	// * INVALID_VALUE: Make sure the OfferId is valid. If it is, contact
	// Google Channel support for further troubleshooting.
	// * NOT_FOUND: The customer or offer resource was not found.
	// * ALREADY_EXISTS:
	//   - The SKU was already purchased for the customer.
	//   - The customer's primary email already exists. Retry
	//     after changing the customer's primary contact email.
	//
	// * CONDITION_NOT_MET or FAILED_PRECONDITION:
	//   - The domain required for purchasing a SKU has not been verified.
	//   - A pre-requisite SKU required to purchase an Add-On SKU is missing.
	//     For example, Google Workspace Business Starter is required to purchase
	//     Vault or Drive.
	//   - (Developer accounts only) Reseller and resold domain must meet the
	//     following naming requirements:
	//   - Domain names must start with goog-test.
	//   - Domain names must include the reseller domain.
	//
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	CreateEntitlement(ctx context.Context, in *CreateEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Change parameters of the entitlement.
	//
	// An entitlement update is a long-running operation and it updates the
	// entitlement as a result of fulfillment.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// For example, the number of seats being changed is greater than the allowed
	// number of max seats, or decreasing seats for a commitment based plan.
	// * NOT_FOUND: Entitlement resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeParameters(ctx context.Context, in *ChangeParametersRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the renewal settings for an existing customer entitlement.
	//
	// An entitlement update is a long-running operation and it updates the
	// entitlement as a result of fulfillment.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
	// commitment plan. Can't enable or disable renewals for non-commitment plans.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	//   - UNKNOWN: Any non-user error related to a technical issue in the backend.
	//     Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeRenewalSettings(ctx context.Context, in *ChangeRenewalSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the Offer for an existing customer entitlement.
	//
	// An entitlement update is a long-running operation and it updates the
	// entitlement as a result of fulfillment.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Offer or Entitlement resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeOffer(ctx context.Context, in *ChangeOfferRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts paid service for a trial entitlement.
	//
	// Starts paid service for a trial entitlement immediately. This method is
	// only applicable if a plan is set up for a trial entitlement but has some
	// trial days remaining.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
	// entitlement on trial plans.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	StartPaidService(ctx context.Context, in *StartPaidServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Suspends a previously fulfilled entitlement.
	//
	// An entitlement suspension is a long-running operation.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * NOT_ACTIVE: Entitlement is not active.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	SuspendEntitlement(ctx context.Context, in *SuspendEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels a previously fulfilled entitlement.
	//
	// An entitlement cancellation is a long-running operation.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * FAILED_PRECONDITION: There are Google Cloud projects linked to the
	// Google Cloud entitlement's Cloud Billing subaccount.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
	// add-ons, or entitlements for Google Cloud's development platform.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The response will contain
	// google.protobuf.Empty on success. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	CancelEntitlement(ctx context.Context, in *CancelEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Activates a previously suspended entitlement. Entitlements suspended for
	// pending ToS acceptance can't be activated using this method.
	//
	// An entitlement activation is a long-running operation and it updates
	// the state of the customer entitlement.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * SUSPENSION_NOT_RESELLER_INITIATED: Can only activate reseller-initiated
	// suspensions and entitlements that have accepted the TOS.
	// * NOT_SUSPENDED: Can only activate suspended entitlements not in an ACTIVE
	// state.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ActivateEntitlement(ctx context.Context, in *ActivateEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Transfers customer entitlements to new reseller.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller.
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer or offer resource was not found.
	// * ALREADY_EXISTS: The SKU was already transferred for the customer.
	// * CONDITION_NOT_MET or FAILED_PRECONDITION:
	//   - The SKU requires domain verification to transfer, but the domain is
	//     not verified.
	//   - An Add-On SKU (example, Vault or Drive) is missing the
	//     pre-requisite SKU (example, G Suite Basic).
	//   - (Developer accounts only) Reseller and resold domain must meet the
	//     following naming requirements:
	//   - Domain names must start with goog-test.
	//   - Domain names must include the reseller domain.
	//   - Specify all transferring entitlements.
	//
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	TransferEntitlements(ctx context.Context, in *TransferEntitlementsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Transfers customer entitlements from their current reseller to Google.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer or offer resource was not found.
	// * ALREADY_EXISTS: The SKU was already transferred for the customer.
	// * CONDITION_NOT_MET or FAILED_PRECONDITION:
	//   - The SKU requires domain verification to transfer, but the domain is
	//     not verified.
	//   - An Add-On SKU (example, Vault or Drive) is missing the
	//     pre-requisite SKU (example, G Suite Basic).
	//   - (Developer accounts only) Reseller and resold domain must meet the
	//     following naming requirements:
	//   - Domain names must start with goog-test.
	//   - Domain names must include the reseller domain.
	//
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The response will contain
	// google.protobuf.Empty on success. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	TransferEntitlementsToGoogle(ctx context.Context, in *TransferEntitlementsToGoogleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s
	// belonging to a distributor. You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// The list of the distributor account's
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resources.
	ListChannelPartnerLinks(ctx context.Context, in *ListChannelPartnerLinksRequest, opts ...grpc.CallOption) (*ListChannelPartnerLinksResponse, error)
	// Returns the requested
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
	// You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: ChannelPartnerLink resource not found because of an
	// invalid channel partner link name.
	//
	// Return value:
	// The [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
	// resource.
	GetChannelPartnerLink(ctx context.Context, in *GetChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error)
	// Initiates a channel partner link between a distributor and a reseller, or
	// between resellers in an n-tier reseller channel.
	// Invited partners need to follow the invite_link_uri provided in the
	// response to accept. After accepting the invitation, a link is set up
	// between the two parties.
	// You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * ALREADY_EXISTS: The ChannelPartnerLink sent in the request already
	// exists.
	// * NOT_FOUND: No Cloud Identity customer exists for provided domain.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The new [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
	// resource.
	CreateChannelPartnerLink(ctx context.Context, in *CreateChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error)
	// Updates a channel partner link. Distributors call this method to change a
	// link's status. For example, to suspend a partner link.
	// You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT:
	//   - Required request parameters are missing or invalid.
	//   - Link state cannot change from invited to active or suspended.
	//   - Cannot send reseller_cloud_identity_id, invite_url, or name in update
	//     mask.
	//
	// * NOT_FOUND: ChannelPartnerLink resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The updated
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
	UpdateChannelPartnerLink(ctx context.Context, in *UpdateChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error)
	// Gets information about how a Reseller modifies their bill before sending
	// it to a Customer.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// was not found.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resource, otherwise returns an error.
	GetCustomerRepricingConfig(ctx context.Context, in *GetCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*CustomerRepricingConfig, error)
	// Lists information about how a Reseller modifies their bill before sending
	// it to a Customer.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resources. The data for each resource is displayed in the ascending order
	// of:
	//
	// * Customer ID
	// * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]
	// * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// * [CustomerRepricingConfig.update_time][google.cloud.channel.v1.CustomerRepricingConfig.update_time]
	//
	// If unsuccessful, returns an error.
	ListCustomerRepricingConfigs(ctx context.Context, in *ListCustomerRepricingConfigsRequest, opts ...grpc.CallOption) (*ListCustomerRepricingConfigsResponse, error)
	// Creates a CustomerRepricingConfig. Call this method to set modifications
	// for a specific customer's bill. You can only create configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. If needed, you can create a config for the current
	// month, with some restrictions.
	//
	// When creating a config for a future month, make sure there are no existing
	// configs for that
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// The following restrictions are for creating configs in the current month.
	//
	// * This functionality is reserved for recovering from an erroneous config,
	// and should not be used for regular business cases.
	// * The new config will not modify exports used with other configs.
	// Changes to the config may be immediate, but may take up to 24 hours.
	// * There is a limit of ten configs for any
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
	// for any
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	// * The contained
	// [CustomerRepricingConfig.repricing_config][google.cloud.channel.v1.CustomerRepricingConfig.repricing_config]
	// value must be different from the value used in the current config for a
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resource, otherwise returns an error.
	CreateCustomerRepricingConfig(ctx context.Context, in *CreateCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*CustomerRepricingConfig, error)
	// Updates a CustomerRepricingConfig. Call this method to set modifications
	// for a specific customer's bill. This method overwrites the existing
	// CustomerRepricingConfig.
	//
	// You can only update configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. To make changes to configs for the current month, use
	// [CreateCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig],
	// taking note of its restrictions. You cannot update the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// When updating a config in the future:
	//
	// * This config must already exist.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resource, otherwise returns an error.
	UpdateCustomerRepricingConfig(ctx context.Context, in *UpdateCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*CustomerRepricingConfig, error)
	// Deletes the given
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// permanently. You can only delete configs if their
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is set to a date after the current month.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * FAILED_PRECONDITION: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// is active or in the past.
	// * NOT_FOUND: No
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// found for the name in the request.
	DeleteCustomerRepricingConfig(ctx context.Context, in *DeleteCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets information about how a Distributor modifies their bill before sending
	// it to a ChannelPartner.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// was not found.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resource, otherwise returns an error.
	GetChannelPartnerRepricingConfig(ctx context.Context, in *GetChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*ChannelPartnerRepricingConfig, error)
	// Lists information about how a Reseller modifies their bill before sending
	// it to a ChannelPartner.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resources. The data for each resource is displayed in the ascending order
	// of:
	//
	// * Channel Partner ID
	// * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// * [ChannelPartnerRepricingConfig.update_time][google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time]
	//
	// If unsuccessful, returns an error.
	ListChannelPartnerRepricingConfigs(ctx context.Context, in *ListChannelPartnerRepricingConfigsRequest, opts ...grpc.CallOption) (*ListChannelPartnerRepricingConfigsResponse, error)
	// Creates a ChannelPartnerRepricingConfig. Call this method to set
	// modifications for a specific ChannelPartner's bill. You can only create
	// configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. If needed, you can create a config for the current
	// month, with some restrictions.
	//
	// When creating a config for a future month, make sure there are no existing
	// configs for that
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// The following restrictions are for creating configs in the current month.
	//
	// * This functionality is reserved for recovering from an erroneous config,
	// and should not be used for regular business cases.
	// * The new config will not modify exports used with other configs.
	// Changes to the config may be immediate, but may take up to 24 hours.
	// * There is a limit of ten configs for any ChannelPartner or
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
	// for any
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	// * The contained
	// [ChannelPartnerRepricingConfig.repricing_config][google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config]
	// value must be different from the value used in the current config for a
	// ChannelPartner.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resource, otherwise returns an error.
	CreateChannelPartnerRepricingConfig(ctx context.Context, in *CreateChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*ChannelPartnerRepricingConfig, error)
	// Updates a ChannelPartnerRepricingConfig. Call this method to set
	// modifications for a specific ChannelPartner's bill. This method overwrites
	// the existing CustomerRepricingConfig.
	//
	// You can only update configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. To make changes to configs for the current month, use
	// [CreateChannelPartnerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig],
	// taking note of its restrictions. You cannot update the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// When updating a config in the future:
	//
	// * This config must already exist.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resource, otherwise returns an error.
	UpdateChannelPartnerRepricingConfig(ctx context.Context, in *UpdateChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*ChannelPartnerRepricingConfig, error)
	// Deletes the given
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// permanently. You can only delete configs if their
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is set to a date after the current month.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * FAILED_PRECONDITION: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// is active or in the past.
	// * NOT_FOUND: No
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// found for the name in the request.
	DeleteChannelPartnerRepricingConfig(ctx context.Context, in *DeleteChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists the Rebilling supported SKU groups the account is authorized to
	// sell.
	// Reference: https://cloud.google.com/skus/sku-groups
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different, or the account doesn't exist.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the [SkuGroup][google.cloud.channel.v1.SkuGroup] resources.
	// The data for each resource is displayed in the alphabetical order of SKU
	// group display name.
	// The data for each resource is displayed in the ascending order of
	// [SkuGroup.display_name][google.cloud.channel.v1.SkuGroup.display_name]
	//
	// If unsuccessful, returns an error.
	ListSkuGroups(ctx context.Context, in *ListSkuGroupsRequest, opts ...grpc.CallOption) (*ListSkuGroupsResponse, error)
	// Lists the Billable SKUs in a given SKU group.
	//
	// Possible error codes:
	// PERMISSION_DENIED: If the account making the request and the account
	// being queried for are different, or the account doesn't exist.
	// INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// INTERNAL: Any non-user error related to technical issue in the
	// backend. In this case, contact cloud channel support.
	//
	// Return Value:
	// If successful, the [BillableSku][google.cloud.channel.v1.BillableSku]
	// resources. The data for each resource is displayed in the ascending order
	// of:
	//
	// * [BillableSku.service_display_name][google.cloud.channel.v1.BillableSku.service_display_name]
	// * [BillableSku.sku_display_name][google.cloud.channel.v1.BillableSku.sku_display_name]
	//
	// If unsuccessful, returns an error.
	ListSkuGroupBillableSkus(ctx context.Context, in *ListSkuGroupBillableSkusRequest, opts ...grpc.CallOption) (*ListSkuGroupBillableSkusResponse, error)
	// Returns the requested [Offer][google.cloud.channel.v1.Offer] resource.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The entitlement doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement or offer was not found.
	//
	// Return value:
	// The [Offer][google.cloud.channel.v1.Offer] resource.
	LookupOffer(ctx context.Context, in *LookupOfferRequest, opts ...grpc.CallOption) (*Offer, error)
	// Lists the Products the reseller is authorized to sell.
	//
	// Possible error codes:
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error)
	// Lists the SKUs for a product the reseller is authorized to sell.
	//
	// Possible error codes:
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListSkus(ctx context.Context, in *ListSkusRequest, opts ...grpc.CallOption) (*ListSkusResponse, error)
	// Lists the Offers the reseller can sell.
	//
	// Possible error codes:
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListOffers(ctx context.Context, in *ListOffersRequest, opts ...grpc.CallOption) (*ListOffersResponse, error)
	// Lists the following:
	//
	// * SKUs that you can purchase for a customer
	// * SKUs that you can upgrade or downgrade for an entitlement.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListPurchasableSkus(ctx context.Context, in *ListPurchasableSkusRequest, opts ...grpc.CallOption) (*ListPurchasableSkusResponse, error)
	// Lists the following:
	//
	// * Offers that you can purchase for a customer.
	// * Offers that you can change for an entitlement.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListPurchasableOffers(ctx context.Context, in *ListPurchasableOffersRequest, opts ...grpc.CallOption) (*ListPurchasableOffersResponse, error)
	// Lists the billing accounts that are eligible to purchase particular SKUs
	// for a given customer.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// Based on the provided list of SKUs, returns a list of SKU groups that must
	// be purchased using the same billing account and the billing accounts
	// eligible to purchase each SKU group.
	QueryEligibleBillingAccounts(ctx context.Context, in *QueryEligibleBillingAccountsRequest, opts ...grpc.CallOption) (*QueryEligibleBillingAccountsResponse, error)
	// Registers a service account with subscriber privileges on the Cloud Pub/Sub
	// topic for this Channel Services account. After you create a
	// subscriber, you get the events through
	// [SubscriberEvent][google.cloud.channel.v1.SubscriberEvent]
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different, or the impersonated user
	// is not a super admin.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The topic name with the registered service email address.
	RegisterSubscriber(ctx context.Context, in *RegisterSubscriberRequest, opts ...grpc.CallOption) (*RegisterSubscriberResponse, error)
	// Unregisters a service account with subscriber privileges on the Cloud
	// Pub/Sub topic created for this Channel Services account. If there are no
	// service accounts left with subscriber privileges, this deletes the topic.
	// You can call ListSubscribers to check for these accounts.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different, or the impersonated user
	// is not a super admin.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The topic resource doesn't exist.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The topic name that unregistered the service email address.
	// Returns a success response if the service email address wasn't registered
	// with the topic.
	UnregisterSubscriber(ctx context.Context, in *UnregisterSubscriberRequest, opts ...grpc.CallOption) (*UnregisterSubscriberResponse, error)
	// Lists service accounts with subscriber privileges on the Cloud Pub/Sub
	// topic created for this Channel Services account.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different, or the impersonated user
	// is not a super admin.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The topic resource doesn't exist.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// A list of service email addresses.
	ListSubscribers(ctx context.Context, in *ListSubscribersRequest, opts ...grpc.CallOption) (*ListSubscribersResponse, error)
	// List entitlement history.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different.
	// * INVALID_ARGUMENT: Missing or invalid required fields in the request.
	// * NOT_FOUND: The parent resource doesn't exist. Usually the result of an
	// invalid name parameter.
	// * INTERNAL: Any non-user error related to a technical issue in the backend.
	// In this case, contact CloudChannel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return value:
	// List of [EntitlementChange][google.cloud.channel.v1.EntitlementChange]s.
	ListEntitlementChanges(ctx context.Context, in *ListEntitlementChangesRequest, opts ...grpc.CallOption) (*ListEntitlementChangesResponse, error)
}

type cloudChannelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudChannelServiceClient(cc grpc.ClientConnInterface) CloudChannelServiceClient {
	return &cloudChannelServiceClient{cc}
}

func (c *cloudChannelServiceClient) ListCustomers(ctx context.Context, in *ListCustomersRequest, opts ...grpc.CallOption) (*ListCustomersResponse, error) {
	out := new(ListCustomersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListCustomers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetCustomer(ctx context.Context, in *GetCustomerRequest, opts ...grpc.CallOption) (*Customer, error) {
	out := new(Customer)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/GetCustomer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CheckCloudIdentityAccountsExist(ctx context.Context, in *CheckCloudIdentityAccountsExistRequest, opts ...grpc.CallOption) (*CheckCloudIdentityAccountsExistResponse, error) {
	out := new(CheckCloudIdentityAccountsExistResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/CheckCloudIdentityAccountsExist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateCustomer(ctx context.Context, in *CreateCustomerRequest, opts ...grpc.CallOption) (*Customer, error) {
	out := new(Customer)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/CreateCustomer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) UpdateCustomer(ctx context.Context, in *UpdateCustomerRequest, opts ...grpc.CallOption) (*Customer, error) {
	out := new(Customer)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/UpdateCustomer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) DeleteCustomer(ctx context.Context, in *DeleteCustomerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/DeleteCustomer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ImportCustomer(ctx context.Context, in *ImportCustomerRequest, opts ...grpc.CallOption) (*Customer, error) {
	out := new(Customer)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ImportCustomer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ProvisionCloudIdentity(ctx context.Context, in *ProvisionCloudIdentityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ProvisionCloudIdentity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListEntitlements(ctx context.Context, in *ListEntitlementsRequest, opts ...grpc.CallOption) (*ListEntitlementsResponse, error) {
	out := new(ListEntitlementsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListEntitlements", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListTransferableSkus(ctx context.Context, in *ListTransferableSkusRequest, opts ...grpc.CallOption) (*ListTransferableSkusResponse, error) {
	out := new(ListTransferableSkusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListTransferableSkus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListTransferableOffers(ctx context.Context, in *ListTransferableOffersRequest, opts ...grpc.CallOption) (*ListTransferableOffersResponse, error) {
	out := new(ListTransferableOffersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListTransferableOffers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetEntitlement(ctx context.Context, in *GetEntitlementRequest, opts ...grpc.CallOption) (*Entitlement, error) {
	out := new(Entitlement)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/GetEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateEntitlement(ctx context.Context, in *CreateEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/CreateEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ChangeParameters(ctx context.Context, in *ChangeParametersRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ChangeParameters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ChangeRenewalSettings(ctx context.Context, in *ChangeRenewalSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ChangeRenewalSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ChangeOffer(ctx context.Context, in *ChangeOfferRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ChangeOffer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) StartPaidService(ctx context.Context, in *StartPaidServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/StartPaidService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) SuspendEntitlement(ctx context.Context, in *SuspendEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/SuspendEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CancelEntitlement(ctx context.Context, in *CancelEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/CancelEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ActivateEntitlement(ctx context.Context, in *ActivateEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ActivateEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) TransferEntitlements(ctx context.Context, in *TransferEntitlementsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/TransferEntitlements", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) TransferEntitlementsToGoogle(ctx context.Context, in *TransferEntitlementsToGoogleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/TransferEntitlementsToGoogle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListChannelPartnerLinks(ctx context.Context, in *ListChannelPartnerLinksRequest, opts ...grpc.CallOption) (*ListChannelPartnerLinksResponse, error) {
	out := new(ListChannelPartnerLinksResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListChannelPartnerLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetChannelPartnerLink(ctx context.Context, in *GetChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error) {
	out := new(ChannelPartnerLink)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/GetChannelPartnerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateChannelPartnerLink(ctx context.Context, in *CreateChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error) {
	out := new(ChannelPartnerLink)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/CreateChannelPartnerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) UpdateChannelPartnerLink(ctx context.Context, in *UpdateChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error) {
	out := new(ChannelPartnerLink)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/UpdateChannelPartnerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetCustomerRepricingConfig(ctx context.Context, in *GetCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*CustomerRepricingConfig, error) {
	out := new(CustomerRepricingConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/GetCustomerRepricingConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListCustomerRepricingConfigs(ctx context.Context, in *ListCustomerRepricingConfigsRequest, opts ...grpc.CallOption) (*ListCustomerRepricingConfigsResponse, error) {
	out := new(ListCustomerRepricingConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListCustomerRepricingConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateCustomerRepricingConfig(ctx context.Context, in *CreateCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*CustomerRepricingConfig, error) {
	out := new(CustomerRepricingConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/CreateCustomerRepricingConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) UpdateCustomerRepricingConfig(ctx context.Context, in *UpdateCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*CustomerRepricingConfig, error) {
	out := new(CustomerRepricingConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/UpdateCustomerRepricingConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) DeleteCustomerRepricingConfig(ctx context.Context, in *DeleteCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/DeleteCustomerRepricingConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetChannelPartnerRepricingConfig(ctx context.Context, in *GetChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*ChannelPartnerRepricingConfig, error) {
	out := new(ChannelPartnerRepricingConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/GetChannelPartnerRepricingConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListChannelPartnerRepricingConfigs(ctx context.Context, in *ListChannelPartnerRepricingConfigsRequest, opts ...grpc.CallOption) (*ListChannelPartnerRepricingConfigsResponse, error) {
	out := new(ListChannelPartnerRepricingConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListChannelPartnerRepricingConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateChannelPartnerRepricingConfig(ctx context.Context, in *CreateChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*ChannelPartnerRepricingConfig, error) {
	out := new(ChannelPartnerRepricingConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/CreateChannelPartnerRepricingConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) UpdateChannelPartnerRepricingConfig(ctx context.Context, in *UpdateChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*ChannelPartnerRepricingConfig, error) {
	out := new(ChannelPartnerRepricingConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/UpdateChannelPartnerRepricingConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) DeleteChannelPartnerRepricingConfig(ctx context.Context, in *DeleteChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/DeleteChannelPartnerRepricingConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListSkuGroups(ctx context.Context, in *ListSkuGroupsRequest, opts ...grpc.CallOption) (*ListSkuGroupsResponse, error) {
	out := new(ListSkuGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListSkuGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListSkuGroupBillableSkus(ctx context.Context, in *ListSkuGroupBillableSkusRequest, opts ...grpc.CallOption) (*ListSkuGroupBillableSkusResponse, error) {
	out := new(ListSkuGroupBillableSkusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListSkuGroupBillableSkus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) LookupOffer(ctx context.Context, in *LookupOfferRequest, opts ...grpc.CallOption) (*Offer, error) {
	out := new(Offer)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/LookupOffer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error) {
	out := new(ListProductsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListSkus(ctx context.Context, in *ListSkusRequest, opts ...grpc.CallOption) (*ListSkusResponse, error) {
	out := new(ListSkusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListSkus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListOffers(ctx context.Context, in *ListOffersRequest, opts ...grpc.CallOption) (*ListOffersResponse, error) {
	out := new(ListOffersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListOffers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListPurchasableSkus(ctx context.Context, in *ListPurchasableSkusRequest, opts ...grpc.CallOption) (*ListPurchasableSkusResponse, error) {
	out := new(ListPurchasableSkusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListPurchasableSkus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListPurchasableOffers(ctx context.Context, in *ListPurchasableOffersRequest, opts ...grpc.CallOption) (*ListPurchasableOffersResponse, error) {
	out := new(ListPurchasableOffersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListPurchasableOffers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) QueryEligibleBillingAccounts(ctx context.Context, in *QueryEligibleBillingAccountsRequest, opts ...grpc.CallOption) (*QueryEligibleBillingAccountsResponse, error) {
	out := new(QueryEligibleBillingAccountsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/QueryEligibleBillingAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) RegisterSubscriber(ctx context.Context, in *RegisterSubscriberRequest, opts ...grpc.CallOption) (*RegisterSubscriberResponse, error) {
	out := new(RegisterSubscriberResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/RegisterSubscriber", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) UnregisterSubscriber(ctx context.Context, in *UnregisterSubscriberRequest, opts ...grpc.CallOption) (*UnregisterSubscriberResponse, error) {
	out := new(UnregisterSubscriberResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/UnregisterSubscriber", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListSubscribers(ctx context.Context, in *ListSubscribersRequest, opts ...grpc.CallOption) (*ListSubscribersResponse, error) {
	out := new(ListSubscribersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListSubscribers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListEntitlementChanges(ctx context.Context, in *ListEntitlementChangesRequest, opts ...grpc.CallOption) (*ListEntitlementChangesResponse, error) {
	out := new(ListEntitlementChangesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListEntitlementChanges", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudChannelServiceServer is the server API for CloudChannelService service.
type CloudChannelServiceServer interface {
	// List [Customer][google.cloud.channel.v1.Customer]s.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// List of [Customer][google.cloud.channel.v1.Customer]s, or an empty list if
	// there are no customers.
	ListCustomers(context.Context, *ListCustomersRequest) (*ListCustomersResponse, error)
	// Returns the requested [Customer][google.cloud.channel.v1.Customer]
	// resource.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer resource doesn't exist. Usually the result of an
	// invalid name parameter.
	//
	// Return value:
	// The [Customer][google.cloud.channel.v1.Customer] resource.
	GetCustomer(context.Context, *GetCustomerRequest) (*Customer, error)
	// Confirms the existence of Cloud Identity accounts based on the domain and
	// if the Cloud Identity accounts are owned by the reseller.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * INVALID_VALUE: Invalid domain value in the request.
	//
	// Return value:
	// A list of
	// [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
	// resources for the domain (may be empty)
	//
	// Note: in the v1alpha1 version of the API, a NOT_FOUND error returns if
	// no
	// [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
	// resources match the domain.
	CheckCloudIdentityAccountsExist(context.Context, *CheckCloudIdentityAccountsExistRequest) (*CheckCloudIdentityAccountsExistResponse, error)
	// Creates a new [Customer][google.cloud.channel.v1.Customer] resource under
	// the reseller or distributor account.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The reseller account making the request is different from the
	//     reseller account in the API request.
	//   - You are not authorized to create a customer. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT:
	//   - Required request parameters are missing or invalid.
	//   - Domain field value doesn't match the primary email domain.
	//
	// Return value:
	// The newly created [Customer][google.cloud.channel.v1.Customer] resource.
	CreateCustomer(context.Context, *CreateCustomerRequest) (*Customer, error)
	// Updates an existing [Customer][google.cloud.channel.v1.Customer] resource
	// for the reseller or distributor.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
	// for the name in the request.
	//
	// Return value:
	// The updated [Customer][google.cloud.channel.v1.Customer] resource.
	UpdateCustomer(context.Context, *UpdateCustomerRequest) (*Customer, error)
	// Deletes the given [Customer][google.cloud.channel.v1.Customer] permanently.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * FAILED_PRECONDITION: The customer has existing entitlements.
	// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
	// for the name in the request.
	DeleteCustomer(context.Context, *DeleteCustomerRequest) (*emptypb.Empty, error)
	// Imports a [Customer][google.cloud.channel.v1.Customer] from the Cloud
	// Identity associated with the provided Cloud Identity ID or domain before a
	// TransferEntitlements call. If a linked Customer already exists and
	// overwrite_if_exists is true, it will update that Customer's data.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The reseller account making the request is different from the
	//     reseller account in the API request.
	//   - You are not authorized to import the customer. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * NOT_FOUND: Cloud Identity doesn't exist or was deleted.
	// * INVALID_ARGUMENT: Required parameters are missing, or the auth_token is
	// expired or invalid.
	// * ALREADY_EXISTS: A customer already exists and has conflicting critical
	// fields. Requires an overwrite.
	//
	// Return value:
	// The [Customer][google.cloud.channel.v1.Customer].
	ImportCustomer(context.Context, *ImportCustomerRequest) (*Customer, error)
	// Creates a Cloud Identity for the given customer using the customer's
	// information, or the information provided here.
	//
	// Possible error codes:
	//
	// *  PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller.
	//   - You are not authorized to provision cloud identity id. See
	//     https://support.google.com/channelservices/answer/9759265
	//   - INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//   - NOT_FOUND: The customer was not found.
	//   - ALREADY_EXISTS: The customer's primary email already exists. Retry
	//     after changing the customer's primary contact email.
	//   - INTERNAL: Any non-user error related to a technical issue in the
	//
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata contains an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ProvisionCloudIdentity(context.Context, *ProvisionCloudIdentityRequest) (*longrunningpb.Operation, error)
	// Lists [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to a
	// customer.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// A list of the customer's
	// [Entitlement][google.cloud.channel.v1.Entitlement]s.
	ListEntitlements(context.Context, *ListEntitlementsRequest) (*ListEntitlementsResponse, error)
	// List [TransferableSku][google.cloud.channel.v1.TransferableSku]s of a
	// customer based on the Cloud Identity ID or Customer Name in the request.
	//
	// Use this method to list the entitlements information of an
	// unowned customer. You should provide the customer's
	// Cloud Identity ID or Customer Name.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller and has no auth token.
	//   - The supplied auth token is invalid.
	//   - The reseller account making the request is different
	//     from the reseller account in the query.
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// A list of the customer's
	// [TransferableSku][google.cloud.channel.v1.TransferableSku].
	ListTransferableSkus(context.Context, *ListTransferableSkusRequest) (*ListTransferableSkusResponse, error)
	// List [TransferableOffer][google.cloud.channel.v1.TransferableOffer]s of a
	// customer based on Cloud Identity ID or Customer Name in the request.
	//
	// Use this method when a reseller gets the entitlement information of an
	// unowned customer. The reseller should provide the customer's
	// Cloud Identity ID or Customer Name.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller and has no auth token.
	//   - The customer provided incorrect reseller information when generating
	//     auth token.
	//   - The reseller account making the request is different
	//     from the reseller account in the query.
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// List of [TransferableOffer][google.cloud.channel.v1.TransferableOffer] for
	// the given customer and SKU.
	ListTransferableOffers(context.Context, *ListTransferableOffersRequest) (*ListTransferableOffersResponse, error)
	// Returns the requested [Entitlement][google.cloud.channel.v1.Entitlement]
	// resource.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer entitlement was not found.
	//
	// Return value:
	// The requested [Entitlement][google.cloud.channel.v1.Entitlement] resource.
	GetEntitlement(context.Context, *GetEntitlementRequest) (*Entitlement, error)
	// Creates an entitlement for a customer.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller.
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT:
	//   - Required request parameters are missing or invalid.
	//   - There is already a customer entitlement for a SKU from the same
	//     product family.
	//
	// * INVALID_VALUE: Make sure the OfferId is valid. If it is, contact
	// Google Channel support for further troubleshooting.
	// * NOT_FOUND: The customer or offer resource was not found.
	// * ALREADY_EXISTS:
	//   - The SKU was already purchased for the customer.
	//   - The customer's primary email already exists. Retry
	//     after changing the customer's primary contact email.
	//
	// * CONDITION_NOT_MET or FAILED_PRECONDITION:
	//   - The domain required for purchasing a SKU has not been verified.
	//   - A pre-requisite SKU required to purchase an Add-On SKU is missing.
	//     For example, Google Workspace Business Starter is required to purchase
	//     Vault or Drive.
	//   - (Developer accounts only) Reseller and resold domain must meet the
	//     following naming requirements:
	//   - Domain names must start with goog-test.
	//   - Domain names must include the reseller domain.
	//
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	CreateEntitlement(context.Context, *CreateEntitlementRequest) (*longrunningpb.Operation, error)
	// Change parameters of the entitlement.
	//
	// An entitlement update is a long-running operation and it updates the
	// entitlement as a result of fulfillment.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// For example, the number of seats being changed is greater than the allowed
	// number of max seats, or decreasing seats for a commitment based plan.
	// * NOT_FOUND: Entitlement resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeParameters(context.Context, *ChangeParametersRequest) (*longrunningpb.Operation, error)
	// Updates the renewal settings for an existing customer entitlement.
	//
	// An entitlement update is a long-running operation and it updates the
	// entitlement as a result of fulfillment.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
	// commitment plan. Can't enable or disable renewals for non-commitment plans.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	//   - UNKNOWN: Any non-user error related to a technical issue in the backend.
	//     Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeRenewalSettings(context.Context, *ChangeRenewalSettingsRequest) (*longrunningpb.Operation, error)
	// Updates the Offer for an existing customer entitlement.
	//
	// An entitlement update is a long-running operation and it updates the
	// entitlement as a result of fulfillment.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Offer or Entitlement resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeOffer(context.Context, *ChangeOfferRequest) (*longrunningpb.Operation, error)
	// Starts paid service for a trial entitlement.
	//
	// Starts paid service for a trial entitlement immediately. This method is
	// only applicable if a plan is set up for a trial entitlement but has some
	// trial days remaining.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
	// entitlement on trial plans.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	StartPaidService(context.Context, *StartPaidServiceRequest) (*longrunningpb.Operation, error)
	// Suspends a previously fulfilled entitlement.
	//
	// An entitlement suspension is a long-running operation.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * NOT_ACTIVE: Entitlement is not active.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	SuspendEntitlement(context.Context, *SuspendEntitlementRequest) (*longrunningpb.Operation, error)
	// Cancels a previously fulfilled entitlement.
	//
	// An entitlement cancellation is a long-running operation.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * FAILED_PRECONDITION: There are Google Cloud projects linked to the
	// Google Cloud entitlement's Cloud Billing subaccount.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
	// add-ons, or entitlements for Google Cloud's development platform.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The response will contain
	// google.protobuf.Empty on success. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	CancelEntitlement(context.Context, *CancelEntitlementRequest) (*longrunningpb.Operation, error)
	// Activates a previously suspended entitlement. Entitlements suspended for
	// pending ToS acceptance can't be activated using this method.
	//
	// An entitlement activation is a long-running operation and it updates
	// the state of the customer entitlement.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * SUSPENSION_NOT_RESELLER_INITIATED: Can only activate reseller-initiated
	// suspensions and entitlements that have accepted the TOS.
	// * NOT_SUSPENDED: Can only activate suspended entitlements not in an ACTIVE
	// state.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ActivateEntitlement(context.Context, *ActivateEntitlementRequest) (*longrunningpb.Operation, error)
	// Transfers customer entitlements to new reseller.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller.
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer or offer resource was not found.
	// * ALREADY_EXISTS: The SKU was already transferred for the customer.
	// * CONDITION_NOT_MET or FAILED_PRECONDITION:
	//   - The SKU requires domain verification to transfer, but the domain is
	//     not verified.
	//   - An Add-On SKU (example, Vault or Drive) is missing the
	//     pre-requisite SKU (example, G Suite Basic).
	//   - (Developer accounts only) Reseller and resold domain must meet the
	//     following naming requirements:
	//   - Domain names must start with goog-test.
	//   - Domain names must include the reseller domain.
	//   - Specify all transferring entitlements.
	//
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	TransferEntitlements(context.Context, *TransferEntitlementsRequest) (*longrunningpb.Operation, error)
	// Transfers customer entitlements from their current reseller to Google.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer or offer resource was not found.
	// * ALREADY_EXISTS: The SKU was already transferred for the customer.
	// * CONDITION_NOT_MET or FAILED_PRECONDITION:
	//   - The SKU requires domain verification to transfer, but the domain is
	//     not verified.
	//   - An Add-On SKU (example, Vault or Drive) is missing the
	//     pre-requisite SKU (example, G Suite Basic).
	//   - (Developer accounts only) Reseller and resold domain must meet the
	//     following naming requirements:
	//   - Domain names must start with goog-test.
	//   - Domain names must include the reseller domain.
	//
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The response will contain
	// google.protobuf.Empty on success. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	TransferEntitlementsToGoogle(context.Context, *TransferEntitlementsToGoogleRequest) (*longrunningpb.Operation, error)
	// List [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s
	// belonging to a distributor. You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// The list of the distributor account's
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resources.
	ListChannelPartnerLinks(context.Context, *ListChannelPartnerLinksRequest) (*ListChannelPartnerLinksResponse, error)
	// Returns the requested
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
	// You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: ChannelPartnerLink resource not found because of an
	// invalid channel partner link name.
	//
	// Return value:
	// The [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
	// resource.
	GetChannelPartnerLink(context.Context, *GetChannelPartnerLinkRequest) (*ChannelPartnerLink, error)
	// Initiates a channel partner link between a distributor and a reseller, or
	// between resellers in an n-tier reseller channel.
	// Invited partners need to follow the invite_link_uri provided in the
	// response to accept. After accepting the invitation, a link is set up
	// between the two parties.
	// You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * ALREADY_EXISTS: The ChannelPartnerLink sent in the request already
	// exists.
	// * NOT_FOUND: No Cloud Identity customer exists for provided domain.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The new [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
	// resource.
	CreateChannelPartnerLink(context.Context, *CreateChannelPartnerLinkRequest) (*ChannelPartnerLink, error)
	// Updates a channel partner link. Distributors call this method to change a
	// link's status. For example, to suspend a partner link.
	// You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT:
	//   - Required request parameters are missing or invalid.
	//   - Link state cannot change from invited to active or suspended.
	//   - Cannot send reseller_cloud_identity_id, invite_url, or name in update
	//     mask.
	//
	// * NOT_FOUND: ChannelPartnerLink resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The updated
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
	UpdateChannelPartnerLink(context.Context, *UpdateChannelPartnerLinkRequest) (*ChannelPartnerLink, error)
	// Gets information about how a Reseller modifies their bill before sending
	// it to a Customer.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// was not found.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resource, otherwise returns an error.
	GetCustomerRepricingConfig(context.Context, *GetCustomerRepricingConfigRequest) (*CustomerRepricingConfig, error)
	// Lists information about how a Reseller modifies their bill before sending
	// it to a Customer.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resources. The data for each resource is displayed in the ascending order
	// of:
	//
	// * Customer ID
	// * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]
	// * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// * [CustomerRepricingConfig.update_time][google.cloud.channel.v1.CustomerRepricingConfig.update_time]
	//
	// If unsuccessful, returns an error.
	ListCustomerRepricingConfigs(context.Context, *ListCustomerRepricingConfigsRequest) (*ListCustomerRepricingConfigsResponse, error)
	// Creates a CustomerRepricingConfig. Call this method to set modifications
	// for a specific customer's bill. You can only create configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. If needed, you can create a config for the current
	// month, with some restrictions.
	//
	// When creating a config for a future month, make sure there are no existing
	// configs for that
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// The following restrictions are for creating configs in the current month.
	//
	// * This functionality is reserved for recovering from an erroneous config,
	// and should not be used for regular business cases.
	// * The new config will not modify exports used with other configs.
	// Changes to the config may be immediate, but may take up to 24 hours.
	// * There is a limit of ten configs for any
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
	// for any
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	// * The contained
	// [CustomerRepricingConfig.repricing_config][google.cloud.channel.v1.CustomerRepricingConfig.repricing_config]
	// value must be different from the value used in the current config for a
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resource, otherwise returns an error.
	CreateCustomerRepricingConfig(context.Context, *CreateCustomerRepricingConfigRequest) (*CustomerRepricingConfig, error)
	// Updates a CustomerRepricingConfig. Call this method to set modifications
	// for a specific customer's bill. This method overwrites the existing
	// CustomerRepricingConfig.
	//
	// You can only update configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. To make changes to configs for the current month, use
	// [CreateCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig],
	// taking note of its restrictions. You cannot update the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// When updating a config in the future:
	//
	// * This config must already exist.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resource, otherwise returns an error.
	UpdateCustomerRepricingConfig(context.Context, *UpdateCustomerRepricingConfigRequest) (*CustomerRepricingConfig, error)
	// Deletes the given
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// permanently. You can only delete configs if their
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is set to a date after the current month.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * FAILED_PRECONDITION: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// is active or in the past.
	// * NOT_FOUND: No
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// found for the name in the request.
	DeleteCustomerRepricingConfig(context.Context, *DeleteCustomerRepricingConfigRequest) (*emptypb.Empty, error)
	// Gets information about how a Distributor modifies their bill before sending
	// it to a ChannelPartner.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// was not found.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resource, otherwise returns an error.
	GetChannelPartnerRepricingConfig(context.Context, *GetChannelPartnerRepricingConfigRequest) (*ChannelPartnerRepricingConfig, error)
	// Lists information about how a Reseller modifies their bill before sending
	// it to a ChannelPartner.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resources. The data for each resource is displayed in the ascending order
	// of:
	//
	// * Channel Partner ID
	// * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// * [ChannelPartnerRepricingConfig.update_time][google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time]
	//
	// If unsuccessful, returns an error.
	ListChannelPartnerRepricingConfigs(context.Context, *ListChannelPartnerRepricingConfigsRequest) (*ListChannelPartnerRepricingConfigsResponse, error)
	// Creates a ChannelPartnerRepricingConfig. Call this method to set
	// modifications for a specific ChannelPartner's bill. You can only create
	// configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. If needed, you can create a config for the current
	// month, with some restrictions.
	//
	// When creating a config for a future month, make sure there are no existing
	// configs for that
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// The following restrictions are for creating configs in the current month.
	//
	// * This functionality is reserved for recovering from an erroneous config,
	// and should not be used for regular business cases.
	// * The new config will not modify exports used with other configs.
	// Changes to the config may be immediate, but may take up to 24 hours.
	// * There is a limit of ten configs for any ChannelPartner or
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
	// for any
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	// * The contained
	// [ChannelPartnerRepricingConfig.repricing_config][google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config]
	// value must be different from the value used in the current config for a
	// ChannelPartner.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resource, otherwise returns an error.
	CreateChannelPartnerRepricingConfig(context.Context, *CreateChannelPartnerRepricingConfigRequest) (*ChannelPartnerRepricingConfig, error)
	// Updates a ChannelPartnerRepricingConfig. Call this method to set
	// modifications for a specific ChannelPartner's bill. This method overwrites
	// the existing CustomerRepricingConfig.
	//
	// You can only update configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. To make changes to configs for the current month, use
	// [CreateChannelPartnerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig],
	// taking note of its restrictions. You cannot update the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// When updating a config in the future:
	//
	// * This config must already exist.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resource, otherwise returns an error.
	UpdateChannelPartnerRepricingConfig(context.Context, *UpdateChannelPartnerRepricingConfigRequest) (*ChannelPartnerRepricingConfig, error)
	// Deletes the given
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// permanently. You can only delete configs if their
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is set to a date after the current month.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * FAILED_PRECONDITION: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// is active or in the past.
	// * NOT_FOUND: No
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// found for the name in the request.
	DeleteChannelPartnerRepricingConfig(context.Context, *DeleteChannelPartnerRepricingConfigRequest) (*emptypb.Empty, error)
	// Lists the Rebilling supported SKU groups the account is authorized to
	// sell.
	// Reference: https://cloud.google.com/skus/sku-groups
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different, or the account doesn't exist.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the [SkuGroup][google.cloud.channel.v1.SkuGroup] resources.
	// The data for each resource is displayed in the alphabetical order of SKU
	// group display name.
	// The data for each resource is displayed in the ascending order of
	// [SkuGroup.display_name][google.cloud.channel.v1.SkuGroup.display_name]
	//
	// If unsuccessful, returns an error.
	ListSkuGroups(context.Context, *ListSkuGroupsRequest) (*ListSkuGroupsResponse, error)
	// Lists the Billable SKUs in a given SKU group.
	//
	// Possible error codes:
	// PERMISSION_DENIED: If the account making the request and the account
	// being queried for are different, or the account doesn't exist.
	// INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// INTERNAL: Any non-user error related to technical issue in the
	// backend. In this case, contact cloud channel support.
	//
	// Return Value:
	// If successful, the [BillableSku][google.cloud.channel.v1.BillableSku]
	// resources. The data for each resource is displayed in the ascending order
	// of:
	//
	// * [BillableSku.service_display_name][google.cloud.channel.v1.BillableSku.service_display_name]
	// * [BillableSku.sku_display_name][google.cloud.channel.v1.BillableSku.sku_display_name]
	//
	// If unsuccessful, returns an error.
	ListSkuGroupBillableSkus(context.Context, *ListSkuGroupBillableSkusRequest) (*ListSkuGroupBillableSkusResponse, error)
	// Returns the requested [Offer][google.cloud.channel.v1.Offer] resource.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The entitlement doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement or offer was not found.
	//
	// Return value:
	// The [Offer][google.cloud.channel.v1.Offer] resource.
	LookupOffer(context.Context, *LookupOfferRequest) (*Offer, error)
	// Lists the Products the reseller is authorized to sell.
	//
	// Possible error codes:
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error)
	// Lists the SKUs for a product the reseller is authorized to sell.
	//
	// Possible error codes:
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListSkus(context.Context, *ListSkusRequest) (*ListSkusResponse, error)
	// Lists the Offers the reseller can sell.
	//
	// Possible error codes:
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListOffers(context.Context, *ListOffersRequest) (*ListOffersResponse, error)
	// Lists the following:
	//
	// * SKUs that you can purchase for a customer
	// * SKUs that you can upgrade or downgrade for an entitlement.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListPurchasableSkus(context.Context, *ListPurchasableSkusRequest) (*ListPurchasableSkusResponse, error)
	// Lists the following:
	//
	// * Offers that you can purchase for a customer.
	// * Offers that you can change for an entitlement.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListPurchasableOffers(context.Context, *ListPurchasableOffersRequest) (*ListPurchasableOffersResponse, error)
	// Lists the billing accounts that are eligible to purchase particular SKUs
	// for a given customer.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// Based on the provided list of SKUs, returns a list of SKU groups that must
	// be purchased using the same billing account and the billing accounts
	// eligible to purchase each SKU group.
	QueryEligibleBillingAccounts(context.Context, *QueryEligibleBillingAccountsRequest) (*QueryEligibleBillingAccountsResponse, error)
	// Registers a service account with subscriber privileges on the Cloud Pub/Sub
	// topic for this Channel Services account. After you create a
	// subscriber, you get the events through
	// [SubscriberEvent][google.cloud.channel.v1.SubscriberEvent]
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different, or the impersonated user
	// is not a super admin.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The topic name with the registered service email address.
	RegisterSubscriber(context.Context, *RegisterSubscriberRequest) (*RegisterSubscriberResponse, error)
	// Unregisters a service account with subscriber privileges on the Cloud
	// Pub/Sub topic created for this Channel Services account. If there are no
	// service accounts left with subscriber privileges, this deletes the topic.
	// You can call ListSubscribers to check for these accounts.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different, or the impersonated user
	// is not a super admin.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The topic resource doesn't exist.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The topic name that unregistered the service email address.
	// Returns a success response if the service email address wasn't registered
	// with the topic.
	UnregisterSubscriber(context.Context, *UnregisterSubscriberRequest) (*UnregisterSubscriberResponse, error)
	// Lists service accounts with subscriber privileges on the Cloud Pub/Sub
	// topic created for this Channel Services account.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different, or the impersonated user
	// is not a super admin.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The topic resource doesn't exist.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// A list of service email addresses.
	ListSubscribers(context.Context, *ListSubscribersRequest) (*ListSubscribersResponse, error)
	// List entitlement history.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different.
	// * INVALID_ARGUMENT: Missing or invalid required fields in the request.
	// * NOT_FOUND: The parent resource doesn't exist. Usually the result of an
	// invalid name parameter.
	// * INTERNAL: Any non-user error related to a technical issue in the backend.
	// In this case, contact CloudChannel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return value:
	// List of [EntitlementChange][google.cloud.channel.v1.EntitlementChange]s.
	ListEntitlementChanges(context.Context, *ListEntitlementChangesRequest) (*ListEntitlementChangesResponse, error)
}

// UnimplementedCloudChannelServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCloudChannelServiceServer struct {
}

func (*UnimplementedCloudChannelServiceServer) ListCustomers(context.Context, *ListCustomersRequest) (*ListCustomersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomers not implemented")
}
func (*UnimplementedCloudChannelServiceServer) GetCustomer(context.Context, *GetCustomerRequest) (*Customer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomer not implemented")
}
func (*UnimplementedCloudChannelServiceServer) CheckCloudIdentityAccountsExist(context.Context, *CheckCloudIdentityAccountsExistRequest) (*CheckCloudIdentityAccountsExistResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckCloudIdentityAccountsExist not implemented")
}
func (*UnimplementedCloudChannelServiceServer) CreateCustomer(context.Context, *CreateCustomerRequest) (*Customer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomer not implemented")
}
func (*UnimplementedCloudChannelServiceServer) UpdateCustomer(context.Context, *UpdateCustomerRequest) (*Customer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomer not implemented")
}
func (*UnimplementedCloudChannelServiceServer) DeleteCustomer(context.Context, *DeleteCustomerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCustomer not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ImportCustomer(context.Context, *ImportCustomerRequest) (*Customer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportCustomer not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ProvisionCloudIdentity(context.Context, *ProvisionCloudIdentityRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProvisionCloudIdentity not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListEntitlements(context.Context, *ListEntitlementsRequest) (*ListEntitlementsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntitlements not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListTransferableSkus(context.Context, *ListTransferableSkusRequest) (*ListTransferableSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTransferableSkus not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListTransferableOffers(context.Context, *ListTransferableOffersRequest) (*ListTransferableOffersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTransferableOffers not implemented")
}
func (*UnimplementedCloudChannelServiceServer) GetEntitlement(context.Context, *GetEntitlementRequest) (*Entitlement, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntitlement not implemented")
}
func (*UnimplementedCloudChannelServiceServer) CreateEntitlement(context.Context, *CreateEntitlementRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntitlement not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ChangeParameters(context.Context, *ChangeParametersRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeParameters not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ChangeRenewalSettings(context.Context, *ChangeRenewalSettingsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeRenewalSettings not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ChangeOffer(context.Context, *ChangeOfferRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeOffer not implemented")
}
func (*UnimplementedCloudChannelServiceServer) StartPaidService(context.Context, *StartPaidServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartPaidService not implemented")
}
func (*UnimplementedCloudChannelServiceServer) SuspendEntitlement(context.Context, *SuspendEntitlementRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuspendEntitlement not implemented")
}
func (*UnimplementedCloudChannelServiceServer) CancelEntitlement(context.Context, *CancelEntitlementRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelEntitlement not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ActivateEntitlement(context.Context, *ActivateEntitlementRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ActivateEntitlement not implemented")
}
func (*UnimplementedCloudChannelServiceServer) TransferEntitlements(context.Context, *TransferEntitlementsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TransferEntitlements not implemented")
}
func (*UnimplementedCloudChannelServiceServer) TransferEntitlementsToGoogle(context.Context, *TransferEntitlementsToGoogleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TransferEntitlementsToGoogle not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListChannelPartnerLinks(context.Context, *ListChannelPartnerLinksRequest) (*ListChannelPartnerLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChannelPartnerLinks not implemented")
}
func (*UnimplementedCloudChannelServiceServer) GetChannelPartnerLink(context.Context, *GetChannelPartnerLinkRequest) (*ChannelPartnerLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChannelPartnerLink not implemented")
}
func (*UnimplementedCloudChannelServiceServer) CreateChannelPartnerLink(context.Context, *CreateChannelPartnerLinkRequest) (*ChannelPartnerLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateChannelPartnerLink not implemented")
}
func (*UnimplementedCloudChannelServiceServer) UpdateChannelPartnerLink(context.Context, *UpdateChannelPartnerLinkRequest) (*ChannelPartnerLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateChannelPartnerLink not implemented")
}
func (*UnimplementedCloudChannelServiceServer) GetCustomerRepricingConfig(context.Context, *GetCustomerRepricingConfigRequest) (*CustomerRepricingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomerRepricingConfig not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListCustomerRepricingConfigs(context.Context, *ListCustomerRepricingConfigsRequest) (*ListCustomerRepricingConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomerRepricingConfigs not implemented")
}
func (*UnimplementedCloudChannelServiceServer) CreateCustomerRepricingConfig(context.Context, *CreateCustomerRepricingConfigRequest) (*CustomerRepricingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomerRepricingConfig not implemented")
}
func (*UnimplementedCloudChannelServiceServer) UpdateCustomerRepricingConfig(context.Context, *UpdateCustomerRepricingConfigRequest) (*CustomerRepricingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomerRepricingConfig not implemented")
}
func (*UnimplementedCloudChannelServiceServer) DeleteCustomerRepricingConfig(context.Context, *DeleteCustomerRepricingConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCustomerRepricingConfig not implemented")
}
func (*UnimplementedCloudChannelServiceServer) GetChannelPartnerRepricingConfig(context.Context, *GetChannelPartnerRepricingConfigRequest) (*ChannelPartnerRepricingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChannelPartnerRepricingConfig not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListChannelPartnerRepricingConfigs(context.Context, *ListChannelPartnerRepricingConfigsRequest) (*ListChannelPartnerRepricingConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChannelPartnerRepricingConfigs not implemented")
}
func (*UnimplementedCloudChannelServiceServer) CreateChannelPartnerRepricingConfig(context.Context, *CreateChannelPartnerRepricingConfigRequest) (*ChannelPartnerRepricingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateChannelPartnerRepricingConfig not implemented")
}
func (*UnimplementedCloudChannelServiceServer) UpdateChannelPartnerRepricingConfig(context.Context, *UpdateChannelPartnerRepricingConfigRequest) (*ChannelPartnerRepricingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateChannelPartnerRepricingConfig not implemented")
}
func (*UnimplementedCloudChannelServiceServer) DeleteChannelPartnerRepricingConfig(context.Context, *DeleteChannelPartnerRepricingConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteChannelPartnerRepricingConfig not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListSkuGroups(context.Context, *ListSkuGroupsRequest) (*ListSkuGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSkuGroups not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListSkuGroupBillableSkus(context.Context, *ListSkuGroupBillableSkusRequest) (*ListSkuGroupBillableSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSkuGroupBillableSkus not implemented")
}
func (*UnimplementedCloudChannelServiceServer) LookupOffer(context.Context, *LookupOfferRequest) (*Offer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupOffer not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProducts not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListSkus(context.Context, *ListSkusRequest) (*ListSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSkus not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListOffers(context.Context, *ListOffersRequest) (*ListOffersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOffers not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListPurchasableSkus(context.Context, *ListPurchasableSkusRequest) (*ListPurchasableSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPurchasableSkus not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListPurchasableOffers(context.Context, *ListPurchasableOffersRequest) (*ListPurchasableOffersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPurchasableOffers not implemented")
}
func (*UnimplementedCloudChannelServiceServer) QueryEligibleBillingAccounts(context.Context, *QueryEligibleBillingAccountsRequest) (*QueryEligibleBillingAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryEligibleBillingAccounts not implemented")
}
func (*UnimplementedCloudChannelServiceServer) RegisterSubscriber(context.Context, *RegisterSubscriberRequest) (*RegisterSubscriberResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterSubscriber not implemented")
}
func (*UnimplementedCloudChannelServiceServer) UnregisterSubscriber(context.Context, *UnregisterSubscriberRequest) (*UnregisterSubscriberResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnregisterSubscriber not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListSubscribers(context.Context, *ListSubscribersRequest) (*ListSubscribersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubscribers not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListEntitlementChanges(context.Context, *ListEntitlementChangesRequest) (*ListEntitlementChangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntitlementChanges not implemented")
}

func RegisterCloudChannelServiceServer(s *grpc.Server, srv CloudChannelServiceServer) {
	s.RegisterService(&_CloudChannelService_serviceDesc, srv)
}

func _CloudChannelService_ListCustomers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListCustomers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListCustomers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListCustomers(ctx, req.(*ListCustomersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/GetCustomer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetCustomer(ctx, req.(*GetCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CheckCloudIdentityAccountsExist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckCloudIdentityAccountsExistRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CheckCloudIdentityAccountsExist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/CheckCloudIdentityAccountsExist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CheckCloudIdentityAccountsExist(ctx, req.(*CheckCloudIdentityAccountsExistRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/CreateCustomer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateCustomer(ctx, req.(*CreateCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_UpdateCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).UpdateCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/UpdateCustomer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).UpdateCustomer(ctx, req.(*UpdateCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_DeleteCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).DeleteCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/DeleteCustomer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).DeleteCustomer(ctx, req.(*DeleteCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ImportCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ImportCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ImportCustomer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ImportCustomer(ctx, req.(*ImportCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ProvisionCloudIdentity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProvisionCloudIdentityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ProvisionCloudIdentity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ProvisionCloudIdentity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ProvisionCloudIdentity(ctx, req.(*ProvisionCloudIdentityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListEntitlements_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntitlementsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListEntitlements(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListEntitlements",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListEntitlements(ctx, req.(*ListEntitlementsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListTransferableSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferableSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListTransferableSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListTransferableSkus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListTransferableSkus(ctx, req.(*ListTransferableSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListTransferableOffers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferableOffersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListTransferableOffers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListTransferableOffers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListTransferableOffers(ctx, req.(*ListTransferableOffersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/GetEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetEntitlement(ctx, req.(*GetEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/CreateEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateEntitlement(ctx, req.(*CreateEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ChangeParameters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeParametersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ChangeParameters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ChangeParameters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ChangeParameters(ctx, req.(*ChangeParametersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ChangeRenewalSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeRenewalSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ChangeRenewalSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ChangeRenewalSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ChangeRenewalSettings(ctx, req.(*ChangeRenewalSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ChangeOffer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeOfferRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ChangeOffer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ChangeOffer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ChangeOffer(ctx, req.(*ChangeOfferRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_StartPaidService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartPaidServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).StartPaidService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/StartPaidService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).StartPaidService(ctx, req.(*StartPaidServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_SuspendEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuspendEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).SuspendEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/SuspendEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).SuspendEntitlement(ctx, req.(*SuspendEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CancelEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CancelEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/CancelEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CancelEntitlement(ctx, req.(*CancelEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ActivateEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ActivateEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ActivateEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ActivateEntitlement(ctx, req.(*ActivateEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_TransferEntitlements_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransferEntitlementsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).TransferEntitlements(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/TransferEntitlements",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).TransferEntitlements(ctx, req.(*TransferEntitlementsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_TransferEntitlementsToGoogle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransferEntitlementsToGoogleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).TransferEntitlementsToGoogle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/TransferEntitlementsToGoogle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).TransferEntitlementsToGoogle(ctx, req.(*TransferEntitlementsToGoogleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListChannelPartnerLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChannelPartnerLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListChannelPartnerLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListChannelPartnerLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListChannelPartnerLinks(ctx, req.(*ListChannelPartnerLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetChannelPartnerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChannelPartnerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetChannelPartnerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/GetChannelPartnerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetChannelPartnerLink(ctx, req.(*GetChannelPartnerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateChannelPartnerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChannelPartnerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateChannelPartnerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/CreateChannelPartnerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateChannelPartnerLink(ctx, req.(*CreateChannelPartnerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_UpdateChannelPartnerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateChannelPartnerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).UpdateChannelPartnerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/UpdateChannelPartnerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).UpdateChannelPartnerLink(ctx, req.(*UpdateChannelPartnerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetCustomerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetCustomerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/GetCustomerRepricingConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetCustomerRepricingConfig(ctx, req.(*GetCustomerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListCustomerRepricingConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomerRepricingConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListCustomerRepricingConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListCustomerRepricingConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListCustomerRepricingConfigs(ctx, req.(*ListCustomerRepricingConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateCustomerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateCustomerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/CreateCustomerRepricingConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateCustomerRepricingConfig(ctx, req.(*CreateCustomerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_UpdateCustomerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).UpdateCustomerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/UpdateCustomerRepricingConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).UpdateCustomerRepricingConfig(ctx, req.(*UpdateCustomerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_DeleteCustomerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCustomerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).DeleteCustomerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/DeleteCustomerRepricingConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).DeleteCustomerRepricingConfig(ctx, req.(*DeleteCustomerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetChannelPartnerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChannelPartnerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetChannelPartnerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/GetChannelPartnerRepricingConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetChannelPartnerRepricingConfig(ctx, req.(*GetChannelPartnerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListChannelPartnerRepricingConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChannelPartnerRepricingConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListChannelPartnerRepricingConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListChannelPartnerRepricingConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListChannelPartnerRepricingConfigs(ctx, req.(*ListChannelPartnerRepricingConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateChannelPartnerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChannelPartnerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateChannelPartnerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/CreateChannelPartnerRepricingConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateChannelPartnerRepricingConfig(ctx, req.(*CreateChannelPartnerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_UpdateChannelPartnerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateChannelPartnerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).UpdateChannelPartnerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/UpdateChannelPartnerRepricingConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).UpdateChannelPartnerRepricingConfig(ctx, req.(*UpdateChannelPartnerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_DeleteChannelPartnerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteChannelPartnerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).DeleteChannelPartnerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/DeleteChannelPartnerRepricingConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).DeleteChannelPartnerRepricingConfig(ctx, req.(*DeleteChannelPartnerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListSkuGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSkuGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListSkuGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListSkuGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListSkuGroups(ctx, req.(*ListSkuGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListSkuGroupBillableSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSkuGroupBillableSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListSkuGroupBillableSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListSkuGroupBillableSkus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListSkuGroupBillableSkus(ctx, req.(*ListSkuGroupBillableSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_LookupOffer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupOfferRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).LookupOffer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/LookupOffer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).LookupOffer(ctx, req.(*LookupOfferRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListProducts(ctx, req.(*ListProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListSkus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListSkus(ctx, req.(*ListSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListOffers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOffersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListOffers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListOffers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListOffers(ctx, req.(*ListOffersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListPurchasableSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPurchasableSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListPurchasableSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListPurchasableSkus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListPurchasableSkus(ctx, req.(*ListPurchasableSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListPurchasableOffers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPurchasableOffersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListPurchasableOffers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListPurchasableOffers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListPurchasableOffers(ctx, req.(*ListPurchasableOffersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_QueryEligibleBillingAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryEligibleBillingAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).QueryEligibleBillingAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/QueryEligibleBillingAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).QueryEligibleBillingAccounts(ctx, req.(*QueryEligibleBillingAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_RegisterSubscriber_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterSubscriberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).RegisterSubscriber(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/RegisterSubscriber",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).RegisterSubscriber(ctx, req.(*RegisterSubscriberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_UnregisterSubscriber_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnregisterSubscriberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).UnregisterSubscriber(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/UnregisterSubscriber",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).UnregisterSubscriber(ctx, req.(*UnregisterSubscriberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListSubscribers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscribersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListSubscribers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListSubscribers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListSubscribers(ctx, req.(*ListSubscribersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListEntitlementChanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntitlementChangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListEntitlementChanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListEntitlementChanges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListEntitlementChanges(ctx, req.(*ListEntitlementChangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudChannelService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.channel.v1.CloudChannelService",
	HandlerType: (*CloudChannelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListCustomers",
			Handler:    _CloudChannelService_ListCustomers_Handler,
		},
		{
			MethodName: "GetCustomer",
			Handler:    _CloudChannelService_GetCustomer_Handler,
		},
		{
			MethodName: "CheckCloudIdentityAccountsExist",
			Handler:    _CloudChannelService_CheckCloudIdentityAccountsExist_Handler,
		},
		{
			MethodName: "CreateCustomer",
			Handler:    _CloudChannelService_CreateCustomer_Handler,
		},
		{
			MethodName: "UpdateCustomer",
			Handler:    _CloudChannelService_UpdateCustomer_Handler,
		},
		{
			MethodName: "DeleteCustomer",
			Handler:    _CloudChannelService_DeleteCustomer_Handler,
		},
		{
			MethodName: "ImportCustomer",
			Handler:    _CloudChannelService_ImportCustomer_Handler,
		},
		{
			MethodName: "ProvisionCloudIdentity",
			Handler:    _CloudChannelService_ProvisionCloudIdentity_Handler,
		},
		{
			MethodName: "ListEntitlements",
			Handler:    _CloudChannelService_ListEntitlements_Handler,
		},
		{
			MethodName: "ListTransferableSkus",
			Handler:    _CloudChannelService_ListTransferableSkus_Handler,
		},
		{
			MethodName: "ListTransferableOffers",
			Handler:    _CloudChannelService_ListTransferableOffers_Handler,
		},
		{
			MethodName: "GetEntitlement",
			Handler:    _CloudChannelService_GetEntitlement_Handler,
		},
		{
			MethodName: "CreateEntitlement",
			Handler:    _CloudChannelService_CreateEntitlement_Handler,
		},
		{
			MethodName: "ChangeParameters",
			Handler:    _CloudChannelService_ChangeParameters_Handler,
		},
		{
			MethodName: "ChangeRenewalSettings",
			Handler:    _CloudChannelService_ChangeRenewalSettings_Handler,
		},
		{
			MethodName: "ChangeOffer",
			Handler:    _CloudChannelService_ChangeOffer_Handler,
		},
		{
			MethodName: "StartPaidService",
			Handler:    _CloudChannelService_StartPaidService_Handler,
		},
		{
			MethodName: "SuspendEntitlement",
			Handler:    _CloudChannelService_SuspendEntitlement_Handler,
		},
		{
			MethodName: "CancelEntitlement",
			Handler:    _CloudChannelService_CancelEntitlement_Handler,
		},
		{
			MethodName: "ActivateEntitlement",
			Handler:    _CloudChannelService_ActivateEntitlement_Handler,
		},
		{
			MethodName: "TransferEntitlements",
			Handler:    _CloudChannelService_TransferEntitlements_Handler,
		},
		{
			MethodName: "TransferEntitlementsToGoogle",
			Handler:    _CloudChannelService_TransferEntitlementsToGoogle_Handler,
		},
		{
			MethodName: "ListChannelPartnerLinks",
			Handler:    _CloudChannelService_ListChannelPartnerLinks_Handler,
		},
		{
			MethodName: "GetChannelPartnerLink",
			Handler:    _CloudChannelService_GetChannelPartnerLink_Handler,
		},
		{
			MethodName: "CreateChannelPartnerLink",
			Handler:    _CloudChannelService_CreateChannelPartnerLink_Handler,
		},
		{
			MethodName: "UpdateChannelPartnerLink",
			Handler:    _CloudChannelService_UpdateChannelPartnerLink_Handler,
		},
		{
			MethodName: "GetCustomerRepricingConfig",
			Handler:    _CloudChannelService_GetCustomerRepricingConfig_Handler,
		},
		{
			MethodName: "ListCustomerRepricingConfigs",
			Handler:    _CloudChannelService_ListCustomerRepricingConfigs_Handler,
		},
		{
			MethodName: "CreateCustomerRepricingConfig",
			Handler:    _CloudChannelService_CreateCustomerRepricingConfig_Handler,
		},
		{
			MethodName: "UpdateCustomerRepricingConfig",
			Handler:    _CloudChannelService_UpdateCustomerRepricingConfig_Handler,
		},
		{
			MethodName: "DeleteCustomerRepricingConfig",
			Handler:    _CloudChannelService_DeleteCustomerRepricingConfig_Handler,
		},
		{
			MethodName: "GetChannelPartnerRepricingConfig",
			Handler:    _CloudChannelService_GetChannelPartnerRepricingConfig_Handler,
		},
		{
			MethodName: "ListChannelPartnerRepricingConfigs",
			Handler:    _CloudChannelService_ListChannelPartnerRepricingConfigs_Handler,
		},
		{
			MethodName: "CreateChannelPartnerRepricingConfig",
			Handler:    _CloudChannelService_CreateChannelPartnerRepricingConfig_Handler,
		},
		{
			MethodName: "UpdateChannelPartnerRepricingConfig",
			Handler:    _CloudChannelService_UpdateChannelPartnerRepricingConfig_Handler,
		},
		{
			MethodName: "DeleteChannelPartnerRepricingConfig",
			Handler:    _CloudChannelService_DeleteChannelPartnerRepricingConfig_Handler,
		},
		{
			MethodName: "ListSkuGroups",
			Handler:    _CloudChannelService_ListSkuGroups_Handler,
		},
		{
			MethodName: "ListSkuGroupBillableSkus",
			Handler:    _CloudChannelService_ListSkuGroupBillableSkus_Handler,
		},
		{
			MethodName: "LookupOffer",
			Handler:    _CloudChannelService_LookupOffer_Handler,
		},
		{
			MethodName: "ListProducts",
			Handler:    _CloudChannelService_ListProducts_Handler,
		},
		{
			MethodName: "ListSkus",
			Handler:    _CloudChannelService_ListSkus_Handler,
		},
		{
			MethodName: "ListOffers",
			Handler:    _CloudChannelService_ListOffers_Handler,
		},
		{
			MethodName: "ListPurchasableSkus",
			Handler:    _CloudChannelService_ListPurchasableSkus_Handler,
		},
		{
			MethodName: "ListPurchasableOffers",
			Handler:    _CloudChannelService_ListPurchasableOffers_Handler,
		},
		{
			MethodName: "QueryEligibleBillingAccounts",
			Handler:    _CloudChannelService_QueryEligibleBillingAccounts_Handler,
		},
		{
			MethodName: "RegisterSubscriber",
			Handler:    _CloudChannelService_RegisterSubscriber_Handler,
		},
		{
			MethodName: "UnregisterSubscriber",
			Handler:    _CloudChannelService_UnregisterSubscriber_Handler,
		},
		{
			MethodName: "ListSubscribers",
			Handler:    _CloudChannelService_ListSubscribers_Handler,
		},
		{
			MethodName: "ListEntitlementChanges",
			Handler:    _CloudChannelService_ListEntitlementChanges_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/channel/v1/service.proto",
}
