// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/bigtable/admin/v2/types.proto

package admin

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// `Type` represents the type of data that is written to, read from, or stored
// in Bigtable. It is heavily based on the GoogleSQL standard to help maintain
// familiarity and consistency across products and features.
//
// For compatibility with Bigtable's existing untyped APIs, each `Type` includes
// an `Encoding` which describes how to convert to/from the underlying data.
// This might involve composing a series of steps into an "encoding chain," for
// example to convert from INT64 -> STRING -> raw bytes. In most cases, a "link"
// in the encoding chain will be based an on existing GoogleSQL conversion
// function like `CAST`.
//
// Each link in the encoding chain also defines the following properties:
//   - Natural sort: Does the encoded value sort consistently with the original
//     typed value? Note that Bigtable will always sort data based on the raw
//     encoded value, *not* the decoded type.
//   - Example: BYTES values sort in the same order as their raw encodings.
//   - Counterexample: Encoding INT64 to a fixed-width STRING does *not*
//     preserve sort order when dealing with negative numbers.
//     INT64(1) > INT64(-1), but STRING("-00001") > STRING("00001).
//   - The overall encoding chain has this property if *every* link does.
//   - Self-delimiting: If we concatenate two encoded values, can we always tell
//     where the first one ends and the second one begins?
//   - Example: If we encode INT64s to fixed-width STRINGs, the first value
//     will always contain exactly N digits, possibly preceded by a sign.
//   - Counterexample: If we concatenate two UTF-8 encoded STRINGs, we have
//     no way to tell where the first one ends.
//   - The overall encoding chain has this property if *any* link does.
//   - Compatibility: Which other systems have matching encoding schemes? For
//     example, does this encoding have a GoogleSQL equivalent? HBase? Java?
type Type struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The kind of type that this represents.
	//
	// Types that are assignable to Kind:
	//
	//	*Type_BytesType
	//	*Type_StringType
	//	*Type_Int64Type
	//	*Type_AggregateType
	Kind isType_Kind `protobuf_oneof:"kind"`
}

func (x *Type) Reset() {
	*x = Type{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type) ProtoMessage() {}

func (x *Type) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type.ProtoReflect.Descriptor instead.
func (*Type) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0}
}

func (m *Type) GetKind() isType_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *Type) GetBytesType() *Type_Bytes {
	if x, ok := x.GetKind().(*Type_BytesType); ok {
		return x.BytesType
	}
	return nil
}

func (x *Type) GetStringType() *Type_String {
	if x, ok := x.GetKind().(*Type_StringType); ok {
		return x.StringType
	}
	return nil
}

func (x *Type) GetInt64Type() *Type_Int64 {
	if x, ok := x.GetKind().(*Type_Int64Type); ok {
		return x.Int64Type
	}
	return nil
}

func (x *Type) GetAggregateType() *Type_Aggregate {
	if x, ok := x.GetKind().(*Type_AggregateType); ok {
		return x.AggregateType
	}
	return nil
}

type isType_Kind interface {
	isType_Kind()
}

type Type_BytesType struct {
	// Bytes
	BytesType *Type_Bytes `protobuf:"bytes,1,opt,name=bytes_type,json=bytesType,proto3,oneof"`
}

type Type_StringType struct {
	// String
	StringType *Type_String `protobuf:"bytes,2,opt,name=string_type,json=stringType,proto3,oneof"`
}

type Type_Int64Type struct {
	// Int64
	Int64Type *Type_Int64 `protobuf:"bytes,5,opt,name=int64_type,json=int64Type,proto3,oneof"`
}

type Type_AggregateType struct {
	// Aggregate
	AggregateType *Type_Aggregate `protobuf:"bytes,6,opt,name=aggregate_type,json=aggregateType,proto3,oneof"`
}

func (*Type_BytesType) isType_Kind() {}

func (*Type_StringType) isType_Kind() {}

func (*Type_Int64Type) isType_Kind() {}

func (*Type_AggregateType) isType_Kind() {}

// Bytes
// Values of type `Bytes` are stored in `Value.bytes_value`.
type Type_Bytes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encoding to use when converting to/from lower level types.
	Encoding *Type_Bytes_Encoding `protobuf:"bytes,1,opt,name=encoding,proto3" json:"encoding,omitempty"`
}

func (x *Type_Bytes) Reset() {
	*x = Type_Bytes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type_Bytes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Bytes) ProtoMessage() {}

func (x *Type_Bytes) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Bytes.ProtoReflect.Descriptor instead.
func (*Type_Bytes) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Type_Bytes) GetEncoding() *Type_Bytes_Encoding {
	if x != nil {
		return x.Encoding
	}
	return nil
}

// String
// Values of type `String` are stored in `Value.string_value`.
type Type_String struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encoding to use when converting to/from lower level types.
	Encoding *Type_String_Encoding `protobuf:"bytes,1,opt,name=encoding,proto3" json:"encoding,omitempty"`
}

func (x *Type_String) Reset() {
	*x = Type_String{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type_String) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_String) ProtoMessage() {}

func (x *Type_String) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_String.ProtoReflect.Descriptor instead.
func (*Type_String) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Type_String) GetEncoding() *Type_String_Encoding {
	if x != nil {
		return x.Encoding
	}
	return nil
}

// Int64
// Values of type `Int64` are stored in `Value.int_value`.
type Type_Int64 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encoding to use when converting to/from lower level types.
	Encoding *Type_Int64_Encoding `protobuf:"bytes,1,opt,name=encoding,proto3" json:"encoding,omitempty"`
}

func (x *Type_Int64) Reset() {
	*x = Type_Int64{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type_Int64) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Int64) ProtoMessage() {}

func (x *Type_Int64) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Int64.ProtoReflect.Descriptor instead.
func (*Type_Int64) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Type_Int64) GetEncoding() *Type_Int64_Encoding {
	if x != nil {
		return x.Encoding
	}
	return nil
}

// A value that combines incremental updates into a summarized value.
//
// Data is never directly written or read using type `Aggregate`. Writes will
// provide either the `input_type` or `state_type`, and reads will always
// return the `state_type` .
type Type_Aggregate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the inputs that are accumulated by this `Aggregate`, which must
	// specify a full encoding.
	// Use `AddInput` mutations to accumulate new inputs.
	InputType *Type `protobuf:"bytes,1,opt,name=input_type,json=inputType,proto3" json:"input_type,omitempty"`
	// Output only. Type that holds the internal accumulator state for the
	// `Aggregate`. This is a function of the `input_type` and `aggregator`
	// chosen, and will always specify a full encoding.
	StateType *Type `protobuf:"bytes,2,opt,name=state_type,json=stateType,proto3" json:"state_type,omitempty"`
	// Which aggregator function to use. The configured types must match.
	//
	// Types that are assignable to Aggregator:
	//
	//	*Type_Aggregate_Sum_
	Aggregator isType_Aggregate_Aggregator `protobuf_oneof:"aggregator"`
}

func (x *Type_Aggregate) Reset() {
	*x = Type_Aggregate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type_Aggregate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Aggregate) ProtoMessage() {}

func (x *Type_Aggregate) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Aggregate.ProtoReflect.Descriptor instead.
func (*Type_Aggregate) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Type_Aggregate) GetInputType() *Type {
	if x != nil {
		return x.InputType
	}
	return nil
}

func (x *Type_Aggregate) GetStateType() *Type {
	if x != nil {
		return x.StateType
	}
	return nil
}

func (m *Type_Aggregate) GetAggregator() isType_Aggregate_Aggregator {
	if m != nil {
		return m.Aggregator
	}
	return nil
}

func (x *Type_Aggregate) GetSum() *Type_Aggregate_Sum {
	if x, ok := x.GetAggregator().(*Type_Aggregate_Sum_); ok {
		return x.Sum
	}
	return nil
}

type isType_Aggregate_Aggregator interface {
	isType_Aggregate_Aggregator()
}

type Type_Aggregate_Sum_ struct {
	// Sum aggregator.
	Sum *Type_Aggregate_Sum `protobuf:"bytes,4,opt,name=sum,proto3,oneof"`
}

func (*Type_Aggregate_Sum_) isType_Aggregate_Aggregator() {}

// Rules used to convert to/from lower level types.
type Type_Bytes_Encoding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which encoding to use.
	//
	// Types that are assignable to Encoding:
	//
	//	*Type_Bytes_Encoding_Raw_
	Encoding isType_Bytes_Encoding_Encoding `protobuf_oneof:"encoding"`
}

func (x *Type_Bytes_Encoding) Reset() {
	*x = Type_Bytes_Encoding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type_Bytes_Encoding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Bytes_Encoding) ProtoMessage() {}

func (x *Type_Bytes_Encoding) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Bytes_Encoding.ProtoReflect.Descriptor instead.
func (*Type_Bytes_Encoding) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (m *Type_Bytes_Encoding) GetEncoding() isType_Bytes_Encoding_Encoding {
	if m != nil {
		return m.Encoding
	}
	return nil
}

func (x *Type_Bytes_Encoding) GetRaw() *Type_Bytes_Encoding_Raw {
	if x, ok := x.GetEncoding().(*Type_Bytes_Encoding_Raw_); ok {
		return x.Raw
	}
	return nil
}

type isType_Bytes_Encoding_Encoding interface {
	isType_Bytes_Encoding_Encoding()
}

type Type_Bytes_Encoding_Raw_ struct {
	// Use `Raw` encoding.
	Raw *Type_Bytes_Encoding_Raw `protobuf:"bytes,1,opt,name=raw,proto3,oneof"`
}

func (*Type_Bytes_Encoding_Raw_) isType_Bytes_Encoding_Encoding() {}

// Leaves the value "as-is"
// * Natural sort? Yes
// * Self-delimiting? No
// * Compatibility? N/A
type Type_Bytes_Encoding_Raw struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Bytes_Encoding_Raw) Reset() {
	*x = Type_Bytes_Encoding_Raw{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type_Bytes_Encoding_Raw) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Bytes_Encoding_Raw) ProtoMessage() {}

func (x *Type_Bytes_Encoding_Raw) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Bytes_Encoding_Raw.ProtoReflect.Descriptor instead.
func (*Type_Bytes_Encoding_Raw) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 0, 0, 0}
}

// Rules used to convert to/from lower level types.
type Type_String_Encoding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which encoding to use.
	//
	// Types that are assignable to Encoding:
	//
	//	*Type_String_Encoding_Utf8Raw_
	Encoding isType_String_Encoding_Encoding `protobuf_oneof:"encoding"`
}

func (x *Type_String_Encoding) Reset() {
	*x = Type_String_Encoding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type_String_Encoding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_String_Encoding) ProtoMessage() {}

func (x *Type_String_Encoding) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_String_Encoding.ProtoReflect.Descriptor instead.
func (*Type_String_Encoding) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (m *Type_String_Encoding) GetEncoding() isType_String_Encoding_Encoding {
	if m != nil {
		return m.Encoding
	}
	return nil
}

func (x *Type_String_Encoding) GetUtf8Raw() *Type_String_Encoding_Utf8Raw {
	if x, ok := x.GetEncoding().(*Type_String_Encoding_Utf8Raw_); ok {
		return x.Utf8Raw
	}
	return nil
}

type isType_String_Encoding_Encoding interface {
	isType_String_Encoding_Encoding()
}

type Type_String_Encoding_Utf8Raw_ struct {
	// Use `Utf8Raw` encoding.
	Utf8Raw *Type_String_Encoding_Utf8Raw `protobuf:"bytes,1,opt,name=utf8_raw,json=utf8Raw,proto3,oneof"`
}

func (*Type_String_Encoding_Utf8Raw_) isType_String_Encoding_Encoding() {}

// UTF-8 encoding
// * Natural sort? No (ASCII characters only)
// * Self-delimiting? No
// * Compatibility?
//   - BigQuery Federation `TEXT` encoding
//   - HBase `Bytes.toBytes`
//   - Java `String#getBytes(StandardCharsets.UTF_8)`
type Type_String_Encoding_Utf8Raw struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_String_Encoding_Utf8Raw) Reset() {
	*x = Type_String_Encoding_Utf8Raw{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type_String_Encoding_Utf8Raw) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_String_Encoding_Utf8Raw) ProtoMessage() {}

func (x *Type_String_Encoding_Utf8Raw) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_String_Encoding_Utf8Raw.ProtoReflect.Descriptor instead.
func (*Type_String_Encoding_Utf8Raw) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 1, 0, 0}
}

// Rules used to convert to/from lower level types.
type Type_Int64_Encoding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which encoding to use.
	//
	// Types that are assignable to Encoding:
	//
	//	*Type_Int64_Encoding_BigEndianBytes_
	Encoding isType_Int64_Encoding_Encoding `protobuf_oneof:"encoding"`
}

func (x *Type_Int64_Encoding) Reset() {
	*x = Type_Int64_Encoding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type_Int64_Encoding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Int64_Encoding) ProtoMessage() {}

func (x *Type_Int64_Encoding) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Int64_Encoding.ProtoReflect.Descriptor instead.
func (*Type_Int64_Encoding) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (m *Type_Int64_Encoding) GetEncoding() isType_Int64_Encoding_Encoding {
	if m != nil {
		return m.Encoding
	}
	return nil
}

func (x *Type_Int64_Encoding) GetBigEndianBytes() *Type_Int64_Encoding_BigEndianBytes {
	if x, ok := x.GetEncoding().(*Type_Int64_Encoding_BigEndianBytes_); ok {
		return x.BigEndianBytes
	}
	return nil
}

type isType_Int64_Encoding_Encoding interface {
	isType_Int64_Encoding_Encoding()
}

type Type_Int64_Encoding_BigEndianBytes_ struct {
	// Use `BigEndianBytes` encoding.
	BigEndianBytes *Type_Int64_Encoding_BigEndianBytes `protobuf:"bytes,1,opt,name=big_endian_bytes,json=bigEndianBytes,proto3,oneof"`
}

func (*Type_Int64_Encoding_BigEndianBytes_) isType_Int64_Encoding_Encoding() {}

// Encodes the value as an 8-byte big endian twos complement `Bytes`
// value.
// * Natural sort? No (positive values only)
// * Self-delimiting? Yes
// * Compatibility?
//   - BigQuery Federation `BINARY` encoding
//   - HBase `Bytes.toBytes`
//   - Java `ByteBuffer.putLong()` with `ByteOrder.BIG_ENDIAN`
type Type_Int64_Encoding_BigEndianBytes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The underlying `Bytes` type, which may be able to encode further.
	BytesType *Type_Bytes `protobuf:"bytes,1,opt,name=bytes_type,json=bytesType,proto3" json:"bytes_type,omitempty"`
}

func (x *Type_Int64_Encoding_BigEndianBytes) Reset() {
	*x = Type_Int64_Encoding_BigEndianBytes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type_Int64_Encoding_BigEndianBytes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Int64_Encoding_BigEndianBytes) ProtoMessage() {}

func (x *Type_Int64_Encoding_BigEndianBytes) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Int64_Encoding_BigEndianBytes.ProtoReflect.Descriptor instead.
func (*Type_Int64_Encoding_BigEndianBytes) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 2, 0, 0}
}

func (x *Type_Int64_Encoding_BigEndianBytes) GetBytesType() *Type_Bytes {
	if x != nil {
		return x.BytesType
	}
	return nil
}

// Computes the sum of the input values.
// Allowed input: `Int64`
// State: same as input
type Type_Aggregate_Sum struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Type_Aggregate_Sum) Reset() {
	*x = Type_Aggregate_Sum{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type_Aggregate_Sum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Aggregate_Sum) ProtoMessage() {}

func (x *Type_Aggregate_Sum) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_types_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Aggregate_Sum.ProtoReflect.Descriptor instead.
func (*Type_Aggregate_Sum) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_types_proto_rawDescGZIP(), []int{0, 3, 0}
}

var File_google_bigtable_admin_v2_types_proto protoreflect.FileDescriptor

var file_google_bigtable_admin_v2_types_proto_rawDesc = []byte{
	0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xda, 0x09, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x48, 0x00, 0x52, 0x09, 0x62, 0x79, 0x74, 0x65, 0x73, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x48, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52,
	0x0a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x69,
	0x6e, 0x74, 0x36, 0x34, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x48, 0x00, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x51, 0x0a, 0x0e, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xb8, 0x01, 0x0a, 0x05, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12,
	0x49, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x1a, 0x64, 0x0a, 0x08, 0x45, 0x6e,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x45, 0x0a, 0x03, 0x72, 0x61, 0x77, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x2e, 0x52, 0x61, 0x77, 0x48, 0x00, 0x52, 0x03, 0x72, 0x61, 0x77, 0x1a, 0x05, 0x0a,
	0x03, 0x52, 0x61, 0x77, 0x42, 0x0a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x1a, 0xcc, 0x01, 0x0a, 0x06, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x4a, 0x0a, 0x08, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x1a, 0x76, 0x0a, 0x08, 0x45, 0x6e, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x53, 0x0a, 0x08, 0x75, 0x74, 0x66, 0x38, 0x5f, 0x72, 0x61, 0x77, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x45, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x55, 0x74, 0x66, 0x38, 0x52, 0x61, 0x77, 0x48, 0x00, 0x52,
	0x07, 0x75, 0x74, 0x66, 0x38, 0x52, 0x61, 0x77, 0x1a, 0x09, 0x0a, 0x07, 0x55, 0x74, 0x66, 0x38,
	0x52, 0x61, 0x77, 0x42, 0x0a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x1a,
	0xac, 0x02, 0x0a, 0x05, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x12, 0x49, 0x0a, 0x08, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x1a, 0xd7, 0x01, 0x0a, 0x08, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x68, 0x0a, 0x10, 0x62, 0x69, 0x67, 0x5f, 0x65, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x42, 0x69, 0x67, 0x45, 0x6e,
	0x64, 0x69, 0x61, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67,
	0x45, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x1a, 0x55, 0x0a, 0x0e, 0x42,
	0x69, 0x67, 0x45, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x43, 0x0a,
	0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x09, 0x62, 0x79, 0x74, 0x65, 0x73, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x1a, 0xe5,
	0x01, 0x0a, 0x09, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x12, 0x3d, 0x0a, 0x0a,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x42, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x40, 0x0a, 0x03, 0x73, 0x75, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x41, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x48, 0x00, 0x52, 0x03, 0x73, 0x75,
	0x6d, 0x1a, 0x05, 0x0a, 0x03, 0x53, 0x75, 0x6d, 0x42, 0x0c, 0x0a, 0x0a, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x42, 0xd2,
	0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69,
	0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x42,
	0x0a, 0x54, 0x79, 0x70, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3d, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x32, 0x3b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0xaa, 0x02, 0x1e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x1e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x5c, 0x56, 0x32, 0xea, 0x02,
	0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x3a,
	0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_bigtable_admin_v2_types_proto_rawDescOnce sync.Once
	file_google_bigtable_admin_v2_types_proto_rawDescData = file_google_bigtable_admin_v2_types_proto_rawDesc
)

func file_google_bigtable_admin_v2_types_proto_rawDescGZIP() []byte {
	file_google_bigtable_admin_v2_types_proto_rawDescOnce.Do(func() {
		file_google_bigtable_admin_v2_types_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_bigtable_admin_v2_types_proto_rawDescData)
	})
	return file_google_bigtable_admin_v2_types_proto_rawDescData
}

var file_google_bigtable_admin_v2_types_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_bigtable_admin_v2_types_proto_goTypes = []interface{}{
	(*Type)(nil),                               // 0: google.bigtable.admin.v2.Type
	(*Type_Bytes)(nil),                         // 1: google.bigtable.admin.v2.Type.Bytes
	(*Type_String)(nil),                        // 2: google.bigtable.admin.v2.Type.String
	(*Type_Int64)(nil),                         // 3: google.bigtable.admin.v2.Type.Int64
	(*Type_Aggregate)(nil),                     // 4: google.bigtable.admin.v2.Type.Aggregate
	(*Type_Bytes_Encoding)(nil),                // 5: google.bigtable.admin.v2.Type.Bytes.Encoding
	(*Type_Bytes_Encoding_Raw)(nil),            // 6: google.bigtable.admin.v2.Type.Bytes.Encoding.Raw
	(*Type_String_Encoding)(nil),               // 7: google.bigtable.admin.v2.Type.String.Encoding
	(*Type_String_Encoding_Utf8Raw)(nil),       // 8: google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw
	(*Type_Int64_Encoding)(nil),                // 9: google.bigtable.admin.v2.Type.Int64.Encoding
	(*Type_Int64_Encoding_BigEndianBytes)(nil), // 10: google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
	(*Type_Aggregate_Sum)(nil),                 // 11: google.bigtable.admin.v2.Type.Aggregate.Sum
}
var file_google_bigtable_admin_v2_types_proto_depIdxs = []int32{
	1,  // 0: google.bigtable.admin.v2.Type.bytes_type:type_name -> google.bigtable.admin.v2.Type.Bytes
	2,  // 1: google.bigtable.admin.v2.Type.string_type:type_name -> google.bigtable.admin.v2.Type.String
	3,  // 2: google.bigtable.admin.v2.Type.int64_type:type_name -> google.bigtable.admin.v2.Type.Int64
	4,  // 3: google.bigtable.admin.v2.Type.aggregate_type:type_name -> google.bigtable.admin.v2.Type.Aggregate
	5,  // 4: google.bigtable.admin.v2.Type.Bytes.encoding:type_name -> google.bigtable.admin.v2.Type.Bytes.Encoding
	7,  // 5: google.bigtable.admin.v2.Type.String.encoding:type_name -> google.bigtable.admin.v2.Type.String.Encoding
	9,  // 6: google.bigtable.admin.v2.Type.Int64.encoding:type_name -> google.bigtable.admin.v2.Type.Int64.Encoding
	0,  // 7: google.bigtable.admin.v2.Type.Aggregate.input_type:type_name -> google.bigtable.admin.v2.Type
	0,  // 8: google.bigtable.admin.v2.Type.Aggregate.state_type:type_name -> google.bigtable.admin.v2.Type
	11, // 9: google.bigtable.admin.v2.Type.Aggregate.sum:type_name -> google.bigtable.admin.v2.Type.Aggregate.Sum
	6,  // 10: google.bigtable.admin.v2.Type.Bytes.Encoding.raw:type_name -> google.bigtable.admin.v2.Type.Bytes.Encoding.Raw
	8,  // 11: google.bigtable.admin.v2.Type.String.Encoding.utf8_raw:type_name -> google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw
	10, // 12: google.bigtable.admin.v2.Type.Int64.Encoding.big_endian_bytes:type_name -> google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
	1,  // 13: google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.bytes_type:type_name -> google.bigtable.admin.v2.Type.Bytes
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_bigtable_admin_v2_types_proto_init() }
func file_google_bigtable_admin_v2_types_proto_init() {
	if File_google_bigtable_admin_v2_types_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_bigtable_admin_v2_types_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_v2_types_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type_Bytes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_v2_types_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type_String); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_v2_types_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type_Int64); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_v2_types_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type_Aggregate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_v2_types_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type_Bytes_Encoding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_v2_types_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type_Bytes_Encoding_Raw); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_v2_types_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type_String_Encoding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_v2_types_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type_String_Encoding_Utf8Raw); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_v2_types_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type_Int64_Encoding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_v2_types_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type_Int64_Encoding_BigEndianBytes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_v2_types_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type_Aggregate_Sum); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_bigtable_admin_v2_types_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Type_BytesType)(nil),
		(*Type_StringType)(nil),
		(*Type_Int64Type)(nil),
		(*Type_AggregateType)(nil),
	}
	file_google_bigtable_admin_v2_types_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Type_Aggregate_Sum_)(nil),
	}
	file_google_bigtable_admin_v2_types_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*Type_Bytes_Encoding_Raw_)(nil),
	}
	file_google_bigtable_admin_v2_types_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*Type_String_Encoding_Utf8Raw_)(nil),
	}
	file_google_bigtable_admin_v2_types_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*Type_Int64_Encoding_BigEndianBytes_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_bigtable_admin_v2_types_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_bigtable_admin_v2_types_proto_goTypes,
		DependencyIndexes: file_google_bigtable_admin_v2_types_proto_depIdxs,
		MessageInfos:      file_google_bigtable_admin_v2_types_proto_msgTypes,
	}.Build()
	File_google_bigtable_admin_v2_types_proto = out.File
	file_google_bigtable_admin_v2_types_proto_rawDesc = nil
	file_google_bigtable_admin_v2_types_proto_goTypes = nil
	file_google_bigtable_admin_v2_types_proto_depIdxs = nil
}
