% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simMarkovOrd.r
\name{simMarkovOrd}
\alias{simMarkovOrd}
\title{simMarkovOrd}
\usage{
simMarkovOrd(
  n = 1,
  y,
  times,
  initial,
  X = NULL,
  absorb = NULL,
  intercepts,
  g,
  carry = FALSE,
  rdsample = NULL,
  ...
)
}
\arguments{
\item{n}{number of subjects to simulate}

\item{y}{vector of possible y values in order (numeric, character, factor)}

\item{times}{vector of measurement times}

\item{initial}{initial value of \code{y} (baseline state; numeric, character, or factor matching \code{y}).  If length 1 this value is used for all subjects, otherwise it is a vector of length \code{n}.}

\item{X}{an optional vector of matrix of baseline covariate values passed to \code{g}.  If a vector, \code{X} represents a set of single values for all the covariates and those values are used for every subject.  Otherwise \code{X} is a matrix with rows corresponding to subjects and columns corresponding to covariates which \code{g} must know how to handle.  \code{g} only sees one row of \code{X} at a time.}

\item{absorb}{vector of absorbing states, a subset of \code{y} (numeric, character, or factor matching \code{y}).  The default is no absorbing states.  Observations are truncated when an absorbing state is simulated.}

\item{intercepts}{vector of intercepts in the proportional odds model.  There must be one fewer of these than the length of \code{y}.}

\item{g}{a user-specified function of three or more arguments which in order are \code{yprev} - the value of \code{y} at the previous time, the current time \code{t}, the \code{gap} between the previous time and the current time, an optional (usually named) covariate vector \code{X}, and optional arguments such as a regression coefficient value to simulate from.  The function needs to allow \code{yprev} to be a vector and \code{yprev} must not include any absorbing states.  The \code{g} function returns the linear predictor for the proportional odds model aside from \code{intercepts}.  The returned value must be a matrix with row names taken from \code{yprev}.  If the model is a proportional odds model, the returned value must be one column.  If it is a partial proportional odds model, the value must have one column for each distinct value of the response variable Y after the first one, with the levels of Y used as optional column names.  So columns correspond to \code{intercepts}. The different columns are used for \code{y}-specific contributions to the linear predictor (aside from \code{intercepts}) for a partial or constrained partial proportional odds model.  Parameters for partial proportional odds effects may be included in the ... arguments.}

\item{carry}{set to \code{TRUE} to carry absorbing state forward after it is first hit; the default is to end records for the subject once the absorbing state is hit}

\item{rdsample}{an optional function to do response-dependent sampling.  It is a function of these arguments, which are vectors that stop at any absorbing state: \code{times} (ascending measurement times for one subject), \code{y} (vector of ordinal outcomes at these times for one subject.  The function returns \code{NULL} if no observations are to be dropped, returns the vector of new times to sample.}

\item{...}{additional arguments to pass to \code{g} such as a regresson coefficient}
}
\value{
data frame with one row per subject per time, and columns id, time, gap, yprev, y
}
\description{
Simulate Ordinal Markov Process
}
\details{
Simulates longitudinal data for subjects following a first-order Markov process under a proportional odds model.  Optionally, response-dependent sampling can be done, e.g., if a subject hits a specified state at time t, measurements are removed for times t+1, t+3, t+5, ...  This is applicable when for example a study of hospitalized patients samples every day, Y=1 denotes patient discharge to home, and sampling is less frequent outside the hospital.  This example assumes that arriving home is not an absorbing state, i.e., a patient could return to the hospital.
}
\seealso{
\url{https://hbiostat.org/R/Hmisc/markov/}
}
\author{
Frank Harrell
}
