
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_parcsr_ls.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSCreate( HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSCreate_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *rel_resid_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSGetFinalRelativeResidualNorm_pre( precision, solver, rel_resid_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetAMGOptions( HYPRE_Solver solver, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_long_double strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetAMGOptions_pre( precision, solver, coarsen_type, agg_levels, relax_type, strength_threshold, interp_type, Pmax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetAMSOptions( HYPRE_Solver solver, HYPRE_Int cycle_type, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_long_double strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetAMSOptions_pre( precision, solver, cycle_type, coarsen_type, agg_levels, relax_type, strength_threshold, interp_type, Pmax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetChebySmoothingOptions( HYPRE_Solver solver, HYPRE_Int cheby_order, hypre_long_double cheby_fraction )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetChebySmoothingOptions_pre( precision, solver, cheby_order, cheby_fraction );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetCoordinateVectors( HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetCoordinateVectors_pre( precision, solver, x, y, z );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetCycleType( HYPRE_Solver solver, HYPRE_Int cycle_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetCycleType_pre( precision, solver, cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetDiscreteCurl( HYPRE_Solver solver, HYPRE_ParCSRMatrix C )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetDiscreteCurl_pre( precision, solver, C );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetDiscreteGradient( HYPRE_Solver solver, HYPRE_ParCSRMatrix G )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetDiscreteGradient_pre( precision, solver, G );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetInterpolations( HYPRE_Solver solver, HYPRE_ParCSRMatrix RT_Pi, HYPRE_ParCSRMatrix RT_Pix, HYPRE_ParCSRMatrix RT_Piy, HYPRE_ParCSRMatrix RT_Piz, HYPRE_ParCSRMatrix ND_Pi, HYPRE_ParCSRMatrix ND_Pix, HYPRE_ParCSRMatrix ND_Piy, HYPRE_ParCSRMatrix ND_Piz )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetInterpolations_pre( precision, solver, RT_Pi, RT_Pix, RT_Piy, RT_Piz, ND_Pi, ND_Pix, ND_Piy, ND_Piz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetMaxIter( HYPRE_Solver solver, HYPRE_Int maxit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetMaxIter_pre( precision, solver, maxit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetSmoothingOptions( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_long_double relax_weight, hypre_long_double omega )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetSmoothingOptions_pre( precision, solver, relax_type, relax_times, relax_weight, omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ADSSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMECreate( HYPRE_Solver *esolver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMECreate_pre( precision, esolver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMEDestroy( HYPRE_Solver esolver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMEDestroy_pre( precision, esolver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMEGetEigenvalues( HYPRE_Solver esolver, void *eigenvalues )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMEGetEigenvalues_pre( precision, esolver, eigenvalues );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMEGetEigenvectors( HYPRE_Solver esolver, HYPRE_ParVector **eigenvectors )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMEGetEigenvectors_pre( precision, esolver, eigenvectors );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetAMSSolver( HYPRE_Solver esolver, HYPRE_Solver ams_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMESetAMSSolver_pre( precision, esolver, ams_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetBlockSize( HYPRE_Solver esolver, HYPRE_Int block_size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMESetBlockSize_pre( precision, esolver, block_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetMassMatrix( HYPRE_Solver esolver, HYPRE_ParCSRMatrix M )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMESetMassMatrix_pre( precision, esolver, M );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetMaxIter( HYPRE_Solver esolver, HYPRE_Int maxit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMESetMaxIter_pre( precision, esolver, maxit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetMaxPCGIter( HYPRE_Solver esolver, HYPRE_Int maxit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMESetMaxPCGIter_pre( precision, esolver, maxit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetPrintLevel( HYPRE_Solver esolver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMESetPrintLevel_pre( precision, esolver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetRTol( HYPRE_Solver esolver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMESetRTol_pre( precision, esolver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetTol( HYPRE_Solver esolver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMESetTol_pre( precision, esolver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetup( HYPRE_Solver esolver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMESetup_pre( precision, esolver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESolve( HYPRE_Solver esolver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMESolve_pre( precision, esolver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSConstructDiscreteGradient( HYPRE_ParCSRMatrix A, HYPRE_ParVector x_coord, HYPRE_BigInt *edge_vertex, HYPRE_Int edge_orientation, HYPRE_ParCSRMatrix *G )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSConstructDiscreteGradient_pre( precision, A, x_coord, edge_vertex, edge_orientation, G );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSCreate( HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSCreate_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *rel_resid_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSGetFinalRelativeResidualNorm_pre( precision, solver, rel_resid_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSProjectOutGradients( HYPRE_Solver solver, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSProjectOutGradients_pre( precision, solver, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetAlphaAMGCoarseRelaxType( HYPRE_Solver solver, HYPRE_Int alpha_coarse_relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetAlphaAMGCoarseRelaxType_pre( precision, solver, alpha_coarse_relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetAlphaAMGOptions( HYPRE_Solver solver, HYPRE_Int alpha_coarsen_type, HYPRE_Int alpha_agg_levels, HYPRE_Int alpha_relax_type, hypre_long_double alpha_strength_threshold, HYPRE_Int alpha_interp_type, HYPRE_Int alpha_Pmax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetAlphaAMGOptions_pre( precision, solver, alpha_coarsen_type, alpha_agg_levels, alpha_relax_type, alpha_strength_threshold, alpha_interp_type, alpha_Pmax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetAlphaPoissonMatrix( HYPRE_Solver solver, HYPRE_ParCSRMatrix A_alpha )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetAlphaPoissonMatrix_pre( precision, solver, A_alpha );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetBetaAMGCoarseRelaxType( HYPRE_Solver solver, HYPRE_Int beta_coarse_relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetBetaAMGCoarseRelaxType_pre( precision, solver, beta_coarse_relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetBetaAMGOptions( HYPRE_Solver solver, HYPRE_Int beta_coarsen_type, HYPRE_Int beta_agg_levels, HYPRE_Int beta_relax_type, hypre_long_double beta_strength_threshold, HYPRE_Int beta_interp_type, HYPRE_Int beta_Pmax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetBetaAMGOptions_pre( precision, solver, beta_coarsen_type, beta_agg_levels, beta_relax_type, beta_strength_threshold, beta_interp_type, beta_Pmax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetBetaPoissonMatrix( HYPRE_Solver solver, HYPRE_ParCSRMatrix A_beta )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetBetaPoissonMatrix_pre( precision, solver, A_beta );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetCoordinateVectors( HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetCoordinateVectors_pre( precision, solver, x, y, z );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetCycleType( HYPRE_Solver solver, HYPRE_Int cycle_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetCycleType_pre( precision, solver, cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetDimension( HYPRE_Solver solver, HYPRE_Int dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetDimension_pre( precision, solver, dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetDiscreteGradient( HYPRE_Solver solver, HYPRE_ParCSRMatrix G )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetDiscreteGradient_pre( precision, solver, G );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetEdgeConstantVectors( HYPRE_Solver solver, HYPRE_ParVector Gx, HYPRE_ParVector Gy, HYPRE_ParVector Gz )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetEdgeConstantVectors_pre( precision, solver, Gx, Gy, Gz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetInteriorNodes( HYPRE_Solver solver, HYPRE_ParVector interior_nodes )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetInteriorNodes_pre( precision, solver, interior_nodes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetInterpolations( HYPRE_Solver solver, HYPRE_ParCSRMatrix Pi, HYPRE_ParCSRMatrix Pix, HYPRE_ParCSRMatrix Piy, HYPRE_ParCSRMatrix Piz )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetInterpolations_pre( precision, solver, Pi, Pix, Piy, Piz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetMaxIter( HYPRE_Solver solver, HYPRE_Int maxit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetMaxIter_pre( precision, solver, maxit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetProjectionFrequency( HYPRE_Solver solver, HYPRE_Int projection_frequency )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetProjectionFrequency_pre( precision, solver, projection_frequency );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetSmoothingOptions( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_long_double relax_weight, hypre_long_double omega )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetSmoothingOptions_pre( precision, solver, relax_type, relax_times, relax_weight, omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AMSSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagCreate( HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BlockTridiagCreate_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BlockTridiagDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSetAMGNumSweeps( HYPRE_Solver solver, HYPRE_Int num_sweeps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BlockTridiagSetAMGNumSweeps_pre( precision, solver, num_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSetAMGRelaxType( HYPRE_Solver solver, HYPRE_Int relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BlockTridiagSetAMGRelaxType_pre( precision, solver, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSetAMGStrengthThreshold( HYPRE_Solver solver, hypre_long_double thresh )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BlockTridiagSetAMGStrengthThreshold_pre( precision, solver, thresh );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSetIndexSet( HYPRE_Solver solver, HYPRE_Int n, HYPRE_Int *inds )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BlockTridiagSetIndexSet_pre( precision, solver, n, inds );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BlockTridiagSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BlockTridiagSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BlockTridiagSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGCreate( HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGCreate_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDCreate( HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDCreate_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDGetAMG( HYPRE_Solver solver, HYPRE_Solver *amg_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDGetAMG_pre( precision, solver, amg_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *rel_resid_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDGetFinalRelativeResidualNorm_pre( precision, solver, rel_resid_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetFACCycleType( HYPRE_Solver solver, HYPRE_Int amgdd_fac_cycle_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDSetFACCycleType_pre( precision, solver, amgdd_fac_cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumCycles( HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_cycles )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDSetFACNumCycles_pre( precision, solver, amgdd_fac_num_cycles );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumRelax( HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDSetFACNumRelax_pre( precision, solver, amgdd_fac_num_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxType( HYPRE_Solver solver, HYPRE_Int amgdd_fac_relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDSetFACRelaxType_pre( precision, solver, amgdd_fac_relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxWeight( HYPRE_Solver solver, hypre_long_double amgdd_fac_relax_weight )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDSetFACRelaxWeight_pre( precision, solver, amgdd_fac_relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetNumGhostLayers( HYPRE_Solver solver, HYPRE_Int num_ghost_layers )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDSetNumGhostLayers_pre( precision, solver, num_ghost_layers );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetPadding( HYPRE_Solver solver, HYPRE_Int padding )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDSetPadding_pre( precision, solver, padding );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetStartLevel( HYPRE_Solver solver, HYPRE_Int start_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDSetStartLevel_pre( precision, solver, start_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDDSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetAdditive( HYPRE_Solver solver, HYPRE_Int *additive )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetAdditive_pre( precision, solver, additive );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCoarsenCutFactor( HYPRE_Solver solver, HYPRE_Int *coarsen_cut_factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetCoarsenCutFactor_pre( precision, solver, coarsen_cut_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCoarsenType( HYPRE_Solver solver, HYPRE_Int *coarsen_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetCoarsenType_pre( precision, solver, coarsen_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetConvergeType( HYPRE_Solver solver, HYPRE_Int *type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetConvergeType_pre( precision, solver, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCumNnzAP( HYPRE_Solver solver, void *cum_nnz_AP )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetCumNnzAP_pre( precision, solver, cum_nnz_AP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCumNumIterations( HYPRE_Solver solver, HYPRE_Int *cum_num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetCumNumIterations_pre( precision, solver, cum_num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCycleNumSweeps( HYPRE_Solver solver, HYPRE_Int *num_sweeps, HYPRE_Int k )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetCycleNumSweeps_pre( precision, solver, num_sweeps, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCycleRelaxType( HYPRE_Solver solver, HYPRE_Int *relax_type, HYPRE_Int k )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetCycleRelaxType_pre( precision, solver, relax_type, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCycleType( HYPRE_Solver solver, HYPRE_Int *cycle_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetCycleType_pre( precision, solver, cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetDebugFlag( HYPRE_Solver solver, HYPRE_Int *debug_flag )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetDebugFlag_pre( precision, solver, debug_flag );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetDomainType( HYPRE_Solver solver, HYPRE_Int *domain_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetDomainType_pre( precision, solver, domain_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetFCycle( HYPRE_Solver solver, HYPRE_Int *fcycle )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetFCycle_pre( precision, solver, fcycle );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetFilterFunctions( HYPRE_Solver solver, HYPRE_Int *filter_functions )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetFilterFunctions_pre( precision, solver, filter_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetFilterThresholdR( HYPRE_Solver solver, void *filter_threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetFilterThresholdR_pre( precision, solver, filter_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *rel_resid_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetFinalRelativeResidualNorm_pre( precision, solver, rel_resid_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetGridHierarchy( HYPRE_Solver solver, HYPRE_Int *cgrid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetGridHierarchy_pre( precision, solver, cgrid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetJacobiTruncThreshold( HYPRE_Solver solver, void *jacobi_trunc_threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetJacobiTruncThreshold_pre( precision, solver, jacobi_trunc_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetLogging( HYPRE_Solver solver, HYPRE_Int *logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMaxCoarseSize( HYPRE_Solver solver, HYPRE_Int *max_coarse_size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetMaxCoarseSize_pre( precision, solver, max_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMaxIter( HYPRE_Solver solver, HYPRE_Int *max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMaxLevels( HYPRE_Solver solver, HYPRE_Int *max_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetMaxLevels_pre( precision, solver, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMaxRowSum( HYPRE_Solver solver, void *max_row_sum )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetMaxRowSum_pre( precision, solver, max_row_sum );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMeasureType( HYPRE_Solver solver, HYPRE_Int *measure_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetMeasureType_pre( precision, solver, measure_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMinCoarseSize( HYPRE_Solver solver, HYPRE_Int *min_coarse_size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetMinCoarseSize_pre( precision, solver, min_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMultAdditive( HYPRE_Solver solver, HYPRE_Int *mult_additive )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetMultAdditive_pre( precision, solver, mult_additive );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetNumFunctions( HYPRE_Solver solver, HYPRE_Int *num_functions )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetNumFunctions_pre( precision, solver, num_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetOverlap( HYPRE_Solver solver, HYPRE_Int *overlap )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetOverlap_pre( precision, solver, overlap );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetPMaxElmts( HYPRE_Solver solver, HYPRE_Int *P_max_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetPMaxElmts_pre( precision, solver, P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetPostInterpType( HYPRE_Solver solver, HYPRE_Int *post_interp_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetPostInterpType_pre( precision, solver, post_interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetPrintLevel( HYPRE_Solver solver, HYPRE_Int *print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetRedundant( HYPRE_Solver solver, HYPRE_Int *redundant )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetRedundant_pre( precision, solver, redundant );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetSchwarzRlxWeight( HYPRE_Solver solver, void *schwarz_rlx_weight )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetSchwarzRlxWeight_pre( precision, solver, schwarz_rlx_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetSeqThreshold( HYPRE_Solver solver, HYPRE_Int *seq_threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetSeqThreshold_pre( precision, solver, seq_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetSimple( HYPRE_Solver solver, HYPRE_Int *simple )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetSimple_pre( precision, solver, simple );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumLevels( HYPRE_Solver solver, HYPRE_Int *smooth_num_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetSmoothNumLevels_pre( precision, solver, smooth_num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumSweeps( HYPRE_Solver solver, HYPRE_Int *smooth_num_sweeps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetSmoothNumSweeps_pre( precision, solver, smooth_num_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetSmoothType( HYPRE_Solver solver, HYPRE_Int *smooth_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetSmoothType_pre( precision, solver, smooth_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetStrongThreshold( HYPRE_Solver solver, void *strong_threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetStrongThreshold_pre( precision, solver, strong_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetStrongThresholdR( HYPRE_Solver solver, void *strong_threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetStrongThresholdR_pre( precision, solver, strong_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetTol( HYPRE_Solver solver, void *tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetTruncFactor( HYPRE_Solver solver, void *trunc_factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetTruncFactor_pre( precision, solver, trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetVariant( HYPRE_Solver solver, HYPRE_Int *variant )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGGetVariant_pre( precision, solver, variant );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGInitGridRelaxation( HYPRE_Int **num_grid_sweeps_ptr, HYPRE_Int **grid_relax_type_ptr, HYPRE_Int ***grid_relax_points_ptr, HYPRE_Int coarsen_type, void *relax_weights_ptr, HYPRE_Int max_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGInitGridRelaxation_pre( precision, num_grid_sweeps_ptr, grid_relax_type_ptr, grid_relax_points_ptr, coarsen_type, relax_weights_ptr, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetADropTol( HYPRE_Solver solver, hypre_long_double A_drop_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetADropTol_pre( precision, solver, A_drop_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetADropType( HYPRE_Solver solver, HYPRE_Int A_drop_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetADropType_pre( precision, solver, A_drop_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAddLastLvl( HYPRE_Solver solver, HYPRE_Int add_last_lvl )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetAddLastLvl_pre( precision, solver, add_last_lvl );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAddPMaxElmts( HYPRE_Solver solver, HYPRE_Int add_P_max_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetAddPMaxElmts_pre( precision, solver, add_P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxType( HYPRE_Solver solver, HYPRE_Int add_rlx_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetAddRelaxType_pre( precision, solver, add_rlx_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxWt( HYPRE_Solver solver, hypre_long_double add_rlx_wt )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetAddRelaxWt_pre( precision, solver, add_rlx_wt );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAddTruncFactor( HYPRE_Solver solver, hypre_long_double add_trunc_factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetAddTruncFactor_pre( precision, solver, add_trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAdditive( HYPRE_Solver solver, HYPRE_Int addlvl )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetAdditive_pre( precision, solver, addlvl );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAggInterpType( HYPRE_Solver solver, HYPRE_Int agg_interp_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetAggInterpType_pre( precision, solver, agg_interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAggNumLevels( HYPRE_Solver solver, HYPRE_Int agg_num_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetAggNumLevels_pre( precision, solver, agg_num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAggP12MaxElmts( HYPRE_Solver solver, HYPRE_Int agg_P12_max_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetAggP12MaxElmts_pre( precision, solver, agg_P12_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAggP12TruncFactor( HYPRE_Solver solver, hypre_long_double agg_P12_trunc_factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetAggP12TruncFactor_pre( precision, solver, agg_P12_trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAggPMaxElmts( HYPRE_Solver solver, HYPRE_Int agg_P_max_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetAggPMaxElmts_pre( precision, solver, agg_P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAggTruncFactor( HYPRE_Solver solver, hypre_long_double agg_trunc_factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetAggTruncFactor_pre( precision, solver, agg_trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCGCIts( HYPRE_Solver solver, HYPRE_Int its )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCGCIts_pre( precision, solver, its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCPoints( HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCPoints_pre( precision, solver, cpt_coarse_level, num_cpt_coarse, cpt_coarse_index );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCRRate( HYPRE_Solver solver, hypre_long_double CR_rate )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCRRate_pre( precision, solver, CR_rate );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCRStrongTh( HYPRE_Solver solver, hypre_long_double CR_strong_th )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCRStrongTh_pre( precision, solver, CR_strong_th );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCRUseCG( HYPRE_Solver solver, HYPRE_Int CR_use_CG )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCRUseCG_pre( precision, solver, CR_use_CG );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetChebyEigEst( HYPRE_Solver solver, HYPRE_Int eig_est )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetChebyEigEst_pre( precision, solver, eig_est );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetChebyFraction( HYPRE_Solver solver, hypre_long_double ratio )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetChebyFraction_pre( precision, solver, ratio );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetChebyOrder( HYPRE_Solver solver, HYPRE_Int order )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetChebyOrder_pre( precision, solver, order );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetChebyScale( HYPRE_Solver solver, HYPRE_Int scale )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetChebyScale_pre( precision, solver, scale );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetChebyVariant( HYPRE_Solver solver, HYPRE_Int variant )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetChebyVariant_pre( precision, solver, variant );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCoarsenCutFactor( HYPRE_Solver solver, HYPRE_Int coarsen_cut_factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCoarsenCutFactor_pre( precision, solver, coarsen_cut_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCoarsenType( HYPRE_Solver solver, HYPRE_Int coarsen_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCoarsenType_pre( precision, solver, coarsen_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetConvergeType( HYPRE_Solver solver, HYPRE_Int type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetConvergeType_pre( precision, solver, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCoordDim( HYPRE_Solver solver, HYPRE_Int coorddim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCoordDim_pre( precision, solver, coorddim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCoordinates( HYPRE_Solver solver, float *coordinates )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCoordinates_pre( precision, solver, coordinates );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCpointsToKeep( HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCpointsToKeep_pre( precision, solver, cpt_coarse_level, num_cpt_coarse, cpt_coarse_index );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCumNnzAP( HYPRE_Solver solver, hypre_long_double cum_nnz_AP )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCumNnzAP_pre( precision, solver, cum_nnz_AP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCycleNumSweeps( HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCycleNumSweeps_pre( precision, solver, num_sweeps, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCycleRelaxType( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCycleRelaxType_pre( precision, solver, relax_type, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCycleType( HYPRE_Solver solver, HYPRE_Int cycle_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetCycleType_pre( precision, solver, cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetDebugFlag( HYPRE_Solver solver, HYPRE_Int debug_flag )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetDebugFlag_pre( precision, solver, debug_flag );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetDofFunc( HYPRE_Solver solver, HYPRE_Int *dof_func )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetDofFunc_pre( precision, solver, dof_func );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetDomainType( HYPRE_Solver solver, HYPRE_Int domain_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetDomainType_pre( precision, solver, domain_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetDropTol( HYPRE_Solver solver, hypre_long_double drop_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetDropTol_pre( precision, solver, drop_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetEuBJ( HYPRE_Solver solver, HYPRE_Int eu_bj )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetEuBJ_pre( precision, solver, eu_bj );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetEuLevel( HYPRE_Solver solver, HYPRE_Int eu_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetEuLevel_pre( precision, solver, eu_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetEuSparseA( HYPRE_Solver solver, hypre_long_double eu_sparse_A )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetEuSparseA_pre( precision, solver, eu_sparse_A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetEuclidFile( HYPRE_Solver solver, char *euclidfile )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetEuclidFile_pre( precision, solver, euclidfile );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFCycle( HYPRE_Solver solver, HYPRE_Int fcycle )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFCycle_pre( precision, solver, fcycle );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFPoints( HYPRE_Solver solver, HYPRE_Int num_fpt, HYPRE_BigInt *fpt_index )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFPoints_pre( precision, solver, num_fpt, fpt_index );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIAlgoType( HYPRE_Solver solver, HYPRE_Int algo_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFSAIAlgoType_pre( precision, solver, algo_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIEigMaxIters( HYPRE_Solver solver, HYPRE_Int eig_max_iters )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFSAIEigMaxIters_pre( precision, solver, eig_max_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIKapTolerance( HYPRE_Solver solver, hypre_long_double kap_tolerance )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFSAIKapTolerance_pre( precision, solver, kap_tolerance );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAILocalSolveType( HYPRE_Solver solver, HYPRE_Int local_solve_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFSAILocalSolveType_pre( precision, solver, local_solve_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxNnzRow( HYPRE_Solver solver, HYPRE_Int max_nnz_row )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFSAIMaxNnzRow_pre( precision, solver, max_nnz_row );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxStepSize( HYPRE_Solver solver, HYPRE_Int max_step_size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFSAIMaxStepSize_pre( precision, solver, max_step_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxSteps( HYPRE_Solver solver, HYPRE_Int max_steps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFSAIMaxSteps_pre( precision, solver, max_steps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAINumLevels( HYPRE_Solver solver, HYPRE_Int num_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFSAINumLevels_pre( precision, solver, num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIThreshold( HYPRE_Solver solver, hypre_long_double threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFSAIThreshold_pre( precision, solver, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFilter( HYPRE_Solver solver, hypre_long_double filter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFilter_pre( precision, solver, filter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFilterFunctions( HYPRE_Solver solver, HYPRE_Int filter_functions )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFilterFunctions_pre( precision, solver, filter_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFilterThresholdR( HYPRE_Solver solver, hypre_long_double filter_threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetFilterThresholdR_pre( precision, solver, filter_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetGMRESSwitchR( HYPRE_Solver solver, HYPRE_Int gmres_switch )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetGMRESSwitchR_pre( precision, solver, gmres_switch );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetGSMG( HYPRE_Solver solver, HYPRE_Int gsmg )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetGSMG_pre( precision, solver, gsmg );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxPoints( HYPRE_Solver solver, HYPRE_Int **grid_relax_points )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetGridRelaxPoints_pre( precision, solver, grid_relax_points );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxType( HYPRE_Solver solver, HYPRE_Int *grid_relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetGridRelaxType_pre( precision, solver, grid_relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUDroptol( HYPRE_Solver solver, hypre_long_double ilu_droptol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILUDroptol_pre( precision, solver, ilu_droptol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupMaxIter( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILUIterSetupMaxIter_pre( precision, solver, ilu_iter_setup_max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupOption( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_option )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILUIterSetupOption_pre( precision, solver, ilu_iter_setup_option );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupTolerance( HYPRE_Solver solver, hypre_long_double ilu_iter_setup_tolerance )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILUIterSetupTolerance_pre( precision, solver, ilu_iter_setup_tolerance );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupType( HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILUIterSetupType_pre( precision, solver, ilu_iter_setup_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILULevel( HYPRE_Solver solver, HYPRE_Int ilu_lfil )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILULevel_pre( precision, solver, ilu_lfil );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILULocalReordering( HYPRE_Solver solver, HYPRE_Int ilu_reordering_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILULocalReordering_pre( precision, solver, ilu_reordering_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILULowerJacobiIters( HYPRE_Solver solver, HYPRE_Int ilu_lower_jacobi_iters )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILULowerJacobiIters_pre( precision, solver, ilu_lower_jacobi_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUMaxIter( HYPRE_Solver solver, HYPRE_Int ilu_max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILUMaxIter_pre( precision, solver, ilu_max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUMaxRowNnz( HYPRE_Solver solver, HYPRE_Int ilu_max_row_nnz )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILUMaxRowNnz_pre( precision, solver, ilu_max_row_nnz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUTriSolve( HYPRE_Solver solver, HYPRE_Int ilu_tri_solve )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILUTriSolve_pre( precision, solver, ilu_tri_solve );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUType( HYPRE_Solver solver, HYPRE_Int ilu_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILUType_pre( precision, solver, ilu_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUUpperJacobiIters( HYPRE_Solver solver, HYPRE_Int ilu_upper_jacobi_iters )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetILUUpperJacobiIters_pre( precision, solver, ilu_upper_jacobi_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetISType( HYPRE_Solver solver, HYPRE_Int IS_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetISType_pre( precision, solver, IS_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetInterpRefine( HYPRE_Solver solver, HYPRE_Int num_refine )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetInterpRefine_pre( precision, solver, num_refine );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetInterpType( HYPRE_Solver solver, HYPRE_Int interp_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetInterpType_pre( precision, solver, interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetInterpVecAbsQTrunc( HYPRE_Solver solver, hypre_long_double q_trunc )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetInterpVecAbsQTrunc_pre( precision, solver, q_trunc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetInterpVecQMax( HYPRE_Solver solver, HYPRE_Int q_max )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetInterpVecQMax_pre( precision, solver, q_max );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetInterpVecVariant( HYPRE_Solver solver, HYPRE_Int var )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetInterpVecVariant_pre( precision, solver, var );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetInterpVectors( HYPRE_Solver solver, HYPRE_Int num_vectors, HYPRE_ParVector *interp_vectors )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetInterpVectors_pre( precision, solver, num_vectors, interp_vectors );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetIsTriangular( HYPRE_Solver solver, HYPRE_Int is_triangular )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetIsTriangular_pre( precision, solver, is_triangular );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetIsolatedFPoints( HYPRE_Solver solver, HYPRE_Int num_isolated_fpt, HYPRE_BigInt *isolated_fpt_index )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetIsolatedFPoints_pre( precision, solver, num_isolated_fpt, isolated_fpt_index );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetJacobiTruncThreshold( HYPRE_Solver solver, hypre_long_double jacobi_trunc_threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetJacobiTruncThreshold_pre( precision, solver, jacobi_trunc_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetKeepSameSign( HYPRE_Solver solver, HYPRE_Int keep_same_sign )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetKeepSameSign_pre( precision, solver, keep_same_sign );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetKeepTranspose( HYPRE_Solver solver, HYPRE_Int keepTranspose )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetKeepTranspose_pre( precision, solver, keepTranspose );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetLevel( HYPRE_Solver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetLevelNonGalerkinTol( HYPRE_Solver solver, hypre_long_double nongalerkin_tol, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetLevelNonGalerkinTol_pre( precision, solver, nongalerkin_tol, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetLevelOuterWt( HYPRE_Solver solver, hypre_long_double omega, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetLevelOuterWt_pre( precision, solver, omega, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetLevelRelaxWt( HYPRE_Solver solver, hypre_long_double relax_weight, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetLevelRelaxWt_pre( precision, solver, relax_weight, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMaxCoarseSize( HYPRE_Solver solver, HYPRE_Int max_coarse_size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetMaxCoarseSize_pre( precision, solver, max_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMaxLevels( HYPRE_Solver solver, HYPRE_Int max_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetMaxLevels_pre( precision, solver, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMaxNzPerRow( HYPRE_Solver solver, HYPRE_Int max_nz_per_row )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetMaxNzPerRow_pre( precision, solver, max_nz_per_row );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMaxRowSum( HYPRE_Solver solver, hypre_long_double max_row_sum )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetMaxRowSum_pre( precision, solver, max_row_sum );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMeasureType( HYPRE_Solver solver, HYPRE_Int measure_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetMeasureType_pre( precision, solver, measure_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMinCoarseSize( HYPRE_Solver solver, HYPRE_Int min_coarse_size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetMinCoarseSize_pre( precision, solver, min_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetModuleRAP2( HYPRE_Solver solver, HYPRE_Int mod_rap2 )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetModuleRAP2_pre( precision, solver, mod_rap2 );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMultAddPMaxElmts( HYPRE_Solver solver, HYPRE_Int add_P_max_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetMultAddPMaxElmts_pre( precision, solver, add_P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMultAddTruncFactor( HYPRE_Solver solver, hypre_long_double add_trunc_factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetMultAddTruncFactor_pre( precision, solver, add_trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMultAdditive( HYPRE_Solver solver, HYPRE_Int addlvl )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetMultAdditive_pre( precision, solver, addlvl );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNodal( HYPRE_Solver solver, HYPRE_Int nodal )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetNodal_pre( precision, solver, nodal );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNodalDiag( HYPRE_Solver solver, HYPRE_Int nodal_diag )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetNodalDiag_pre( precision, solver, nodal_diag );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNodalLevels( HYPRE_Solver solver, HYPRE_Int nodal_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetNodalLevels_pre( precision, solver, nodal_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkTol( HYPRE_Solver solver, HYPRE_Int nongalerk_num_tol, void *nongalerk_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetNonGalerkTol_pre( precision, solver, nongalerk_num_tol, nongalerk_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkinTol( HYPRE_Solver solver, hypre_long_double nongalerkin_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetNonGalerkinTol_pre( precision, solver, nongalerkin_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNumCRRelaxSteps( HYPRE_Solver solver, HYPRE_Int num_CR_relax_steps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetNumCRRelaxSteps_pre( precision, solver, num_CR_relax_steps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNumFunctions( HYPRE_Solver solver, HYPRE_Int num_functions )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetNumFunctions_pre( precision, solver, num_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNumGridSweeps( HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetNumGridSweeps_pre( precision, solver, num_grid_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNumPaths( HYPRE_Solver solver, HYPRE_Int num_paths )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetNumPaths_pre( precision, solver, num_paths );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNumSamples( HYPRE_Solver solver, HYPRE_Int num_samples )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetNumSamples_pre( precision, solver, num_samples );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNumSweeps( HYPRE_Solver solver, HYPRE_Int num_sweeps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetNumSweeps_pre( precision, solver, num_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetOldDefault( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetOldDefault_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetOmega( HYPRE_Solver solver, void *omega )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetOmega_pre( precision, solver, omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetOuterWt( HYPRE_Solver solver, hypre_long_double omega )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetOuterWt_pre( precision, solver, omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetOverlap( HYPRE_Solver solver, HYPRE_Int overlap )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetOverlap_pre( precision, solver, overlap );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetPMaxElmts( HYPRE_Solver solver, HYPRE_Int P_max_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetPMaxElmts_pre( precision, solver, P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetPlotFileName( HYPRE_Solver solver, const char *plotfilename )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetPlotFileName_pre( precision, solver, plotfilename );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetPlotGrids( HYPRE_Solver solver, HYPRE_Int plotgrids )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetPlotGrids_pre( precision, solver, plotgrids );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetPostInterpType( HYPRE_Solver solver, HYPRE_Int post_interp_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetPostInterpType_pre( precision, solver, post_interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetPrintFileName( HYPRE_Solver solver, const char *print_file_name )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetPrintFileName_pre( precision, solver, print_file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRAP2( HYPRE_Solver solver, HYPRE_Int rap2 )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetRAP2_pre( precision, solver, rap2 );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRedundant( HYPRE_Solver solver, HYPRE_Int redundant )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetRedundant_pre( precision, solver, redundant );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRelaxOrder( HYPRE_Solver solver, HYPRE_Int relax_order )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetRelaxOrder_pre( precision, solver, relax_order );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRelaxType( HYPRE_Solver solver, HYPRE_Int relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetRelaxType_pre( precision, solver, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRelaxWeight( HYPRE_Solver solver, void *relax_weight )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetRelaxWeight_pre( precision, solver, relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRelaxWt( HYPRE_Solver solver, hypre_long_double relax_weight )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetRelaxWt_pre( precision, solver, relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRestriction( HYPRE_Solver solver, HYPRE_Int restr_par )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetRestriction_pre( precision, solver, restr_par );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSCommPkgSwitch( HYPRE_Solver solver, hypre_long_double S_commpkg_switch )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSCommPkgSwitch_pre( precision, solver, S_commpkg_switch );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSabs( HYPRE_Solver solver, HYPRE_Int Sabs )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSabs_pre( precision, solver, Sabs );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSchwarzRlxWeight( HYPRE_Solver solver, hypre_long_double schwarz_rlx_weight )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSchwarzRlxWeight_pre( precision, solver, schwarz_rlx_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSchwarzUseNonSymm( HYPRE_Solver solver, HYPRE_Int use_nonsymm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSchwarzUseNonSymm_pre( precision, solver, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSepWeight( HYPRE_Solver solver, HYPRE_Int sep_weight )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSepWeight_pre( precision, solver, sep_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSeqThreshold( HYPRE_Solver solver, HYPRE_Int seq_threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSeqThreshold_pre( precision, solver, seq_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSetupType( HYPRE_Solver solver, HYPRE_Int setup_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSetupType_pre( precision, solver, setup_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSimple( HYPRE_Solver solver, HYPRE_Int addlvl )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSimple_pre( precision, solver, addlvl );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSmoothInterpVectors( HYPRE_Solver solver, HYPRE_Int smooth_interp_vectors )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSmoothInterpVectors_pre( precision, solver, smooth_interp_vectors );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumLevels( HYPRE_Solver solver, HYPRE_Int smooth_num_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSmoothNumLevels_pre( precision, solver, smooth_num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumSweeps( HYPRE_Solver solver, HYPRE_Int smooth_num_sweeps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSmoothNumSweeps_pre( precision, solver, smooth_num_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSmoothType( HYPRE_Solver solver, HYPRE_Int smooth_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSmoothType_pre( precision, solver, smooth_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetStrongThreshold( HYPRE_Solver solver, hypre_long_double strong_threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetStrongThreshold_pre( precision, solver, strong_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetStrongThresholdR( HYPRE_Solver solver, hypre_long_double strong_threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetStrongThresholdR_pre( precision, solver, strong_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSym( HYPRE_Solver solver, HYPRE_Int sym )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetSym_pre( precision, solver, sym );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetThreshold( HYPRE_Solver solver, hypre_long_double threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetThreshold_pre( precision, solver, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetTruncFactor( HYPRE_Solver solver, hypre_long_double trunc_factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetTruncFactor_pre( precision, solver, trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetVariant( HYPRE_Solver solver, HYPRE_Int variant )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetVariant_pre( precision, solver, variant );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSolveT( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BoomerAMGSolveT_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidCreate( MPI_Comm comm, HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetBJ( HYPRE_Solver solver, HYPRE_Int bj )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidSetBJ_pre( precision, solver, bj );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetILUT( HYPRE_Solver solver, hypre_long_double drop_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidSetILUT_pre( precision, solver, drop_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetLevel( HYPRE_Solver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidSetLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetMem( HYPRE_Solver solver, HYPRE_Int eu_mem )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidSetMem_pre( precision, solver, eu_mem );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetParams( HYPRE_Solver solver, HYPRE_Int argc, char *argv[] )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidSetParams_pre( precision, solver, argc, argv );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetParamsFromFile( HYPRE_Solver solver, char *filename )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidSetParamsFromFile_pre( precision, solver, filename );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetRowScale( HYPRE_Solver solver, HYPRE_Int row_scale )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidSetRowScale_pre( precision, solver, row_scale );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetSparseA( HYPRE_Solver solver, hypre_long_double sparse_A )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidSetSparseA_pre( precision, solver, sparse_A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetStats( HYPRE_Solver solver, HYPRE_Int eu_stats )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidSetStats_pre( precision, solver, eu_stats );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_EuclidSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAICreate( HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAICreate_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAIDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAIDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetAlgoType( HYPRE_Solver solver, HYPRE_Int algo_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetAlgoType_pre( precision, solver, algo_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetEigMaxIters( HYPRE_Solver solver, HYPRE_Int eig_max_iters )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetEigMaxIters_pre( precision, solver, eig_max_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetKapTolerance( HYPRE_Solver solver, hypre_long_double kap_tolerance )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetKapTolerance_pre( precision, solver, kap_tolerance );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetLocalSolveType( HYPRE_Solver solver, HYPRE_Int local_solve_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetLocalSolveType_pre( precision, solver, local_solve_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetMaxIterations( HYPRE_Solver solver, HYPRE_Int max_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetMaxIterations_pre( precision, solver, max_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetMaxNnzRow( HYPRE_Solver solver, HYPRE_Int max_nnz_row )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetMaxNnzRow_pre( precision, solver, max_nnz_row );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetMaxStepSize( HYPRE_Solver solver, HYPRE_Int max_step_size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetMaxStepSize_pre( precision, solver, max_step_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetMaxSteps( HYPRE_Solver solver, HYPRE_Int max_steps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetMaxSteps_pre( precision, solver, max_steps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetNumLevels( HYPRE_Solver solver, HYPRE_Int num_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetNumLevels_pre( precision, solver, num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetOmega( HYPRE_Solver solver, hypre_long_double omega )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetOmega_pre( precision, solver, omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetThreshold( HYPRE_Solver solver, hypre_long_double threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetThreshold_pre( precision, solver, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetTolerance( HYPRE_Solver solver, hypre_long_double tolerance )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetTolerance_pre( precision, solver, tolerance );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetZeroGuess( HYPRE_Solver solver, HYPRE_Int zero_guess )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetZeroGuess_pre( precision, solver, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FSAISolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUCreate( HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUCreate_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *res_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUGetFinalRelativeResidualNorm_pre( precision, solver, res_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetDropThreshold( HYPRE_Solver solver, hypre_long_double threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetDropThreshold_pre( precision, solver, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetDropThresholdArray( HYPRE_Solver solver, void *threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetDropThresholdArray_pre( precision, solver, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetIterativeSetupMaxIter( HYPRE_Solver solver, HYPRE_Int iter_setup_max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetIterativeSetupMaxIter_pre( precision, solver, iter_setup_max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetIterativeSetupOption( HYPRE_Solver solver, HYPRE_Int iter_setup_option )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetIterativeSetupOption_pre( precision, solver, iter_setup_option );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetIterativeSetupTolerance( HYPRE_Solver solver, hypre_long_double iter_setup_tolerance )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetIterativeSetupTolerance_pre( precision, solver, iter_setup_tolerance );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetIterativeSetupType( HYPRE_Solver solver, HYPRE_Int iter_setup_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetIterativeSetupType_pre( precision, solver, iter_setup_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetLevelOfFill( HYPRE_Solver solver, HYPRE_Int lfil )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetLevelOfFill_pre( precision, solver, lfil );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetLocalReordering( HYPRE_Solver solver, HYPRE_Int reordering_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetLocalReordering_pre( precision, solver, reordering_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetLowerJacobiIters( HYPRE_Solver solver, HYPRE_Int lower_jacobi_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetLowerJacobiIters_pre( precision, solver, lower_jacobi_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetMaxNnzPerRow( HYPRE_Solver solver, HYPRE_Int nzmax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetMaxNnzPerRow_pre( precision, solver, nzmax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetNSHDropThreshold( HYPRE_Solver solver, hypre_long_double threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetNSHDropThreshold_pre( precision, solver, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetNSHDropThresholdArray( HYPRE_Solver solver, void *threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetNSHDropThresholdArray_pre( precision, solver, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetSchurMaxIter( HYPRE_Solver solver, HYPRE_Int ss_max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetSchurMaxIter_pre( precision, solver, ss_max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetTriSolve( HYPRE_Solver solver, HYPRE_Int tri_solve )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetTriSolve_pre( precision, solver, tri_solve );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetType( HYPRE_Solver solver, HYPRE_Int ilu_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetType_pre( precision, solver, ilu_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetUpperJacobiIters( HYPRE_Solver solver, HYPRE_Int upper_jacobi_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetUpperJacobiIters_pre( precision, solver, upper_jacobi_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ILUSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRBuildAff( HYPRE_ParCSRMatrix A, HYPRE_Int *CF_marker, HYPRE_Int debug_flag, HYPRE_ParCSRMatrix *A_ff )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRBuildAff_pre( precision, A, CF_marker, debug_flag, A_ff );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRCreate( HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRCreate_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRGetCoarseGridConvergenceFactor( HYPRE_Solver solver, void *conv_factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRGetCoarseGridConvergenceFactor_pre( precision, solver, conv_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *res_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRGetFinalRelativeResidualNorm_pre( precision, solver, res_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetBlockJacobiBlockSize( HYPRE_Solver solver, HYPRE_Int blk_size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetBlockJacobiBlockSize_pre( precision, solver, blk_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetBlockSize( HYPRE_Solver solver, HYPRE_Int bsize )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetBlockSize_pre( precision, solver, bsize );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetCoarseGridMethod( HYPRE_Solver solver, HYPRE_Int *cg_method )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetCoarseGridMethod_pre( precision, solver, cg_method );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetCoarseGridPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetCoarseGridPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetCoarseSolver( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn coarse_grid_solver_solve, HYPRE_PtrToParSolverFcn coarse_grid_solver_setup, HYPRE_Solver coarse_grid_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetCoarseSolver_pre( precision, solver, coarse_grid_solver_solve, coarse_grid_solver_setup, coarse_grid_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetCpointsByBlock( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetCpointsByBlock_pre( precision, solver, block_size, max_num_levels, num_block_coarse_points, block_coarse_indexes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetCpointsByContiguousBlock( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_BigInt *idx_array, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetCpointsByContiguousBlock_pre( precision, solver, block_size, max_num_levels, idx_array, num_block_coarse_points, block_coarse_indexes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetCpointsByPointMarkerArray( HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **lvl_block_coarse_indexes, HYPRE_Int *point_marker_array )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetCpointsByPointMarkerArray_pre( precision, solver, block_size, max_num_levels, num_block_coarse_points, lvl_block_coarse_indexes, point_marker_array );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetFRelaxMethod( HYPRE_Solver solver, HYPRE_Int relax_method )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetFRelaxMethod_pre( precision, solver, relax_method );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetFSolver( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn fine_grid_solver_solve, HYPRE_PtrToParSolverFcn fine_grid_solver_setup, HYPRE_Solver fsolver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetFSolver_pre( precision, solver, fine_grid_solver_solve, fine_grid_solver_setup, fsolver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetFSolverAtLevel( HYPRE_Solver solver, HYPRE_Solver fsolver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetFSolverAtLevel_pre( precision, solver, fsolver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetFrelaxPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetFrelaxPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetGlobalSmoothCycle( HYPRE_Solver solver, HYPRE_Int global_smooth_cycle )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetGlobalSmoothCycle_pre( precision, solver, global_smooth_cycle );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetGlobalSmoothType( HYPRE_Solver solver, HYPRE_Int smooth_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetGlobalSmoothType_pre( precision, solver, smooth_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetGlobalSmootherAtLevel( HYPRE_Solver solver, HYPRE_Solver smoother, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetGlobalSmootherAtLevel_pre( precision, solver, smoother, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetInterpType( HYPRE_Solver solver, HYPRE_Int interp_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetInterpType_pre( precision, solver, interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelFRelaxMethod( HYPRE_Solver solver, HYPRE_Int *relax_method )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetLevelFRelaxMethod_pre( precision, solver, relax_method );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelFRelaxNumFunctions( HYPRE_Solver solver, HYPRE_Int *num_functions )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetLevelFRelaxNumFunctions_pre( precision, solver, num_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelFRelaxType( HYPRE_Solver solver, HYPRE_Int *relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetLevelFRelaxType_pre( precision, solver, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelInterpType( HYPRE_Solver solver, HYPRE_Int *interp_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetLevelInterpType_pre( precision, solver, interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelNonGalerkinMaxElmts( HYPRE_Solver solver, HYPRE_Int *max_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetLevelNonGalerkinMaxElmts_pre( precision, solver, max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelNumRelaxSweeps( HYPRE_Solver solver, HYPRE_Int *nsweeps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetLevelNumRelaxSweeps_pre( precision, solver, nsweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelPMaxElmts( HYPRE_Solver solver, HYPRE_Int *P_max_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetLevelPMaxElmts_pre( precision, solver, P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelRestrictType( HYPRE_Solver solver, HYPRE_Int *restrict_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetLevelRestrictType_pre( precision, solver, restrict_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelSmoothIters( HYPRE_Solver solver, HYPRE_Int *smooth_iters )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetLevelSmoothIters_pre( precision, solver, smooth_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelSmoothType( HYPRE_Solver solver, HYPRE_Int *smooth_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetLevelSmoothType_pre( precision, solver, smooth_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetMaxCoarseLevels( HYPRE_Solver solver, HYPRE_Int maxlev )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetMaxCoarseLevels_pre( precision, solver, maxlev );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetMaxGlobalSmoothIters( HYPRE_Solver solver, HYPRE_Int smooth_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetMaxGlobalSmoothIters_pre( precision, solver, smooth_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetNonCpointsToFpoints( HYPRE_Solver solver, HYPRE_Int nonCptToFptFlag )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetNonCpointsToFpoints_pre( precision, solver, nonCptToFptFlag );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetNonGalerkinMaxElmts( HYPRE_Solver solver, HYPRE_Int max_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetNonGalerkinMaxElmts_pre( precision, solver, max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetNumInterpSweeps( HYPRE_Solver solver, HYPRE_Int nsweeps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetNumInterpSweeps_pre( precision, solver, nsweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetNumRelaxSweeps( HYPRE_Solver solver, HYPRE_Int nsweeps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetNumRelaxSweeps_pre( precision, solver, nsweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetNumRestrictSweeps( HYPRE_Solver solver, HYPRE_Int nsweeps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetNumRestrictSweeps_pre( precision, solver, nsweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetPMaxElmts( HYPRE_Solver solver, HYPRE_Int P_max_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetPMaxElmts_pre( precision, solver, P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetRelaxType( HYPRE_Solver solver, HYPRE_Int relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetRelaxType_pre( precision, solver, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetReservedCoarseNodes( HYPRE_Solver solver, HYPRE_Int reserved_coarse_size, HYPRE_BigInt *reserved_coarse_nodes )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetReservedCoarseNodes_pre( precision, solver, reserved_coarse_size, reserved_coarse_nodes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetReservedCpointsLevelToKeep( HYPRE_Solver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetReservedCpointsLevelToKeep_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetRestrictType( HYPRE_Solver solver, HYPRE_Int restrict_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetRestrictType_pre( precision, solver, restrict_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetTruncateCoarseGridThreshold( HYPRE_Solver solver, hypre_long_double threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetTruncateCoarseGridThreshold_pre( precision, solver, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MGRSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABCreate( MPI_Comm comm, HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABGetPrecond_pre( precision, solver, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABSetAbsoluteTol_pre( precision, solver, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABSetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRBiCGSTABSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRCreate( MPI_Comm comm, HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRGetPrecond_pre( precision, solver, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precondT, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRSetPrecond_pre( precision, solver, precond, precondT, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRSetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCGNRSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESCreate( MPI_Comm comm, HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESGetPrecond_pre( precision, solver, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESSetAbsoluteTol_pre( precision, solver, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetCGS( HYPRE_Solver solver, HYPRE_Int cgs )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESSetCGS_pre( precision, solver, cgs );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetUnroll( HYPRE_Solver solver, HYPRE_Int unroll )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESSetUnroll_pre( precision, solver, unroll );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRCOGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRDiagScale( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRDiagScale_pre( precision, solver, HA, Hy, Hx );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRDiagScaleSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector y, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRDiagScaleSetup_pre( precision, solver, A, y, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESCreate( MPI_Comm comm, HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESGetPrecond_pre( precision, solver, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESSetAbsoluteTol_pre( precision, solver, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetModifyPC( HYPRE_Solver solver, HYPRE_PtrToModifyPCFcn modify_pc )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESSetModifyPC_pre( precision, solver, modify_pc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRFlexGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESCreate( MPI_Comm comm, HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESGetPrecond_pre( precision, solver, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESGetRefSolution( HYPRE_Solver solver, HYPRE_ParVector *ref_solution )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESGetRefSolution_pre( precision, solver, ref_solution );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESSetAbsoluteTol_pre( precision, solver, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetRefSolution( HYPRE_Solver solver, HYPRE_ParVector ref_solution )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESSetRefSolution_pre( precision, solver, ref_solution );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESSetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridCreate( HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridCreate_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetDSCGNumIterations( HYPRE_Solver solver, HYPRE_Int *dscg_num_its )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridGetDSCGNumIterations_pre( precision, solver, dscg_num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_its )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridGetNumIterations_pre( precision, solver, num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetPCGNumIterations( HYPRE_Solver solver, HYPRE_Int *pcg_num_its )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridGetPCGNumIterations_pre( precision, solver, pcg_num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidual( HYPRE_Solver solver, HYPRE_Int *recompute_residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridGetRecomputeResidual_pre( precision, solver, recompute_residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidualP( HYPRE_Solver solver, HYPRE_Int *recompute_residual_p )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridGetRecomputeResidualP_pre( precision, solver, recompute_residual_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetSetupSolveTime( HYPRE_Solver solver, void *time )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridGetSetupSolveTime_pre( precision, solver, time );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetAggInterpType( HYPRE_Solver solver, HYPRE_Int agg_interp_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetAggInterpType_pre( precision, solver, agg_interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetAggNumLevels( HYPRE_Solver solver, HYPRE_Int agg_num_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetAggNumLevels_pre( precision, solver, agg_num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetCoarsenType( HYPRE_Solver solver, HYPRE_Int coarsen_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetCoarsenType_pre( precision, solver, coarsen_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetConvergenceTol( HYPRE_Solver solver, hypre_long_double cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetConvergenceTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetCycleNumSweeps( HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetCycleNumSweeps_pre( precision, solver, num_sweeps, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetCycleRelaxType( HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetCycleRelaxType_pre( precision, solver, relax_type, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetCycleType( HYPRE_Solver solver, HYPRE_Int cycle_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetCycleType_pre( precision, solver, cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetDSCGMaxIter( HYPRE_Solver solver, HYPRE_Int dscg_max_its )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetDSCGMaxIter_pre( precision, solver, dscg_max_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetDofFunc( HYPRE_Solver solver, HYPRE_Int *dof_func )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetDofFunc_pre( precision, solver, dof_func );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxPoints( HYPRE_Solver solver, HYPRE_Int **grid_relax_points )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetGridRelaxPoints_pre( precision, solver, grid_relax_points );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxType( HYPRE_Solver solver, HYPRE_Int *grid_relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetGridRelaxType_pre( precision, solver, grid_relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetInterpType( HYPRE_Solver solver, HYPRE_Int interp_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetInterpType_pre( precision, solver, interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetKeepTranspose( HYPRE_Solver solver, HYPRE_Int keepT )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetKeepTranspose_pre( precision, solver, keepT );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetLevelOuterWt( HYPRE_Solver solver, hypre_long_double outer_wt, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetLevelOuterWt_pre( precision, solver, outer_wt, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetLevelRelaxWt( HYPRE_Solver solver, hypre_long_double relax_wt, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetLevelRelaxWt_pre( precision, solver, relax_wt, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetMaxCoarseSize( HYPRE_Solver solver, HYPRE_Int max_coarse_size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetMaxCoarseSize_pre( precision, solver, max_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetMaxLevels( HYPRE_Solver solver, HYPRE_Int max_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetMaxLevels_pre( precision, solver, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetMaxRowSum( HYPRE_Solver solver, hypre_long_double max_row_sum )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetMaxRowSum_pre( precision, solver, max_row_sum );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetMeasureType( HYPRE_Solver solver, HYPRE_Int measure_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetMeasureType_pre( precision, solver, measure_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetMinCoarseSize( HYPRE_Solver solver, HYPRE_Int min_coarse_size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetMinCoarseSize_pre( precision, solver, min_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetNodal( HYPRE_Solver solver, HYPRE_Int nodal )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetNodal_pre( precision, solver, nodal );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetNonGalerkinTol( HYPRE_Solver solver, HYPRE_Int num_levels, void *nongalerkin_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetNonGalerkinTol_pre( precision, solver, num_levels, nongalerkin_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetNumFunctions( HYPRE_Solver solver, HYPRE_Int num_functions )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetNumFunctions_pre( precision, solver, num_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetNumGridSweeps( HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetNumGridSweeps_pre( precision, solver, num_grid_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetNumPaths( HYPRE_Solver solver, HYPRE_Int num_paths )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetNumPaths_pre( precision, solver, num_paths );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetNumSweeps( HYPRE_Solver solver, HYPRE_Int num_sweeps )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetNumSweeps_pre( precision, solver, num_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetOmega( HYPRE_Solver solver, void *omega )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetOmega_pre( precision, solver, omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetOuterWt( HYPRE_Solver solver, hypre_long_double outer_wt )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetOuterWt_pre( precision, solver, outer_wt );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetPCGMaxIter( HYPRE_Solver solver, HYPRE_Int pcg_max_its )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetPCGMaxIter_pre( precision, solver, pcg_max_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetPMaxElmts( HYPRE_Solver solver, HYPRE_Int P_max_elmts )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetPMaxElmts_pre( precision, solver, P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidual( HYPRE_Solver solver, HYPRE_Int recompute_residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetRecomputeResidual_pre( precision, solver, recompute_residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidualP( HYPRE_Solver solver, HYPRE_Int recompute_residual_p )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetRecomputeResidualP_pre( precision, solver, recompute_residual_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRelChange( HYPRE_Solver solver, HYPRE_Int rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxOrder( HYPRE_Solver solver, HYPRE_Int relax_order )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetRelaxOrder_pre( precision, solver, relax_order );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxType( HYPRE_Solver solver, HYPRE_Int relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetRelaxType_pre( precision, solver, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWeight( HYPRE_Solver solver, void *relax_weight )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetRelaxWeight_pre( precision, solver, relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWt( HYPRE_Solver solver, hypre_long_double relax_wt )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetRelaxWt_pre( precision, solver, relax_wt );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetSeqThreshold( HYPRE_Solver solver, HYPRE_Int seq_threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetSeqThreshold_pre( precision, solver, seq_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetSetupType( HYPRE_Solver solver, HYPRE_Int setup_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetSetupType_pre( precision, solver, setup_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetSolverType( HYPRE_Solver solver, HYPRE_Int solver_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetSolverType_pre( precision, solver, solver_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetStrongThreshold( HYPRE_Solver solver, hypre_long_double strong_threshold )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetStrongThreshold_pre( precision, solver, strong_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetTruncFactor( HYPRE_Solver solver, hypre_long_double trunc_factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetTruncFactor_pre( precision, solver, trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetTwoNorm( HYPRE_Solver solver, HYPRE_Int two_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetTwoNorm_pre( precision, solver, two_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRHybridSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESCreate( MPI_Comm comm, HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESGetPrecond_pre( precision, solver, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESSetAbsoluteTol_pre( precision, solver, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetAugDim( HYPRE_Solver solver, HYPRE_Int aug_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESSetAugDim_pre( precision, solver, aug_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRLGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMultiVectorPrint( void *x_, const char *fileName )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMultiVectorPrint_pre( precision, x_, fileName );
}

/*--------------------------------------------------------------------------*/

void *
HYPRE_ParCSRMultiVectorRead( MPI_Comm comm, void *ii_, const char *fileName )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMultiVectorRead_pre( precision, comm, ii_, fileName );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSROnProcTriSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSROnProcTriSetup_pre( precision, solver, HA, Hy, Hx );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSROnProcTriSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSROnProcTriSolve_pre( precision, solver, HA, Hy, Hx );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGCreate( MPI_Comm comm, HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGGetPrecond_pre( precision, solver, precond_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGGetResidual( HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGSetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetPrecond( HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetPreconditioner( HYPRE_Solver solver, HYPRE_Solver precond )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGSetPreconditioner_pre( precision, solver, precond );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetPrintLevel( HYPRE_Solver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetRelChange( HYPRE_Solver solver, HYPRE_Int rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGSetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGSetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetTwoNorm( HYPRE_Solver solver, HYPRE_Int two_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGSetTwoNorm_pre( precision, solver, two_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPCGSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsCreate( MPI_Comm comm, HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRParaSailsCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRParaSailsDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetFilter( HYPRE_Solver solver, hypre_long_double filter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRParaSailsSetFilter_pre( precision, solver, filter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetLoadbal( HYPRE_Solver solver, hypre_long_double loadbal )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRParaSailsSetLoadbal_pre( precision, solver, loadbal );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRParaSailsSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetParams( HYPRE_Solver solver, hypre_long_double thresh, HYPRE_Int nlevels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRParaSailsSetParams_pre( precision, solver, thresh, nlevels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetReuse( HYPRE_Solver solver, HYPRE_Int reuse )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRParaSailsSetReuse_pre( precision, solver, reuse );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetSym( HYPRE_Solver solver, HYPRE_Int sym )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRParaSailsSetSym_pre( precision, solver, sym );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRParaSailsSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRParaSailsSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutCreate( MPI_Comm comm, HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPilutCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPilutDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutSetDropTolerance( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPilutSetDropTolerance_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutSetFactorRowSize( HYPRE_Solver solver, HYPRE_Int size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPilutSetFactorRowSize_pre( precision, solver, size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPilutSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPilutSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPilutSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRPilutSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRSetupInterpreter( mv_InterfaceInterpreter *i )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRSetupInterpreter_pre( precision, i );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRSetupMatvec( HYPRE_MatvecFunctions *mv )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRSetupMatvec_pre( precision, mv );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsBuildIJMatrix( HYPRE_Solver solver, HYPRE_IJMatrix *pij_A )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsBuildIJMatrix_pre( precision, solver, pij_A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsCreate( MPI_Comm comm, HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetFilter( HYPRE_Solver solver, void *filter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsGetFilter_pre( precision, solver, filter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetLoadbal( HYPRE_Solver solver, void *loadbal )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsGetLoadbal_pre( precision, solver, loadbal );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetLogging( HYPRE_Solver solver, HYPRE_Int *logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsGetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetNlevels( HYPRE_Solver solver, HYPRE_Int *nlevels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsGetNlevels_pre( precision, solver, nlevels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetReuse( HYPRE_Solver solver, HYPRE_Int *reuse )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsGetReuse_pre( precision, solver, reuse );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetSym( HYPRE_Solver solver, HYPRE_Int *sym )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsGetSym_pre( precision, solver, sym );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetThresh( HYPRE_Solver solver, void *thresh )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsGetThresh_pre( precision, solver, thresh );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetFilter( HYPRE_Solver solver, hypre_long_double filter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsSetFilter_pre( precision, solver, filter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetLoadbal( HYPRE_Solver solver, hypre_long_double loadbal )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsSetLoadbal_pre( precision, solver, loadbal );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetNlevels( HYPRE_Solver solver, HYPRE_Int nlevels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsSetNlevels_pre( precision, solver, nlevels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetParams( HYPRE_Solver solver, hypre_long_double thresh, HYPRE_Int nlevels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsSetParams_pre( precision, solver, thresh, nlevels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetReuse( HYPRE_Solver solver, HYPRE_Int reuse )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsSetReuse_pre( precision, solver, reuse );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetSym( HYPRE_Solver solver, HYPRE_Int sym )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsSetSym_pre( precision, solver, sym );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetThresh( HYPRE_Solver solver, hypre_long_double thresh )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsSetThresh_pre( precision, solver, thresh );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParaSailsSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzCreate( HYPRE_Solver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SchwarzCreate_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SchwarzDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetDofFunc( HYPRE_Solver solver, HYPRE_Int *dof_func )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SchwarzSetDofFunc_pre( precision, solver, dof_func );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetDomainStructure( HYPRE_Solver solver, HYPRE_CSRMatrix domain_structure )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SchwarzSetDomainStructure_pre( precision, solver, domain_structure );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetDomainType( HYPRE_Solver solver, HYPRE_Int domain_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SchwarzSetDomainType_pre( precision, solver, domain_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetNonSymm( HYPRE_Solver solver, HYPRE_Int use_nonsymm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SchwarzSetNonSymm_pre( precision, solver, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetNumFunctions( HYPRE_Solver solver, HYPRE_Int num_functions )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SchwarzSetNumFunctions_pre( precision, solver, num_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetOverlap( HYPRE_Solver solver, HYPRE_Int overlap )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SchwarzSetOverlap_pre( precision, solver, overlap );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetRelaxWeight( HYPRE_Solver solver, hypre_long_double relax_weight )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SchwarzSetRelaxWeight_pre( precision, solver, relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetVariant( HYPRE_Solver solver, HYPRE_Int variant )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SchwarzSetVariant_pre( precision, solver, variant );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetup( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SchwarzSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSolve( HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SchwarzSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_TempParCSRSetupInterpreter( mv_InterfaceInterpreter *i )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_TempParCSRSetupInterpreter_pre( precision, i );
}



#endif

