
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#ifndef hypre_SEQ_MV_MUP_HEADER
#define hypre_SEQ_MV_MUP_HEADER

#ifdef __cplusplus
extern "C" {
#endif

#if defined (HYPRE_MIXED_PRECISION)

/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


hypre_CSRMatrix *
hypre_CSRMatrixAdd_flt( hypre_float alpha, hypre_CSRMatrix *A, hypre_float beta, hypre_CSRMatrix *B );
hypre_CSRMatrix *
hypre_CSRMatrixAdd_dbl( hypre_double alpha, hypre_CSRMatrix *A, hypre_double beta, hypre_CSRMatrix *B );
hypre_CSRMatrix *
hypre_CSRMatrixAdd_long_dbl( hypre_long_double alpha, hypre_CSRMatrix *A, hypre_long_double beta, hypre_CSRMatrix *B );

HYPRE_Int
hypre_CSRMatrixAddFirstPass_flt( HYPRE_Int firstrow, HYPRE_Int lastrow, HYPRE_Int *marker, HYPRE_Int *twspace, HYPRE_Int *map_A2C, HYPRE_Int *map_B2C, hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_Int nnzrows_C, HYPRE_Int nrows_C, HYPRE_Int ncols_C, HYPRE_Int *rownnz_C, HYPRE_MemoryLocation memory_location_C, HYPRE_Int *C_i, hypre_CSRMatrix **C_ptr );
HYPRE_Int
hypre_CSRMatrixAddFirstPass_dbl( HYPRE_Int firstrow, HYPRE_Int lastrow, HYPRE_Int *marker, HYPRE_Int *twspace, HYPRE_Int *map_A2C, HYPRE_Int *map_B2C, hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_Int nnzrows_C, HYPRE_Int nrows_C, HYPRE_Int ncols_C, HYPRE_Int *rownnz_C, HYPRE_MemoryLocation memory_location_C, HYPRE_Int *C_i, hypre_CSRMatrix **C_ptr );
HYPRE_Int
hypre_CSRMatrixAddFirstPass_long_dbl( HYPRE_Int firstrow, HYPRE_Int lastrow, HYPRE_Int *marker, HYPRE_Int *twspace, HYPRE_Int *map_A2C, HYPRE_Int *map_B2C, hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_Int nnzrows_C, HYPRE_Int nrows_C, HYPRE_Int ncols_C, HYPRE_Int *rownnz_C, HYPRE_MemoryLocation memory_location_C, HYPRE_Int *C_i, hypre_CSRMatrix **C_ptr );

hypre_CSRMatrix *
hypre_CSRMatrixAddHost_flt( hypre_float alpha, hypre_CSRMatrix *A, hypre_float beta, hypre_CSRMatrix *B );
hypre_CSRMatrix *
hypre_CSRMatrixAddHost_dbl( hypre_double alpha, hypre_CSRMatrix *A, hypre_double beta, hypre_CSRMatrix *B );
hypre_CSRMatrix *
hypre_CSRMatrixAddHost_long_dbl( hypre_long_double alpha, hypre_CSRMatrix *A, hypre_long_double beta, hypre_CSRMatrix *B );

hypre_CSRMatrix *
hypre_CSRMatrixAddPartial_flt( hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_Int *row_nums );
hypre_CSRMatrix *
hypre_CSRMatrixAddPartial_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_Int *row_nums );
hypre_CSRMatrix *
hypre_CSRMatrixAddPartial_long_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_Int *row_nums );

HYPRE_Int
hypre_CSRMatrixAddSecondPass_flt( HYPRE_Int firstrow, HYPRE_Int lastrow, HYPRE_Int *marker, HYPRE_Int *map_A2C, HYPRE_Int *map_B2C, HYPRE_Int *rownnz_C, hypre_float alpha, hypre_float beta, hypre_CSRMatrix *A, hypre_CSRMatrix *B, hypre_CSRMatrix *C );
HYPRE_Int
hypre_CSRMatrixAddSecondPass_dbl( HYPRE_Int firstrow, HYPRE_Int lastrow, HYPRE_Int *marker, HYPRE_Int *map_A2C, HYPRE_Int *map_B2C, HYPRE_Int *rownnz_C, hypre_double alpha, hypre_double beta, hypre_CSRMatrix *A, hypre_CSRMatrix *B, hypre_CSRMatrix *C );
HYPRE_Int
hypre_CSRMatrixAddSecondPass_long_dbl( HYPRE_Int firstrow, HYPRE_Int lastrow, HYPRE_Int *marker, HYPRE_Int *map_A2C, HYPRE_Int *map_B2C, HYPRE_Int *rownnz_C, hypre_long_double alpha, hypre_long_double beta, hypre_CSRMatrix *A, hypre_CSRMatrix *B, hypre_CSRMatrix *C );

HYPRE_Int
hypre_CSRMatrixBigInitialize_flt( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixBigInitialize_dbl( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixBigInitialize_long_dbl( hypre_CSRMatrix *matrix );

HYPRE_Int
hypre_CSRMatrixBigJtoJ_flt( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixBigJtoJ_dbl( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixBigJtoJ_long_dbl( hypre_CSRMatrix *matrix );

HYPRE_Int
hypre_CSRMatrixCheckSetNumNonzeros_flt( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixCheckSetNumNonzeros_dbl( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixCheckSetNumNonzeros_long_dbl( hypre_CSRMatrix *matrix );

hypre_CSRMatrix *
hypre_CSRMatrixClone_flt( hypre_CSRMatrix *A, HYPRE_Int copy_data );
hypre_CSRMatrix *
hypre_CSRMatrixClone_dbl( hypre_CSRMatrix *A, HYPRE_Int copy_data );
hypre_CSRMatrix *
hypre_CSRMatrixClone_long_dbl( hypre_CSRMatrix *A, HYPRE_Int copy_data );

hypre_CSRMatrix *
hypre_CSRMatrixClone_v2_flt( hypre_CSRMatrix *A, HYPRE_Int copy_data, HYPRE_MemoryLocation memory_location );
hypre_CSRMatrix *
hypre_CSRMatrixClone_v2_dbl( hypre_CSRMatrix *A, HYPRE_Int copy_data, HYPRE_MemoryLocation memory_location );
hypre_CSRMatrix *
hypre_CSRMatrixClone_v2_long_dbl( hypre_CSRMatrix *A, HYPRE_Int copy_data, HYPRE_MemoryLocation memory_location );

HYPRE_Int
hypre_CSRMatrixComputeColSum_flt( hypre_CSRMatrix *A, hypre_float *col_sum, HYPRE_Int type, hypre_float scal );
HYPRE_Int
hypre_CSRMatrixComputeColSum_dbl( hypre_CSRMatrix *A, hypre_double *col_sum, HYPRE_Int type, hypre_double scal );
HYPRE_Int
hypre_CSRMatrixComputeColSum_long_dbl( hypre_CSRMatrix *A, hypre_long_double *col_sum, HYPRE_Int type, hypre_long_double scal );

HYPRE_Int
hypre_CSRMatrixComputeRowSum_flt( hypre_CSRMatrix *A, HYPRE_Int *CF_i, HYPRE_Int *CF_j, hypre_float *row_sum, HYPRE_Int type, hypre_float scal, const char *set_or_add );
HYPRE_Int
hypre_CSRMatrixComputeRowSum_dbl( hypre_CSRMatrix *A, HYPRE_Int *CF_i, HYPRE_Int *CF_j, hypre_double *row_sum, HYPRE_Int type, hypre_double scal, const char *set_or_add );
HYPRE_Int
hypre_CSRMatrixComputeRowSum_long_dbl( hypre_CSRMatrix *A, HYPRE_Int *CF_i, HYPRE_Int *CF_j, hypre_long_double *row_sum, HYPRE_Int type, hypre_long_double scal, const char *set_or_add );

HYPRE_Int
hypre_CSRMatrixCopy_flt( hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_Int copy_data );
HYPRE_Int
hypre_CSRMatrixCopy_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_Int copy_data );
HYPRE_Int
hypre_CSRMatrixCopy_long_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_Int copy_data );

hypre_CSRMatrix *
hypre_CSRMatrixCreate_flt( HYPRE_Int num_rows, HYPRE_Int num_cols, HYPRE_Int num_nonzeros );
hypre_CSRMatrix *
hypre_CSRMatrixCreate_dbl( HYPRE_Int num_rows, HYPRE_Int num_cols, HYPRE_Int num_nonzeros );
hypre_CSRMatrix *
hypre_CSRMatrixCreate_long_dbl( HYPRE_Int num_rows, HYPRE_Int num_cols, HYPRE_Int num_nonzeros );

hypre_CSRMatrix *
hypre_CSRMatrixDeleteZeros_flt( hypre_CSRMatrix *A, hypre_float tol );
hypre_CSRMatrix *
hypre_CSRMatrixDeleteZeros_dbl( hypre_CSRMatrix *A, hypre_double tol );
hypre_CSRMatrix *
hypre_CSRMatrixDeleteZeros_long_dbl( hypre_CSRMatrix *A, hypre_long_double tol );

HYPRE_Int
hypre_CSRMatrixDestroy_flt( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixDestroy_dbl( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixDestroy_long_dbl( hypre_CSRMatrix *matrix );

HYPRE_Int
hypre_CSRMatrixDiagScale_flt( hypre_CSRMatrix *A, hypre_Vector *ld, hypre_Vector *rd );
HYPRE_Int
hypre_CSRMatrixDiagScale_dbl( hypre_CSRMatrix *A, hypre_Vector *ld, hypre_Vector *rd );
HYPRE_Int
hypre_CSRMatrixDiagScale_long_dbl( hypre_CSRMatrix *A, hypre_Vector *ld, hypre_Vector *rd );

HYPRE_Int
hypre_CSRMatrixEliminateRowsCols_flt( hypre_CSRMatrix *A, HYPRE_Int nrows, HYPRE_Int *rows );
HYPRE_Int
hypre_CSRMatrixEliminateRowsCols_dbl( hypre_CSRMatrix *A, HYPRE_Int nrows, HYPRE_Int *rows );
HYPRE_Int
hypre_CSRMatrixEliminateRowsCols_long_dbl( hypre_CSRMatrix *A, HYPRE_Int nrows, HYPRE_Int *rows );

HYPRE_Int
hypre_CSRMatrixExtractDiagonal_flt( hypre_CSRMatrix *A, hypre_float *d, HYPRE_Int type );
HYPRE_Int
hypre_CSRMatrixExtractDiagonal_dbl( hypre_CSRMatrix *A, hypre_double *d, HYPRE_Int type );
HYPRE_Int
hypre_CSRMatrixExtractDiagonal_long_dbl( hypre_CSRMatrix *A, hypre_long_double *d, HYPRE_Int type );

HYPRE_Int
hypre_CSRMatrixExtractDiagonalHost_flt( hypre_CSRMatrix *A, hypre_float *d, HYPRE_Int type );
HYPRE_Int
hypre_CSRMatrixExtractDiagonalHost_dbl( hypre_CSRMatrix *A, hypre_double *d, HYPRE_Int type );
HYPRE_Int
hypre_CSRMatrixExtractDiagonalHost_long_dbl( hypre_CSRMatrix *A, hypre_long_double *d, HYPRE_Int type );

HYPRE_Real
hypre_CSRMatrixFnorm_flt( hypre_CSRMatrix *A );
HYPRE_Real
hypre_CSRMatrixFnorm_dbl( hypre_CSRMatrix *A );
HYPRE_Real
hypre_CSRMatrixFnorm_long_dbl( hypre_CSRMatrix *A );

HYPRE_Int
hypre_CSRMatrixGetLoadBalancedPartitionBegin_flt( hypre_CSRMatrix *A );
HYPRE_Int
hypre_CSRMatrixGetLoadBalancedPartitionBegin_dbl( hypre_CSRMatrix *A );
HYPRE_Int
hypre_CSRMatrixGetLoadBalancedPartitionBegin_long_dbl( hypre_CSRMatrix *A );

HYPRE_Int
hypre_CSRMatrixGetLoadBalancedPartitionEnd_flt( hypre_CSRMatrix *A );
HYPRE_Int
hypre_CSRMatrixGetLoadBalancedPartitionEnd_dbl( hypre_CSRMatrix *A );
HYPRE_Int
hypre_CSRMatrixGetLoadBalancedPartitionEnd_long_dbl( hypre_CSRMatrix *A );

HYPRE_Int
hypre_CSRMatrixInitialize_flt( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixInitialize_dbl( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixInitialize_long_dbl( hypre_CSRMatrix *matrix );

HYPRE_Int
hypre_CSRMatrixInitialize_v2_flt( hypre_CSRMatrix *matrix, HYPRE_Int bigInit, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_CSRMatrixInitialize_v2_dbl( hypre_CSRMatrix *matrix, HYPRE_Int bigInit, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_CSRMatrixInitialize_v2_long_dbl( hypre_CSRMatrix *matrix, HYPRE_Int bigInit, HYPRE_MemoryLocation memory_location );

HYPRE_Int
hypre_CSRMatrixJtoBigJ_flt( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixJtoBigJ_dbl( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixJtoBigJ_long_dbl( hypre_CSRMatrix *matrix );

HYPRE_Int
hypre_CSRMatrixMatvec_flt( hypre_float alpha, hypre_CSRMatrix *A, hypre_Vector *x, hypre_float beta, hypre_Vector *y );
HYPRE_Int
hypre_CSRMatrixMatvec_dbl( hypre_double alpha, hypre_CSRMatrix *A, hypre_Vector *x, hypre_double beta, hypre_Vector *y );
HYPRE_Int
hypre_CSRMatrixMatvec_long_dbl( hypre_long_double alpha, hypre_CSRMatrix *A, hypre_Vector *x, hypre_long_double beta, hypre_Vector *y );

HYPRE_Int
hypre_CSRMatrixMatvecOutOfPlace_flt( hypre_float alpha, hypre_CSRMatrix *A, hypre_Vector *x, hypre_float beta, hypre_Vector *b, hypre_Vector *y, HYPRE_Int offset );
HYPRE_Int
hypre_CSRMatrixMatvecOutOfPlace_dbl( hypre_double alpha, hypre_CSRMatrix *A, hypre_Vector *x, hypre_double beta, hypre_Vector *b, hypre_Vector *y, HYPRE_Int offset );
HYPRE_Int
hypre_CSRMatrixMatvecOutOfPlace_long_dbl( hypre_long_double alpha, hypre_CSRMatrix *A, hypre_Vector *x, hypre_long_double beta, hypre_Vector *b, hypre_Vector *y, HYPRE_Int offset );

HYPRE_Int
hypre_CSRMatrixMatvecT_flt( hypre_float alpha, hypre_CSRMatrix *A, hypre_Vector *x, hypre_float beta, hypre_Vector *y );
HYPRE_Int
hypre_CSRMatrixMatvecT_dbl( hypre_double alpha, hypre_CSRMatrix *A, hypre_Vector *x, hypre_double beta, hypre_Vector *y );
HYPRE_Int
hypre_CSRMatrixMatvecT_long_dbl( hypre_long_double alpha, hypre_CSRMatrix *A, hypre_Vector *x, hypre_long_double beta, hypre_Vector *y );

HYPRE_Int
hypre_CSRMatrixMatvec_FF_flt( hypre_float alpha, hypre_CSRMatrix *A, hypre_Vector *x, hypre_float beta, hypre_Vector *y, HYPRE_Int *CF_marker_x, HYPRE_Int *CF_marker_y, HYPRE_Int fpt );
HYPRE_Int
hypre_CSRMatrixMatvec_FF_dbl( hypre_double alpha, hypre_CSRMatrix *A, hypre_Vector *x, hypre_double beta, hypre_Vector *y, HYPRE_Int *CF_marker_x, HYPRE_Int *CF_marker_y, HYPRE_Int fpt );
HYPRE_Int
hypre_CSRMatrixMatvec_FF_long_dbl( hypre_long_double alpha, hypre_CSRMatrix *A, hypre_Vector *x, hypre_long_double beta, hypre_Vector *y, HYPRE_Int *CF_marker_x, HYPRE_Int *CF_marker_y, HYPRE_Int fpt );

HYPRE_Int
hypre_CSRMatrixMigrate_flt( hypre_CSRMatrix *A, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_CSRMatrixMigrate_dbl( hypre_CSRMatrix *A, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_CSRMatrixMigrate_long_dbl( hypre_CSRMatrix *A, HYPRE_MemoryLocation memory_location );

hypre_CSRMatrix *
hypre_CSRMatrixMultiply_flt( hypre_CSRMatrix *A, hypre_CSRMatrix *B );
hypre_CSRMatrix *
hypre_CSRMatrixMultiply_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix *B );
hypre_CSRMatrix *
hypre_CSRMatrixMultiply_long_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix *B );

hypre_CSRMatrix *
hypre_CSRMatrixMultiplyHost_flt( hypre_CSRMatrix *A, hypre_CSRMatrix *B );
hypre_CSRMatrix *
hypre_CSRMatrixMultiplyHost_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix *B );
hypre_CSRMatrix *
hypre_CSRMatrixMultiplyHost_long_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix *B );

HYPRE_Int
hypre_CSRMatrixPermute_flt( hypre_CSRMatrix *A, HYPRE_Int *perm, HYPRE_Int *rqperm, hypre_CSRMatrix **B_ptr );
HYPRE_Int
hypre_CSRMatrixPermute_dbl( hypre_CSRMatrix *A, HYPRE_Int *perm, HYPRE_Int *rqperm, hypre_CSRMatrix **B_ptr );
HYPRE_Int
hypre_CSRMatrixPermute_long_dbl( hypre_CSRMatrix *A, HYPRE_Int *perm, HYPRE_Int *rqperm, hypre_CSRMatrix **B_ptr );

HYPRE_Int
hypre_CSRMatrixPrefetch_flt( hypre_CSRMatrix *A, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_CSRMatrixPrefetch_dbl( hypre_CSRMatrix *A, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_CSRMatrixPrefetch_long_dbl( hypre_CSRMatrix *A, HYPRE_MemoryLocation memory_location );

HYPRE_Int
hypre_CSRMatrixPrint_flt( hypre_CSRMatrix *matrix, const char *file_name );
HYPRE_Int
hypre_CSRMatrixPrint_dbl( hypre_CSRMatrix *matrix, const char *file_name );
HYPRE_Int
hypre_CSRMatrixPrint_long_dbl( hypre_CSRMatrix *matrix, const char *file_name );

HYPRE_Int
hypre_CSRMatrixPrintHB_flt( hypre_CSRMatrix *matrix_input, char *file_name );
HYPRE_Int
hypre_CSRMatrixPrintHB_dbl( hypre_CSRMatrix *matrix_input, char *file_name );
HYPRE_Int
hypre_CSRMatrixPrintHB_long_dbl( hypre_CSRMatrix *matrix_input, char *file_name );

HYPRE_Int
hypre_CSRMatrixPrintIJ_flt( hypre_CSRMatrix *matrix, HYPRE_Int base_i, HYPRE_Int base_j, char *filename );
HYPRE_Int
hypre_CSRMatrixPrintIJ_dbl( hypre_CSRMatrix *matrix, HYPRE_Int base_i, HYPRE_Int base_j, char *filename );
HYPRE_Int
hypre_CSRMatrixPrintIJ_long_dbl( hypre_CSRMatrix *matrix, HYPRE_Int base_i, HYPRE_Int base_j, char *filename );

HYPRE_Int
hypre_CSRMatrixPrintMM_flt( hypre_CSRMatrix *matrix, HYPRE_Int basei, HYPRE_Int basej, HYPRE_Int trans, const char *file_name );
HYPRE_Int
hypre_CSRMatrixPrintMM_dbl( hypre_CSRMatrix *matrix, HYPRE_Int basei, HYPRE_Int basej, HYPRE_Int trans, const char *file_name );
HYPRE_Int
hypre_CSRMatrixPrintMM_long_dbl( hypre_CSRMatrix *matrix, HYPRE_Int basei, HYPRE_Int basej, HYPRE_Int trans, const char *file_name );

hypre_CSRMatrix *
hypre_CSRMatrixRead_flt( char *file_name );
hypre_CSRMatrix *
hypre_CSRMatrixRead_dbl( char *file_name );
hypre_CSRMatrix *
hypre_CSRMatrixRead_long_dbl( char *file_name );

HYPRE_Int
hypre_CSRMatrixReorder_flt( hypre_CSRMatrix *A );
HYPRE_Int
hypre_CSRMatrixReorder_dbl( hypre_CSRMatrix *A );
HYPRE_Int
hypre_CSRMatrixReorder_long_dbl( hypre_CSRMatrix *A );

HYPRE_Int
hypre_CSRMatrixResize_flt( hypre_CSRMatrix *matrix, HYPRE_Int new_num_rows, HYPRE_Int new_num_cols, HYPRE_Int new_num_nonzeros );
HYPRE_Int
hypre_CSRMatrixResize_dbl( hypre_CSRMatrix *matrix, HYPRE_Int new_num_rows, HYPRE_Int new_num_cols, HYPRE_Int new_num_nonzeros );
HYPRE_Int
hypre_CSRMatrixResize_long_dbl( hypre_CSRMatrix *matrix, HYPRE_Int new_num_rows, HYPRE_Int new_num_cols, HYPRE_Int new_num_nonzeros );

HYPRE_Int
hypre_CSRMatrixScale_flt( hypre_CSRMatrix *A, hypre_float scalar );
HYPRE_Int
hypre_CSRMatrixScale_dbl( hypre_CSRMatrix *A, hypre_double scalar );
HYPRE_Int
hypre_CSRMatrixScale_long_dbl( hypre_CSRMatrix *A, hypre_long_double scalar );

HYPRE_Int
hypre_CSRMatrixSetConstantValues_flt( hypre_CSRMatrix *A, hypre_float value );
HYPRE_Int
hypre_CSRMatrixSetConstantValues_dbl( hypre_CSRMatrix *A, hypre_double value );
HYPRE_Int
hypre_CSRMatrixSetConstantValues_long_dbl( hypre_CSRMatrix *A, hypre_long_double value );

HYPRE_Int
hypre_CSRMatrixSetDataOwner_flt( hypre_CSRMatrix *matrix, HYPRE_Int owns_data );
HYPRE_Int
hypre_CSRMatrixSetDataOwner_dbl( hypre_CSRMatrix *matrix, HYPRE_Int owns_data );
HYPRE_Int
hypre_CSRMatrixSetDataOwner_long_dbl( hypre_CSRMatrix *matrix, HYPRE_Int owns_data );

HYPRE_Int
hypre_CSRMatrixSetPatternOnly_flt( hypre_CSRMatrix *matrix, HYPRE_Int pattern_only );
HYPRE_Int
hypre_CSRMatrixSetPatternOnly_dbl( hypre_CSRMatrix *matrix, HYPRE_Int pattern_only );
HYPRE_Int
hypre_CSRMatrixSetPatternOnly_long_dbl( hypre_CSRMatrix *matrix, HYPRE_Int pattern_only );

HYPRE_Int
hypre_CSRMatrixSetRownnz_flt( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixSetRownnz_dbl( hypre_CSRMatrix *matrix );
HYPRE_Int
hypre_CSRMatrixSetRownnz_long_dbl( hypre_CSRMatrix *matrix );

HYPRE_Int
hypre_CSRMatrixSplit_flt( hypre_CSRMatrix *Bs_ext, HYPRE_BigInt first_col_diag_B, HYPRE_BigInt last_col_diag_B, HYPRE_Int num_cols_offd_B, HYPRE_BigInt *col_map_offd_B, HYPRE_Int *num_cols_offd_C_ptr, HYPRE_BigInt **col_map_offd_C_ptr, hypre_CSRMatrix **Bext_diag_ptr, hypre_CSRMatrix **Bext_offd_ptr );
HYPRE_Int
hypre_CSRMatrixSplit_dbl( hypre_CSRMatrix *Bs_ext, HYPRE_BigInt first_col_diag_B, HYPRE_BigInt last_col_diag_B, HYPRE_Int num_cols_offd_B, HYPRE_BigInt *col_map_offd_B, HYPRE_Int *num_cols_offd_C_ptr, HYPRE_BigInt **col_map_offd_C_ptr, hypre_CSRMatrix **Bext_diag_ptr, hypre_CSRMatrix **Bext_offd_ptr );
HYPRE_Int
hypre_CSRMatrixSplit_long_dbl( hypre_CSRMatrix *Bs_ext, HYPRE_BigInt first_col_diag_B, HYPRE_BigInt last_col_diag_B, HYPRE_Int num_cols_offd_B, HYPRE_BigInt *col_map_offd_B, HYPRE_Int *num_cols_offd_C_ptr, HYPRE_BigInt **col_map_offd_C_ptr, hypre_CSRMatrix **Bext_diag_ptr, hypre_CSRMatrix **Bext_offd_ptr );

HYPRE_Complex
hypre_CSRMatrixSumElts_flt( hypre_CSRMatrix *A );
HYPRE_Complex
hypre_CSRMatrixSumElts_dbl( hypre_CSRMatrix *A );
HYPRE_Complex
hypre_CSRMatrixSumElts_long_dbl( hypre_CSRMatrix *A );

HYPRE_Int
hypre_CSRMatrixTaggedFnorm_flt( hypre_CSRMatrix *A, HYPRE_Int num_tags, HYPRE_Int *tags, hypre_float **tnorms_ptr );
HYPRE_Int
hypre_CSRMatrixTaggedFnorm_dbl( hypre_CSRMatrix *A, HYPRE_Int num_tags, HYPRE_Int *tags, hypre_double **tnorms_ptr );
HYPRE_Int
hypre_CSRMatrixTaggedFnorm_long_dbl( hypre_CSRMatrix *A, HYPRE_Int num_tags, HYPRE_Int *tags, hypre_long_double **tnorms_ptr );

HYPRE_Int
hypre_CSRMatrixTranspose_flt( hypre_CSRMatrix *A, hypre_CSRMatrix **AT, HYPRE_Int data );
HYPRE_Int
hypre_CSRMatrixTranspose_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix **AT, HYPRE_Int data );
HYPRE_Int
hypre_CSRMatrixTranspose_long_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix **AT, HYPRE_Int data );

HYPRE_Int
hypre_CSRMatrixTransposeHost_flt( hypre_CSRMatrix *A, hypre_CSRMatrix **AT, HYPRE_Int data );
HYPRE_Int
hypre_CSRMatrixTransposeHost_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix **AT, HYPRE_Int data );
HYPRE_Int
hypre_CSRMatrixTransposeHost_long_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix **AT, HYPRE_Int data );

HYPRE_Int
hypre_CSRMatrixTruncateDiag_flt( hypre_CSRMatrix *A );
HYPRE_Int
hypre_CSRMatrixTruncateDiag_dbl( hypre_CSRMatrix *A );
HYPRE_Int
hypre_CSRMatrixTruncateDiag_long_dbl( hypre_CSRMatrix *A );

hypre_CSRMatrix *
hypre_CSRMatrixUnion_flt( hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_BigInt *col_map_offd_A, HYPRE_BigInt *col_map_offd_B, HYPRE_BigInt **col_map_offd_C );
hypre_CSRMatrix *
hypre_CSRMatrixUnion_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_BigInt *col_map_offd_A, HYPRE_BigInt *col_map_offd_B, HYPRE_BigInt **col_map_offd_C );
hypre_CSRMatrix *
hypre_CSRMatrixUnion_long_dbl( hypre_CSRMatrix *A, hypre_CSRMatrix *B, HYPRE_BigInt *col_map_offd_A, HYPRE_BigInt *col_map_offd_B, HYPRE_BigInt **col_map_offd_C );

HYPRE_Int
hypre_GenerateLocalPartitioning_flt( HYPRE_BigInt length, HYPRE_Int num_procs, HYPRE_Int myid, HYPRE_BigInt *part );
HYPRE_Int
hypre_GenerateLocalPartitioning_dbl( HYPRE_BigInt length, HYPRE_Int num_procs, HYPRE_Int myid, HYPRE_BigInt *part );
HYPRE_Int
hypre_GenerateLocalPartitioning_long_dbl( HYPRE_BigInt length, HYPRE_Int num_procs, HYPRE_Int myid, HYPRE_BigInt *part );

HYPRE_Int
hypre_GeneratePartitioning_flt( HYPRE_BigInt length, HYPRE_Int num_procs, HYPRE_BigInt **part_ptr );
HYPRE_Int
hypre_GeneratePartitioning_dbl( HYPRE_BigInt length, HYPRE_Int num_procs, HYPRE_BigInt **part_ptr );
HYPRE_Int
hypre_GeneratePartitioning_long_dbl( HYPRE_BigInt length, HYPRE_Int num_procs, HYPRE_BigInt **part_ptr );

HYPRE_Int
hypre_MappedMatrixAssemble_flt( hypre_MappedMatrix *matrix );
HYPRE_Int
hypre_MappedMatrixAssemble_dbl( hypre_MappedMatrix *matrix );
HYPRE_Int
hypre_MappedMatrixAssemble_long_dbl( hypre_MappedMatrix *matrix );

hypre_MappedMatrix *
hypre_MappedMatrixCreate_flt( void );
hypre_MappedMatrix *
hypre_MappedMatrixCreate_dbl( void );
hypre_MappedMatrix *
hypre_MappedMatrixCreate_long_dbl( void );

HYPRE_Int
hypre_MappedMatrixDestroy_flt( hypre_MappedMatrix *matrix );
HYPRE_Int
hypre_MappedMatrixDestroy_dbl( hypre_MappedMatrix *matrix );
HYPRE_Int
hypre_MappedMatrixDestroy_long_dbl( hypre_MappedMatrix *matrix );

HYPRE_Int
hypre_MappedMatrixGetColIndex_flt( hypre_MappedMatrix *matrix, HYPRE_Int j );
HYPRE_Int
hypre_MappedMatrixGetColIndex_dbl( hypre_MappedMatrix *matrix, HYPRE_Int j );
HYPRE_Int
hypre_MappedMatrixGetColIndex_long_dbl( hypre_MappedMatrix *matrix, HYPRE_Int j );

void *
hypre_MappedMatrixGetMatrix_flt( hypre_MappedMatrix *matrix );
void *
hypre_MappedMatrixGetMatrix_dbl( hypre_MappedMatrix *matrix );
void *
hypre_MappedMatrixGetMatrix_long_dbl( hypre_MappedMatrix *matrix );

HYPRE_Int
hypre_MappedMatrixInitialize_flt( hypre_MappedMatrix *matrix );
HYPRE_Int
hypre_MappedMatrixInitialize_dbl( hypre_MappedMatrix *matrix );
HYPRE_Int
hypre_MappedMatrixInitialize_long_dbl( hypre_MappedMatrix *matrix );

HYPRE_Int
hypre_MappedMatrixLimitedDestroy_flt( hypre_MappedMatrix *matrix );
HYPRE_Int
hypre_MappedMatrixLimitedDestroy_dbl( hypre_MappedMatrix *matrix );
HYPRE_Int
hypre_MappedMatrixLimitedDestroy_long_dbl( hypre_MappedMatrix *matrix );

void
hypre_MappedMatrixPrint_flt( hypre_MappedMatrix *matrix );
void
hypre_MappedMatrixPrint_dbl( hypre_MappedMatrix *matrix );
void
hypre_MappedMatrixPrint_long_dbl( hypre_MappedMatrix *matrix );

HYPRE_Int
hypre_MappedMatrixSetMapData_flt( hypre_MappedMatrix *matrix, void *map_data );
HYPRE_Int
hypre_MappedMatrixSetMapData_dbl( hypre_MappedMatrix *matrix, void *map_data );
HYPRE_Int
hypre_MappedMatrixSetMapData_long_dbl( hypre_MappedMatrix *matrix, void *map_data );

HYPRE_Int
hypre_MappedMatrixSetMatrix_flt( hypre_MappedMatrix *matrix, void *matrix_data );
HYPRE_Int
hypre_MappedMatrixSetMatrix_dbl( hypre_MappedMatrix *matrix, void *matrix_data );
HYPRE_Int
hypre_MappedMatrixSetMatrix_long_dbl( hypre_MappedMatrix *matrix, void *matrix_data );

HYPRE_Int
hypre_MultiblockMatrixAssemble_flt( hypre_MultiblockMatrix *matrix );
HYPRE_Int
hypre_MultiblockMatrixAssemble_dbl( hypre_MultiblockMatrix *matrix );
HYPRE_Int
hypre_MultiblockMatrixAssemble_long_dbl( hypre_MultiblockMatrix *matrix );

hypre_MultiblockMatrix *
hypre_MultiblockMatrixCreate_flt( void );
hypre_MultiblockMatrix *
hypre_MultiblockMatrixCreate_dbl( void );
hypre_MultiblockMatrix *
hypre_MultiblockMatrixCreate_long_dbl( void );

HYPRE_Int
hypre_MultiblockMatrixDestroy_flt( hypre_MultiblockMatrix *matrix );
HYPRE_Int
hypre_MultiblockMatrixDestroy_dbl( hypre_MultiblockMatrix *matrix );
HYPRE_Int
hypre_MultiblockMatrixDestroy_long_dbl( hypre_MultiblockMatrix *matrix );

HYPRE_Int
hypre_MultiblockMatrixInitialize_flt( hypre_MultiblockMatrix *matrix );
HYPRE_Int
hypre_MultiblockMatrixInitialize_dbl( hypre_MultiblockMatrix *matrix );
HYPRE_Int
hypre_MultiblockMatrixInitialize_long_dbl( hypre_MultiblockMatrix *matrix );

HYPRE_Int
hypre_MultiblockMatrixLimitedDestroy_flt( hypre_MultiblockMatrix *matrix );
HYPRE_Int
hypre_MultiblockMatrixLimitedDestroy_dbl( hypre_MultiblockMatrix *matrix );
HYPRE_Int
hypre_MultiblockMatrixLimitedDestroy_long_dbl( hypre_MultiblockMatrix *matrix );

void
hypre_MultiblockMatrixPrint_flt( hypre_MultiblockMatrix *matrix );
void
hypre_MultiblockMatrixPrint_dbl( hypre_MultiblockMatrix *matrix );
void
hypre_MultiblockMatrixPrint_long_dbl( hypre_MultiblockMatrix *matrix );

HYPRE_Int
hypre_MultiblockMatrixSetNumSubmatrices_flt( hypre_MultiblockMatrix *matrix, HYPRE_Int n );
HYPRE_Int
hypre_MultiblockMatrixSetNumSubmatrices_dbl( hypre_MultiblockMatrix *matrix, HYPRE_Int n );
HYPRE_Int
hypre_MultiblockMatrixSetNumSubmatrices_long_dbl( hypre_MultiblockMatrix *matrix, HYPRE_Int n );

HYPRE_Int
hypre_MultiblockMatrixSetSubmatrix_flt( hypre_MultiblockMatrix *matrix, HYPRE_Int j, void *submatrix );
HYPRE_Int
hypre_MultiblockMatrixSetSubmatrix_dbl( hypre_MultiblockMatrix *matrix, HYPRE_Int j, void *submatrix );
HYPRE_Int
hypre_MultiblockMatrixSetSubmatrix_long_dbl( hypre_MultiblockMatrix *matrix, HYPRE_Int j, void *submatrix );

HYPRE_Int
hypre_MultiblockMatrixSetSubmatrixType_flt( hypre_MultiblockMatrix *matrix, HYPRE_Int j, HYPRE_Int type );
HYPRE_Int
hypre_MultiblockMatrixSetSubmatrixType_dbl( hypre_MultiblockMatrix *matrix, HYPRE_Int j, HYPRE_Int type );
HYPRE_Int
hypre_MultiblockMatrixSetSubmatrixType_long_dbl( hypre_MultiblockMatrix *matrix, HYPRE_Int j, HYPRE_Int type );

hypre_Vector *
hypre_SeqMultiVectorCreate_flt( HYPRE_Int size, HYPRE_Int num_vectors );
hypre_Vector *
hypre_SeqMultiVectorCreate_dbl( HYPRE_Int size, HYPRE_Int num_vectors );
hypre_Vector *
hypre_SeqMultiVectorCreate_long_dbl( HYPRE_Int size, HYPRE_Int num_vectors );

HYPRE_Int
hypre_SeqVectorAxpy_flt( hypre_float alpha, hypre_Vector *x, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorAxpy_dbl( hypre_double alpha, hypre_Vector *x, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorAxpy_long_dbl( hypre_long_double alpha, hypre_Vector *x, hypre_Vector *y );

HYPRE_Int
hypre_SeqVectorAxpyHost_flt( hypre_float alpha, hypre_Vector *x, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorAxpyHost_dbl( hypre_double alpha, hypre_Vector *x, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorAxpyHost_long_dbl( hypre_long_double alpha, hypre_Vector *x, hypre_Vector *y );

HYPRE_Int
hypre_SeqVectorAxpyz_flt( hypre_float alpha, hypre_Vector *x, hypre_float beta, hypre_Vector *y, hypre_Vector *z );
HYPRE_Int
hypre_SeqVectorAxpyz_dbl( hypre_double alpha, hypre_Vector *x, hypre_double beta, hypre_Vector *y, hypre_Vector *z );
HYPRE_Int
hypre_SeqVectorAxpyz_long_dbl( hypre_long_double alpha, hypre_Vector *x, hypre_long_double beta, hypre_Vector *y, hypre_Vector *z );

hypre_Vector *
hypre_SeqVectorCloneDeep_flt( hypre_Vector *x );
hypre_Vector *
hypre_SeqVectorCloneDeep_dbl( hypre_Vector *x );
hypre_Vector *
hypre_SeqVectorCloneDeep_long_dbl( hypre_Vector *x );

hypre_Vector *
hypre_SeqVectorCloneDeep_v2_flt( hypre_Vector *x, HYPRE_MemoryLocation memory_location );
hypre_Vector *
hypre_SeqVectorCloneDeep_v2_dbl( hypre_Vector *x, HYPRE_MemoryLocation memory_location );
hypre_Vector *
hypre_SeqVectorCloneDeep_v2_long_dbl( hypre_Vector *x, HYPRE_MemoryLocation memory_location );

hypre_Vector *
hypre_SeqVectorCloneShallow_flt( hypre_Vector *x );
hypre_Vector *
hypre_SeqVectorCloneShallow_dbl( hypre_Vector *x );
hypre_Vector *
hypre_SeqVectorCloneShallow_long_dbl( hypre_Vector *x );

HYPRE_Int
hypre_SeqVectorCopy_flt( hypre_Vector *x, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorCopy_dbl( hypre_Vector *x, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorCopy_long_dbl( hypre_Vector *x, hypre_Vector *y );

HYPRE_Int
hypre_SeqVectorCopyTags_flt( hypre_Vector *x, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorCopyTags_dbl( hypre_Vector *x, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorCopyTags_long_dbl( hypre_Vector *x, hypre_Vector *y );

hypre_Vector *
hypre_SeqVectorCreate_flt( HYPRE_Int size );
hypre_Vector *
hypre_SeqVectorCreate_dbl( HYPRE_Int size );
hypre_Vector *
hypre_SeqVectorCreate_long_dbl( HYPRE_Int size );

HYPRE_Int
hypre_SeqVectorDestroy_flt( hypre_Vector *vector );
HYPRE_Int
hypre_SeqVectorDestroy_dbl( hypre_Vector *vector );
HYPRE_Int
hypre_SeqVectorDestroy_long_dbl( hypre_Vector *vector );

HYPRE_Int
hypre_SeqVectorInitialize_flt( hypre_Vector *vector );
HYPRE_Int
hypre_SeqVectorInitialize_dbl( hypre_Vector *vector );
HYPRE_Int
hypre_SeqVectorInitialize_long_dbl( hypre_Vector *vector );

HYPRE_Int
hypre_SeqVectorInitializeShell_flt( hypre_Vector *vector );
HYPRE_Int
hypre_SeqVectorInitializeShell_dbl( hypre_Vector *vector );
HYPRE_Int
hypre_SeqVectorInitializeShell_long_dbl( hypre_Vector *vector );

HYPRE_Int
hypre_SeqVectorInitialize_v2_flt( hypre_Vector *vector, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_SeqVectorInitialize_v2_dbl( hypre_Vector *vector, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_SeqVectorInitialize_v2_long_dbl( hypre_Vector *vector, HYPRE_MemoryLocation memory_location );

HYPRE_Real
hypre_SeqVectorInnerProd_flt( hypre_Vector *x, hypre_Vector *y );
HYPRE_Real
hypre_SeqVectorInnerProd_dbl( hypre_Vector *x, hypre_Vector *y );
HYPRE_Real
hypre_SeqVectorInnerProd_long_dbl( hypre_Vector *x, hypre_Vector *y );

HYPRE_Real
hypre_SeqVectorInnerProdHost_flt( hypre_Vector *x, hypre_Vector *y );
HYPRE_Real
hypre_SeqVectorInnerProdHost_dbl( hypre_Vector *x, hypre_Vector *y );
HYPRE_Real
hypre_SeqVectorInnerProdHost_long_dbl( hypre_Vector *x, hypre_Vector *y );

HYPRE_Int
hypre_SeqVectorInnerProdTagged_flt( hypre_Vector *x, hypre_Vector *y, hypre_float *iprod );
HYPRE_Int
hypre_SeqVectorInnerProdTagged_dbl( hypre_Vector *x, hypre_Vector *y, hypre_double *iprod );
HYPRE_Int
hypre_SeqVectorInnerProdTagged_long_dbl( hypre_Vector *x, hypre_Vector *y, hypre_long_double *iprod );

HYPRE_Int
hypre_SeqVectorMassAxpy_flt( hypre_float *alpha, hypre_Vector **x, hypre_Vector *y, HYPRE_Int k, HYPRE_Int unroll );
HYPRE_Int
hypre_SeqVectorMassAxpy_dbl( hypre_double *alpha, hypre_Vector **x, hypre_Vector *y, HYPRE_Int k, HYPRE_Int unroll );
HYPRE_Int
hypre_SeqVectorMassAxpy_long_dbl( hypre_long_double *alpha, hypre_Vector **x, hypre_Vector *y, HYPRE_Int k, HYPRE_Int unroll );

HYPRE_Int
hypre_SeqVectorMassAxpy4_flt( hypre_float *alpha, hypre_Vector **x, hypre_Vector *y, HYPRE_Int k );
HYPRE_Int
hypre_SeqVectorMassAxpy4_dbl( hypre_double *alpha, hypre_Vector **x, hypre_Vector *y, HYPRE_Int k );
HYPRE_Int
hypre_SeqVectorMassAxpy4_long_dbl( hypre_long_double *alpha, hypre_Vector **x, hypre_Vector *y, HYPRE_Int k );

HYPRE_Int
hypre_SeqVectorMassAxpy8_flt( hypre_float *alpha, hypre_Vector **x, hypre_Vector *y, HYPRE_Int k );
HYPRE_Int
hypre_SeqVectorMassAxpy8_dbl( hypre_double *alpha, hypre_Vector **x, hypre_Vector *y, HYPRE_Int k );
HYPRE_Int
hypre_SeqVectorMassAxpy8_long_dbl( hypre_long_double *alpha, hypre_Vector **x, hypre_Vector *y, HYPRE_Int k );

HYPRE_Int
hypre_SeqVectorMassDotpTwo_flt( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z, HYPRE_Int k, HYPRE_Int unroll, hypre_float *result_x, hypre_float *result_y );
HYPRE_Int
hypre_SeqVectorMassDotpTwo_dbl( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z, HYPRE_Int k, HYPRE_Int unroll, hypre_double *result_x, hypre_double *result_y );
HYPRE_Int
hypre_SeqVectorMassDotpTwo_long_dbl( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z, HYPRE_Int k, HYPRE_Int unroll, hypre_long_double *result_x, hypre_long_double *result_y );

HYPRE_Int
hypre_SeqVectorMassDotpTwo4_flt( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z, HYPRE_Int k, hypre_float *result_x, hypre_float *result_y );
HYPRE_Int
hypre_SeqVectorMassDotpTwo4_dbl( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z, HYPRE_Int k, hypre_double *result_x, hypre_double *result_y );
HYPRE_Int
hypre_SeqVectorMassDotpTwo4_long_dbl( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z, HYPRE_Int k, hypre_long_double *result_x, hypre_long_double *result_y );

HYPRE_Int
hypre_SeqVectorMassDotpTwo8_flt( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z, HYPRE_Int k, hypre_float *result_x, hypre_float *result_y );
HYPRE_Int
hypre_SeqVectorMassDotpTwo8_dbl( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z, HYPRE_Int k, hypre_double *result_x, hypre_double *result_y );
HYPRE_Int
hypre_SeqVectorMassDotpTwo8_long_dbl( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z, HYPRE_Int k, hypre_long_double *result_x, hypre_long_double *result_y );

HYPRE_Int
hypre_SeqVectorMassInnerProd_flt( hypre_Vector *x, hypre_Vector **y, HYPRE_Int k, HYPRE_Int unroll, hypre_float *result );
HYPRE_Int
hypre_SeqVectorMassInnerProd_dbl( hypre_Vector *x, hypre_Vector **y, HYPRE_Int k, HYPRE_Int unroll, hypre_double *result );
HYPRE_Int
hypre_SeqVectorMassInnerProd_long_dbl( hypre_Vector *x, hypre_Vector **y, HYPRE_Int k, HYPRE_Int unroll, hypre_long_double *result );

HYPRE_Int
hypre_SeqVectorMassInnerProd4_flt( hypre_Vector *x, hypre_Vector **y, HYPRE_Int k, hypre_float *result );
HYPRE_Int
hypre_SeqVectorMassInnerProd4_dbl( hypre_Vector *x, hypre_Vector **y, HYPRE_Int k, hypre_double *result );
HYPRE_Int
hypre_SeqVectorMassInnerProd4_long_dbl( hypre_Vector *x, hypre_Vector **y, HYPRE_Int k, hypre_long_double *result );

HYPRE_Int
hypre_SeqVectorMassInnerProd8_flt( hypre_Vector *x, hypre_Vector **y, HYPRE_Int k, hypre_float *result );
HYPRE_Int
hypre_SeqVectorMassInnerProd8_dbl( hypre_Vector *x, hypre_Vector **y, HYPRE_Int k, hypre_double *result );
HYPRE_Int
hypre_SeqVectorMassInnerProd8_long_dbl( hypre_Vector *x, hypre_Vector **y, HYPRE_Int k, hypre_long_double *result );

HYPRE_Int
hypre_SeqVectorMigrate_flt( hypre_Vector *x, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_SeqVectorMigrate_dbl( hypre_Vector *x, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_SeqVectorMigrate_long_dbl( hypre_Vector *x, HYPRE_MemoryLocation memory_location );

HYPRE_Int
hypre_SeqVectorPointwiseDivision_flt( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z_ptr );
HYPRE_Int
hypre_SeqVectorPointwiseDivision_dbl( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z_ptr );
HYPRE_Int
hypre_SeqVectorPointwiseDivision_long_dbl( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z_ptr );

HYPRE_Int
hypre_SeqVectorPointwiseDivpy_flt( hypre_Vector *x, hypre_Vector *b, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorPointwiseDivpy_dbl( hypre_Vector *x, hypre_Vector *b, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorPointwiseDivpy_long_dbl( hypre_Vector *x, hypre_Vector *b, hypre_Vector *y );

HYPRE_Int
hypre_SeqVectorPointwiseDivpyMarked_flt( hypre_Vector *x, hypre_Vector *b, hypre_Vector *y, HYPRE_Int *marker, HYPRE_Int marker_val );
HYPRE_Int
hypre_SeqVectorPointwiseDivpyMarked_dbl( hypre_Vector *x, hypre_Vector *b, hypre_Vector *y, HYPRE_Int *marker, HYPRE_Int marker_val );
HYPRE_Int
hypre_SeqVectorPointwiseDivpyMarked_long_dbl( hypre_Vector *x, hypre_Vector *b, hypre_Vector *y, HYPRE_Int *marker, HYPRE_Int marker_val );

HYPRE_Int
hypre_SeqVectorPointwiseInverse_flt( hypre_Vector *x, hypre_Vector **y_ptr );
HYPRE_Int
hypre_SeqVectorPointwiseInverse_dbl( hypre_Vector *x, hypre_Vector **y_ptr );
HYPRE_Int
hypre_SeqVectorPointwiseInverse_long_dbl( hypre_Vector *x, hypre_Vector **y_ptr );

HYPRE_Int
hypre_SeqVectorPointwiseProduct_flt( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z_ptr );
HYPRE_Int
hypre_SeqVectorPointwiseProduct_dbl( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z_ptr );
HYPRE_Int
hypre_SeqVectorPointwiseProduct_long_dbl( hypre_Vector *x, hypre_Vector *y, hypre_Vector **z_ptr );

HYPRE_Int
hypre_SeqVectorPrint_flt( hypre_Vector *vector, char *file_name );
HYPRE_Int
hypre_SeqVectorPrint_dbl( hypre_Vector *vector, char *file_name );
HYPRE_Int
hypre_SeqVectorPrint_long_dbl( hypre_Vector *vector, char *file_name );

hypre_Vector *
hypre_SeqVectorRead_flt( char *file_name );
hypre_Vector *
hypre_SeqVectorRead_dbl( char *file_name );
hypre_Vector *
hypre_SeqVectorRead_long_dbl( char *file_name );

HYPRE_Int
hypre_SeqVectorResize_flt( hypre_Vector *vector, HYPRE_Int size_in, HYPRE_Int num_vectors_in );
HYPRE_Int
hypre_SeqVectorResize_dbl( hypre_Vector *vector, HYPRE_Int size_in, HYPRE_Int num_vectors_in );
HYPRE_Int
hypre_SeqVectorResize_long_dbl( hypre_Vector *vector, HYPRE_Int size_in, HYPRE_Int num_vectors_in );

HYPRE_Int
hypre_SeqVectorScale_flt( hypre_float alpha, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorScale_dbl( hypre_double alpha, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorScale_long_dbl( hypre_long_double alpha, hypre_Vector *y );

HYPRE_Int
hypre_SeqVectorScaleHost_flt( hypre_float alpha, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorScaleHost_dbl( hypre_double alpha, hypre_Vector *y );
HYPRE_Int
hypre_SeqVectorScaleHost_long_dbl( hypre_long_double alpha, hypre_Vector *y );

HYPRE_Int
hypre_SeqVectorSetConstantValues_flt( hypre_Vector *v, hypre_float value );
HYPRE_Int
hypre_SeqVectorSetConstantValues_dbl( hypre_Vector *v, hypre_double value );
HYPRE_Int
hypre_SeqVectorSetConstantValues_long_dbl( hypre_Vector *v, hypre_long_double value );

HYPRE_Int
hypre_SeqVectorSetConstantValuesHost_flt( hypre_Vector *v, hypre_float value );
HYPRE_Int
hypre_SeqVectorSetConstantValuesHost_dbl( hypre_Vector *v, hypre_double value );
HYPRE_Int
hypre_SeqVectorSetConstantValuesHost_long_dbl( hypre_Vector *v, hypre_long_double value );

HYPRE_Int
hypre_SeqVectorSetData_flt( hypre_Vector *vector, hypre_float *data );
HYPRE_Int
hypre_SeqVectorSetData_dbl( hypre_Vector *vector, hypre_double *data );
HYPRE_Int
hypre_SeqVectorSetData_long_dbl( hypre_Vector *vector, hypre_long_double *data );

HYPRE_Int
hypre_SeqVectorSetDataOwner_flt( hypre_Vector *vector, HYPRE_Int owns_data );
HYPRE_Int
hypre_SeqVectorSetDataOwner_dbl( hypre_Vector *vector, HYPRE_Int owns_data );
HYPRE_Int
hypre_SeqVectorSetDataOwner_long_dbl( hypre_Vector *vector, HYPRE_Int owns_data );

HYPRE_Int
hypre_SeqVectorSetNumTags_flt( hypre_Vector *vector, HYPRE_Int num_tags );
HYPRE_Int
hypre_SeqVectorSetNumTags_dbl( hypre_Vector *vector, HYPRE_Int num_tags );
HYPRE_Int
hypre_SeqVectorSetNumTags_long_dbl( hypre_Vector *vector, HYPRE_Int num_tags );

HYPRE_Int
hypre_SeqVectorSetOwnsTags_flt( hypre_Vector *vector, HYPRE_Int owns_tags );
HYPRE_Int
hypre_SeqVectorSetOwnsTags_dbl( hypre_Vector *vector, HYPRE_Int owns_tags );
HYPRE_Int
hypre_SeqVectorSetOwnsTags_long_dbl( hypre_Vector *vector, HYPRE_Int owns_tags );

HYPRE_Int
hypre_SeqVectorSetRandomValues_flt( hypre_Vector *v, HYPRE_Int seed );
HYPRE_Int
hypre_SeqVectorSetRandomValues_dbl( hypre_Vector *v, HYPRE_Int seed );
HYPRE_Int
hypre_SeqVectorSetRandomValues_long_dbl( hypre_Vector *v, HYPRE_Int seed );

HYPRE_Int
hypre_SeqVectorSetSize_flt( hypre_Vector *vector, HYPRE_Int size );
HYPRE_Int
hypre_SeqVectorSetSize_dbl( hypre_Vector *vector, HYPRE_Int size );
HYPRE_Int
hypre_SeqVectorSetSize_long_dbl( hypre_Vector *vector, HYPRE_Int size );

HYPRE_Int
hypre_SeqVectorSetTags_flt( hypre_Vector *vector, HYPRE_MemoryLocation memory_location, HYPRE_Int *tags );
HYPRE_Int
hypre_SeqVectorSetTags_dbl( hypre_Vector *vector, HYPRE_MemoryLocation memory_location, HYPRE_Int *tags );
HYPRE_Int
hypre_SeqVectorSetTags_long_dbl( hypre_Vector *vector, HYPRE_MemoryLocation memory_location, HYPRE_Int *tags );

HYPRE_Int
hypre_SeqVectorSetValuesTagged_flt( hypre_Vector *vector, hypre_float *values );
HYPRE_Int
hypre_SeqVectorSetValuesTagged_dbl( hypre_Vector *vector, hypre_double *values );
HYPRE_Int
hypre_SeqVectorSetValuesTagged_long_dbl( hypre_Vector *vector, hypre_long_double *values );

HYPRE_Int
hypre_SeqVectorStridedCopy_flt( hypre_Vector *x, HYPRE_Int istride, HYPRE_Int ostride, HYPRE_Int size, hypre_float *data );
HYPRE_Int
hypre_SeqVectorStridedCopy_dbl( hypre_Vector *x, HYPRE_Int istride, HYPRE_Int ostride, HYPRE_Int size, hypre_double *data );
HYPRE_Int
hypre_SeqVectorStridedCopy_long_dbl( hypre_Vector *x, HYPRE_Int istride, HYPRE_Int ostride, HYPRE_Int size, hypre_long_double *data );

HYPRE_Complex
hypre_SeqVectorSumElts_flt( hypre_Vector *vector );
HYPRE_Complex
hypre_SeqVectorSumElts_dbl( hypre_Vector *vector );
HYPRE_Complex
hypre_SeqVectorSumElts_long_dbl( hypre_Vector *vector );

HYPRE_Complex
hypre_SeqVectorSumEltsHost_flt( hypre_Vector *vector );
HYPRE_Complex
hypre_SeqVectorSumEltsHost_dbl( hypre_Vector *vector );
HYPRE_Complex
hypre_SeqVectorSumEltsHost_long_dbl( hypre_Vector *vector );


/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



#endif

#ifdef __cplusplus
}
#endif

#endif

