/*
 *
 * Copyright (C) 2024, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Zhenyu Wang <wangzhenyu@kylinos.cn>
 *
 */

#include "../../kysdk-appconf2/src/kconf2.h"
#include <QtTest>

// add necessary includes here
using namespace kdk;

class AppconfTest : public QObject
{
    Q_OBJECT

private slots:
    void appconfTest();
};

void AppconfTest::appconfTest()
{
    KConf2 m_styleSettings("style");
    KConf2 m_settings("control-center");

    if (KConf2::isSettingsAvailable("control-center")) {
        QStringList fontList = m_settings.get("fonts-list").toStringList();
        qDebug() << "fontlist =" << fontList;

        QStringList list1;
        list1 << "111"
              << "222"
              << "333";
        QVariant va(list1);
        m_settings.set("fonts-list", va);

        m_settings.keys();

        m_settings.schemas("control-center", "2.0.0-0k0.0");

        QString str1("fonts-list");
        m_settings.getDescrition(str1);

        QString str2("fonts-list");
        m_settings.getSummary(str2);

        QString str3("fonts-list");
        m_settings.getType(str3);

        QString str4("enabled");
        m_settings.isWritable(str4);

        m_settings.getId();

        m_settings.getVersion();

        QString str5("apt");
        m_settings.getChild(str5);
        //        m_settings.getChild(str5)->getId();

        m_settings.children();

        m_settings.reset("fonts-list");

        m_settings.trySet("fonts-list", "font-list");

        m_settings.get("defaultapp-blacklist");
        m_settings.get("default-shortcut");
    }

    if (KConf2::isSettingsAvailable("style")) {
        m_styleSettings.set("system-font-size", "11");
    }
}

QTEST_APPLESS_MAIN(AppconfTest)

#include "appconftest.moc"
