% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{call_function}
\alias{call_function}
\title{Call an Arrow compute function}
\usage{
call_function(
  function_name,
  ...,
  args = list(...),
  options = empty_named_list()
)
}
\arguments{
\item{function_name}{string Arrow compute function name}

\item{...}{Function arguments, which may include \code{Array}, \code{ChunkedArray}, \code{Scalar},
\code{RecordBatch}, or \code{Table}.}

\item{args}{list arguments as an alternative to specifying in \code{...}}

\item{options}{named list of C++ function options.}
}
\value{
An \code{Array}, \code{ChunkedArray}, \code{Scalar}, \code{RecordBatch}, or \code{Table}, whatever the compute function results in.
}
\description{
This function provides a lower-level API for calling Arrow functions by their
string function name. You won't use it directly for most applications.
Many Arrow compute functions are mapped to R methods,
and in a \code{dplyr} evaluation context, \link[=list_compute_functions]{all Arrow functions}
are callable with an \code{arrow_} prefix.
}
\details{
When passing indices in \code{...}, \code{args}, or \code{options}, express them as
0-based integers (consistent with C++).
}
\examples{
\dontshow{if (arrow_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
a <- Array$create(c(1L, 2L, 3L, NA, 5L))
s <- Scalar$create(4L)
call_function("coalesce", a, s)

a <- Array$create(rnorm(10000))
call_function("quantile", a, options = list(q = seq(0, 1, 0.25)))
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://arrow.apache.org/docs/cpp/compute.html}{Arrow C++ documentation} for
the functions and their respective options.
}
