/*
 * Copyright 2020 Cypress Semiconductor Corporation.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#include "config.h"

#include "fu-ccgx-firmware.h"
#include "fu-ccgx-hid-device.h"
#include "fu-ccgx-hpi-device.h"
#include "fu-ccgx-plugin.h"
#include "fu-ccgx-pure-hid-device.h"

struct _FuCcgxPlugin {
	FuPlugin parent_instance;
};

G_DEFINE_TYPE(FuCcgxPlugin, fu_ccgx_plugin, FU_TYPE_PLUGIN)

static void
fu_ccgx_plugin_init(FuCcgxPlugin *self)
{
	fu_plugin_add_flag(FU_PLUGIN(self), FWUPD_PLUGIN_FLAG_MUTABLE_ENUMERATION);
}

static void
fu_ccgx_plugin_constructed(GObject *obj)
{
	FuPlugin *plugin = FU_PLUGIN(obj);
	FuContext *ctx = fu_plugin_get_context(plugin);
	fu_context_add_quirk_key(ctx, "CcgxFlashRowSize");
	fu_context_add_quirk_key(ctx, "CcgxFlashSize");
	fu_context_add_quirk_key(ctx, "CcgxImageKind");
	fu_plugin_add_udev_subsystem(plugin, "usb");
	fu_plugin_add_firmware_gtype(plugin, NULL, FU_TYPE_CCGX_FIRMWARE);
	fu_plugin_add_device_gtype(plugin, FU_TYPE_CCGX_HID_DEVICE);
	fu_plugin_add_device_gtype(plugin, FU_TYPE_CCGX_PURE_HID_DEVICE);
	fu_plugin_add_device_gtype(plugin, FU_TYPE_CCGX_HPI_DEVICE);
}

static void
fu_ccgx_plugin_class_init(FuCcgxPluginClass *klass)
{
	FuPluginClass *plugin_class = FU_PLUGIN_CLASS(klass);
	plugin_class->constructed = fu_ccgx_plugin_constructed;
}
