#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Lion's Song
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240915.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='the-lions-song'
GAME_NAME='The Lion’s Song'

ARCHIVE_BASE_0_NAME='the_lion_s_song_0_7_35794.sh'
ARCHIVE_BASE_0_MD5='bc86daa55b3afd2714bafce8e5bed230'
ARCHIVE_BASE_0_SIZE='360000'
ARCHIVE_BASE_0_VERSION='0.7-gog35794'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_lions_song'

CONTENT_PATH_DEFAULT='data/noarch/game/GameData'
CONTENT_GAME_BIN_FILES='
engine.cfg
TLS'
CONTENT_GAME_DATA_FILES='
Assets
LZ4_license.txt
Vollkorn_SILOpenFontLicensev1_10.txt
*.base
*.bundle
*.header
*.universe
*.world
*.it
*.en
*.es
*.fr
*.ru'

APP_MAIN_EXE='TLS'
APP_MAIN_ICON='../../support/icon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libcurl.so.4
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libstdc++.so.6
libuuid.so.1
libX11.so.6
libXcursor.so.1
libXinerama.so.1
libXrandr.so.2
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
