#[inline]
pub unsafe fn CreateDataModelManager<P0>(debughost: P0) -> windows_core::Result<IDataModelManager>
where
    P0: windows_core::Param<IDebugHost>,
{
    windows_targets::link!("dbgmodel.dll" "system" fn CreateDataModelManager(debughost : * mut core::ffi::c_void, manager : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    CreateDataModelManager(debughost.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn DebugConnect<P0>(remoteoptions: P0, interfaceid: *const windows_core::GUID, interface: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("dbgeng.dll" "system" fn DebugConnect(remoteoptions : windows_core::PCSTR, interfaceid : *const windows_core::GUID, interface : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    DebugConnect(remoteoptions.param().abi(), interfaceid, interface).ok()
}
#[inline]
pub unsafe fn DebugConnectWide<P0>(remoteoptions: P0, interfaceid: *const windows_core::GUID, interface: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("dbgeng.dll" "system" fn DebugConnectWide(remoteoptions : windows_core::PCWSTR, interfaceid : *const windows_core::GUID, interface : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    DebugConnectWide(remoteoptions.param().abi(), interfaceid, interface).ok()
}
#[inline]
pub unsafe fn DebugCreate<T>() -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_targets::link!("dbgeng.dll" "system" fn DebugCreate(interfaceid : *const windows_core::GUID, interface : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = std::ptr::null_mut();
    DebugCreate(&T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn DebugCreateEx<T>(dbgengoptions: u32) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_targets::link!("dbgeng.dll" "system" fn DebugCreateEx(interfaceid : *const windows_core::GUID, dbgengoptions : u32, interface : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = std::ptr::null_mut();
    DebugCreateEx(&T::IID, dbgengoptions, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
windows_core::imp::define_interface!(DebugBaseEventCallbacks, DebugBaseEventCallbacks_Vtbl, 0);
impl std::ops::Deref for DebugBaseEventCallbacks {
    type Target = IDebugEventCallbacks;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(DebugBaseEventCallbacks, windows_core::IUnknown, IDebugEventCallbacks);
impl DebugBaseEventCallbacks {}
#[repr(C)]
pub struct DebugBaseEventCallbacks_Vtbl {
    pub base__: IDebugEventCallbacks_Vtbl,
}
windows_core::imp::define_interface!(DebugBaseEventCallbacksWide, DebugBaseEventCallbacksWide_Vtbl, 0);
impl std::ops::Deref for DebugBaseEventCallbacksWide {
    type Target = IDebugEventCallbacksWide;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(DebugBaseEventCallbacksWide, windows_core::IUnknown, IDebugEventCallbacksWide);
impl DebugBaseEventCallbacksWide {}
#[repr(C)]
pub struct DebugBaseEventCallbacksWide_Vtbl {
    pub base__: IDebugEventCallbacksWide_Vtbl,
}
windows_core::imp::define_interface!(ICodeAddressConcept, ICodeAddressConcept_Vtbl, 0xc7371568_5c78_4a00_a4ab_6ef8823184cb);
impl std::ops::Deref for ICodeAddressConcept {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICodeAddressConcept, windows_core::IUnknown);
impl ICodeAddressConcept {
    pub unsafe fn GetContainingSymbol<P0>(&self, pcontextobject: P0) -> windows_core::Result<IDebugHostSymbol>
    where
        P0: windows_core::Param<IModelObject>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetContainingSymbol)(windows_core::Interface::as_raw(self), pcontextobject.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct ICodeAddressConcept_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetContainingSymbol: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IComparableConcept, IComparableConcept_Vtbl, 0xa7830646_9f0c_4a31_ba19_503f33e6c8a3);
impl std::ops::Deref for IComparableConcept {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IComparableConcept, windows_core::IUnknown);
impl IComparableConcept {
    pub unsafe fn CompareObjects<P0, P1>(&self, contextobject: P0, otherobject: P1) -> windows_core::Result<i32>
    where
        P0: windows_core::Param<IModelObject>,
        P1: windows_core::Param<IModelObject>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CompareObjects)(windows_core::Interface::as_raw(self), contextobject.param().abi(), otherobject.param().abi(), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IComparableConcept_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CompareObjects: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelConcept, IDataModelConcept_Vtbl, 0xfcb98d1d_1114_4fbf_b24c_effcb5def0d3);
impl std::ops::Deref for IDataModelConcept {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelConcept, windows_core::IUnknown);
impl IDataModelConcept {
    pub unsafe fn InitializeObject<P0, P1, P2>(&self, modelobject: P0, matchingtypesignature: P1, wildcardmatches: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IModelObject>,
        P1: windows_core::Param<IDebugHostTypeSignature>,
        P2: windows_core::Param<IDebugHostSymbolEnumerator>,
    {
        (windows_core::Interface::vtable(self).InitializeObject)(windows_core::Interface::as_raw(self), modelobject.param().abi(), matchingtypesignature.param().abi(), wildcardmatches.param().abi()).ok()
    }
    pub unsafe fn GetName(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelConcept_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub InitializeObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelManager, IDataModelManager_Vtbl, 0x73fe19f4_a110_4500_8ed9_3c28896f508c);
impl std::ops::Deref for IDataModelManager {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelManager, windows_core::IUnknown);
impl IDataModelManager {
    pub unsafe fn Close(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Close)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn CreateNoValue(&self) -> windows_core::Result<IModelObject> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateNoValue)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateErrorObject<P0>(&self, hrerror: windows_core::HRESULT, pwszmessage: P0) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateErrorObject)(windows_core::Interface::as_raw(self), hrerror, pwszmessage.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateTypedObject<P0, P1>(&self, context: P0, objectlocation: Location, objecttype: P1) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDebugHostContext>,
        P1: windows_core::Param<IDebugHostType>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateTypedObject)(windows_core::Interface::as_raw(self), context.param().abi(), core::mem::transmute(objectlocation), objecttype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateTypedObjectReference<P0, P1>(&self, context: P0, objectlocation: Location, objecttype: P1) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDebugHostContext>,
        P1: windows_core::Param<IDebugHostType>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateTypedObjectReference)(windows_core::Interface::as_raw(self), context.param().abi(), core::mem::transmute(objectlocation), objecttype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateSyntheticObject<P0>(&self, context: P0) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDebugHostContext>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateSyntheticObject)(windows_core::Interface::as_raw(self), context.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateDataModelObject<P0>(&self, datamodel: P0) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDataModelConcept>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateDataModelObject)(windows_core::Interface::as_raw(self), datamodel.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateIntrinsicObject(&self, objectkind: ModelObjectKind, intrinsicdata: *const windows_core::VARIANT) -> windows_core::Result<IModelObject> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateIntrinsicObject)(windows_core::Interface::as_raw(self), objectkind, core::mem::transmute(intrinsicdata), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateTypedIntrinsicObject<P0>(&self, intrinsicdata: *const windows_core::VARIANT, r#type: P0) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDebugHostType>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateTypedIntrinsicObject)(windows_core::Interface::as_raw(self), core::mem::transmute(intrinsicdata), r#type.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetModelForTypeSignature<P0>(&self, typesignature: P0) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDebugHostTypeSignature>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetModelForTypeSignature)(windows_core::Interface::as_raw(self), typesignature.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetModelForType<P0>(&self, r#type: P0, datamodel: *mut Option<IModelObject>, typesignature: Option<*mut Option<IDebugHostTypeSignature>>, wildcardmatches: Option<*mut Option<IDebugHostSymbolEnumerator>>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugHostType>,
    {
        (windows_core::Interface::vtable(self).GetModelForType)(windows_core::Interface::as_raw(self), r#type.param().abi(), core::mem::transmute(datamodel), core::mem::transmute(typesignature.unwrap_or(std::ptr::null_mut())), core::mem::transmute(wildcardmatches.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn RegisterModelForTypeSignature<P0, P1>(&self, typesignature: P0, datamodel: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugHostTypeSignature>,
        P1: windows_core::Param<IModelObject>,
    {
        (windows_core::Interface::vtable(self).RegisterModelForTypeSignature)(windows_core::Interface::as_raw(self), typesignature.param().abi(), datamodel.param().abi()).ok()
    }
    pub unsafe fn UnregisterModelForTypeSignature<P0, P1>(&self, datamodel: P0, typesignature: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IModelObject>,
        P1: windows_core::Param<IDebugHostTypeSignature>,
    {
        (windows_core::Interface::vtable(self).UnregisterModelForTypeSignature)(windows_core::Interface::as_raw(self), datamodel.param().abi(), typesignature.param().abi()).ok()
    }
    pub unsafe fn RegisterExtensionForTypeSignature<P0, P1>(&self, typesignature: P0, datamodel: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugHostTypeSignature>,
        P1: windows_core::Param<IModelObject>,
    {
        (windows_core::Interface::vtable(self).RegisterExtensionForTypeSignature)(windows_core::Interface::as_raw(self), typesignature.param().abi(), datamodel.param().abi()).ok()
    }
    pub unsafe fn UnregisterExtensionForTypeSignature<P0, P1>(&self, datamodel: P0, typesignature: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IModelObject>,
        P1: windows_core::Param<IDebugHostTypeSignature>,
    {
        (windows_core::Interface::vtable(self).UnregisterExtensionForTypeSignature)(windows_core::Interface::as_raw(self), datamodel.param().abi(), typesignature.param().abi()).ok()
    }
    pub unsafe fn CreateMetadataStore<P0>(&self, parentstore: P0) -> windows_core::Result<IKeyStore>
    where
        P0: windows_core::Param<IKeyStore>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateMetadataStore)(windows_core::Interface::as_raw(self), parentstore.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetRootNamespace(&self) -> windows_core::Result<IModelObject> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRootNamespace)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RegisterNamedModel<P0, P1>(&self, modelname: P0, modeobject: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<IModelObject>,
    {
        (windows_core::Interface::vtable(self).RegisterNamedModel)(windows_core::Interface::as_raw(self), modelname.param().abi(), modeobject.param().abi()).ok()
    }
    pub unsafe fn UnregisterNamedModel<P0>(&self, modelname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).UnregisterNamedModel)(windows_core::Interface::as_raw(self), modelname.param().abi()).ok()
    }
    pub unsafe fn AcquireNamedModel<P0>(&self, modelname: P0) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AcquireNamedModel)(windows_core::Interface::as_raw(self), modelname.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelManager_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Close: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateNoValue: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateErrorObject: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::HRESULT, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateTypedObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, Location, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateTypedObjectReference: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, Location, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateSyntheticObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateDataModelObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateIntrinsicObject: unsafe extern "system" fn(*mut core::ffi::c_void, ModelObjectKind, *const std::mem::MaybeUninit<windows_core::VARIANT>, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateTypedIntrinsicObject: unsafe extern "system" fn(*mut core::ffi::c_void, *const std::mem::MaybeUninit<windows_core::VARIANT>, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetModelForTypeSignature: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetModelForType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterModelForTypeSignature: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UnregisterModelForTypeSignature: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterExtensionForTypeSignature: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UnregisterExtensionForTypeSignature: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateMetadataStore: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRootNamespace: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterNamedModel: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UnregisterNamedModel: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AcquireNamedModel: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelManager2, IDataModelManager2_Vtbl, 0xf412c5ea_2284_4622_a660_a697160d3312);
impl std::ops::Deref for IDataModelManager2 {
    type Target = IDataModelManager;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelManager2, windows_core::IUnknown, IDataModelManager);
impl IDataModelManager2 {
    pub unsafe fn AcquireSubNamespace<P0, P1, P2, P3>(&self, modelname: P0, subnamespacemodelname: P1, accessname: P2, metadata: P3) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<IKeyStore>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AcquireSubNamespace)(windows_core::Interface::as_raw(self), modelname.param().abi(), subnamespacemodelname.param().abi(), accessname.param().abi(), metadata.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateTypedIntrinsicObjectEx<P0, P1>(&self, context: P0, intrinsicdata: *const windows_core::VARIANT, r#type: P1) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDebugHostContext>,
        P1: windows_core::Param<IDebugHostType>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateTypedIntrinsicObjectEx)(windows_core::Interface::as_raw(self), context.param().abi(), core::mem::transmute(intrinsicdata), r#type.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelManager2_Vtbl {
    pub base__: IDataModelManager_Vtbl,
    pub AcquireSubNamespace: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, windows_core::PCWSTR, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateTypedIntrinsicObjectEx: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const std::mem::MaybeUninit<windows_core::VARIANT>, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelNameBinder, IDataModelNameBinder_Vtbl, 0xaf352b7b_8292_4c01_b360_2dc3696c65e7);
impl std::ops::Deref for IDataModelNameBinder {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelNameBinder, windows_core::IUnknown);
impl IDataModelNameBinder {
    pub unsafe fn BindValue<P0, P1>(&self, contextobject: P0, name: P1, value: *mut Option<IModelObject>, metadata: Option<*mut Option<IKeyStore>>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IModelObject>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).BindValue)(windows_core::Interface::as_raw(self), contextobject.param().abi(), name.param().abi(), core::mem::transmute(value), core::mem::transmute(metadata.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn BindReference<P0, P1>(&self, contextobject: P0, name: P1, reference: *mut Option<IModelObject>, metadata: Option<*mut Option<IKeyStore>>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IModelObject>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).BindReference)(windows_core::Interface::as_raw(self), contextobject.param().abi(), name.param().abi(), core::mem::transmute(reference), core::mem::transmute(metadata.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn EnumerateValues<P0>(&self, contextobject: P0) -> windows_core::Result<IKeyEnumerator>
    where
        P0: windows_core::Param<IModelObject>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).EnumerateValues)(windows_core::Interface::as_raw(self), contextobject.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn EnumerateReferences<P0>(&self, contextobject: P0) -> windows_core::Result<IKeyEnumerator>
    where
        P0: windows_core::Param<IModelObject>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).EnumerateReferences)(windows_core::Interface::as_raw(self), contextobject.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelNameBinder_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub BindValue: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub BindReference: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateValues: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateReferences: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScript, IDataModelScript_Vtbl, 0x7b4d30fc_b14a_49f8_8d87_d9a1480c97f7);
impl std::ops::Deref for IDataModelScript {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScript, windows_core::IUnknown);
impl IDataModelScript {
    pub unsafe fn GetName(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Rename<P0>(&self, scriptname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Rename)(windows_core::Interface::as_raw(self), scriptname.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Populate<P0>(&self, contentstream: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::super::Com::IStream>,
    {
        (windows_core::Interface::vtable(self).Populate)(windows_core::Interface::as_raw(self), contentstream.param().abi()).ok()
    }
    pub unsafe fn Execute<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScriptClient>,
    {
        (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), client.param().abi()).ok()
    }
    pub unsafe fn Unlink(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Unlink)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn IsInvocable(&self) -> windows_core::Result<bool> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).IsInvocable)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn InvokeMain<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScriptClient>,
    {
        (windows_core::Interface::vtable(self).InvokeMain)(windows_core::Interface::as_raw(self), client.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDataModelScript_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub Rename: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Populate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Populate: usize,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Unlink: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub IsInvocable: unsafe extern "system" fn(*mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub InvokeMain: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptClient, IDataModelScriptClient_Vtbl, 0x3b362b0e_89f0_46c6_a663_dfdc95194aef);
impl std::ops::Deref for IDataModelScriptClient {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptClient, windows_core::IUnknown);
impl IDataModelScriptClient {
    pub unsafe fn ReportError<P0>(&self, errclass: ErrorClass, hrfail: windows_core::HRESULT, message: P0, line: u32, position: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ReportError)(windows_core::Interface::as_raw(self), errclass, hrfail, message.param().abi(), line, position).ok()
    }
}
#[repr(C)]
pub struct IDataModelScriptClient_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ReportError: unsafe extern "system" fn(*mut core::ffi::c_void, ErrorClass, windows_core::HRESULT, windows_core::PCWSTR, u32, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptDebug, IDataModelScriptDebug_Vtbl, 0xde8e0945_9750_4471_ab76_a8f79d6ec350);
impl std::ops::Deref for IDataModelScriptDebug {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptDebug, windows_core::IUnknown);
impl IDataModelScriptDebug {
    pub unsafe fn GetDebugState(&self) -> ScriptDebugState {
        (windows_core::Interface::vtable(self).GetDebugState)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetCurrentPosition(&self, currentposition: *mut ScriptDebugPosition, positionspanend: Option<*mut ScriptDebugPosition>, linetext: Option<*mut windows_core::BSTR>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCurrentPosition)(windows_core::Interface::as_raw(self), currentposition, core::mem::transmute(positionspanend.unwrap_or(std::ptr::null_mut())), core::mem::transmute(linetext.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetStack(&self) -> windows_core::Result<IDataModelScriptDebugStack> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetStack)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetBreakpoint(&self, lineposition: u32, columnposition: u32) -> windows_core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).SetBreakpoint)(windows_core::Interface::as_raw(self), lineposition, columnposition, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn FindBreakpointById(&self, breakpointid: u64) -> windows_core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).FindBreakpointById)(windows_core::Interface::as_raw(self), breakpointid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn EnumerateBreakpoints(&self) -> windows_core::Result<IDataModelScriptDebugBreakpointEnumerator> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).EnumerateBreakpoints)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetEventFilter(&self, eventfilter: ScriptDebugEventFilter) -> windows_core::Result<bool> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventFilter)(windows_core::Interface::as_raw(self), eventfilter, &mut result__).map(|| result__)
    }
    pub unsafe fn SetEventFilter(&self, eventfilter: ScriptDebugEventFilter, isbreakenabled: u8) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEventFilter)(windows_core::Interface::as_raw(self), eventfilter, isbreakenabled).ok()
    }
    pub unsafe fn StartDebugging<P0>(&self, debugclient: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScriptDebugClient>,
    {
        (windows_core::Interface::vtable(self).StartDebugging)(windows_core::Interface::as_raw(self), debugclient.param().abi()).ok()
    }
    pub unsafe fn StopDebugging<P0>(&self, debugclient: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScriptDebugClient>,
    {
        (windows_core::Interface::vtable(self).StopDebugging)(windows_core::Interface::as_raw(self), debugclient.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDataModelScriptDebug_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDebugState: unsafe extern "system" fn(*mut core::ffi::c_void) -> ScriptDebugState,
    pub GetCurrentPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut ScriptDebugPosition, *mut ScriptDebugPosition, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub GetStack: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FindBreakpointById: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateBreakpoints: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetEventFilter: unsafe extern "system" fn(*mut core::ffi::c_void, ScriptDebugEventFilter, *mut bool) -> windows_core::HRESULT,
    pub SetEventFilter: unsafe extern "system" fn(*mut core::ffi::c_void, ScriptDebugEventFilter, u8) -> windows_core::HRESULT,
    pub StartDebugging: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub StopDebugging: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptDebug2, IDataModelScriptDebug2_Vtbl, 0xcbb10ed3_839e_426c_9243_e23535c1ae1a);
impl std::ops::Deref for IDataModelScriptDebug2 {
    type Target = IDataModelScriptDebug;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptDebug2, windows_core::IUnknown, IDataModelScriptDebug);
impl IDataModelScriptDebug2 {
    pub unsafe fn SetBreakpointAtFunction<P0>(&self, functionname: P0) -> windows_core::Result<IDataModelScriptDebugBreakpoint>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).SetBreakpointAtFunction)(windows_core::Interface::as_raw(self), functionname.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelScriptDebug2_Vtbl {
    pub base__: IDataModelScriptDebug_Vtbl,
    pub SetBreakpointAtFunction: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptDebugBreakpoint, IDataModelScriptDebugBreakpoint_Vtbl, 0x6bb27b35_02e6_47cb_90a0_5371244032de);
impl std::ops::Deref for IDataModelScriptDebugBreakpoint {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptDebugBreakpoint, windows_core::IUnknown);
impl IDataModelScriptDebugBreakpoint {
    pub unsafe fn GetId(&self) -> u64 {
        (windows_core::Interface::vtable(self).GetId)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn IsEnabled(&self) -> bool {
        (windows_core::Interface::vtable(self).IsEnabled)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn Enable(&self) {
        (windows_core::Interface::vtable(self).Enable)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn Disable(&self) {
        (windows_core::Interface::vtable(self).Disable)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn Remove(&self) {
        (windows_core::Interface::vtable(self).Remove)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetPosition(&self, position: *mut ScriptDebugPosition, positionspanend: Option<*mut ScriptDebugPosition>, linetext: Option<*mut windows_core::BSTR>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPosition)(windows_core::Interface::as_raw(self), position, core::mem::transmute(positionspanend.unwrap_or(std::ptr::null_mut())), core::mem::transmute(linetext.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IDataModelScriptDebugBreakpoint_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(*mut core::ffi::c_void) -> u64,
    pub IsEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> bool,
    pub Enable: unsafe extern "system" fn(*mut core::ffi::c_void),
    pub Disable: unsafe extern "system" fn(*mut core::ffi::c_void),
    pub Remove: unsafe extern "system" fn(*mut core::ffi::c_void),
    pub GetPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut ScriptDebugPosition, *mut ScriptDebugPosition, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptDebugBreakpointEnumerator, IDataModelScriptDebugBreakpointEnumerator_Vtbl, 0x39484a75_b4f3_4799_86da_691afa57b299);
impl std::ops::Deref for IDataModelScriptDebugBreakpointEnumerator {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptDebugBreakpointEnumerator, windows_core::IUnknown);
impl IDataModelScriptDebugBreakpointEnumerator {
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetNext(&self) -> windows_core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNext)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelScriptDebugBreakpointEnumerator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetNext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptDebugClient, IDataModelScriptDebugClient_Vtbl, 0x53159b6d_d4c4_471b_a863_5b110ca800ca);
impl std::ops::Deref for IDataModelScriptDebugClient {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptDebugClient, windows_core::IUnknown);
impl IDataModelScriptDebugClient {
    pub unsafe fn NotifyDebugEvent<P0, P1>(&self, peventinfo: *const ScriptDebugEventInformation, pscript: P0, peventdataobject: P1, resumeeventkind: *mut ScriptExecutionKind) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScript>,
        P1: windows_core::Param<IModelObject>,
    {
        (windows_core::Interface::vtable(self).NotifyDebugEvent)(windows_core::Interface::as_raw(self), peventinfo, pscript.param().abi(), peventdataobject.param().abi(), resumeeventkind).ok()
    }
}
#[repr(C)]
pub struct IDataModelScriptDebugClient_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub NotifyDebugEvent: unsafe extern "system" fn(*mut core::ffi::c_void, *const ScriptDebugEventInformation, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut ScriptExecutionKind) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptDebugStack, IDataModelScriptDebugStack_Vtbl, 0x051364dd_e449_443e_9762_fe578f4a5473);
impl std::ops::Deref for IDataModelScriptDebugStack {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptDebugStack, windows_core::IUnknown);
impl IDataModelScriptDebugStack {
    pub unsafe fn GetFrameCount(&self) -> u64 {
        (windows_core::Interface::vtable(self).GetFrameCount)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetStackFrame(&self, framenumber: u64) -> windows_core::Result<IDataModelScriptDebugStackFrame> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetStackFrame)(windows_core::Interface::as_raw(self), framenumber, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelScriptDebugStack_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetFrameCount: unsafe extern "system" fn(*mut core::ffi::c_void) -> u64,
    pub GetStackFrame: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptDebugStackFrame, IDataModelScriptDebugStackFrame_Vtbl, 0xdec6ed5e_6360_4941_ab4c_a26409de4f82);
impl std::ops::Deref for IDataModelScriptDebugStackFrame {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptDebugStackFrame, windows_core::IUnknown);
impl IDataModelScriptDebugStackFrame {
    pub unsafe fn GetName(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetPosition(&self, position: *mut ScriptDebugPosition, positionspanend: Option<*mut ScriptDebugPosition>, linetext: Option<*mut windows_core::BSTR>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPosition)(windows_core::Interface::as_raw(self), position, core::mem::transmute(positionspanend.unwrap_or(std::ptr::null_mut())), core::mem::transmute(linetext.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn IsTransitionPoint(&self) -> windows_core::Result<bool> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).IsTransitionPoint)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetTransition(&self, transitionscript: *mut Option<IDataModelScript>, istransitioncontiguous: *mut bool) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTransition)(windows_core::Interface::as_raw(self), core::mem::transmute(transitionscript), istransitioncontiguous).ok()
    }
    pub unsafe fn Evaluate<P0>(&self, pwszexpression: P0) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).Evaluate)(windows_core::Interface::as_raw(self), pwszexpression.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn EnumerateLocals(&self) -> windows_core::Result<IDataModelScriptDebugVariableSetEnumerator> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).EnumerateLocals)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn EnumerateArguments(&self) -> windows_core::Result<IDataModelScriptDebugVariableSetEnumerator> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).EnumerateArguments)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelScriptDebugStackFrame_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub GetPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut ScriptDebugPosition, *mut ScriptDebugPosition, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub IsTransitionPoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub GetTransition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub Evaluate: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateLocals: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateArguments: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptDebugVariableSetEnumerator, IDataModelScriptDebugVariableSetEnumerator_Vtbl, 0x0f9feed7_d045_4ac3_98a8_a98942cf6a35);
impl std::ops::Deref for IDataModelScriptDebugVariableSetEnumerator {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptDebugVariableSetEnumerator, windows_core::IUnknown);
impl IDataModelScriptDebugVariableSetEnumerator {
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetNext(&self, variablename: *mut windows_core::BSTR, variablevalue: Option<*mut Option<IModelObject>>, variablemetadata: Option<*mut Option<IKeyStore>>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetNext)(windows_core::Interface::as_raw(self), core::mem::transmute(variablename), core::mem::transmute(variablevalue.unwrap_or(std::ptr::null_mut())), core::mem::transmute(variablemetadata.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IDataModelScriptDebugVariableSetEnumerator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetNext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptHostContext, IDataModelScriptHostContext_Vtbl, 0x014d366a_1f23_4981_9219_b2db8b402054);
impl std::ops::Deref for IDataModelScriptHostContext {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptHostContext, windows_core::IUnknown);
impl IDataModelScriptHostContext {
    pub unsafe fn NotifyScriptChange<P0>(&self, script: P0, changekind: ScriptChangeKind) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScript>,
    {
        (windows_core::Interface::vtable(self).NotifyScriptChange)(windows_core::Interface::as_raw(self), script.param().abi(), changekind).ok()
    }
    pub unsafe fn GetNamespaceObject(&self) -> windows_core::Result<IModelObject> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNamespaceObject)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelScriptHostContext_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub NotifyScriptChange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, ScriptChangeKind) -> windows_core::HRESULT,
    pub GetNamespaceObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptManager, IDataModelScriptManager_Vtbl, 0x6fd11e33_e5ad_410b_8011_68c6bc4bf80d);
impl std::ops::Deref for IDataModelScriptManager {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptManager, windows_core::IUnknown);
impl IDataModelScriptManager {
    pub unsafe fn GetDefaultNameBinder(&self) -> windows_core::Result<IDataModelNameBinder> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDefaultNameBinder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RegisterScriptProvider<P0>(&self, provider: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScriptProvider>,
    {
        (windows_core::Interface::vtable(self).RegisterScriptProvider)(windows_core::Interface::as_raw(self), provider.param().abi()).ok()
    }
    pub unsafe fn UnregisterScriptProvider<P0>(&self, provider: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScriptProvider>,
    {
        (windows_core::Interface::vtable(self).UnregisterScriptProvider)(windows_core::Interface::as_raw(self), provider.param().abi()).ok()
    }
    pub unsafe fn FindProviderForScriptType<P0>(&self, scripttype: P0) -> windows_core::Result<IDataModelScriptProvider>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).FindProviderForScriptType)(windows_core::Interface::as_raw(self), scripttype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn FindProviderForScriptExtension<P0>(&self, scriptextension: P0) -> windows_core::Result<IDataModelScriptProvider>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).FindProviderForScriptExtension)(windows_core::Interface::as_raw(self), scriptextension.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn EnumerateScriptProviders(&self) -> windows_core::Result<IDataModelScriptProviderEnumerator> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).EnumerateScriptProviders)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelScriptManager_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDefaultNameBinder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterScriptProvider: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UnregisterScriptProvider: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FindProviderForScriptType: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FindProviderForScriptExtension: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateScriptProviders: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptProvider, IDataModelScriptProvider_Vtbl, 0x513461e0_4fca_48ce_8658_32f3e2056f3b);
impl std::ops::Deref for IDataModelScriptProvider {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptProvider, windows_core::IUnknown);
impl IDataModelScriptProvider {
    pub unsafe fn GetName(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetExtension(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExtension)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateScript(&self) -> windows_core::Result<IDataModelScript> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateScript)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetDefaultTemplateContent(&self) -> windows_core::Result<IDataModelScriptTemplate> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDefaultTemplateContent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn EnumerateTemplates(&self) -> windows_core::Result<IDataModelScriptTemplateEnumerator> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).EnumerateTemplates)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelScriptProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub GetExtension: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub CreateScript: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetDefaultTemplateContent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateTemplates: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptProviderEnumerator, IDataModelScriptProviderEnumerator_Vtbl, 0x95ba00e2_704a_4fe2_a8f1_a7e7d8fb0941);
impl std::ops::Deref for IDataModelScriptProviderEnumerator {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptProviderEnumerator, windows_core::IUnknown);
impl IDataModelScriptProviderEnumerator {
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetNext(&self) -> windows_core::Result<IDataModelScriptProvider> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNext)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelScriptProviderEnumerator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetNext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataModelScriptTemplate, IDataModelScriptTemplate_Vtbl, 0x1303dec4_fa3b_4f1b_9224_b953d16babb5);
impl std::ops::Deref for IDataModelScriptTemplate {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptTemplate, windows_core::IUnknown);
impl IDataModelScriptTemplate {
    pub unsafe fn GetName(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetDescription(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDescription)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetContent(&self) -> windows_core::Result<super::super::super::Com::IStream> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetContent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelScriptTemplate_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub GetDescription: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetContent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetContent: usize,
}
windows_core::imp::define_interface!(IDataModelScriptTemplateEnumerator, IDataModelScriptTemplateEnumerator_Vtbl, 0x69ce6ae2_2268_4e6f_b062_20ce62bfe677);
impl std::ops::Deref for IDataModelScriptTemplateEnumerator {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptTemplateEnumerator, windows_core::IUnknown);
impl IDataModelScriptTemplateEnumerator {
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetNext(&self) -> windows_core::Result<IDataModelScriptTemplate> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNext)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDataModelScriptTemplateEnumerator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetNext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugAdvanced, IDebugAdvanced_Vtbl, 0xf2df5f53_071f_47bd_9de6_5734c3fed689);
impl std::ops::Deref for IDebugAdvanced {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugAdvanced, windows_core::IUnknown);
impl IDebugAdvanced {
    pub unsafe fn GetThreadContext(&self, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetThreadContext)(windows_core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn SetThreadContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetThreadContext)(windows_core::Interface::as_raw(self), context, contextsize).ok()
    }
}
#[repr(C)]
pub struct IDebugAdvanced_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugAdvanced2, IDebugAdvanced2_Vtbl, 0x716d14c9_119b_4ba5_af1f_0890e672416a);
impl std::ops::Deref for IDebugAdvanced2 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugAdvanced2, windows_core::IUnknown);
impl IDebugAdvanced2 {
    pub unsafe fn GetThreadContext(&self, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetThreadContext)(windows_core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn SetThreadContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetThreadContext)(windows_core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn Request(&self, request: u32, inbuffer: Option<*const core::ffi::c_void>, inbuffersize: u32, outbuffer: Option<*mut core::ffi::c_void>, outbuffersize: u32, outsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Request)(windows_core::Interface::as_raw(self), request, core::mem::transmute(inbuffer.unwrap_or(std::ptr::null())), inbuffersize, core::mem::transmute(outbuffer.unwrap_or(std::ptr::null_mut())), outbuffersize, core::mem::transmute(outsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSourceFileInformation<P0>(&self, which: u32, sourcefile: P0, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetSourceFileInformation)(windows_core::Interface::as_raw(self), which, sourcefile.param().abi(), arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FindSourceFileAndToken<P0>(&self, startelement: u32, modaddr: u64, file: P0, flags: u32, filetoken: Option<*const core::ffi::c_void>, filetokensize: u32, foundelement: Option<*mut u32>, buffer: Option<&mut [u8]>, foundsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).FindSourceFileAndToken)(windows_core::Interface::as_raw(self), startelement, modaddr, file.param().abi(), flags, core::mem::transmute(filetoken.unwrap_or(std::ptr::null())), filetokensize, core::mem::transmute(foundelement.unwrap_or(std::ptr::null_mut())), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(foundsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>, stringbuffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSymbolInformation)(windows_core::Interface::as_raw(self), which, arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(stringbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemObjectInformation)(windows_core::Interface::as_raw(self), which, arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IDebugAdvanced2_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Request: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSourceFileInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FindSourceFileAndToken: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, windows_core::PCSTR, u32, *const core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSymbolInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemObjectInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugAdvanced3, IDebugAdvanced3_Vtbl, 0xcba4abb4_84c4_444d_87ca_a04e13286739);
impl std::ops::Deref for IDebugAdvanced3 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugAdvanced3, windows_core::IUnknown);
impl IDebugAdvanced3 {
    pub unsafe fn GetThreadContext(&self, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetThreadContext)(windows_core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn SetThreadContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetThreadContext)(windows_core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn Request(&self, request: u32, inbuffer: Option<*const core::ffi::c_void>, inbuffersize: u32, outbuffer: Option<*mut core::ffi::c_void>, outbuffersize: u32, outsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Request)(windows_core::Interface::as_raw(self), request, core::mem::transmute(inbuffer.unwrap_or(std::ptr::null())), inbuffersize, core::mem::transmute(outbuffer.unwrap_or(std::ptr::null_mut())), outbuffersize, core::mem::transmute(outsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSourceFileInformation<P0>(&self, which: u32, sourcefile: P0, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetSourceFileInformation)(windows_core::Interface::as_raw(self), which, sourcefile.param().abi(), arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FindSourceFileAndToken<P0>(&self, startelement: u32, modaddr: u64, file: P0, flags: u32, filetoken: Option<*const core::ffi::c_void>, filetokensize: u32, foundelement: Option<*mut u32>, buffer: Option<&mut [u8]>, foundsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).FindSourceFileAndToken)(windows_core::Interface::as_raw(self), startelement, modaddr, file.param().abi(), flags, core::mem::transmute(filetoken.unwrap_or(std::ptr::null())), filetokensize, core::mem::transmute(foundelement.unwrap_or(std::ptr::null_mut())), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(foundsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>, stringbuffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSymbolInformation)(windows_core::Interface::as_raw(self), which, arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(stringbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemObjectInformation)(windows_core::Interface::as_raw(self), which, arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSourceFileInformationWide<P0>(&self, which: u32, sourcefile: P0, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetSourceFileInformationWide)(windows_core::Interface::as_raw(self), which, sourcefile.param().abi(), arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FindSourceFileAndTokenWide<P0>(&self, startelement: u32, modaddr: u64, file: P0, flags: u32, filetoken: Option<*const core::ffi::c_void>, filetokensize: u32, foundelement: Option<*mut u32>, buffer: Option<&mut [u16]>, foundsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).FindSourceFileAndTokenWide)(windows_core::Interface::as_raw(self), startelement, modaddr, file.param().abi(), flags, core::mem::transmute(filetoken.unwrap_or(std::ptr::null())), filetokensize, core::mem::transmute(foundelement.unwrap_or(std::ptr::null_mut())), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(foundsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSymbolInformationWide(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>, stringbuffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSymbolInformationWide)(windows_core::Interface::as_raw(self), which, arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(stringbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IDebugAdvanced3_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Request: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSourceFileInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FindSourceFileAndToken: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, windows_core::PCSTR, u32, *const core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSymbolInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemObjectInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSourceFileInformationWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FindSourceFileAndTokenWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, windows_core::PCWSTR, u32, *const core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSymbolInformationWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugAdvanced4, IDebugAdvanced4_Vtbl, 0xd1069067_2a65_4bf0_ae97_76184b67856b);
impl std::ops::Deref for IDebugAdvanced4 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugAdvanced4, windows_core::IUnknown);
impl IDebugAdvanced4 {
    pub unsafe fn GetThreadContext(&self, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetThreadContext)(windows_core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn SetThreadContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetThreadContext)(windows_core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn Request(&self, request: u32, inbuffer: Option<*const core::ffi::c_void>, inbuffersize: u32, outbuffer: Option<*mut core::ffi::c_void>, outbuffersize: u32, outsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Request)(windows_core::Interface::as_raw(self), request, core::mem::transmute(inbuffer.unwrap_or(std::ptr::null())), inbuffersize, core::mem::transmute(outbuffer.unwrap_or(std::ptr::null_mut())), outbuffersize, core::mem::transmute(outsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSourceFileInformation<P0>(&self, which: u32, sourcefile: P0, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetSourceFileInformation)(windows_core::Interface::as_raw(self), which, sourcefile.param().abi(), arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FindSourceFileAndToken<P0>(&self, startelement: u32, modaddr: u64, file: P0, flags: u32, filetoken: Option<*const core::ffi::c_void>, filetokensize: u32, foundelement: Option<*mut u32>, buffer: Option<&mut [u8]>, foundsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).FindSourceFileAndToken)(windows_core::Interface::as_raw(self), startelement, modaddr, file.param().abi(), flags, core::mem::transmute(filetoken.unwrap_or(std::ptr::null())), filetokensize, core::mem::transmute(foundelement.unwrap_or(std::ptr::null_mut())), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(foundsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>, stringbuffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSymbolInformation)(windows_core::Interface::as_raw(self), which, arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(stringbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemObjectInformation)(windows_core::Interface::as_raw(self), which, arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSourceFileInformationWide<P0>(&self, which: u32, sourcefile: P0, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetSourceFileInformationWide)(windows_core::Interface::as_raw(self), which, sourcefile.param().abi(), arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FindSourceFileAndTokenWide<P0>(&self, startelement: u32, modaddr: u64, file: P0, flags: u32, filetoken: Option<*const core::ffi::c_void>, filetokensize: u32, foundelement: Option<*mut u32>, buffer: Option<&mut [u16]>, foundsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).FindSourceFileAndTokenWide)(windows_core::Interface::as_raw(self), startelement, modaddr, file.param().abi(), flags, core::mem::transmute(filetoken.unwrap_or(std::ptr::null())), filetokensize, core::mem::transmute(foundelement.unwrap_or(std::ptr::null_mut())), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(foundsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSymbolInformationWide(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>, stringbuffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSymbolInformationWide)(windows_core::Interface::as_raw(self), which, arg64, arg32, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(stringbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSymbolInformationWideEx(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>, stringbuffer: Option<&mut [u16]>, stringsize: Option<*mut u32>, pinfoex: Option<*mut SYMBOL_INFO_EX>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSymbolInformationWideEx)(
            windows_core::Interface::as_raw(self),
            which,
            arg64,
            arg32,
            core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())),
            buffersize,
            core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(stringbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            stringbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(pinfoex.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
}
#[repr(C)]
pub struct IDebugAdvanced4_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Request: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSourceFileInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FindSourceFileAndToken: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, windows_core::PCSTR, u32, *const core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSymbolInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemObjectInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSourceFileInformationWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FindSourceFileAndTokenWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, windows_core::PCWSTR, u32, *const core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSymbolInformationWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSymbolInformationWideEx: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32, *mut SYMBOL_INFO_EX) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugBreakpoint, IDebugBreakpoint_Vtbl, 0x5bd9d474_5975_423a_b88b_65a8e7110e65);
impl std::ops::Deref for IDebugBreakpoint {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugBreakpoint, windows_core::IUnknown);
impl IDebugBreakpoint {
    pub unsafe fn GetId(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetType)(windows_core::Interface::as_raw(self), breaktype, proctype).ok()
    }
    pub unsafe fn GetAdder(&self) -> windows_core::Result<IDebugClient> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAdder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddFlags(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddFlags)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn RemoveFlags(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveFlags)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetFlags(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOffset(&self, offset: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOffset)(windows_core::Interface::as_raw(self), offset).ok()
    }
    pub unsafe fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDataParameters)(windows_core::Interface::as_raw(self), size, accesstype).ok()
    }
    pub unsafe fn SetDataParameters(&self, size: u32, accesstype: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetDataParameters)(windows_core::Interface::as_raw(self), size, accesstype).ok()
    }
    pub unsafe fn GetPassCount(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPassCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetPassCount(&self, count: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetPassCount)(windows_core::Interface::as_raw(self), count).ok()
    }
    pub unsafe fn GetCurrentPassCount(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentPassCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetMatchThreadId(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMatchThreadId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMatchThreadId(&self, thread: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetMatchThreadId)(windows_core::Interface::as_raw(self), thread).ok()
    }
    pub unsafe fn GetCommand(&self, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCommand)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetCommand<P0>(&self, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetCommand)(windows_core::Interface::as_raw(self), command.param().abi()).ok()
    }
    pub unsafe fn GetOffsetExpression(&self, buffer: Option<&mut [u8]>, expressionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOffsetExpression)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(expressionsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOffsetExpression<P0>(&self, expression: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetOffsetExpression)(windows_core::Interface::as_raw(self), expression.param().abi()).ok()
    }
    pub unsafe fn GetParameters(&self, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetParameters)(windows_core::Interface::as_raw(self), params).ok()
    }
}
#[repr(C)]
pub struct IDebugBreakpoint_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetAdder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetDataParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetDataParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCurrentPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetMatchThreadId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetMatchThreadId: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetOffsetExpression: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOffsetExpression: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugBreakpoint2, IDebugBreakpoint2_Vtbl, 0x1b278d20_79f2_426e_a3f9_c1ddf375d48e);
impl std::ops::Deref for IDebugBreakpoint2 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugBreakpoint2, windows_core::IUnknown);
impl IDebugBreakpoint2 {
    pub unsafe fn GetId(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetType)(windows_core::Interface::as_raw(self), breaktype, proctype).ok()
    }
    pub unsafe fn GetAdder(&self) -> windows_core::Result<IDebugClient> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAdder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddFlags(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddFlags)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn RemoveFlags(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveFlags)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetFlags(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOffset(&self, offset: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOffset)(windows_core::Interface::as_raw(self), offset).ok()
    }
    pub unsafe fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDataParameters)(windows_core::Interface::as_raw(self), size, accesstype).ok()
    }
    pub unsafe fn SetDataParameters(&self, size: u32, accesstype: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetDataParameters)(windows_core::Interface::as_raw(self), size, accesstype).ok()
    }
    pub unsafe fn GetPassCount(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPassCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetPassCount(&self, count: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetPassCount)(windows_core::Interface::as_raw(self), count).ok()
    }
    pub unsafe fn GetCurrentPassCount(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentPassCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetMatchThreadId(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMatchThreadId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMatchThreadId(&self, thread: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetMatchThreadId)(windows_core::Interface::as_raw(self), thread).ok()
    }
    pub unsafe fn GetCommand(&self, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCommand)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetCommand<P0>(&self, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetCommand)(windows_core::Interface::as_raw(self), command.param().abi()).ok()
    }
    pub unsafe fn GetOffsetExpression(&self, buffer: Option<&mut [u8]>, expressionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOffsetExpression)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(expressionsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOffsetExpression<P0>(&self, expression: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetOffsetExpression)(windows_core::Interface::as_raw(self), expression.param().abi()).ok()
    }
    pub unsafe fn GetParameters(&self, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetParameters)(windows_core::Interface::as_raw(self), params).ok()
    }
    pub unsafe fn GetCommandWide(&self, buffer: Option<&mut [u16]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCommandWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetCommandWide<P0>(&self, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetCommandWide)(windows_core::Interface::as_raw(self), command.param().abi()).ok()
    }
    pub unsafe fn GetOffsetExpressionWide(&self, buffer: Option<&mut [u16]>, expressionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOffsetExpressionWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(expressionsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOffsetExpressionWide<P0>(&self, expression: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetOffsetExpressionWide)(windows_core::Interface::as_raw(self), expression.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDebugBreakpoint2_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetAdder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetDataParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetDataParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCurrentPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetMatchThreadId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetMatchThreadId: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetOffsetExpression: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOffsetExpression: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
    pub GetCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetOffsetExpressionWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOffsetExpressionWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugBreakpoint3, IDebugBreakpoint3_Vtbl, 0x38f5c249_b448_43bb_9835_579d4ec02249);
impl std::ops::Deref for IDebugBreakpoint3 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugBreakpoint3, windows_core::IUnknown);
impl IDebugBreakpoint3 {
    pub unsafe fn GetId(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetType)(windows_core::Interface::as_raw(self), breaktype, proctype).ok()
    }
    pub unsafe fn GetAdder(&self) -> windows_core::Result<IDebugClient> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAdder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddFlags(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddFlags)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn RemoveFlags(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveFlags)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetFlags(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOffset(&self, offset: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOffset)(windows_core::Interface::as_raw(self), offset).ok()
    }
    pub unsafe fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDataParameters)(windows_core::Interface::as_raw(self), size, accesstype).ok()
    }
    pub unsafe fn SetDataParameters(&self, size: u32, accesstype: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetDataParameters)(windows_core::Interface::as_raw(self), size, accesstype).ok()
    }
    pub unsafe fn GetPassCount(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPassCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetPassCount(&self, count: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetPassCount)(windows_core::Interface::as_raw(self), count).ok()
    }
    pub unsafe fn GetCurrentPassCount(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentPassCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetMatchThreadId(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMatchThreadId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMatchThreadId(&self, thread: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetMatchThreadId)(windows_core::Interface::as_raw(self), thread).ok()
    }
    pub unsafe fn GetCommand(&self, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCommand)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetCommand<P0>(&self, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetCommand)(windows_core::Interface::as_raw(self), command.param().abi()).ok()
    }
    pub unsafe fn GetOffsetExpression(&self, buffer: Option<&mut [u8]>, expressionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOffsetExpression)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(expressionsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOffsetExpression<P0>(&self, expression: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetOffsetExpression)(windows_core::Interface::as_raw(self), expression.param().abi()).ok()
    }
    pub unsafe fn GetParameters(&self, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetParameters)(windows_core::Interface::as_raw(self), params).ok()
    }
    pub unsafe fn GetCommandWide(&self, buffer: Option<&mut [u16]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCommandWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetCommandWide<P0>(&self, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetCommandWide)(windows_core::Interface::as_raw(self), command.param().abi()).ok()
    }
    pub unsafe fn GetOffsetExpressionWide(&self, buffer: Option<&mut [u16]>, expressionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOffsetExpressionWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(expressionsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOffsetExpressionWide<P0>(&self, expression: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetOffsetExpressionWide)(windows_core::Interface::as_raw(self), expression.param().abi()).ok()
    }
    pub unsafe fn GetGuid(&self) -> windows_core::Result<windows_core::GUID> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetGuid)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IDebugBreakpoint3_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetAdder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetDataParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetDataParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCurrentPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetMatchThreadId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetMatchThreadId: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetOffsetExpression: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOffsetExpression: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
    pub GetCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetOffsetExpressionWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOffsetExpressionWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetGuid: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugClient, IDebugClient_Vtbl, 0x27fe5639_8407_4f47_8364_ee118fb08ac8);
impl std::ops::Deref for IDebugClient {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugClient, windows_core::IUnknown);
impl IDebugClient {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(optionssize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), core::mem::transmute(reserved.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(actualcount.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(prefixsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(identitysize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IDebugClient_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugClient2, IDebugClient2_Vtbl, 0xedbed635_372e_4dab_bbfe_ed0d2f63be81);
impl std::ops::Deref for IDebugClient2 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugClient2, windows_core::IUnknown);
impl IDebugClient2 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(optionssize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), core::mem::transmute(reserved.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(actualcount.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(prefixsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(identitysize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IDebugClient2_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugClient3, IDebugClient3_Vtbl, 0xdd492d7f_71b8_4ad6_a8dc_1c887479ff91);
impl std::ops::Deref for IDebugClient3 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugClient3, windows_core::IUnknown);
impl IDebugClient3 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(optionssize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), core::mem::transmute(reserved.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(actualcount.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(prefixsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(identitysize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u16]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u16]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn CreateProcessWide<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttachWide<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttachWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
}
#[repr(C)]
pub struct IDebugClient3_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, u32, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugClient4, IDebugClient4_Vtbl, 0xca83c3de_5089_4cf8_93c8_d892387f2a5e);
impl std::ops::Deref for IDebugClient4 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugClient4, windows_core::IUnknown);
impl IDebugClient4 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(optionssize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), core::mem::transmute(reserved.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(actualcount.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(prefixsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(identitysize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u16]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u16]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn CreateProcessWide<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttachWide<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttachWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle).ok()
    }
    pub unsafe fn WriteDumpFileWide<P0, P1>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, qualifier, formatflags, comment.param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AddDumpInformationFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, r#type).ok()
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberDumpFiles)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: Option<&mut [u8]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDumpFile)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(namesize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(handle.unwrap_or(std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: Option<&mut [u16]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDumpFileWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(namesize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(handle.unwrap_or(std::ptr::null_mut())), r#type).ok()
    }
}
#[repr(C)]
pub struct IDebugClient4_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64) -> windows_core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32) -> windows_core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugClient5, IDebugClient5_Vtbl, 0xe3acb9d7_7ec2_4f0c_a0da_e81e0cbbe628);
impl std::ops::Deref for IDebugClient5 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugClient5, windows_core::IUnknown);
impl IDebugClient5 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(optionssize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), core::mem::transmute(reserved.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(actualcount.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(prefixsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(identitysize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u16]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u16]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn CreateProcessWide<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttachWide<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttachWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle).ok()
    }
    pub unsafe fn WriteDumpFileWide<P0, P1>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, qualifier, formatflags, comment.param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AddDumpInformationFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, r#type).ok()
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberDumpFiles)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: Option<&mut [u8]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDumpFile)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(namesize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(handle.unwrap_or(std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: Option<&mut [u16]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDumpFileWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(namesize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(handle.unwrap_or(std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn AttachKernelWide<P0>(&self, flags: u32, connectoptions: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AttachKernelWide)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptionsWide(&self, buffer: Option<&mut [u16]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(optionssize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptionsWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn StartProcessServerWide<P0>(&self, flags: u32, options: P0, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StartProcessServerWide)(windows_core::Interface::as_raw(self), flags, options.param().abi(), core::mem::transmute(reserved.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServerWide<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ConnectProcessServerWide)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn StartServerWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StartServerWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn OutputServersWide<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputServersWide)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok()
    }
    pub unsafe fn GetOutputCallbacksWide(&self) -> windows_core::Result<IDebugOutputCallbacksWide> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetOutputCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacksWide>,
    {
        (windows_core::Interface::vtable(self).SetOutputCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputLinePrefixWide(&self, buffer: Option<&mut [u16]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(prefixsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefixWide<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok()
    }
    pub unsafe fn GetIdentityWide(&self, buffer: Option<&mut [u16]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIdentityWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(identitysize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentityWide<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputIdentityWide)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacksWide(&self) -> windows_core::Result<IDebugEventCallbacksWide> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetEventCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacksWide>,
    {
        (windows_core::Interface::vtable(self).SetEventCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn CreateProcess2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcess2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok()
    }
    pub unsafe fn CreateProcess2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcess2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok()
    }
    pub unsafe fn CreateProcessAndAttach2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn PushOutputLinePrefix<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).PushOutputLinePrefix)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn PushOutputLinePrefixWide<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).PushOutputLinePrefixWide)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn PopOutputLinePrefix(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).PopOutputLinePrefix)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetNumberInputCallbacks(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberOutputCallbacks(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberEventCallbacks(&self, eventflags: u32) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberEventCallbacks)(windows_core::Interface::as_raw(self), eventflags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetQuitLockString(&self, buffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetQuitLockString)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockString<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetQuitLockString)(windows_core::Interface::as_raw(self), string.param().abi()).ok()
    }
    pub unsafe fn GetQuitLockStringWide(&self, buffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetQuitLockStringWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockStringWide<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetQuitLockStringWide)(windows_core::Interface::as_raw(self), string.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDebugClient5_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64) -> windows_core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32) -> windows_core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub AttachKernelWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub StartProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub StartServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputServersWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateProcess2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub CreateProcess2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR, u32, u32) -> windows_core::HRESULT,
    pub PushOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub PushOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub PopOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetNumberInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugClient6, IDebugClient6_Vtbl, 0xfd28b4c5_c498_4686_a28e_62cad2154eb3);
impl std::ops::Deref for IDebugClient6 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugClient6, windows_core::IUnknown);
impl IDebugClient6 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(optionssize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), core::mem::transmute(reserved.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(actualcount.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(prefixsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(identitysize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u16]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u16]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn CreateProcessWide<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttachWide<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttachWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle).ok()
    }
    pub unsafe fn WriteDumpFileWide<P0, P1>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, qualifier, formatflags, comment.param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AddDumpInformationFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, r#type).ok()
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberDumpFiles)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: Option<&mut [u8]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDumpFile)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(namesize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(handle.unwrap_or(std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: Option<&mut [u16]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDumpFileWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(namesize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(handle.unwrap_or(std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn AttachKernelWide<P0>(&self, flags: u32, connectoptions: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AttachKernelWide)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptionsWide(&self, buffer: Option<&mut [u16]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(optionssize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptionsWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn StartProcessServerWide<P0>(&self, flags: u32, options: P0, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StartProcessServerWide)(windows_core::Interface::as_raw(self), flags, options.param().abi(), core::mem::transmute(reserved.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServerWide<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ConnectProcessServerWide)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn StartServerWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StartServerWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn OutputServersWide<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputServersWide)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok()
    }
    pub unsafe fn GetOutputCallbacksWide(&self) -> windows_core::Result<IDebugOutputCallbacksWide> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetOutputCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacksWide>,
    {
        (windows_core::Interface::vtable(self).SetOutputCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputLinePrefixWide(&self, buffer: Option<&mut [u16]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(prefixsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefixWide<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok()
    }
    pub unsafe fn GetIdentityWide(&self, buffer: Option<&mut [u16]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIdentityWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(identitysize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentityWide<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputIdentityWide)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacksWide(&self) -> windows_core::Result<IDebugEventCallbacksWide> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetEventCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacksWide>,
    {
        (windows_core::Interface::vtable(self).SetEventCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn CreateProcess2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcess2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok()
    }
    pub unsafe fn CreateProcess2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcess2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok()
    }
    pub unsafe fn CreateProcessAndAttach2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn PushOutputLinePrefix<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).PushOutputLinePrefix)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn PushOutputLinePrefixWide<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).PushOutputLinePrefixWide)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn PopOutputLinePrefix(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).PopOutputLinePrefix)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetNumberInputCallbacks(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberOutputCallbacks(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberEventCallbacks(&self, eventflags: u32) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberEventCallbacks)(windows_core::Interface::as_raw(self), eventflags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetQuitLockString(&self, buffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetQuitLockString)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockString<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetQuitLockString)(windows_core::Interface::as_raw(self), string.param().abi()).ok()
    }
    pub unsafe fn GetQuitLockStringWide(&self, buffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetQuitLockStringWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockStringWide<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetQuitLockStringWide)(windows_core::Interface::as_raw(self), string.param().abi()).ok()
    }
    pub unsafe fn SetEventContextCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventContextCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetEventContextCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDebugClient6_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64) -> windows_core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32) -> windows_core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub AttachKernelWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub StartProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub StartServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputServersWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateProcess2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub CreateProcess2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR, u32, u32) -> windows_core::HRESULT,
    pub PushOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub PushOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub PopOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetNumberInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetEventContextCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugClient7, IDebugClient7_Vtbl, 0x13586be3_542e_481e_b1f2_8497ba74f9a9);
impl std::ops::Deref for IDebugClient7 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugClient7, windows_core::IUnknown);
impl IDebugClient7 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(optionssize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), core::mem::transmute(reserved.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(actualcount.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(prefixsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(identitysize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u16]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u16]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn CreateProcessWide<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttachWide<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttachWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle).ok()
    }
    pub unsafe fn WriteDumpFileWide<P0, P1>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, qualifier, formatflags, comment.param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AddDumpInformationFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, r#type).ok()
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberDumpFiles)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: Option<&mut [u8]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDumpFile)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(namesize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(handle.unwrap_or(std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: Option<&mut [u16]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDumpFileWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(namesize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(handle.unwrap_or(std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn AttachKernelWide<P0>(&self, flags: u32, connectoptions: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AttachKernelWide)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptionsWide(&self, buffer: Option<&mut [u16]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(optionssize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptionsWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn StartProcessServerWide<P0>(&self, flags: u32, options: P0, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StartProcessServerWide)(windows_core::Interface::as_raw(self), flags, options.param().abi(), core::mem::transmute(reserved.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServerWide<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ConnectProcessServerWide)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn StartServerWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StartServerWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn OutputServersWide<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputServersWide)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok()
    }
    pub unsafe fn GetOutputCallbacksWide(&self) -> windows_core::Result<IDebugOutputCallbacksWide> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetOutputCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacksWide>,
    {
        (windows_core::Interface::vtable(self).SetOutputCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputLinePrefixWide(&self, buffer: Option<&mut [u16]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(prefixsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefixWide<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok()
    }
    pub unsafe fn GetIdentityWide(&self, buffer: Option<&mut [u16]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIdentityWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(identitysize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentityWide<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputIdentityWide)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacksWide(&self) -> windows_core::Result<IDebugEventCallbacksWide> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetEventCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacksWide>,
    {
        (windows_core::Interface::vtable(self).SetEventCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn CreateProcess2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcess2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok()
    }
    pub unsafe fn CreateProcess2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcess2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok()
    }
    pub unsafe fn CreateProcessAndAttach2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn PushOutputLinePrefix<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).PushOutputLinePrefix)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn PushOutputLinePrefixWide<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).PushOutputLinePrefixWide)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn PopOutputLinePrefix(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).PopOutputLinePrefix)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetNumberInputCallbacks(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberOutputCallbacks(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberEventCallbacks(&self, eventflags: u32) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberEventCallbacks)(windows_core::Interface::as_raw(self), eventflags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetQuitLockString(&self, buffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetQuitLockString)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockString<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetQuitLockString)(windows_core::Interface::as_raw(self), string.param().abi()).ok()
    }
    pub unsafe fn GetQuitLockStringWide(&self, buffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetQuitLockStringWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockStringWide<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetQuitLockStringWide)(windows_core::Interface::as_raw(self), string.param().abi()).ok()
    }
    pub unsafe fn SetEventContextCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventContextCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetEventContextCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn SetClientContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetClientContext)(windows_core::Interface::as_raw(self), context, contextsize).ok()
    }
}
#[repr(C)]
pub struct IDebugClient7_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64) -> windows_core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32) -> windows_core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub AttachKernelWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub StartProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub StartServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputServersWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateProcess2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub CreateProcess2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR, u32, u32) -> windows_core::HRESULT,
    pub PushOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub PushOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub PopOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetNumberInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetEventContextCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetClientContext: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugClient8, IDebugClient8_Vtbl, 0xcec43add_6375_469e_83d5_414e4033c19a);
impl std::ops::Deref for IDebugClient8 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugClient8, windows_core::IUnknown);
impl IDebugClient8 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(optionssize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), core::mem::transmute(reserved.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(actualcount.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(prefixsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(identitysize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P0>(&self, server: u64, exename: P0, flags: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u16]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u16]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
            windows_core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualexenamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(actualdescriptionsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn CreateProcessWide<P0>(&self, server: u64, commandline: P0, createflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttachWide<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttachWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle).ok()
    }
    pub unsafe fn WriteDumpFileWide<P0, P1>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).WriteDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, qualifier, formatflags, comment.param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AddDumpInformationFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, r#type).ok()
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberDumpFiles)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: Option<&mut [u8]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDumpFile)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(namesize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(handle.unwrap_or(std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: Option<&mut [u16]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDumpFileWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(namesize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(handle.unwrap_or(std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn AttachKernelWide<P0>(&self, flags: u32, connectoptions: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AttachKernelWide)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptionsWide(&self, buffer: Option<&mut [u16]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(optionssize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptionsWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn StartProcessServerWide<P0>(&self, flags: u32, options: P0, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StartProcessServerWide)(windows_core::Interface::as_raw(self), flags, options.param().abi(), core::mem::transmute(reserved.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServerWide<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ConnectProcessServerWide)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn StartServerWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StartServerWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok()
    }
    pub unsafe fn OutputServersWide<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputServersWide)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok()
    }
    pub unsafe fn GetOutputCallbacksWide(&self) -> windows_core::Result<IDebugOutputCallbacksWide> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOutputCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetOutputCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacksWide>,
    {
        (windows_core::Interface::vtable(self).SetOutputCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn GetOutputLinePrefixWide(&self, buffer: Option<&mut [u16]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(prefixsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefixWide<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok()
    }
    pub unsafe fn GetIdentityWide(&self, buffer: Option<&mut [u16]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIdentityWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(identitysize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentityWide<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputIdentityWide)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacksWide(&self) -> windows_core::Result<IDebugEventCallbacksWide> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEventCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetEventCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacksWide>,
    {
        (windows_core::Interface::vtable(self).SetEventCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn CreateProcess2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcess2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok()
    }
    pub unsafe fn CreateProcess2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcess2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok()
    }
    pub unsafe fn CreateProcessAndAttach2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessAndAttach2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn PushOutputLinePrefix<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).PushOutputLinePrefix)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn PushOutputLinePrefixWide<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).PushOutputLinePrefixWide)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn PopOutputLinePrefix(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).PopOutputLinePrefix)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetNumberInputCallbacks(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberOutputCallbacks(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberEventCallbacks(&self, eventflags: u32) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberEventCallbacks)(windows_core::Interface::as_raw(self), eventflags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetQuitLockString(&self, buffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetQuitLockString)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockString<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetQuitLockString)(windows_core::Interface::as_raw(self), string.param().abi()).ok()
    }
    pub unsafe fn GetQuitLockStringWide(&self, buffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetQuitLockStringWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockStringWide<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetQuitLockStringWide)(windows_core::Interface::as_raw(self), string.param().abi()).ok()
    }
    pub unsafe fn SetEventContextCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventContextCallbacks>,
    {
        (windows_core::Interface::vtable(self).SetEventContextCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok()
    }
    pub unsafe fn SetClientContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetClientContext)(windows_core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn OpenDumpFileWide2<P0>(&self, filename: P0, filehandle: u64, alternatearch: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OpenDumpFileWide2)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, alternatearch).ok()
    }
}
#[repr(C)]
pub struct IDebugClient8_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64) -> windows_core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32) -> windows_core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub AttachKernelWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub StartProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub StartServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputServersWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateProcess2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub CreateProcess2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR, u32, u32) -> windows_core::HRESULT,
    pub PushOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub PushOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub PopOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetNumberInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetEventContextCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetClientContext: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFileWide2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugControl, IDebugControl_Vtbl, 0x5182e668_105e_416e_ad92_24ef800424ba);
impl std::ops::Deref for IDebugControl {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugControl, windows_core::IUnknown);
impl IDebugControl {
    pub unsafe fn GetInterrupt(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetInterrupt)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetInterrupt(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterrupt)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetInterruptTimeout(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInterruptTimeout)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetInterruptTimeout(&self, seconds: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterruptTimeout)(windows_core::Interface::as_raw(self), seconds).ok()
    }
    pub unsafe fn GetLogFile(&self, buffer: Option<&mut [u8]>, filesize: Option<*mut u32>, append: *mut super::super::super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), append).ok()
    }
    pub unsafe fn OpenLogFile<P0, P1>(&self, file: P0, append: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<super::super::super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile)(windows_core::Interface::as_raw(self), file.param().abi(), append.param().abi()).ok()
    }
    pub unsafe fn CloseLogFile(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CloseLogFile)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetLogMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetLogMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetLogMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetLogMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn Input(&self, buffer: &mut [u8], inputsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Input)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_ptr()), buffer.len().try_into().unwrap(), core::mem::transmute(inputsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReturnInput<P0>(&self, buffer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ReturnInput)(windows_core::Interface::as_raw(self), buffer.param().abi()).ok()
    }
    pub unsafe fn Output<P0>(&self, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Output)(windows_core::Interface::as_raw(self), mask, format.param().abi()).ok()
    }
    pub unsafe fn OutputVaList<P0>(&self, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputVaList)(windows_core::Interface::as_raw(self), mask, format.param().abi(), args).ok()
    }
    pub unsafe fn ControlledOutput<P0>(&self, outputcontrol: u32, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutput)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi()).ok()
    }
    pub unsafe fn ControlledOutputVaList<P0>(&self, outputcontrol: u32, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputVaList)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi(), args).ok()
    }
    pub unsafe fn OutputPrompt<P0>(&self, outputcontrol: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPrompt)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi()).ok()
    }
    pub unsafe fn OutputPromptVaList<P0>(&self, outputcontrol: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptVaList)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi(), args).ok()
    }
    pub unsafe fn GetPromptText(&self, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPromptText)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputCurrentState(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputCurrentState)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn OutputVersionInformation(&self, outputcontrol: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputVersionInformation)(windows_core::Interface::as_raw(self), outputcontrol).ok()
    }
    pub unsafe fn GetNotifyEventHandle(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNotifyEventHandle)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetNotifyEventHandle(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetNotifyEventHandle)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn Assemble<P0>(&self, offset: u64, instr: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).Assemble)(windows_core::Interface::as_raw(self), offset, instr.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn Disassemble(&self, offset: u64, flags: u32, buffer: Option<&mut [u8]>, disassemblysize: Option<*mut u32>, endoffset: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Disassemble)(windows_core::Interface::as_raw(self), offset, flags, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(disassemblysize.unwrap_or(std::ptr::null_mut())), endoffset).ok()
    }
    pub unsafe fn GetDisassembleEffectiveOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDisassembleEffectiveOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassembly(&self, outputcontrol: u32, offset: u64, flags: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).OutputDisassembly)(windows_core::Interface::as_raw(self), outputcontrol, offset, flags, &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassemblyLines(&self, outputcontrol: u32, previouslines: u32, offset: u64, flags: u32, offsetline: Option<*mut u32>, startoffset: Option<*mut u64>, endoffset: Option<*mut u64>, lineoffsets: Option<&mut [u64]>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputDisassemblyLines)(windows_core::Interface::as_raw(self), outputcontrol, previouslines, lineoffsets.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), offset, flags, core::mem::transmute(offsetline.unwrap_or(std::ptr::null_mut())), core::mem::transmute(startoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(endoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(lineoffsets.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))).ok()
    }
    pub unsafe fn GetNearInstruction(&self, offset: u64, delta: i32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNearInstruction)(windows_core::Interface::as_raw(self), offset, delta, &mut result__).map(|| result__)
    }
    pub unsafe fn GetStackTrace(&self, frameoffset: u64, stackoffset: u64, instructionoffset: u64, frames: &mut [DEBUG_STACK_FRAME], framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStackTrace)(windows_core::Interface::as_raw(self), frameoffset, stackoffset, instructionoffset, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetReturnOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetReturnOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputStackTrace(&self, outputcontrol: u32, frames: Option<&[DEBUG_STACK_FRAME]>, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputStackTrace)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), flags).ok()
    }
    pub unsafe fn GetDebuggeeType(&self, class: *mut u32, qualifier: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDebuggeeType)(windows_core::Interface::as_raw(self), class, qualifier).ok()
    }
    pub unsafe fn GetActualProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetActualProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetExecutingProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutingProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberPossibleExecutingProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetPossibleExecutingProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetNumberProcessors(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberProcessors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSystemVersion(&self, platformid: *mut u32, major: *mut u32, minor: *mut u32, servicepackstring: Option<&mut [u8]>, servicepackstringused: Option<*mut u32>, servicepacknumber: *mut u32, buildstring: Option<&mut [u8]>, buildstringused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersion)(
            windows_core::Interface::as_raw(self),
            platformid,
            major,
            minor,
            core::mem::transmute(servicepackstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            servicepackstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(servicepackstringused.unwrap_or(std::ptr::null_mut())),
            servicepacknumber,
            core::mem::transmute(buildstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            buildstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(buildstringused.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetPageSize(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPageSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsPointer64Bit(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsPointer64Bit)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReadBugCheckData(&self, code: *mut u32, arg1: *mut u64, arg2: *mut u64, arg3: *mut u64, arg4: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadBugCheckData)(windows_core::Interface::as_raw(self), code, arg1, arg2, arg3, arg4).ok()
    }
    pub unsafe fn GetNumberSupportedProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberSupportedProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSupportedProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSupportedProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetProcessorTypeNames(&self, r#type: u32, fullnamebuffer: Option<&mut [u8]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u8]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProcessorTypeNames)(
            windows_core::Interface::as_raw(self),
            r#type,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetEffectiveProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEffectiveProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetEffectiveProcessorType(&self, r#type: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEffectiveProcessorType)(windows_core::Interface::as_raw(self), r#type).ok()
    }
    pub unsafe fn GetExecutionStatus(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutionStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExecutionStatus(&self, status: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExecutionStatus)(windows_core::Interface::as_raw(self), status).ok()
    }
    pub unsafe fn GetCodeLevel(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCodeLevel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCodeLevel(&self, level: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCodeLevel)(windows_core::Interface::as_raw(self), level).ok()
    }
    pub unsafe fn GetEngineOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEngineOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn GetSystemErrorControl(&self, outputlevel: *mut u32, breaklevel: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn SetSystemErrorControl(&self, outputlevel: u32, breaklevel: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn GetTextMacro(&self, slot: u32, buffer: Option<&mut [u8]>, macrosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTextMacro)(windows_core::Interface::as_raw(self), slot, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(macrosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetTextMacro<P0>(&self, slot: u32, r#macro: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextMacro)(windows_core::Interface::as_raw(self), slot, r#macro.param().abi()).ok()
    }
    pub unsafe fn GetRadix(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRadix)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRadix(&self, radix: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetRadix)(windows_core::Interface::as_raw(self), radix).ok()
    }
    pub unsafe fn Evaluate<P0>(&self, expression: P0, desiredtype: u32, value: *mut DEBUG_VALUE, remainderindex: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Evaluate)(windows_core::Interface::as_raw(self), expression.param().abi(), desiredtype, value, core::mem::transmute(remainderindex.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CoerceValue(&self, r#in: *const DEBUG_VALUE, outtype: u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValue)(windows_core::Interface::as_raw(self), r#in, outtype, out).ok()
    }
    pub unsafe fn CoerceValues(&self, count: u32, r#in: *const DEBUG_VALUE, outtypes: *const u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValues)(windows_core::Interface::as_raw(self), count, r#in, outtypes, out).ok()
    }
    pub unsafe fn Execute<P0>(&self, outputcontrol: u32, command: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), outputcontrol, command.param().abi(), flags).ok()
    }
    pub unsafe fn ExecuteCommandFile<P0>(&self, outputcontrol: u32, commandfile: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteCommandFile)(windows_core::Interface::as_raw(self), outputcontrol, commandfile.param().abi(), flags).ok()
    }
    pub unsafe fn GetNumberBreakpoints(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberBreakpoints)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetBreakpointByIndex(&self, index: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByIndex)(windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointById(&self, id: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointById)(windows_core::Interface::as_raw(self), id, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointParameters(&self, count: u32, ids: Option<*const u32>, start: u32, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetBreakpointParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(ids.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn AddBreakpoint(&self, r#type: u32, desiredid: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddBreakpoint)(windows_core::Interface::as_raw(self), r#type, desiredid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RemoveBreakpoint<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint>,
    {
        (windows_core::Interface::vtable(self).RemoveBreakpoint)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn AddExtension<P0>(&self, path: P0, flags: u32) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddExtension)(windows_core::Interface::as_raw(self), path.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn RemoveExtension(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveExtension)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetExtensionByPath<P0>(&self, path: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExtensionByPath)(windows_core::Interface::as_raw(self), path.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn CallExtension<P0, P1>(&self, handle: u64, function: P0, arguments: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CallExtension)(windows_core::Interface::as_raw(self), handle, function.param().abi(), arguments.param().abi()).ok()
    }
    pub unsafe fn GetExtensionFunction<P0>(&self, handle: u64, funcname: P0, function: *mut super::super::super::super::Foundation::FARPROC) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetExtensionFunction)(windows_core::Interface::as_raw(self), handle, funcname.param().abi(), function).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis32(&self, api: *mut WINDBG_EXTENSION_APIS32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis32)(windows_core::Interface::as_raw(self), api).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis64(&self, api: *mut WINDBG_EXTENSION_APIS64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis64)(windows_core::Interface::as_raw(self), api).ok()
    }
    pub unsafe fn GetNumberEventFilters(&self, specificevents: *mut u32, specificexceptions: *mut u32, arbitraryexceptions: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetNumberEventFilters)(windows_core::Interface::as_raw(self), specificevents, specificexceptions, arbitraryexceptions).ok()
    }
    pub unsafe fn GetEventFilterText(&self, index: u32, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterText)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetEventFilterCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetEventFilterCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetEventFilterCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetSpecificFilterParameters(&self, start: u32, params: &mut [DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn SetSpecificFilterParameters(&self, start: u32, params: &[DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetSpecificFilterArgument(&self, index: u32, buffer: Option<&mut [u8]>, argumentsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(argumentsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetSpecificFilterArgument<P0>(&self, index: u32, argument: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, argument.param().abi()).ok()
    }
    pub unsafe fn GetExceptionFilterParameters(&self, count: u32, codes: Option<*const u32>, start: u32, params: *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(codes.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn SetExceptionFilterParameters(&self, params: &[DEBUG_EXCEPTION_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExceptionFilterParameters)(windows_core::Interface::as_raw(self), params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetExceptionFilterSecondCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetExceptionFilterSecondCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn WaitForEvent(&self, flags: u32, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForEvent)(windows_core::Interface::as_raw(self), flags, timeout).ok()
    }
    pub unsafe fn GetLastEventInformation(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>, description: Option<&mut [u8]>, descriptionused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLastEventInformation)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(descriptionused.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IDebugControl_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32, *mut super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OpenLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub CloseLogFile: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Input: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReturnInput: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub Output: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub ControlledOutput: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub ControlledOutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub OutputPrompt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputPromptVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub GetPromptText: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputCurrentState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OutputVersionInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub Assemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub Disassemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PSTR, u32, *mut u32, *mut u64) -> windows_core::HRESULT,
    pub GetDisassembleEffectiveOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassembly: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassemblyLines: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, u32, *mut u32, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNearInstruction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, i32, *mut u64) -> windows_core::HRESULT,
    pub GetStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, *mut DEBUG_STACK_FRAME, u32, *mut u32) -> windows_core::HRESULT,
    pub GetReturnOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME, u32, u32) -> windows_core::HRESULT,
    pub GetDebuggeeType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetActualProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExecutingProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNumberProcessors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetPageSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub IsPointer64Bit: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ReadBugCheckData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u64, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNumberSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetProcessorTypeNames: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Evaluate: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut DEBUG_VALUE, *mut u32) -> windows_core::HRESULT,
    pub CoerceValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const DEBUG_VALUE, u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub CoerceValues: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_VALUE, *const u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ExecuteCommandFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub GetNumberBreakpoints: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetBreakpointByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointById: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
    pub AddBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddExtension: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut u64) -> windows_core::HRESULT,
    pub RemoveExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetExtensionByPath: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub CallExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExtensionFunction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut super::super::super::super::Foundation::FARPROC) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis32: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis32: usize,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis64: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis64: usize,
    pub GetNumberEventFilters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterText: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *const DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WaitForEvent: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetLastEventInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugControl2, IDebugControl2_Vtbl, 0xd4366723_44df_4bed_8c7e_4c05424f4588);
impl std::ops::Deref for IDebugControl2 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugControl2, windows_core::IUnknown);
impl IDebugControl2 {
    pub unsafe fn GetInterrupt(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetInterrupt)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetInterrupt(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterrupt)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetInterruptTimeout(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInterruptTimeout)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetInterruptTimeout(&self, seconds: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterruptTimeout)(windows_core::Interface::as_raw(self), seconds).ok()
    }
    pub unsafe fn GetLogFile(&self, buffer: Option<&mut [u8]>, filesize: Option<*mut u32>, append: *mut super::super::super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), append).ok()
    }
    pub unsafe fn OpenLogFile<P0, P1>(&self, file: P0, append: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<super::super::super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile)(windows_core::Interface::as_raw(self), file.param().abi(), append.param().abi()).ok()
    }
    pub unsafe fn CloseLogFile(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CloseLogFile)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetLogMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetLogMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetLogMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetLogMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn Input(&self, buffer: &mut [u8], inputsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Input)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_ptr()), buffer.len().try_into().unwrap(), core::mem::transmute(inputsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReturnInput<P0>(&self, buffer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ReturnInput)(windows_core::Interface::as_raw(self), buffer.param().abi()).ok()
    }
    pub unsafe fn Output<P0>(&self, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Output)(windows_core::Interface::as_raw(self), mask, format.param().abi()).ok()
    }
    pub unsafe fn OutputVaList<P0>(&self, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputVaList)(windows_core::Interface::as_raw(self), mask, format.param().abi(), args).ok()
    }
    pub unsafe fn ControlledOutput<P0>(&self, outputcontrol: u32, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutput)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi()).ok()
    }
    pub unsafe fn ControlledOutputVaList<P0>(&self, outputcontrol: u32, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputVaList)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi(), args).ok()
    }
    pub unsafe fn OutputPrompt<P0>(&self, outputcontrol: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPrompt)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi()).ok()
    }
    pub unsafe fn OutputPromptVaList<P0>(&self, outputcontrol: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptVaList)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi(), args).ok()
    }
    pub unsafe fn GetPromptText(&self, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPromptText)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputCurrentState(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputCurrentState)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn OutputVersionInformation(&self, outputcontrol: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputVersionInformation)(windows_core::Interface::as_raw(self), outputcontrol).ok()
    }
    pub unsafe fn GetNotifyEventHandle(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNotifyEventHandle)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetNotifyEventHandle(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetNotifyEventHandle)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn Assemble<P0>(&self, offset: u64, instr: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).Assemble)(windows_core::Interface::as_raw(self), offset, instr.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn Disassemble(&self, offset: u64, flags: u32, buffer: Option<&mut [u8]>, disassemblysize: Option<*mut u32>, endoffset: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Disassemble)(windows_core::Interface::as_raw(self), offset, flags, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(disassemblysize.unwrap_or(std::ptr::null_mut())), endoffset).ok()
    }
    pub unsafe fn GetDisassembleEffectiveOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDisassembleEffectiveOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassembly(&self, outputcontrol: u32, offset: u64, flags: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).OutputDisassembly)(windows_core::Interface::as_raw(self), outputcontrol, offset, flags, &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassemblyLines(&self, outputcontrol: u32, previouslines: u32, offset: u64, flags: u32, offsetline: Option<*mut u32>, startoffset: Option<*mut u64>, endoffset: Option<*mut u64>, lineoffsets: Option<&mut [u64]>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputDisassemblyLines)(windows_core::Interface::as_raw(self), outputcontrol, previouslines, lineoffsets.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), offset, flags, core::mem::transmute(offsetline.unwrap_or(std::ptr::null_mut())), core::mem::transmute(startoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(endoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(lineoffsets.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))).ok()
    }
    pub unsafe fn GetNearInstruction(&self, offset: u64, delta: i32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNearInstruction)(windows_core::Interface::as_raw(self), offset, delta, &mut result__).map(|| result__)
    }
    pub unsafe fn GetStackTrace(&self, frameoffset: u64, stackoffset: u64, instructionoffset: u64, frames: &mut [DEBUG_STACK_FRAME], framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStackTrace)(windows_core::Interface::as_raw(self), frameoffset, stackoffset, instructionoffset, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetReturnOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetReturnOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputStackTrace(&self, outputcontrol: u32, frames: Option<&[DEBUG_STACK_FRAME]>, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputStackTrace)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), flags).ok()
    }
    pub unsafe fn GetDebuggeeType(&self, class: *mut u32, qualifier: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDebuggeeType)(windows_core::Interface::as_raw(self), class, qualifier).ok()
    }
    pub unsafe fn GetActualProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetActualProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetExecutingProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutingProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberPossibleExecutingProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetPossibleExecutingProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetNumberProcessors(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberProcessors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSystemVersion(&self, platformid: *mut u32, major: *mut u32, minor: *mut u32, servicepackstring: Option<&mut [u8]>, servicepackstringused: Option<*mut u32>, servicepacknumber: *mut u32, buildstring: Option<&mut [u8]>, buildstringused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersion)(
            windows_core::Interface::as_raw(self),
            platformid,
            major,
            minor,
            core::mem::transmute(servicepackstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            servicepackstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(servicepackstringused.unwrap_or(std::ptr::null_mut())),
            servicepacknumber,
            core::mem::transmute(buildstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            buildstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(buildstringused.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetPageSize(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPageSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsPointer64Bit(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsPointer64Bit)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReadBugCheckData(&self, code: *mut u32, arg1: *mut u64, arg2: *mut u64, arg3: *mut u64, arg4: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadBugCheckData)(windows_core::Interface::as_raw(self), code, arg1, arg2, arg3, arg4).ok()
    }
    pub unsafe fn GetNumberSupportedProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberSupportedProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSupportedProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSupportedProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetProcessorTypeNames(&self, r#type: u32, fullnamebuffer: Option<&mut [u8]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u8]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProcessorTypeNames)(
            windows_core::Interface::as_raw(self),
            r#type,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetEffectiveProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEffectiveProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetEffectiveProcessorType(&self, r#type: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEffectiveProcessorType)(windows_core::Interface::as_raw(self), r#type).ok()
    }
    pub unsafe fn GetExecutionStatus(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutionStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExecutionStatus(&self, status: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExecutionStatus)(windows_core::Interface::as_raw(self), status).ok()
    }
    pub unsafe fn GetCodeLevel(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCodeLevel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCodeLevel(&self, level: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCodeLevel)(windows_core::Interface::as_raw(self), level).ok()
    }
    pub unsafe fn GetEngineOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEngineOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn GetSystemErrorControl(&self, outputlevel: *mut u32, breaklevel: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn SetSystemErrorControl(&self, outputlevel: u32, breaklevel: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn GetTextMacro(&self, slot: u32, buffer: Option<&mut [u8]>, macrosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTextMacro)(windows_core::Interface::as_raw(self), slot, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(macrosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetTextMacro<P0>(&self, slot: u32, r#macro: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextMacro)(windows_core::Interface::as_raw(self), slot, r#macro.param().abi()).ok()
    }
    pub unsafe fn GetRadix(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRadix)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRadix(&self, radix: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetRadix)(windows_core::Interface::as_raw(self), radix).ok()
    }
    pub unsafe fn Evaluate<P0>(&self, expression: P0, desiredtype: u32, value: *mut DEBUG_VALUE, remainderindex: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Evaluate)(windows_core::Interface::as_raw(self), expression.param().abi(), desiredtype, value, core::mem::transmute(remainderindex.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CoerceValue(&self, r#in: *const DEBUG_VALUE, outtype: u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValue)(windows_core::Interface::as_raw(self), r#in, outtype, out).ok()
    }
    pub unsafe fn CoerceValues(&self, count: u32, r#in: *const DEBUG_VALUE, outtypes: *const u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValues)(windows_core::Interface::as_raw(self), count, r#in, outtypes, out).ok()
    }
    pub unsafe fn Execute<P0>(&self, outputcontrol: u32, command: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), outputcontrol, command.param().abi(), flags).ok()
    }
    pub unsafe fn ExecuteCommandFile<P0>(&self, outputcontrol: u32, commandfile: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteCommandFile)(windows_core::Interface::as_raw(self), outputcontrol, commandfile.param().abi(), flags).ok()
    }
    pub unsafe fn GetNumberBreakpoints(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberBreakpoints)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetBreakpointByIndex(&self, index: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByIndex)(windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointById(&self, id: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointById)(windows_core::Interface::as_raw(self), id, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointParameters(&self, count: u32, ids: Option<*const u32>, start: u32, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetBreakpointParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(ids.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn AddBreakpoint(&self, r#type: u32, desiredid: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddBreakpoint)(windows_core::Interface::as_raw(self), r#type, desiredid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RemoveBreakpoint<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint>,
    {
        (windows_core::Interface::vtable(self).RemoveBreakpoint)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn AddExtension<P0>(&self, path: P0, flags: u32) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddExtension)(windows_core::Interface::as_raw(self), path.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn RemoveExtension(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveExtension)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetExtensionByPath<P0>(&self, path: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExtensionByPath)(windows_core::Interface::as_raw(self), path.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn CallExtension<P0, P1>(&self, handle: u64, function: P0, arguments: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CallExtension)(windows_core::Interface::as_raw(self), handle, function.param().abi(), arguments.param().abi()).ok()
    }
    pub unsafe fn GetExtensionFunction<P0>(&self, handle: u64, funcname: P0, function: *mut super::super::super::super::Foundation::FARPROC) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetExtensionFunction)(windows_core::Interface::as_raw(self), handle, funcname.param().abi(), function).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis32(&self, api: *mut WINDBG_EXTENSION_APIS32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis32)(windows_core::Interface::as_raw(self), api).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis64(&self, api: *mut WINDBG_EXTENSION_APIS64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis64)(windows_core::Interface::as_raw(self), api).ok()
    }
    pub unsafe fn GetNumberEventFilters(&self, specificevents: *mut u32, specificexceptions: *mut u32, arbitraryexceptions: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetNumberEventFilters)(windows_core::Interface::as_raw(self), specificevents, specificexceptions, arbitraryexceptions).ok()
    }
    pub unsafe fn GetEventFilterText(&self, index: u32, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterText)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetEventFilterCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetEventFilterCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetEventFilterCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetSpecificFilterParameters(&self, start: u32, params: &mut [DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn SetSpecificFilterParameters(&self, start: u32, params: &[DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetSpecificFilterArgument(&self, index: u32, buffer: Option<&mut [u8]>, argumentsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(argumentsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetSpecificFilterArgument<P0>(&self, index: u32, argument: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, argument.param().abi()).ok()
    }
    pub unsafe fn GetExceptionFilterParameters(&self, count: u32, codes: Option<*const u32>, start: u32, params: *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(codes.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn SetExceptionFilterParameters(&self, params: &[DEBUG_EXCEPTION_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExceptionFilterParameters)(windows_core::Interface::as_raw(self), params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetExceptionFilterSecondCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetExceptionFilterSecondCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn WaitForEvent(&self, flags: u32, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForEvent)(windows_core::Interface::as_raw(self), flags, timeout).ok()
    }
    pub unsafe fn GetLastEventInformation(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>, description: Option<&mut [u8]>, descriptionused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLastEventInformation)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(descriptionused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetCurrentTimeDate(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentTimeDate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentSystemUpTime(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentSystemUpTime)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDumpFormatFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDumpFormatFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberTextReplacements(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberTextReplacements)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetTextReplacement<P0>(&self, srctext: P0, index: u32, srcbuffer: Option<&mut [u8]>, srcsize: Option<*mut u32>, dstbuffer: Option<&mut [u8]>, dstsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetTextReplacement)(
            windows_core::Interface::as_raw(self),
            srctext.param().abi(),
            index,
            core::mem::transmute(srcbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            srcbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(srcsize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(dstbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            dstbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(dstsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn SetTextReplacement<P0, P1>(&self, srctext: P0, dsttext: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextReplacement)(windows_core::Interface::as_raw(self), srctext.param().abi(), dsttext.param().abi()).ok()
    }
    pub unsafe fn RemoveTextReplacements(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveTextReplacements)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn OutputTextReplacements(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputTextReplacements)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
}
#[repr(C)]
pub struct IDebugControl2_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32, *mut super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OpenLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub CloseLogFile: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Input: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReturnInput: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub Output: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub ControlledOutput: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub ControlledOutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub OutputPrompt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputPromptVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub GetPromptText: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputCurrentState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OutputVersionInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub Assemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub Disassemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PSTR, u32, *mut u32, *mut u64) -> windows_core::HRESULT,
    pub GetDisassembleEffectiveOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassembly: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassemblyLines: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, u32, *mut u32, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNearInstruction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, i32, *mut u64) -> windows_core::HRESULT,
    pub GetStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, *mut DEBUG_STACK_FRAME, u32, *mut u32) -> windows_core::HRESULT,
    pub GetReturnOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME, u32, u32) -> windows_core::HRESULT,
    pub GetDebuggeeType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetActualProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExecutingProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNumberProcessors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetPageSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub IsPointer64Bit: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ReadBugCheckData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u64, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNumberSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetProcessorTypeNames: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Evaluate: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut DEBUG_VALUE, *mut u32) -> windows_core::HRESULT,
    pub CoerceValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const DEBUG_VALUE, u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub CoerceValues: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_VALUE, *const u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ExecuteCommandFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub GetNumberBreakpoints: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetBreakpointByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointById: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
    pub AddBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddExtension: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut u64) -> windows_core::HRESULT,
    pub RemoveExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetExtensionByPath: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub CallExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExtensionFunction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut super::super::super::super::Foundation::FARPROC) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis32: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis32: usize,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis64: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis64: usize,
    pub GetNumberEventFilters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterText: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *const DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WaitForEvent: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetLastEventInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentTimeDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentSystemUpTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFormatFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTextReplacement: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextReplacement: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub RemoveTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OutputTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugControl3, IDebugControl3_Vtbl, 0x7df74a86_b03f_407f_90ab_a20dadcead08);
impl std::ops::Deref for IDebugControl3 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugControl3, windows_core::IUnknown);
impl IDebugControl3 {
    pub unsafe fn GetInterrupt(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetInterrupt)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetInterrupt(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterrupt)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetInterruptTimeout(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInterruptTimeout)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetInterruptTimeout(&self, seconds: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterruptTimeout)(windows_core::Interface::as_raw(self), seconds).ok()
    }
    pub unsafe fn GetLogFile(&self, buffer: Option<&mut [u8]>, filesize: Option<*mut u32>, append: *mut super::super::super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), append).ok()
    }
    pub unsafe fn OpenLogFile<P0, P1>(&self, file: P0, append: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<super::super::super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile)(windows_core::Interface::as_raw(self), file.param().abi(), append.param().abi()).ok()
    }
    pub unsafe fn CloseLogFile(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CloseLogFile)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetLogMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetLogMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetLogMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetLogMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn Input(&self, buffer: &mut [u8], inputsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Input)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_ptr()), buffer.len().try_into().unwrap(), core::mem::transmute(inputsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReturnInput<P0>(&self, buffer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ReturnInput)(windows_core::Interface::as_raw(self), buffer.param().abi()).ok()
    }
    pub unsafe fn Output<P0>(&self, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Output)(windows_core::Interface::as_raw(self), mask, format.param().abi()).ok()
    }
    pub unsafe fn OutputVaList<P0>(&self, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputVaList)(windows_core::Interface::as_raw(self), mask, format.param().abi(), args).ok()
    }
    pub unsafe fn ControlledOutput<P0>(&self, outputcontrol: u32, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutput)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi()).ok()
    }
    pub unsafe fn ControlledOutputVaList<P0>(&self, outputcontrol: u32, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputVaList)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi(), args).ok()
    }
    pub unsafe fn OutputPrompt<P0>(&self, outputcontrol: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPrompt)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi()).ok()
    }
    pub unsafe fn OutputPromptVaList<P0>(&self, outputcontrol: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptVaList)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi(), args).ok()
    }
    pub unsafe fn GetPromptText(&self, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPromptText)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputCurrentState(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputCurrentState)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn OutputVersionInformation(&self, outputcontrol: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputVersionInformation)(windows_core::Interface::as_raw(self), outputcontrol).ok()
    }
    pub unsafe fn GetNotifyEventHandle(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNotifyEventHandle)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetNotifyEventHandle(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetNotifyEventHandle)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn Assemble<P0>(&self, offset: u64, instr: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).Assemble)(windows_core::Interface::as_raw(self), offset, instr.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn Disassemble(&self, offset: u64, flags: u32, buffer: Option<&mut [u8]>, disassemblysize: Option<*mut u32>, endoffset: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Disassemble)(windows_core::Interface::as_raw(self), offset, flags, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(disassemblysize.unwrap_or(std::ptr::null_mut())), endoffset).ok()
    }
    pub unsafe fn GetDisassembleEffectiveOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDisassembleEffectiveOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassembly(&self, outputcontrol: u32, offset: u64, flags: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).OutputDisassembly)(windows_core::Interface::as_raw(self), outputcontrol, offset, flags, &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassemblyLines(&self, outputcontrol: u32, previouslines: u32, offset: u64, flags: u32, offsetline: Option<*mut u32>, startoffset: Option<*mut u64>, endoffset: Option<*mut u64>, lineoffsets: Option<&mut [u64]>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputDisassemblyLines)(windows_core::Interface::as_raw(self), outputcontrol, previouslines, lineoffsets.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), offset, flags, core::mem::transmute(offsetline.unwrap_or(std::ptr::null_mut())), core::mem::transmute(startoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(endoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(lineoffsets.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))).ok()
    }
    pub unsafe fn GetNearInstruction(&self, offset: u64, delta: i32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNearInstruction)(windows_core::Interface::as_raw(self), offset, delta, &mut result__).map(|| result__)
    }
    pub unsafe fn GetStackTrace(&self, frameoffset: u64, stackoffset: u64, instructionoffset: u64, frames: &mut [DEBUG_STACK_FRAME], framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStackTrace)(windows_core::Interface::as_raw(self), frameoffset, stackoffset, instructionoffset, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetReturnOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetReturnOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputStackTrace(&self, outputcontrol: u32, frames: Option<&[DEBUG_STACK_FRAME]>, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputStackTrace)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), flags).ok()
    }
    pub unsafe fn GetDebuggeeType(&self, class: *mut u32, qualifier: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDebuggeeType)(windows_core::Interface::as_raw(self), class, qualifier).ok()
    }
    pub unsafe fn GetActualProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetActualProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetExecutingProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutingProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberPossibleExecutingProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetPossibleExecutingProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetNumberProcessors(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberProcessors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSystemVersion(&self, platformid: *mut u32, major: *mut u32, minor: *mut u32, servicepackstring: Option<&mut [u8]>, servicepackstringused: Option<*mut u32>, servicepacknumber: *mut u32, buildstring: Option<&mut [u8]>, buildstringused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersion)(
            windows_core::Interface::as_raw(self),
            platformid,
            major,
            minor,
            core::mem::transmute(servicepackstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            servicepackstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(servicepackstringused.unwrap_or(std::ptr::null_mut())),
            servicepacknumber,
            core::mem::transmute(buildstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            buildstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(buildstringused.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetPageSize(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPageSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsPointer64Bit(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsPointer64Bit)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReadBugCheckData(&self, code: *mut u32, arg1: *mut u64, arg2: *mut u64, arg3: *mut u64, arg4: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadBugCheckData)(windows_core::Interface::as_raw(self), code, arg1, arg2, arg3, arg4).ok()
    }
    pub unsafe fn GetNumberSupportedProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberSupportedProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSupportedProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSupportedProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetProcessorTypeNames(&self, r#type: u32, fullnamebuffer: Option<&mut [u8]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u8]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProcessorTypeNames)(
            windows_core::Interface::as_raw(self),
            r#type,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetEffectiveProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEffectiveProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetEffectiveProcessorType(&self, r#type: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEffectiveProcessorType)(windows_core::Interface::as_raw(self), r#type).ok()
    }
    pub unsafe fn GetExecutionStatus(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutionStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExecutionStatus(&self, status: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExecutionStatus)(windows_core::Interface::as_raw(self), status).ok()
    }
    pub unsafe fn GetCodeLevel(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCodeLevel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCodeLevel(&self, level: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCodeLevel)(windows_core::Interface::as_raw(self), level).ok()
    }
    pub unsafe fn GetEngineOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEngineOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn GetSystemErrorControl(&self, outputlevel: *mut u32, breaklevel: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn SetSystemErrorControl(&self, outputlevel: u32, breaklevel: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn GetTextMacro(&self, slot: u32, buffer: Option<&mut [u8]>, macrosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTextMacro)(windows_core::Interface::as_raw(self), slot, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(macrosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetTextMacro<P0>(&self, slot: u32, r#macro: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextMacro)(windows_core::Interface::as_raw(self), slot, r#macro.param().abi()).ok()
    }
    pub unsafe fn GetRadix(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRadix)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRadix(&self, radix: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetRadix)(windows_core::Interface::as_raw(self), radix).ok()
    }
    pub unsafe fn Evaluate<P0>(&self, expression: P0, desiredtype: u32, value: *mut DEBUG_VALUE, remainderindex: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Evaluate)(windows_core::Interface::as_raw(self), expression.param().abi(), desiredtype, value, core::mem::transmute(remainderindex.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CoerceValue(&self, r#in: *const DEBUG_VALUE, outtype: u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValue)(windows_core::Interface::as_raw(self), r#in, outtype, out).ok()
    }
    pub unsafe fn CoerceValues(&self, count: u32, r#in: *const DEBUG_VALUE, outtypes: *const u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValues)(windows_core::Interface::as_raw(self), count, r#in, outtypes, out).ok()
    }
    pub unsafe fn Execute<P0>(&self, outputcontrol: u32, command: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), outputcontrol, command.param().abi(), flags).ok()
    }
    pub unsafe fn ExecuteCommandFile<P0>(&self, outputcontrol: u32, commandfile: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteCommandFile)(windows_core::Interface::as_raw(self), outputcontrol, commandfile.param().abi(), flags).ok()
    }
    pub unsafe fn GetNumberBreakpoints(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberBreakpoints)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetBreakpointByIndex(&self, index: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByIndex)(windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointById(&self, id: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointById)(windows_core::Interface::as_raw(self), id, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointParameters(&self, count: u32, ids: Option<*const u32>, start: u32, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetBreakpointParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(ids.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn AddBreakpoint(&self, r#type: u32, desiredid: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddBreakpoint)(windows_core::Interface::as_raw(self), r#type, desiredid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RemoveBreakpoint<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint>,
    {
        (windows_core::Interface::vtable(self).RemoveBreakpoint)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn AddExtension<P0>(&self, path: P0, flags: u32) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddExtension)(windows_core::Interface::as_raw(self), path.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn RemoveExtension(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveExtension)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetExtensionByPath<P0>(&self, path: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExtensionByPath)(windows_core::Interface::as_raw(self), path.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn CallExtension<P0, P1>(&self, handle: u64, function: P0, arguments: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CallExtension)(windows_core::Interface::as_raw(self), handle, function.param().abi(), arguments.param().abi()).ok()
    }
    pub unsafe fn GetExtensionFunction<P0>(&self, handle: u64, funcname: P0, function: *mut super::super::super::super::Foundation::FARPROC) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetExtensionFunction)(windows_core::Interface::as_raw(self), handle, funcname.param().abi(), function).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis32(&self, api: *mut WINDBG_EXTENSION_APIS32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis32)(windows_core::Interface::as_raw(self), api).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis64(&self, api: *mut WINDBG_EXTENSION_APIS64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis64)(windows_core::Interface::as_raw(self), api).ok()
    }
    pub unsafe fn GetNumberEventFilters(&self, specificevents: *mut u32, specificexceptions: *mut u32, arbitraryexceptions: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetNumberEventFilters)(windows_core::Interface::as_raw(self), specificevents, specificexceptions, arbitraryexceptions).ok()
    }
    pub unsafe fn GetEventFilterText(&self, index: u32, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterText)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetEventFilterCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetEventFilterCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetEventFilterCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetSpecificFilterParameters(&self, start: u32, params: &mut [DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn SetSpecificFilterParameters(&self, start: u32, params: &[DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetSpecificFilterArgument(&self, index: u32, buffer: Option<&mut [u8]>, argumentsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(argumentsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetSpecificFilterArgument<P0>(&self, index: u32, argument: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, argument.param().abi()).ok()
    }
    pub unsafe fn GetExceptionFilterParameters(&self, count: u32, codes: Option<*const u32>, start: u32, params: *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(codes.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn SetExceptionFilterParameters(&self, params: &[DEBUG_EXCEPTION_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExceptionFilterParameters)(windows_core::Interface::as_raw(self), params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetExceptionFilterSecondCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetExceptionFilterSecondCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn WaitForEvent(&self, flags: u32, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForEvent)(windows_core::Interface::as_raw(self), flags, timeout).ok()
    }
    pub unsafe fn GetLastEventInformation(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>, description: Option<&mut [u8]>, descriptionused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLastEventInformation)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(descriptionused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetCurrentTimeDate(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentTimeDate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentSystemUpTime(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentSystemUpTime)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDumpFormatFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDumpFormatFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberTextReplacements(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberTextReplacements)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetTextReplacement<P0>(&self, srctext: P0, index: u32, srcbuffer: Option<&mut [u8]>, srcsize: Option<*mut u32>, dstbuffer: Option<&mut [u8]>, dstsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetTextReplacement)(
            windows_core::Interface::as_raw(self),
            srctext.param().abi(),
            index,
            core::mem::transmute(srcbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            srcbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(srcsize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(dstbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            dstbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(dstsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn SetTextReplacement<P0, P1>(&self, srctext: P0, dsttext: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextReplacement)(windows_core::Interface::as_raw(self), srctext.param().abi(), dsttext.param().abi()).ok()
    }
    pub unsafe fn RemoveTextReplacements(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveTextReplacements)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn OutputTextReplacements(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputTextReplacements)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn GetAssemblyOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAssemblyOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn GetExpressionSyntax(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExpressionSyntax)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExpressionSyntax(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExpressionSyntax)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetExpressionSyntaxByName<P0>(&self, abbrevname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetExpressionSyntaxByName)(windows_core::Interface::as_raw(self), abbrevname.param().abi()).ok()
    }
    pub unsafe fn GetNumberExpressionSyntaxes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberExpressionSyntaxes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetExpressionSyntaxNames(&self, index: u32, fullnamebuffer: Option<&mut [u8]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u8]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExpressionSyntaxNames)(
            windows_core::Interface::as_raw(self),
            index,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetNumberEvents(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberEvents)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetEventIndexDescription<P0>(&self, index: u32, which: u32, buffer: P0, buffersize: u32, descsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetEventIndexDescription)(windows_core::Interface::as_raw(self), index, which, buffer.param().abi(), buffersize, core::mem::transmute(descsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetCurrentEventIndex(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentEventIndex)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetNextEventIndex(&self, relation: u32, value: u32) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).SetNextEventIndex)(windows_core::Interface::as_raw(self), relation, value, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IDebugControl3_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32, *mut super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OpenLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub CloseLogFile: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Input: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReturnInput: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub Output: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub ControlledOutput: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub ControlledOutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub OutputPrompt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputPromptVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub GetPromptText: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputCurrentState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OutputVersionInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub Assemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub Disassemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PSTR, u32, *mut u32, *mut u64) -> windows_core::HRESULT,
    pub GetDisassembleEffectiveOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassembly: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassemblyLines: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, u32, *mut u32, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNearInstruction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, i32, *mut u64) -> windows_core::HRESULT,
    pub GetStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, *mut DEBUG_STACK_FRAME, u32, *mut u32) -> windows_core::HRESULT,
    pub GetReturnOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME, u32, u32) -> windows_core::HRESULT,
    pub GetDebuggeeType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetActualProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExecutingProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNumberProcessors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetPageSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub IsPointer64Bit: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ReadBugCheckData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u64, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNumberSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetProcessorTypeNames: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Evaluate: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut DEBUG_VALUE, *mut u32) -> windows_core::HRESULT,
    pub CoerceValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const DEBUG_VALUE, u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub CoerceValues: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_VALUE, *const u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ExecuteCommandFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub GetNumberBreakpoints: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetBreakpointByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointById: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
    pub AddBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddExtension: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut u64) -> windows_core::HRESULT,
    pub RemoveExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetExtensionByPath: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub CallExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExtensionFunction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut super::super::super::super::Foundation::FARPROC) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis32: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis32: usize,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis64: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis64: usize,
    pub GetNumberEventFilters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterText: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *const DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WaitForEvent: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetLastEventInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentTimeDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentSystemUpTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFormatFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTextReplacement: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextReplacement: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub RemoveTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OutputTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExpressionSyntax: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetExpressionSyntax: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetExpressionSyntaxByName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetNumberExpressionSyntaxes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExpressionSyntaxNames: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNumberEvents: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetEventIndexDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentEventIndex: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetNextEventIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugControl4, IDebugControl4_Vtbl, 0x94e60ce9_9b41_4b19_9fc0_6d9eb35272b3);
impl std::ops::Deref for IDebugControl4 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugControl4, windows_core::IUnknown);
impl IDebugControl4 {
    pub unsafe fn GetInterrupt(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetInterrupt)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetInterrupt(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterrupt)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetInterruptTimeout(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInterruptTimeout)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetInterruptTimeout(&self, seconds: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterruptTimeout)(windows_core::Interface::as_raw(self), seconds).ok()
    }
    pub unsafe fn GetLogFile(&self, buffer: Option<&mut [u8]>, filesize: Option<*mut u32>, append: *mut super::super::super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), append).ok()
    }
    pub unsafe fn OpenLogFile<P0, P1>(&self, file: P0, append: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<super::super::super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile)(windows_core::Interface::as_raw(self), file.param().abi(), append.param().abi()).ok()
    }
    pub unsafe fn CloseLogFile(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CloseLogFile)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetLogMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetLogMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetLogMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetLogMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn Input(&self, buffer: &mut [u8], inputsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Input)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_ptr()), buffer.len().try_into().unwrap(), core::mem::transmute(inputsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReturnInput<P0>(&self, buffer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ReturnInput)(windows_core::Interface::as_raw(self), buffer.param().abi()).ok()
    }
    pub unsafe fn Output<P0>(&self, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Output)(windows_core::Interface::as_raw(self), mask, format.param().abi()).ok()
    }
    pub unsafe fn OutputVaList<P0>(&self, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputVaList)(windows_core::Interface::as_raw(self), mask, format.param().abi(), args).ok()
    }
    pub unsafe fn ControlledOutput<P0>(&self, outputcontrol: u32, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutput)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi()).ok()
    }
    pub unsafe fn ControlledOutputVaList<P0>(&self, outputcontrol: u32, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputVaList)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi(), args).ok()
    }
    pub unsafe fn OutputPrompt<P0>(&self, outputcontrol: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPrompt)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi()).ok()
    }
    pub unsafe fn OutputPromptVaList<P0>(&self, outputcontrol: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptVaList)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi(), args).ok()
    }
    pub unsafe fn GetPromptText(&self, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPromptText)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputCurrentState(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputCurrentState)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn OutputVersionInformation(&self, outputcontrol: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputVersionInformation)(windows_core::Interface::as_raw(self), outputcontrol).ok()
    }
    pub unsafe fn GetNotifyEventHandle(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNotifyEventHandle)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetNotifyEventHandle(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetNotifyEventHandle)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn Assemble<P0>(&self, offset: u64, instr: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).Assemble)(windows_core::Interface::as_raw(self), offset, instr.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn Disassemble(&self, offset: u64, flags: u32, buffer: Option<&mut [u8]>, disassemblysize: Option<*mut u32>, endoffset: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Disassemble)(windows_core::Interface::as_raw(self), offset, flags, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(disassemblysize.unwrap_or(std::ptr::null_mut())), endoffset).ok()
    }
    pub unsafe fn GetDisassembleEffectiveOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDisassembleEffectiveOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassembly(&self, outputcontrol: u32, offset: u64, flags: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).OutputDisassembly)(windows_core::Interface::as_raw(self), outputcontrol, offset, flags, &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassemblyLines(&self, outputcontrol: u32, previouslines: u32, offset: u64, flags: u32, offsetline: Option<*mut u32>, startoffset: Option<*mut u64>, endoffset: Option<*mut u64>, lineoffsets: Option<&mut [u64]>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputDisassemblyLines)(windows_core::Interface::as_raw(self), outputcontrol, previouslines, lineoffsets.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), offset, flags, core::mem::transmute(offsetline.unwrap_or(std::ptr::null_mut())), core::mem::transmute(startoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(endoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(lineoffsets.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))).ok()
    }
    pub unsafe fn GetNearInstruction(&self, offset: u64, delta: i32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNearInstruction)(windows_core::Interface::as_raw(self), offset, delta, &mut result__).map(|| result__)
    }
    pub unsafe fn GetStackTrace(&self, frameoffset: u64, stackoffset: u64, instructionoffset: u64, frames: &mut [DEBUG_STACK_FRAME], framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStackTrace)(windows_core::Interface::as_raw(self), frameoffset, stackoffset, instructionoffset, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetReturnOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetReturnOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputStackTrace(&self, outputcontrol: u32, frames: Option<&[DEBUG_STACK_FRAME]>, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputStackTrace)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), flags).ok()
    }
    pub unsafe fn GetDebuggeeType(&self, class: *mut u32, qualifier: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDebuggeeType)(windows_core::Interface::as_raw(self), class, qualifier).ok()
    }
    pub unsafe fn GetActualProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetActualProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetExecutingProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutingProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberPossibleExecutingProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetPossibleExecutingProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetNumberProcessors(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberProcessors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSystemVersion(&self, platformid: *mut u32, major: *mut u32, minor: *mut u32, servicepackstring: Option<&mut [u8]>, servicepackstringused: Option<*mut u32>, servicepacknumber: *mut u32, buildstring: Option<&mut [u8]>, buildstringused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersion)(
            windows_core::Interface::as_raw(self),
            platformid,
            major,
            minor,
            core::mem::transmute(servicepackstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            servicepackstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(servicepackstringused.unwrap_or(std::ptr::null_mut())),
            servicepacknumber,
            core::mem::transmute(buildstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            buildstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(buildstringused.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetPageSize(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPageSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsPointer64Bit(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsPointer64Bit)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReadBugCheckData(&self, code: *mut u32, arg1: *mut u64, arg2: *mut u64, arg3: *mut u64, arg4: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadBugCheckData)(windows_core::Interface::as_raw(self), code, arg1, arg2, arg3, arg4).ok()
    }
    pub unsafe fn GetNumberSupportedProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberSupportedProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSupportedProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSupportedProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetProcessorTypeNames(&self, r#type: u32, fullnamebuffer: Option<&mut [u8]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u8]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProcessorTypeNames)(
            windows_core::Interface::as_raw(self),
            r#type,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetEffectiveProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEffectiveProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetEffectiveProcessorType(&self, r#type: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEffectiveProcessorType)(windows_core::Interface::as_raw(self), r#type).ok()
    }
    pub unsafe fn GetExecutionStatus(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutionStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExecutionStatus(&self, status: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExecutionStatus)(windows_core::Interface::as_raw(self), status).ok()
    }
    pub unsafe fn GetCodeLevel(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCodeLevel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCodeLevel(&self, level: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCodeLevel)(windows_core::Interface::as_raw(self), level).ok()
    }
    pub unsafe fn GetEngineOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEngineOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn GetSystemErrorControl(&self, outputlevel: *mut u32, breaklevel: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn SetSystemErrorControl(&self, outputlevel: u32, breaklevel: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn GetTextMacro(&self, slot: u32, buffer: Option<&mut [u8]>, macrosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTextMacro)(windows_core::Interface::as_raw(self), slot, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(macrosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetTextMacro<P0>(&self, slot: u32, r#macro: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextMacro)(windows_core::Interface::as_raw(self), slot, r#macro.param().abi()).ok()
    }
    pub unsafe fn GetRadix(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRadix)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRadix(&self, radix: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetRadix)(windows_core::Interface::as_raw(self), radix).ok()
    }
    pub unsafe fn Evaluate<P0>(&self, expression: P0, desiredtype: u32, value: *mut DEBUG_VALUE, remainderindex: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Evaluate)(windows_core::Interface::as_raw(self), expression.param().abi(), desiredtype, value, core::mem::transmute(remainderindex.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CoerceValue(&self, r#in: *const DEBUG_VALUE, outtype: u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValue)(windows_core::Interface::as_raw(self), r#in, outtype, out).ok()
    }
    pub unsafe fn CoerceValues(&self, count: u32, r#in: *const DEBUG_VALUE, outtypes: *const u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValues)(windows_core::Interface::as_raw(self), count, r#in, outtypes, out).ok()
    }
    pub unsafe fn Execute<P0>(&self, outputcontrol: u32, command: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), outputcontrol, command.param().abi(), flags).ok()
    }
    pub unsafe fn ExecuteCommandFile<P0>(&self, outputcontrol: u32, commandfile: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteCommandFile)(windows_core::Interface::as_raw(self), outputcontrol, commandfile.param().abi(), flags).ok()
    }
    pub unsafe fn GetNumberBreakpoints(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberBreakpoints)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetBreakpointByIndex(&self, index: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByIndex)(windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointById(&self, id: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointById)(windows_core::Interface::as_raw(self), id, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointParameters(&self, count: u32, ids: Option<*const u32>, start: u32, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetBreakpointParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(ids.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn AddBreakpoint(&self, r#type: u32, desiredid: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddBreakpoint)(windows_core::Interface::as_raw(self), r#type, desiredid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RemoveBreakpoint<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint>,
    {
        (windows_core::Interface::vtable(self).RemoveBreakpoint)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn AddExtension<P0>(&self, path: P0, flags: u32) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddExtension)(windows_core::Interface::as_raw(self), path.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn RemoveExtension(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveExtension)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetExtensionByPath<P0>(&self, path: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExtensionByPath)(windows_core::Interface::as_raw(self), path.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn CallExtension<P0, P1>(&self, handle: u64, function: P0, arguments: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CallExtension)(windows_core::Interface::as_raw(self), handle, function.param().abi(), arguments.param().abi()).ok()
    }
    pub unsafe fn GetExtensionFunction<P0>(&self, handle: u64, funcname: P0, function: *mut super::super::super::super::Foundation::FARPROC) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetExtensionFunction)(windows_core::Interface::as_raw(self), handle, funcname.param().abi(), function).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis32(&self, api: *mut WINDBG_EXTENSION_APIS32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis32)(windows_core::Interface::as_raw(self), api).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis64(&self, api: *mut WINDBG_EXTENSION_APIS64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis64)(windows_core::Interface::as_raw(self), api).ok()
    }
    pub unsafe fn GetNumberEventFilters(&self, specificevents: *mut u32, specificexceptions: *mut u32, arbitraryexceptions: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetNumberEventFilters)(windows_core::Interface::as_raw(self), specificevents, specificexceptions, arbitraryexceptions).ok()
    }
    pub unsafe fn GetEventFilterText(&self, index: u32, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterText)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetEventFilterCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetEventFilterCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetEventFilterCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetSpecificFilterParameters(&self, start: u32, params: &mut [DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn SetSpecificFilterParameters(&self, start: u32, params: &[DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetSpecificFilterArgument(&self, index: u32, buffer: Option<&mut [u8]>, argumentsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(argumentsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetSpecificFilterArgument<P0>(&self, index: u32, argument: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, argument.param().abi()).ok()
    }
    pub unsafe fn GetExceptionFilterParameters(&self, count: u32, codes: Option<*const u32>, start: u32, params: *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(codes.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn SetExceptionFilterParameters(&self, params: &[DEBUG_EXCEPTION_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExceptionFilterParameters)(windows_core::Interface::as_raw(self), params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetExceptionFilterSecondCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetExceptionFilterSecondCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn WaitForEvent(&self, flags: u32, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForEvent)(windows_core::Interface::as_raw(self), flags, timeout).ok()
    }
    pub unsafe fn GetLastEventInformation(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>, description: Option<&mut [u8]>, descriptionused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLastEventInformation)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(descriptionused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetCurrentTimeDate(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentTimeDate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentSystemUpTime(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentSystemUpTime)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDumpFormatFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDumpFormatFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberTextReplacements(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberTextReplacements)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetTextReplacement<P0>(&self, srctext: P0, index: u32, srcbuffer: Option<&mut [u8]>, srcsize: Option<*mut u32>, dstbuffer: Option<&mut [u8]>, dstsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetTextReplacement)(
            windows_core::Interface::as_raw(self),
            srctext.param().abi(),
            index,
            core::mem::transmute(srcbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            srcbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(srcsize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(dstbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            dstbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(dstsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn SetTextReplacement<P0, P1>(&self, srctext: P0, dsttext: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextReplacement)(windows_core::Interface::as_raw(self), srctext.param().abi(), dsttext.param().abi()).ok()
    }
    pub unsafe fn RemoveTextReplacements(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveTextReplacements)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn OutputTextReplacements(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputTextReplacements)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn GetAssemblyOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAssemblyOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn GetExpressionSyntax(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExpressionSyntax)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExpressionSyntax(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExpressionSyntax)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetExpressionSyntaxByName<P0>(&self, abbrevname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetExpressionSyntaxByName)(windows_core::Interface::as_raw(self), abbrevname.param().abi()).ok()
    }
    pub unsafe fn GetNumberExpressionSyntaxes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberExpressionSyntaxes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetExpressionSyntaxNames(&self, index: u32, fullnamebuffer: Option<&mut [u8]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u8]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExpressionSyntaxNames)(
            windows_core::Interface::as_raw(self),
            index,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetNumberEvents(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberEvents)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetEventIndexDescription<P0>(&self, index: u32, which: u32, buffer: P0, buffersize: u32, descsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetEventIndexDescription)(windows_core::Interface::as_raw(self), index, which, buffer.param().abi(), buffersize, core::mem::transmute(descsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetCurrentEventIndex(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentEventIndex)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetNextEventIndex(&self, relation: u32, value: u32) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).SetNextEventIndex)(windows_core::Interface::as_raw(self), relation, value, &mut result__).map(|| result__)
    }
    pub unsafe fn GetLogFileWide(&self, buffer: Option<&mut [u16]>, filesize: Option<*mut u32>, append: *mut super::super::super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFileWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), append).ok()
    }
    pub unsafe fn OpenLogFileWide<P0, P1>(&self, file: P0, append: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<super::super::super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OpenLogFileWide)(windows_core::Interface::as_raw(self), file.param().abi(), append.param().abi()).ok()
    }
    pub unsafe fn InputWide(&self, buffer: &mut [u16], inputsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).InputWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_ptr()), buffer.len().try_into().unwrap(), core::mem::transmute(inputsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReturnInputWide<P0>(&self, buffer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ReturnInputWide)(windows_core::Interface::as_raw(self), buffer.param().abi()).ok()
    }
    pub unsafe fn OutputWide<P0>(&self, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputWide)(windows_core::Interface::as_raw(self), mask, format.param().abi()).ok()
    }
    pub unsafe fn OutputVaListWide<P0>(&self, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputVaListWide)(windows_core::Interface::as_raw(self), mask, format.param().abi(), args).ok()
    }
    pub unsafe fn ControlledOutputWide<P0>(&self, outputcontrol: u32, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputWide)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi()).ok()
    }
    pub unsafe fn ControlledOutputVaListWide<P0>(&self, outputcontrol: u32, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputVaListWide)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi(), args).ok()
    }
    pub unsafe fn OutputPromptWide<P0>(&self, outputcontrol: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptWide)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi()).ok()
    }
    pub unsafe fn OutputPromptVaListWide<P0>(&self, outputcontrol: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptVaListWide)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi(), args).ok()
    }
    pub unsafe fn GetPromptTextWide(&self, buffer: Option<&mut [u16]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPromptTextWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn AssembleWide<P0>(&self, offset: u64, instr: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AssembleWide)(windows_core::Interface::as_raw(self), offset, instr.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisassembleWide(&self, offset: u64, flags: u32, buffer: Option<&mut [u16]>, disassemblysize: Option<*mut u32>, endoffset: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DisassembleWide)(windows_core::Interface::as_raw(self), offset, flags, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(disassemblysize.unwrap_or(std::ptr::null_mut())), endoffset).ok()
    }
    pub unsafe fn GetProcessorTypeNamesWide(&self, r#type: u32, fullnamebuffer: Option<&mut [u16]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u16]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProcessorTypeNamesWide)(
            windows_core::Interface::as_raw(self),
            r#type,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetTextMacroWide(&self, slot: u32, buffer: Option<&mut [u16]>, macrosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTextMacroWide)(windows_core::Interface::as_raw(self), slot, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(macrosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetTextMacroWide<P0>(&self, slot: u32, r#macro: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextMacroWide)(windows_core::Interface::as_raw(self), slot, r#macro.param().abi()).ok()
    }
    pub unsafe fn EvaluateWide<P0>(&self, expression: P0, desiredtype: u32, value: *mut DEBUG_VALUE, remainderindex: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).EvaluateWide)(windows_core::Interface::as_raw(self), expression.param().abi(), desiredtype, value, core::mem::transmute(remainderindex.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ExecuteWide<P0>(&self, outputcontrol: u32, command: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteWide)(windows_core::Interface::as_raw(self), outputcontrol, command.param().abi(), flags).ok()
    }
    pub unsafe fn ExecuteCommandFileWide<P0>(&self, outputcontrol: u32, commandfile: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteCommandFileWide)(windows_core::Interface::as_raw(self), outputcontrol, commandfile.param().abi(), flags).ok()
    }
    pub unsafe fn GetBreakpointByIndex2(&self, index: u32) -> windows_core::Result<IDebugBreakpoint2> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByIndex2)(windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointById2(&self, id: u32) -> windows_core::Result<IDebugBreakpoint2> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointById2)(windows_core::Interface::as_raw(self), id, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn AddBreakpoint2(&self, r#type: u32, desiredid: u32) -> windows_core::Result<IDebugBreakpoint2> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddBreakpoint2)(windows_core::Interface::as_raw(self), r#type, desiredid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RemoveBreakpoint2<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint2>,
    {
        (windows_core::Interface::vtable(self).RemoveBreakpoint2)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn AddExtensionWide<P0>(&self, path: P0, flags: u32) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddExtensionWide)(windows_core::Interface::as_raw(self), path.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetExtensionByPathWide<P0>(&self, path: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExtensionByPathWide)(windows_core::Interface::as_raw(self), path.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn CallExtensionWide<P0, P1>(&self, handle: u64, function: P0, arguments: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CallExtensionWide)(windows_core::Interface::as_raw(self), handle, function.param().abi(), arguments.param().abi()).ok()
    }
    pub unsafe fn GetExtensionFunctionWide<P0>(&self, handle: u64, funcname: P0, function: *mut super::super::super::super::Foundation::FARPROC) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetExtensionFunctionWide)(windows_core::Interface::as_raw(self), handle, funcname.param().abi(), function).ok()
    }
    pub unsafe fn GetEventFilterTextWide(&self, index: u32, buffer: Option<&mut [u16]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterTextWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetEventFilterCommandWide(&self, index: u32, buffer: Option<&mut [u16]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterCommandWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetEventFilterCommandWide<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetEventFilterCommandWide)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetSpecificFilterArgumentWide(&self, index: u32, buffer: Option<&mut [u16]>, argumentsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterArgumentWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(argumentsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetSpecificFilterArgumentWide<P0>(&self, index: u32, argument: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetSpecificFilterArgumentWide)(windows_core::Interface::as_raw(self), index, argument.param().abi()).ok()
    }
    pub unsafe fn GetExceptionFilterSecondCommandWide(&self, index: u32, buffer: Option<&mut [u16]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterSecondCommandWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetExceptionFilterSecondCommandWide<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetExceptionFilterSecondCommandWide)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetLastEventInformationWide(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>, description: Option<&mut [u16]>, descriptionused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLastEventInformationWide)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(descriptionused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetTextReplacementWide<P0>(&self, srctext: P0, index: u32, srcbuffer: Option<&mut [u16]>, srcsize: Option<*mut u32>, dstbuffer: Option<&mut [u16]>, dstsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetTextReplacementWide)(
            windows_core::Interface::as_raw(self),
            srctext.param().abi(),
            index,
            core::mem::transmute(srcbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            srcbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(srcsize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(dstbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            dstbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(dstsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn SetTextReplacementWide<P0, P1>(&self, srctext: P0, dsttext: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextReplacementWide)(windows_core::Interface::as_raw(self), srctext.param().abi(), dsttext.param().abi()).ok()
    }
    pub unsafe fn SetExpressionSyntaxByNameWide<P0>(&self, abbrevname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetExpressionSyntaxByNameWide)(windows_core::Interface::as_raw(self), abbrevname.param().abi()).ok()
    }
    pub unsafe fn GetExpressionSyntaxNamesWide(&self, index: u32, fullnamebuffer: Option<&mut [u16]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u16]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExpressionSyntaxNamesWide)(
            windows_core::Interface::as_raw(self),
            index,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetEventIndexDescriptionWide<P0>(&self, index: u32, which: u32, buffer: P0, buffersize: u32, descsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetEventIndexDescriptionWide)(windows_core::Interface::as_raw(self), index, which, buffer.param().abi(), buffersize, core::mem::transmute(descsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetLogFile2(&self, buffer: Option<&mut [u8]>, filesize: Option<*mut u32>, flags: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile2)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), flags).ok()
    }
    pub unsafe fn OpenLogFile2<P0>(&self, file: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile2)(windows_core::Interface::as_raw(self), file.param().abi(), flags).ok()
    }
    pub unsafe fn GetLogFile2Wide(&self, buffer: Option<&mut [u16]>, filesize: Option<*mut u32>, flags: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile2Wide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), flags).ok()
    }
    pub unsafe fn OpenLogFile2Wide<P0>(&self, file: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile2Wide)(windows_core::Interface::as_raw(self), file.param().abi(), flags).ok()
    }
    pub unsafe fn GetSystemVersionValues(&self, platformid: *mut u32, win32major: *mut u32, win32minor: *mut u32, kdmajor: Option<*mut u32>, kdminor: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersionValues)(windows_core::Interface::as_raw(self), platformid, win32major, win32minor, core::mem::transmute(kdmajor.unwrap_or(std::ptr::null_mut())), core::mem::transmute(kdminor.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemVersionString(&self, which: u32, buffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersionString)(windows_core::Interface::as_raw(self), which, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemVersionStringWide(&self, which: u32, buffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersionStringWide)(windows_core::Interface::as_raw(self), which, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetContextStackTrace(&self, startcontext: Option<*const core::ffi::c_void>, startcontextsize: u32, frames: Option<&mut [DEBUG_STACK_FRAME]>, framecontexts: Option<*mut core::ffi::c_void>, framecontextssize: u32, framecontextsentrysize: u32, framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetContextStackTrace)(windows_core::Interface::as_raw(self), core::mem::transmute(startcontext.unwrap_or(std::ptr::null())), startcontextsize, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(framecontexts.unwrap_or(std::ptr::null_mut())), framecontextssize, framecontextsentrysize, core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputContextStackTrace(&self, outputcontrol: u32, frames: &[DEBUG_STACK_FRAME], framecontexts: *const core::ffi::c_void, framecontextssize: u32, framecontextsentrysize: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputContextStackTrace)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), framecontexts, framecontextssize, framecontextsentrysize, flags).ok()
    }
    pub unsafe fn GetStoredEventInformation(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, context: Option<*mut core::ffi::c_void>, contextsize: u32, contextused: Option<*mut u32>, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStoredEventInformation)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(context.unwrap_or(std::ptr::null_mut())), contextsize, core::mem::transmute(contextused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetManagedStatus(&self, flags: Option<*mut u32>, whichstring: u32, string: Option<&mut [u8]>, stringneeded: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetManagedStatus)(windows_core::Interface::as_raw(self), core::mem::transmute(flags.unwrap_or(std::ptr::null_mut())), whichstring, core::mem::transmute(string.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), string.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringneeded.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetManagedStatusWide(&self, flags: Option<*mut u32>, whichstring: u32, string: Option<&mut [u16]>, stringneeded: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetManagedStatusWide)(windows_core::Interface::as_raw(self), core::mem::transmute(flags.unwrap_or(std::ptr::null_mut())), whichstring, core::mem::transmute(string.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), string.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringneeded.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ResetManagedStatus(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ResetManagedStatus)(windows_core::Interface::as_raw(self), flags).ok()
    }
}
#[repr(C)]
pub struct IDebugControl4_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32, *mut super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OpenLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub CloseLogFile: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Input: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReturnInput: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub Output: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub ControlledOutput: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub ControlledOutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub OutputPrompt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputPromptVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub GetPromptText: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputCurrentState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OutputVersionInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub Assemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub Disassemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PSTR, u32, *mut u32, *mut u64) -> windows_core::HRESULT,
    pub GetDisassembleEffectiveOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassembly: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassemblyLines: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, u32, *mut u32, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNearInstruction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, i32, *mut u64) -> windows_core::HRESULT,
    pub GetStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, *mut DEBUG_STACK_FRAME, u32, *mut u32) -> windows_core::HRESULT,
    pub GetReturnOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME, u32, u32) -> windows_core::HRESULT,
    pub GetDebuggeeType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetActualProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExecutingProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNumberProcessors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetPageSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub IsPointer64Bit: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ReadBugCheckData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u64, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNumberSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetProcessorTypeNames: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Evaluate: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut DEBUG_VALUE, *mut u32) -> windows_core::HRESULT,
    pub CoerceValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const DEBUG_VALUE, u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub CoerceValues: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_VALUE, *const u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ExecuteCommandFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub GetNumberBreakpoints: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetBreakpointByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointById: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
    pub AddBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddExtension: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut u64) -> windows_core::HRESULT,
    pub RemoveExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetExtensionByPath: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub CallExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExtensionFunction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut super::super::super::super::Foundation::FARPROC) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis32: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis32: usize,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis64: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis64: usize,
    pub GetNumberEventFilters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterText: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *const DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WaitForEvent: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetLastEventInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentTimeDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentSystemUpTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFormatFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTextReplacement: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextReplacement: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub RemoveTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OutputTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExpressionSyntax: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetExpressionSyntax: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetExpressionSyntaxByName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetNumberExpressionSyntaxes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExpressionSyntaxNames: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNumberEvents: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetEventIndexDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentEventIndex: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetNextEventIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetLogFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32, *mut super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OpenLogFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub InputWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReturnInputWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputVaListWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const i8) -> windows_core::HRESULT,
    pub ControlledOutputWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub ControlledOutputVaListWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR, *const i8) -> windows_core::HRESULT,
    pub OutputPromptWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputPromptVaListWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const i8) -> windows_core::HRESULT,
    pub GetPromptTextWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AssembleWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub DisassembleWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PWSTR, u32, *mut u32, *mut u64) -> windows_core::HRESULT,
    pub GetProcessorTypeNamesWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetTextMacroWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextMacroWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub EvaluateWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, *mut DEBUG_VALUE, *mut u32) -> windows_core::HRESULT,
    pub ExecuteWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub ExecuteCommandFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetBreakpointByIndex2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointById2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddBreakpoint2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveBreakpoint2: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddExtensionWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, *mut u64) -> windows_core::HRESULT,
    pub GetExtensionByPathWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub CallExtensionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetExtensionFunctionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *mut super::super::super::super::Foundation::FARPROC) -> windows_core::HRESULT,
    pub GetEventFilterTextWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetEventFilterCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetSpecificFilterArgumentWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetSpecificFilterArgumentWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetExceptionFilterSecondCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetExceptionFilterSecondCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetLastEventInformationWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetTextReplacementWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextReplacementWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetExpressionSyntaxByNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetExpressionSyntaxNamesWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventIndexDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetLogFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub OpenLogFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub GetLogFile2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub OpenLogFile2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetSystemVersionValues: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersionString: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersionStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetContextStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32, *mut DEBUG_STACK_FRAME, u32, *mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputContextStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME, u32, *const core::ffi::c_void, u32, u32, u32) -> windows_core::HRESULT,
    pub GetStoredEventInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetManagedStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetManagedStatusWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ResetManagedStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugControl5, IDebugControl5_Vtbl, 0xb2ffe162_2412_429f_8d1d_5bf6dd824696);
impl std::ops::Deref for IDebugControl5 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugControl5, windows_core::IUnknown);
impl IDebugControl5 {
    pub unsafe fn GetInterrupt(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetInterrupt)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetInterrupt(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterrupt)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetInterruptTimeout(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInterruptTimeout)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetInterruptTimeout(&self, seconds: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterruptTimeout)(windows_core::Interface::as_raw(self), seconds).ok()
    }
    pub unsafe fn GetLogFile(&self, buffer: Option<&mut [u8]>, filesize: Option<*mut u32>, append: *mut super::super::super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), append).ok()
    }
    pub unsafe fn OpenLogFile<P0, P1>(&self, file: P0, append: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<super::super::super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile)(windows_core::Interface::as_raw(self), file.param().abi(), append.param().abi()).ok()
    }
    pub unsafe fn CloseLogFile(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CloseLogFile)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetLogMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetLogMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetLogMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetLogMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn Input(&self, buffer: &mut [u8], inputsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Input)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_ptr()), buffer.len().try_into().unwrap(), core::mem::transmute(inputsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReturnInput<P0>(&self, buffer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ReturnInput)(windows_core::Interface::as_raw(self), buffer.param().abi()).ok()
    }
    pub unsafe fn Output<P0>(&self, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Output)(windows_core::Interface::as_raw(self), mask, format.param().abi()).ok()
    }
    pub unsafe fn OutputVaList<P0>(&self, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputVaList)(windows_core::Interface::as_raw(self), mask, format.param().abi(), args).ok()
    }
    pub unsafe fn ControlledOutput<P0>(&self, outputcontrol: u32, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutput)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi()).ok()
    }
    pub unsafe fn ControlledOutputVaList<P0>(&self, outputcontrol: u32, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputVaList)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi(), args).ok()
    }
    pub unsafe fn OutputPrompt<P0>(&self, outputcontrol: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPrompt)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi()).ok()
    }
    pub unsafe fn OutputPromptVaList<P0>(&self, outputcontrol: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptVaList)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi(), args).ok()
    }
    pub unsafe fn GetPromptText(&self, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPromptText)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputCurrentState(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputCurrentState)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn OutputVersionInformation(&self, outputcontrol: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputVersionInformation)(windows_core::Interface::as_raw(self), outputcontrol).ok()
    }
    pub unsafe fn GetNotifyEventHandle(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNotifyEventHandle)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetNotifyEventHandle(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetNotifyEventHandle)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn Assemble<P0>(&self, offset: u64, instr: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).Assemble)(windows_core::Interface::as_raw(self), offset, instr.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn Disassemble(&self, offset: u64, flags: u32, buffer: Option<&mut [u8]>, disassemblysize: Option<*mut u32>, endoffset: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Disassemble)(windows_core::Interface::as_raw(self), offset, flags, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(disassemblysize.unwrap_or(std::ptr::null_mut())), endoffset).ok()
    }
    pub unsafe fn GetDisassembleEffectiveOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDisassembleEffectiveOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassembly(&self, outputcontrol: u32, offset: u64, flags: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).OutputDisassembly)(windows_core::Interface::as_raw(self), outputcontrol, offset, flags, &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassemblyLines(&self, outputcontrol: u32, previouslines: u32, offset: u64, flags: u32, offsetline: Option<*mut u32>, startoffset: Option<*mut u64>, endoffset: Option<*mut u64>, lineoffsets: Option<&mut [u64]>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputDisassemblyLines)(windows_core::Interface::as_raw(self), outputcontrol, previouslines, lineoffsets.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), offset, flags, core::mem::transmute(offsetline.unwrap_or(std::ptr::null_mut())), core::mem::transmute(startoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(endoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(lineoffsets.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))).ok()
    }
    pub unsafe fn GetNearInstruction(&self, offset: u64, delta: i32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNearInstruction)(windows_core::Interface::as_raw(self), offset, delta, &mut result__).map(|| result__)
    }
    pub unsafe fn GetStackTrace(&self, frameoffset: u64, stackoffset: u64, instructionoffset: u64, frames: &mut [DEBUG_STACK_FRAME], framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStackTrace)(windows_core::Interface::as_raw(self), frameoffset, stackoffset, instructionoffset, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetReturnOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetReturnOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputStackTrace(&self, outputcontrol: u32, frames: Option<&[DEBUG_STACK_FRAME]>, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputStackTrace)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), flags).ok()
    }
    pub unsafe fn GetDebuggeeType(&self, class: *mut u32, qualifier: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDebuggeeType)(windows_core::Interface::as_raw(self), class, qualifier).ok()
    }
    pub unsafe fn GetActualProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetActualProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetExecutingProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutingProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberPossibleExecutingProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetPossibleExecutingProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetNumberProcessors(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberProcessors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSystemVersion(&self, platformid: *mut u32, major: *mut u32, minor: *mut u32, servicepackstring: Option<&mut [u8]>, servicepackstringused: Option<*mut u32>, servicepacknumber: *mut u32, buildstring: Option<&mut [u8]>, buildstringused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersion)(
            windows_core::Interface::as_raw(self),
            platformid,
            major,
            minor,
            core::mem::transmute(servicepackstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            servicepackstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(servicepackstringused.unwrap_or(std::ptr::null_mut())),
            servicepacknumber,
            core::mem::transmute(buildstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            buildstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(buildstringused.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetPageSize(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPageSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsPointer64Bit(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsPointer64Bit)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReadBugCheckData(&self, code: *mut u32, arg1: *mut u64, arg2: *mut u64, arg3: *mut u64, arg4: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadBugCheckData)(windows_core::Interface::as_raw(self), code, arg1, arg2, arg3, arg4).ok()
    }
    pub unsafe fn GetNumberSupportedProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberSupportedProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSupportedProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSupportedProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetProcessorTypeNames(&self, r#type: u32, fullnamebuffer: Option<&mut [u8]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u8]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProcessorTypeNames)(
            windows_core::Interface::as_raw(self),
            r#type,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetEffectiveProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEffectiveProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetEffectiveProcessorType(&self, r#type: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEffectiveProcessorType)(windows_core::Interface::as_raw(self), r#type).ok()
    }
    pub unsafe fn GetExecutionStatus(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutionStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExecutionStatus(&self, status: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExecutionStatus)(windows_core::Interface::as_raw(self), status).ok()
    }
    pub unsafe fn GetCodeLevel(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCodeLevel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCodeLevel(&self, level: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCodeLevel)(windows_core::Interface::as_raw(self), level).ok()
    }
    pub unsafe fn GetEngineOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEngineOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn GetSystemErrorControl(&self, outputlevel: *mut u32, breaklevel: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn SetSystemErrorControl(&self, outputlevel: u32, breaklevel: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn GetTextMacro(&self, slot: u32, buffer: Option<&mut [u8]>, macrosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTextMacro)(windows_core::Interface::as_raw(self), slot, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(macrosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetTextMacro<P0>(&self, slot: u32, r#macro: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextMacro)(windows_core::Interface::as_raw(self), slot, r#macro.param().abi()).ok()
    }
    pub unsafe fn GetRadix(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRadix)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRadix(&self, radix: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetRadix)(windows_core::Interface::as_raw(self), radix).ok()
    }
    pub unsafe fn Evaluate<P0>(&self, expression: P0, desiredtype: u32, value: *mut DEBUG_VALUE, remainderindex: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Evaluate)(windows_core::Interface::as_raw(self), expression.param().abi(), desiredtype, value, core::mem::transmute(remainderindex.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CoerceValue(&self, r#in: *const DEBUG_VALUE, outtype: u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValue)(windows_core::Interface::as_raw(self), r#in, outtype, out).ok()
    }
    pub unsafe fn CoerceValues(&self, count: u32, r#in: *const DEBUG_VALUE, outtypes: *const u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValues)(windows_core::Interface::as_raw(self), count, r#in, outtypes, out).ok()
    }
    pub unsafe fn Execute<P0>(&self, outputcontrol: u32, command: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), outputcontrol, command.param().abi(), flags).ok()
    }
    pub unsafe fn ExecuteCommandFile<P0>(&self, outputcontrol: u32, commandfile: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteCommandFile)(windows_core::Interface::as_raw(self), outputcontrol, commandfile.param().abi(), flags).ok()
    }
    pub unsafe fn GetNumberBreakpoints(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberBreakpoints)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetBreakpointByIndex(&self, index: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByIndex)(windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointById(&self, id: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointById)(windows_core::Interface::as_raw(self), id, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointParameters(&self, count: u32, ids: Option<*const u32>, start: u32, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetBreakpointParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(ids.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn AddBreakpoint(&self, r#type: u32, desiredid: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddBreakpoint)(windows_core::Interface::as_raw(self), r#type, desiredid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RemoveBreakpoint<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint>,
    {
        (windows_core::Interface::vtable(self).RemoveBreakpoint)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn AddExtension<P0>(&self, path: P0, flags: u32) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddExtension)(windows_core::Interface::as_raw(self), path.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn RemoveExtension(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveExtension)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetExtensionByPath<P0>(&self, path: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExtensionByPath)(windows_core::Interface::as_raw(self), path.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn CallExtension<P0, P1>(&self, handle: u64, function: P0, arguments: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CallExtension)(windows_core::Interface::as_raw(self), handle, function.param().abi(), arguments.param().abi()).ok()
    }
    pub unsafe fn GetExtensionFunction<P0>(&self, handle: u64, funcname: P0, function: *mut super::super::super::super::Foundation::FARPROC) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetExtensionFunction)(windows_core::Interface::as_raw(self), handle, funcname.param().abi(), function).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis32(&self, api: *mut WINDBG_EXTENSION_APIS32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis32)(windows_core::Interface::as_raw(self), api).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis64(&self, api: *mut WINDBG_EXTENSION_APIS64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis64)(windows_core::Interface::as_raw(self), api).ok()
    }
    pub unsafe fn GetNumberEventFilters(&self, specificevents: *mut u32, specificexceptions: *mut u32, arbitraryexceptions: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetNumberEventFilters)(windows_core::Interface::as_raw(self), specificevents, specificexceptions, arbitraryexceptions).ok()
    }
    pub unsafe fn GetEventFilterText(&self, index: u32, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterText)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetEventFilterCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetEventFilterCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetEventFilterCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetSpecificFilterParameters(&self, start: u32, params: &mut [DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn SetSpecificFilterParameters(&self, start: u32, params: &[DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetSpecificFilterArgument(&self, index: u32, buffer: Option<&mut [u8]>, argumentsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(argumentsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetSpecificFilterArgument<P0>(&self, index: u32, argument: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, argument.param().abi()).ok()
    }
    pub unsafe fn GetExceptionFilterParameters(&self, count: u32, codes: Option<*const u32>, start: u32, params: *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(codes.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn SetExceptionFilterParameters(&self, params: &[DEBUG_EXCEPTION_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExceptionFilterParameters)(windows_core::Interface::as_raw(self), params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetExceptionFilterSecondCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetExceptionFilterSecondCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn WaitForEvent(&self, flags: u32, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForEvent)(windows_core::Interface::as_raw(self), flags, timeout).ok()
    }
    pub unsafe fn GetLastEventInformation(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>, description: Option<&mut [u8]>, descriptionused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLastEventInformation)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(descriptionused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetCurrentTimeDate(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentTimeDate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentSystemUpTime(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentSystemUpTime)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDumpFormatFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDumpFormatFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberTextReplacements(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberTextReplacements)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetTextReplacement<P0>(&self, srctext: P0, index: u32, srcbuffer: Option<&mut [u8]>, srcsize: Option<*mut u32>, dstbuffer: Option<&mut [u8]>, dstsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetTextReplacement)(
            windows_core::Interface::as_raw(self),
            srctext.param().abi(),
            index,
            core::mem::transmute(srcbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            srcbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(srcsize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(dstbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            dstbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(dstsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn SetTextReplacement<P0, P1>(&self, srctext: P0, dsttext: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextReplacement)(windows_core::Interface::as_raw(self), srctext.param().abi(), dsttext.param().abi()).ok()
    }
    pub unsafe fn RemoveTextReplacements(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveTextReplacements)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn OutputTextReplacements(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputTextReplacements)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn GetAssemblyOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAssemblyOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn GetExpressionSyntax(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExpressionSyntax)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExpressionSyntax(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExpressionSyntax)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetExpressionSyntaxByName<P0>(&self, abbrevname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetExpressionSyntaxByName)(windows_core::Interface::as_raw(self), abbrevname.param().abi()).ok()
    }
    pub unsafe fn GetNumberExpressionSyntaxes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberExpressionSyntaxes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetExpressionSyntaxNames(&self, index: u32, fullnamebuffer: Option<&mut [u8]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u8]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExpressionSyntaxNames)(
            windows_core::Interface::as_raw(self),
            index,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetNumberEvents(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberEvents)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetEventIndexDescription<P0>(&self, index: u32, which: u32, buffer: P0, buffersize: u32, descsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetEventIndexDescription)(windows_core::Interface::as_raw(self), index, which, buffer.param().abi(), buffersize, core::mem::transmute(descsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetCurrentEventIndex(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentEventIndex)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetNextEventIndex(&self, relation: u32, value: u32) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).SetNextEventIndex)(windows_core::Interface::as_raw(self), relation, value, &mut result__).map(|| result__)
    }
    pub unsafe fn GetLogFileWide(&self, buffer: Option<&mut [u16]>, filesize: Option<*mut u32>, append: *mut super::super::super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFileWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), append).ok()
    }
    pub unsafe fn OpenLogFileWide<P0, P1>(&self, file: P0, append: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<super::super::super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OpenLogFileWide)(windows_core::Interface::as_raw(self), file.param().abi(), append.param().abi()).ok()
    }
    pub unsafe fn InputWide(&self, buffer: &mut [u16], inputsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).InputWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_ptr()), buffer.len().try_into().unwrap(), core::mem::transmute(inputsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReturnInputWide<P0>(&self, buffer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ReturnInputWide)(windows_core::Interface::as_raw(self), buffer.param().abi()).ok()
    }
    pub unsafe fn OutputWide<P0>(&self, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputWide)(windows_core::Interface::as_raw(self), mask, format.param().abi()).ok()
    }
    pub unsafe fn OutputVaListWide<P0>(&self, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputVaListWide)(windows_core::Interface::as_raw(self), mask, format.param().abi(), args).ok()
    }
    pub unsafe fn ControlledOutputWide<P0>(&self, outputcontrol: u32, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputWide)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi()).ok()
    }
    pub unsafe fn ControlledOutputVaListWide<P0>(&self, outputcontrol: u32, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputVaListWide)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi(), args).ok()
    }
    pub unsafe fn OutputPromptWide<P0>(&self, outputcontrol: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptWide)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi()).ok()
    }
    pub unsafe fn OutputPromptVaListWide<P0>(&self, outputcontrol: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptVaListWide)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi(), args).ok()
    }
    pub unsafe fn GetPromptTextWide(&self, buffer: Option<&mut [u16]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPromptTextWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn AssembleWide<P0>(&self, offset: u64, instr: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AssembleWide)(windows_core::Interface::as_raw(self), offset, instr.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisassembleWide(&self, offset: u64, flags: u32, buffer: Option<&mut [u16]>, disassemblysize: Option<*mut u32>, endoffset: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DisassembleWide)(windows_core::Interface::as_raw(self), offset, flags, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(disassemblysize.unwrap_or(std::ptr::null_mut())), endoffset).ok()
    }
    pub unsafe fn GetProcessorTypeNamesWide(&self, r#type: u32, fullnamebuffer: Option<&mut [u16]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u16]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProcessorTypeNamesWide)(
            windows_core::Interface::as_raw(self),
            r#type,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetTextMacroWide(&self, slot: u32, buffer: Option<&mut [u16]>, macrosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTextMacroWide)(windows_core::Interface::as_raw(self), slot, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(macrosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetTextMacroWide<P0>(&self, slot: u32, r#macro: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextMacroWide)(windows_core::Interface::as_raw(self), slot, r#macro.param().abi()).ok()
    }
    pub unsafe fn EvaluateWide<P0>(&self, expression: P0, desiredtype: u32, value: *mut DEBUG_VALUE, remainderindex: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).EvaluateWide)(windows_core::Interface::as_raw(self), expression.param().abi(), desiredtype, value, core::mem::transmute(remainderindex.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ExecuteWide<P0>(&self, outputcontrol: u32, command: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteWide)(windows_core::Interface::as_raw(self), outputcontrol, command.param().abi(), flags).ok()
    }
    pub unsafe fn ExecuteCommandFileWide<P0>(&self, outputcontrol: u32, commandfile: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteCommandFileWide)(windows_core::Interface::as_raw(self), outputcontrol, commandfile.param().abi(), flags).ok()
    }
    pub unsafe fn GetBreakpointByIndex2(&self, index: u32) -> windows_core::Result<IDebugBreakpoint2> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByIndex2)(windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointById2(&self, id: u32) -> windows_core::Result<IDebugBreakpoint2> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointById2)(windows_core::Interface::as_raw(self), id, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn AddBreakpoint2(&self, r#type: u32, desiredid: u32) -> windows_core::Result<IDebugBreakpoint2> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddBreakpoint2)(windows_core::Interface::as_raw(self), r#type, desiredid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RemoveBreakpoint2<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint2>,
    {
        (windows_core::Interface::vtable(self).RemoveBreakpoint2)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn AddExtensionWide<P0>(&self, path: P0, flags: u32) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddExtensionWide)(windows_core::Interface::as_raw(self), path.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetExtensionByPathWide<P0>(&self, path: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExtensionByPathWide)(windows_core::Interface::as_raw(self), path.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn CallExtensionWide<P0, P1>(&self, handle: u64, function: P0, arguments: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CallExtensionWide)(windows_core::Interface::as_raw(self), handle, function.param().abi(), arguments.param().abi()).ok()
    }
    pub unsafe fn GetExtensionFunctionWide<P0>(&self, handle: u64, funcname: P0, function: *mut super::super::super::super::Foundation::FARPROC) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetExtensionFunctionWide)(windows_core::Interface::as_raw(self), handle, funcname.param().abi(), function).ok()
    }
    pub unsafe fn GetEventFilterTextWide(&self, index: u32, buffer: Option<&mut [u16]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterTextWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetEventFilterCommandWide(&self, index: u32, buffer: Option<&mut [u16]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterCommandWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetEventFilterCommandWide<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetEventFilterCommandWide)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetSpecificFilterArgumentWide(&self, index: u32, buffer: Option<&mut [u16]>, argumentsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterArgumentWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(argumentsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetSpecificFilterArgumentWide<P0>(&self, index: u32, argument: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetSpecificFilterArgumentWide)(windows_core::Interface::as_raw(self), index, argument.param().abi()).ok()
    }
    pub unsafe fn GetExceptionFilterSecondCommandWide(&self, index: u32, buffer: Option<&mut [u16]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterSecondCommandWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetExceptionFilterSecondCommandWide<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetExceptionFilterSecondCommandWide)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetLastEventInformationWide(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>, description: Option<&mut [u16]>, descriptionused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLastEventInformationWide)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(descriptionused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetTextReplacementWide<P0>(&self, srctext: P0, index: u32, srcbuffer: Option<&mut [u16]>, srcsize: Option<*mut u32>, dstbuffer: Option<&mut [u16]>, dstsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetTextReplacementWide)(
            windows_core::Interface::as_raw(self),
            srctext.param().abi(),
            index,
            core::mem::transmute(srcbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            srcbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(srcsize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(dstbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            dstbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(dstsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn SetTextReplacementWide<P0, P1>(&self, srctext: P0, dsttext: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextReplacementWide)(windows_core::Interface::as_raw(self), srctext.param().abi(), dsttext.param().abi()).ok()
    }
    pub unsafe fn SetExpressionSyntaxByNameWide<P0>(&self, abbrevname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetExpressionSyntaxByNameWide)(windows_core::Interface::as_raw(self), abbrevname.param().abi()).ok()
    }
    pub unsafe fn GetExpressionSyntaxNamesWide(&self, index: u32, fullnamebuffer: Option<&mut [u16]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u16]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExpressionSyntaxNamesWide)(
            windows_core::Interface::as_raw(self),
            index,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetEventIndexDescriptionWide<P0>(&self, index: u32, which: u32, buffer: P0, buffersize: u32, descsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetEventIndexDescriptionWide)(windows_core::Interface::as_raw(self), index, which, buffer.param().abi(), buffersize, core::mem::transmute(descsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetLogFile2(&self, buffer: Option<&mut [u8]>, filesize: Option<*mut u32>, flags: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile2)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), flags).ok()
    }
    pub unsafe fn OpenLogFile2<P0>(&self, file: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile2)(windows_core::Interface::as_raw(self), file.param().abi(), flags).ok()
    }
    pub unsafe fn GetLogFile2Wide(&self, buffer: Option<&mut [u16]>, filesize: Option<*mut u32>, flags: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile2Wide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), flags).ok()
    }
    pub unsafe fn OpenLogFile2Wide<P0>(&self, file: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile2Wide)(windows_core::Interface::as_raw(self), file.param().abi(), flags).ok()
    }
    pub unsafe fn GetSystemVersionValues(&self, platformid: *mut u32, win32major: *mut u32, win32minor: *mut u32, kdmajor: Option<*mut u32>, kdminor: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersionValues)(windows_core::Interface::as_raw(self), platformid, win32major, win32minor, core::mem::transmute(kdmajor.unwrap_or(std::ptr::null_mut())), core::mem::transmute(kdminor.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemVersionString(&self, which: u32, buffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersionString)(windows_core::Interface::as_raw(self), which, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemVersionStringWide(&self, which: u32, buffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersionStringWide)(windows_core::Interface::as_raw(self), which, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetContextStackTrace(&self, startcontext: Option<*const core::ffi::c_void>, startcontextsize: u32, frames: Option<&mut [DEBUG_STACK_FRAME]>, framecontexts: Option<*mut core::ffi::c_void>, framecontextssize: u32, framecontextsentrysize: u32, framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetContextStackTrace)(windows_core::Interface::as_raw(self), core::mem::transmute(startcontext.unwrap_or(std::ptr::null())), startcontextsize, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(framecontexts.unwrap_or(std::ptr::null_mut())), framecontextssize, framecontextsentrysize, core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputContextStackTrace(&self, outputcontrol: u32, frames: &[DEBUG_STACK_FRAME], framecontexts: *const core::ffi::c_void, framecontextssize: u32, framecontextsentrysize: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputContextStackTrace)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), framecontexts, framecontextssize, framecontextsentrysize, flags).ok()
    }
    pub unsafe fn GetStoredEventInformation(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, context: Option<*mut core::ffi::c_void>, contextsize: u32, contextused: Option<*mut u32>, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStoredEventInformation)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(context.unwrap_or(std::ptr::null_mut())), contextsize, core::mem::transmute(contextused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetManagedStatus(&self, flags: Option<*mut u32>, whichstring: u32, string: Option<&mut [u8]>, stringneeded: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetManagedStatus)(windows_core::Interface::as_raw(self), core::mem::transmute(flags.unwrap_or(std::ptr::null_mut())), whichstring, core::mem::transmute(string.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), string.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringneeded.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetManagedStatusWide(&self, flags: Option<*mut u32>, whichstring: u32, string: Option<&mut [u16]>, stringneeded: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetManagedStatusWide)(windows_core::Interface::as_raw(self), core::mem::transmute(flags.unwrap_or(std::ptr::null_mut())), whichstring, core::mem::transmute(string.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), string.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringneeded.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ResetManagedStatus(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ResetManagedStatus)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetStackTraceEx(&self, frameoffset: u64, stackoffset: u64, instructionoffset: u64, frames: &mut [DEBUG_STACK_FRAME_EX], framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStackTraceEx)(windows_core::Interface::as_raw(self), frameoffset, stackoffset, instructionoffset, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputStackTraceEx(&self, outputcontrol: u32, frames: Option<&[DEBUG_STACK_FRAME_EX]>, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputStackTraceEx)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), flags).ok()
    }
    pub unsafe fn GetContextStackTraceEx(&self, startcontext: Option<*const core::ffi::c_void>, startcontextsize: u32, frames: Option<&mut [DEBUG_STACK_FRAME_EX]>, framecontexts: Option<*mut core::ffi::c_void>, framecontextssize: u32, framecontextsentrysize: u32, framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetContextStackTraceEx)(windows_core::Interface::as_raw(self), core::mem::transmute(startcontext.unwrap_or(std::ptr::null())), startcontextsize, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(framecontexts.unwrap_or(std::ptr::null_mut())), framecontextssize, framecontextsentrysize, core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputContextStackTraceEx(&self, outputcontrol: u32, frames: &[DEBUG_STACK_FRAME_EX], framecontexts: *const core::ffi::c_void, framecontextssize: u32, framecontextsentrysize: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputContextStackTraceEx)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), framecontexts, framecontextssize, framecontextsentrysize, flags).ok()
    }
    pub unsafe fn GetBreakpointByGuid(&self, guid: *const windows_core::GUID) -> windows_core::Result<IDebugBreakpoint3> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByGuid)(windows_core::Interface::as_raw(self), guid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDebugControl5_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32, *mut super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OpenLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub CloseLogFile: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Input: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReturnInput: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub Output: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub ControlledOutput: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub ControlledOutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub OutputPrompt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputPromptVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub GetPromptText: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputCurrentState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OutputVersionInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub Assemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub Disassemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PSTR, u32, *mut u32, *mut u64) -> windows_core::HRESULT,
    pub GetDisassembleEffectiveOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassembly: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassemblyLines: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, u32, *mut u32, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNearInstruction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, i32, *mut u64) -> windows_core::HRESULT,
    pub GetStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, *mut DEBUG_STACK_FRAME, u32, *mut u32) -> windows_core::HRESULT,
    pub GetReturnOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME, u32, u32) -> windows_core::HRESULT,
    pub GetDebuggeeType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetActualProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExecutingProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNumberProcessors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetPageSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub IsPointer64Bit: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ReadBugCheckData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u64, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNumberSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetProcessorTypeNames: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Evaluate: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut DEBUG_VALUE, *mut u32) -> windows_core::HRESULT,
    pub CoerceValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const DEBUG_VALUE, u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub CoerceValues: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_VALUE, *const u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ExecuteCommandFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub GetNumberBreakpoints: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetBreakpointByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointById: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
    pub AddBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddExtension: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut u64) -> windows_core::HRESULT,
    pub RemoveExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetExtensionByPath: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub CallExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExtensionFunction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut super::super::super::super::Foundation::FARPROC) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis32: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis32: usize,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis64: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis64: usize,
    pub GetNumberEventFilters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterText: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *const DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WaitForEvent: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetLastEventInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentTimeDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentSystemUpTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFormatFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTextReplacement: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextReplacement: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub RemoveTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OutputTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExpressionSyntax: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetExpressionSyntax: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetExpressionSyntaxByName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetNumberExpressionSyntaxes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExpressionSyntaxNames: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNumberEvents: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetEventIndexDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentEventIndex: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetNextEventIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetLogFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32, *mut super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OpenLogFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub InputWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReturnInputWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputVaListWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const i8) -> windows_core::HRESULT,
    pub ControlledOutputWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub ControlledOutputVaListWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR, *const i8) -> windows_core::HRESULT,
    pub OutputPromptWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputPromptVaListWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const i8) -> windows_core::HRESULT,
    pub GetPromptTextWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AssembleWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub DisassembleWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PWSTR, u32, *mut u32, *mut u64) -> windows_core::HRESULT,
    pub GetProcessorTypeNamesWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetTextMacroWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextMacroWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub EvaluateWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, *mut DEBUG_VALUE, *mut u32) -> windows_core::HRESULT,
    pub ExecuteWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub ExecuteCommandFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetBreakpointByIndex2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointById2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddBreakpoint2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveBreakpoint2: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddExtensionWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, *mut u64) -> windows_core::HRESULT,
    pub GetExtensionByPathWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub CallExtensionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetExtensionFunctionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *mut super::super::super::super::Foundation::FARPROC) -> windows_core::HRESULT,
    pub GetEventFilterTextWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetEventFilterCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetSpecificFilterArgumentWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetSpecificFilterArgumentWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetExceptionFilterSecondCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetExceptionFilterSecondCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetLastEventInformationWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetTextReplacementWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextReplacementWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetExpressionSyntaxByNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetExpressionSyntaxNamesWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventIndexDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetLogFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub OpenLogFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub GetLogFile2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub OpenLogFile2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetSystemVersionValues: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersionString: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersionStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetContextStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32, *mut DEBUG_STACK_FRAME, u32, *mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputContextStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME, u32, *const core::ffi::c_void, u32, u32, u32) -> windows_core::HRESULT,
    pub GetStoredEventInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetManagedStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetManagedStatusWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ResetManagedStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetStackTraceEx: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, *mut DEBUG_STACK_FRAME_EX, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputStackTraceEx: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME_EX, u32, u32) -> windows_core::HRESULT,
    pub GetContextStackTraceEx: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32, *mut DEBUG_STACK_FRAME_EX, u32, *mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputContextStackTraceEx: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME_EX, u32, *const core::ffi::c_void, u32, u32, u32) -> windows_core::HRESULT,
    pub GetBreakpointByGuid: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugControl6, IDebugControl6_Vtbl, 0xbc0d583f_126d_43a1_9cc4_a860ab1d537b);
impl std::ops::Deref for IDebugControl6 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugControl6, windows_core::IUnknown);
impl IDebugControl6 {
    pub unsafe fn GetInterrupt(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetInterrupt)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetInterrupt(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterrupt)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetInterruptTimeout(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInterruptTimeout)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetInterruptTimeout(&self, seconds: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterruptTimeout)(windows_core::Interface::as_raw(self), seconds).ok()
    }
    pub unsafe fn GetLogFile(&self, buffer: Option<&mut [u8]>, filesize: Option<*mut u32>, append: *mut super::super::super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), append).ok()
    }
    pub unsafe fn OpenLogFile<P0, P1>(&self, file: P0, append: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<super::super::super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile)(windows_core::Interface::as_raw(self), file.param().abi(), append.param().abi()).ok()
    }
    pub unsafe fn CloseLogFile(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CloseLogFile)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetLogMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetLogMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetLogMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetLogMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn Input(&self, buffer: &mut [u8], inputsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Input)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_ptr()), buffer.len().try_into().unwrap(), core::mem::transmute(inputsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReturnInput<P0>(&self, buffer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ReturnInput)(windows_core::Interface::as_raw(self), buffer.param().abi()).ok()
    }
    pub unsafe fn Output<P0>(&self, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Output)(windows_core::Interface::as_raw(self), mask, format.param().abi()).ok()
    }
    pub unsafe fn OutputVaList<P0>(&self, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputVaList)(windows_core::Interface::as_raw(self), mask, format.param().abi(), args).ok()
    }
    pub unsafe fn ControlledOutput<P0>(&self, outputcontrol: u32, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutput)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi()).ok()
    }
    pub unsafe fn ControlledOutputVaList<P0>(&self, outputcontrol: u32, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputVaList)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi(), args).ok()
    }
    pub unsafe fn OutputPrompt<P0>(&self, outputcontrol: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPrompt)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi()).ok()
    }
    pub unsafe fn OutputPromptVaList<P0>(&self, outputcontrol: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptVaList)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi(), args).ok()
    }
    pub unsafe fn GetPromptText(&self, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPromptText)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputCurrentState(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputCurrentState)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn OutputVersionInformation(&self, outputcontrol: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputVersionInformation)(windows_core::Interface::as_raw(self), outputcontrol).ok()
    }
    pub unsafe fn GetNotifyEventHandle(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNotifyEventHandle)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetNotifyEventHandle(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetNotifyEventHandle)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn Assemble<P0>(&self, offset: u64, instr: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).Assemble)(windows_core::Interface::as_raw(self), offset, instr.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn Disassemble(&self, offset: u64, flags: u32, buffer: Option<&mut [u8]>, disassemblysize: Option<*mut u32>, endoffset: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Disassemble)(windows_core::Interface::as_raw(self), offset, flags, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(disassemblysize.unwrap_or(std::ptr::null_mut())), endoffset).ok()
    }
    pub unsafe fn GetDisassembleEffectiveOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDisassembleEffectiveOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassembly(&self, outputcontrol: u32, offset: u64, flags: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).OutputDisassembly)(windows_core::Interface::as_raw(self), outputcontrol, offset, flags, &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassemblyLines(&self, outputcontrol: u32, previouslines: u32, offset: u64, flags: u32, offsetline: Option<*mut u32>, startoffset: Option<*mut u64>, endoffset: Option<*mut u64>, lineoffsets: Option<&mut [u64]>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputDisassemblyLines)(windows_core::Interface::as_raw(self), outputcontrol, previouslines, lineoffsets.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), offset, flags, core::mem::transmute(offsetline.unwrap_or(std::ptr::null_mut())), core::mem::transmute(startoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(endoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(lineoffsets.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))).ok()
    }
    pub unsafe fn GetNearInstruction(&self, offset: u64, delta: i32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNearInstruction)(windows_core::Interface::as_raw(self), offset, delta, &mut result__).map(|| result__)
    }
    pub unsafe fn GetStackTrace(&self, frameoffset: u64, stackoffset: u64, instructionoffset: u64, frames: &mut [DEBUG_STACK_FRAME], framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStackTrace)(windows_core::Interface::as_raw(self), frameoffset, stackoffset, instructionoffset, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetReturnOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetReturnOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputStackTrace(&self, outputcontrol: u32, frames: Option<&[DEBUG_STACK_FRAME]>, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputStackTrace)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), flags).ok()
    }
    pub unsafe fn GetDebuggeeType(&self, class: *mut u32, qualifier: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDebuggeeType)(windows_core::Interface::as_raw(self), class, qualifier).ok()
    }
    pub unsafe fn GetActualProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetActualProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetExecutingProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutingProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberPossibleExecutingProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetPossibleExecutingProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetNumberProcessors(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberProcessors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSystemVersion(&self, platformid: *mut u32, major: *mut u32, minor: *mut u32, servicepackstring: Option<&mut [u8]>, servicepackstringused: Option<*mut u32>, servicepacknumber: *mut u32, buildstring: Option<&mut [u8]>, buildstringused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersion)(
            windows_core::Interface::as_raw(self),
            platformid,
            major,
            minor,
            core::mem::transmute(servicepackstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            servicepackstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(servicepackstringused.unwrap_or(std::ptr::null_mut())),
            servicepacknumber,
            core::mem::transmute(buildstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            buildstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(buildstringused.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetPageSize(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPageSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsPointer64Bit(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsPointer64Bit)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReadBugCheckData(&self, code: *mut u32, arg1: *mut u64, arg2: *mut u64, arg3: *mut u64, arg4: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadBugCheckData)(windows_core::Interface::as_raw(self), code, arg1, arg2, arg3, arg4).ok()
    }
    pub unsafe fn GetNumberSupportedProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberSupportedProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSupportedProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSupportedProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetProcessorTypeNames(&self, r#type: u32, fullnamebuffer: Option<&mut [u8]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u8]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProcessorTypeNames)(
            windows_core::Interface::as_raw(self),
            r#type,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetEffectiveProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEffectiveProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetEffectiveProcessorType(&self, r#type: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEffectiveProcessorType)(windows_core::Interface::as_raw(self), r#type).ok()
    }
    pub unsafe fn GetExecutionStatus(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutionStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExecutionStatus(&self, status: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExecutionStatus)(windows_core::Interface::as_raw(self), status).ok()
    }
    pub unsafe fn GetCodeLevel(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCodeLevel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCodeLevel(&self, level: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCodeLevel)(windows_core::Interface::as_raw(self), level).ok()
    }
    pub unsafe fn GetEngineOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEngineOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn GetSystemErrorControl(&self, outputlevel: *mut u32, breaklevel: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn SetSystemErrorControl(&self, outputlevel: u32, breaklevel: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn GetTextMacro(&self, slot: u32, buffer: Option<&mut [u8]>, macrosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTextMacro)(windows_core::Interface::as_raw(self), slot, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(macrosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetTextMacro<P0>(&self, slot: u32, r#macro: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextMacro)(windows_core::Interface::as_raw(self), slot, r#macro.param().abi()).ok()
    }
    pub unsafe fn GetRadix(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRadix)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRadix(&self, radix: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetRadix)(windows_core::Interface::as_raw(self), radix).ok()
    }
    pub unsafe fn Evaluate<P0>(&self, expression: P0, desiredtype: u32, value: *mut DEBUG_VALUE, remainderindex: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Evaluate)(windows_core::Interface::as_raw(self), expression.param().abi(), desiredtype, value, core::mem::transmute(remainderindex.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CoerceValue(&self, r#in: *const DEBUG_VALUE, outtype: u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValue)(windows_core::Interface::as_raw(self), r#in, outtype, out).ok()
    }
    pub unsafe fn CoerceValues(&self, count: u32, r#in: *const DEBUG_VALUE, outtypes: *const u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValues)(windows_core::Interface::as_raw(self), count, r#in, outtypes, out).ok()
    }
    pub unsafe fn Execute<P0>(&self, outputcontrol: u32, command: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), outputcontrol, command.param().abi(), flags).ok()
    }
    pub unsafe fn ExecuteCommandFile<P0>(&self, outputcontrol: u32, commandfile: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteCommandFile)(windows_core::Interface::as_raw(self), outputcontrol, commandfile.param().abi(), flags).ok()
    }
    pub unsafe fn GetNumberBreakpoints(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberBreakpoints)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetBreakpointByIndex(&self, index: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByIndex)(windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointById(&self, id: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointById)(windows_core::Interface::as_raw(self), id, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointParameters(&self, count: u32, ids: Option<*const u32>, start: u32, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetBreakpointParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(ids.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn AddBreakpoint(&self, r#type: u32, desiredid: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddBreakpoint)(windows_core::Interface::as_raw(self), r#type, desiredid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RemoveBreakpoint<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint>,
    {
        (windows_core::Interface::vtable(self).RemoveBreakpoint)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn AddExtension<P0>(&self, path: P0, flags: u32) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddExtension)(windows_core::Interface::as_raw(self), path.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn RemoveExtension(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveExtension)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetExtensionByPath<P0>(&self, path: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExtensionByPath)(windows_core::Interface::as_raw(self), path.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn CallExtension<P0, P1>(&self, handle: u64, function: P0, arguments: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CallExtension)(windows_core::Interface::as_raw(self), handle, function.param().abi(), arguments.param().abi()).ok()
    }
    pub unsafe fn GetExtensionFunction<P0>(&self, handle: u64, funcname: P0, function: *mut super::super::super::super::Foundation::FARPROC) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetExtensionFunction)(windows_core::Interface::as_raw(self), handle, funcname.param().abi(), function).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis32(&self, api: *mut WINDBG_EXTENSION_APIS32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis32)(windows_core::Interface::as_raw(self), api).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis64(&self, api: *mut WINDBG_EXTENSION_APIS64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis64)(windows_core::Interface::as_raw(self), api).ok()
    }
    pub unsafe fn GetNumberEventFilters(&self, specificevents: *mut u32, specificexceptions: *mut u32, arbitraryexceptions: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetNumberEventFilters)(windows_core::Interface::as_raw(self), specificevents, specificexceptions, arbitraryexceptions).ok()
    }
    pub unsafe fn GetEventFilterText(&self, index: u32, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterText)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetEventFilterCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetEventFilterCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetEventFilterCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetSpecificFilterParameters(&self, start: u32, params: &mut [DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn SetSpecificFilterParameters(&self, start: u32, params: &[DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetSpecificFilterArgument(&self, index: u32, buffer: Option<&mut [u8]>, argumentsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(argumentsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetSpecificFilterArgument<P0>(&self, index: u32, argument: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, argument.param().abi()).ok()
    }
    pub unsafe fn GetExceptionFilterParameters(&self, count: u32, codes: Option<*const u32>, start: u32, params: *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(codes.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn SetExceptionFilterParameters(&self, params: &[DEBUG_EXCEPTION_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExceptionFilterParameters)(windows_core::Interface::as_raw(self), params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetExceptionFilterSecondCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetExceptionFilterSecondCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn WaitForEvent(&self, flags: u32, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForEvent)(windows_core::Interface::as_raw(self), flags, timeout).ok()
    }
    pub unsafe fn GetLastEventInformation(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>, description: Option<&mut [u8]>, descriptionused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLastEventInformation)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(descriptionused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetCurrentTimeDate(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentTimeDate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentSystemUpTime(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentSystemUpTime)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDumpFormatFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDumpFormatFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberTextReplacements(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberTextReplacements)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetTextReplacement<P0>(&self, srctext: P0, index: u32, srcbuffer: Option<&mut [u8]>, srcsize: Option<*mut u32>, dstbuffer: Option<&mut [u8]>, dstsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetTextReplacement)(
            windows_core::Interface::as_raw(self),
            srctext.param().abi(),
            index,
            core::mem::transmute(srcbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            srcbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(srcsize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(dstbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            dstbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(dstsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn SetTextReplacement<P0, P1>(&self, srctext: P0, dsttext: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextReplacement)(windows_core::Interface::as_raw(self), srctext.param().abi(), dsttext.param().abi()).ok()
    }
    pub unsafe fn RemoveTextReplacements(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveTextReplacements)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn OutputTextReplacements(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputTextReplacements)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn GetAssemblyOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAssemblyOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn GetExpressionSyntax(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExpressionSyntax)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExpressionSyntax(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExpressionSyntax)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetExpressionSyntaxByName<P0>(&self, abbrevname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetExpressionSyntaxByName)(windows_core::Interface::as_raw(self), abbrevname.param().abi()).ok()
    }
    pub unsafe fn GetNumberExpressionSyntaxes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberExpressionSyntaxes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetExpressionSyntaxNames(&self, index: u32, fullnamebuffer: Option<&mut [u8]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u8]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExpressionSyntaxNames)(
            windows_core::Interface::as_raw(self),
            index,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetNumberEvents(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberEvents)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetEventIndexDescription<P0>(&self, index: u32, which: u32, buffer: P0, buffersize: u32, descsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetEventIndexDescription)(windows_core::Interface::as_raw(self), index, which, buffer.param().abi(), buffersize, core::mem::transmute(descsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetCurrentEventIndex(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentEventIndex)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetNextEventIndex(&self, relation: u32, value: u32) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).SetNextEventIndex)(windows_core::Interface::as_raw(self), relation, value, &mut result__).map(|| result__)
    }
    pub unsafe fn GetLogFileWide(&self, buffer: Option<&mut [u16]>, filesize: Option<*mut u32>, append: *mut super::super::super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFileWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), append).ok()
    }
    pub unsafe fn OpenLogFileWide<P0, P1>(&self, file: P0, append: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<super::super::super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OpenLogFileWide)(windows_core::Interface::as_raw(self), file.param().abi(), append.param().abi()).ok()
    }
    pub unsafe fn InputWide(&self, buffer: &mut [u16], inputsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).InputWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_ptr()), buffer.len().try_into().unwrap(), core::mem::transmute(inputsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReturnInputWide<P0>(&self, buffer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ReturnInputWide)(windows_core::Interface::as_raw(self), buffer.param().abi()).ok()
    }
    pub unsafe fn OutputWide<P0>(&self, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputWide)(windows_core::Interface::as_raw(self), mask, format.param().abi()).ok()
    }
    pub unsafe fn OutputVaListWide<P0>(&self, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputVaListWide)(windows_core::Interface::as_raw(self), mask, format.param().abi(), args).ok()
    }
    pub unsafe fn ControlledOutputWide<P0>(&self, outputcontrol: u32, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputWide)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi()).ok()
    }
    pub unsafe fn ControlledOutputVaListWide<P0>(&self, outputcontrol: u32, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputVaListWide)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi(), args).ok()
    }
    pub unsafe fn OutputPromptWide<P0>(&self, outputcontrol: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptWide)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi()).ok()
    }
    pub unsafe fn OutputPromptVaListWide<P0>(&self, outputcontrol: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptVaListWide)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi(), args).ok()
    }
    pub unsafe fn GetPromptTextWide(&self, buffer: Option<&mut [u16]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPromptTextWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn AssembleWide<P0>(&self, offset: u64, instr: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AssembleWide)(windows_core::Interface::as_raw(self), offset, instr.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisassembleWide(&self, offset: u64, flags: u32, buffer: Option<&mut [u16]>, disassemblysize: Option<*mut u32>, endoffset: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DisassembleWide)(windows_core::Interface::as_raw(self), offset, flags, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(disassemblysize.unwrap_or(std::ptr::null_mut())), endoffset).ok()
    }
    pub unsafe fn GetProcessorTypeNamesWide(&self, r#type: u32, fullnamebuffer: Option<&mut [u16]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u16]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProcessorTypeNamesWide)(
            windows_core::Interface::as_raw(self),
            r#type,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetTextMacroWide(&self, slot: u32, buffer: Option<&mut [u16]>, macrosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTextMacroWide)(windows_core::Interface::as_raw(self), slot, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(macrosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetTextMacroWide<P0>(&self, slot: u32, r#macro: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextMacroWide)(windows_core::Interface::as_raw(self), slot, r#macro.param().abi()).ok()
    }
    pub unsafe fn EvaluateWide<P0>(&self, expression: P0, desiredtype: u32, value: *mut DEBUG_VALUE, remainderindex: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).EvaluateWide)(windows_core::Interface::as_raw(self), expression.param().abi(), desiredtype, value, core::mem::transmute(remainderindex.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ExecuteWide<P0>(&self, outputcontrol: u32, command: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteWide)(windows_core::Interface::as_raw(self), outputcontrol, command.param().abi(), flags).ok()
    }
    pub unsafe fn ExecuteCommandFileWide<P0>(&self, outputcontrol: u32, commandfile: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteCommandFileWide)(windows_core::Interface::as_raw(self), outputcontrol, commandfile.param().abi(), flags).ok()
    }
    pub unsafe fn GetBreakpointByIndex2(&self, index: u32) -> windows_core::Result<IDebugBreakpoint2> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByIndex2)(windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointById2(&self, id: u32) -> windows_core::Result<IDebugBreakpoint2> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointById2)(windows_core::Interface::as_raw(self), id, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn AddBreakpoint2(&self, r#type: u32, desiredid: u32) -> windows_core::Result<IDebugBreakpoint2> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddBreakpoint2)(windows_core::Interface::as_raw(self), r#type, desiredid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RemoveBreakpoint2<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint2>,
    {
        (windows_core::Interface::vtable(self).RemoveBreakpoint2)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn AddExtensionWide<P0>(&self, path: P0, flags: u32) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddExtensionWide)(windows_core::Interface::as_raw(self), path.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetExtensionByPathWide<P0>(&self, path: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExtensionByPathWide)(windows_core::Interface::as_raw(self), path.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn CallExtensionWide<P0, P1>(&self, handle: u64, function: P0, arguments: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CallExtensionWide)(windows_core::Interface::as_raw(self), handle, function.param().abi(), arguments.param().abi()).ok()
    }
    pub unsafe fn GetExtensionFunctionWide<P0>(&self, handle: u64, funcname: P0, function: *mut super::super::super::super::Foundation::FARPROC) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetExtensionFunctionWide)(windows_core::Interface::as_raw(self), handle, funcname.param().abi(), function).ok()
    }
    pub unsafe fn GetEventFilterTextWide(&self, index: u32, buffer: Option<&mut [u16]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterTextWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetEventFilterCommandWide(&self, index: u32, buffer: Option<&mut [u16]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterCommandWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetEventFilterCommandWide<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetEventFilterCommandWide)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetSpecificFilterArgumentWide(&self, index: u32, buffer: Option<&mut [u16]>, argumentsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterArgumentWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(argumentsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetSpecificFilterArgumentWide<P0>(&self, index: u32, argument: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetSpecificFilterArgumentWide)(windows_core::Interface::as_raw(self), index, argument.param().abi()).ok()
    }
    pub unsafe fn GetExceptionFilterSecondCommandWide(&self, index: u32, buffer: Option<&mut [u16]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterSecondCommandWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetExceptionFilterSecondCommandWide<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetExceptionFilterSecondCommandWide)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetLastEventInformationWide(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>, description: Option<&mut [u16]>, descriptionused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLastEventInformationWide)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(descriptionused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetTextReplacementWide<P0>(&self, srctext: P0, index: u32, srcbuffer: Option<&mut [u16]>, srcsize: Option<*mut u32>, dstbuffer: Option<&mut [u16]>, dstsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetTextReplacementWide)(
            windows_core::Interface::as_raw(self),
            srctext.param().abi(),
            index,
            core::mem::transmute(srcbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            srcbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(srcsize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(dstbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            dstbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(dstsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn SetTextReplacementWide<P0, P1>(&self, srctext: P0, dsttext: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextReplacementWide)(windows_core::Interface::as_raw(self), srctext.param().abi(), dsttext.param().abi()).ok()
    }
    pub unsafe fn SetExpressionSyntaxByNameWide<P0>(&self, abbrevname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetExpressionSyntaxByNameWide)(windows_core::Interface::as_raw(self), abbrevname.param().abi()).ok()
    }
    pub unsafe fn GetExpressionSyntaxNamesWide(&self, index: u32, fullnamebuffer: Option<&mut [u16]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u16]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExpressionSyntaxNamesWide)(
            windows_core::Interface::as_raw(self),
            index,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetEventIndexDescriptionWide<P0>(&self, index: u32, which: u32, buffer: P0, buffersize: u32, descsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetEventIndexDescriptionWide)(windows_core::Interface::as_raw(self), index, which, buffer.param().abi(), buffersize, core::mem::transmute(descsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetLogFile2(&self, buffer: Option<&mut [u8]>, filesize: Option<*mut u32>, flags: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile2)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), flags).ok()
    }
    pub unsafe fn OpenLogFile2<P0>(&self, file: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile2)(windows_core::Interface::as_raw(self), file.param().abi(), flags).ok()
    }
    pub unsafe fn GetLogFile2Wide(&self, buffer: Option<&mut [u16]>, filesize: Option<*mut u32>, flags: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile2Wide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), flags).ok()
    }
    pub unsafe fn OpenLogFile2Wide<P0>(&self, file: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile2Wide)(windows_core::Interface::as_raw(self), file.param().abi(), flags).ok()
    }
    pub unsafe fn GetSystemVersionValues(&self, platformid: *mut u32, win32major: *mut u32, win32minor: *mut u32, kdmajor: Option<*mut u32>, kdminor: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersionValues)(windows_core::Interface::as_raw(self), platformid, win32major, win32minor, core::mem::transmute(kdmajor.unwrap_or(std::ptr::null_mut())), core::mem::transmute(kdminor.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemVersionString(&self, which: u32, buffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersionString)(windows_core::Interface::as_raw(self), which, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemVersionStringWide(&self, which: u32, buffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersionStringWide)(windows_core::Interface::as_raw(self), which, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetContextStackTrace(&self, startcontext: Option<*const core::ffi::c_void>, startcontextsize: u32, frames: Option<&mut [DEBUG_STACK_FRAME]>, framecontexts: Option<*mut core::ffi::c_void>, framecontextssize: u32, framecontextsentrysize: u32, framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetContextStackTrace)(windows_core::Interface::as_raw(self), core::mem::transmute(startcontext.unwrap_or(std::ptr::null())), startcontextsize, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(framecontexts.unwrap_or(std::ptr::null_mut())), framecontextssize, framecontextsentrysize, core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputContextStackTrace(&self, outputcontrol: u32, frames: &[DEBUG_STACK_FRAME], framecontexts: *const core::ffi::c_void, framecontextssize: u32, framecontextsentrysize: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputContextStackTrace)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), framecontexts, framecontextssize, framecontextsentrysize, flags).ok()
    }
    pub unsafe fn GetStoredEventInformation(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, context: Option<*mut core::ffi::c_void>, contextsize: u32, contextused: Option<*mut u32>, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStoredEventInformation)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(context.unwrap_or(std::ptr::null_mut())), contextsize, core::mem::transmute(contextused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetManagedStatus(&self, flags: Option<*mut u32>, whichstring: u32, string: Option<&mut [u8]>, stringneeded: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetManagedStatus)(windows_core::Interface::as_raw(self), core::mem::transmute(flags.unwrap_or(std::ptr::null_mut())), whichstring, core::mem::transmute(string.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), string.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringneeded.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetManagedStatusWide(&self, flags: Option<*mut u32>, whichstring: u32, string: Option<&mut [u16]>, stringneeded: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetManagedStatusWide)(windows_core::Interface::as_raw(self), core::mem::transmute(flags.unwrap_or(std::ptr::null_mut())), whichstring, core::mem::transmute(string.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), string.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringneeded.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ResetManagedStatus(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ResetManagedStatus)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetStackTraceEx(&self, frameoffset: u64, stackoffset: u64, instructionoffset: u64, frames: &mut [DEBUG_STACK_FRAME_EX], framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStackTraceEx)(windows_core::Interface::as_raw(self), frameoffset, stackoffset, instructionoffset, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputStackTraceEx(&self, outputcontrol: u32, frames: Option<&[DEBUG_STACK_FRAME_EX]>, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputStackTraceEx)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), flags).ok()
    }
    pub unsafe fn GetContextStackTraceEx(&self, startcontext: Option<*const core::ffi::c_void>, startcontextsize: u32, frames: Option<&mut [DEBUG_STACK_FRAME_EX]>, framecontexts: Option<*mut core::ffi::c_void>, framecontextssize: u32, framecontextsentrysize: u32, framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetContextStackTraceEx)(windows_core::Interface::as_raw(self), core::mem::transmute(startcontext.unwrap_or(std::ptr::null())), startcontextsize, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(framecontexts.unwrap_or(std::ptr::null_mut())), framecontextssize, framecontextsentrysize, core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputContextStackTraceEx(&self, outputcontrol: u32, frames: &[DEBUG_STACK_FRAME_EX], framecontexts: *const core::ffi::c_void, framecontextssize: u32, framecontextsentrysize: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputContextStackTraceEx)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), framecontexts, framecontextssize, framecontextsentrysize, flags).ok()
    }
    pub unsafe fn GetBreakpointByGuid(&self, guid: *const windows_core::GUID) -> windows_core::Result<IDebugBreakpoint3> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByGuid)(windows_core::Interface::as_raw(self), guid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetExecutionStatusEx(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutionStatusEx)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSynchronizationStatus(&self, sendsattempted: *mut u32, secondssincelastresponse: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSynchronizationStatus)(windows_core::Interface::as_raw(self), sendsattempted, secondssincelastresponse).ok()
    }
}
#[repr(C)]
pub struct IDebugControl6_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32, *mut super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OpenLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub CloseLogFile: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Input: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReturnInput: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub Output: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub ControlledOutput: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub ControlledOutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub OutputPrompt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputPromptVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub GetPromptText: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputCurrentState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OutputVersionInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub Assemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub Disassemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PSTR, u32, *mut u32, *mut u64) -> windows_core::HRESULT,
    pub GetDisassembleEffectiveOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassembly: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassemblyLines: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, u32, *mut u32, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNearInstruction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, i32, *mut u64) -> windows_core::HRESULT,
    pub GetStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, *mut DEBUG_STACK_FRAME, u32, *mut u32) -> windows_core::HRESULT,
    pub GetReturnOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME, u32, u32) -> windows_core::HRESULT,
    pub GetDebuggeeType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetActualProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExecutingProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNumberProcessors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetPageSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub IsPointer64Bit: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ReadBugCheckData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u64, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNumberSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetProcessorTypeNames: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Evaluate: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut DEBUG_VALUE, *mut u32) -> windows_core::HRESULT,
    pub CoerceValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const DEBUG_VALUE, u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub CoerceValues: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_VALUE, *const u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ExecuteCommandFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub GetNumberBreakpoints: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetBreakpointByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointById: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
    pub AddBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddExtension: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut u64) -> windows_core::HRESULT,
    pub RemoveExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetExtensionByPath: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub CallExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExtensionFunction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut super::super::super::super::Foundation::FARPROC) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis32: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis32: usize,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis64: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis64: usize,
    pub GetNumberEventFilters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterText: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *const DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WaitForEvent: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetLastEventInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentTimeDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentSystemUpTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFormatFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTextReplacement: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextReplacement: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub RemoveTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OutputTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExpressionSyntax: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetExpressionSyntax: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetExpressionSyntaxByName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetNumberExpressionSyntaxes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExpressionSyntaxNames: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNumberEvents: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetEventIndexDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentEventIndex: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetNextEventIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetLogFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32, *mut super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OpenLogFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub InputWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReturnInputWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputVaListWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const i8) -> windows_core::HRESULT,
    pub ControlledOutputWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub ControlledOutputVaListWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR, *const i8) -> windows_core::HRESULT,
    pub OutputPromptWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputPromptVaListWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const i8) -> windows_core::HRESULT,
    pub GetPromptTextWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AssembleWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub DisassembleWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PWSTR, u32, *mut u32, *mut u64) -> windows_core::HRESULT,
    pub GetProcessorTypeNamesWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetTextMacroWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextMacroWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub EvaluateWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, *mut DEBUG_VALUE, *mut u32) -> windows_core::HRESULT,
    pub ExecuteWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub ExecuteCommandFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetBreakpointByIndex2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointById2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddBreakpoint2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveBreakpoint2: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddExtensionWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, *mut u64) -> windows_core::HRESULT,
    pub GetExtensionByPathWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub CallExtensionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetExtensionFunctionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *mut super::super::super::super::Foundation::FARPROC) -> windows_core::HRESULT,
    pub GetEventFilterTextWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetEventFilterCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetSpecificFilterArgumentWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetSpecificFilterArgumentWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetExceptionFilterSecondCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetExceptionFilterSecondCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetLastEventInformationWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetTextReplacementWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextReplacementWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetExpressionSyntaxByNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetExpressionSyntaxNamesWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventIndexDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetLogFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub OpenLogFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub GetLogFile2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub OpenLogFile2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetSystemVersionValues: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersionString: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersionStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetContextStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32, *mut DEBUG_STACK_FRAME, u32, *mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputContextStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME, u32, *const core::ffi::c_void, u32, u32, u32) -> windows_core::HRESULT,
    pub GetStoredEventInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetManagedStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetManagedStatusWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ResetManagedStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetStackTraceEx: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, *mut DEBUG_STACK_FRAME_EX, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputStackTraceEx: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME_EX, u32, u32) -> windows_core::HRESULT,
    pub GetContextStackTraceEx: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32, *mut DEBUG_STACK_FRAME_EX, u32, *mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputContextStackTraceEx: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME_EX, u32, *const core::ffi::c_void, u32, u32, u32) -> windows_core::HRESULT,
    pub GetBreakpointByGuid: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetExecutionStatusEx: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSynchronizationStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugControl7, IDebugControl7_Vtbl, 0xb86fb3b1_80d4_475b_aea3_cf06539cf63a);
impl std::ops::Deref for IDebugControl7 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugControl7, windows_core::IUnknown);
impl IDebugControl7 {
    pub unsafe fn GetInterrupt(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetInterrupt)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetInterrupt(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterrupt)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetInterruptTimeout(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInterruptTimeout)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetInterruptTimeout(&self, seconds: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetInterruptTimeout)(windows_core::Interface::as_raw(self), seconds).ok()
    }
    pub unsafe fn GetLogFile(&self, buffer: Option<&mut [u8]>, filesize: Option<*mut u32>, append: *mut super::super::super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), append).ok()
    }
    pub unsafe fn OpenLogFile<P0, P1>(&self, file: P0, append: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<super::super::super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile)(windows_core::Interface::as_raw(self), file.param().abi(), append.param().abi()).ok()
    }
    pub unsafe fn CloseLogFile(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CloseLogFile)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetLogMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetLogMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetLogMask(&self, mask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetLogMask)(windows_core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn Input(&self, buffer: &mut [u8], inputsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Input)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_ptr()), buffer.len().try_into().unwrap(), core::mem::transmute(inputsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReturnInput<P0>(&self, buffer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ReturnInput)(windows_core::Interface::as_raw(self), buffer.param().abi()).ok()
    }
    pub unsafe fn Output<P0>(&self, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Output)(windows_core::Interface::as_raw(self), mask, format.param().abi()).ok()
    }
    pub unsafe fn OutputVaList<P0>(&self, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputVaList)(windows_core::Interface::as_raw(self), mask, format.param().abi(), args).ok()
    }
    pub unsafe fn ControlledOutput<P0>(&self, outputcontrol: u32, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutput)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi()).ok()
    }
    pub unsafe fn ControlledOutputVaList<P0>(&self, outputcontrol: u32, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputVaList)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi(), args).ok()
    }
    pub unsafe fn OutputPrompt<P0>(&self, outputcontrol: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPrompt)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi()).ok()
    }
    pub unsafe fn OutputPromptVaList<P0>(&self, outputcontrol: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptVaList)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi(), args).ok()
    }
    pub unsafe fn GetPromptText(&self, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPromptText)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputCurrentState(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputCurrentState)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn OutputVersionInformation(&self, outputcontrol: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputVersionInformation)(windows_core::Interface::as_raw(self), outputcontrol).ok()
    }
    pub unsafe fn GetNotifyEventHandle(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNotifyEventHandle)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetNotifyEventHandle(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetNotifyEventHandle)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn Assemble<P0>(&self, offset: u64, instr: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).Assemble)(windows_core::Interface::as_raw(self), offset, instr.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn Disassemble(&self, offset: u64, flags: u32, buffer: Option<&mut [u8]>, disassemblysize: Option<*mut u32>, endoffset: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Disassemble)(windows_core::Interface::as_raw(self), offset, flags, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(disassemblysize.unwrap_or(std::ptr::null_mut())), endoffset).ok()
    }
    pub unsafe fn GetDisassembleEffectiveOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDisassembleEffectiveOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassembly(&self, outputcontrol: u32, offset: u64, flags: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).OutputDisassembly)(windows_core::Interface::as_raw(self), outputcontrol, offset, flags, &mut result__).map(|| result__)
    }
    pub unsafe fn OutputDisassemblyLines(&self, outputcontrol: u32, previouslines: u32, offset: u64, flags: u32, offsetline: Option<*mut u32>, startoffset: Option<*mut u64>, endoffset: Option<*mut u64>, lineoffsets: Option<&mut [u64]>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputDisassemblyLines)(windows_core::Interface::as_raw(self), outputcontrol, previouslines, lineoffsets.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), offset, flags, core::mem::transmute(offsetline.unwrap_or(std::ptr::null_mut())), core::mem::transmute(startoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(endoffset.unwrap_or(std::ptr::null_mut())), core::mem::transmute(lineoffsets.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))).ok()
    }
    pub unsafe fn GetNearInstruction(&self, offset: u64, delta: i32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNearInstruction)(windows_core::Interface::as_raw(self), offset, delta, &mut result__).map(|| result__)
    }
    pub unsafe fn GetStackTrace(&self, frameoffset: u64, stackoffset: u64, instructionoffset: u64, frames: &mut [DEBUG_STACK_FRAME], framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStackTrace)(windows_core::Interface::as_raw(self), frameoffset, stackoffset, instructionoffset, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetReturnOffset(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetReturnOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OutputStackTrace(&self, outputcontrol: u32, frames: Option<&[DEBUG_STACK_FRAME]>, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputStackTrace)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), flags).ok()
    }
    pub unsafe fn GetDebuggeeType(&self, class: *mut u32, qualifier: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDebuggeeType)(windows_core::Interface::as_raw(self), class, qualifier).ok()
    }
    pub unsafe fn GetActualProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetActualProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetExecutingProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutingProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberPossibleExecutingProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetPossibleExecutingProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPossibleExecutingProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetNumberProcessors(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberProcessors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSystemVersion(&self, platformid: *mut u32, major: *mut u32, minor: *mut u32, servicepackstring: Option<&mut [u8]>, servicepackstringused: Option<*mut u32>, servicepacknumber: *mut u32, buildstring: Option<&mut [u8]>, buildstringused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersion)(
            windows_core::Interface::as_raw(self),
            platformid,
            major,
            minor,
            core::mem::transmute(servicepackstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            servicepackstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(servicepackstringused.unwrap_or(std::ptr::null_mut())),
            servicepacknumber,
            core::mem::transmute(buildstring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            buildstring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(buildstringused.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetPageSize(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPageSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsPointer64Bit(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsPointer64Bit)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReadBugCheckData(&self, code: *mut u32, arg1: *mut u64, arg2: *mut u64, arg3: *mut u64, arg4: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadBugCheckData)(windows_core::Interface::as_raw(self), code, arg1, arg2, arg3, arg4).ok()
    }
    pub unsafe fn GetNumberSupportedProcessorTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberSupportedProcessorTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSupportedProcessorTypes(&self, start: u32, types: &mut [u32]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSupportedProcessorTypes)(windows_core::Interface::as_raw(self), start, types.len().try_into().unwrap(), core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetProcessorTypeNames(&self, r#type: u32, fullnamebuffer: Option<&mut [u8]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u8]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProcessorTypeNames)(
            windows_core::Interface::as_raw(self),
            r#type,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetEffectiveProcessorType(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEffectiveProcessorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetEffectiveProcessorType(&self, r#type: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEffectiveProcessorType)(windows_core::Interface::as_raw(self), r#type).ok()
    }
    pub unsafe fn GetExecutionStatus(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutionStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExecutionStatus(&self, status: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExecutionStatus)(windows_core::Interface::as_raw(self), status).ok()
    }
    pub unsafe fn GetCodeLevel(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCodeLevel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCodeLevel(&self, level: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCodeLevel)(windows_core::Interface::as_raw(self), level).ok()
    }
    pub unsafe fn GetEngineOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEngineOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetEngineOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEngineOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn GetSystemErrorControl(&self, outputlevel: *mut u32, breaklevel: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn SetSystemErrorControl(&self, outputlevel: u32, breaklevel: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSystemErrorControl)(windows_core::Interface::as_raw(self), outputlevel, breaklevel).ok()
    }
    pub unsafe fn GetTextMacro(&self, slot: u32, buffer: Option<&mut [u8]>, macrosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTextMacro)(windows_core::Interface::as_raw(self), slot, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(macrosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetTextMacro<P0>(&self, slot: u32, r#macro: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextMacro)(windows_core::Interface::as_raw(self), slot, r#macro.param().abi()).ok()
    }
    pub unsafe fn GetRadix(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRadix)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRadix(&self, radix: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetRadix)(windows_core::Interface::as_raw(self), radix).ok()
    }
    pub unsafe fn Evaluate<P0>(&self, expression: P0, desiredtype: u32, value: *mut DEBUG_VALUE, remainderindex: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Evaluate)(windows_core::Interface::as_raw(self), expression.param().abi(), desiredtype, value, core::mem::transmute(remainderindex.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CoerceValue(&self, r#in: *const DEBUG_VALUE, outtype: u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValue)(windows_core::Interface::as_raw(self), r#in, outtype, out).ok()
    }
    pub unsafe fn CoerceValues(&self, count: u32, r#in: *const DEBUG_VALUE, outtypes: *const u32, out: *mut DEBUG_VALUE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CoerceValues)(windows_core::Interface::as_raw(self), count, r#in, outtypes, out).ok()
    }
    pub unsafe fn Execute<P0>(&self, outputcontrol: u32, command: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), outputcontrol, command.param().abi(), flags).ok()
    }
    pub unsafe fn ExecuteCommandFile<P0>(&self, outputcontrol: u32, commandfile: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteCommandFile)(windows_core::Interface::as_raw(self), outputcontrol, commandfile.param().abi(), flags).ok()
    }
    pub unsafe fn GetNumberBreakpoints(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberBreakpoints)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetBreakpointByIndex(&self, index: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByIndex)(windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointById(&self, id: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointById)(windows_core::Interface::as_raw(self), id, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointParameters(&self, count: u32, ids: Option<*const u32>, start: u32, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetBreakpointParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(ids.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn AddBreakpoint(&self, r#type: u32, desiredid: u32) -> windows_core::Result<IDebugBreakpoint> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddBreakpoint)(windows_core::Interface::as_raw(self), r#type, desiredid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RemoveBreakpoint<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint>,
    {
        (windows_core::Interface::vtable(self).RemoveBreakpoint)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn AddExtension<P0>(&self, path: P0, flags: u32) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddExtension)(windows_core::Interface::as_raw(self), path.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn RemoveExtension(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveExtension)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetExtensionByPath<P0>(&self, path: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExtensionByPath)(windows_core::Interface::as_raw(self), path.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn CallExtension<P0, P1>(&self, handle: u64, function: P0, arguments: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CallExtension)(windows_core::Interface::as_raw(self), handle, function.param().abi(), arguments.param().abi()).ok()
    }
    pub unsafe fn GetExtensionFunction<P0>(&self, handle: u64, funcname: P0, function: *mut super::super::super::super::Foundation::FARPROC) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetExtensionFunction)(windows_core::Interface::as_raw(self), handle, funcname.param().abi(), function).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis32(&self, api: *mut WINDBG_EXTENSION_APIS32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis32)(windows_core::Interface::as_raw(self), api).ok()
    }
    #[cfg(feature = "Win32_System_Kernel")]
    pub unsafe fn GetWindbgExtensionApis64(&self, api: *mut WINDBG_EXTENSION_APIS64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetWindbgExtensionApis64)(windows_core::Interface::as_raw(self), api).ok()
    }
    pub unsafe fn GetNumberEventFilters(&self, specificevents: *mut u32, specificexceptions: *mut u32, arbitraryexceptions: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetNumberEventFilters)(windows_core::Interface::as_raw(self), specificevents, specificexceptions, arbitraryexceptions).ok()
    }
    pub unsafe fn GetEventFilterText(&self, index: u32, buffer: Option<&mut [u8]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterText)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetEventFilterCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetEventFilterCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetEventFilterCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetSpecificFilterParameters(&self, start: u32, params: &mut [DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn SetSpecificFilterParameters(&self, start: u32, params: &[DEBUG_SPECIFIC_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSpecificFilterParameters)(windows_core::Interface::as_raw(self), start, params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetSpecificFilterArgument(&self, index: u32, buffer: Option<&mut [u8]>, argumentsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(argumentsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetSpecificFilterArgument<P0>(&self, index: u32, argument: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetSpecificFilterArgument)(windows_core::Interface::as_raw(self), index, argument.param().abi()).ok()
    }
    pub unsafe fn GetExceptionFilterParameters(&self, count: u32, codes: Option<*const u32>, start: u32, params: *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterParameters)(windows_core::Interface::as_raw(self), count, core::mem::transmute(codes.unwrap_or(std::ptr::null())), start, params).ok()
    }
    pub unsafe fn SetExceptionFilterParameters(&self, params: &[DEBUG_EXCEPTION_FILTER_PARAMETERS]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExceptionFilterParameters)(windows_core::Interface::as_raw(self), params.len().try_into().unwrap(), core::mem::transmute(params.as_ptr())).ok()
    }
    pub unsafe fn GetExceptionFilterSecondCommand(&self, index: u32, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetExceptionFilterSecondCommand<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetExceptionFilterSecondCommand)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn WaitForEvent(&self, flags: u32, timeout: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WaitForEvent)(windows_core::Interface::as_raw(self), flags, timeout).ok()
    }
    pub unsafe fn GetLastEventInformation(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>, description: Option<&mut [u8]>, descriptionused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLastEventInformation)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(descriptionused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetCurrentTimeDate(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentTimeDate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentSystemUpTime(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentSystemUpTime)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDumpFormatFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDumpFormatFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberTextReplacements(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberTextReplacements)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetTextReplacement<P0>(&self, srctext: P0, index: u32, srcbuffer: Option<&mut [u8]>, srcsize: Option<*mut u32>, dstbuffer: Option<&mut [u8]>, dstsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetTextReplacement)(
            windows_core::Interface::as_raw(self),
            srctext.param().abi(),
            index,
            core::mem::transmute(srcbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            srcbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(srcsize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(dstbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            dstbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(dstsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn SetTextReplacement<P0, P1>(&self, srctext: P0, dsttext: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextReplacement)(windows_core::Interface::as_raw(self), srctext.param().abi(), dsttext.param().abi()).ok()
    }
    pub unsafe fn RemoveTextReplacements(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveTextReplacements)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn OutputTextReplacements(&self, outputcontrol: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputTextReplacements)(windows_core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn GetAssemblyOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAssemblyOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetAssemblyOptions(&self, options: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetAssemblyOptions)(windows_core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn GetExpressionSyntax(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExpressionSyntax)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExpressionSyntax(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetExpressionSyntax)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetExpressionSyntaxByName<P0>(&self, abbrevname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetExpressionSyntaxByName)(windows_core::Interface::as_raw(self), abbrevname.param().abi()).ok()
    }
    pub unsafe fn GetNumberExpressionSyntaxes(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberExpressionSyntaxes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetExpressionSyntaxNames(&self, index: u32, fullnamebuffer: Option<&mut [u8]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u8]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExpressionSyntaxNames)(
            windows_core::Interface::as_raw(self),
            index,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetNumberEvents(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberEvents)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetEventIndexDescription<P0>(&self, index: u32, which: u32, buffer: P0, buffersize: u32, descsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).GetEventIndexDescription)(windows_core::Interface::as_raw(self), index, which, buffer.param().abi(), buffersize, core::mem::transmute(descsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetCurrentEventIndex(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentEventIndex)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetNextEventIndex(&self, relation: u32, value: u32) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).SetNextEventIndex)(windows_core::Interface::as_raw(self), relation, value, &mut result__).map(|| result__)
    }
    pub unsafe fn GetLogFileWide(&self, buffer: Option<&mut [u16]>, filesize: Option<*mut u32>, append: *mut super::super::super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFileWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), append).ok()
    }
    pub unsafe fn OpenLogFileWide<P0, P1>(&self, file: P0, append: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<super::super::super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OpenLogFileWide)(windows_core::Interface::as_raw(self), file.param().abi(), append.param().abi()).ok()
    }
    pub unsafe fn InputWide(&self, buffer: &mut [u16], inputsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).InputWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_ptr()), buffer.len().try_into().unwrap(), core::mem::transmute(inputsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReturnInputWide<P0>(&self, buffer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ReturnInputWide)(windows_core::Interface::as_raw(self), buffer.param().abi()).ok()
    }
    pub unsafe fn OutputWide<P0>(&self, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputWide)(windows_core::Interface::as_raw(self), mask, format.param().abi()).ok()
    }
    pub unsafe fn OutputVaListWide<P0>(&self, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputVaListWide)(windows_core::Interface::as_raw(self), mask, format.param().abi(), args).ok()
    }
    pub unsafe fn ControlledOutputWide<P0>(&self, outputcontrol: u32, mask: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputWide)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi()).ok()
    }
    pub unsafe fn ControlledOutputVaListWide<P0>(&self, outputcontrol: u32, mask: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ControlledOutputVaListWide)(windows_core::Interface::as_raw(self), outputcontrol, mask, format.param().abi(), args).ok()
    }
    pub unsafe fn OutputPromptWide<P0>(&self, outputcontrol: u32, format: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptWide)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi()).ok()
    }
    pub unsafe fn OutputPromptVaListWide<P0>(&self, outputcontrol: u32, format: P0, args: *const i8) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OutputPromptVaListWide)(windows_core::Interface::as_raw(self), outputcontrol, format.param().abi(), args).ok()
    }
    pub unsafe fn GetPromptTextWide(&self, buffer: Option<&mut [u16]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPromptTextWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn AssembleWide<P0>(&self, offset: u64, instr: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AssembleWide)(windows_core::Interface::as_raw(self), offset, instr.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisassembleWide(&self, offset: u64, flags: u32, buffer: Option<&mut [u16]>, disassemblysize: Option<*mut u32>, endoffset: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DisassembleWide)(windows_core::Interface::as_raw(self), offset, flags, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(disassemblysize.unwrap_or(std::ptr::null_mut())), endoffset).ok()
    }
    pub unsafe fn GetProcessorTypeNamesWide(&self, r#type: u32, fullnamebuffer: Option<&mut [u16]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u16]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProcessorTypeNamesWide)(
            windows_core::Interface::as_raw(self),
            r#type,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetTextMacroWide(&self, slot: u32, buffer: Option<&mut [u16]>, macrosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTextMacroWide)(windows_core::Interface::as_raw(self), slot, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(macrosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetTextMacroWide<P0>(&self, slot: u32, r#macro: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextMacroWide)(windows_core::Interface::as_raw(self), slot, r#macro.param().abi()).ok()
    }
    pub unsafe fn EvaluateWide<P0>(&self, expression: P0, desiredtype: u32, value: *mut DEBUG_VALUE, remainderindex: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).EvaluateWide)(windows_core::Interface::as_raw(self), expression.param().abi(), desiredtype, value, core::mem::transmute(remainderindex.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ExecuteWide<P0>(&self, outputcontrol: u32, command: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteWide)(windows_core::Interface::as_raw(self), outputcontrol, command.param().abi(), flags).ok()
    }
    pub unsafe fn ExecuteCommandFileWide<P0>(&self, outputcontrol: u32, commandfile: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ExecuteCommandFileWide)(windows_core::Interface::as_raw(self), outputcontrol, commandfile.param().abi(), flags).ok()
    }
    pub unsafe fn GetBreakpointByIndex2(&self, index: u32) -> windows_core::Result<IDebugBreakpoint2> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByIndex2)(windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetBreakpointById2(&self, id: u32) -> windows_core::Result<IDebugBreakpoint2> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointById2)(windows_core::Interface::as_raw(self), id, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn AddBreakpoint2(&self, r#type: u32, desiredid: u32) -> windows_core::Result<IDebugBreakpoint2> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddBreakpoint2)(windows_core::Interface::as_raw(self), r#type, desiredid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RemoveBreakpoint2<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint2>,
    {
        (windows_core::Interface::vtable(self).RemoveBreakpoint2)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn AddExtensionWide<P0>(&self, path: P0, flags: u32) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).AddExtensionWide)(windows_core::Interface::as_raw(self), path.param().abi(), flags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetExtensionByPathWide<P0>(&self, path: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExtensionByPathWide)(windows_core::Interface::as_raw(self), path.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn CallExtensionWide<P0, P1>(&self, handle: u64, function: P0, arguments: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CallExtensionWide)(windows_core::Interface::as_raw(self), handle, function.param().abi(), arguments.param().abi()).ok()
    }
    pub unsafe fn GetExtensionFunctionWide<P0>(&self, handle: u64, funcname: P0, function: *mut super::super::super::super::Foundation::FARPROC) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetExtensionFunctionWide)(windows_core::Interface::as_raw(self), handle, funcname.param().abi(), function).ok()
    }
    pub unsafe fn GetEventFilterTextWide(&self, index: u32, buffer: Option<&mut [u16]>, textsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterTextWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(textsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetEventFilterCommandWide(&self, index: u32, buffer: Option<&mut [u16]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetEventFilterCommandWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetEventFilterCommandWide<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetEventFilterCommandWide)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetSpecificFilterArgumentWide(&self, index: u32, buffer: Option<&mut [u16]>, argumentsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpecificFilterArgumentWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(argumentsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetSpecificFilterArgumentWide<P0>(&self, index: u32, argument: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetSpecificFilterArgumentWide)(windows_core::Interface::as_raw(self), index, argument.param().abi()).ok()
    }
    pub unsafe fn GetExceptionFilterSecondCommandWide(&self, index: u32, buffer: Option<&mut [u16]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExceptionFilterSecondCommandWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(commandsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetExceptionFilterSecondCommandWide<P0>(&self, index: u32, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetExceptionFilterSecondCommandWide)(windows_core::Interface::as_raw(self), index, command.param().abi()).ok()
    }
    pub unsafe fn GetLastEventInformationWide(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>, description: Option<&mut [u16]>, descriptionused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLastEventInformationWide)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(descriptionused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetTextReplacementWide<P0>(&self, srctext: P0, index: u32, srcbuffer: Option<&mut [u16]>, srcsize: Option<*mut u32>, dstbuffer: Option<&mut [u16]>, dstsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetTextReplacementWide)(
            windows_core::Interface::as_raw(self),
            srctext.param().abi(),
            index,
            core::mem::transmute(srcbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            srcbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(srcsize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(dstbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            dstbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(dstsize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn SetTextReplacementWide<P0, P1>(&self, srctext: P0, dsttext: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTextReplacementWide)(windows_core::Interface::as_raw(self), srctext.param().abi(), dsttext.param().abi()).ok()
    }
    pub unsafe fn SetExpressionSyntaxByNameWide<P0>(&self, abbrevname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetExpressionSyntaxByNameWide)(windows_core::Interface::as_raw(self), abbrevname.param().abi()).ok()
    }
    pub unsafe fn GetExpressionSyntaxNamesWide(&self, index: u32, fullnamebuffer: Option<&mut [u16]>, fullnamesize: Option<*mut u32>, abbrevnamebuffer: Option<&mut [u16]>, abbrevnamesize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExpressionSyntaxNamesWide)(
            windows_core::Interface::as_raw(self),
            index,
            core::mem::transmute(fullnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            fullnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(fullnamesize.unwrap_or(std::ptr::null_mut())),
            core::mem::transmute(abbrevnamebuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
            abbrevnamebuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
            core::mem::transmute(abbrevnamesize.unwrap_or(std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetEventIndexDescriptionWide<P0>(&self, index: u32, which: u32, buffer: P0, buffersize: u32, descsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetEventIndexDescriptionWide)(windows_core::Interface::as_raw(self), index, which, buffer.param().abi(), buffersize, core::mem::transmute(descsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetLogFile2(&self, buffer: Option<&mut [u8]>, filesize: Option<*mut u32>, flags: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile2)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), flags).ok()
    }
    pub unsafe fn OpenLogFile2<P0>(&self, file: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile2)(windows_core::Interface::as_raw(self), file.param().abi(), flags).ok()
    }
    pub unsafe fn GetLogFile2Wide(&self, buffer: Option<&mut [u16]>, filesize: Option<*mut u32>, flags: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLogFile2Wide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(filesize.unwrap_or(std::ptr::null_mut())), flags).ok()
    }
    pub unsafe fn OpenLogFile2Wide<P0>(&self, file: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OpenLogFile2Wide)(windows_core::Interface::as_raw(self), file.param().abi(), flags).ok()
    }
    pub unsafe fn GetSystemVersionValues(&self, platformid: *mut u32, win32major: *mut u32, win32minor: *mut u32, kdmajor: Option<*mut u32>, kdminor: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersionValues)(windows_core::Interface::as_raw(self), platformid, win32major, win32minor, core::mem::transmute(kdmajor.unwrap_or(std::ptr::null_mut())), core::mem::transmute(kdminor.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemVersionString(&self, which: u32, buffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersionString)(windows_core::Interface::as_raw(self), which, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemVersionStringWide(&self, which: u32, buffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSystemVersionStringWide)(windows_core::Interface::as_raw(self), which, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetContextStackTrace(&self, startcontext: Option<*const core::ffi::c_void>, startcontextsize: u32, frames: Option<&mut [DEBUG_STACK_FRAME]>, framecontexts: Option<*mut core::ffi::c_void>, framecontextssize: u32, framecontextsentrysize: u32, framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetContextStackTrace)(windows_core::Interface::as_raw(self), core::mem::transmute(startcontext.unwrap_or(std::ptr::null())), startcontextsize, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(framecontexts.unwrap_or(std::ptr::null_mut())), framecontextssize, framecontextsentrysize, core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputContextStackTrace(&self, outputcontrol: u32, frames: &[DEBUG_STACK_FRAME], framecontexts: *const core::ffi::c_void, framecontextssize: u32, framecontextsentrysize: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputContextStackTrace)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), framecontexts, framecontextssize, framecontextsentrysize, flags).ok()
    }
    pub unsafe fn GetStoredEventInformation(&self, r#type: *mut u32, processid: *mut u32, threadid: *mut u32, context: Option<*mut core::ffi::c_void>, contextsize: u32, contextused: Option<*mut u32>, extrainformation: Option<*mut core::ffi::c_void>, extrainformationsize: u32, extrainformationused: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStoredEventInformation)(windows_core::Interface::as_raw(self), r#type, processid, threadid, core::mem::transmute(context.unwrap_or(std::ptr::null_mut())), contextsize, core::mem::transmute(contextused.unwrap_or(std::ptr::null_mut())), core::mem::transmute(extrainformation.unwrap_or(std::ptr::null_mut())), extrainformationsize, core::mem::transmute(extrainformationused.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetManagedStatus(&self, flags: Option<*mut u32>, whichstring: u32, string: Option<&mut [u8]>, stringneeded: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetManagedStatus)(windows_core::Interface::as_raw(self), core::mem::transmute(flags.unwrap_or(std::ptr::null_mut())), whichstring, core::mem::transmute(string.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), string.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringneeded.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetManagedStatusWide(&self, flags: Option<*mut u32>, whichstring: u32, string: Option<&mut [u16]>, stringneeded: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetManagedStatusWide)(windows_core::Interface::as_raw(self), core::mem::transmute(flags.unwrap_or(std::ptr::null_mut())), whichstring, core::mem::transmute(string.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), string.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringneeded.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ResetManagedStatus(&self, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ResetManagedStatus)(windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetStackTraceEx(&self, frameoffset: u64, stackoffset: u64, instructionoffset: u64, frames: &mut [DEBUG_STACK_FRAME_EX], framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStackTraceEx)(windows_core::Interface::as_raw(self), frameoffset, stackoffset, instructionoffset, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputStackTraceEx(&self, outputcontrol: u32, frames: Option<&[DEBUG_STACK_FRAME_EX]>, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputStackTraceEx)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), flags).ok()
    }
    pub unsafe fn GetContextStackTraceEx(&self, startcontext: Option<*const core::ffi::c_void>, startcontextsize: u32, frames: Option<&mut [DEBUG_STACK_FRAME_EX]>, framecontexts: Option<*mut core::ffi::c_void>, framecontextssize: u32, framecontextsentrysize: u32, framesfilled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetContextStackTraceEx)(windows_core::Interface::as_raw(self), core::mem::transmute(startcontext.unwrap_or(std::ptr::null())), startcontextsize, core::mem::transmute(frames.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(framecontexts.unwrap_or(std::ptr::null_mut())), framecontextssize, framecontextsentrysize, core::mem::transmute(framesfilled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputContextStackTraceEx(&self, outputcontrol: u32, frames: &[DEBUG_STACK_FRAME_EX], framecontexts: *const core::ffi::c_void, framecontextssize: u32, framecontextsentrysize: u32, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OutputContextStackTraceEx)(windows_core::Interface::as_raw(self), outputcontrol, core::mem::transmute(frames.as_ptr()), frames.len().try_into().unwrap(), framecontexts, framecontextssize, framecontextsentrysize, flags).ok()
    }
    pub unsafe fn GetBreakpointByGuid(&self, guid: *const windows_core::GUID) -> windows_core::Result<IDebugBreakpoint3> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBreakpointByGuid)(windows_core::Interface::as_raw(self), guid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetExecutionStatusEx(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExecutionStatusEx)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSynchronizationStatus(&self, sendsattempted: *mut u32, secondssincelastresponse: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSynchronizationStatus)(windows_core::Interface::as_raw(self), sendsattempted, secondssincelastresponse).ok()
    }
    pub unsafe fn GetDebuggeeType2(&self, flags: u32, class: *mut u32, qualifier: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDebuggeeType2)(windows_core::Interface::as_raw(self), flags, class, qualifier).ok()
    }
}
#[repr(C)]
pub struct IDebugControl7_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInterrupt: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetInterruptTimeout: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32, *mut super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OpenLogFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub CloseLogFile: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetLogMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Input: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReturnInput: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub Output: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub ControlledOutput: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub ControlledOutputVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub OutputPrompt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputPromptVaList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const i8) -> windows_core::HRESULT,
    pub GetPromptText: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputCurrentState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OutputVersionInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetNotifyEventHandle: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub Assemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub Disassemble: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PSTR, u32, *mut u32, *mut u64) -> windows_core::HRESULT,
    pub GetDisassembleEffectiveOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassembly: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut u64) -> windows_core::HRESULT,
    pub OutputDisassemblyLines: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, u32, *mut u32, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNearInstruction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, i32, *mut u64) -> windows_core::HRESULT,
    pub GetStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, *mut DEBUG_STACK_FRAME, u32, *mut u32) -> windows_core::HRESULT,
    pub GetReturnOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub OutputStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME, u32, u32) -> windows_core::HRESULT,
    pub GetDebuggeeType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetActualProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExecutingProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetPossibleExecutingProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNumberProcessors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetPageSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub IsPointer64Bit: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ReadBugCheckData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u64, *mut u64, *mut u64, *mut u64) -> windows_core::HRESULT,
    pub GetNumberSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSupportedProcessorTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetProcessorTypeNames: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetEffectiveProcessorType: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetExecutionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetCodeLevel: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetEngineOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetSystemErrorControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextMacro: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetRadix: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Evaluate: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut DEBUG_VALUE, *mut u32) -> windows_core::HRESULT,
    pub CoerceValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const DEBUG_VALUE, u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub CoerceValues: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_VALUE, *const u32, *mut DEBUG_VALUE) -> windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ExecuteCommandFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub GetNumberBreakpoints: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetBreakpointByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointById: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
    pub AddBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddExtension: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut u64) -> windows_core::HRESULT,
    pub RemoveExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetExtensionByPath: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub CallExtension: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExtensionFunction: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *mut super::super::super::super::Foundation::FARPROC) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis32: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis32: usize,
    #[cfg(feature = "Win32_System_Kernel")]
    pub GetWindbgExtensionApis64: unsafe extern "system" fn(*mut core::ffi::c_void, *mut WINDBG_EXTENSION_APIS64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Kernel"))]
    GetWindbgExtensionApis64: usize,
    pub GetNumberEventFilters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterText: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetEventFilterCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetSpecificFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *const DEBUG_SPECIFIC_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetSpecificFilterArgument: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u32, u32, *mut DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub SetExceptionFilterParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_EXCEPTION_FILTER_PARAMETERS) -> windows_core::HRESULT,
    pub GetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetExceptionFilterSecondCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WaitForEvent: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetLastEventInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentTimeDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentSystemUpTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFormatFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTextReplacement: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextReplacement: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub RemoveTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OutputTextReplacements: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetAssemblyOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExpressionSyntax: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetExpressionSyntax: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetExpressionSyntaxByName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetNumberExpressionSyntaxes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExpressionSyntaxNames: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNumberEvents: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetEventIndexDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetCurrentEventIndex: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetNextEventIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetLogFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32, *mut super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OpenLogFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, super::super::super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub InputWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReturnInputWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputVaListWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const i8) -> windows_core::HRESULT,
    pub ControlledOutputWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub ControlledOutputVaListWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR, *const i8) -> windows_core::HRESULT,
    pub OutputPromptWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputPromptVaListWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const i8) -> windows_core::HRESULT,
    pub GetPromptTextWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AssembleWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub DisassembleWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PWSTR, u32, *mut u32, *mut u64) -> windows_core::HRESULT,
    pub GetProcessorTypeNamesWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetTextMacroWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextMacroWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub EvaluateWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, *mut DEBUG_VALUE, *mut u32) -> windows_core::HRESULT,
    pub ExecuteWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub ExecuteCommandFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetBreakpointByIndex2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBreakpointById2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddBreakpoint2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveBreakpoint2: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddExtensionWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, *mut u64) -> windows_core::HRESULT,
    pub GetExtensionByPathWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub CallExtensionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetExtensionFunctionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *mut super::super::super::super::Foundation::FARPROC) -> windows_core::HRESULT,
    pub GetEventFilterTextWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventFilterCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetEventFilterCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetSpecificFilterArgumentWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetSpecificFilterArgumentWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetExceptionFilterSecondCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetExceptionFilterSecondCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetLastEventInformationWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetTextReplacementWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetTextReplacementWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetExpressionSyntaxByNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetExpressionSyntaxNamesWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetEventIndexDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetLogFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub OpenLogFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub GetLogFile2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub OpenLogFile2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetSystemVersionValues: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersionString: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemVersionStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetContextStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32, *mut DEBUG_STACK_FRAME, u32, *mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputContextStackTrace: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME, u32, *const core::ffi::c_void, u32, u32, u32) -> windows_core::HRESULT,
    pub GetStoredEventInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetManagedStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetManagedStatusWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ResetManagedStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetStackTraceEx: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, *mut DEBUG_STACK_FRAME_EX, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputStackTraceEx: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME_EX, u32, u32) -> windows_core::HRESULT,
    pub GetContextStackTraceEx: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32, *mut DEBUG_STACK_FRAME_EX, u32, *mut core::ffi::c_void, u32, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputContextStackTraceEx: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const DEBUG_STACK_FRAME_EX, u32, *const core::ffi::c_void, u32, u32, u32) -> windows_core::HRESULT,
    pub GetBreakpointByGuid: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetExecutionStatusEx: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSynchronizationStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetDebuggeeType2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugDataSpaces, IDebugDataSpaces_Vtbl, 0x88f7dfab_3ea7_4c3a_aefb_c4e8106173aa);
impl std::ops::Deref for IDebugDataSpaces {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugDataSpaces, windows_core::IUnknown);
impl IDebugDataSpaces {
    pub unsafe fn ReadVirtual(&self, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadVirtual)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteVirtual(&self, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteVirtual)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SearchVirtual(&self, offset: u64, length: u64, pattern: *const core::ffi::c_void, patternsize: u32, patterngranularity: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).SearchVirtual)(windows_core::Interface::as_raw(self), offset, length, pattern, patternsize, patterngranularity, &mut result__).map(|| result__)
    }
    pub unsafe fn ReadVirtualUncached(&self, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadVirtualUncached)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteVirtualUncached(&self, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteVirtualUncached)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadPointersVirtual(&self, offset: u64, ptrs: &mut [u64]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadPointersVirtual)(windows_core::Interface::as_raw(self), ptrs.len().try_into().unwrap(), offset, core::mem::transmute(ptrs.as_ptr())).ok()
    }
    pub unsafe fn WritePointersVirtual(&self, offset: u64, ptrs: &[u64]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WritePointersVirtual)(windows_core::Interface::as_raw(self), ptrs.len().try_into().unwrap(), offset, core::mem::transmute(ptrs.as_ptr())).ok()
    }
    pub unsafe fn ReadPhysical(&self, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadPhysical)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WritePhysical(&self, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WritePhysical)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadControl(&self, processor: u32, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadControl)(windows_core::Interface::as_raw(self), processor, offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteControl(&self, processor: u32, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteControl)(windows_core::Interface::as_raw(self), processor, offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadIo(&self, interfacetype: u32, busnumber: u32, addressspace: u32, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadIo)(windows_core::Interface::as_raw(self), interfacetype, busnumber, addressspace, offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteIo(&self, interfacetype: u32, busnumber: u32, addressspace: u32, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteIo)(windows_core::Interface::as_raw(self), interfacetype, busnumber, addressspace, offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadMsr(&self, msr: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ReadMsr)(windows_core::Interface::as_raw(self), msr, &mut result__).map(|| result__)
    }
    pub unsafe fn WriteMsr(&self, msr: u32, value: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteMsr)(windows_core::Interface::as_raw(self), msr, value).ok()
    }
    pub unsafe fn ReadBusData(&self, busdatatype: u32, busnumber: u32, slotnumber: u32, offset: u32, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadBusData)(windows_core::Interface::as_raw(self), busdatatype, busnumber, slotnumber, offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteBusData(&self, busdatatype: u32, busnumber: u32, slotnumber: u32, offset: u32, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteBusData)(windows_core::Interface::as_raw(self), busdatatype, busnumber, slotnumber, offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CheckLowMemory(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CheckLowMemory)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReadDebuggerData(&self, index: u32, buffer: *mut core::ffi::c_void, buffersize: u32, datasize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadDebuggerData)(windows_core::Interface::as_raw(self), index, buffer, buffersize, core::mem::transmute(datasize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadProcessorSystemData(&self, processor: u32, index: u32, buffer: *mut core::ffi::c_void, buffersize: u32, datasize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadProcessorSystemData)(windows_core::Interface::as_raw(self), processor, index, buffer, buffersize, core::mem::transmute(datasize.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IDebugDataSpaces_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ReadVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub SearchVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, *const core::ffi::c_void, u32, u32, *mut u64) -> windows_core::HRESULT,
    pub ReadVirtualUncached: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteVirtualUncached: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadPointersVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *mut u64) -> windows_core::HRESULT,
    pub WritePointersVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *const u64) -> windows_core::HRESULT,
    pub ReadPhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WritePhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadIo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteIo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadMsr: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u64) -> windows_core::HRESULT,
    pub WriteMsr: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64) -> windows_core::HRESULT,
    pub ReadBusData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteBusData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u32, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub CheckLowMemory: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ReadDebuggerData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadProcessorSystemData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugDataSpaces2, IDebugDataSpaces2_Vtbl, 0x7a5e852f_96e9_468f_ac1b_0b3addc4a049);
impl std::ops::Deref for IDebugDataSpaces2 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugDataSpaces2, windows_core::IUnknown);
impl IDebugDataSpaces2 {
    pub unsafe fn ReadVirtual(&self, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadVirtual)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteVirtual(&self, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteVirtual)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SearchVirtual(&self, offset: u64, length: u64, pattern: *const core::ffi::c_void, patternsize: u32, patterngranularity: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).SearchVirtual)(windows_core::Interface::as_raw(self), offset, length, pattern, patternsize, patterngranularity, &mut result__).map(|| result__)
    }
    pub unsafe fn ReadVirtualUncached(&self, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadVirtualUncached)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteVirtualUncached(&self, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteVirtualUncached)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadPointersVirtual(&self, offset: u64, ptrs: &mut [u64]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadPointersVirtual)(windows_core::Interface::as_raw(self), ptrs.len().try_into().unwrap(), offset, core::mem::transmute(ptrs.as_ptr())).ok()
    }
    pub unsafe fn WritePointersVirtual(&self, offset: u64, ptrs: &[u64]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WritePointersVirtual)(windows_core::Interface::as_raw(self), ptrs.len().try_into().unwrap(), offset, core::mem::transmute(ptrs.as_ptr())).ok()
    }
    pub unsafe fn ReadPhysical(&self, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadPhysical)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WritePhysical(&self, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WritePhysical)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadControl(&self, processor: u32, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadControl)(windows_core::Interface::as_raw(self), processor, offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteControl(&self, processor: u32, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteControl)(windows_core::Interface::as_raw(self), processor, offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadIo(&self, interfacetype: u32, busnumber: u32, addressspace: u32, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadIo)(windows_core::Interface::as_raw(self), interfacetype, busnumber, addressspace, offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteIo(&self, interfacetype: u32, busnumber: u32, addressspace: u32, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteIo)(windows_core::Interface::as_raw(self), interfacetype, busnumber, addressspace, offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadMsr(&self, msr: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ReadMsr)(windows_core::Interface::as_raw(self), msr, &mut result__).map(|| result__)
    }
    pub unsafe fn WriteMsr(&self, msr: u32, value: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteMsr)(windows_core::Interface::as_raw(self), msr, value).ok()
    }
    pub unsafe fn ReadBusData(&self, busdatatype: u32, busnumber: u32, slotnumber: u32, offset: u32, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadBusData)(windows_core::Interface::as_raw(self), busdatatype, busnumber, slotnumber, offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteBusData(&self, busdatatype: u32, busnumber: u32, slotnumber: u32, offset: u32, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteBusData)(windows_core::Interface::as_raw(self), busdatatype, busnumber, slotnumber, offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CheckLowMemory(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CheckLowMemory)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReadDebuggerData(&self, index: u32, buffer: *mut core::ffi::c_void, buffersize: u32, datasize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadDebuggerData)(windows_core::Interface::as_raw(self), index, buffer, buffersize, core::mem::transmute(datasize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadProcessorSystemData(&self, processor: u32, index: u32, buffer: *mut core::ffi::c_void, buffersize: u32, datasize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadProcessorSystemData)(windows_core::Interface::as_raw(self), processor, index, buffer, buffersize, core::mem::transmute(datasize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn VirtualToPhysical(&self, r#virtual: u64) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).VirtualToPhysical)(windows_core::Interface::as_raw(self), r#virtual, &mut result__).map(|| result__)
    }
    pub unsafe fn GetVirtualTranslationPhysicalOffsets(&self, r#virtual: u64, offsets: Option<&mut [u64]>, levels: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetVirtualTranslationPhysicalOffsets)(windows_core::Interface::as_raw(self), r#virtual, core::mem::transmute(offsets.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), offsets.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(levels.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadHandleData(&self, handle: u64, datatype: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, datasize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadHandleData)(windows_core::Interface::as_raw(self), handle, datatype, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(datasize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FillVirtual(&self, start: u64, size: u32, pattern: *const core::ffi::c_void, patternsize: u32, filled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FillVirtual)(windows_core::Interface::as_raw(self), start, size, pattern, patternsize, core::mem::transmute(filled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FillPhysical(&self, start: u64, size: u32, pattern: *const core::ffi::c_void, patternsize: u32, filled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FillPhysical)(windows_core::Interface::as_raw(self), start, size, pattern, patternsize, core::mem::transmute(filled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    #[cfg(feature = "Win32_System_Memory")]
    pub unsafe fn QueryVirtual(&self, offset: u64, info: *mut super::super::super::Memory::MEMORY_BASIC_INFORMATION64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).QueryVirtual)(windows_core::Interface::as_raw(self), offset, info).ok()
    }
}
#[repr(C)]
pub struct IDebugDataSpaces2_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ReadVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub SearchVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, *const core::ffi::c_void, u32, u32, *mut u64) -> windows_core::HRESULT,
    pub ReadVirtualUncached: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteVirtualUncached: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadPointersVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *mut u64) -> windows_core::HRESULT,
    pub WritePointersVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *const u64) -> windows_core::HRESULT,
    pub ReadPhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WritePhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadIo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteIo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadMsr: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u64) -> windows_core::HRESULT,
    pub WriteMsr: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64) -> windows_core::HRESULT,
    pub ReadBusData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteBusData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u32, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub CheckLowMemory: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ReadDebuggerData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadProcessorSystemData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub VirtualToPhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u64) -> windows_core::HRESULT,
    pub GetVirtualTranslationPhysicalOffsets: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u64, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadHandleData: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FillVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FillPhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Memory")]
    pub QueryVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut super::super::super::Memory::MEMORY_BASIC_INFORMATION64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Memory"))]
    QueryVirtual: usize,
}
windows_core::imp::define_interface!(IDebugDataSpaces3, IDebugDataSpaces3_Vtbl, 0x23f79d6c_8aaf_4f7c_a607_9995f5407e63);
impl std::ops::Deref for IDebugDataSpaces3 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugDataSpaces3, windows_core::IUnknown);
impl IDebugDataSpaces3 {
    pub unsafe fn ReadVirtual(&self, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadVirtual)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteVirtual(&self, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteVirtual)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SearchVirtual(&self, offset: u64, length: u64, pattern: *const core::ffi::c_void, patternsize: u32, patterngranularity: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).SearchVirtual)(windows_core::Interface::as_raw(self), offset, length, pattern, patternsize, patterngranularity, &mut result__).map(|| result__)
    }
    pub unsafe fn ReadVirtualUncached(&self, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadVirtualUncached)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteVirtualUncached(&self, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteVirtualUncached)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadPointersVirtual(&self, offset: u64, ptrs: &mut [u64]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadPointersVirtual)(windows_core::Interface::as_raw(self), ptrs.len().try_into().unwrap(), offset, core::mem::transmute(ptrs.as_ptr())).ok()
    }
    pub unsafe fn WritePointersVirtual(&self, offset: u64, ptrs: &[u64]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WritePointersVirtual)(windows_core::Interface::as_raw(self), ptrs.len().try_into().unwrap(), offset, core::mem::transmute(ptrs.as_ptr())).ok()
    }
    pub unsafe fn ReadPhysical(&self, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadPhysical)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WritePhysical(&self, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WritePhysical)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadControl(&self, processor: u32, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadControl)(windows_core::Interface::as_raw(self), processor, offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteControl(&self, processor: u32, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteControl)(windows_core::Interface::as_raw(self), processor, offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadIo(&self, interfacetype: u32, busnumber: u32, addressspace: u32, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadIo)(windows_core::Interface::as_raw(self), interfacetype, busnumber, addressspace, offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteIo(&self, interfacetype: u32, busnumber: u32, addressspace: u32, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteIo)(windows_core::Interface::as_raw(self), interfacetype, busnumber, addressspace, offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadMsr(&self, msr: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ReadMsr)(windows_core::Interface::as_raw(self), msr, &mut result__).map(|| result__)
    }
    pub unsafe fn WriteMsr(&self, msr: u32, value: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteMsr)(windows_core::Interface::as_raw(self), msr, value).ok()
    }
    pub unsafe fn ReadBusData(&self, busdatatype: u32, busnumber: u32, slotnumber: u32, offset: u32, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadBusData)(windows_core::Interface::as_raw(self), busdatatype, busnumber, slotnumber, offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteBusData(&self, busdatatype: u32, busnumber: u32, slotnumber: u32, offset: u32, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteBusData)(windows_core::Interface::as_raw(self), busdatatype, busnumber, slotnumber, offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CheckLowMemory(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CheckLowMemory)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReadDebuggerData(&self, index: u32, buffer: *mut core::ffi::c_void, buffersize: u32, datasize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadDebuggerData)(windows_core::Interface::as_raw(self), index, buffer, buffersize, core::mem::transmute(datasize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadProcessorSystemData(&self, processor: u32, index: u32, buffer: *mut core::ffi::c_void, buffersize: u32, datasize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadProcessorSystemData)(windows_core::Interface::as_raw(self), processor, index, buffer, buffersize, core::mem::transmute(datasize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn VirtualToPhysical(&self, r#virtual: u64) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).VirtualToPhysical)(windows_core::Interface::as_raw(self), r#virtual, &mut result__).map(|| result__)
    }
    pub unsafe fn GetVirtualTranslationPhysicalOffsets(&self, r#virtual: u64, offsets: Option<&mut [u64]>, levels: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetVirtualTranslationPhysicalOffsets)(windows_core::Interface::as_raw(self), r#virtual, core::mem::transmute(offsets.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), offsets.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(levels.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadHandleData(&self, handle: u64, datatype: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, datasize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadHandleData)(windows_core::Interface::as_raw(self), handle, datatype, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(datasize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FillVirtual(&self, start: u64, size: u32, pattern: *const core::ffi::c_void, patternsize: u32, filled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FillVirtual)(windows_core::Interface::as_raw(self), start, size, pattern, patternsize, core::mem::transmute(filled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FillPhysical(&self, start: u64, size: u32, pattern: *const core::ffi::c_void, patternsize: u32, filled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FillPhysical)(windows_core::Interface::as_raw(self), start, size, pattern, patternsize, core::mem::transmute(filled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    #[cfg(feature = "Win32_System_Memory")]
    pub unsafe fn QueryVirtual(&self, offset: u64, info: *mut super::super::super::Memory::MEMORY_BASIC_INFORMATION64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).QueryVirtual)(windows_core::Interface::as_raw(self), offset, info).ok()
    }
    #[cfg(feature = "Win32_System_SystemInformation")]
    pub unsafe fn ReadImageNtHeaders(&self, imagebase: u64, headers: *mut super::IMAGE_NT_HEADERS64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadImageNtHeaders)(windows_core::Interface::as_raw(self), imagebase, headers).ok()
    }
    pub unsafe fn ReadTagged(&self, tag: *const windows_core::GUID, offset: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, totalsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadTagged)(windows_core::Interface::as_raw(self), tag, offset, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(totalsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn StartEnumTagged(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).StartEnumTagged)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNextTagged(&self, handle: u64, tag: *mut windows_core::GUID, size: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetNextTagged)(windows_core::Interface::as_raw(self), handle, tag, size).ok()
    }
    pub unsafe fn EndEnumTagged(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndEnumTagged)(windows_core::Interface::as_raw(self), handle).ok()
    }
}
#[repr(C)]
pub struct IDebugDataSpaces3_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ReadVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub SearchVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, *const core::ffi::c_void, u32, u32, *mut u64) -> windows_core::HRESULT,
    pub ReadVirtualUncached: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteVirtualUncached: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadPointersVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *mut u64) -> windows_core::HRESULT,
    pub WritePointersVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *const u64) -> windows_core::HRESULT,
    pub ReadPhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WritePhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadIo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteIo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadMsr: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u64) -> windows_core::HRESULT,
    pub WriteMsr: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64) -> windows_core::HRESULT,
    pub ReadBusData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteBusData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u32, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub CheckLowMemory: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ReadDebuggerData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadProcessorSystemData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub VirtualToPhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u64) -> windows_core::HRESULT,
    pub GetVirtualTranslationPhysicalOffsets: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u64, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadHandleData: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FillVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FillPhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Memory")]
    pub QueryVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut super::super::super::Memory::MEMORY_BASIC_INFORMATION64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Memory"))]
    QueryVirtual: usize,
    #[cfg(feature = "Win32_System_SystemInformation")]
    pub ReadImageNtHeaders: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut super::IMAGE_NT_HEADERS64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_SystemInformation"))]
    ReadImageNtHeaders: usize,
    pub ReadTagged: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub StartEnumTagged: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub GetNextTagged: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut windows_core::GUID, *mut u32) -> windows_core::HRESULT,
    pub EndEnumTagged: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugDataSpaces4, IDebugDataSpaces4_Vtbl, 0xd98ada1f_29e9_4ef5_a6c0_e53349883212);
impl std::ops::Deref for IDebugDataSpaces4 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugDataSpaces4, windows_core::IUnknown);
impl IDebugDataSpaces4 {
    pub unsafe fn ReadVirtual(&self, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadVirtual)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteVirtual(&self, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteVirtual)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SearchVirtual(&self, offset: u64, length: u64, pattern: *const core::ffi::c_void, patternsize: u32, patterngranularity: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).SearchVirtual)(windows_core::Interface::as_raw(self), offset, length, pattern, patternsize, patterngranularity, &mut result__).map(|| result__)
    }
    pub unsafe fn ReadVirtualUncached(&self, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadVirtualUncached)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteVirtualUncached(&self, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteVirtualUncached)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadPointersVirtual(&self, offset: u64, ptrs: &mut [u64]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadPointersVirtual)(windows_core::Interface::as_raw(self), ptrs.len().try_into().unwrap(), offset, core::mem::transmute(ptrs.as_ptr())).ok()
    }
    pub unsafe fn WritePointersVirtual(&self, offset: u64, ptrs: &[u64]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WritePointersVirtual)(windows_core::Interface::as_raw(self), ptrs.len().try_into().unwrap(), offset, core::mem::transmute(ptrs.as_ptr())).ok()
    }
    pub unsafe fn ReadPhysical(&self, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadPhysical)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WritePhysical(&self, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WritePhysical)(windows_core::Interface::as_raw(self), offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadControl(&self, processor: u32, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadControl)(windows_core::Interface::as_raw(self), processor, offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteControl(&self, processor: u32, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteControl)(windows_core::Interface::as_raw(self), processor, offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadIo(&self, interfacetype: u32, busnumber: u32, addressspace: u32, offset: u64, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadIo)(windows_core::Interface::as_raw(self), interfacetype, busnumber, addressspace, offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteIo(&self, interfacetype: u32, busnumber: u32, addressspace: u32, offset: u64, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteIo)(windows_core::Interface::as_raw(self), interfacetype, busnumber, addressspace, offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadMsr(&self, msr: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ReadMsr)(windows_core::Interface::as_raw(self), msr, &mut result__).map(|| result__)
    }
    pub unsafe fn WriteMsr(&self, msr: u32, value: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteMsr)(windows_core::Interface::as_raw(self), msr, value).ok()
    }
    pub unsafe fn ReadBusData(&self, busdatatype: u32, busnumber: u32, slotnumber: u32, offset: u32, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadBusData)(windows_core::Interface::as_raw(self), busdatatype, busnumber, slotnumber, offset, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WriteBusData(&self, busdatatype: u32, busnumber: u32, slotnumber: u32, offset: u32, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WriteBusData)(windows_core::Interface::as_raw(self), busdatatype, busnumber, slotnumber, offset, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn CheckLowMemory(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CheckLowMemory)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReadDebuggerData(&self, index: u32, buffer: *mut core::ffi::c_void, buffersize: u32, datasize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadDebuggerData)(windows_core::Interface::as_raw(self), index, buffer, buffersize, core::mem::transmute(datasize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadProcessorSystemData(&self, processor: u32, index: u32, buffer: *mut core::ffi::c_void, buffersize: u32, datasize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadProcessorSystemData)(windows_core::Interface::as_raw(self), processor, index, buffer, buffersize, core::mem::transmute(datasize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn VirtualToPhysical(&self, r#virtual: u64) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).VirtualToPhysical)(windows_core::Interface::as_raw(self), r#virtual, &mut result__).map(|| result__)
    }
    pub unsafe fn GetVirtualTranslationPhysicalOffsets(&self, r#virtual: u64, offsets: Option<&mut [u64]>, levels: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetVirtualTranslationPhysicalOffsets)(windows_core::Interface::as_raw(self), r#virtual, core::mem::transmute(offsets.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), offsets.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(levels.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadHandleData(&self, handle: u64, datatype: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, datasize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadHandleData)(windows_core::Interface::as_raw(self), handle, datatype, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(datasize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FillVirtual(&self, start: u64, size: u32, pattern: *const core::ffi::c_void, patternsize: u32, filled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FillVirtual)(windows_core::Interface::as_raw(self), start, size, pattern, patternsize, core::mem::transmute(filled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FillPhysical(&self, start: u64, size: u32, pattern: *const core::ffi::c_void, patternsize: u32, filled: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FillPhysical)(windows_core::Interface::as_raw(self), start, size, pattern, patternsize, core::mem::transmute(filled.unwrap_or(std::ptr::null_mut()))).ok()
    }
    #[cfg(feature = "Win32_System_Memory")]
    pub unsafe fn QueryVirtual(&self, offset: u64, info: *mut super::super::super::Memory::MEMORY_BASIC_INFORMATION64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).QueryVirtual)(windows_core::Interface::as_raw(self), offset, info).ok()
    }
    #[cfg(feature = "Win32_System_SystemInformation")]
    pub unsafe fn ReadImageNtHeaders(&self, imagebase: u64, headers: *mut super::IMAGE_NT_HEADERS64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadImageNtHeaders)(windows_core::Interface::as_raw(self), imagebase, headers).ok()
    }
    pub unsafe fn ReadTagged(&self, tag: *const windows_core::GUID, offset: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, totalsize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadTagged)(windows_core::Interface::as_raw(self), tag, offset, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(totalsize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn StartEnumTagged(&self) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).StartEnumTagged)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNextTagged(&self, handle: u64, tag: *mut windows_core::GUID, size: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetNextTagged)(windows_core::Interface::as_raw(self), handle, tag, size).ok()
    }
    pub unsafe fn EndEnumTagged(&self, handle: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndEnumTagged)(windows_core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetOffsetInformation(&self, space: u32, which: u32, offset: u64, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetOffsetInformation)(windows_core::Interface::as_raw(self), space, which, offset, core::mem::transmute(buffer.unwrap_or(std::ptr::null_mut())), buffersize, core::mem::transmute(infosize.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetNextDifferentlyValidOffsetVirtual(&self, offset: u64) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNextDifferentlyValidOffsetVirtual)(windows_core::Interface::as_raw(self), offset, &mut result__).map(|| result__)
    }
    pub unsafe fn GetValidRegionVirtual(&self, base: u64, size: u32, validbase: *mut u64, validsize: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetValidRegionVirtual)(windows_core::Interface::as_raw(self), base, size, validbase, validsize).ok()
    }
    pub unsafe fn SearchVirtual2(&self, offset: u64, length: u64, flags: u32, pattern: *const core::ffi::c_void, patternsize: u32, patterngranularity: u32) -> windows_core::Result<u64> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).SearchVirtual2)(windows_core::Interface::as_raw(self), offset, length, flags, pattern, patternsize, patterngranularity, &mut result__).map(|| result__)
    }
    pub unsafe fn ReadMultiByteStringVirtual(&self, offset: u64, maxbytes: u32, buffer: Option<&mut [u8]>, stringbytes: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadMultiByteStringVirtual)(windows_core::Interface::as_raw(self), offset, maxbytes, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringbytes.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadMultiByteStringVirtualWide(&self, offset: u64, maxbytes: u32, codepage: u32, buffer: Option<&mut [u16]>, stringbytes: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadMultiByteStringVirtualWide)(windows_core::Interface::as_raw(self), offset, maxbytes, codepage, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringbytes.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadUnicodeStringVirtual(&self, offset: u64, maxbytes: u32, codepage: u32, buffer: Option<&mut [u8]>, stringbytes: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadUnicodeStringVirtual)(windows_core::Interface::as_raw(self), offset, maxbytes, codepage, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringbytes.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadUnicodeStringVirtualWide(&self, offset: u64, maxbytes: u32, buffer: Option<&mut [u16]>, stringbytes: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadUnicodeStringVirtualWide)(windows_core::Interface::as_raw(self), offset, maxbytes, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(stringbytes.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReadPhysical2(&self, offset: u64, flags: u32, buffer: *mut core::ffi::c_void, buffersize: u32, bytesread: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadPhysical2)(windows_core::Interface::as_raw(self), offset, flags, buffer, buffersize, core::mem::transmute(bytesread.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn WritePhysical2(&self, offset: u64, flags: u32, buffer: *const core::ffi::c_void, buffersize: u32, byteswritten: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WritePhysical2)(windows_core::Interface::as_raw(self), offset, flags, buffer, buffersize, core::mem::transmute(byteswritten.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IDebugDataSpaces4_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ReadVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub SearchVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, *const core::ffi::c_void, u32, u32, *mut u64) -> windows_core::HRESULT,
    pub ReadVirtualUncached: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteVirtualUncached: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadPointersVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *mut u64) -> windows_core::HRESULT,
    pub WritePointersVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *const u64) -> windows_core::HRESULT,
    pub ReadPhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WritePhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteControl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadIo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteIo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u64, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadMsr: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u64) -> windows_core::HRESULT,
    pub WriteMsr: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64) -> windows_core::HRESULT,
    pub ReadBusData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WriteBusData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u32, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub CheckLowMemory: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ReadDebuggerData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadProcessorSystemData: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub VirtualToPhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u64) -> windows_core::HRESULT,
    pub GetVirtualTranslationPhysicalOffsets: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u64, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadHandleData: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FillVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FillPhysical: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Memory")]
    pub QueryVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut super::super::super::Memory::MEMORY_BASIC_INFORMATION64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Memory"))]
    QueryVirtual: usize,
    #[cfg(feature = "Win32_System_SystemInformation")]
    pub ReadImageNtHeaders: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut super::IMAGE_NT_HEADERS64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_SystemInformation"))]
    ReadImageNtHeaders: usize,
    pub ReadTagged: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub StartEnumTagged: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub GetNextTagged: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut windows_core::GUID, *mut u32) -> windows_core::HRESULT,
    pub EndEnumTagged: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetOffsetInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u64, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNextDifferentlyValidOffsetVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u64) -> windows_core::HRESULT,
    pub GetValidRegionVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub SearchVirtual2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u32, *const core::ffi::c_void, u32, u32, *mut u64) -> windows_core::HRESULT,
    pub ReadMultiByteStringVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadMultiByteStringVirtualWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadUnicodeStringVirtual: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadUnicodeStringVirtualWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub ReadPhysical2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub WritePhysical2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *const core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugEventCallbacks, IDebugEventCallbacks_Vtbl, 0x337be28b_5036_4d72_b6bf_c45fbb9f2eaa);
impl std::ops::Deref for IDebugEventCallbacks {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugEventCallbacks, windows_core::IUnknown);
impl IDebugEventCallbacks {
    pub unsafe fn GetInterestMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInterestMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Breakpoint<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint>,
    {
        (windows_core::Interface::vtable(self).Breakpoint)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn Exception(&self, exception: *const super::EXCEPTION_RECORD64, firstchance: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Exception)(windows_core::Interface::as_raw(self), exception, firstchance).ok()
    }
    pub unsafe fn CreateThread(&self, handle: u64, dataoffset: u64, startoffset: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CreateThread)(windows_core::Interface::as_raw(self), handle, dataoffset, startoffset).ok()
    }
    pub unsafe fn ExitThread(&self, exitcode: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ExitThread)(windows_core::Interface::as_raw(self), exitcode).ok()
    }
    pub unsafe fn CreateProcessA<P0, P1>(&self, imagefilehandle: u64, handle: u64, baseoffset: u64, modulesize: u32, modulename: P0, imagename: P1, checksum: u32, timedatestamp: u32, initialthreadhandle: u64, threaddataoffset: u64, startoffset: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), imagefilehandle, handle, baseoffset, modulesize, modulename.param().abi(), imagename.param().abi(), checksum, timedatestamp, initialthreadhandle, threaddataoffset, startoffset).ok()
    }
    pub unsafe fn ExitProcess(&self, exitcode: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ExitProcess)(windows_core::Interface::as_raw(self), exitcode).ok()
    }
    pub unsafe fn LoadModule<P0, P1>(&self, imagefilehandle: u64, baseoffset: u64, modulesize: u32, modulename: P0, imagename: P1, checksum: u32, timedatestamp: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).LoadModule)(windows_core::Interface::as_raw(self), imagefilehandle, baseoffset, modulesize, modulename.param().abi(), imagename.param().abi(), checksum, timedatestamp).ok()
    }
    pub unsafe fn UnloadModule<P0>(&self, imagebasename: P0, baseoffset: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).UnloadModule)(windows_core::Interface::as_raw(self), imagebasename.param().abi(), baseoffset).ok()
    }
    pub unsafe fn SystemError(&self, error: u32, level: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SystemError)(windows_core::Interface::as_raw(self), error, level).ok()
    }
    pub unsafe fn SessionStatus(&self, status: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SessionStatus)(windows_core::Interface::as_raw(self), status).ok()
    }
    pub unsafe fn ChangeDebuggeeState(&self, flags: u32, argument: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ChangeDebuggeeState)(windows_core::Interface::as_raw(self), flags, argument).ok()
    }
    pub unsafe fn ChangeEngineState(&self, flags: u32, argument: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ChangeEngineState)(windows_core::Interface::as_raw(self), flags, argument).ok()
    }
    pub unsafe fn ChangeSymbolState(&self, flags: u32, argument: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ChangeSymbolState)(windows_core::Interface::as_raw(self), flags, argument).ok()
    }
}
#[repr(C)]
pub struct IDebugEventCallbacks_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetInterestMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Breakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Exception: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::EXCEPTION_RECORD64, u32) -> windows_core::HRESULT,
    pub CreateThread: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64) -> windows_core::HRESULT,
    pub ExitThread: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, u32, windows_core::PCSTR, windows_core::PCSTR, u32, u32, u64, u64, u64) -> windows_core::HRESULT,
    pub ExitProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub LoadModule: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u32, windows_core::PCSTR, windows_core::PCSTR, u32, u32) -> windows_core::HRESULT,
    pub UnloadModule: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u64) -> windows_core::HRESULT,
    pub SystemError: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub SessionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ChangeDebuggeeState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64) -> windows_core::HRESULT,
    pub ChangeEngineState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64) -> windows_core::HRESULT,
    pub ChangeSymbolState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugEventCallbacksWide, IDebugEventCallbacksWide_Vtbl, 0x0690e046_9c23_45ac_a04f_987ac29ad0d3);
impl std::ops::Deref for IDebugEventCallbacksWide {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugEventCallbacksWide, windows_core::IUnknown);
impl IDebugEventCallbacksWide {
    pub unsafe fn GetInterestMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInterestMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Breakpoint<P0>(&self, bp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint2>,
    {
        (windows_core::Interface::vtable(self).Breakpoint)(windows_core::Interface::as_raw(self), bp.param().abi()).ok()
    }
    pub unsafe fn Exception(&self, exception: *const super::EXCEPTION_RECORD64, firstchance: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Exception)(windows_core::Interface::as_raw(self), exception, firstchance).ok()
    }
    pub unsafe fn CreateThread(&self, handle: u64, dataoffset: u64, startoffset: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CreateThread)(windows_core::Interface::as_raw(self), handle, dataoffset, startoffset).ok()
    }
    pub unsafe fn ExitThread(&self, exitcode: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ExitThread)(windows_core::Interface::as_raw(self), exitcode).ok()
    }
    pub unsafe fn CreateProcessA<P0, P1>(&self, imagefilehandle: u64, handle: u64, baseoffset: u64, modulesize: u32, modulename: P0, imagename: P1, checksum: u32, timedatestamp: u32, initialthreadhandle: u64, threaddataoffset: u64, startoffset: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), imagefilehandle, handle, baseoffset, modulesize, modulename.param().abi(), imagename.param().abi(), checksum, timedatestamp, initialthreadhandle, threaddataoffset, startoffset).ok()
    }
    pub unsafe fn ExitProcess(&self, exitcode: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ExitProcess)(windows_core::Interface::as_raw(self), exitcode).ok()
    }
    pub unsafe fn LoadModule<P0, P1>(&self, imagefilehandle: u64, baseoffset: u64, modulesize: u32, modulename: P0, imagename: P1, checksum: u32, timedatestamp: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).LoadModule)(windows_core::Interface::as_raw(self), imagefilehandle, baseoffset, modulesize, modulename.param().abi(), imagename.param().abi(), checksum, timedatestamp).ok()
    }
    pub unsafe fn UnloadModule<P0>(&self, imagebasename: P0, baseoffset: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).UnloadModule)(windows_core::Interface::as_raw(self), imagebasename.param().abi(), baseoffset).ok()
    }
    pub unsafe fn SystemError(&self, error: u32, level: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SystemError)(windows_core::Interface::as_raw(self), error, level).ok()
    }
    pub unsafe fn SessionStatus(&self, status: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SessionStatus)(windows_core::Interface::as_raw(self), status).ok()
    }
    pub unsafe fn ChangeDebuggeeState(&self, flags: u32, argument: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ChangeDebuggeeState)(windows_core::Interface::as_raw(self), flags, argument).ok()
    }
    pub unsafe fn ChangeEngineState(&self, flags: u32, argument: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ChangeEngineState)(windows_core::Interface::as_raw(self), flags, argument).ok()
    }
    pub unsafe fn ChangeSymbolState(&self, flags: u32, argument: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ChangeSymbolState)(windows_core::Interface::as_raw(self), flags, argument).ok()
    }
}
#[repr(C)]
pub struct IDebugEventCallbacksWide_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetInterestMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Breakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Exception: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::EXCEPTION_RECORD64, u32) -> windows_core::HRESULT,
    pub CreateThread: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64) -> windows_core::HRESULT,
    pub ExitThread: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, u32, windows_core::PCWSTR, windows_core::PCWSTR, u32, u32, u64, u64, u64) -> windows_core::HRESULT,
    pub ExitProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub LoadModule: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u32, windows_core::PCWSTR, windows_core::PCWSTR, u32, u32) -> windows_core::HRESULT,
    pub UnloadModule: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64) -> windows_core::HRESULT,
    pub SystemError: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub SessionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ChangeDebuggeeState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64) -> windows_core::HRESULT,
    pub ChangeEngineState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64) -> windows_core::HRESULT,
    pub ChangeSymbolState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugEventContextCallbacks, IDebugEventContextCallbacks_Vtbl, 0x61a4905b_23f9_4247_b3c5_53d087529ab7);
impl std::ops::Deref for IDebugEventContextCallbacks {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugEventContextCallbacks, windows_core::IUnknown);
impl IDebugEventContextCallbacks {
    pub unsafe fn GetInterestMask(&self) -> windows_core::Result<u32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInterestMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Breakpoint<P0>(&self, bp: P0, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugBreakpoint2>,
    {
        (windows_core::Interface::vtable(self).Breakpoint)(windows_core::Interface::as_raw(self), bp.param().abi(), context, contextsize).ok()
    }
    pub unsafe fn Exception(&self, exception: *const super::EXCEPTION_RECORD64, firstchance: u32, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Exception)(windows_core::Interface::as_raw(self), exception, firstchance, context, contextsize).ok()
    }
    pub unsafe fn CreateThread(&self, handle: u64, dataoffset: u64, startoffset: u64, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CreateThread)(windows_core::Interface::as_raw(self), handle, dataoffset, startoffset, context, contextsize).ok()
    }
    pub unsafe fn ExitThread(&self, exitcode: u32, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ExitThread)(windows_core::Interface::as_raw(self), exitcode, context, contextsize).ok()
    }
    pub unsafe fn CreateProcessA<P0, P1>(&self, imagefilehandle: u64, handle: u64, baseoffset: u64, modulesize: u32, modulename: P0, imagename: P1, checksum: u32, timedatestamp: u32, initialthreadhandle: u64, threaddataoffset: u64, startoffset: u64, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), imagefilehandle, handle, baseoffset, modulesize, modulename.param().abi(), imagename.param().abi(), checksum, timedatestamp, initialthreadhandle, threaddataoffset, startoffset, context, contextsize).ok()
    }
    pub unsafe fn ExitProcess(&self, exitcode: u32, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ExitProcess)(windows_core::Interface::as_raw(self), exitcode, context, contextsize).ok()
    }
    pub unsafe fn LoadModule<P0, P1>(&self, imagefilehandle: u64, baseoffset: u64, modulesize: u32, modulename: P0, imagename: P1, checksum: u32, timedatestamp: u32, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).LoadModule)(windows_core::Interface::as_raw(self), imagefilehandle, baseoffset, modulesize, modulename.param().abi(), imagename.param().abi(), checksum, timedatestamp, context, contextsize).ok()
    }
    pub unsafe fn UnloadModule<P0>(&self, imagebasename: P0, baseoffset: u64, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).UnloadModule)(windows_core::Interface::as_raw(self), imagebasename.param().abi(), baseoffset, context, contextsize).ok()
    }
    pub unsafe fn SystemError(&self, error: u32, level: u32, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SystemError)(windows_core::Interface::as_raw(self), error, level, context, contextsize).ok()
    }
    pub unsafe fn SessionStatus(&self, status: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SessionStatus)(windows_core::Interface::as_raw(self), status).ok()
    }
    pub unsafe fn ChangeDebuggeeState(&self, flags: u32, argument: u64, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ChangeDebuggeeState)(windows_core::Interface::as_raw(self), flags, argument, context, contextsize).ok()
    }
    pub unsafe fn ChangeEngineState(&self, flags: u32, argument: u64, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ChangeEngineState)(windows_core::Interface::as_raw(self), flags, argument, context, contextsize).ok()
    }
    pub unsafe fn ChangeSymbolState(&self, flags: u32, argument: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ChangeSymbolState)(windows_core::Interface::as_raw(self), flags, argument).ok()
    }
}
#[repr(C)]
pub struct IDebugEventContextCallbacks_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetInterestMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Breakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Exception: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::EXCEPTION_RECORD64, u32, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub CreateThread: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitThread: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, u32, windows_core::PCWSTR, windows_core::PCWSTR, u32, u32, u64, u64, u64, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub LoadModule: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u32, windows_core::PCWSTR, windows_core::PCWSTR, u32, u32, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub UnloadModule: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SystemError: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SessionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ChangeDebuggeeState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ChangeEngineState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ChangeSymbolState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDebugFAEntryTags, IDebugFAEntryTags_Vtbl);
impl IDebugFAEntryTags {
    pub unsafe fn GetType(&self, tag: DEBUG_FLR_PARAM_TYPE) -> FA_ENTRY_TYPE {
        (windows_core::Interface::vtable(self).GetType)(windows_core::Interface::as_raw(self), tag)
    }
    pub unsafe fn SetType(&self, tag: DEBUG_FLR_PARAM_TYPE, entrytype: FA_ENTRY_TYPE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetType)(windows_core::Interface::as_raw(self), tag, entrytype).ok()
    }
    pub unsafe fn GetProperties(&self, tag: DEBUG_FLR_PARAM_TYPE, name: windows_core::PSTR, namesize: Option<*mut u32>, description: windows_core::PSTR, descsize: Option<*mut u32>, flags: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProperties)(windows_core::Interface::as_raw(self), tag, core::mem::transmute(name), core::mem::transmute(namesize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(description), core::mem::transmute(descsize.unwrap_or(std::ptr::null_mut())), core::mem::transmute(flags.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetProperties<P0, P1>(&self, tag: DEBUG_FLR_PARAM_TYPE, name: P0, description: P1, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetProperties)(windows_core::Interface::as_raw(self), tag, name.param().abi(), description.param().abi(), flags).ok()
    }
    pub unsafe fn GetTagByName<P0, P1>(&self, pluginid: P0, tagname: P1) -> windows_core::Result<DEBUG_FLR_PARAM_TYPE>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetTagByName)(windows_core::Interface::as_raw(self), pluginid.param().abi(), tagname.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn IsValidTagToSet(&self, tag: DEBUG_FLR_PARAM_TYPE) -> super::super::super::super::Foundation::BOOL {
        (windows_core::Interface::vtable(self).IsValidTagToSet)(windows_core::Interface::as_raw(self), tag)
    }
}
#[repr(C)]
pub struct IDebugFAEntryTags_Vtbl {
    pub GetType: unsafe extern "system" fn(*mut core::ffi::c_void, DEBUG_FLR_PARAM_TYPE) -> FA_ENTRY_TYPE,
    pub SetType: unsafe extern "system" fn(*mut core::ffi::c_void, DEBUG_FLR_PARAM_TYPE, FA_ENTRY_TYPE) -> windows_core::HRESULT,
    pub GetProperties: unsafe extern "system" fn(*mut core::ffi::c_void, DEBUG_FLR_PARAM_TYPE, windows_core::PSTR, *mut u32, windows_core::PSTR, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetProperties: unsafe extern "system" fn(*mut core::ffi::c_void, DEBUG_FLR_PARAM_TYPE, windows_core::PCSTR, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub GetTagByName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, windows_core::PCSTR, *mut DEBUG_FLR_PARAM_TYPE) -> windows_core::HRESULT,
    pub IsValidTagToSet: unsafe extern "system" fn(*mut core::ffi::c_void, DEBUG_FLR_PARAM_TYPE) -> super::super::super::super::Foundation::BOOL,
}
windows_core::imp::define_interface!(IDebugFailureAnalysis, IDebugFailureAnalysis_Vtbl, 0xed0de363_451f_4943_820c_62dccdfa7e6d);
impl std::ops::Deref for IDebugFailureAnalysis {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugFailureAnalysis, windows_core::IUnknown);
impl IDebugFailureAnalysis {
    pub unsafe fn GetFailureClass(&self) -> u32 {
        (windows_core::Interface::vtable(self).GetFailureClass)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetFailureType(&self) -> DEBUG_FAILURE_TYPE {
        (windows_core::Interface::vtable(self).GetFailureType)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetFailureCode(&self) -> u32 {
        (windows_core::Interface::vtable(self).GetFailureCode)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn Get(&self, tag: DEBUG_FLR_PARAM_TYPE) -> *mut FA_ENTRY {
        (windows_core::Interface::vtable(self).Get)(windows_core::Interface::as_raw(self), tag)
    }
    pub unsafe fn GetNext(&self, entry: *mut FA_ENTRY, tag: DEBUG_FLR_PARAM_TYPE, tagmask: DEBUG_FLR_PARAM_TYPE) -> *mut FA_ENTRY {
        (windows_core::Interface::vtable(self).GetNext)(windows_core::Interface::as_raw(self), entry, tag, tagmask)
    }
    pub unsafe fn GetString(&self, tag: DEBUG_FLR_PARAM_TYPE, str: &mut [u8]) -> *mut FA_ENTRY {
        (windows_core::Interface::vtable(self).GetString)(windows_core::Interface::as_raw(self), tag, core::mem::transmute(str.as_ptr()), str.len().try_into().unwrap())
    }
    pub unsafe fn GetBuffer(&self, tag: DEBUG_FLR_PARAM_TYPE, buf: *mut core::ffi::c_void, size: u32) -> *mut FA_ENTRY {
        (windows_core::Interface::vtable(self).GetBuffer)(windows_core::Interface::as_raw(self), tag, buf, size)
    }
    pub unsafe fn GetUlong(&self, tag: DEBUG_FLR_PARAM_TYPE, value: *mut u32) -> *mut FA_ENTRY {
        (windows_core::Interface::vtable(self).GetUlong)(windows_core::Interface::as_raw(self), tag, value)
    }
    pub unsafe fn GetUlong64(&self, tag: DEBUG_FLR_PARAM_TYPE, value: *mut u64) -> *mut FA_ENTRY {
        (windows_core::Interface::vtable(self).GetUlong64)(windows_core::Interface::as_raw(self), tag, value)
    }
    pub unsafe fn NextEntry(&self, entry: Option<*const FA_ENTRY>) -> *mut FA_ENTRY {
        (windows_core::Interface::vtable(self).NextEntry)(windows_core::Interface::as_raw(self), core::mem::transmute(entry.unwrap_or(std::ptr::null())))
    }
}
#[repr(C)]
pub struct IDebugFailureAnalysis_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetFailureClass: unsafe extern "system" fn(*mut core::ffi::c_void) -> u32,
    pub GetFailureType: unsafe extern "system" fn(*mut core::ffi::c_void) -> DEBUG_FAILURE_TYPE,
    pub GetFailureCode: unsafe extern "system" fn(*mut core::ffi::c_void) -> u32,
    pub Get: unsafe extern "system" fn(*mut core::ffi::c_void, DEBUG_FLR_PARAM_TYPE) -> *mut FA_ENTRY,
    pub GetNext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FA_ENTRY, DEBUG_FLR_PARAM_TYPE, DEBUG_FLR_PARAM_TYPE) -> *mut FA_ENTRY,
    pub GetString: unsafe extern "system" fn(*mut core::ffi::c_void, DEBUG_FLR_PARAM_TYPE, windows_core::PSTR, u32) -> *mut FA_ENTRY,
    pub GetBuffer: unsafe extern "system" fn(*mut core::ffi::c_void, DEBUG_FLR_PARAM_TYPE, *mut core::ffi::c_void, u32) -> *mut FA_ENTRY,
    pub GetUlong: unsafe extern "system" fn(*mut core::ffi::c_void, DEBUG_FLR_PARAM_TYPE, *mut u32) -> *mut FA_ENTRY,
    pub GetUlong64: unsafe extern "system" fn(*mut core::ffi::c_void, DEBUG_FLR_PARAM_TYPE, *mut u64) -> *mut FA_ENTRY,
    pub NextEntry: unsafe extern "system" fn(*mut core::ffi::c_void, *const FA_ENTRY) -> *mut FA_ENTRY,
}
windows_core::imp::define_interface!(IDebugFailureAnalysis2, IDebugFailureAnalysis2_Vtbl, 0xea15c288_8226_4b70_acf6_0be6b189e3ad);
impl std::ops::Deref for IDebugFailureAnalysis2 {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDebugFailureAnalysis2, windows_core::IUnknown);
impl IDebugFailureAnalysis2 {
    pub unsafe fn GetFailureClass(&self) -> u32 {
        (windows_core::Interface::vtable(self).GetFailureClass)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetFailureType(&self) -> DEBUG_FAILURE_TYPE {
        (windows_core::Interface::vtable(self).GetFailureType)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetFailureCode(&self) -> u32 {
        (windows_core::Interface::vtable(self).GetFailureCode)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn Get(&self, tag: DEBUG_FLR_PARAM_TYPE) -> *mut FA_ENTRY {
        (windows_core::Interfac