

/*
import("stdfaust.lib");

//==================== MAIN ================
// 60 model en parallèle via play% & freq%
process = par(j,10,onebell(j)):>_;

//==================== GUI SPECIFICATION ================

freq(j) = nentry("pitch%j",60+j,60,160,0.01):ba.midikey2hz;
select(j) = button("play%j")<:(>(mem));

//==================== SIGNAL PROCESSING ================
//----------------------- Algorithm implementation ----------------------------

//One resonance
resonance(x,j) = + : + (excitation(preset,x)*select(j)) : delayLine(x,j) : *(basegains(preset,x)) : *((freq(j)*modes(preset,x)) < (ma.SR/2)) : bandPassFilter(x,j);

// new process from Chris to simulate a simple bell
onebell(j) =
		//Bowed Excitation
		(select(j)) <:
		//nModes resonances with nModes feedbacks
		par(i,nModes,(resonance(i,j)~(*(fb)))) :>_
		with {
			fb = nentry("feedback",0.989,0,1,0.001);
		};

//----------------------- Synthesis parameters computing and functions declaration ----------------------------

//the number of modes depends on the preset being used
nModes = nMode(preset);

delayLengthBase(j) = ma.SR/freq(j);

//delay lengths in number of samples
delayLength(x,j) = delayLengthBase(j)/modes(preset,x);

//delay lines
delayLine(x,j) = de.delay(4096,delayLength(x,j));

//Filter bank: bandpass filters (declared in instrument.lib)
radius = 1 - ma.PI*32/ma.SR;

bandPassFilter(x,j) = bandpass(freq(j)*modes(preset,x),radius)
with {
    bandpass(resonance,radius) = fi.TF2(b0,b1,b2,a1,a2)
	with {
		a2 = radius*radius;
		a1 = -2*radius*cos(ma.PI*2*resonance/ma.SR);
		b0 = 0.5-0.5*a2;
		b1 = 0;
		b2 = -b0;
	};
};

//==================== MODAL PARAMETERS ================

preset = 0;

nMode(0) = 12;

modes(0,0) = 0.996108344;
basegains(0,0) = 0.999925960128219;
excitation(0,0) = 11.900357 / 10;

modes(0,1) = 1.0038916562;
basegains(0,1) = 0.999925960128219;
excitation(0,1) = 11.900357 / 10;

modes(0,2) = 2.979178;
basegains(0,2) = 0.999982774366897;
excitation(0,2) = 10.914886 / 10;

modes(0,3) = 2.99329767;
basegains(0,3) = 0.999982774366897;
excitation(0,3) = 10.914886 / 10;

modes(0,4) = 5.704452;
basegains(0,4) = 1.0;
excitation(0,4) = 42.995041 / 10;

modes(0,5) = 5.704452;
basegains(0,5) = 1.0;
excitation(0,5) = 42.995041 / 10;

modes(0,6) = 8.9982;
basegains(0,6) = 1.0;
excitation(0,6) = 40.063034 / 10;

modes(0,7) = 9.01549726;
basegains(0,7) = 1.0;
excitation(0,7) = 40.063034 / 10;

modes(0,8) = 12.83303;
basegains(0,8) = 0.999965497558225;
excitation(0,8) = 7.063034 / 10;

modes(0,9) = 12.807382;
basegains(0,9) = 0.999965497558225;
excitation(0,9) = 7.063034 / 10;

modes(0,10) = 17.2808219;
basegains(0,10) = 0.9999999999999999999965497558225;
excitation(0,10) = 57.063034 / 10;

modes(0,11) = 21.97602739726;
basegains(0,11) = 0.999999999999999965497558225;
excitation(0,11) = 57.063034 / 10;
*/



ID_0 = button("play0");
ID_1 = _, mem;
ID_2 = ID_1 : >;
ID_3 = ID_0 <: ID_2;
ID_4 = 1.1900357f, ID_3;
ID_5 = (ID_4 : *);
ID_6 = _, ID_5;
ID_7 = ID_6 : +;
ID_8 = _, 0.999926f;
ID_9 = ID_8 : *;
ID_10 = nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f);
ID_11 = (ID_10 : \(x2).(4.4e+02f,(2.0f,((x2,69.0f : -),12.0f : /) : pow) : *));
ID_12 = ID_11, 0.99610835f;
ID_13 = (ID_12 : *);
ID_14 = fconstant(int fSamplingFreq, <math.h>);
ID_15 = 1.0f, ID_14;
ID_16 = (ID_15 : max);
ID_17 = 1.92e+05f, ID_16;
ID_18 = (ID_17 : min);
ID_19 = ID_18, 2;
ID_20 = (ID_19 : /);
ID_21 = ID_13, ID_20;
ID_22 = (ID_21 : <);
ID_23 = _, ID_22;
ID_24 = ID_23 : *;
ID_25 = \(x485).(\(x486).(x486,x485 : -)) ~ \(x487).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x488).(4.4e+02f,(2.0f,((x488,69.0f : -),12.0f : /) : pow) : *)),0.99610835f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x487 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x487 : mem) : *) : +);
ID_26 = ID_25 : \(x489).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x489 : *),(0,(x489 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x489 : mem : mem) : *) : +);
ID_27 = ID_24 : ID_26;
ID_28 = ID_9 : ID_27;
ID_29 = \(x483).(x483,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),0.99610835f : /) : max) : min) : @) : ID_28;
ID_30 = ID_7 : ID_29;
ID_31 = (+ : ID_30);
ID_32 = nentry("feedback", 0.989f, 0.0f, 1.0f, 0.001f);
ID_33 = _, ID_32;
ID_34 = (ID_33 : *);
ID_35 = ID_31 ~ ID_34;
ID_36 = ID_11, 1.0038917f;
ID_37 = (ID_36 : *);
ID_38 = ID_37, ID_20;
ID_39 = (ID_38 : <);
ID_40 = _, ID_39;
ID_41 = ID_40 : *;
ID_42 = \(x491).(\(x492).(x492,x491 : -)) ~ \(x493).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x494).(4.4e+02f,(2.0f,((x494,69.0f : -),12.0f : /) : pow) : *)),1.0038917f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x493 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x493 : mem) : *) : +);
ID_43 = ID_42 : \(x495).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x495 : *),(0,(x495 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x495 : mem : mem) : *) : +);
ID_44 = ID_41 : ID_43;
ID_45 = ID_9 : ID_44;
ID_46 = \(x490).(x490,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),1.0038917f : /) : max) : min) : @) : ID_45;
ID_47 = ID_7 : ID_46;
ID_48 = (+ : ID_47);
ID_49 = ID_48 ~ ID_34;
ID_50 = 1.0914886f, ID_3;
ID_51 = (ID_50 : *);
ID_52 = _, ID_51;
ID_53 = ID_52 : +;
ID_54 = _, 0.9999828f;
ID_55 = ID_54 : *;
ID_56 = ID_11, 2.979178f;
ID_57 = (ID_56 : *);
ID_58 = ID_57, ID_20;
ID_59 = (ID_58 : <);
ID_60 = _, ID_59;
ID_61 = ID_60 : *;
ID_62 = \(x497).(\(x498).(x498,x497 : -)) ~ \(x499).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x500).(4.4e+02f,(2.0f,((x500,69.0f : -),12.0f : /) : pow) : *)),2.979178f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x499 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x499 : mem) : *) : +);
ID_63 = ID_62 : \(x501).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x501 : *),(0,(x501 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x501 : mem : mem) : *) : +);
ID_64 = ID_61 : ID_63;
ID_65 = ID_55 : ID_64;
ID_66 = \(x496).(x496,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.979178f : /) : max) : min) : @) : ID_65;
ID_67 = ID_53 : ID_66;
ID_68 = (+ : ID_67);
ID_69 = ID_68 ~ ID_34;
ID_70 = ID_11, 2.9932976f;
ID_71 = (ID_70 : *);
ID_72 = ID_71, ID_20;
ID_73 = (ID_72 : <);
ID_74 = _, ID_73;
ID_75 = ID_74 : *;
ID_76 = \(x503).(\(x504).(x504,x503 : -)) ~ \(x505).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x506).(4.4e+02f,(2.0f,((x506,69.0f : -),12.0f : /) : pow) : *)),2.9932976f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x505 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x505 : mem) : *) : +);
ID_77 = ID_76 : \(x507).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x507 : *),(0,(x507 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x507 : mem : mem) : *) : +);
ID_78 = ID_75 : ID_77;
ID_79 = ID_55 : ID_78;
ID_80 = \(x502).(x502,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.9932976f : /) : max) : min) : @) : ID_79;
ID_81 = ID_53 : ID_80;
ID_82 = (+ : ID_81);
ID_83 = ID_82 ~ ID_34;
ID_84 = 4.2995043f, ID_3;
ID_85 = (ID_84 : *);
ID_86 = _, ID_85;
ID_87 = ID_86 : +;
ID_88 = _, 1.0f;
ID_89 = ID_88 : *;
ID_90 = ID_11, 5.704452f;
ID_91 = (ID_90 : *);
ID_92 = ID_91, ID_20;
ID_93 = (ID_92 : <);
ID_94 = _, ID_93;
ID_95 = ID_94 : *;
ID_96 = \(x509).(\(x510).(x510,x509 : -)) ~ \(x511).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x512).(4.4e+02f,(2.0f,((x512,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x511 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x511 : mem) : *) : +);
ID_97 = ID_96 : \(x513).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x513 : *),(0,(x513 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x513 : mem : mem) : *) : +);
ID_98 = ID_95 : ID_97;
ID_99 = ID_89 : ID_98;
ID_100 = \(x508).(x508,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_99;
ID_101 = ID_87 : ID_100;
ID_102 = (+ : ID_101);
ID_103 = ID_102 ~ ID_34;
ID_104 = \(x515).(\(x516).(x516,x515 : -)) ~ \(x517).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x518).(4.4e+02f,(2.0f,((x518,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x517 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x517 : mem) : *) : +);
ID_105 = ID_104 : \(x519).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x519 : *),(0,(x519 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x519 : mem : mem) : *) : +);
ID_106 = ID_95 : ID_105;
ID_107 = ID_89 : ID_106;
ID_108 = \(x514).(x514,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_107;
ID_109 = ID_87 : ID_108;
ID_110 = (+ : ID_109);
ID_111 = ID_110 ~ ID_34;
ID_112 = 4.0063033f, ID_3;
ID_113 = (ID_112 : *);
ID_114 = _, ID_113;
ID_115 = ID_114 : +;
ID_116 = ID_11, 8.9982f;
ID_117 = (ID_116 : *);
ID_118 = ID_117, ID_20;
ID_119 = (ID_118 : <);
ID_120 = _, ID_119;
ID_121 = ID_120 : *;
ID_122 = \(x521).(\(x522).(x522,x521 : -)) ~ \(x523).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x524).(4.4e+02f,(2.0f,((x524,69.0f : -),12.0f : /) : pow) : *)),8.9982f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x523 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x523 : mem) : *) : +);
ID_123 = ID_122 : \(x525).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x525 : *),(0,(x525 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x525 : mem : mem) : *) : +);
ID_124 = ID_121 : ID_123;
ID_125 = ID_89 : ID_124;
ID_126 = \(x520).(x520,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),8.9982f : /) : max) : min) : @) : ID_125;
ID_127 = ID_115 : ID_126;
ID_128 = (+ : ID_127);
ID_129 = ID_128 ~ ID_34;
ID_130 = ID_11, 9.015497f;
ID_131 = (ID_130 : *);
ID_132 = ID_131, ID_20;
ID_133 = (ID_132 : <);
ID_134 = _, ID_133;
ID_135 = ID_134 : *;
ID_136 = \(x527).(\(x528).(x528,x527 : -)) ~ \(x529).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x530).(4.4e+02f,(2.0f,((x530,69.0f : -),12.0f : /) : pow) : *)),9.015497f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x529 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x529 : mem) : *) : +);
ID_137 = ID_136 : \(x531).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x531 : *),(0,(x531 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x531 : mem : mem) : *) : +);
ID_138 = ID_135 : ID_137;
ID_139 = ID_89 : ID_138;
ID_140 = \(x526).(x526,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),9.015497f : /) : max) : min) : @) : ID_139;
ID_141 = ID_115 : ID_140;
ID_142 = (+ : ID_141);
ID_143 = ID_142 ~ ID_34;
ID_144 = 0.7063034f, ID_3;
ID_145 = (ID_144 : *);
ID_146 = _, ID_145;
ID_147 = ID_146 : +;
ID_148 = _, 0.9999655f;
ID_149 = ID_148 : *;
ID_150 = ID_11, 12.83303f;
ID_151 = (ID_150 : *);
ID_152 = ID_151, ID_20;
ID_153 = (ID_152 : <);
ID_154 = _, ID_153;
ID_155 = ID_154 : *;
ID_156 = \(x533).(\(x534).(x534,x533 : -)) ~ \(x535).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x536).(4.4e+02f,(2.0f,((x536,69.0f : -),12.0f : /) : pow) : *)),12.83303f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x535 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x535 : mem) : *) : +);
ID_157 = ID_156 : \(x537).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x537 : *),(0,(x537 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x537 : mem : mem) : *) : +);
ID_158 = ID_155 : ID_157;
ID_159 = ID_149 : ID_158;
ID_160 = \(x532).(x532,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.83303f : /) : max) : min) : @) : ID_159;
ID_161 = ID_147 : ID_160;
ID_162 = (+ : ID_161);
ID_163 = ID_162 ~ ID_34;
ID_164 = ID_11, 12.807382f;
ID_165 = (ID_164 : *);
ID_166 = ID_165, ID_20;
ID_167 = (ID_166 : <);
ID_168 = _, ID_167;
ID_169 = ID_168 : *;
ID_170 = \(x539).(\(x540).(x540,x539 : -)) ~ \(x541).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x542).(4.4e+02f,(2.0f,((x542,69.0f : -),12.0f : /) : pow) : *)),12.807382f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x541 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x541 : mem) : *) : +);
ID_171 = ID_170 : \(x543).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x543 : *),(0,(x543 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x543 : mem : mem) : *) : +);
ID_172 = ID_169 : ID_171;
ID_173 = ID_149 : ID_172;
ID_174 = \(x538).(x538,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.807382f : /) : max) : min) : @) : ID_173;
ID_175 = ID_147 : ID_174;
ID_176 = (+ : ID_175);
ID_177 = ID_176 ~ ID_34;
ID_178 = 5.7063036f, ID_3;
ID_179 = (ID_178 : *);
ID_180 = _, ID_179;
ID_181 = ID_180 : +;
ID_182 = ID_11, 17.280823f;
ID_183 = (ID_182 : *);
ID_184 = ID_183, ID_20;
ID_185 = (ID_184 : <);
ID_186 = _, ID_185;
ID_187 = ID_186 : *;
ID_188 = \(x545).(\(x546).(x546,x545 : -)) ~ \(x547).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x548).(4.4e+02f,(2.0f,((x548,69.0f : -),12.0f : /) : pow) : *)),17.280823f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x547 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x547 : mem) : *) : +);
ID_189 = ID_188 : \(x549).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x549 : *),(0,(x549 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x549 : mem : mem) : *) : +);
ID_190 = ID_187 : ID_189;
ID_191 = ID_89 : ID_190;
ID_192 = \(x544).(x544,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),17.280823f : /) : max) : min) : @) : ID_191;
ID_193 = ID_181 : ID_192;
ID_194 = (+ : ID_193);
ID_195 = ID_194 ~ ID_34;
ID_196 = ID_11, 21.976027f;
ID_197 = (ID_196 : *);
ID_198 = ID_197, ID_20;
ID_199 = (ID_198 : <);
ID_200 = _, ID_199;
ID_201 = ID_200 : *;
ID_202 = \(x551).(\(x552).(x552,x551 : -)) ~ \(x553).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x554).(4.4e+02f,(2.0f,((x554,69.0f : -),12.0f : /) : pow) : *)),21.976027f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x553 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x553 : mem) : *) : +);
ID_203 = ID_202 : \(x555).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x555 : *),(0,(x555 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x555 : mem : mem) : *) : +);
ID_204 = ID_201 : ID_203;
ID_205 = ID_89 : ID_204;
ID_206 = \(x550).(x550,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch0", 6e+01f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),21.976027f : /) : max) : min) : @) : ID_205;
ID_207 = ID_181 : ID_206;
ID_208 = (+ : ID_207);
ID_209 = ID_208 ~ ID_34;
ID_210 = ID_195, ID_209;
ID_211 = ID_177, ID_210;
ID_212 = ID_163, ID_211;
ID_213 = ID_143, ID_212;
ID_214 = ID_129, ID_213;
ID_215 = ID_111, ID_214;
ID_216 = ID_103, ID_215;
ID_217 = ID_83, ID_216;
ID_218 = ID_69, ID_217;
ID_219 = ID_49, ID_218;
ID_220 = ID_35, ID_219;
ID_221 = ID_220 :> _;
ID_222 = (ID_3 <: ID_221);
ID_223 = button("play1");
ID_224 = ID_223 <: ID_2;
ID_225 = 1.1900357f, ID_224;
ID_226 = (ID_225 : *);
ID_227 = _, ID_226;
ID_228 = ID_227 : +;
ID_229 = nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f);
ID_230 = (ID_229 : \(x2).(4.4e+02f,(2.0f,((x2,69.0f : -),12.0f : /) : pow) : *));
ID_231 = ID_230, 0.99610835f;
ID_232 = (ID_231 : *);
ID_233 = ID_232, ID_20;
ID_234 = (ID_233 : <);
ID_235 = _, ID_234;
ID_236 = ID_235 : *;
ID_237 = \(x557).(\(x558).(x558,x557 : -)) ~ \(x559).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x560).(4.4e+02f,(2.0f,((x560,69.0f : -),12.0f : /) : pow) : *)),0.99610835f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x559 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x559 : mem) : *) : +);
ID_238 = ID_237 : \(x561).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x561 : *),(0,(x561 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x561 : mem : mem) : *) : +);
ID_239 = ID_236 : ID_238;
ID_240 = ID_9 : ID_239;
ID_241 = \(x556).(x556,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),0.99610835f : /) : max) : min) : @) : ID_240;
ID_242 = ID_228 : ID_241;
ID_243 = (+ : ID_242);
ID_244 = ID_243 ~ ID_34;
ID_245 = ID_230, 1.0038917f;
ID_246 = (ID_245 : *);
ID_247 = ID_246, ID_20;
ID_248 = (ID_247 : <);
ID_249 = _, ID_248;
ID_250 = ID_249 : *;
ID_251 = \(x563).(\(x564).(x564,x563 : -)) ~ \(x565).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x566).(4.4e+02f,(2.0f,((x566,69.0f : -),12.0f : /) : pow) : *)),1.0038917f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x565 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x565 : mem) : *) : +);
ID_252 = ID_251 : \(x567).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x567 : *),(0,(x567 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x567 : mem : mem) : *) : +);
ID_253 = ID_250 : ID_252;
ID_254 = ID_9 : ID_253;
ID_255 = \(x562).(x562,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),1.0038917f : /) : max) : min) : @) : ID_254;
ID_256 = ID_228 : ID_255;
ID_257 = (+ : ID_256);
ID_258 = ID_257 ~ ID_34;
ID_259 = 1.0914886f, ID_224;
ID_260 = (ID_259 : *);
ID_261 = _, ID_260;
ID_262 = ID_261 : +;
ID_263 = ID_230, 2.979178f;
ID_264 = (ID_263 : *);
ID_265 = ID_264, ID_20;
ID_266 = (ID_265 : <);
ID_267 = _, ID_266;
ID_268 = ID_267 : *;
ID_269 = \(x569).(\(x570).(x570,x569 : -)) ~ \(x571).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x572).(4.4e+02f,(2.0f,((x572,69.0f : -),12.0f : /) : pow) : *)),2.979178f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x571 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x571 : mem) : *) : +);
ID_270 = ID_269 : \(x573).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x573 : *),(0,(x573 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x573 : mem : mem) : *) : +);
ID_271 = ID_268 : ID_270;
ID_272 = ID_55 : ID_271;
ID_273 = \(x568).(x568,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.979178f : /) : max) : min) : @) : ID_272;
ID_274 = ID_262 : ID_273;
ID_275 = (+ : ID_274);
ID_276 = ID_275 ~ ID_34;
ID_277 = ID_230, 2.9932976f;
ID_278 = (ID_277 : *);
ID_279 = ID_278, ID_20;
ID_280 = (ID_279 : <);
ID_281 = _, ID_280;
ID_282 = ID_281 : *;
ID_283 = \(x575).(\(x576).(x576,x575 : -)) ~ \(x577).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x578).(4.4e+02f,(2.0f,((x578,69.0f : -),12.0f : /) : pow) : *)),2.9932976f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x577 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x577 : mem) : *) : +);
ID_284 = ID_283 : \(x579).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x579 : *),(0,(x579 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x579 : mem : mem) : *) : +);
ID_285 = ID_282 : ID_284;
ID_286 = ID_55 : ID_285;
ID_287 = \(x574).(x574,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.9932976f : /) : max) : min) : @) : ID_286;
ID_288 = ID_262 : ID_287;
ID_289 = (+ : ID_288);
ID_290 = ID_289 ~ ID_34;
ID_291 = 4.2995043f, ID_224;
ID_292 = (ID_291 : *);
ID_293 = _, ID_292;
ID_294 = ID_293 : +;
ID_295 = ID_230, 5.704452f;
ID_296 = (ID_295 : *);
ID_297 = ID_296, ID_20;
ID_298 = (ID_297 : <);
ID_299 = _, ID_298;
ID_300 = ID_299 : *;
ID_301 = \(x581).(\(x582).(x582,x581 : -)) ~ \(x583).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x584).(4.4e+02f,(2.0f,((x584,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x583 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x583 : mem) : *) : +);
ID_302 = ID_301 : \(x585).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x585 : *),(0,(x585 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x585 : mem : mem) : *) : +);
ID_303 = ID_300 : ID_302;
ID_304 = ID_89 : ID_303;
ID_305 = \(x580).(x580,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_304;
ID_306 = ID_294 : ID_305;
ID_307 = (+ : ID_306);
ID_308 = ID_307 ~ ID_34;
ID_309 = \(x587).(\(x588).(x588,x587 : -)) ~ \(x589).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x590).(4.4e+02f,(2.0f,((x590,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x589 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x589 : mem) : *) : +);
ID_310 = ID_309 : \(x591).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x591 : *),(0,(x591 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x591 : mem : mem) : *) : +);
ID_311 = ID_300 : ID_310;
ID_312 = ID_89 : ID_311;
ID_313 = \(x586).(x586,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_312;
ID_314 = ID_294 : ID_313;
ID_315 = (+ : ID_314);
ID_316 = ID_315 ~ ID_34;
ID_317 = 4.0063033f, ID_224;
ID_318 = (ID_317 : *);
ID_319 = _, ID_318;
ID_320 = ID_319 : +;
ID_321 = ID_230, 8.9982f;
ID_322 = (ID_321 : *);
ID_323 = ID_322, ID_20;
ID_324 = (ID_323 : <);
ID_325 = _, ID_324;
ID_326 = ID_325 : *;
ID_327 = \(x593).(\(x594).(x594,x593 : -)) ~ \(x595).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x596).(4.4e+02f,(2.0f,((x596,69.0f : -),12.0f : /) : pow) : *)),8.9982f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x595 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x595 : mem) : *) : +);
ID_328 = ID_327 : \(x597).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x597 : *),(0,(x597 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x597 : mem : mem) : *) : +);
ID_329 = ID_326 : ID_328;
ID_330 = ID_89 : ID_329;
ID_331 = \(x592).(x592,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),8.9982f : /) : max) : min) : @) : ID_330;
ID_332 = ID_320 : ID_331;
ID_333 = (+ : ID_332);
ID_334 = ID_333 ~ ID_34;
ID_335 = ID_230, 9.015497f;
ID_336 = (ID_335 : *);
ID_337 = ID_336, ID_20;
ID_338 = (ID_337 : <);
ID_339 = _, ID_338;
ID_340 = ID_339 : *;
ID_341 = \(x599).(\(x600).(x600,x599 : -)) ~ \(x601).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x602).(4.4e+02f,(2.0f,((x602,69.0f : -),12.0f : /) : pow) : *)),9.015497f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x601 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x601 : mem) : *) : +);
ID_342 = ID_341 : \(x603).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x603 : *),(0,(x603 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x603 : mem : mem) : *) : +);
ID_343 = ID_340 : ID_342;
ID_344 = ID_89 : ID_343;
ID_345 = \(x598).(x598,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),9.015497f : /) : max) : min) : @) : ID_344;
ID_346 = ID_320 : ID_345;
ID_347 = (+ : ID_346);
ID_348 = ID_347 ~ ID_34;
ID_349 = 0.7063034f, ID_224;
ID_350 = (ID_349 : *);
ID_351 = _, ID_350;
ID_352 = ID_351 : +;
ID_353 = ID_230, 12.83303f;
ID_354 = (ID_353 : *);
ID_355 = ID_354, ID_20;
ID_356 = (ID_355 : <);
ID_357 = _, ID_356;
ID_358 = ID_357 : *;
ID_359 = \(x605).(\(x606).(x606,x605 : -)) ~ \(x607).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x608).(4.4e+02f,(2.0f,((x608,69.0f : -),12.0f : /) : pow) : *)),12.83303f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x607 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x607 : mem) : *) : +);
ID_360 = ID_359 : \(x609).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x609 : *),(0,(x609 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x609 : mem : mem) : *) : +);
ID_361 = ID_358 : ID_360;
ID_362 = ID_149 : ID_361;
ID_363 = \(x604).(x604,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.83303f : /) : max) : min) : @) : ID_362;
ID_364 = ID_352 : ID_363;
ID_365 = (+ : ID_364);
ID_366 = ID_365 ~ ID_34;
ID_367 = ID_230, 12.807382f;
ID_368 = (ID_367 : *);
ID_369 = ID_368, ID_20;
ID_370 = (ID_369 : <);
ID_371 = _, ID_370;
ID_372 = ID_371 : *;
ID_373 = \(x611).(\(x612).(x612,x611 : -)) ~ \(x613).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x614).(4.4e+02f,(2.0f,((x614,69.0f : -),12.0f : /) : pow) : *)),12.807382f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x613 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x613 : mem) : *) : +);
ID_374 = ID_373 : \(x615).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x615 : *),(0,(x615 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x615 : mem : mem) : *) : +);
ID_375 = ID_372 : ID_374;
ID_376 = ID_149 : ID_375;
ID_377 = \(x610).(x610,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.807382f : /) : max) : min) : @) : ID_376;
ID_378 = ID_352 : ID_377;
ID_379 = (+ : ID_378);
ID_380 = ID_379 ~ ID_34;
ID_381 = 5.7063036f, ID_224;
ID_382 = (ID_381 : *);
ID_383 = _, ID_382;
ID_384 = ID_383 : +;
ID_385 = ID_230, 17.280823f;
ID_386 = (ID_385 : *);
ID_387 = ID_386, ID_20;
ID_388 = (ID_387 : <);
ID_389 = _, ID_388;
ID_390 = ID_389 : *;
ID_391 = \(x617).(\(x618).(x618,x617 : -)) ~ \(x619).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x620).(4.4e+02f,(2.0f,((x620,69.0f : -),12.0f : /) : pow) : *)),17.280823f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x619 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x619 : mem) : *) : +);
ID_392 = ID_391 : \(x621).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x621 : *),(0,(x621 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x621 : mem : mem) : *) : +);
ID_393 = ID_390 : ID_392;
ID_394 = ID_89 : ID_393;
ID_395 = \(x616).(x616,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),17.280823f : /) : max) : min) : @) : ID_394;
ID_396 = ID_384 : ID_395;
ID_397 = (+ : ID_396);
ID_398 = ID_397 ~ ID_34;
ID_399 = ID_230, 21.976027f;
ID_400 = (ID_399 : *);
ID_401 = ID_400, ID_20;
ID_402 = (ID_401 : <);
ID_403 = _, ID_402;
ID_404 = ID_403 : *;
ID_405 = \(x623).(\(x624).(x624,x623 : -)) ~ \(x625).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x626).(4.4e+02f,(2.0f,((x626,69.0f : -),12.0f : /) : pow) : *)),21.976027f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x625 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x625 : mem) : *) : +);
ID_406 = ID_405 : \(x627).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x627 : *),(0,(x627 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x627 : mem : mem) : *) : +);
ID_407 = ID_404 : ID_406;
ID_408 = ID_89 : ID_407;
ID_409 = \(x622).(x622,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch1", 61.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),21.976027f : /) : max) : min) : @) : ID_408;
ID_410 = ID_384 : ID_409;
ID_411 = (+ : ID_410);
ID_412 = ID_411 ~ ID_34;
ID_413 = ID_398, ID_412;
ID_414 = ID_380, ID_413;
ID_415 = ID_366, ID_414;
ID_416 = ID_348, ID_415;
ID_417 = ID_334, ID_416;
ID_418 = ID_316, ID_417;
ID_419 = ID_308, ID_418;
ID_420 = ID_290, ID_419;
ID_421 = ID_276, ID_420;
ID_422 = ID_258, ID_421;
ID_423 = ID_244, ID_422;
ID_424 = ID_423 :> _;
ID_425 = (ID_224 <: ID_424);
ID_426 = button("play2");
ID_427 = ID_426 <: ID_2;
ID_428 = 1.1900357f, ID_427;
ID_429 = (ID_428 : *);
ID_430 = _, ID_429;
ID_431 = ID_430 : +;
ID_432 = nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f);
ID_433 = (ID_432 : \(x2).(4.4e+02f,(2.0f,((x2,69.0f : -),12.0f : /) : pow) : *));
ID_434 = ID_433, 0.99610835f;
ID_435 = (ID_434 : *);
ID_436 = ID_435, ID_20;
ID_437 = (ID_436 : <);
ID_438 = _, ID_437;
ID_439 = ID_438 : *;
ID_440 = \(x629).(\(x630).(x630,x629 : -)) ~ \(x631).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x632).(4.4e+02f,(2.0f,((x632,69.0f : -),12.0f : /) : pow) : *)),0.99610835f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x631 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x631 : mem) : *) : +);
ID_441 = ID_440 : \(x633).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x633 : *),(0,(x633 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x633 : mem : mem) : *) : +);
ID_442 = ID_439 : ID_441;
ID_443 = ID_9 : ID_442;
ID_444 = \(x628).(x628,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),0.99610835f : /) : max) : min) : @) : ID_443;
ID_445 = ID_431 : ID_444;
ID_446 = (+ : ID_445);
ID_447 = ID_446 ~ ID_34;
ID_448 = ID_433, 1.0038917f;
ID_449 = (ID_448 : *);
ID_450 = ID_449, ID_20;
ID_451 = (ID_450 : <);
ID_452 = _, ID_451;
ID_453 = ID_452 : *;
ID_454 = \(x635).(\(x636).(x636,x635 : -)) ~ \(x637).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x638).(4.4e+02f,(2.0f,((x638,69.0f : -),12.0f : /) : pow) : *)),1.0038917f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x637 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x637 : mem) : *) : +);
ID_455 = ID_454 : \(x639).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x639 : *),(0,(x639 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x639 : mem : mem) : *) : +);
ID_456 = ID_453 : ID_455;
ID_457 = ID_9 : ID_456;
ID_458 = \(x634).(x634,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),1.0038917f : /) : max) : min) : @) : ID_457;
ID_459 = ID_431 : ID_458;
ID_460 = (+ : ID_459);
ID_461 = ID_460 ~ ID_34;
ID_462 = 1.0914886f, ID_427;
ID_463 = (ID_462 : *);
ID_464 = _, ID_463;
ID_465 = ID_464 : +;
ID_466 = ID_433, 2.979178f;
ID_467 = (ID_466 : *);
ID_468 = ID_467, ID_20;
ID_469 = (ID_468 : <);
ID_470 = _, ID_469;
ID_471 = ID_470 : *;
ID_472 = \(x641).(\(x642).(x642,x641 : -)) ~ \(x643).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x644).(4.4e+02f,(2.0f,((x644,69.0f : -),12.0f : /) : pow) : *)),2.979178f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x643 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x643 : mem) : *) : +);
ID_473 = ID_472 : \(x645).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x645 : *),(0,(x645 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x645 : mem : mem) : *) : +);
ID_474 = ID_471 : ID_473;
ID_475 = ID_55 : ID_474;
ID_476 = \(x640).(x640,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.979178f : /) : max) : min) : @) : ID_475;
ID_477 = ID_465 : ID_476;
ID_478 = (+ : ID_477);
ID_479 = ID_478 ~ ID_34;
ID_480 = ID_433, 2.9932976f;
ID_481 = (ID_480 : *);
ID_482 = ID_481, ID_20;
ID_483 = (ID_482 : <);
ID_484 = _, ID_483;
ID_485 = ID_484 : *;
ID_486 = \(x647).(\(x648).(x648,x647 : -)) ~ \(x649).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x650).(4.4e+02f,(2.0f,((x650,69.0f : -),12.0f : /) : pow) : *)),2.9932976f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x649 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x649 : mem) : *) : +);
ID_487 = ID_486 : \(x651).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x651 : *),(0,(x651 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x651 : mem : mem) : *) : +);
ID_488 = ID_485 : ID_487;
ID_489 = ID_55 : ID_488;
ID_490 = \(x646).(x646,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.9932976f : /) : max) : min) : @) : ID_489;
ID_491 = ID_465 : ID_490;
ID_492 = (+ : ID_491);
ID_493 = ID_492 ~ ID_34;
ID_494 = 4.2995043f, ID_427;
ID_495 = (ID_494 : *);
ID_496 = _, ID_495;
ID_497 = ID_496 : +;
ID_498 = ID_433, 5.704452f;
ID_499 = (ID_498 : *);
ID_500 = ID_499, ID_20;
ID_501 = (ID_500 : <);
ID_502 = _, ID_501;
ID_503 = ID_502 : *;
ID_504 = \(x653).(\(x654).(x654,x653 : -)) ~ \(x655).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x656).(4.4e+02f,(2.0f,((x656,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x655 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x655 : mem) : *) : +);
ID_505 = ID_504 : \(x657).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x657 : *),(0,(x657 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x657 : mem : mem) : *) : +);
ID_506 = ID_503 : ID_505;
ID_507 = ID_89 : ID_506;
ID_508 = \(x652).(x652,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_507;
ID_509 = ID_497 : ID_508;
ID_510 = (+ : ID_509);
ID_511 = ID_510 ~ ID_34;
ID_512 = \(x659).(\(x660).(x660,x659 : -)) ~ \(x661).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x662).(4.4e+02f,(2.0f,((x662,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x661 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x661 : mem) : *) : +);
ID_513 = ID_512 : \(x663).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x663 : *),(0,(x663 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x663 : mem : mem) : *) : +);
ID_514 = ID_503 : ID_513;
ID_515 = ID_89 : ID_514;
ID_516 = \(x658).(x658,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_515;
ID_517 = ID_497 : ID_516;
ID_518 = (+ : ID_517);
ID_519 = ID_518 ~ ID_34;
ID_520 = 4.0063033f, ID_427;
ID_521 = (ID_520 : *);
ID_522 = _, ID_521;
ID_523 = ID_522 : +;
ID_524 = ID_433, 8.9982f;
ID_525 = (ID_524 : *);
ID_526 = ID_525, ID_20;
ID_527 = (ID_526 : <);
ID_528 = _, ID_527;
ID_529 = ID_528 : *;
ID_530 = \(x665).(\(x666).(x666,x665 : -)) ~ \(x667).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x668).(4.4e+02f,(2.0f,((x668,69.0f : -),12.0f : /) : pow) : *)),8.9982f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x667 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x667 : mem) : *) : +);
ID_531 = ID_530 : \(x669).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x669 : *),(0,(x669 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x669 : mem : mem) : *) : +);
ID_532 = ID_529 : ID_531;
ID_533 = ID_89 : ID_532;
ID_534 = \(x664).(x664,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),8.9982f : /) : max) : min) : @) : ID_533;
ID_535 = ID_523 : ID_534;
ID_536 = (+ : ID_535);
ID_537 = ID_536 ~ ID_34;
ID_538 = ID_433, 9.015497f;
ID_539 = (ID_538 : *);
ID_540 = ID_539, ID_20;
ID_541 = (ID_540 : <);
ID_542 = _, ID_541;
ID_543 = ID_542 : *;
ID_544 = \(x671).(\(x672).(x672,x671 : -)) ~ \(x673).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x674).(4.4e+02f,(2.0f,((x674,69.0f : -),12.0f : /) : pow) : *)),9.015497f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x673 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x673 : mem) : *) : +);
ID_545 = ID_544 : \(x675).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x675 : *),(0,(x675 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x675 : mem : mem) : *) : +);
ID_546 = ID_543 : ID_545;
ID_547 = ID_89 : ID_546;
ID_548 = \(x670).(x670,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),9.015497f : /) : max) : min) : @) : ID_547;
ID_549 = ID_523 : ID_548;
ID_550 = (+ : ID_549);
ID_551 = ID_550 ~ ID_34;
ID_552 = 0.7063034f, ID_427;
ID_553 = (ID_552 : *);
ID_554 = _, ID_553;
ID_555 = ID_554 : +;
ID_556 = ID_433, 12.83303f;
ID_557 = (ID_556 : *);
ID_558 = ID_557, ID_20;
ID_559 = (ID_558 : <);
ID_560 = _, ID_559;
ID_561 = ID_560 : *;
ID_562 = \(x677).(\(x678).(x678,x677 : -)) ~ \(x679).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x680).(4.4e+02f,(2.0f,((x680,69.0f : -),12.0f : /) : pow) : *)),12.83303f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x679 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x679 : mem) : *) : +);
ID_563 = ID_562 : \(x681).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x681 : *),(0,(x681 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x681 : mem : mem) : *) : +);
ID_564 = ID_561 : ID_563;
ID_565 = ID_149 : ID_564;
ID_566 = \(x676).(x676,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.83303f : /) : max) : min) : @) : ID_565;
ID_567 = ID_555 : ID_566;
ID_568 = (+ : ID_567);
ID_569 = ID_568 ~ ID_34;
ID_570 = ID_433, 12.807382f;
ID_571 = (ID_570 : *);
ID_572 = ID_571, ID_20;
ID_573 = (ID_572 : <);
ID_574 = _, ID_573;
ID_575 = ID_574 : *;
ID_576 = \(x683).(\(x684).(x684,x683 : -)) ~ \(x685).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x686).(4.4e+02f,(2.0f,((x686,69.0f : -),12.0f : /) : pow) : *)),12.807382f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x685 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x685 : mem) : *) : +);
ID_577 = ID_576 : \(x687).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x687 : *),(0,(x687 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x687 : mem : mem) : *) : +);
ID_578 = ID_575 : ID_577;
ID_579 = ID_149 : ID_578;
ID_580 = \(x682).(x682,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.807382f : /) : max) : min) : @) : ID_579;
ID_581 = ID_555 : ID_580;
ID_582 = (+ : ID_581);
ID_583 = ID_582 ~ ID_34;
ID_584 = 5.7063036f, ID_427;
ID_585 = (ID_584 : *);
ID_586 = _, ID_585;
ID_587 = ID_586 : +;
ID_588 = ID_433, 17.280823f;
ID_589 = (ID_588 : *);
ID_590 = ID_589, ID_20;
ID_591 = (ID_590 : <);
ID_592 = _, ID_591;
ID_593 = ID_592 : *;
ID_594 = \(x689).(\(x690).(x690,x689 : -)) ~ \(x691).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x692).(4.4e+02f,(2.0f,((x692,69.0f : -),12.0f : /) : pow) : *)),17.280823f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x691 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x691 : mem) : *) : +);
ID_595 = ID_594 : \(x693).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x693 : *),(0,(x693 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x693 : mem : mem) : *) : +);
ID_596 = ID_593 : ID_595;
ID_597 = ID_89 : ID_596;
ID_598 = \(x688).(x688,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),17.280823f : /) : max) : min) : @) : ID_597;
ID_599 = ID_587 : ID_598;
ID_600 = (+ : ID_599);
ID_601 = ID_600 ~ ID_34;
ID_602 = ID_433, 21.976027f;
ID_603 = (ID_602 : *);
ID_604 = ID_603, ID_20;
ID_605 = (ID_604 : <);
ID_606 = _, ID_605;
ID_607 = ID_606 : *;
ID_608 = \(x695).(\(x696).(x696,x695 : -)) ~ \(x697).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x698).(4.4e+02f,(2.0f,((x698,69.0f : -),12.0f : /) : pow) : *)),21.976027f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x697 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x697 : mem) : *) : +);
ID_609 = ID_608 : \(x699).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x699 : *),(0,(x699 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x699 : mem : mem) : *) : +);
ID_610 = ID_607 : ID_609;
ID_611 = ID_89 : ID_610;
ID_612 = \(x694).(x694,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch2", 62.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),21.976027f : /) : max) : min) : @) : ID_611;
ID_613 = ID_587 : ID_612;
ID_614 = (+ : ID_613);
ID_615 = ID_614 ~ ID_34;
ID_616 = ID_601, ID_615;
ID_617 = ID_583, ID_616;
ID_618 = ID_569, ID_617;
ID_619 = ID_551, ID_618;
ID_620 = ID_537, ID_619;
ID_621 = ID_519, ID_620;
ID_622 = ID_511, ID_621;
ID_623 = ID_493, ID_622;
ID_624 = ID_479, ID_623;
ID_625 = ID_461, ID_624;
ID_626 = ID_447, ID_625;
ID_627 = ID_626 :> _;
ID_628 = (ID_427 <: ID_627);
ID_629 = button("play3");
ID_630 = ID_629 <: ID_2;
ID_631 = 1.1900357f, ID_630;
ID_632 = (ID_631 : *);
ID_633 = _, ID_632;
ID_634 = ID_633 : +;
ID_635 = nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f);
ID_636 = (ID_635 : \(x2).(4.4e+02f,(2.0f,((x2,69.0f : -),12.0f : /) : pow) : *));
ID_637 = ID_636, 0.99610835f;
ID_638 = (ID_637 : *);
ID_639 = ID_638, ID_20;
ID_640 = (ID_639 : <);
ID_641 = _, ID_640;
ID_642 = ID_641 : *;
ID_643 = \(x701).(\(x702).(x702,x701 : -)) ~ \(x703).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x704).(4.4e+02f,(2.0f,((x704,69.0f : -),12.0f : /) : pow) : *)),0.99610835f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x703 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x703 : mem) : *) : +);
ID_644 = ID_643 : \(x705).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x705 : *),(0,(x705 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x705 : mem : mem) : *) : +);
ID_645 = ID_642 : ID_644;
ID_646 = ID_9 : ID_645;
ID_647 = \(x700).(x700,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),0.99610835f : /) : max) : min) : @) : ID_646;
ID_648 = ID_634 : ID_647;
ID_649 = (+ : ID_648);
ID_650 = ID_649 ~ ID_34;
ID_651 = ID_636, 1.0038917f;
ID_652 = (ID_651 : *);
ID_653 = ID_652, ID_20;
ID_654 = (ID_653 : <);
ID_655 = _, ID_654;
ID_656 = ID_655 : *;
ID_657 = \(x707).(\(x708).(x708,x707 : -)) ~ \(x709).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x710).(4.4e+02f,(2.0f,((x710,69.0f : -),12.0f : /) : pow) : *)),1.0038917f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x709 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x709 : mem) : *) : +);
ID_658 = ID_657 : \(x711).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x711 : *),(0,(x711 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x711 : mem : mem) : *) : +);
ID_659 = ID_656 : ID_658;
ID_660 = ID_9 : ID_659;
ID_661 = \(x706).(x706,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),1.0038917f : /) : max) : min) : @) : ID_660;
ID_662 = ID_634 : ID_661;
ID_663 = (+ : ID_662);
ID_664 = ID_663 ~ ID_34;
ID_665 = 1.0914886f, ID_630;
ID_666 = (ID_665 : *);
ID_667 = _, ID_666;
ID_668 = ID_667 : +;
ID_669 = ID_636, 2.979178f;
ID_670 = (ID_669 : *);
ID_671 = ID_670, ID_20;
ID_672 = (ID_671 : <);
ID_673 = _, ID_672;
ID_674 = ID_673 : *;
ID_675 = \(x713).(\(x714).(x714,x713 : -)) ~ \(x715).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x716).(4.4e+02f,(2.0f,((x716,69.0f : -),12.0f : /) : pow) : *)),2.979178f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x715 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x715 : mem) : *) : +);
ID_676 = ID_675 : \(x717).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x717 : *),(0,(x717 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x717 : mem : mem) : *) : +);
ID_677 = ID_674 : ID_676;
ID_678 = ID_55 : ID_677;
ID_679 = \(x712).(x712,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.979178f : /) : max) : min) : @) : ID_678;
ID_680 = ID_668 : ID_679;
ID_681 = (+ : ID_680);
ID_682 = ID_681 ~ ID_34;
ID_683 = ID_636, 2.9932976f;
ID_684 = (ID_683 : *);
ID_685 = ID_684, ID_20;
ID_686 = (ID_685 : <);
ID_687 = _, ID_686;
ID_688 = ID_687 : *;
ID_689 = \(x719).(\(x720).(x720,x719 : -)) ~ \(x721).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x722).(4.4e+02f,(2.0f,((x722,69.0f : -),12.0f : /) : pow) : *)),2.9932976f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x721 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x721 : mem) : *) : +);
ID_690 = ID_689 : \(x723).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x723 : *),(0,(x723 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x723 : mem : mem) : *) : +);
ID_691 = ID_688 : ID_690;
ID_692 = ID_55 : ID_691;
ID_693 = \(x718).(x718,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.9932976f : /) : max) : min) : @) : ID_692;
ID_694 = ID_668 : ID_693;
ID_695 = (+ : ID_694);
ID_696 = ID_695 ~ ID_34;
ID_697 = 4.2995043f, ID_630;
ID_698 = (ID_697 : *);
ID_699 = _, ID_698;
ID_700 = ID_699 : +;
ID_701 = ID_636, 5.704452f;
ID_702 = (ID_701 : *);
ID_703 = ID_702, ID_20;
ID_704 = (ID_703 : <);
ID_705 = _, ID_704;
ID_706 = ID_705 : *;
ID_707 = \(x725).(\(x726).(x726,x725 : -)) ~ \(x727).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x728).(4.4e+02f,(2.0f,((x728,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x727 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x727 : mem) : *) : +);
ID_708 = ID_707 : \(x729).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x729 : *),(0,(x729 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x729 : mem : mem) : *) : +);
ID_709 = ID_706 : ID_708;
ID_710 = ID_89 : ID_709;
ID_711 = \(x724).(x724,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_710;
ID_712 = ID_700 : ID_711;
ID_713 = (+ : ID_712);
ID_714 = ID_713 ~ ID_34;
ID_715 = \(x731).(\(x732).(x732,x731 : -)) ~ \(x733).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x734).(4.4e+02f,(2.0f,((x734,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x733 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x733 : mem) : *) : +);
ID_716 = ID_715 : \(x735).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x735 : *),(0,(x735 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x735 : mem : mem) : *) : +);
ID_717 = ID_706 : ID_716;
ID_718 = ID_89 : ID_717;
ID_719 = \(x730).(x730,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_718;
ID_720 = ID_700 : ID_719;
ID_721 = (+ : ID_720);
ID_722 = ID_721 ~ ID_34;
ID_723 = 4.0063033f, ID_630;
ID_724 = (ID_723 : *);
ID_725 = _, ID_724;
ID_726 = ID_725 : +;
ID_727 = ID_636, 8.9982f;
ID_728 = (ID_727 : *);
ID_729 = ID_728, ID_20;
ID_730 = (ID_729 : <);
ID_731 = _, ID_730;
ID_732 = ID_731 : *;
ID_733 = \(x737).(\(x738).(x738,x737 : -)) ~ \(x739).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x740).(4.4e+02f,(2.0f,((x740,69.0f : -),12.0f : /) : pow) : *)),8.9982f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x739 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x739 : mem) : *) : +);
ID_734 = ID_733 : \(x741).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x741 : *),(0,(x741 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x741 : mem : mem) : *) : +);
ID_735 = ID_732 : ID_734;
ID_736 = ID_89 : ID_735;
ID_737 = \(x736).(x736,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),8.9982f : /) : max) : min) : @) : ID_736;
ID_738 = ID_726 : ID_737;
ID_739 = (+ : ID_738);
ID_740 = ID_739 ~ ID_34;
ID_741 = ID_636, 9.015497f;
ID_742 = (ID_741 : *);
ID_743 = ID_742, ID_20;
ID_744 = (ID_743 : <);
ID_745 = _, ID_744;
ID_746 = ID_745 : *;
ID_747 = \(x743).(\(x744).(x744,x743 : -)) ~ \(x745).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x746).(4.4e+02f,(2.0f,((x746,69.0f : -),12.0f : /) : pow) : *)),9.015497f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x745 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x745 : mem) : *) : +);
ID_748 = ID_747 : \(x747).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x747 : *),(0,(x747 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x747 : mem : mem) : *) : +);
ID_749 = ID_746 : ID_748;
ID_750 = ID_89 : ID_749;
ID_751 = \(x742).(x742,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),9.015497f : /) : max) : min) : @) : ID_750;
ID_752 = ID_726 : ID_751;
ID_753 = (+ : ID_752);
ID_754 = ID_753 ~ ID_34;
ID_755 = 0.7063034f, ID_630;
ID_756 = (ID_755 : *);
ID_757 = _, ID_756;
ID_758 = ID_757 : +;
ID_759 = ID_636, 12.83303f;
ID_760 = (ID_759 : *);
ID_761 = ID_760, ID_20;
ID_762 = (ID_761 : <);
ID_763 = _, ID_762;
ID_764 = ID_763 : *;
ID_765 = \(x749).(\(x750).(x750,x749 : -)) ~ \(x751).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x752).(4.4e+02f,(2.0f,((x752,69.0f : -),12.0f : /) : pow) : *)),12.83303f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x751 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x751 : mem) : *) : +);
ID_766 = ID_765 : \(x753).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x753 : *),(0,(x753 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x753 : mem : mem) : *) : +);
ID_767 = ID_764 : ID_766;
ID_768 = ID_149 : ID_767;
ID_769 = \(x748).(x748,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.83303f : /) : max) : min) : @) : ID_768;
ID_770 = ID_758 : ID_769;
ID_771 = (+ : ID_770);
ID_772 = ID_771 ~ ID_34;
ID_773 = ID_636, 12.807382f;
ID_774 = (ID_773 : *);
ID_775 = ID_774, ID_20;
ID_776 = (ID_775 : <);
ID_777 = _, ID_776;
ID_778 = ID_777 : *;
ID_779 = \(x755).(\(x756).(x756,x755 : -)) ~ \(x757).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x758).(4.4e+02f,(2.0f,((x758,69.0f : -),12.0f : /) : pow) : *)),12.807382f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x757 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x757 : mem) : *) : +);
ID_780 = ID_779 : \(x759).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x759 : *),(0,(x759 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x759 : mem : mem) : *) : +);
ID_781 = ID_778 : ID_780;
ID_782 = ID_149 : ID_781;
ID_783 = \(x754).(x754,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.807382f : /) : max) : min) : @) : ID_782;
ID_784 = ID_758 : ID_783;
ID_785 = (+ : ID_784);
ID_786 = ID_785 ~ ID_34;
ID_787 = 5.7063036f, ID_630;
ID_788 = (ID_787 : *);
ID_789 = _, ID_788;
ID_790 = ID_789 : +;
ID_791 = ID_636, 17.280823f;
ID_792 = (ID_791 : *);
ID_793 = ID_792, ID_20;
ID_794 = (ID_793 : <);
ID_795 = _, ID_794;
ID_796 = ID_795 : *;
ID_797 = \(x761).(\(x762).(x762,x761 : -)) ~ \(x763).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x764).(4.4e+02f,(2.0f,((x764,69.0f : -),12.0f : /) : pow) : *)),17.280823f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x763 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x763 : mem) : *) : +);
ID_798 = ID_797 : \(x765).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x765 : *),(0,(x765 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x765 : mem : mem) : *) : +);
ID_799 = ID_796 : ID_798;
ID_800 = ID_89 : ID_799;
ID_801 = \(x760).(x760,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),17.280823f : /) : max) : min) : @) : ID_800;
ID_802 = ID_790 : ID_801;
ID_803 = (+ : ID_802);
ID_804 = ID_803 ~ ID_34;
ID_805 = ID_636, 21.976027f;
ID_806 = (ID_805 : *);
ID_807 = ID_806, ID_20;
ID_808 = (ID_807 : <);
ID_809 = _, ID_808;
ID_810 = ID_809 : *;
ID_811 = \(x767).(\(x768).(x768,x767 : -)) ~ \(x769).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x770).(4.4e+02f,(2.0f,((x770,69.0f : -),12.0f : /) : pow) : *)),21.976027f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x769 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x769 : mem) : *) : +);
ID_812 = ID_811 : \(x771).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x771 : *),(0,(x771 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x771 : mem : mem) : *) : +);
ID_813 = ID_810 : ID_812;
ID_814 = ID_89 : ID_813;
ID_815 = \(x766).(x766,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch3", 63.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),21.976027f : /) : max) : min) : @) : ID_814;
ID_816 = ID_790 : ID_815;
ID_817 = (+ : ID_816);
ID_818 = ID_817 ~ ID_34;
ID_819 = ID_804, ID_818;
ID_820 = ID_786, ID_819;
ID_821 = ID_772, ID_820;
ID_822 = ID_754, ID_821;
ID_823 = ID_740, ID_822;
ID_824 = ID_722, ID_823;
ID_825 = ID_714, ID_824;
ID_826 = ID_696, ID_825;
ID_827 = ID_682, ID_826;
ID_828 = ID_664, ID_827;
ID_829 = ID_650, ID_828;
ID_830 = ID_829 :> _;
ID_831 = (ID_630 <: ID_830);
ID_832 = button("play4");
ID_833 = ID_832 <: ID_2;
ID_834 = 1.1900357f, ID_833;
ID_835 = (ID_834 : *);
ID_836 = _, ID_835;
ID_837 = ID_836 : +;
ID_838 = nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f);
ID_839 = (ID_838 : \(x2).(4.4e+02f,(2.0f,((x2,69.0f : -),12.0f : /) : pow) : *));
ID_840 = ID_839, 0.99610835f;
ID_841 = (ID_840 : *);
ID_842 = ID_841, ID_20;
ID_843 = (ID_842 : <);
ID_844 = _, ID_843;
ID_845 = ID_844 : *;
ID_846 = \(x773).(\(x774).(x774,x773 : -)) ~ \(x775).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x776).(4.4e+02f,(2.0f,((x776,69.0f : -),12.0f : /) : pow) : *)),0.99610835f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x775 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x775 : mem) : *) : +);
ID_847 = ID_846 : \(x777).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x777 : *),(0,(x777 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x777 : mem : mem) : *) : +);
ID_848 = ID_845 : ID_847;
ID_849 = ID_9 : ID_848;
ID_850 = \(x772).(x772,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),0.99610835f : /) : max) : min) : @) : ID_849;
ID_851 = ID_837 : ID_850;
ID_852 = (+ : ID_851);
ID_853 = ID_852 ~ ID_34;
ID_854 = ID_839, 1.0038917f;
ID_855 = (ID_854 : *);
ID_856 = ID_855, ID_20;
ID_857 = (ID_856 : <);
ID_858 = _, ID_857;
ID_859 = ID_858 : *;
ID_860 = \(x779).(\(x780).(x780,x779 : -)) ~ \(x781).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x782).(4.4e+02f,(2.0f,((x782,69.0f : -),12.0f : /) : pow) : *)),1.0038917f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x781 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x781 : mem) : *) : +);
ID_861 = ID_860 : \(x783).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x783 : *),(0,(x783 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x783 : mem : mem) : *) : +);
ID_862 = ID_859 : ID_861;
ID_863 = ID_9 : ID_862;
ID_864 = \(x778).(x778,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),1.0038917f : /) : max) : min) : @) : ID_863;
ID_865 = ID_837 : ID_864;
ID_866 = (+ : ID_865);
ID_867 = ID_866 ~ ID_34;
ID_868 = 1.0914886f, ID_833;
ID_869 = (ID_868 : *);
ID_870 = _, ID_869;
ID_871 = ID_870 : +;
ID_872 = ID_839, 2.979178f;
ID_873 = (ID_872 : *);
ID_874 = ID_873, ID_20;
ID_875 = (ID_874 : <);
ID_876 = _, ID_875;
ID_877 = ID_876 : *;
ID_878 = \(x785).(\(x786).(x786,x785 : -)) ~ \(x787).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x788).(4.4e+02f,(2.0f,((x788,69.0f : -),12.0f : /) : pow) : *)),2.979178f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x787 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x787 : mem) : *) : +);
ID_879 = ID_878 : \(x789).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x789 : *),(0,(x789 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x789 : mem : mem) : *) : +);
ID_880 = ID_877 : ID_879;
ID_881 = ID_55 : ID_880;
ID_882 = \(x784).(x784,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.979178f : /) : max) : min) : @) : ID_881;
ID_883 = ID_871 : ID_882;
ID_884 = (+ : ID_883);
ID_885 = ID_884 ~ ID_34;
ID_886 = ID_839, 2.9932976f;
ID_887 = (ID_886 : *);
ID_888 = ID_887, ID_20;
ID_889 = (ID_888 : <);
ID_890 = _, ID_889;
ID_891 = ID_890 : *;
ID_892 = \(x791).(\(x792).(x792,x791 : -)) ~ \(x793).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x794).(4.4e+02f,(2.0f,((x794,69.0f : -),12.0f : /) : pow) : *)),2.9932976f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x793 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x793 : mem) : *) : +);
ID_893 = ID_892 : \(x795).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x795 : *),(0,(x795 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x795 : mem : mem) : *) : +);
ID_894 = ID_891 : ID_893;
ID_895 = ID_55 : ID_894;
ID_896 = \(x790).(x790,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.9932976f : /) : max) : min) : @) : ID_895;
ID_897 = ID_871 : ID_896;
ID_898 = (+ : ID_897);
ID_899 = ID_898 ~ ID_34;
ID_900 = 4.2995043f, ID_833;
ID_901 = (ID_900 : *);
ID_902 = _, ID_901;
ID_903 = ID_902 : +;
ID_904 = ID_839, 5.704452f;
ID_905 = (ID_904 : *);
ID_906 = ID_905, ID_20;
ID_907 = (ID_906 : <);
ID_908 = _, ID_907;
ID_909 = ID_908 : *;
ID_910 = \(x797).(\(x798).(x798,x797 : -)) ~ \(x799).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x800).(4.4e+02f,(2.0f,((x800,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x799 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x799 : mem) : *) : +);
ID_911 = ID_910 : \(x801).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x801 : *),(0,(x801 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x801 : mem : mem) : *) : +);
ID_912 = ID_909 : ID_911;
ID_913 = ID_89 : ID_912;
ID_914 = \(x796).(x796,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_913;
ID_915 = ID_903 : ID_914;
ID_916 = (+ : ID_915);
ID_917 = ID_916 ~ ID_34;
ID_918 = \(x803).(\(x804).(x804,x803 : -)) ~ \(x805).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x806).(4.4e+02f,(2.0f,((x806,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x805 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x805 : mem) : *) : +);
ID_919 = ID_918 : \(x807).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x807 : *),(0,(x807 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x807 : mem : mem) : *) : +);
ID_920 = ID_909 : ID_919;
ID_921 = ID_89 : ID_920;
ID_922 = \(x802).(x802,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_921;
ID_923 = ID_903 : ID_922;
ID_924 = (+ : ID_923);
ID_925 = ID_924 ~ ID_34;
ID_926 = 4.0063033f, ID_833;
ID_927 = (ID_926 : *);
ID_928 = _, ID_927;
ID_929 = ID_928 : +;
ID_930 = ID_839, 8.9982f;
ID_931 = (ID_930 : *);
ID_932 = ID_931, ID_20;
ID_933 = (ID_932 : <);
ID_934 = _, ID_933;
ID_935 = ID_934 : *;
ID_936 = \(x809).(\(x810).(x810,x809 : -)) ~ \(x811).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x812).(4.4e+02f,(2.0f,((x812,69.0f : -),12.0f : /) : pow) : *)),8.9982f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x811 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x811 : mem) : *) : +);
ID_937 = ID_936 : \(x813).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x813 : *),(0,(x813 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x813 : mem : mem) : *) : +);
ID_938 = ID_935 : ID_937;
ID_939 = ID_89 : ID_938;
ID_940 = \(x808).(x808,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),8.9982f : /) : max) : min) : @) : ID_939;
ID_941 = ID_929 : ID_940;
ID_942 = (+ : ID_941);
ID_943 = ID_942 ~ ID_34;
ID_944 = ID_839, 9.015497f;
ID_945 = (ID_944 : *);
ID_946 = ID_945, ID_20;
ID_947 = (ID_946 : <);
ID_948 = _, ID_947;
ID_949 = ID_948 : *;
ID_950 = \(x815).(\(x816).(x816,x815 : -)) ~ \(x817).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x818).(4.4e+02f,(2.0f,((x818,69.0f : -),12.0f : /) : pow) : *)),9.015497f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x817 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x817 : mem) : *) : +);
ID_951 = ID_950 : \(x819).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x819 : *),(0,(x819 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x819 : mem : mem) : *) : +);
ID_952 = ID_949 : ID_951;
ID_953 = ID_89 : ID_952;
ID_954 = \(x814).(x814,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),9.015497f : /) : max) : min) : @) : ID_953;
ID_955 = ID_929 : ID_954;
ID_956 = (+ : ID_955);
ID_957 = ID_956 ~ ID_34;
ID_958 = 0.7063034f, ID_833;
ID_959 = (ID_958 : *);
ID_960 = _, ID_959;
ID_961 = ID_960 : +;
ID_962 = ID_839, 12.83303f;
ID_963 = (ID_962 : *);
ID_964 = ID_963, ID_20;
ID_965 = (ID_964 : <);
ID_966 = _, ID_965;
ID_967 = ID_966 : *;
ID_968 = \(x821).(\(x822).(x822,x821 : -)) ~ \(x823).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x824).(4.4e+02f,(2.0f,((x824,69.0f : -),12.0f : /) : pow) : *)),12.83303f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x823 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x823 : mem) : *) : +);
ID_969 = ID_968 : \(x825).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x825 : *),(0,(x825 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x825 : mem : mem) : *) : +);
ID_970 = ID_967 : ID_969;
ID_971 = ID_149 : ID_970;
ID_972 = \(x820).(x820,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.83303f : /) : max) : min) : @) : ID_971;
ID_973 = ID_961 : ID_972;
ID_974 = (+ : ID_973);
ID_975 = ID_974 ~ ID_34;
ID_976 = ID_839, 12.807382f;
ID_977 = (ID_976 : *);
ID_978 = ID_977, ID_20;
ID_979 = (ID_978 : <);
ID_980 = _, ID_979;
ID_981 = ID_980 : *;
ID_982 = \(x827).(\(x828).(x828,x827 : -)) ~ \(x829).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x830).(4.4e+02f,(2.0f,((x830,69.0f : -),12.0f : /) : pow) : *)),12.807382f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x829 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x829 : mem) : *) : +);
ID_983 = ID_982 : \(x831).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x831 : *),(0,(x831 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x831 : mem : mem) : *) : +);
ID_984 = ID_981 : ID_983;
ID_985 = ID_149 : ID_984;
ID_986 = \(x826).(x826,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.807382f : /) : max) : min) : @) : ID_985;
ID_987 = ID_961 : ID_986;
ID_988 = (+ : ID_987);
ID_989 = ID_988 ~ ID_34;
ID_990 = 5.7063036f, ID_833;
ID_991 = (ID_990 : *);
ID_992 = _, ID_991;
ID_993 = ID_992 : +;
ID_994 = ID_839, 17.280823f;
ID_995 = (ID_994 : *);
ID_996 = ID_995, ID_20;
ID_997 = (ID_996 : <);
ID_998 = _, ID_997;
ID_999 = ID_998 : *;
ID_1000 = \(x833).(\(x834).(x834,x833 : -)) ~ \(x835).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x836).(4.4e+02f,(2.0f,((x836,69.0f : -),12.0f : /) : pow) : *)),17.280823f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x835 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x835 : mem) : *) : +);
ID_1001 = ID_1000 : \(x837).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x837 : *),(0,(x837 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x837 : mem : mem) : *) : +);
ID_1002 = ID_999 : ID_1001;
ID_1003 = ID_89 : ID_1002;
ID_1004 = \(x832).(x832,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),17.280823f : /) : max) : min) : @) : ID_1003;
ID_1005 = ID_993 : ID_1004;
ID_1006 = (+ : ID_1005);
ID_1007 = ID_1006 ~ ID_34;
ID_1008 = ID_839, 21.976027f;
ID_1009 = (ID_1008 : *);
ID_1010 = ID_1009, ID_20;
ID_1011 = (ID_1010 : <);
ID_1012 = _, ID_1011;
ID_1013 = ID_1012 : *;
ID_1014 = \(x839).(\(x840).(x840,x839 : -)) ~ \(x841).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x842).(4.4e+02f,(2.0f,((x842,69.0f : -),12.0f : /) : pow) : *)),21.976027f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x841 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x841 : mem) : *) : +);
ID_1015 = ID_1014 : \(x843).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x843 : *),(0,(x843 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x843 : mem : mem) : *) : +);
ID_1016 = ID_1013 : ID_1015;
ID_1017 = ID_89 : ID_1016;
ID_1018 = \(x838).(x838,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch4", 64.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),21.976027f : /) : max) : min) : @) : ID_1017;
ID_1019 = ID_993 : ID_1018;
ID_1020 = (+ : ID_1019);
ID_1021 = ID_1020 ~ ID_34;
ID_1022 = ID_1007, ID_1021;
ID_1023 = ID_989, ID_1022;
ID_1024 = ID_975, ID_1023;
ID_1025 = ID_957, ID_1024;
ID_1026 = ID_943, ID_1025;
ID_1027 = ID_925, ID_1026;
ID_1028 = ID_917, ID_1027;
ID_1029 = ID_899, ID_1028;
ID_1030 = ID_885, ID_1029;
ID_1031 = ID_867, ID_1030;
ID_1032 = ID_853, ID_1031;
ID_1033 = ID_1032 :> _;
ID_1034 = (ID_833 <: ID_1033);
ID_1035 = button("play5");
ID_1036 = ID_1035 <: ID_2;
ID_1037 = 1.1900357f, ID_1036;
ID_1038 = (ID_1037 : *);
ID_1039 = _, ID_1038;
ID_1040 = ID_1039 : +;
ID_1041 = nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f);
ID_1042 = (ID_1041 : \(x2).(4.4e+02f,(2.0f,((x2,69.0f : -),12.0f : /) : pow) : *));
ID_1043 = ID_1042, 0.99610835f;
ID_1044 = (ID_1043 : *);
ID_1045 = ID_1044, ID_20;
ID_1046 = (ID_1045 : <);
ID_1047 = _, ID_1046;
ID_1048 = ID_1047 : *;
ID_1049 = \(x845).(\(x846).(x846,x845 : -)) ~ \(x847).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x848).(4.4e+02f,(2.0f,((x848,69.0f : -),12.0f : /) : pow) : *)),0.99610835f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x847 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x847 : mem) : *) : +);
ID_1050 = ID_1049 : \(x849).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x849 : *),(0,(x849 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x849 : mem : mem) : *) : +);
ID_1051 = ID_1048 : ID_1050;
ID_1052 = ID_9 : ID_1051;
ID_1053 = \(x844).(x844,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),0.99610835f : /) : max) : min) : @) : ID_1052;
ID_1054 = ID_1040 : ID_1053;
ID_1055 = (+ : ID_1054);
ID_1056 = ID_1055 ~ ID_34;
ID_1057 = ID_1042, 1.0038917f;
ID_1058 = (ID_1057 : *);
ID_1059 = ID_1058, ID_20;
ID_1060 = (ID_1059 : <);
ID_1061 = _, ID_1060;
ID_1062 = ID_1061 : *;
ID_1063 = \(x851).(\(x852).(x852,x851 : -)) ~ \(x853).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x854).(4.4e+02f,(2.0f,((x854,69.0f : -),12.0f : /) : pow) : *)),1.0038917f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x853 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x853 : mem) : *) : +);
ID_1064 = ID_1063 : \(x855).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x855 : *),(0,(x855 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x855 : mem : mem) : *) : +);
ID_1065 = ID_1062 : ID_1064;
ID_1066 = ID_9 : ID_1065;
ID_1067 = \(x850).(x850,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),1.0038917f : /) : max) : min) : @) : ID_1066;
ID_1068 = ID_1040 : ID_1067;
ID_1069 = (+ : ID_1068);
ID_1070 = ID_1069 ~ ID_34;
ID_1071 = 1.0914886f, ID_1036;
ID_1072 = (ID_1071 : *);
ID_1073 = _, ID_1072;
ID_1074 = ID_1073 : +;
ID_1075 = ID_1042, 2.979178f;
ID_1076 = (ID_1075 : *);
ID_1077 = ID_1076, ID_20;
ID_1078 = (ID_1077 : <);
ID_1079 = _, ID_1078;
ID_1080 = ID_1079 : *;
ID_1081 = \(x857).(\(x858).(x858,x857 : -)) ~ \(x859).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x860).(4.4e+02f,(2.0f,((x860,69.0f : -),12.0f : /) : pow) : *)),2.979178f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x859 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x859 : mem) : *) : +);
ID_1082 = ID_1081 : \(x861).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x861 : *),(0,(x861 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x861 : mem : mem) : *) : +);
ID_1083 = ID_1080 : ID_1082;
ID_1084 = ID_55 : ID_1083;
ID_1085 = \(x856).(x856,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.979178f : /) : max) : min) : @) : ID_1084;
ID_1086 = ID_1074 : ID_1085;
ID_1087 = (+ : ID_1086);
ID_1088 = ID_1087 ~ ID_34;
ID_1089 = ID_1042, 2.9932976f;
ID_1090 = (ID_1089 : *);
ID_1091 = ID_1090, ID_20;
ID_1092 = (ID_1091 : <);
ID_1093 = _, ID_1092;
ID_1094 = ID_1093 : *;
ID_1095 = \(x863).(\(x864).(x864,x863 : -)) ~ \(x865).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x866).(4.4e+02f,(2.0f,((x866,69.0f : -),12.0f : /) : pow) : *)),2.9932976f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x865 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x865 : mem) : *) : +);
ID_1096 = ID_1095 : \(x867).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x867 : *),(0,(x867 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x867 : mem : mem) : *) : +);
ID_1097 = ID_1094 : ID_1096;
ID_1098 = ID_55 : ID_1097;
ID_1099 = \(x862).(x862,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.9932976f : /) : max) : min) : @) : ID_1098;
ID_1100 = ID_1074 : ID_1099;
ID_1101 = (+ : ID_1100);
ID_1102 = ID_1101 ~ ID_34;
ID_1103 = 4.2995043f, ID_1036;
ID_1104 = (ID_1103 : *);
ID_1105 = _, ID_1104;
ID_1106 = ID_1105 : +;
ID_1107 = ID_1042, 5.704452f;
ID_1108 = (ID_1107 : *);
ID_1109 = ID_1108, ID_20;
ID_1110 = (ID_1109 : <);
ID_1111 = _, ID_1110;
ID_1112 = ID_1111 : *;
ID_1113 = \(x869).(\(x870).(x870,x869 : -)) ~ \(x871).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x872).(4.4e+02f,(2.0f,((x872,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x871 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x871 : mem) : *) : +);
ID_1114 = ID_1113 : \(x873).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x873 : *),(0,(x873 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x873 : mem : mem) : *) : +);
ID_1115 = ID_1112 : ID_1114;
ID_1116 = ID_89 : ID_1115;
ID_1117 = \(x868).(x868,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_1116;
ID_1118 = ID_1106 : ID_1117;
ID_1119 = (+ : ID_1118);
ID_1120 = ID_1119 ~ ID_34;
ID_1121 = \(x875).(\(x876).(x876,x875 : -)) ~ \(x877).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x878).(4.4e+02f,(2.0f,((x878,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x877 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x877 : mem) : *) : +);
ID_1122 = ID_1121 : \(x879).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x879 : *),(0,(x879 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x879 : mem : mem) : *) : +);
ID_1123 = ID_1112 : ID_1122;
ID_1124 = ID_89 : ID_1123;
ID_1125 = \(x874).(x874,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_1124;
ID_1126 = ID_1106 : ID_1125;
ID_1127 = (+ : ID_1126);
ID_1128 = ID_1127 ~ ID_34;
ID_1129 = 4.0063033f, ID_1036;
ID_1130 = (ID_1129 : *);
ID_1131 = _, ID_1130;
ID_1132 = ID_1131 : +;
ID_1133 = ID_1042, 8.9982f;
ID_1134 = (ID_1133 : *);
ID_1135 = ID_1134, ID_20;
ID_1136 = (ID_1135 : <);
ID_1137 = _, ID_1136;
ID_1138 = ID_1137 : *;
ID_1139 = \(x881).(\(x882).(x882,x881 : -)) ~ \(x883).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x884).(4.4e+02f,(2.0f,((x884,69.0f : -),12.0f : /) : pow) : *)),8.9982f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x883 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x883 : mem) : *) : +);
ID_1140 = ID_1139 : \(x885).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x885 : *),(0,(x885 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x885 : mem : mem) : *) : +);
ID_1141 = ID_1138 : ID_1140;
ID_1142 = ID_89 : ID_1141;
ID_1143 = \(x880).(x880,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),8.9982f : /) : max) : min) : @) : ID_1142;
ID_1144 = ID_1132 : ID_1143;
ID_1145 = (+ : ID_1144);
ID_1146 = ID_1145 ~ ID_34;
ID_1147 = ID_1042, 9.015497f;
ID_1148 = (ID_1147 : *);
ID_1149 = ID_1148, ID_20;
ID_1150 = (ID_1149 : <);
ID_1151 = _, ID_1150;
ID_1152 = ID_1151 : *;
ID_1153 = \(x887).(\(x888).(x888,x887 : -)) ~ \(x889).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x890).(4.4e+02f,(2.0f,((x890,69.0f : -),12.0f : /) : pow) : *)),9.015497f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x889 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x889 : mem) : *) : +);
ID_1154 = ID_1153 : \(x891).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x891 : *),(0,(x891 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x891 : mem : mem) : *) : +);
ID_1155 = ID_1152 : ID_1154;
ID_1156 = ID_89 : ID_1155;
ID_1157 = \(x886).(x886,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),9.015497f : /) : max) : min) : @) : ID_1156;
ID_1158 = ID_1132 : ID_1157;
ID_1159 = (+ : ID_1158);
ID_1160 = ID_1159 ~ ID_34;
ID_1161 = 0.7063034f, ID_1036;
ID_1162 = (ID_1161 : *);
ID_1163 = _, ID_1162;
ID_1164 = ID_1163 : +;
ID_1165 = ID_1042, 12.83303f;
ID_1166 = (ID_1165 : *);
ID_1167 = ID_1166, ID_20;
ID_1168 = (ID_1167 : <);
ID_1169 = _, ID_1168;
ID_1170 = ID_1169 : *;
ID_1171 = \(x893).(\(x894).(x894,x893 : -)) ~ \(x895).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x896).(4.4e+02f,(2.0f,((x896,69.0f : -),12.0f : /) : pow) : *)),12.83303f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x895 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x895 : mem) : *) : +);
ID_1172 = ID_1171 : \(x897).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x897 : *),(0,(x897 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x897 : mem : mem) : *) : +);
ID_1173 = ID_1170 : ID_1172;
ID_1174 = ID_149 : ID_1173;
ID_1175 = \(x892).(x892,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.83303f : /) : max) : min) : @) : ID_1174;
ID_1176 = ID_1164 : ID_1175;
ID_1177 = (+ : ID_1176);
ID_1178 = ID_1177 ~ ID_34;
ID_1179 = ID_1042, 12.807382f;
ID_1180 = (ID_1179 : *);
ID_1181 = ID_1180, ID_20;
ID_1182 = (ID_1181 : <);
ID_1183 = _, ID_1182;
ID_1184 = ID_1183 : *;
ID_1185 = \(x899).(\(x900).(x900,x899 : -)) ~ \(x901).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x902).(4.4e+02f,(2.0f,((x902,69.0f : -),12.0f : /) : pow) : *)),12.807382f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x901 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x901 : mem) : *) : +);
ID_1186 = ID_1185 : \(x903).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x903 : *),(0,(x903 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x903 : mem : mem) : *) : +);
ID_1187 = ID_1184 : ID_1186;
ID_1188 = ID_149 : ID_1187;
ID_1189 = \(x898).(x898,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.807382f : /) : max) : min) : @) : ID_1188;
ID_1190 = ID_1164 : ID_1189;
ID_1191 = (+ : ID_1190);
ID_1192 = ID_1191 ~ ID_34;
ID_1193 = 5.7063036f, ID_1036;
ID_1194 = (ID_1193 : *);
ID_1195 = _, ID_1194;
ID_1196 = ID_1195 : +;
ID_1197 = ID_1042, 17.280823f;
ID_1198 = (ID_1197 : *);
ID_1199 = ID_1198, ID_20;
ID_1200 = (ID_1199 : <);
ID_1201 = _, ID_1200;
ID_1202 = ID_1201 : *;
ID_1203 = \(x905).(\(x906).(x906,x905 : -)) ~ \(x907).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x908).(4.4e+02f,(2.0f,((x908,69.0f : -),12.0f : /) : pow) : *)),17.280823f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x907 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x907 : mem) : *) : +);
ID_1204 = ID_1203 : \(x909).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x909 : *),(0,(x909 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x909 : mem : mem) : *) : +);
ID_1205 = ID_1202 : ID_1204;
ID_1206 = ID_89 : ID_1205;
ID_1207 = \(x904).(x904,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),17.280823f : /) : max) : min) : @) : ID_1206;
ID_1208 = ID_1196 : ID_1207;
ID_1209 = (+ : ID_1208);
ID_1210 = ID_1209 ~ ID_34;
ID_1211 = ID_1042, 21.976027f;
ID_1212 = (ID_1211 : *);
ID_1213 = ID_1212, ID_20;
ID_1214 = (ID_1213 : <);
ID_1215 = _, ID_1214;
ID_1216 = ID_1215 : *;
ID_1217 = \(x911).(\(x912).(x912,x911 : -)) ~ \(x913).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x914).(4.4e+02f,(2.0f,((x914,69.0f : -),12.0f : /) : pow) : *)),21.976027f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x913 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x913 : mem) : *) : +);
ID_1218 = ID_1217 : \(x915).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x915 : *),(0,(x915 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x915 : mem : mem) : *) : +);
ID_1219 = ID_1216 : ID_1218;
ID_1220 = ID_89 : ID_1219;
ID_1221 = \(x910).(x910,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch5", 65.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),21.976027f : /) : max) : min) : @) : ID_1220;
ID_1222 = ID_1196 : ID_1221;
ID_1223 = (+ : ID_1222);
ID_1224 = ID_1223 ~ ID_34;
ID_1225 = ID_1210, ID_1224;
ID_1226 = ID_1192, ID_1225;
ID_1227 = ID_1178, ID_1226;
ID_1228 = ID_1160, ID_1227;
ID_1229 = ID_1146, ID_1228;
ID_1230 = ID_1128, ID_1229;
ID_1231 = ID_1120, ID_1230;
ID_1232 = ID_1102, ID_1231;
ID_1233 = ID_1088, ID_1232;
ID_1234 = ID_1070, ID_1233;
ID_1235 = ID_1056, ID_1234;
ID_1236 = ID_1235 :> _;
ID_1237 = (ID_1036 <: ID_1236);
ID_1238 = button("play6");
ID_1239 = ID_1238 <: ID_2;
ID_1240 = 1.1900357f, ID_1239;
ID_1241 = (ID_1240 : *);
ID_1242 = _, ID_1241;
ID_1243 = ID_1242 : +;
ID_1244 = nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f);
ID_1245 = (ID_1244 : \(x2).(4.4e+02f,(2.0f,((x2,69.0f : -),12.0f : /) : pow) : *));
ID_1246 = ID_1245, 0.99610835f;
ID_1247 = (ID_1246 : *);
ID_1248 = ID_1247, ID_20;
ID_1249 = (ID_1248 : <);
ID_1250 = _, ID_1249;
ID_1251 = ID_1250 : *;
ID_1252 = \(x917).(\(x918).(x918,x917 : -)) ~ \(x919).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x920).(4.4e+02f,(2.0f,((x920,69.0f : -),12.0f : /) : pow) : *)),0.99610835f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x919 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x919 : mem) : *) : +);
ID_1253 = ID_1252 : \(x921).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x921 : *),(0,(x921 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x921 : mem : mem) : *) : +);
ID_1254 = ID_1251 : ID_1253;
ID_1255 = ID_9 : ID_1254;
ID_1256 = \(x916).(x916,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),0.99610835f : /) : max) : min) : @) : ID_1255;
ID_1257 = ID_1243 : ID_1256;
ID_1258 = (+ : ID_1257);
ID_1259 = ID_1258 ~ ID_34;
ID_1260 = ID_1245, 1.0038917f;
ID_1261 = (ID_1260 : *);
ID_1262 = ID_1261, ID_20;
ID_1263 = (ID_1262 : <);
ID_1264 = _, ID_1263;
ID_1265 = ID_1264 : *;
ID_1266 = \(x923).(\(x924).(x924,x923 : -)) ~ \(x925).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x926).(4.4e+02f,(2.0f,((x926,69.0f : -),12.0f : /) : pow) : *)),1.0038917f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x925 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x925 : mem) : *) : +);
ID_1267 = ID_1266 : \(x927).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x927 : *),(0,(x927 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x927 : mem : mem) : *) : +);
ID_1268 = ID_1265 : ID_1267;
ID_1269 = ID_9 : ID_1268;
ID_1270 = \(x922).(x922,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),1.0038917f : /) : max) : min) : @) : ID_1269;
ID_1271 = ID_1243 : ID_1270;
ID_1272 = (+ : ID_1271);
ID_1273 = ID_1272 ~ ID_34;
ID_1274 = 1.0914886f, ID_1239;
ID_1275 = (ID_1274 : *);
ID_1276 = _, ID_1275;
ID_1277 = ID_1276 : +;
ID_1278 = ID_1245, 2.979178f;
ID_1279 = (ID_1278 : *);
ID_1280 = ID_1279, ID_20;
ID_1281 = (ID_1280 : <);
ID_1282 = _, ID_1281;
ID_1283 = ID_1282 : *;
ID_1284 = \(x929).(\(x930).(x930,x929 : -)) ~ \(x931).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x932).(4.4e+02f,(2.0f,((x932,69.0f : -),12.0f : /) : pow) : *)),2.979178f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x931 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x931 : mem) : *) : +);
ID_1285 = ID_1284 : \(x933).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x933 : *),(0,(x933 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x933 : mem : mem) : *) : +);
ID_1286 = ID_1283 : ID_1285;
ID_1287 = ID_55 : ID_1286;
ID_1288 = \(x928).(x928,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.979178f : /) : max) : min) : @) : ID_1287;
ID_1289 = ID_1277 : ID_1288;
ID_1290 = (+ : ID_1289);
ID_1291 = ID_1290 ~ ID_34;
ID_1292 = ID_1245, 2.9932976f;
ID_1293 = (ID_1292 : *);
ID_1294 = ID_1293, ID_20;
ID_1295 = (ID_1294 : <);
ID_1296 = _, ID_1295;
ID_1297 = ID_1296 : *;
ID_1298 = \(x935).(\(x936).(x936,x935 : -)) ~ \(x937).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x938).(4.4e+02f,(2.0f,((x938,69.0f : -),12.0f : /) : pow) : *)),2.9932976f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x937 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x937 : mem) : *) : +);
ID_1299 = ID_1298 : \(x939).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x939 : *),(0,(x939 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x939 : mem : mem) : *) : +);
ID_1300 = ID_1297 : ID_1299;
ID_1301 = ID_55 : ID_1300;
ID_1302 = \(x934).(x934,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.9932976f : /) : max) : min) : @) : ID_1301;
ID_1303 = ID_1277 : ID_1302;
ID_1304 = (+ : ID_1303);
ID_1305 = ID_1304 ~ ID_34;
ID_1306 = 4.2995043f, ID_1239;
ID_1307 = (ID_1306 : *);
ID_1308 = _, ID_1307;
ID_1309 = ID_1308 : +;
ID_1310 = ID_1245, 5.704452f;
ID_1311 = (ID_1310 : *);
ID_1312 = ID_1311, ID_20;
ID_1313 = (ID_1312 : <);
ID_1314 = _, ID_1313;
ID_1315 = ID_1314 : *;
ID_1316 = \(x941).(\(x942).(x942,x941 : -)) ~ \(x943).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x944).(4.4e+02f,(2.0f,((x944,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x943 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x943 : mem) : *) : +);
ID_1317 = ID_1316 : \(x945).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x945 : *),(0,(x945 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x945 : mem : mem) : *) : +);
ID_1318 = ID_1315 : ID_1317;
ID_1319 = ID_89 : ID_1318;
ID_1320 = \(x940).(x940,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_1319;
ID_1321 = ID_1309 : ID_1320;
ID_1322 = (+ : ID_1321);
ID_1323 = ID_1322 ~ ID_34;
ID_1324 = \(x947).(\(x948).(x948,x947 : -)) ~ \(x949).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x950).(4.4e+02f,(2.0f,((x950,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x949 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x949 : mem) : *) : +);
ID_1325 = ID_1324 : \(x951).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x951 : *),(0,(x951 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x951 : mem : mem) : *) : +);
ID_1326 = ID_1315 : ID_1325;
ID_1327 = ID_89 : ID_1326;
ID_1328 = \(x946).(x946,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_1327;
ID_1329 = ID_1309 : ID_1328;
ID_1330 = (+ : ID_1329);
ID_1331 = ID_1330 ~ ID_34;
ID_1332 = 4.0063033f, ID_1239;
ID_1333 = (ID_1332 : *);
ID_1334 = _, ID_1333;
ID_1335 = ID_1334 : +;
ID_1336 = ID_1245, 8.9982f;
ID_1337 = (ID_1336 : *);
ID_1338 = ID_1337, ID_20;
ID_1339 = (ID_1338 : <);
ID_1340 = _, ID_1339;
ID_1341 = ID_1340 : *;
ID_1342 = \(x953).(\(x954).(x954,x953 : -)) ~ \(x955).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x956).(4.4e+02f,(2.0f,((x956,69.0f : -),12.0f : /) : pow) : *)),8.9982f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x955 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x955 : mem) : *) : +);
ID_1343 = ID_1342 : \(x957).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x957 : *),(0,(x957 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x957 : mem : mem) : *) : +);
ID_1344 = ID_1341 : ID_1343;
ID_1345 = ID_89 : ID_1344;
ID_1346 = \(x952).(x952,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),8.9982f : /) : max) : min) : @) : ID_1345;
ID_1347 = ID_1335 : ID_1346;
ID_1348 = (+ : ID_1347);
ID_1349 = ID_1348 ~ ID_34;
ID_1350 = ID_1245, 9.015497f;
ID_1351 = (ID_1350 : *);
ID_1352 = ID_1351, ID_20;
ID_1353 = (ID_1352 : <);
ID_1354 = _, ID_1353;
ID_1355 = ID_1354 : *;
ID_1356 = \(x959).(\(x960).(x960,x959 : -)) ~ \(x961).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x962).(4.4e+02f,(2.0f,((x962,69.0f : -),12.0f : /) : pow) : *)),9.015497f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x961 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x961 : mem) : *) : +);
ID_1357 = ID_1356 : \(x963).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x963 : *),(0,(x963 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x963 : mem : mem) : *) : +);
ID_1358 = ID_1355 : ID_1357;
ID_1359 = ID_89 : ID_1358;
ID_1360 = \(x958).(x958,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),9.015497f : /) : max) : min) : @) : ID_1359;
ID_1361 = ID_1335 : ID_1360;
ID_1362 = (+ : ID_1361);
ID_1363 = ID_1362 ~ ID_34;
ID_1364 = 0.7063034f, ID_1239;
ID_1365 = (ID_1364 : *);
ID_1366 = _, ID_1365;
ID_1367 = ID_1366 : +;
ID_1368 = ID_1245, 12.83303f;
ID_1369 = (ID_1368 : *);
ID_1370 = ID_1369, ID_20;
ID_1371 = (ID_1370 : <);
ID_1372 = _, ID_1371;
ID_1373 = ID_1372 : *;
ID_1374 = \(x965).(\(x966).(x966,x965 : -)) ~ \(x967).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x968).(4.4e+02f,(2.0f,((x968,69.0f : -),12.0f : /) : pow) : *)),12.83303f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x967 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x967 : mem) : *) : +);
ID_1375 = ID_1374 : \(x969).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x969 : *),(0,(x969 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x969 : mem : mem) : *) : +);
ID_1376 = ID_1373 : ID_1375;
ID_1377 = ID_149 : ID_1376;
ID_1378 = \(x964).(x964,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.83303f : /) : max) : min) : @) : ID_1377;
ID_1379 = ID_1367 : ID_1378;
ID_1380 = (+ : ID_1379);
ID_1381 = ID_1380 ~ ID_34;
ID_1382 = ID_1245, 12.807382f;
ID_1383 = (ID_1382 : *);
ID_1384 = ID_1383, ID_20;
ID_1385 = (ID_1384 : <);
ID_1386 = _, ID_1385;
ID_1387 = ID_1386 : *;
ID_1388 = \(x971).(\(x972).(x972,x971 : -)) ~ \(x973).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x974).(4.4e+02f,(2.0f,((x974,69.0f : -),12.0f : /) : pow) : *)),12.807382f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x973 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x973 : mem) : *) : +);
ID_1389 = ID_1388 : \(x975).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x975 : *),(0,(x975 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x975 : mem : mem) : *) : +);
ID_1390 = ID_1387 : ID_1389;
ID_1391 = ID_149 : ID_1390;
ID_1392 = \(x970).(x970,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.807382f : /) : max) : min) : @) : ID_1391;
ID_1393 = ID_1367 : ID_1392;
ID_1394 = (+ : ID_1393);
ID_1395 = ID_1394 ~ ID_34;
ID_1396 = 5.7063036f, ID_1239;
ID_1397 = (ID_1396 : *);
ID_1398 = _, ID_1397;
ID_1399 = ID_1398 : +;
ID_1400 = ID_1245, 17.280823f;
ID_1401 = (ID_1400 : *);
ID_1402 = ID_1401, ID_20;
ID_1403 = (ID_1402 : <);
ID_1404 = _, ID_1403;
ID_1405 = ID_1404 : *;
ID_1406 = \(x977).(\(x978).(x978,x977 : -)) ~ \(x979).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x980).(4.4e+02f,(2.0f,((x980,69.0f : -),12.0f : /) : pow) : *)),17.280823f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x979 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x979 : mem) : *) : +);
ID_1407 = ID_1406 : \(x981).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x981 : *),(0,(x981 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x981 : mem : mem) : *) : +);
ID_1408 = ID_1405 : ID_1407;
ID_1409 = ID_89 : ID_1408;
ID_1410 = \(x976).(x976,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),17.280823f : /) : max) : min) : @) : ID_1409;
ID_1411 = ID_1399 : ID_1410;
ID_1412 = (+ : ID_1411);
ID_1413 = ID_1412 ~ ID_34;
ID_1414 = ID_1245, 21.976027f;
ID_1415 = (ID_1414 : *);
ID_1416 = ID_1415, ID_20;
ID_1417 = (ID_1416 : <);
ID_1418 = _, ID_1417;
ID_1419 = ID_1418 : *;
ID_1420 = \(x983).(\(x984).(x984,x983 : -)) ~ \(x985).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x986).(4.4e+02f,(2.0f,((x986,69.0f : -),12.0f : /) : pow) : *)),21.976027f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x985 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x985 : mem) : *) : +);
ID_1421 = ID_1420 : \(x987).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x987 : *),(0,(x987 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x987 : mem : mem) : *) : +);
ID_1422 = ID_1419 : ID_1421;
ID_1423 = ID_89 : ID_1422;
ID_1424 = \(x982).(x982,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch6", 66.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),21.976027f : /) : max) : min) : @) : ID_1423;
ID_1425 = ID_1399 : ID_1424;
ID_1426 = (+ : ID_1425);
ID_1427 = ID_1426 ~ ID_34;
ID_1428 = ID_1413, ID_1427;
ID_1429 = ID_1395, ID_1428;
ID_1430 = ID_1381, ID_1429;
ID_1431 = ID_1363, ID_1430;
ID_1432 = ID_1349, ID_1431;
ID_1433 = ID_1331, ID_1432;
ID_1434 = ID_1323, ID_1433;
ID_1435 = ID_1305, ID_1434;
ID_1436 = ID_1291, ID_1435;
ID_1437 = ID_1273, ID_1436;
ID_1438 = ID_1259, ID_1437;
ID_1439 = ID_1438 :> _;
ID_1440 = (ID_1239 <: ID_1439);
ID_1441 = button("play7");
ID_1442 = ID_1441 <: ID_2;
ID_1443 = 1.1900357f, ID_1442;
ID_1444 = (ID_1443 : *);
ID_1445 = _, ID_1444;
ID_1446 = ID_1445 : +;
ID_1447 = nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f);
ID_1448 = (ID_1447 : \(x2).(4.4e+02f,(2.0f,((x2,69.0f : -),12.0f : /) : pow) : *));
ID_1449 = ID_1448, 0.99610835f;
ID_1450 = (ID_1449 : *);
ID_1451 = ID_1450, ID_20;
ID_1452 = (ID_1451 : <);
ID_1453 = _, ID_1452;
ID_1454 = ID_1453 : *;
ID_1455 = \(x989).(\(x990).(x990,x989 : -)) ~ \(x991).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x992).(4.4e+02f,(2.0f,((x992,69.0f : -),12.0f : /) : pow) : *)),0.99610835f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x991 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x991 : mem) : *) : +);
ID_1456 = ID_1455 : \(x993).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x993 : *),(0,(x993 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x993 : mem : mem) : *) : +);
ID_1457 = ID_1454 : ID_1456;
ID_1458 = ID_9 : ID_1457;
ID_1459 = \(x988).(x988,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),0.99610835f : /) : max) : min) : @) : ID_1458;
ID_1460 = ID_1446 : ID_1459;
ID_1461 = (+ : ID_1460);
ID_1462 = ID_1461 ~ ID_34;
ID_1463 = ID_1448, 1.0038917f;
ID_1464 = (ID_1463 : *);
ID_1465 = ID_1464, ID_20;
ID_1466 = (ID_1465 : <);
ID_1467 = _, ID_1466;
ID_1468 = ID_1467 : *;
ID_1469 = \(x995).(\(x996).(x996,x995 : -)) ~ \(x997).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x998).(4.4e+02f,(2.0f,((x998,69.0f : -),12.0f : /) : pow) : *)),1.0038917f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x997 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x997 : mem) : *) : +);
ID_1470 = ID_1469 : \(x999).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x999 : *),(0,(x999 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x999 : mem : mem) : *) : +);
ID_1471 = ID_1468 : ID_1470;
ID_1472 = ID_9 : ID_1471;
ID_1473 = \(x994).(x994,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),1.0038917f : /) : max) : min) : @) : ID_1472;
ID_1474 = ID_1446 : ID_1473;
ID_1475 = (+ : ID_1474);
ID_1476 = ID_1475 ~ ID_34;
ID_1477 = 1.0914886f, ID_1442;
ID_1478 = (ID_1477 : *);
ID_1479 = _, ID_1478;
ID_1480 = ID_1479 : +;
ID_1481 = ID_1448, 2.979178f;
ID_1482 = (ID_1481 : *);
ID_1483 = ID_1482, ID_20;
ID_1484 = (ID_1483 : <);
ID_1485 = _, ID_1484;
ID_1486 = ID_1485 : *;
ID_1487 = \(x1001).(\(x1002).(x1002,x1001 : -)) ~ \(x1003).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1004).(4.4e+02f,(2.0f,((x1004,69.0f : -),12.0f : /) : pow) : *)),2.979178f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1003 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1003 : mem) : *) : +);
ID_1488 = ID_1487 : \(x1005).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1005 : *),(0,(x1005 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1005 : mem : mem) : *) : +);
ID_1489 = ID_1486 : ID_1488;
ID_1490 = ID_55 : ID_1489;
ID_1491 = \(x1000).(x1000,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.979178f : /) : max) : min) : @) : ID_1490;
ID_1492 = ID_1480 : ID_1491;
ID_1493 = (+ : ID_1492);
ID_1494 = ID_1493 ~ ID_34;
ID_1495 = ID_1448, 2.9932976f;
ID_1496 = (ID_1495 : *);
ID_1497 = ID_1496, ID_20;
ID_1498 = (ID_1497 : <);
ID_1499 = _, ID_1498;
ID_1500 = ID_1499 : *;
ID_1501 = \(x1007).(\(x1008).(x1008,x1007 : -)) ~ \(x1009).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1010).(4.4e+02f,(2.0f,((x1010,69.0f : -),12.0f : /) : pow) : *)),2.9932976f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1009 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1009 : mem) : *) : +);
ID_1502 = ID_1501 : \(x1011).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1011 : *),(0,(x1011 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1011 : mem : mem) : *) : +);
ID_1503 = ID_1500 : ID_1502;
ID_1504 = ID_55 : ID_1503;
ID_1505 = \(x1006).(x1006,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.9932976f : /) : max) : min) : @) : ID_1504;
ID_1506 = ID_1480 : ID_1505;
ID_1507 = (+ : ID_1506);
ID_1508 = ID_1507 ~ ID_34;
ID_1509 = 4.2995043f, ID_1442;
ID_1510 = (ID_1509 : *);
ID_1511 = _, ID_1510;
ID_1512 = ID_1511 : +;
ID_1513 = ID_1448, 5.704452f;
ID_1514 = (ID_1513 : *);
ID_1515 = ID_1514, ID_20;
ID_1516 = (ID_1515 : <);
ID_1517 = _, ID_1516;
ID_1518 = ID_1517 : *;
ID_1519 = \(x1013).(\(x1014).(x1014,x1013 : -)) ~ \(x1015).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1016).(4.4e+02f,(2.0f,((x1016,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1015 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1015 : mem) : *) : +);
ID_1520 = ID_1519 : \(x1017).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1017 : *),(0,(x1017 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1017 : mem : mem) : *) : +);
ID_1521 = ID_1518 : ID_1520;
ID_1522 = ID_89 : ID_1521;
ID_1523 = \(x1012).(x1012,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_1522;
ID_1524 = ID_1512 : ID_1523;
ID_1525 = (+ : ID_1524);
ID_1526 = ID_1525 ~ ID_34;
ID_1527 = \(x1019).(\(x1020).(x1020,x1019 : -)) ~ \(x1021).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1022).(4.4e+02f,(2.0f,((x1022,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1021 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1021 : mem) : *) : +);
ID_1528 = ID_1527 : \(x1023).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1023 : *),(0,(x1023 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1023 : mem : mem) : *) : +);
ID_1529 = ID_1518 : ID_1528;
ID_1530 = ID_89 : ID_1529;
ID_1531 = \(x1018).(x1018,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_1530;
ID_1532 = ID_1512 : ID_1531;
ID_1533 = (+ : ID_1532);
ID_1534 = ID_1533 ~ ID_34;
ID_1535 = 4.0063033f, ID_1442;
ID_1536 = (ID_1535 : *);
ID_1537 = _, ID_1536;
ID_1538 = ID_1537 : +;
ID_1539 = ID_1448, 8.9982f;
ID_1540 = (ID_1539 : *);
ID_1541 = ID_1540, ID_20;
ID_1542 = (ID_1541 : <);
ID_1543 = _, ID_1542;
ID_1544 = ID_1543 : *;
ID_1545 = \(x1025).(\(x1026).(x1026,x1025 : -)) ~ \(x1027).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1028).(4.4e+02f,(2.0f,((x1028,69.0f : -),12.0f : /) : pow) : *)),8.9982f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1027 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1027 : mem) : *) : +);
ID_1546 = ID_1545 : \(x1029).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1029 : *),(0,(x1029 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1029 : mem : mem) : *) : +);
ID_1547 = ID_1544 : ID_1546;
ID_1548 = ID_89 : ID_1547;
ID_1549 = \(x1024).(x1024,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),8.9982f : /) : max) : min) : @) : ID_1548;
ID_1550 = ID_1538 : ID_1549;
ID_1551 = (+ : ID_1550);
ID_1552 = ID_1551 ~ ID_34;
ID_1553 = ID_1448, 9.015497f;
ID_1554 = (ID_1553 : *);
ID_1555 = ID_1554, ID_20;
ID_1556 = (ID_1555 : <);
ID_1557 = _, ID_1556;
ID_1558 = ID_1557 : *;
ID_1559 = \(x1031).(\(x1032).(x1032,x1031 : -)) ~ \(x1033).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1034).(4.4e+02f,(2.0f,((x1034,69.0f : -),12.0f : /) : pow) : *)),9.015497f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1033 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1033 : mem) : *) : +);
ID_1560 = ID_1559 : \(x1035).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1035 : *),(0,(x1035 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1035 : mem : mem) : *) : +);
ID_1561 = ID_1558 : ID_1560;
ID_1562 = ID_89 : ID_1561;
ID_1563 = \(x1030).(x1030,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),9.015497f : /) : max) : min) : @) : ID_1562;
ID_1564 = ID_1538 : ID_1563;
ID_1565 = (+ : ID_1564);
ID_1566 = ID_1565 ~ ID_34;
ID_1567 = 0.7063034f, ID_1442;
ID_1568 = (ID_1567 : *);
ID_1569 = _, ID_1568;
ID_1570 = ID_1569 : +;
ID_1571 = ID_1448, 12.83303f;
ID_1572 = (ID_1571 : *);
ID_1573 = ID_1572, ID_20;
ID_1574 = (ID_1573 : <);
ID_1575 = _, ID_1574;
ID_1576 = ID_1575 : *;
ID_1577 = \(x1037).(\(x1038).(x1038,x1037 : -)) ~ \(x1039).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1040).(4.4e+02f,(2.0f,((x1040,69.0f : -),12.0f : /) : pow) : *)),12.83303f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1039 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1039 : mem) : *) : +);
ID_1578 = ID_1577 : \(x1041).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1041 : *),(0,(x1041 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1041 : mem : mem) : *) : +);
ID_1579 = ID_1576 : ID_1578;
ID_1580 = ID_149 : ID_1579;
ID_1581 = \(x1036).(x1036,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.83303f : /) : max) : min) : @) : ID_1580;
ID_1582 = ID_1570 : ID_1581;
ID_1583 = (+ : ID_1582);
ID_1584 = ID_1583 ~ ID_34;
ID_1585 = ID_1448, 12.807382f;
ID_1586 = (ID_1585 : *);
ID_1587 = ID_1586, ID_20;
ID_1588 = (ID_1587 : <);
ID_1589 = _, ID_1588;
ID_1590 = ID_1589 : *;
ID_1591 = \(x1043).(\(x1044).(x1044,x1043 : -)) ~ \(x1045).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1046).(4.4e+02f,(2.0f,((x1046,69.0f : -),12.0f : /) : pow) : *)),12.807382f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1045 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1045 : mem) : *) : +);
ID_1592 = ID_1591 : \(x1047).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1047 : *),(0,(x1047 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1047 : mem : mem) : *) : +);
ID_1593 = ID_1590 : ID_1592;
ID_1594 = ID_149 : ID_1593;
ID_1595 = \(x1042).(x1042,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.807382f : /) : max) : min) : @) : ID_1594;
ID_1596 = ID_1570 : ID_1595;
ID_1597 = (+ : ID_1596);
ID_1598 = ID_1597 ~ ID_34;
ID_1599 = 5.7063036f, ID_1442;
ID_1600 = (ID_1599 : *);
ID_1601 = _, ID_1600;
ID_1602 = ID_1601 : +;
ID_1603 = ID_1448, 17.280823f;
ID_1604 = (ID_1603 : *);
ID_1605 = ID_1604, ID_20;
ID_1606 = (ID_1605 : <);
ID_1607 = _, ID_1606;
ID_1608 = ID_1607 : *;
ID_1609 = \(x1049).(\(x1050).(x1050,x1049 : -)) ~ \(x1051).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1052).(4.4e+02f,(2.0f,((x1052,69.0f : -),12.0f : /) : pow) : *)),17.280823f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1051 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1051 : mem) : *) : +);
ID_1610 = ID_1609 : \(x1053).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1053 : *),(0,(x1053 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1053 : mem : mem) : *) : +);
ID_1611 = ID_1608 : ID_1610;
ID_1612 = ID_89 : ID_1611;
ID_1613 = \(x1048).(x1048,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),17.280823f : /) : max) : min) : @) : ID_1612;
ID_1614 = ID_1602 : ID_1613;
ID_1615 = (+ : ID_1614);
ID_1616 = ID_1615 ~ ID_34;
ID_1617 = ID_1448, 21.976027f;
ID_1618 = (ID_1617 : *);
ID_1619 = ID_1618, ID_20;
ID_1620 = (ID_1619 : <);
ID_1621 = _, ID_1620;
ID_1622 = ID_1621 : *;
ID_1623 = \(x1055).(\(x1056).(x1056,x1055 : -)) ~ \(x1057).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1058).(4.4e+02f,(2.0f,((x1058,69.0f : -),12.0f : /) : pow) : *)),21.976027f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1057 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1057 : mem) : *) : +);
ID_1624 = ID_1623 : \(x1059).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1059 : *),(0,(x1059 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1059 : mem : mem) : *) : +);
ID_1625 = ID_1622 : ID_1624;
ID_1626 = ID_89 : ID_1625;
ID_1627 = \(x1054).(x1054,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch7", 67.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),21.976027f : /) : max) : min) : @) : ID_1626;
ID_1628 = ID_1602 : ID_1627;
ID_1629 = (+ : ID_1628);
ID_1630 = ID_1629 ~ ID_34;
ID_1631 = ID_1616, ID_1630;
ID_1632 = ID_1598, ID_1631;
ID_1633 = ID_1584, ID_1632;
ID_1634 = ID_1566, ID_1633;
ID_1635 = ID_1552, ID_1634;
ID_1636 = ID_1534, ID_1635;
ID_1637 = ID_1526, ID_1636;
ID_1638 = ID_1508, ID_1637;
ID_1639 = ID_1494, ID_1638;
ID_1640 = ID_1476, ID_1639;
ID_1641 = ID_1462, ID_1640;
ID_1642 = ID_1641 :> _;
ID_1643 = (ID_1442 <: ID_1642);
ID_1644 = button("play8");
ID_1645 = ID_1644 <: ID_2;
ID_1646 = 1.1900357f, ID_1645;
ID_1647 = (ID_1646 : *);
ID_1648 = _, ID_1647;
ID_1649 = ID_1648 : +;
ID_1650 = nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f);
ID_1651 = (ID_1650 : \(x2).(4.4e+02f,(2.0f,((x2,69.0f : -),12.0f : /) : pow) : *));
ID_1652 = ID_1651, 0.99610835f;
ID_1653 = (ID_1652 : *);
ID_1654 = ID_1653, ID_20;
ID_1655 = (ID_1654 : <);
ID_1656 = _, ID_1655;
ID_1657 = ID_1656 : *;
ID_1658 = \(x1061).(\(x1062).(x1062,x1061 : -)) ~ \(x1063).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1064).(4.4e+02f,(2.0f,((x1064,69.0f : -),12.0f : /) : pow) : *)),0.99610835f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1063 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1063 : mem) : *) : +);
ID_1659 = ID_1658 : \(x1065).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1065 : *),(0,(x1065 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1065 : mem : mem) : *) : +);
ID_1660 = ID_1657 : ID_1659;
ID_1661 = ID_9 : ID_1660;
ID_1662 = \(x1060).(x1060,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),0.99610835f : /) : max) : min) : @) : ID_1661;
ID_1663 = ID_1649 : ID_1662;
ID_1664 = (+ : ID_1663);
ID_1665 = ID_1664 ~ ID_34;
ID_1666 = ID_1651, 1.0038917f;
ID_1667 = (ID_1666 : *);
ID_1668 = ID_1667, ID_20;
ID_1669 = (ID_1668 : <);
ID_1670 = _, ID_1669;
ID_1671 = ID_1670 : *;
ID_1672 = \(x1067).(\(x1068).(x1068,x1067 : -)) ~ \(x1069).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1070).(4.4e+02f,(2.0f,((x1070,69.0f : -),12.0f : /) : pow) : *)),1.0038917f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1069 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1069 : mem) : *) : +);
ID_1673 = ID_1672 : \(x1071).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1071 : *),(0,(x1071 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1071 : mem : mem) : *) : +);
ID_1674 = ID_1671 : ID_1673;
ID_1675 = ID_9 : ID_1674;
ID_1676 = \(x1066).(x1066,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),1.0038917f : /) : max) : min) : @) : ID_1675;
ID_1677 = ID_1649 : ID_1676;
ID_1678 = (+ : ID_1677);
ID_1679 = ID_1678 ~ ID_34;
ID_1680 = 1.0914886f, ID_1645;
ID_1681 = (ID_1680 : *);
ID_1682 = _, ID_1681;
ID_1683 = ID_1682 : +;
ID_1684 = ID_1651, 2.979178f;
ID_1685 = (ID_1684 : *);
ID_1686 = ID_1685, ID_20;
ID_1687 = (ID_1686 : <);
ID_1688 = _, ID_1687;
ID_1689 = ID_1688 : *;
ID_1690 = \(x1073).(\(x1074).(x1074,x1073 : -)) ~ \(x1075).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1076).(4.4e+02f,(2.0f,((x1076,69.0f : -),12.0f : /) : pow) : *)),2.979178f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1075 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1075 : mem) : *) : +);
ID_1691 = ID_1690 : \(x1077).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1077 : *),(0,(x1077 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1077 : mem : mem) : *) : +);
ID_1692 = ID_1689 : ID_1691;
ID_1693 = ID_55 : ID_1692;
ID_1694 = \(x1072).(x1072,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.979178f : /) : max) : min) : @) : ID_1693;
ID_1695 = ID_1683 : ID_1694;
ID_1696 = (+ : ID_1695);
ID_1697 = ID_1696 ~ ID_34;
ID_1698 = ID_1651, 2.9932976f;
ID_1699 = (ID_1698 : *);
ID_1700 = ID_1699, ID_20;
ID_1701 = (ID_1700 : <);
ID_1702 = _, ID_1701;
ID_1703 = ID_1702 : *;
ID_1704 = \(x1079).(\(x1080).(x1080,x1079 : -)) ~ \(x1081).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1082).(4.4e+02f,(2.0f,((x1082,69.0f : -),12.0f : /) : pow) : *)),2.9932976f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1081 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1081 : mem) : *) : +);
ID_1705 = ID_1704 : \(x1083).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1083 : *),(0,(x1083 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1083 : mem : mem) : *) : +);
ID_1706 = ID_1703 : ID_1705;
ID_1707 = ID_55 : ID_1706;
ID_1708 = \(x1078).(x1078,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.9932976f : /) : max) : min) : @) : ID_1707;
ID_1709 = ID_1683 : ID_1708;
ID_1710 = (+ : ID_1709);
ID_1711 = ID_1710 ~ ID_34;
ID_1712 = 4.2995043f, ID_1645;
ID_1713 = (ID_1712 : *);
ID_1714 = _, ID_1713;
ID_1715 = ID_1714 : +;
ID_1716 = ID_1651, 5.704452f;
ID_1717 = (ID_1716 : *);
ID_1718 = ID_1717, ID_20;
ID_1719 = (ID_1718 : <);
ID_1720 = _, ID_1719;
ID_1721 = ID_1720 : *;
ID_1722 = \(x1085).(\(x1086).(x1086,x1085 : -)) ~ \(x1087).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1088).(4.4e+02f,(2.0f,((x1088,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1087 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1087 : mem) : *) : +);
ID_1723 = ID_1722 : \(x1089).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1089 : *),(0,(x1089 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1089 : mem : mem) : *) : +);
ID_1724 = ID_1721 : ID_1723;
ID_1725 = ID_89 : ID_1724;
ID_1726 = \(x1084).(x1084,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_1725;
ID_1727 = ID_1715 : ID_1726;
ID_1728 = (+ : ID_1727);
ID_1729 = ID_1728 ~ ID_34;
ID_1730 = \(x1091).(\(x1092).(x1092,x1091 : -)) ~ \(x1093).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1094).(4.4e+02f,(2.0f,((x1094,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1093 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1093 : mem) : *) : +);
ID_1731 = ID_1730 : \(x1095).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1095 : *),(0,(x1095 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1095 : mem : mem) : *) : +);
ID_1732 = ID_1721 : ID_1731;
ID_1733 = ID_89 : ID_1732;
ID_1734 = \(x1090).(x1090,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_1733;
ID_1735 = ID_1715 : ID_1734;
ID_1736 = (+ : ID_1735);
ID_1737 = ID_1736 ~ ID_34;
ID_1738 = 4.0063033f, ID_1645;
ID_1739 = (ID_1738 : *);
ID_1740 = _, ID_1739;
ID_1741 = ID_1740 : +;
ID_1742 = ID_1651, 8.9982f;
ID_1743 = (ID_1742 : *);
ID_1744 = ID_1743, ID_20;
ID_1745 = (ID_1744 : <);
ID_1746 = _, ID_1745;
ID_1747 = ID_1746 : *;
ID_1748 = \(x1097).(\(x1098).(x1098,x1097 : -)) ~ \(x1099).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1100).(4.4e+02f,(2.0f,((x1100,69.0f : -),12.0f : /) : pow) : *)),8.9982f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1099 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1099 : mem) : *) : +);
ID_1749 = ID_1748 : \(x1101).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1101 : *),(0,(x1101 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1101 : mem : mem) : *) : +);
ID_1750 = ID_1747 : ID_1749;
ID_1751 = ID_89 : ID_1750;
ID_1752 = \(x1096).(x1096,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),8.9982f : /) : max) : min) : @) : ID_1751;
ID_1753 = ID_1741 : ID_1752;
ID_1754 = (+ : ID_1753);
ID_1755 = ID_1754 ~ ID_34;
ID_1756 = ID_1651, 9.015497f;
ID_1757 = (ID_1756 : *);
ID_1758 = ID_1757, ID_20;
ID_1759 = (ID_1758 : <);
ID_1760 = _, ID_1759;
ID_1761 = ID_1760 : *;
ID_1762 = \(x1103).(\(x1104).(x1104,x1103 : -)) ~ \(x1105).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1106).(4.4e+02f,(2.0f,((x1106,69.0f : -),12.0f : /) : pow) : *)),9.015497f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1105 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1105 : mem) : *) : +);
ID_1763 = ID_1762 : \(x1107).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1107 : *),(0,(x1107 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1107 : mem : mem) : *) : +);
ID_1764 = ID_1761 : ID_1763;
ID_1765 = ID_89 : ID_1764;
ID_1766 = \(x1102).(x1102,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),9.015497f : /) : max) : min) : @) : ID_1765;
ID_1767 = ID_1741 : ID_1766;
ID_1768 = (+ : ID_1767);
ID_1769 = ID_1768 ~ ID_34;
ID_1770 = 0.7063034f, ID_1645;
ID_1771 = (ID_1770 : *);
ID_1772 = _, ID_1771;
ID_1773 = ID_1772 : +;
ID_1774 = ID_1651, 12.83303f;
ID_1775 = (ID_1774 : *);
ID_1776 = ID_1775, ID_20;
ID_1777 = (ID_1776 : <);
ID_1778 = _, ID_1777;
ID_1779 = ID_1778 : *;
ID_1780 = \(x1109).(\(x1110).(x1110,x1109 : -)) ~ \(x1111).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1112).(4.4e+02f,(2.0f,((x1112,69.0f : -),12.0f : /) : pow) : *)),12.83303f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1111 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1111 : mem) : *) : +);
ID_1781 = ID_1780 : \(x1113).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1113 : *),(0,(x1113 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1113 : mem : mem) : *) : +);
ID_1782 = ID_1779 : ID_1781;
ID_1783 = ID_149 : ID_1782;
ID_1784 = \(x1108).(x1108,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.83303f : /) : max) : min) : @) : ID_1783;
ID_1785 = ID_1773 : ID_1784;
ID_1786 = (+ : ID_1785);
ID_1787 = ID_1786 ~ ID_34;
ID_1788 = ID_1651, 12.807382f;
ID_1789 = (ID_1788 : *);
ID_1790 = ID_1789, ID_20;
ID_1791 = (ID_1790 : <);
ID_1792 = _, ID_1791;
ID_1793 = ID_1792 : *;
ID_1794 = \(x1115).(\(x1116).(x1116,x1115 : -)) ~ \(x1117).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1118).(4.4e+02f,(2.0f,((x1118,69.0f : -),12.0f : /) : pow) : *)),12.807382f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1117 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1117 : mem) : *) : +);
ID_1795 = ID_1794 : \(x1119).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1119 : *),(0,(x1119 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1119 : mem : mem) : *) : +);
ID_1796 = ID_1793 : ID_1795;
ID_1797 = ID_149 : ID_1796;
ID_1798 = \(x1114).(x1114,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.807382f : /) : max) : min) : @) : ID_1797;
ID_1799 = ID_1773 : ID_1798;
ID_1800 = (+ : ID_1799);
ID_1801 = ID_1800 ~ ID_34;
ID_1802 = 5.7063036f, ID_1645;
ID_1803 = (ID_1802 : *);
ID_1804 = _, ID_1803;
ID_1805 = ID_1804 : +;
ID_1806 = ID_1651, 17.280823f;
ID_1807 = (ID_1806 : *);
ID_1808 = ID_1807, ID_20;
ID_1809 = (ID_1808 : <);
ID_1810 = _, ID_1809;
ID_1811 = ID_1810 : *;
ID_1812 = \(x1121).(\(x1122).(x1122,x1121 : -)) ~ \(x1123).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1124).(4.4e+02f,(2.0f,((x1124,69.0f : -),12.0f : /) : pow) : *)),17.280823f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1123 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1123 : mem) : *) : +);
ID_1813 = ID_1812 : \(x1125).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1125 : *),(0,(x1125 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1125 : mem : mem) : *) : +);
ID_1814 = ID_1811 : ID_1813;
ID_1815 = ID_89 : ID_1814;
ID_1816 = \(x1120).(x1120,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),17.280823f : /) : max) : min) : @) : ID_1815;
ID_1817 = ID_1805 : ID_1816;
ID_1818 = (+ : ID_1817);
ID_1819 = ID_1818 ~ ID_34;
ID_1820 = ID_1651, 21.976027f;
ID_1821 = (ID_1820 : *);
ID_1822 = ID_1821, ID_20;
ID_1823 = (ID_1822 : <);
ID_1824 = _, ID_1823;
ID_1825 = ID_1824 : *;
ID_1826 = \(x1127).(\(x1128).(x1128,x1127 : -)) ~ \(x1129).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1130).(4.4e+02f,(2.0f,((x1130,69.0f : -),12.0f : /) : pow) : *)),21.976027f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1129 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1129 : mem) : *) : +);
ID_1827 = ID_1826 : \(x1131).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1131 : *),(0,(x1131 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1131 : mem : mem) : *) : +);
ID_1828 = ID_1825 : ID_1827;
ID_1829 = ID_89 : ID_1828;
ID_1830 = \(x1126).(x1126,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch8", 68.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),21.976027f : /) : max) : min) : @) : ID_1829;
ID_1831 = ID_1805 : ID_1830;
ID_1832 = (+ : ID_1831);
ID_1833 = ID_1832 ~ ID_34;
ID_1834 = ID_1819, ID_1833;
ID_1835 = ID_1801, ID_1834;
ID_1836 = ID_1787, ID_1835;
ID_1837 = ID_1769, ID_1836;
ID_1838 = ID_1755, ID_1837;
ID_1839 = ID_1737, ID_1838;
ID_1840 = ID_1729, ID_1839;
ID_1841 = ID_1711, ID_1840;
ID_1842 = ID_1697, ID_1841;
ID_1843 = ID_1679, ID_1842;
ID_1844 = ID_1665, ID_1843;
ID_1845 = ID_1844 :> _;
ID_1846 = (ID_1645 <: ID_1845);
ID_1847 = button("play9");
ID_1848 = ID_1847 <: ID_2;
ID_1849 = 1.1900357f, ID_1848;
ID_1850 = (ID_1849 : *);
ID_1851 = _, ID_1850;
ID_1852 = ID_1851 : +;
ID_1853 = nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f);
ID_1854 = (ID_1853 : \(x2).(4.4e+02f,(2.0f,((x2,69.0f : -),12.0f : /) : pow) : *));
ID_1855 = ID_1854, 0.99610835f;
ID_1856 = (ID_1855 : *);
ID_1857 = ID_1856, ID_20;
ID_1858 = (ID_1857 : <);
ID_1859 = _, ID_1858;
ID_1860 = ID_1859 : *;
ID_1861 = \(x1133).(\(x1134).(x1134,x1133 : -)) ~ \(x1135).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1136).(4.4e+02f,(2.0f,((x1136,69.0f : -),12.0f : /) : pow) : *)),0.99610835f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1135 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1135 : mem) : *) : +);
ID_1862 = ID_1861 : \(x1137).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1137 : *),(0,(x1137 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1137 : mem : mem) : *) : +);
ID_1863 = ID_1860 : ID_1862;
ID_1864 = ID_9 : ID_1863;
ID_1865 = \(x1132).(x1132,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),0.99610835f : /) : max) : min) : @) : ID_1864;
ID_1866 = ID_1852 : ID_1865;
ID_1867 = (+ : ID_1866);
ID_1868 = ID_1867 ~ ID_34;
ID_1869 = ID_1854, 1.0038917f;
ID_1870 = (ID_1869 : *);
ID_1871 = ID_1870, ID_20;
ID_1872 = (ID_1871 : <);
ID_1873 = _, ID_1872;
ID_1874 = ID_1873 : *;
ID_1875 = \(x1139).(\(x1140).(x1140,x1139 : -)) ~ \(x1141).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1142).(4.4e+02f,(2.0f,((x1142,69.0f : -),12.0f : /) : pow) : *)),1.0038917f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1141 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1141 : mem) : *) : +);
ID_1876 = ID_1875 : \(x1143).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1143 : *),(0,(x1143 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1143 : mem : mem) : *) : +);
ID_1877 = ID_1874 : ID_1876;
ID_1878 = ID_9 : ID_1877;
ID_1879 = \(x1138).(x1138,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),1.0038917f : /) : max) : min) : @) : ID_1878;
ID_1880 = ID_1852 : ID_1879;
ID_1881 = (+ : ID_1880);
ID_1882 = ID_1881 ~ ID_34;
ID_1883 = 1.0914886f, ID_1848;
ID_1884 = (ID_1883 : *);
ID_1885 = _, ID_1884;
ID_1886 = ID_1885 : +;
ID_1887 = ID_1854, 2.979178f;
ID_1888 = (ID_1887 : *);
ID_1889 = ID_1888, ID_20;
ID_1890 = (ID_1889 : <);
ID_1891 = _, ID_1890;
ID_1892 = ID_1891 : *;
ID_1893 = \(x1145).(\(x1146).(x1146,x1145 : -)) ~ \(x1147).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1148).(4.4e+02f,(2.0f,((x1148,69.0f : -),12.0f : /) : pow) : *)),2.979178f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1147 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1147 : mem) : *) : +);
ID_1894 = ID_1893 : \(x1149).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1149 : *),(0,(x1149 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1149 : mem : mem) : *) : +);
ID_1895 = ID_1892 : ID_1894;
ID_1896 = ID_55 : ID_1895;
ID_1897 = \(x1144).(x1144,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.979178f : /) : max) : min) : @) : ID_1896;
ID_1898 = ID_1886 : ID_1897;
ID_1899 = (+ : ID_1898);
ID_1900 = ID_1899 ~ ID_34;
ID_1901 = ID_1854, 2.9932976f;
ID_1902 = (ID_1901 : *);
ID_1903 = ID_1902, ID_20;
ID_1904 = (ID_1903 : <);
ID_1905 = _, ID_1904;
ID_1906 = ID_1905 : *;
ID_1907 = \(x1151).(\(x1152).(x1152,x1151 : -)) ~ \(x1153).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1154).(4.4e+02f,(2.0f,((x1154,69.0f : -),12.0f : /) : pow) : *)),2.9932976f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1153 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1153 : mem) : *) : +);
ID_1908 = ID_1907 : \(x1155).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1155 : *),(0,(x1155 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1155 : mem : mem) : *) : +);
ID_1909 = ID_1906 : ID_1908;
ID_1910 = ID_55 : ID_1909;
ID_1911 = \(x1150).(x1150,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),2.9932976f : /) : max) : min) : @) : ID_1910;
ID_1912 = ID_1886 : ID_1911;
ID_1913 = (+ : ID_1912);
ID_1914 = ID_1913 ~ ID_34;
ID_1915 = 4.2995043f, ID_1848;
ID_1916 = (ID_1915 : *);
ID_1917 = _, ID_1916;
ID_1918 = ID_1917 : +;
ID_1919 = ID_1854, 5.704452f;
ID_1920 = (ID_1919 : *);
ID_1921 = ID_1920, ID_20;
ID_1922 = (ID_1921 : <);
ID_1923 = _, ID_1922;
ID_1924 = ID_1923 : *;
ID_1925 = \(x1157).(\(x1158).(x1158,x1157 : -)) ~ \(x1159).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1160).(4.4e+02f,(2.0f,((x1160,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1159 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1159 : mem) : *) : +);
ID_1926 = ID_1925 : \(x1161).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1161 : *),(0,(x1161 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1161 : mem : mem) : *) : +);
ID_1927 = ID_1924 : ID_1926;
ID_1928 = ID_89 : ID_1927;
ID_1929 = \(x1156).(x1156,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_1928;
ID_1930 = ID_1918 : ID_1929;
ID_1931 = (+ : ID_1930);
ID_1932 = ID_1931 ~ ID_34;
ID_1933 = \(x1163).(\(x1164).(x1164,x1163 : -)) ~ \(x1165).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1166).(4.4e+02f,(2.0f,((x1166,69.0f : -),12.0f : /) : pow) : *)),5.704452f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1165 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1165 : mem) : *) : +);
ID_1934 = ID_1933 : \(x1167).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1167 : *),(0,(x1167 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1167 : mem : mem) : *) : +);
ID_1935 = ID_1924 : ID_1934;
ID_1936 = ID_89 : ID_1935;
ID_1937 = \(x1162).(x1162,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),5.704452f : /) : max) : min) : @) : ID_1936;
ID_1938 = ID_1918 : ID_1937;
ID_1939 = (+ : ID_1938);
ID_1940 = ID_1939 ~ ID_34;
ID_1941 = 4.0063033f, ID_1848;
ID_1942 = (ID_1941 : *);
ID_1943 = _, ID_1942;
ID_1944 = ID_1943 : +;
ID_1945 = ID_1854, 8.9982f;
ID_1946 = (ID_1945 : *);
ID_1947 = ID_1946, ID_20;
ID_1948 = (ID_1947 : <);
ID_1949 = _, ID_1948;
ID_1950 = ID_1949 : *;
ID_1951 = \(x1169).(\(x1170).(x1170,x1169 : -)) ~ \(x1171).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1172).(4.4e+02f,(2.0f,((x1172,69.0f : -),12.0f : /) : pow) : *)),8.9982f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1171 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1171 : mem) : *) : +);
ID_1952 = ID_1951 : \(x1173).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1173 : *),(0,(x1173 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1173 : mem : mem) : *) : +);
ID_1953 = ID_1950 : ID_1952;
ID_1954 = ID_89 : ID_1953;
ID_1955 = \(x1168).(x1168,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),8.9982f : /) : max) : min) : @) : ID_1954;
ID_1956 = ID_1944 : ID_1955;
ID_1957 = (+ : ID_1956);
ID_1958 = ID_1957 ~ ID_34;
ID_1959 = ID_1854, 9.015497f;
ID_1960 = (ID_1959 : *);
ID_1961 = ID_1960, ID_20;
ID_1962 = (ID_1961 : <);
ID_1963 = _, ID_1962;
ID_1964 = ID_1963 : *;
ID_1965 = \(x1175).(\(x1176).(x1176,x1175 : -)) ~ \(x1177).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1178).(4.4e+02f,(2.0f,((x1178,69.0f : -),12.0f : /) : pow) : *)),9.015497f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1177 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1177 : mem) : *) : +);
ID_1966 = ID_1965 : \(x1179).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1179 : *),(0,(x1179 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1179 : mem : mem) : *) : +);
ID_1967 = ID_1964 : ID_1966;
ID_1968 = ID_89 : ID_1967;
ID_1969 = \(x1174).(x1174,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),9.015497f : /) : max) : min) : @) : ID_1968;
ID_1970 = ID_1944 : ID_1969;
ID_1971 = (+ : ID_1970);
ID_1972 = ID_1971 ~ ID_34;
ID_1973 = 0.7063034f, ID_1848;
ID_1974 = (ID_1973 : *);
ID_1975 = _, ID_1974;
ID_1976 = ID_1975 : +;
ID_1977 = ID_1854, 12.83303f;
ID_1978 = (ID_1977 : *);
ID_1979 = ID_1978, ID_20;
ID_1980 = (ID_1979 : <);
ID_1981 = _, ID_1980;
ID_1982 = ID_1981 : *;
ID_1983 = \(x1181).(\(x1182).(x1182,x1181 : -)) ~ \(x1183).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1184).(4.4e+02f,(2.0f,((x1184,69.0f : -),12.0f : /) : pow) : *)),12.83303f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1183 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1183 : mem) : *) : +);
ID_1984 = ID_1983 : \(x1185).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1185 : *),(0,(x1185 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1185 : mem : mem) : *) : +);
ID_1985 = ID_1982 : ID_1984;
ID_1986 = ID_149 : ID_1985;
ID_1987 = \(x1180).(x1180,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.83303f : /) : max) : min) : @) : ID_1986;
ID_1988 = ID_1976 : ID_1987;
ID_1989 = (+ : ID_1988);
ID_1990 = ID_1989 ~ ID_34;
ID_1991 = ID_1854, 12.807382f;
ID_1992 = (ID_1991 : *);
ID_1993 = ID_1992, ID_20;
ID_1994 = (ID_1993 : <);
ID_1995 = _, ID_1994;
ID_1996 = ID_1995 : *;
ID_1997 = \(x1187).(\(x1188).(x1188,x1187 : -)) ~ \(x1189).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1190).(4.4e+02f,(2.0f,((x1190,69.0f : -),12.0f : /) : pow) : *)),12.807382f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1189 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1189 : mem) : *) : +);
ID_1998 = ID_1997 : \(x1191).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1191 : *),(0,(x1191 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1191 : mem : mem) : *) : +);
ID_1999 = ID_1996 : ID_1998;
ID_2000 = ID_149 : ID_1999;
ID_2001 = \(x1186).(x1186,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),12.807382f : /) : max) : min) : @) : ID_2000;
ID_2002 = ID_1976 : ID_2001;
ID_2003 = (+ : ID_2002);
ID_2004 = ID_2003 ~ ID_34;
ID_2005 = 5.7063036f, ID_1848;
ID_2006 = (ID_2005 : *);
ID_2007 = _, ID_2006;
ID_2008 = ID_2007 : +;
ID_2009 = ID_1854, 17.280823f;
ID_2010 = (ID_2009 : *);
ID_2011 = ID_2010, ID_20;
ID_2012 = (ID_2011 : <);
ID_2013 = _, ID_2012;
ID_2014 = ID_2013 : *;
ID_2015 = \(x1193).(\(x1194).(x1194,x1193 : -)) ~ \(x1195).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1196).(4.4e+02f,(2.0f,((x1196,69.0f : -),12.0f : /) : pow) : *)),17.280823f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1195 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1195 : mem) : *) : +);
ID_2016 = ID_2015 : \(x1197).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1197 : *),(0,(x1197 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1197 : mem : mem) : *) : +);
ID_2017 = ID_2014 : ID_2016;
ID_2018 = ID_89 : ID_2017;
ID_2019 = \(x1192).(x1192,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),17.280823f : /) : max) : min) : @) : ID_2018;
ID_2020 = ID_2008 : ID_2019;
ID_2021 = (+ : ID_2020);
ID_2022 = ID_2021 ~ ID_34;
ID_2023 = ID_1854, 21.976027f;
ID_2024 = (ID_2023 : *);
ID_2025 = ID_2024, ID_20;
ID_2026 = (ID_2025 : <);
ID_2027 = _, ID_2026;
ID_2028 = ID_2027 : *;
ID_2029 = \(x1199).(\(x1200).(x1200,x1199 : -)) ~ \(x1201).((((-2,(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),((6.2831855f,((nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x1202).(4.4e+02f,(2.0f,((x1202,69.0f : -),12.0f : /) : pow) : *)),21.976027f : *) : *),(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : cos) : *),x1201 : *),(((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *),(x1201 : mem) : *) : +);
ID_2030 = ID_2029 : \(x1203).((((0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -),x1203 : *),(0,(x1203 : mem) : *) : +),((0,(0.5f,(0.5f,((1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -),(1,(100.53097f,(1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : /) : -) : *) : *) : -) : -),(x1203 : mem : mem) : *) : +);
ID_2031 = ID_2028 : ID_2030;
ID_2032 = ID_89 : ID_2031;
ID_2033 = \(x1198).(x1198,(4096,(0,(((1.92e+05f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),(nentry("pitch9", 69.0f, 6e+01f, 1.6e+02f, 0.01f) : \(x484).(4.4e+02f,(2.0f,((x484,69.0f : -),12.0f : /) : pow) : *)) : /),21.976027f : /) : max) : min) : @) : ID_2032;
ID_2034 = ID_2008 : ID_2033;
ID_2035 = (+ : ID_2034);
ID_2036 = ID_2035 ~ ID_34;
ID_2037 = ID_2022, ID_2036;
ID_2038 = ID_2004, ID_2037;
ID_2039 = ID_1990, ID_2038;
ID_2040 = ID_1972, ID_2039;
ID_2041 = ID_1958, ID_2040;
ID_2042 = ID_1940, ID_2041;
ID_2043 = ID_1932, ID_2042;
ID_2044 = ID_1914, ID_2043;
ID_2045 = ID_1900, ID_2044;
ID_2046 = ID_1882, ID_2045;
ID_2047 = ID_1868, ID_2046;
ID_2048 = ID_2047 :> _;
ID_2049 = (ID_1848 <: ID_2048);
ID_2050 = ID_1846, ID_2049;
ID_2051 = ID_1643, ID_2050;
ID_2052 = ID_1440, ID_2051;
ID_2053 = ID_1237, ID_2052;
ID_2054 = ID_1034, ID_2053;
ID_2055 = ID_831, ID_2054;
ID_2056 = ID_628, ID_2055;
ID_2057 = ID_425, ID_2056;
ID_2058 = ID_222, ID_2057;
ID_2059 = ID_2058 :> _;
process = ID_2059;
