if(NOT BUILD_GAME_LIBRARIES AND NOT BUILD_GAME_QVMS)
    return()
endif()

include(utils/qvm_tools)
include(utils/set_output_dirs)

set(MPCGAME_SOURCES
    ${SOURCE_DIR}/cgame/cg_newdraw.c
    ${SOURCE_DIR}/ui/ui_shared.c
)

set(MPUI_SOURCES
    ${SOURCE_DIR}/ui/ui_main.c
    ${SOURCE_DIR}/ui/ui_atoms.c
    ${SOURCE_DIR}/ui/ui_gameinfo.c
    ${SOURCE_DIR}/ui/ui_players.c
    ${SOURCE_DIR}/ui/ui_shared.c
    ${SOURCE_DIR}/game/bg_misc.c
    ${SOURCE_DIR}/game/bg_lib.c
)

set(MISSIONPACK "missionpack")

set(CGAME_SOURCES_MISSIONPACK ${CGAME_SOURCES} ${MPCGAME_SOURCES} ${GAME_MODULE_SHARED_SOURCES})
set(GAME_SOURCES_MISSIONPACK ${GAME_SOURCES} ${GAME_MODULE_SHARED_SOURCES})
set(UI_SOURCES_MISSIONPACK ${MPUI_SOURCES} ${GAME_MODULE_SHARED_SOURCES})

if(BUILD_GAME_LIBRARIES)
    set(CGAME_MODULE_BINARY_MISSIONPACK ${CGAME_MODULE_BINARY}_${MISSIONPACK})
    set(GAME_MODULE_BINARY_MISSIONPACK ${GAME_MODULE_BINARY}_${MISSIONPACK})
    set(UI_MODULE_BINARY_MISSIONPACK ${UI_MODULE_BINARY}_${MISSIONPACK})

    add_library(                ${CGAME_MODULE_BINARY_MISSIONPACK} SHARED ${CGAME_SOURCES_MISSIONPACK} ${CGAME_BINARY_SOURCES})
    target_compile_definitions( ${CGAME_MODULE_BINARY_MISSIONPACK} PRIVATE CGAME MISSIONPACK)
    target_link_libraries(      ${CGAME_MODULE_BINARY_MISSIONPACK} PRIVATE ${COMMON_LIBRARIES})
    set_target_properties(      ${CGAME_MODULE_BINARY_MISSIONPACK} PROPERTIES OUTPUT_NAME ${CGAME_MODULE_BINARY})
    set_output_dirs(            ${CGAME_MODULE_BINARY_MISSIONPACK} SUBDIRECTORY ${MISSIONPACK})

    add_library(                ${GAME_MODULE_BINARY_MISSIONPACK} SHARED ${GAME_SOURCES_MISSIONPACK} ${GAME_BINARY_SOURCES})
    target_compile_definitions( ${GAME_MODULE_BINARY_MISSIONPACK} PRIVATE QAGAME MISSIONPACK)
    target_link_libraries(      ${GAME_MODULE_BINARY_MISSIONPACK} PRIVATE ${COMMON_LIBRARIES})
    set_target_properties(      ${GAME_MODULE_BINARY_MISSIONPACK} PROPERTIES OUTPUT_NAME ${GAME_MODULE_BINARY})
    set_output_dirs(            ${GAME_MODULE_BINARY_MISSIONPACK} SUBDIRECTORY ${MISSIONPACK})

    add_library(                ${UI_MODULE_BINARY_MISSIONPACK} SHARED ${UI_SOURCES_MISSIONPACK} ${UI_BINARY_SOURCES})
    target_compile_definitions( ${UI_MODULE_BINARY_MISSIONPACK} PRIVATE UI MISSIONPACK)
    target_link_libraries(      ${UI_MODULE_BINARY_MISSIONPACK} PRIVATE ${COMMON_LIBRARIES})
    set_target_properties(      ${UI_MODULE_BINARY_MISSIONPACK} PROPERTIES OUTPUT_NAME ${UI_MODULE_BINARY})
    set_output_dirs(            ${UI_MODULE_BINARY_MISSIONPACK} SUBDIRECTORY ${MISSIONPACK})
endif()

if(BUILD_GAME_QVMS)
    set(CGAME_MODULE_QVM_MISSIONPACK ${CGAME_MODULE}qvm_${MISSIONPACK})
    set(GAME_MODULE_QVM_MISSIONPACK ${GAME_MODULE}qvm_${MISSIONPACK})
    set(UI_MODULE_QVM_MISSIONPACK ${UI_MODULE}qvm_${MISSIONPACK})

    add_qvm(${CGAME_MODULE_QVM_MISSIONPACK}
        DEFINITIONS CGAME MISSIONPACK
        OUTPUT_NAME ${CGAME_MODULE}
        OUTPUT_DIRECTORY ${MISSIONPACK}/vm
        SOURCES ${CGAME_SOURCES_MISSIONPACK} ${CGAME_QVM_SOURCES})

    add_qvm(${GAME_MODULE_QVM_MISSIONPACK}
        DEFINITIONS QAGAME MISSIONPACK
        OUTPUT_NAME ${GAME_MODULE}
        OUTPUT_DIRECTORY ${MISSIONPACK}/vm
        SOURCES ${GAME_SOURCES_MISSIONPACK} ${GAME_QVM_SOURCES})

    add_qvm(${UI_MODULE_QVM_MISSIONPACK}
        DEFINITIONS UI MISSIONPACK
        OUTPUT_NAME ${UI_MODULE}
        OUTPUT_DIRECTORY ${MISSIONPACK}/vm
        SOURCES ${UI_SOURCES_MISSIONPACK} ${UI_QVM_SOURCES})
endif()
