/* $Id: User_object.cpp 369026 2012-07-16 12:24:38Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'general.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/general/User_object.hpp>
#include <objects/general/User_field.hpp>
#include <objects/general/Object_id.hpp>
#include <corelib/ncbiexpt.hpp>
#include <corelib/ncbistr.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CUser_object::~CUser_object(void)
{
}


//
// retrieve a named field.  The named field can recurse, depending
// on a set of user-defined delimiters
//
const CUser_field& CUser_object::GetField(const string& str,
                                          const string& delim) const
{
    return *GetFieldRef(str, delim);
}


CConstRef<CUser_field> CUser_object::GetFieldRef(const string& str,
                                                 const string& delim) const
{
    list<string> toks;
    NStr::Split(str, delim, toks);
    if ( !toks.size() ) {
        return CConstRef<CUser_field>();
    }

    ///
    /// step 1: scan one level deep for a nested object
    /// we scan only with the first token
    ///
    string sub;
    string first;
    {{
        list<string>::iterator iter = toks.begin();
        first = *iter;
        for (++iter;  iter != toks.end();  ++iter) {
            if ( !sub.empty() ) {
                sub += delim;
            }
            sub += *iter;
        }
    }}

    ITERATE(TData, field_iter, GetData()) {
        bool found = false;
        const CUser_field& field = **field_iter;
        if (field.IsSetLabel()  &&  field.GetLabel().IsStr()) {
            const string& this_label = field.GetLabel().GetStr();
            if (this_label == first) {
                found = true;
            }
        }
        if ( !found ) {
            continue;
        }

        if ( !sub.empty() ) {
            CConstRef<CUser_field> field_ref =
                (*field_iter)->GetFieldRef(sub, delim);
            if (field_ref) {
                return field_ref;
            }
        } else {
            return CConstRef<CUser_field>(&field);
        }
    }
    return CConstRef<CUser_field>();
}


bool CUser_object::HasField(const string& str,
                            const string& delim) const
{
    return GetFieldRef(str, delim).GetPointer() ? true : false;
}


//
// retrieve a named field.  The named field can recurse, depending
// on a set of user-defined delimiters
//
CUser_field& CUser_object::SetField(const string& str,
                                    const string& delim,
                                    const string& obj_subtype)
{
    return *SetFieldRef(str, delim, obj_subtype);
}


CRef<CUser_field> CUser_object::SetFieldRef(const string& str,
                                            const string& delim,
                                            const string& /* obj_subtype */)
{
    list<string> toks;
    NStr::Split(str, delim, toks);

    CRef<CUser_field>  field_ref;

    /// pass 1: see if we have a field that starts with this label already
    NON_CONST_ITERATE(TData, field_iter, SetData()) {
        CUser_field& field = **field_iter;
        if (field.GetLabel().IsStr()  &&
            field.GetLabel().GetStr() == toks.front()) {
            field_ref = *field_iter;
            break;
        }
    }

    if ( !field_ref ) {
        field_ref.Reset(new CUser_field());
        field_ref->SetLabel().SetStr(toks.front());
        SetData().push_back(field_ref);
    }

    toks.pop_front();
    if (toks.size()) {
        string s = NStr::Join(toks, delim);
        CRef<CUser_field> f = field_ref->SetFieldRef(s, delim);
        field_ref = f;
    }

    return field_ref;
}


// add a data field to the user object that holds a given value
CUser_object& CUser_object::AddField(const string& label,
                                     const string& value,
                                     EParseField parse)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    switch (parse) {
    case eParse_Number:
        try {
            int i = NStr::StringToInt(value);
            field->SetData().SetInt(i);
            break;
        }
        catch (...) {
        }

        try {
            double d = NStr::StringToDouble(value);
            field->SetData().SetReal(d);
            break;
        }
        catch (...) {
        }
        field->SetData().SetStr(value);
        break;

    default:
    case eParse_String:
        field->SetData().SetStr(value);
        break;
    }

    SetData().push_back(field);
    return *this;
}

CUser_object& CUser_object::AddField(const string& label,
                                     int           value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetData().SetInt(value);

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     double        value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetData().SetReal(value);

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     bool          value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetData().SetBool(value);

    SetData().push_back(field);
    return *this;
}



CUser_object& CUser_object::AddField(const string& label,
                                     CUser_object& object)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetData().SetObject(object);

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     const vector<string>& value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetNum(value.size());
    field->SetData().SetStrs() = value;

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     const vector<int>&    value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetNum(value.size());
    field->SetData().SetInts() = value;

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     const vector<double>& value)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetNum(value.size());
    field->SetData().SetReals() = value;

    SetData().push_back(field);
    return *this;
}


CUser_object&
CUser_object::AddField(const string& label,
                       const vector< CRef<CUser_object> >& objects)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetNum(objects.size());
    field->SetData().SetObjects() = objects;

    SetData().push_back(field);
    return *this;
}


CUser_object& CUser_object::AddField(const string& label,
                                     const vector<CRef<CUser_field> >& objects)
{
    CRef<CUser_field> field(new CUser_field());
    field->SetLabel().SetStr(label);
    field->SetNum(objects.size());
    field->SetData().SetFields() = objects;

    SetData().push_back(field);
    return *this;
}



// static consts here allow us to use reference counting
static const char* s_ncbi("NCBI");
static const char* s_expres("experimental_results");
static const char* s_exp("experiment");
static const char* s_sage("SAGE");
static const char* s_tag("tag");
static const char* s_count("count");


// accessors: classify a given user object
CUser_object::ECategory CUser_object::GetCategory(void) const
{
    if (!IsSetClass()  ||
        GetClass() != s_ncbi) {
        // we fail to recognize non-NCBI classes of user-objects
        return eCategory_Unknown;
    }

    //
    // experimental results
    //
    if (GetType().IsStr()  &&
        NStr::CompareNocase(GetType().GetStr(), s_expres) == 0  &&
        GetData().size() == 1) {

        ITERATE (CUser_object::TData, iter, GetData()) {
            const CUser_field& field       = **iter;
            const CUser_field::TData& data = field.GetData();
            if (data.Which() != CUser_field::TData::e_Object  ||
                !field.IsSetLabel()  ||
                !field.GetLabel().IsStr()  ||
                NStr::CompareNocase(field.GetLabel().GetStr(),
                                    s_exp) != 0) {
                // poorly formed experiment spec
                return eCategory_Unknown;
            }
        }

        return eCategory_Experiment;
    }

    //
    // unrecognized - catch-all
    //
    return eCategory_Unknown;
}


// sub-category accessors:
CUser_object::EExperiment CUser_object::GetExperimentType(void) const
{
    // check to see if we have an experiment
    if ( GetCategory() != eCategory_Experiment) {
        return eExperiment_Unknown;
    }

    // we do - so we have one nested user object that contains the
    // specification of the experimental data
    const CUser_field& field = *GetData().front();
    const CUser_object& obj = field.GetData().GetObject();
    if (obj.GetType().IsStr()  &&
        NStr::CompareNocase(obj.GetType().GetStr(), s_sage) == 0) {
        return eExperiment_Sage;
    }

    //
    // catch-all
    //
    return eExperiment_Unknown;
}


// sub-category accessors:
const CUser_object& CUser_object::GetExperiment(void) const
{
    switch (GetExperimentType()) {
    case eExperiment_Sage:
        // we have one nested user object that contains the
        // specification of the experimental data
        return GetData().front()->GetData().GetObject();

    case eExperiment_Unknown:
    default:
        return *this;
    }
}


//
// format the type specification fo a given user object
//
static string s_GetUserObjectType(const CUser_object& obj)
{
    switch (obj.GetCategory()) {
    case CUser_object::eCategory_Experiment:
        switch (obj.GetExperimentType()) {
        case CUser_object::eExperiment_Sage:
            return "SAGE";

        case CUser_object::eExperiment_Unknown:
        default:
            return "Experiment";
        }
        break;

    case CUser_object::eCategory_Unknown:
    default:
        break;
    }

    return "User";
}


static string s_GetUserObjectContent(const CUser_object& obj)
{
    switch (obj.GetCategory()) {
    case CUser_object::eCategory_Experiment:
        switch (obj.GetExperimentType()) {
        case CUser_object::eExperiment_Sage:
            {{
                string label;
                const CUser_object& nested_obj =
                    obj.GetData().front()->GetData().GetObject();

                // grab the tag and count fields
                const CUser_field* tag = NULL;
                const CUser_field* count = NULL;
                ITERATE (CUser_object::TData, iter, nested_obj.GetData()) {
                    const CUser_field& field = **iter;
                    if (!field.GetLabel().IsStr()) {
                        continue;
                    }

                    const string& lbl = field.GetLabel().GetStr();
                    if (NStr::CompareNocase(lbl, s_tag) == 0) {
                        tag = &field;
                    } else if (NStr::CompareNocase(lbl, s_count) == 0) {
                        count = &field;
                    }
                }

                if (tag  &&  tag->GetData().IsStr()) {
                    if ( !label.empty() ) {
                        label += " ";
                    }
                    label += string(s_tag) + "=" + tag->GetData().GetStr();
                }

                if (count  &&  count->GetData().IsInt()) {
                    if ( !label.empty() ) {
                        label += " ";
                    }
                    label += string(s_count) + "=" +
                        NStr::IntToString(count->GetData().GetInt());
                }

                return label;
            }}

        case CUser_object::eExperiment_Unknown:
        default:
            break;
        }
        return "[experiment]";

    case CUser_object::eCategory_Unknown:
    default:
        break;
    }
    return "[User]";
}


//
// append a formatted string to a label describing this object
//
void CUser_object::GetLabel(string* label, ELabelContent mode) const
{
    // Check the label is not null
    if (!label) {
        return;
    }

    switch (mode) {
    case eType:
        *label += s_GetUserObjectType(*this);
        break;
    case eContent:
        *label += s_GetUserObjectContent(*this);
        break;
    case eBoth:
        *label += s_GetUserObjectType(*this) + ": " +
            s_GetUserObjectContent(*this);
        break;
    }
}


CUser_object& CUser_object::SetCategory(ECategory category)
{
    Reset();
    SetClass(s_ncbi);
    switch (category) {
    case eCategory_Experiment:
        SetType().SetStr(s_expres);
        {{
            CRef<CUser_object> subobj(new CUser_object());
            AddField(s_exp, *subobj);
            SetClass(s_ncbi);
            return *subobj;
        }}

    case eCategory_Unknown:
    default:
        break;
    }

    return *this;
}


CUser_object& CUser_object::SetExperiment(EExperiment category)
{
    Reset();
    SetClass(s_ncbi);
    switch (category) {
    case eExperiment_Sage:
        SetType().SetStr(s_sage);
        break;

    case eExperiment_Unknown:
    default:
        break;
    }

    return *this;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1893, CRC32: f7a70d1d */
