# Cryptographic functions

## GENERAL

These section contains all NASL function, which are related to cryptographic.

## TABLE OF CONTENT

- **[aes128_cbc_encrypt](aes128_cbc_encrypt.md)** - encrypts given data with AES 128 CBC mode.
- **[aes128_ccm_decrypt_auth](aes128_ccm_decrypt_auth.md)** - decrypts given data including a authentication token with AES 128 CCM mode.
- **[aes128_ccm_decrypt](aes128_ccm_decrypt.md)** - decrypts given encrypted data with AES 128 CCM mode.
- **[aes128_ccm_encrypt_auth](aes128_ccm_encrypt_auth.md)** - encrypts given data including a authentication token with AES 128 CCM mode.
- **[aes128_ccm_encrypt](aes128_ccm_encrypt.md)** - encrypts given data with AES 128 CCM mode.
- **[aes128_ctr_encrypt](aes128_ctr_encrypt.md)** - encrypts given data with AES 128 CTR mode.
- **[aes128_gcm_decrypt_auth](aes128_gcm_decrypt_auth.md)** - decrypts given data including a authentication token with AES 128 GCM mode.
- **[aes128_gcm_decrypt](aes128_gcm_decrypt.md)** - decrypts given encrypted data with AES 128 GCM mode.
- **[aes128_gcm_encrypt_auth](aes128_gcm_encrypt_auth.md)** - encrypts given data including a authentication token with AES 128 GCM mode.
- **[aes128_gcm_encrypt](aes128_gcm_encrypt.md)** - encrypts given data with AES 128 GCM mode.
- **[aes256_cbc_encrypt](aes256_cbc_encrypt.md)** - encrypts given data with AES 256 CBC mode.
- **[aes256_ccm_decrypt_auth](aes256_ccm_decrypt_auth.md)** - decrypts given data including a authentication token with AES 256 CCM mode.
- **[aes256_ccm_decrypt](aes256_ccm_decrypt.md)** - decrypts given encrypted data with AES 256 CCM mode.
- **[aes256_ccm_encrypt_auth](aes256_ccm_encrypt_auth.md)** - encrypts given data including a authentication token with AES 256 CCM mode.
- **[aes256_ccm_encrypt](aes256_ccm_encrypt.md)** - encrypts given data with AES 256 CCM mode.
- **[aes256_ctr_encrypt](aes256_ctr_encrypt.md)** - encrypts given data with AES 256 CTR mode.
- **[aes256_gcm_decrypt_auth](aes256_gcm_decrypt_auth.md)** - decrypts given data including a authentication token with AES 256 GCM mode.
- **[aes256_gcm_decrypt](aes256_gcm_decrypt.md)** - decrypts given encrypted data with AES 256 GCM mode.
- **[aes256_gcm_encrypt_auth](aes256_gcm_encrypt_auth.md)** - encrypts given data including a authentication token with AES 256 GCM mode.
- **[aes256_gcm_encrypt](aes256_gcm_encrypt.md)** - encrypts given data with AES 256 GCM mode.
- **[aes_mac_cbc](aes_mac_cbc.md)** - takes two named arguments key, data
- **[aes_mac_gcm](aes_mac_gcm.md)** - takes two named arguments key, data
- **[bf_cbc_decrypt](bf_cbc_decrypt.md)** - decrypts given data with blowfish CBC mode.
- **[bf_cbc_encrypt](bf_cbc_encrypt.md)** - encrypts given data with blowfish CBC mode.
- **[bn_cmp](bn_cmp.md)** - takes two named arguments key1, key2. Returns 0 when they're equal, -1 when key1 > key2, +1 when key2 > key1
- **[bn_random](bn_random.md)** - takes one named arguments need to returns a message passing interface with the given amount of bits.
- **[close_stream_cipher](close_stream_cipher.md)** - closes a stream cipher.
- **[des_ede_cbc_encrypt](des_ede_cbc_encrypt.md)** - encrypts given data with DES EDE CBC mode.
- **[DES](DES.md)** - takes a unnamed paramaeter and return DES hash.
- **[dh_compute_key](dh_compute_key.md)** - computes the shared secret with the given shared parameter p and g, the servers public key and the clients private and public key.
- **[dh_generate_key](dh_generate_key.md)** - takes three named arguments p, g and priv to generate the public key.
- **[dsa_do_sign](dsa_do_sign.md)** - computes DSA signature.
- **[dsa_do_verify](dsa_do_verify.md)** - verifies that the DSA signature matches the hash based on the public DSA key. Returns 1 if the signature is valid otherwise 0.
- **[get_signature](get_signature.md)** - takes four named arguments key, buf, buflen, seq_number
- **[get_smb2_signature](get_smb2_signature.md)** - takes two named arguments key, buf
- **[HMAC_MD2](HMAC_MD2.md)** - takes named paramaeter data and key to return HMAC MD2 string.
- **[HMAC_MD5](HMAC_MD5.md)** - takes named paramaeter data and key to return HMAC MD5 string.
- **[HMAC_RIPEMD160](HMAC_RIPEMD160.md)** - takes named paramaeter data and key to return HMAC RIPEMD160 string.
- **[HMAC_SHA1](HMAC_SHA1.md)** - takes named paramaeter data and key to return HMAC SHA1 string.
- **[HMAC_SHA256](HMAC_SHA256.md)** - takes named paramaeter data and key to return HMAC SHA256 string.
- **[HMAC_SHA384](HMAC_SHA384.md)** - takes named paramaeter data and key to return HMAC SHA384 string.
- **[HMAC_SHA512](HMAC_SHA512.md)** - takes named paramaeter data and key to return HMAC SHA512 string.
- **[insert_hexzeros](insert_hexzeros.md)** - appends a empty byte to each character in a string
- **[key_exchange](key_exchange.md)** - takes three named arguments cryptkey, session_key, nt_hash
- **[lm_owf_gen](lm_owf_gen.md)** - takes a unnamed parameter and returns LanMan one way hash.
- **[MD2](MD2.md)** - takes a unnamed paramaeter and return MD2 hash.
- **[MD4](MD4.md)** - takes a unnamed paramaeter and return MD4 hash.
- **[MD5](MD5.md)** - takes a unnamed paramaeter and return MD5 hash.
- **[ntlm2_response](ntlm2_response.md)** - takes three named arguments cryptkey, password, nt_hash
- **[ntlm_response](ntlm_response.md)** - takes four named arguments cryptkey, password, nt_hash, neg_flags
- **[NTLMv1_HASH](NTLMv1_HASH.md)** - takes two named arguments cryptkey, pass_hash
- **[NTLMv2_HASH](NTLMv2_HASH.md)** - takes two named arguments cryptkey, pass_hash
- **[ntlmv2_response](ntlmv2_response.md)** - takes six named arguments cryptkey, user, domain, ntlmv2_hash, address_list, address_list_len to generate a ntlmv2 response.
- **[nt_owf_gen](nt_owf_gen.md)** - takes a unnamed paramaeter and returns NT one way hash.
- **[ntv2_owf_gen](ntv2_owf_gen.md)** - takes fiven named arguments owf, login, domain, length, insert_hexzeros to generate the NTLMv2 of a users's password.
- **[open_rc4_cipher](open_rc4_cipher.md)** - opens an rc4 encryption handler for data stream encryptions.
- **[pem_to_dsa](pem_to_dsa.md)** - reads the private key in pem format to return the `x` parameter of the DSA key.
- **[pem_to_rsa](pem_to_rsa.md)** - reads the private key in pem format to return the `d` parameter of the RSA key.
- **[prf_sha256](prf_sha256.md)** - takes four named arguments secret, seed, label, outlen
- **[prf_sha384](prf_sha384.md)** - takes four named arguments secret, seed, label, outlen
- **[rc4_encrypt](rc4_encrypt.md)** - encrypts given data with rc4.
- **[RIPEMD160](RIPEMD160.md)** - takes a unnamed paramaeter and return RIPEMD160 hash
- **[rsa_private_decrypt](rsa_private_decrypt.md)** - decrypts provided data with the public RSA key given by e, n and d. Returns the decrypted data.
- **[rsa_public_decrypt](rsa_public_decrypt.md)** - decrypts provided data with the public RSA key given by e and d. Returns the decrypted data.
- **[rsa_public_encrypt](rsa_public_encrypt.md)** - encrypts provided data with the public RSA key given by e and n. Returns the encrypted data.
- **[rsa_sign](rsa_sign.md)** - signs data with the given private RSA key.
- **[SHA1](SHA1.md)** - takes a unnamed paramaeter and return SHA1 hash
- **[SHA256](SHA256.md)** - takes a unnamed paramaeter and return SHA256 hash
- **[SHA512](SHA512.md)** - takes a unnamed paramaeter and return SHA512 hash
- **[smb3kdf](smb3kdf.md)** - is a key derivation function for SMB3
- **[smb_cmac_aes_signature](smb_cmac_aes_signature.md)** - takes two named arguments key, buf
- **[smb_gmac_aes_signature](smb_gmac_aes_signature.md)** - takes two named arguments key, buf, iv
- **[tls1_prf](tls1_prf.md)** - takes four named arguments secret, seed, label, outlen
