/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.components;

import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.components.Markers;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;

public class TokenMarker
implements SyntaxComponent,
CaretListener {
    public static final String DEFAULT_TOKENTYPES = "IDENTIFIER, TYPE, TYPE2, TYPE3";
    public static final String PROPERTY_COLOR = "TokenMarker.Color";
    public static final String PROPERTY_TOKENTYPES = "TokenMarker.TokenTypes";
    private static final int DEFAULT_COLOR = 0xFFEE66;
    private JEditorPane pane;
    private Set<TokenType> tokenTypes = new HashSet<TokenType>();
    private Markers.SimpleMarker marker;
    private static final Logger LOG = Logger.getLogger(TokenMarker.class.getName());

    public void caretUpdate(CaretEvent e) {
        int pos = e.getDot();
        SyntaxDocument doc = ActionUtils.getSyntaxDocument(this.pane);
        Token token = doc.getTokenAt(pos);
        this.removeMarkers();
        if (token != null && this.tokenTypes.contains((Object)token.type)) {
            this.addMarkers(token);
        }
    }

    public void removeMarkers() {
        Markers.removeMarkers(this.pane, this.marker);
    }

    void addMarkers(Token tok) {
        SyntaxDocument sDoc = (SyntaxDocument)this.pane.getDocument();
        sDoc.readLock();
        String text = tok.getText(sDoc);
        Iterator<Token> it = sDoc.getTokens(0, sDoc.getLength());
        while (it.hasNext()) {
            Token nextToken = it.next();
            if (nextToken.length != tok.length || !text.equals(nextToken.getText(sDoc))) continue;
            Markers.markToken(this.pane, nextToken, this.marker);
        }
        sDoc.readUnlock();
    }

    public void config(Configuration config, String prefix) {
        Color markerColor = new Color(config.getPrefixInteger(prefix, PROPERTY_COLOR, 0xFFEE66));
        this.marker = new Markers.SimpleMarker(markerColor);
        String types = config.getPrefixProperty(prefix, PROPERTY_TOKENTYPES, DEFAULT_TOKENTYPES);
        for (String type : types.split("\\s*,\\s*")) {
            try {
                TokenType tt = TokenType.valueOf(type);
                this.tokenTypes.add(tt);
            }
            catch (IllegalArgumentException e) {
                LOG.warning("Error in setting up TokenMarker for " + prefix + " - Invalid TokenType: " + type);
            }
        }
    }

    public void install(JEditorPane editor) {
        this.pane = editor;
        this.pane.addCaretListener(this);
    }

    public void deinstall(JEditorPane editor) {
        this.removeMarkers();
        this.pane.removeCaretListener(this);
    }
}

